#include "madv.t"
#include "mystery.t"

init: function;

init: function
{
    version.sdesc;
  "\tWelcome to the sample mystery.  As the curtain opens, we find Gloria
   Rodriguez at her office, where she works for Sure-Luck Homes, a real
   estate agency in the Pan Fernando valley.  Currently, you are waiting
   for a wealthy client who is due to turn up around 4:00pm.\b";
   "[There's nothing to do in the office, so type 'wait until 4:00'.]\b";
    setdaemon( turncount, nil );   // start the turn counter daemon
    Me.location := startroom;      // move player to initial location
    startroom.lookAround( true );  // show player where he is
    startroom.isseen := true;      // note that we've seen the room
    scoreStatus(0);
}

version: object
        sdesc = "\b\(Example Mystery II\)\n
                by G.\ Kevin Wilson\b"
;

startroom: room
  sdesc = "Your Office"
  ldesc = "Here is where you sit, day in and day out, a lowly secretary for
    the horrid Mr.\ Catsmasher.  Nothing would please you more than to see
    that old geezer get his. "
;

phone: fixeditem
  sdesc = "telephone"
  noun = 'telephone' 'phone'
  ldesc = "This is the telephone.  In a real adventure, you would be able to
    do something with it, but since this is just a demo, you can't.  Instead,
    why don't you 'wait until 4:00'? "
  location = startroom
;

modify global
   hour = 12
   minute = 00
   day = 'Thursday'
   isAM = nil
   maxscore = 50
;

replace timeevents: function
{
        if ((global.hour = 3) and (global.minute = 0)) {
        "\bSuddenly, the phone starts to ring. Do you answer it? <Y/N>";
        if(yorn()) {
                "\tTired of sitting around, you answer the phone.\n
                \t\"Hello?  Mrs.\ Rodriguez?  Yes, my name is Officer
                O'Riley, and I have the sad duty of informing you
                that your employer, Mr.\ Catsmasher, was found
                murdered twenty minutes ago at the Lookout Tower just
                outside of town.  We'd like you to come down and
                confirm the body's identity, as well as answering a
                few questions.\"\n
                \t\"Oh my God.  Y-y-y-es, I'll be down as soon as I can.\"\n
                You hang up and rush outside to your car, then drive
                down to Lookout Tower.\n";
                Me.location := Towerbottom;
                intsay(nil);
                return(nil);
        }
        "\tYou decide to ignore the call.  An hour later, the police
        pull up and arrest you for the murder of Mr.\ Catsmasher.
        It seems they tried to get hold of you, but couldn't, and
        Ms.\ Loreli, the other office secretary, stumbled upon
        evidence that implicated you.  How convenient.  You get
        the chair. ";
        die();
        abort;
        }
}


Towerbottom: room
  sdesc = "The Base of the Tower"
  ldesc = "You look up at the immenseness of Lookout Tower.  Wow, how immense.
    Stairs lead up into it, or you can go west, towards the tool shed. "
  west = toolShed
  up = Tower1
;

Reporters: item
  verDoTake(actor) = { "Leave them alone. "; }
  sdesc = "group of reporters"
  noun = 'reporters' 'group'
  adjective = 'group of'
  ldesc = "This is a group of reporters, they are huddled around the sheet
    covered body of Mr.\ Catsmasher.  They have no importance to the game."
  location = Towerbottom
;

catsmasher: mdeadActor
  autoTake = nil
  name = "Mr.\ Catsmasher"
  ldesc = "Wow, what an exotic way to die.  It looks as though he was
    mauled by an irate chihuahua, smeared with lipstick, dressed as a
    clown, and pushed off the Lookout Tower. "
  location = Towerbottom
  noun = 'catsmasher' 'mr. catsmasher' 'body' 'corpse'
  
;

chico: hiddenItem, item2
  sdesc = "chihuahua"
  autoTake = nil
  ldesc = 
  {
        "This is Ms.\ Loreli's chihuahua, Chico.  He shivers in the manner
        of small dogs everywhere. ";
        useasclue := true;
  }
  taken = nil
  doTake(actor) =
  {
        if (not taken) {
        "You gently pry Chico off the body.  He barks at you. ";
        incscore(10);
        taken := true;
        }
        pass doTake;
  }
  noun = 'dog' 'chico' 'chihuahua'
  searchLoc = catsmasher
  useasclue = nil
;

toolShed: room
  sdesc = "Tool Shed"
  ldesc = "This is the tool shed.  Light dimly filters in through the rickity
    roof. "
  east = Towerbottom
;

clownnose: item2
  sdesc = "clown nose"
  ldesc = "It's a clown nose! "
  noun = 'nose'
  adjective = 'clown'
  location = toolShed
  prints = [loreli]
;

Tower1: room
  sdesc = "Middle of Tower"
  ldesc = "You are climbing the endless stairs that make up the Lookout Tower. "
  up = TowerTop
  down = Towerbottom
;

lipstick: item2
  sdesc = "lipstick"
  noun = 'lipstick'
  adjective = 'red'
  ldesc = "Hunh, the police must've overlooked it.  How incompetent. "
  location = Tower1
  prints = [loreli]
;

TowerTop: room
  sdesc = "Top of Tower"
  ldesc = "This is the top of the tower, where Catsmasher was pushed off. "
  down = Tower1
;

oriley: mActor
  name = "Officer O'Riley"
  ldesc = "Officer O'Riley is a fat Irish cop with a donut in one hand, and
    a cup of coffee in the other. "
  noun = 'officer' 'o\'riley'
  adjective = 'officer'
  location = TowerTop
;

loreli: fActor
  name = "Ms.\ Loreli"
  ldesc = "Ms.\ Loreli is a gorgeous blonde, a regular femme fatale. "
  noun = 'loreli'
  location = TowerTop
  murderlist = [chico lipstick clownnose]
  murderConf = 
  {
     incscore(10);
     "\b\"I didn't do it,\" she screams as they drag her off to jail.  Officer
      O'Riley gives you a commendation for your assistance...\b
      \tLater, you are cruising to the airport, with Chico sitting next to
      you, a ticket to Rio in your purse, and $500,000 in embezzled cash in
      your money belt.  The fools.  You really DID kill Catsmasher when he
      found out about the money.  Chuckling, you peel the tiny plastic gloves
      off your fingers that enabled you to fake Ms.\ Loreli's fingerprnts, and
      smile as you think of the sundrenched days ahead!\b";
     runEnding(self,canArrest);
  }
  doPrint( actor ) =
  {
      "She looks startled at your suggestion to Officer O'Riley, but goes along
       with it. ";
      global.printlist += self;
  }
  ioShowTo(actor, dobj) = { dobj.doShowTo(actor, self); }
;

item2: item
        shown = nil
        prints = []
        useasclue = true
        verDoPrint( actor ) = { return true; }
        doPrint( actor ) =
        {
                if ( length(self.prints) = 0 )
                {
                        "You give it to a passing officer who dusts it for
                         prints.  He finds none. ";
                }
                else if ( intersect(self.prints,global.printlist) = [] )
                {
                        "You give it to a passing officer who dusts it for
                         prints.  He finds some, but says that they aren't
                         on record. ";
                }
                else
                {
                        local l := intersect(self.prints,global.printlist);
                        local ind;
                        local len := length(l);
                        local len2 := length(self.prints);
                        "On "; self.thedesc;
                        ",\ the officer you handed it to find prints from:\n";
                        for(ind := 1; ind <= len; ind++)
                        {
                                "\t";
                                if (isclass(l[ind],myActor))
                                {
                                        l[ind].name;
                                }
                                else l[ind].sdesc;
                                "\n";
                        }
                        if (len2 > len)
                        {
                                "\bUnfortunately, some prints aren't
                                on record. ";
                        }
                }
        }
        verDoCheckFor( actor, dobj ) = { return true; }
        doCheckFor( actor, dobj ) =
        {
                "%You% can't check "; self.thedesc; " for "; dobj.sdesc;
        }
        verDoShowTo( actor, io ) = { return true; }
        doShowTo( actor, io ) =
        {
                if (isclass(io,myActor))
                {
                   if (io = loreli) {
           if (self.shown) {
             "You already showed that to her. ";
             return(nil);
           }
           "Ms.\ Loreli stares at it in astonishment.  \"But, but...\"\n";
                    incscore(10);
                     self.shown := true;
                        io.murderlist -= self;
                        io.bmaillist -= self;
                        io.adulterylist -= self;
                        io.fraudlist -= self;
                        io.theftlist -= self;
                                    }
                }
                else pass doShowTo;
        }
;

