#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// DEBUG STUFF
// NOTES
// GUNS AND SHOOTING: pedestals and plaques
// GUNS AND SHOOTING: ArtifactGun and Artifact classes, etc.
// GUNS AND SHOOTING: Token fixtures
// GUNS AND SHOOTING: Font style tags
// GUNS AND SHOOTING: Shooting verbs (includes Gun/Weapon inheritance tree)
// GUNS AND SHOOTING: Classes: Weapon, MeleeWeapon, Gun
// GUNS AND SHOOTING: Scott Adams functions
// GUNS AND SHOOTING: verbs: Set, ToStun, ToDestroy (for Scott Adams phaser)
// GUNS AND SHOOTING: verbs: PutOnWhat (for Scott Adams phaser)
// GUNS AND SHOOTING: Actor modifications: phasers and stunning
// GUNS AND SHOOTING: Scott Adams parsing (and other strange gun parsing)
// GUNS AND SHOOTING: Verb changes associated with Strange Thing: Cut, Give, Show, Attach, Ask, Tell, [Plug]
// GUNS AND SHOOTING: StrangeThing class
// GUNS AND SHOOTING: MessageResult modifications
// GUNS AND SHOOTING: Guns/Artifacts
// GUNS AND SHOOTING: Guns/Artifacts: shotgun
// GUNS AND SHOOTING: Guns/Artifacts: phaser
// GUNS AND SHOOTING: Guns/Artifacts: explosive
// GUNS AND SHOOTING: Guns/Artifacts: handgun
// GUNS AND SHOOTING: Guns/Artifacts: laser
// GUNS AND SHOOTING: Guns/Artifacts: dispenser
// GUNS AND SHOOTING: Guns/Artifacts: crystal
// GUNS AND SHOOTING: Guns/Artifacts: particleGun classes and objects
// GUNS AND SHOOTING: Guns/Artifacts: xenite
// GUNS AND SHOOTING: Guns/Artifacts: ary ung classes and objects
// GUNS AND SHOOTING: Guns/Artifacts: pulseGun
// GUNS AND SHOOTING: Guns/Artifacts: electricPistol
// GUNS AND SHOOTING: Guns/Artifacts: silencedPistol
// GUNS AND SHOOTING: Guns/Artifacts: disrupter
// GUNS AND SHOOTING: Guns/Artifacts: missileLauncher
// GUNS AND SHOOTING: Guns/Artifacts: tRemovingGun classes and objects
// GUNS AND SHOOTING: Additional weapon modifications

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

//myGun: GunThing 'gun' 'gun' @dreamRoom ammo=5 ammoDecrement=1;

//tRemover: Thing;
//remover: Thing;
//pbGun2: Thing 'pb gun' 'pb gun';

DefineIAction(Paricle)
  execAction() {
    if (silverPed.contents) {
      for (local a = silverPed.contents.length; a >= 1; a--) {
        if (!silverPed.contents[a].ofKind(Plaque))
          silverPed.contents[a].moveInto(nil);
      }
    }
    paricleGun.moveInto(silverPed);
    "Okay, paricle stuff done now. ";
  }
;

VerbRule(Paricle)
  'paricle'
  : ParicleAction
  verbPhrase = 'paricle/paricling'
;

DefineIAction(Gest) // Gun test
  execAction() {
    local loopMax = 6;
    local gunList = [];
    local prevLoc = nil;
    for (local cur = firstObj(RangeWeapon); cur != nil; 
         cur = nextObj(cur, RangeWeapon)) {
      gunList += cur;
    }
    for (local a = 1; a <= gunList.length; a++) {
      "&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;<p>";
      for (local b = 1; b <= loopMax; b++) {
        prevLoc = gunList[a].location;
        if (!gunList[a].location || !gunList[a].location.ofKind(Alien))
          gunList[a].baseMoveInto(youngGuard);
        // output
        doChoice(gunList[a], b);
        "<.p>";
        // after output
        if (gunList[a].location != prevLoc)
          gunList[a].baseMoveInto(prevLoc);
      }
    }
  }
  doChoice(obj, num) {
    switch(num) {
      case 1:
        "<b><<obj.name>>/hit:</b><p>";
        obj.suddenRangeAttackParagraph('suddenly ', nil);
        obj.deathParagraph(true, nil);
        if (obj.canKillNow) "<p><b>*** You have died ***</b> ";
        break;
      case 2:
        "<b><<obj.name>>/wide miss:</b><p>";
        obj.suddenRangeAttackParagraph('', nil);
        obj.reportNpcMiss(wideMiss, nil);
        "\^<<endgameDaemon.sayNpcsCurse([obj.location])>>. ";
        break;
      case 3:
        "<b><<obj.name>>/medium miss:</b><p>";
        obj.suddenRangeAttackParagraph('', nil);
        obj.reportNpcMiss(mediumMiss, nil);
        "\^<<endgameDaemon.sayNpcsCurse([obj.location])>>, 
          while you take a deep breath. That was close. ";
        break;
      case 4:
        "<b><<obj.name>>/narrow miss:</b><p>";
        obj.suddenRangeAttackParagraph('', nil);
        obj.reportNpcMiss(narrowMiss, nil);
        "\^<<endgameDaemon.sayNpcsCurse([obj.location])>>, 
          while you take a deep breath. That was far too close. ";
        break;
      case 5:
        "<b><<obj.name>>/no ammo:</b><p>";
        obj.suddenRangeAttackParagraph('', nil);
        obj.reportNoNpcAmmo;
        "\^<<endgameDaemon.sayNpcsCurse([obj.location])>>. ";
        "Disgustedly, he tosses <<obj.theName>> down to the floor. ";
        
        "<p>";
        obj.location.standardWeapon.suddenRangeAttackParagraph('undeterred, ', nil);
        obj.location.standardWeapon.deathParagraph(true, nil);
        if (obj.location.standardWeapon.canKillNow) "<p><b>*** You have died ***</b> ";
        break;
      case 6:
        "<b><<obj.name>>/gerund phrase:</b><p>";
        "Two guys attack, but <<obj.location.theName>> is faster, ";
        obj.assaultingYouDesc;
        obj.deathParagraph(true, nil);
        if (obj.canKillNow) "<p><b>*** You have died ***</b> ";
        
        if (!obj.canKillSometimes) {
          "Disgustedly, he tosses <<obj.theName>> down to the floor. ";
          "<p>";
          obj.location.standardWeapon.suddenRangeAttackParagraph('undeterred, ', nil);
          obj.location.standardWeapon.deathParagraph(true, nil);
          if (obj.location.standardWeapon.canKillNow) "<p><b>*** You have died ***</b> ";
        }
        break;
      case 7:
        
        break;
      case 8:
        
        break;
      case 9:
        
        break;
      case 10:
        
        break;
      case 11:
        
        break;
      case 12:
        
        break;
      case 13:
        
        break;
      case 14:
        
        break;
      case 15:
        
        break;
      case 16:
        
        break;
      case 17:
        
        break;
      case 18:
        
        break;
      case 19:
        
        break;
      case 20:
        
        break;
      case 21:
        
        break;
      case 22:
        
        break;
      case 23:
        
        break;
      case 24:
        
        break;
      case 25:
        
        break;
      case 26:
        
        break;
      case 27:
        
        break;
      case 28:
        
        break;
      case 29:
        
        break;
      case 30:
        
        break;
      case 31:
        
        break;
      case 32:
        
        break;
      case 33:
        
        break;
      case 34:
        
        break;
      case 35:
        
        break;
      case 36:
        
        break;
      case 37:
        
        break;
      case 38:
        
        break;
      case 39:
        
        break;
      case 40:
        
        break;
      case 41:
        
        break;
      case 42:
        
        break;
      case 43:
        
        break;
      case 44:
        
        break;
      case 45:
        
        break;
      case 46:
        
        break;
      case 47:
        
        break;
      case 48:
        
        break;
      case 49:
        
        break;
      case 50:
        
        break;
      default:
        
        break;
    }
  }
;
VerbRule(Gest)
  'gest'
  : GestAction
  verbPhrase = 'test/testing guns'
;

//mcthing: Thing 'mcthing' 'McThing' @dreamRoom;
//mcsurface: Surface 'mcsurface' 'McSurface' @dreamRoom;
//mcstrange: Artifact 'mcstrange' 'McStrange' @dreamRoom
//    dobjFor(PutIn)
//    {
//        preCond = [objHeld]
//        verify()
//        {
//            /* 
//             *   It makes no sense to put us in a container we're already
//             *   directly in.  (It's fine to put it in something it's
//             *   indirectly in, though - doing so takes it out of the
//             *   intermediate container and moves it directly into the
//             *   indirect object.) 
//             */
//            if (gIobj != nil && isDirectlyIn(gIobj))
//                illogicalAlready(&alreadyPutInMsg);
//
//            /* can't put in self, obviously */
//            if (gIobj == self)
//                illogicalSelf(&cannotPutInSelfMsg);
//
//            /* verify the transfer */
//            verifyMoveTo(gIobj);
//        }
//    }
//    dobjFor(PutOn)
//    {
//        preCond = [objHeld]
//        verify()
//        {
//            /* it makes no sense to put us on a surface we're already on */
//            if (gIobj != nil && isDirectlyIn(gIobj))
//                illogicalAlready(&alreadyPutOnMsg);
//
//            /* can't put on self, obviously */
//            if (gIobj == self)
//                illogicalSelf(&cannotPutOnSelfMsg);
//
//            /* verify the transfer */
//            verifyMoveTo(gIobj);
//        }
//    }
//;

#endif // __DEBUG

// -------------------------------------------------------------------
// NOTES
// -------------------------------------------------------------------

/*
change these properties of StrangeThing!
notAContainerMsg
notASurfaceMsg
cannotPutUnderMsg
cannotPutBehindMsg
notAWeaponMsg
willNotCatch
cannotMoveWith
cannotTurnWith
cannotLockWith
cannotUnlockWith
*/
/*
read black.read navy.read green.read maroon. read teal.read purple.read olive.read silver
read gray.read blue.read lime.read red.read aqua.read fuchsia. read yellow.read white
*/

/*
TO DO:
Create an appropriate response for firing at the prisoners
  as opposed to the aliens.
*/

// The world's smallest species of sturgeon is:
// Pseudoscaphirhynchus hermanni
// dwarf sturgeon
// http://ichtyonb1.mnhn.fr/Summary/SpeciesSummary.cfm?ID=8764&genusname=Pseudoscaphirhynchus&speciesname=hermanni
// max length: 27.5 cm (male)
// max weight: 50.5 g

// IMPORTANT NOTE: I had to eliminate the verb (Set) because it 
// conflicts with the new version of TADS 3 introduced in late
// August 2005. Make very sure to check my verb (Set) vs. that
// of the new version of the library. Make changes accordingly.

// A.P. Hill's review of his own game Amissville
// (http://www.carouselchain.com/if/comments.php?rategame=1771):
//   When my life was at its lowest, this game turned it all around 
//   and inspired me to make something of myself. If you only play 
//   one game in your entire life, it must be this one. All others, 
//   by comparison, are poor faded shadows of the greatness of 
//   Return to Amissville. If you enjoy truth in its most raw and 
//   primal form, you will enjoy this game. I will write a much more 
//   detailed review later but unfortunately my time is limited at 
//   the moment.

// The aliens' review of Xenos:
//   If you only play one Earth game in your entire life, it must be this one.
//   All others, by comparison, are poor faded shadows of the greatness of Xenos.
//   If you enjoy truth in its most raw and primal form, you will enjoy this game.
//   Why is Xenos so great? Let me tell you.

/*
- 1979              Dog Star Adventure
X 1979    shotgun   Xenos
X 1981    phaser    Strange Odyssey
X 1984    explosive Countdown to Doom
X 1983    handgun   Snowball
- 1985              Essex
X 1983    laser     Planetfall
X 1984    dispenser The Hitchhiker's Guide to the Galaxy
X 1988    ?         Fish!
X 1993    p.b. gun  Gateway 2: Homeworld

  1997 In           Sins Against Mimesis
  1999              Worlds Apart
  2000              Heroine's Mantle
  2001              Centipede
  2003              Scavenger

X 1988 T2 xenite    Deep Space Drifter
X 1994 T2 ary ung   The Legend Lives!
X 1998 In pulse gun Spider and Web
X 2001 Hu e. pistol Fallacy of Dawn
X 2003 T3 blaster   Max Blaster and Doris de Lightning Against the Parrot Creatures of Venus
X 2026    T-r. gun  Leather Goddesses Zero: Dawn of the Goddesses

X 1988 T2 Roberts    Deep Space Drifter
  1992 D  Cunningham t-zero
X 1994 T2 Baggett    The Legend Lives!
  1995 T2 McCarthy   The Light: Shelby's Addendum
  1996 In Phillips   Time: All Things Come to an End
  1996 In Forman     Delusions
  1997 T2 Finley     Babel
  1997 In Thornton   Sins Against Mimesis
  1997 T2 Cull       Glowgrass
  1997 In Smith      The Edifice
  1997 T2 Wilson     Sea of Night
X 1998 In Plotkin    Spider and Web
  1998 T2 Shiovitz   Bad Machine
  1998 In Gentry     Little Blue Men
  1998 T2 Granade    Arrival
  1999 T2 Britton    Worlds Apart
  1999 T2 Litherland Erehwon
  2000 T2 Finley     Kaged
  2000 In Ingold     Fail-Safe
  2000 In O'Brian    LASH
  2000 In Phillips   Heroine's Mantle
  2001 In Ingold     All Roads
  2001 In O'Brian    Earth and Sky
  2001 Gl Thornton   Stiffy Makane: The Undiscovered Country
  2001 T2 Wheeler    First Things First
  2001 In Wheeler    Centipede
  2001 In Mark       Vicious Cycles
  2001 In Raszewski  Moments out of Time
X 2001 Hu Sherwin    Fallacy of Dawn
  2002 T2 Ingo/Sousa Till Death Makes a Monk-Fish out of Me!
  2002 Gl O'Brian    EAS2: Another Earth, Another Sky
  2002 In Hol        Dutch Dapper IV: The Final Voyage
X 2003 T3 Shio/Short Max Blaster and Doris de Lightning
  2003 In Ingold     Insight
  2003 In Fischer    Inevitable
  2003 T2 Stone      Scavenger
  2004 Gl O'Brian    EAS3: Luminous Horizon
  2004 In Ord        All Things Devours
  2004 In Weisenb.   The Orion Agenda
*/

// -------------------------------------------------------------------
// GUNS AND SHOOTING: pedestals and plaques
// -------------------------------------------------------------------

class Pedestal: /*OutOfReach,*/ Platform, Fixture
  //vocabWords = 'pedestal/podium/stand*pedestals*podiums*stands'
  nounVocabWords = 'pedestal/podium/stand*pedestals*podiums*stands'
  name() { return self.pcolor + ' pedestal'; }
  desc {
    local pCell;
    "The <<name>> is fully five feet in diameter, and is situated
      <<positionOrdinal>>.
      Affixed to the pedestal is a <<pcolor>> plaque, which reads,
      <i><.q></i><<asscPlq.asscArt.attributionForPlaque>><./q> ";
    pCell = contents.indexWhich({x: x.ofKind(Powercellesque)});
    if (pCell) {
      pCell = contents[pCell];
      if (pCell.asscGun.isIn(self))
        pCell.asscGun.pedestalContentsDesc;
      else
        pCell.pedestalContentsDesc;
    }
    if (dispenser.location == self) {
      dispenser.pedestalContentsDesc;
    }
  }
  positionFromLeft {
    if (xValue < 0)
      return yValue + 4;
    else
      return 5 - yValue;
  }
  pluralOrder {
    if (xValue < 0)
      return yValue + 4;
    else
      return 13 - yValue;
  }
  positionOrdinal {
    switch (positionFromLeft) {
      case 1: return 'on the far left of ' + location.theName;
      case 2: return 'second from the left on ' + location.theName;
      case 3: return 'third from the left on ' + location.theName;
      case 4: return 'fourth from the left on ' + location.theName;
      case 5: return 'fifth from the left on ' + location.theName;
      case 6: return 'sixth from the left on ' + location.theName;
      case 7: return 'seventh from the left on ' + location.theName;
      case 8: return 'on the far right of ' + location.theName;
    }
    return 'such that it has a position value of ' + positionFromLeft
      + ' (BUG!)';
  }
  asscPlq { return asscArt.asscPlq; }
  dobjFor(Read) remapTo(Read, asscPlq)
  asscArt = nil // Will be changed.
  allowedPostures = [sitting, standing]
  obviousPostures = [sitting, standing]
  effectiveFollowLocation = (location.effectiveFollowLocation)
  getDropDestination(obj, path) {
    return location != nil
      ? location.getDropDestination(obj, path)
      : self;
  }
  isGoNearDestForContents = true
  objIsNearToThis(obj) {
    if (obj.getOutermostRoom != self.getOutermostRoom)
      return nil;
    return (obj.yValue == self.yValue &&
      absVal(obj.xValue - self.xValue) <= 1);
  }
  dobjFor(Enter) asDobjFor(StandOn)
  dobjFor(Climb) asDobjFor(StandOn)
  dobjFor(ClimbUp) asDobjFor(StandOn)
  dobjFor(ClimbDown) asDobjFor(GetOffOf)
  dobjFor(StandOn) {
    preCond = [touchObj, actorStanding]
  }
  dobjFor(SitOn) {
  }
  // If the goal is simply to move near a pedestal, we do not want
  // to stand on top of it. Instead, we want to stand right next to it.
  moveActorNearThis(actor) {
    if (getOutermostRoom != museum)
      return;
    if (actor.xValue == xValue && actor.yValue == yValue)
      return;
    actor.yBaseValue = self.yValue;
    actor.xBaseValue = proxyXValueForGoingNear;
    //callWithSenseContext(nil, nil, new function { "[Pedestal.moveActorNearThis] "; } );
    actor.doXYConsequences;
  }
  // Very significant: Going near a pedestal must not mean stepping
  // on top of it. Hence, proxyXValueForGoingNear = -2 or 2, not -3 or 3.
  proxyXValueForGoingNear = (self.xValue < 0 ? -2 : 2)
  zapT = die(
    'The ' + pcolor + ' pedestal is transformed into '
        + Thing.aNameFrom(tRemColor) + ' pedesal!
      <p>Pedesals are among the most feared predators
        on all of 18 Scorpii II. They look&mdash;well, 
        a little like a dinosaur, except that they<./s>re
        headless, with mouths on their abdomen.
        Also, they have eight feet, or perhaps twelve if you
        count the lesser appendages on their back.
      <p>Pedesals are almost always aggressive, and this '
        + tRemColor + ' one is no exception. The bad news is,
        it pounces on you and starts ripping you apart.
        The good news is, your death is quick. '
    , 'pedesal', 'pedestal' //,killEverybodyInRoom
  )
;
class Plaque: WeaklyColored, Readable, Component
  //vocabWords = 'plaque/inscription*plaques*inscriptions'
  nounVocabWords = 'plaque/inscription*plaques*inscriptions'
  pcolor='BUG'
  name() { return self.pcolor + ' plaque'; }
  desc {
    asscArt.recognized = true;
    "The <<pcolor>> plaque reads, 
      <i><.q></i><<asscArt.attributionForPlaque>><./q> ";
    //asscArt.plqDesc;
  }
  asscPed { return asscArt.asscPed; }
  asscArt = nil // Will be changed.
  pluralOrder = (asscPed.pluralOrder)
  //initializeVocabWith(str) {
  //  inherited(str);
  //  if (weakTokens == nil)
  //    weakTokens = [];
  //  weakTokens += 
  //}
  transformObj = asscPed
  //hitByAry { asscPed.hitByAry; }
  //hitByT { asscPed.hitByT; }
;

//class On76:    Thing location=nil;
//class On86:    Thing location=nil;
//class On96:    Thing location=nil;
class Nowhere: Thing location=nil;
class OnWestPlatform: Thing
  location = westPlatform
  xBaseValue = -3
;
class OnEastPlatform: Thing
  location = eastPlatform
  xBaseValue = 3
;

class Color: object
  vocabList = ''
  initializeVocabWith(str) {
    str = '';
    for (local a = 1; a <= colorList.length; a++) {
      if (ofKind(WeaklyColored) && colorList[a].substr(1, 1) != '(')
        str += '(' + colorList[a] + ') ';
      else
        str += colorList[a] + ' ';
    }
    //str += '-';
    str += nounVocabWords;
    vocabList = str;
    inherited(str);
  }
  pcolor = colorList[1]
  tRemColor = (pcolor.findReplace('t', '', ReplaceAll))
  colorList = ['blank']
  isWeaklyColored = nil
;

class Black:   Color colorList=['black'  ,'dark'];
class Navy:    Color colorList=['navy'   ,'dark'/*,'(blue)'*/];
class Green:   Color colorList=['green'  ,'dark'];
class Maroon:  Color colorList=['maroon' ,'dark'/*,'(red)'*/];
class Teal:    Color colorList=['teal'   ,'dark','turquoise'];
class Purple:  Color colorList=['purple' ,'dark','violet'];
class Olive:   Color colorList=['olive'  ,'dark','brown','tan'];
class Silver:  Color colorList=['silver' ,'dark'];

class Gray:    Color colorList=['gray'   ,'light','grey'];
class Blue:    Color colorList=['blue'   ,'light'];
class Lime:    Color colorList=['lime'   ,'light'/*,'(green)'*/];
class Red:     Color colorList=['red'    ,'light'];
class Aqua:    Color colorList=['aqua'   ,'light','cyan'];
class Fuchsia: Color colorList=['fuchsia','light','fuschia','fushia','fuchia','magenta','lavender'];
class Yellow:  Color colorList=['yellow' ,'light'];
class White:   Color colorList=['white'  ,'light'];

class Cyan:    Color colorList=['cyan'   ];
class Magenta: Color colorList=['magenta'];
class NoColor: Color colorList=['blank'  ];

class WeaklyColored: object
  isWeaklyColored = true
;

blackPed:   Black,   Pedestal, OnWestPlatform yBaseValue = -3;
navyPed:    Navy,    Pedestal, OnWestPlatform yBaseValue = -2;
greenPed:   Green,   Pedestal, OnWestPlatform yBaseValue = -1;
maroonPed:  Maroon,  Pedestal, OnWestPlatform yBaseValue =  0;
tealPed:    Teal,    Pedestal, OnWestPlatform yBaseValue =  1;
purplePed:  Purple,  Pedestal, OnWestPlatform yBaseValue =  2;
olivePed:   Olive,   Pedestal, OnWestPlatform yBaseValue =  3;
silverPed:  Silver,  Pedestal, OnWestPlatform yBaseValue =  4;

grayPed:    Gray,    Pedestal, OnEastPlatform yBaseValue =  4;
bluePed:    Blue,    Pedestal, OnEastPlatform yBaseValue =  3;
limePed:    Lime,    Pedestal, OnEastPlatform yBaseValue =  2;
redPed:     Red,     Pedestal, OnEastPlatform yBaseValue =  1;
aquaPed:    Aqua,    Pedestal, OnEastPlatform yBaseValue =  0;
fuchsiaPed: Fuchsia, Pedestal, OnEastPlatform yBaseValue = -1;
yellowPed:  Yellow,  Pedestal, OnEastPlatform yBaseValue = -2;
whitePed:   White,   Pedestal, OnEastPlatform yBaseValue = -3;

modify navyPed
  zapAry = die(
    'The navy pedestal is transformed into a pedestal navy! 
        That is, there is now an assembly of floating pedestals here,
        each of them manned by miniature sailors. 
      <p>When the two-inch-tall captain of the flagship 
        (or flagpedestal) sights you,
        he instictively takes you for an enemy, and sends the code
        for all vessels to open fire.
      <p>Though their artillery shells are small, they are 
        as deadly as any bullets. '
    , 'pedestal navy', 'navy pedestal', killEverybodyInRoom
  )
;
modify greenPed
  zapAry = lose(
    'The green pedestal disappears, and in its place appear a couple
        of exceedingly strange-looking birds, like a pair of 
        ostrich-sized turkeys.
      <p>What<./s>s more, they can talk. In fact, one of
        them is saying to another, <.q>Oh yeah, well, if you
        were a <i>real</i> eagle, you<./s>d eat meat.<./q>
      <p>The other replies, <.q>Oh, I eat meat, all right.
        You, though&mdash;you don<./s>t eat anything but grass seed.<./q>
      <p><.q>What! I<./s>d eat meat right now, if there was any
        to eat!<./q> squawks the first.
      <p>The other bird points its wing at you.
        <.q>Well, there<./s>s a human over there. You can
        eat it right now, if you want to. Unless you<./s>re only
        <i>pretending</i> to be an eagle, that is.<./q>
      <p>The first bird looks at you, a bit startled, then says,
        <.q>Oh. No, no, I<./s>m an eagle. Uh, just you watch!<./q>
      <p>The bird is inexpert at killing, but also taller
        than you are. You never really stand a chance. '
    , ftPretendEagles, 'pretend eagles', 'green pedestal'
  )
;
ftPretendEagles: FinishType
  finishMsg = 'You have fallen prey to pretend eagles'
;
modify maroonPed
  zapAry = die(
    'The maroon pedestal disappears. Then, all of a sudden,
        pieces of plastic start falling from the 
        ceiling. Each piece is etched with someone<./s>s
        name: <.q>Irene Reynolds,<./q> <.q>Trevor MacAllister,<./q> 
        and so on. They look like they might be used as door
        nameplates.
      <p>Just as you<./s>re wondering how these door nameplates 
        could have fallen from the ceiling, they
        start falling ever faster, turning into an epic 
        hailstorm&mdash;or no, more like an avalanche.
        It is as though a whole warehouse<./s>s worth
        of plastic is being dumped into the museum.
      <p>Soon you are completely buried, and then you are doomed. 
        It takes you several agonizing days to die 
        of dehydration, buried by door nameplates. '
    , 'door nameplates', 'maroon pedestal', killEverybodyInRoom
  )
;
modify silverPed
  //zapAry = die(
  //  'The silver pedestal is transformed into an assembly of
  //      devil<./s>s prelates! Yes, the devil has clergymen too,
  //      or so it seems. Anyway, they are all dressed in
  //      what would otherwise look like bishops<./s> garb, 
  //      except that it is covered with pentagrams. 
  //      Another telltale sign is that they are chanting 
  //      odd phrases like, <.q>Death to goodness,<./q> and
  //      <.q>Glory be to bad things, amen.<./q>
  //    <p>But the biggest clue that they are indeed the 
  //      <i>devil<./s>s</i> prelates is that they start preparing
  //      for what is obviously a ritual 
  //      of human sacrifice. When they look for victims,
  //      they find you. '
  //  //,killEverybodyInRoom
  //)
;
modify limePed
  zapAry = die(
    'The lime pedestal disappears. The next instant, 
        you are crushed beneath solid marble.
      <p>Although you will never know it, the stone that
        crushes you is none other than foundation stone
        for the Ideal Temples, 
        the much-admired religious monuments 
        of 18 Scorpii II. When the priestesses inside 
        emerge, they are no less surprised than you.
        They are considerably less dead, however. '
    , 'Ideal Temples', 'lime pedestal', killEverybodyInRoom
  )
;

cyanPed:    Cyan,    Pedestal, Nowhere;
magentaPed: Magenta, Pedestal, Nowhere;
blankPed:   NoColor, Pedestal, Nowhere;


blackPlq:   Black,   Plaque location=blackPed  ;
navyPlq:    Navy,    Plaque location=navyPed   ;
greenPlq:   Green,   Plaque location=greenPed  ;
maroonPlq:  Maroon,  Plaque location=maroonPed ;
tealPlq:    Teal,    Plaque location=tealPed   ;
purplePlq:  Purple,  Plaque location=purplePed ;
olivePlq:   Olive,   Plaque location=olivePed  ;
silverPlq:  Silver,  Plaque location=silverPed ;

grayPlq:    Gray,    Plaque location=grayPed   ;
bluePlq:    Blue,    Plaque location=bluePed   ;
limePlq:    Lime,    Plaque location=limePed   ;
redPlq:     Red,     Plaque location=redPed    ;
aquaPlq:    Aqua,    Plaque location=aquaPed   ;
fuchsiaPlq: Fuchsia, Plaque location=fuchsiaPed;
yellowPlq:  Yellow,  Plaque location=yellowPed ;
whitePlq:   White,   Plaque location=whitePed  ;

cyanPlq:    Cyan,    Plaque location=cyanPed   ;
magentaPlq: Magenta, Plaque location=magentaPed;
blankPlq:   NoColor, Plaque location=blankPed  ;

//    ". The pedestals on the west platform are colored 
//      black, blue, green, cyan, red, magenta, yellow, and white;
//      the pedestals on the east platform are colored
//      aqua, fuchsia, gray, lime, maroon, navy, olive, and silver. ";

/*
class Black:   object gotArt=impBlaster    vocabWords='black -'   pcolor='black'  ;
class Blue:    object gotArt=phaser    vocabWords='blue -'    pcolor='blue'   ;
class Green:   object gotArt=explosive       vocabWords='green -'   pcolor='green'  ;
class Cyan:    object gotArt=handgun   vocabWords='cyan -'    pcolor='cyan'   ;
class Red:     object gotArt=essex      vocabWords='red -'     pcolor='red'    ;
class Magenta: object gotArt=laser vocabWords='magenta -' pcolor='magenta';
class Yellow:  object gotArt=dispenser vocabWords='yellow -'  pcolor='yellow' ;
class White:   object gotArt=pbGun   vocabWords='white -'   pcolor='white'  ;
class Aqua:    object gotArt=aryUng     vocabWords='aqua -'    pcolor='aqua'   ;
class Fuchsia: object gotArt=mimesis    vocabWords='fuchsia -' pcolor='fuchsia';
class Gray:    object gotArt=pulseGun     vocabWords='gray -'    pcolor='gray'   ;
class Lime:    object gotArt=worlds     vocabWords='lime -'    pcolor='lime'   ;
class Maroon:  object gotArt=heroine    vocabWords='maroon -'  pcolor='maroon' ;
class Navy:    object gotArt=centipede  vocabWords='navy -'    pcolor='navy'   ;
class Olive:   object gotArt=blaster    vocabWords='olive -'   pcolor='olive'  ;
class Silver:  object gotArt=scavenger  vocabWords='silver -'  pcolor='silver' ;
class Teal:    object gotArt=nil        vocabWords='teal -'    pcolor='teal'   ;
class NoColor: object gotArt=magnetic   vocabWords='blank -'   pcolor='blank'  ;
//class Gray:    object gotArt=nil        vocabWords='gray -'    pcolor='gray'   ;
//class Purple:  object gotArt=nil        vocabWords='purple -'  pcolor='purple' ;
*/

// -------------------------------------------------------------------
// GUNS AND SHOOTING: ArtifactGun and Artifact classes, etc.
// -------------------------------------------------------------------

//class MaybeCountedAsArtifact: object
//;

modify Thing
  sayForArt(msg) {
    //NOOF
    if (msg != '')
      "<<artHtml1>><<msg>><<artHtml2>>";
  }
;

class Artifact: StrangeThing
  countedAsArtifactForRoomDesc = true
  doNotMoveArtifact = nil
  //vocabWords = 'gun'
  location   = nil // this will be changed later
  asscPed    = nil // this will be changed later
  asscPlq    = nil // this will be changed later
  recognized = nil
  artHtml1   = '<font color=lime>' // A stupid color, to show
  artHtml2   = '</font>'           // that something's wrong.
  pluralOrder = (asscPed.pluralOrder)
  // As long as an artifact is sitting on a pedestal, don't list 
  // it in the room description. 
  isListed {
    if (location && location.ofKind(Pedestal))
      return nil;
    else
      return inherited;
  }
  isListedInCredits = true
  //desc {
  //  say(artHtml1);
  //  say(artDesc);
  //  say(artHtml2);
  //}
  desc {
    //NOOF
    //local obj = self;
    sayForArt('');
    "<<artHtml1>>";
    tripartiteDesc
      ('{The dobj/he} {is} sitting on the ' + asscPed.name + '. ',
       'This is {the dobj/him} you got from the ' 
         + asscPed.name + '. ',
       'Apparently this is {the dobj/him} from ' 
         + simpleAttribution + '. ');
    "<p>";
    artDesc;
    "<<artHtml2>>";
  }
  attributionForPlaque {
    local str = simpleAttribution;
    if (artAuthor != nil && artAuthor != '')
      str += '.';
    else
      str += '<i>.</i>';
    if (artCompany != nil && artCompany != '')
      str += ' \^' + artCompany + '.';
    if (artYear != nil && artYear != '')
      str += ' ' + artYear + '.';
    return str;
  }
  simpleAttribution {
    if (artAuthor != nil && artAuthor != '') {
      if (artTitle.substr(-1) == '!')
        return titlei('') + ' by ' + artAuthor;
      else
        return titlei(',') + ' by ' + artAuthor;
    }
    else
      return titlei('');
  }
  attributionForCredits {
    return simpleAttribution 
      + (permissionObtained ? '[*]' : '')
      + ((artCompany != nil && artCompany != '') ? ' (' + artCompany + ')' : '');
  }
  initLocation() {
    for (local obj=firstObj(Pedestal, ObjInstances); obj!=nil;
      obj = nextObj(obj,Pedestal, ObjInstances)) {
      if (obj.ofKind(gc(self, 1))) {
        self.asscPed = obj;
        obj.asscArt = self;
        break;
      }
    }
    for (local obj=firstObj(Plaque, ObjInstances); obj!=nil;
      obj = nextObj(obj,Plaque, ObjInstances)) {
      if (obj.ofKind(gc(self, 1))) {
        self.asscPlq = obj;
        obj.asscArt = self;
        break;
      }
    }
    //"<<name>> is being moved to <<asscPed.pcolor>>.\n ";
    moveInto(asscPed);
  }
  miniDesc() {
    if (recognized)
      "<<nickname>> from <<artTitle>>";
    //else if (location == asscPed)
    else if (location != asscPed)
      "<<nickname>> that you got from the <<asscPed.name>>";
  }
  titlei (punc) {
    return '<i>' + artTitle + punc + '</i>';
  }
  tripartiteDesc(seenIt, movedIt, knowIt) {
    if (recognized)
      say(knowIt);
    else if (location == asscPed)
      say(seenIt);
    else
      say(movedIt);
  }
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  permissionObtained = nil
;

initArtLocations() {
  local idx;
  //// move plaques to associated pedestals
  //for (local pdl=firstObj(Pedestal, ObjInstances); pdl!=nil;
  //  pdl=nextObj(pdl,Pedestal, ObjInstances)) {
  //  for (local plq=firstObj(Plaque, ObjInstances); plq!=nil;
  //    plq=nextObj(plq,Plaque, ObjInstances)) {
  //    if (plq.pcolor == pdl.pcolor) {
  //      plq.moveInto(pdl);
  //      break;
  //    }
  //  }
  //}
  for (local obj = firstObj(Artifact, ObjInstances); obj != nil;
       obj = nextObj(obj,Artifact, ObjInstances)) {
    if (!obj.doNotMoveArtifact) {
      obj.initLocation();
      if (obj.location && obj.location.location && 
          obj.location.ofKind(Pedestal) && 
          obj.location.location.ofKind(AlienPlatform) &&
          absVal(obj.xValue) == 3)
      {
        if (obj.xValue < 1) {
          idx = 0 + (4 + obj.yValue);
        }
        else {
          idx = 8 + (5 - obj.yValue);
        }
        if (idx >= 1 && idx <= 16)
          glob.artifactList[idx] = obj;
      }
    }
  }
  //glob.artifactList = 
  //  glob.artifactList.sort(nil, 
  //    //{x, y: x.artTitle - y.artTitle}
  //    {x, y: x.artTitle < y.artTitle ? -1 : 1 }
  //  );
}

modify Thing
  artHtml1 = ''
  artHtml2 = ''
;

function gc(weapon, wanted) {
  local a;
  local b;
  switch (weapon) {
    //case tokenShotgun: a=White ; b='gray'; break;
    //case impBlaster: a=NoColor; b='gray   '; break;
    //case dispenser : a=Yellow ; b='olive  '; break;
    //case mimesis   : a=
    
//    case shotgun   : a=Black  ; b='gray   '; break;
//    case phaser    : a=Blue   ; b='blue   '; break;
//    case tokFix5   : a=Green  ; b='green  '; break;
//    //case explosive : a=Green  ; b='green  '; break;
//    case handgun   : a=Cyan   ; b='teal   '; break;
//    //case tokFix8   : a=Red    ; b='red    '; break;
//    case laser     : a=Red    ; b='red    '; break;
//    case dispenser : a=Magenta; b='fuchsia'; break;
//    //case tokFix6   : a=Yellow ; b='olive'  ; break;
//    case crystal   : a=Yellow ; b='olive'  ; break;
//    case pbGun     : a=White  ; b='silver '; break;
//    
//    //case tokFix7   : a=Aqua   ; b='teal   '; break;
//    case xenite    : a=Aqua   ; b='teal   '; break;
//    case aryUng    : a=Fuchsia; b='fuchsia'; break;
//    case pulseGun  : a=Gray   ; b='gray   '; break;
//    //case tokFix1   : a=Lime   ; b='green  '; break;
//    case pistol    : a=Lime   ; b='green  '; break;
//    case blaster   : a=Maroon ; b='maroon '; break;
//    case tokFix2   : a=Navy   ; b='navy   '; break;
//    case tokFix3   : a=Olive  ; b='olive  '; break;
//    case tokFix4   : a=Silver ; b='silver '; break;
        
    case shotgun        : a=Black  ; b='#000000';/*b='black  ';*/ break;
    case phaser         : a=Navy   ; b='#000080';/*b='navy   ';*/ break;
    case explosive      : a=Green  ; b='#008000';/*b='green  ';*/ break;
    case handgun        : a=Maroon ; b='#800000';/*b='maroon ';*/ break;
    case laser          : a=Teal   ; b='#008080';/*b='teal   ';*/ break;
    case dispenser      : a=Purple ; b='#800080';/*b='purple ';*/ break;
    case crystal        : a=Olive  ; b='#6E6E00';/*b='olive  ';*/ break; // was #808000 2019-07-31 GWB
    case particleGun    : a=Silver ; b='#666666';/*b='silver ';*/ break;
    
    case xenite         : a=Gray   ; b='#666666';/*b='gray   ';*/ break;
    case aryUng         : a=Blue   ; b='#0000FF';/*b='blue   ';*/ break;
    case pulseGun       : a=Lime   ; b='#00CC00';/*b='lime   ';*/ break;
    case electricPistol : a=Red    ; b='#FF0000';/*b='red    ';*/ break;
    case silencedPistol : a=Aqua   ; b='#00CCCC';/*b='aqua   ';*/ break;
    case disrupter      : a=Fuchsia; b='#FF00FF';/*b='fuchsia';*/ break;
    case missileLauncher: a=Yellow ; b='#A1A100';/*b='yellow ';*/ break; // was #CCCC00 2019-07-31 GWB
    case tRemovingGun   : a=White  ; b='#999999';/*b='white  ';*/ break;
    
    default             : a=NoColor; b='black  '; break;
  }
  if (wanted == 1)
    return a;
  else // wanted = 2
    return b;
}

/*
function gc(weapon, wanted) {
  local a;
  local b;
  switch (weapon) {
    case shotgun     : return Black  ;
    case impBlaster   : return NoColor;
    case phaser   : return Blue   ;
    case explosive      : return Green  ;
    case handgun  : return Cyan   ;
    case essex     : return Red    ;
    case magnetic  : return NoColor;
    case laser: return Magenta;
    case dispenser: return Yellow ;
    case pbGun  : return White  ;
    case aryUng    : return Aqua   ;
    case mimesis   : return Fuchsia;
    case pulseGun    : return Gray   ;
    case worlds    : return Lime   ;
    case heroine   : return Maroon ;
    case centipede : return Navy   ;
    case blaster   : return Olive  ;
    case scavenger : return Silver ;
    //case default   : return NoColor;
  }
  return NoColor;
}
*/


class ArtifactGun: Gun, Artifact
  //dobjFor(ShootAimlessly) {
  //  action() {
  //    if (bang()) bangWeapon();
  //    exit;
  //  }
  //}
  //iobjFor(ShootWith) {
  //  action() {
  //    if (bang()) {
  //      if (gDobj && gIobj) gDobj.resistShooting();
  //      bangTarget();
  //    }
  //    exit;
  //  }
  //}
  //bang()       { return true; }
  //bangWeapon() { defaultReport(&okayShootMsg); }
  //bangTarget() { defaultReport(&okayShootTargetMsg); }
;

//modify Thing
//  resistShooting() { }
//;

/*
*/

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Token fixtures
// -------------------------------------------------------------------

tokFix1: Fixture;
tokFix2: Fixture;
tokFix3: Fixture;
tokFix4: Fixture;
tokFix5: Fixture;
tokFix6: Fixture;
tokFix7: Fixture;
tokFix8: Fixture;
tokFix9: Fixture;
tokFix10: Fixture;
tokFix11: Fixture;
tokFix12: Fixture;
tokFix13: Fixture;
tokFix14: Fixture;
tokFix15: Fixture;
tokFix16: Fixture;
tokFix17: Fixture;
tokFix18: Fixture;
tokFix19: Fixture;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Font style tags
// -------------------------------------------------------------------

class FontTag: HtmlStyleTag
  htmlCloseText = '</font>'
;

blueTag:  FontTag 'blue'  htmlOpenText='<font color=blue >';
tealTag:  FontTag 'teal'  htmlOpenText='<font color=teal >';
greenTag: FontTag 'green' htmlOpenText='<font color=green>';
redTag:   FontTag 'red'   htmlOpenText='<font color=red  >';

class ArtTag: FontTag
  htmlOpenText = '<font color=' + clr + '>'
    + (isBlack ? '<b>' : '')
  clr = 'black'
  htmlCloseText = (isBlack ? '</b>' + inherited : inherited)
  isBlack {
    if (_isBlack != -1)
      return _isBlack;
    if (clr.toLower.find('black') || clr.find('000000'))
      _isBlack = true;
    else
      _isBlack = nil;
    return _isBlack;
  }
  _isBlack = -1 // an arbitrary value meaning "I don't know"
;

odysseyblueTag:  FontTag 'odysseyblue'  htmlOpenText='<font color=blue>';
odysseytealTag:  FontTag 'odysseyteal'  htmlOpenText='<font color=blue>';
odysseygreenTag: FontTag 'odysseygreen' htmlOpenText='<font color=blue>';

//wpTag: ArtTag 'wptag'      clr=gc(tokenWeapon     , 2);
//sgTag: ArtTag 'sgtag'      clr=gc(tokenShotgun    , 2);

xenosTag:      ArtTag 'xenos'      clr=gc(shotgun   , 2); // 1
//dogstarTag:    ArtTag 'dogstar'    clr=gc(impBlaster, 2); // 
odysseyTag:    ArtTag 'odyssey'    clr=gc(phaser    , 2); // 2
doomTag:       ArtTag 'doom'       clr=gc(explosive , 2); // 3
snowballTag:   ArtTag 'snowball'   clr=gc(handgun   , 2); // 4
//essexTag:      ArtTag 'essex'      clr=gc(essex     , 2); // 
fishTag:       ArtTag 'fish'       clr=gc(crystal   , 2); // 7
planetfallTag: ArtTag 'planetfall' clr=gc(laser     , 2); // 5
hitchhikerTag: ArtTag 'hitchhiker' clr=gc(dispenser , 2); // 6
gatewayTag:    ArtTag 'gateway'    clr=gc(particleGun     , 2); // 8
deepTag:       ArtTag 'deep'       clr=gc(xenite    , 2); // 1
legendTag:     ArtTag 'legend'     clr=gc(aryUng    , 2); // 2
//mimesisTag:    ArtTag 'mimesis'    clr=gc(mimesis   , 2); // 
spiderTag:     ArtTag 'spider'     clr=gc(pulseGun  , 2); // 3
fallacyTag:    ArtTag 'fallacy'    clr=gc(electricPistol, 2); // 4-5
//worldsTag:     ArtTag 'worlds'     clr=gc(worlds    , 2); // 
//heroineTag:    ArtTag 'heroine'    clr=gc(heroine   , 2); // 
//centipedeTag:  ArtTag 'centipede'  clr=gc(centipede , 2); // 
//blasterTag:    ArtTag 'blaster'    clr=gc(blaster   , 2); // 5-6
scavengerTag:  ArtTag 'scavenger'  clr=gc(silencedPistol , 2); // 
momentsTag:    ArtTag 'moments'    clr=gc(disrupter , 2); //
counterTag:    ArtTag 'counter'    clr=gc(missileLauncher  , 2); // 
leatherTag:    ArtTag 'leather'    clr=gc(tRemovingGun  , 2); // 

/*
shotgun   :Xeno1,Xeno2,Xeno3 gc=Black  ;
impBlaster:Dogs1,Dogs2,Dogs3 gc=NoColor;
phaser    :Odys1,Odys2,Odys3 gc=Blue   ;
explosive :Doom1,Doom2,Doom3 gc=Green  ;
handgun   :Snow1,Snow2,Snow3 gc=Cyan   ;
essex     :Esse1,Esse2,Esse3 gc=Red    ;
magnetic  :Magn1,Magn2,Magn3 gc=NoColor;
laser     :Plan1,Plan2,Plan3 gc=Magenta;
dispenser :Hitc1,Hitc2,Hitc3 gc=Yellow ;
pbGun     :Gate1,Gate2,Gate3 gc=White  ;
aryUng    :Lege1,Lege2,Lege3 gc=Aqua   ;
mimesis   :Mime1,Mime2,Mime3 gc=Fuchsia;
pulseGun  :Spid1,Spid2,Spid3 gc=Gray   ;
worlds    :Worl1,Worl2,Worl3 gc=Lime   ;
heroine   :Hero1,Hero2,Hero3 gc=Maroon ;
centipede :Cent1,Cent2,Cent3 gc=Navy   ;
blaster   :Blas1,Blas2,Blas3 gc=Olive  ;
scavenger :Scav1,Scav2,Scav3 gc=Silver ;

class Xeno3: object plqDesc="This is the gun from <<artTitle>>. ";
class Dogs3: object plqDesc="This is the gun from <<artTitle>>. ";
class Odys3: object plqDesc="This is the gun from <<artTitle>>. ";
class Doom3: object plqDesc="This is the gun from <<artTitle>>. ";
class Snow3: object plqDesc="This is the gun from <<artTitle>>. ";
class Esse3: object plqDesc="This is the gun from <<artTitle>>. ";
class Magn3: object plqDesc="This is the gun from <<artTitle>>. ";
class Plan3: object plqDesc="This is the gun from <<artTitle>>. ";
class Hitc3: object plqDesc="This is the gun from <<artTitle>>. ";
class Gate3: object plqDesc="This is the gun from <<artTitle>>. ";
class Lege3: object plqDesc="This is the gun from <<artTitle>>. ";
class Mime3: object plqDesc="This is the gun from <<artTitle>>. ";
class Spid3: object plqDesc="This is the gun from <<artTitle>>. ";
class Worl3: object plqDesc="This is the gun from <<artTitle>>. ";
class Hero3: object plqDesc="This is the gun from <<artTitle>>. ";
class Cent3: object plqDesc="This is the gun from <<artTitle>>. ";
class Blas3: object plqDesc="This is the gun from <<artTitle>>. ";
class Scav3: object plqDesc="This is the gun from <<artTitle>>. ";

class Xeno2: object;
class Dogs2: object;
class Odys2: object;
class Doom2: object;
class Snow2: object;
class Esse2: object;
class Magn2: object;
class Plan2: object;
class Hitc2: object;
class Gate2: object;
class Lege2: object;
class Mime2: object;
class Spid2: object;
class Worl2: object;
class Hero2: object;
class Cent2: object;
class Blas2: object;
class Scav2: object;
*/

modify glob
  seenArtColors = 0
;

//  crocInThisRoom() {
//    local whichClass = Crocodile;
//    for(local cur=firstObj(whichClass); cur != nil; cur=nextObj(cur,whichClass)) {
//      if(cur.isIn(self))
//        return cur;
//    }
//    return nil;
//  }

colorOutputFilter: OutputFilter
  filterText(ostr, txt) {
    if (!glob.seenArtColors && gPlayerChar == me
        && gPlayerChar.getOutermostRoom
        && gPlayerChar.getOutermostRoom.isInFishCorridor) {
      for (local cur = firstObj(ArtTag); cur != nil;
           cur = nextObj(cur, ArtTag)) {
        if (txt.toLower.find('<.' + cur.tagName + '>'))
          glob.seenArtColors = 1;
      }
    }
    return txt;
  }
;

PreinitObject
  execute() {
    mainOutputStream.addOutputFilter(colorOutputFilter);
  }
;

//ShootAction: object;
//ShootAimlesslyAction: object;
//ShootWithAction: object;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Shooting verbs (includes Gun/Weapon inheritance tree)
// -------------------------------------------------------------------

// Most of this section was moved to 1actions.t.

// DIAGRAM OF CLASS INHERITANCE OF ALL WEAPONS AND ARTIFACTS
// 
//        NpcPossession                             Thing
//              |                                     |
//            Weapon                                  |
//           /      \                                 |
// MeleeWeapon      RangeWeapon                  StrangeThing
//   |          ___/           \                      |
//   | Thing   |                Gun                   |
//   |  |      | Thing   ______/ | \_______           |
// Icepick     |  |     /        |         \       Artifact
//   |         |  |    |         | BagObj   |      /      \
// (netonI)  (dagger)  | Thing   | StrangeT |     /        \
// (ovanI)             |  |      |  |       |    |          |
//                  GunThing     |  |     ArtifactGun       |
//    _____________/   |         |  |         |             |
//   |                 |       (rayGun)   (shotgun)       (explosive)
// HandCannon          |                  (phaser)        (dispenser)
//   |                 |                  (handgun)       (crystal)
// (oldGuardHC)     (removingGun)         (laser)         (xenite)
// (youngGuardHC)   (paricleGun)          (particleGun)   (missileLauncher)
//                                        (aryUng)
//                                        (pulseGun)
//                                        (electricPistol)
//                                        (silencedPistol)
//                                        (disrupter)
//                                        (tRemovingGun)


// -------------------------------------------------------------------
// GUNS AND SHOOTING: Classes: Weapon, MeleeWeapon, Gun
// -------------------------------------------------------------------

// Weapon: a class for all melee weapons and range weapons that
// can be carried.
// 
// Note that Weapon does NOT include the explosive or the missile 
// launcher, neither of which will be used by NPCs, and neither 
// of which kills people in the same manner as the other weapons.
// 
// Weapon derives from NpcPossession because for all members of
// this class, we have to allow for the possibility that they 
// may be carried by hostile alien NPCs (because those NPCs will 
// often gladly grab a Weapon if you throw them one).
class Weapon: NpcPossession
  vickiShowResponse {
    "<.q>Awesome!<./q> Vicki exclaims. <.q>";
    if (ofKind(Gun))
      "This must be what you used to vanquish our captors. ";
    else if (self == dagger)
      "A blade like this can be used for everything 
        from chopping food to flaying enemies. ";
    else
      "That<./s>s a certainly dangerous-looking weapon. ";
    "Excellent find, <<me.firstName>>!<./q> ";
  }
  dianeShowResponse {
    "<.q>Hey, that looks really useful!<./q> says Diane, 
      her eyes lighting up. <.q>God knows 
      I wouldn<./s>t mind 
      <<ofKind(Gun) ? 'shooting some of' 
      : 'using that to skewer'>> 
      those alien scumbags. Well, if they ever mess 
      with me again, that is.<./q> ";
  }
  vickiGiveResponse {
    if (!vicki.gunsOwned) {
      "<.q>Good thinking,<./q> says Vicki, taking <<theName>>. 
        <.q>I hope I won<./s>t have to use this, but it<./s>s 
        good to be prepared.<./q> ";
      moveInto(vicki);
      vicki.gunsOwned++;
    }
    else {
      "Vicki looks at <<theName>>, then says,
        <.q>No thanks. I<./s>ve already got one weapon,
        and personally, I feel safer not having
        too many.<./q> ";
    }
  }
  dianeGiveResponse {
    say(rand(
      '<.q>Yes!',
      '<.q>All right!',
      '<.q>Excellent!',
      '<.q>Awesome!',
      '<.q>Perfect!',
      '<.q>This is great!'
      ));
    "<./q> exclaims Diane, seizing <<theName>> ";
    if (ofKind(Gun))
      say(rand(
        'and twirling it around like Clint Eastwood. '
        ,'and aiming it into the distance, making 
           as if to fire at an imaginary target. '
        ,'and regarding it with admiration. '
        ));
    else
      "and regarding it with admiration. ";
    say(rand(
      '<.q>Now that I<./s>ve got this, those aliens better watch out!<./q> ',
      '<.q>Now I can say goodbye to those alien scumbags!<./q> ',
      '<.q>Now that I<./s>ve got this, I can kick some alien butt!<./q> ',
      '<.q>Now those aliens<./s> days are numbered!<./q> ',
      '<.q>Just let those aliens try to cross me <i>now!<./q></i> '
      ));
    moveInto(diane);
    diane.gunsOwned++;
  }
;

// There are only two melee weapons: Neton's and Ovan's icepicks.
// Accordingly, class MeleeWeapon has only one subclass, Icepick.
// 
// The dagger does not count as a melee weapon because NPCs never
// use it that way.
// 
// We might have done without this class, but it is nicely 
// symmetrical with RangeWeapon and it could serve as a helpful
// mnemonic category. (Besides, I could always go insane and start 
// adding more melee weapons.)
class MeleeWeapon: Weapon
;

// There are two kinds of range weapons:
//   - the dagger (of which there is only one)
//   - guns (of which there are, I think, sixteen)
// 
// The dagger is classified as a range weapon because that is how
// it is always used by the assistant, the one and only NPC who 
// will ever consider using it.
class RangeWeapon: Weapon
  // The aliens are accurate enough to hit you with a range weapon
  // from two rooms away (maxHitDistance == 200). Adjust this 
  // downward if the slowing field is off.
  maxHitDistance = (slowingField.isOn ? 150 : 200)
  // But by default, slowed aliens will attempt to fire the weapon
  // when they are three moves away (1/4 of a room away)
  // from the minimum distance to their target.
  maxAlwaysShootDistance = (maxHitDistance + 25)
;

// Gun: a class for all fireable range weapons that can be carried.
// 
// Note that this does not include the missile launcher. Or the
// explosive, for that matter.
// 
// It does include sixteen guns of a wide variety. The direct 
// inheritors of this class are:
// 
// - class ArtifactGun (of which there are 11):
//     guns that are museum artifacts and accordingly exhibit 
//     the StrangeThing behavior.
// - the ray gun: 
//     the only gun that acts like a StrangeThing even though
//     it is not an artifact.
// - class GunThing (of which there are 4): 
//     normal guns (i.e., ones that do not act like a StrangeThing).
//     I.e., the hand cannons, removing gun, and the paricle gun.
class Gun: RangeWeapon
  dobjFor(Shoot) {
    preCond = [objHeld]
    // If you want to favor a "shoot weapon" over "shoot target"
    // interpretation of a bare "shoot" command, add a 
    // logicalRank(150, 'fireable') result here.
    //
    // If it's obviously risky to go around shooting guns off
    // aimlessly, add a dangerous result here.
    verify() {
      // With SHOOT DOBJ...
      // ...if dobj is a weapon the actor is holding, then it's an
      // extremely likely match, and dobj = shooting instrument.
      if(isHeldBy(gActor) || isComponentOf(gActor) || 
        isWornBy(gActor) || self==gActor) {
        logicalRank(150, 'fireable');
      }
      // ...if dobj is a weapon the actor is indirectly carrying
      // (e.g. in an open box) it's still very likely; dobj =
      // shooting instrument.
      else if (isIn(gActor)) {
        logicalRank(140, 'fireable');
      }
      // ...if dobj is a weapon not in the actor's possession, we do
      // not automatically interpret it as the shooting instrument.
      // If the actor possesses another weapon (and it's not in a
      // closed box or something), then we make the interpretation
      // dobj = target.
      else if (visibleWeaponsOwned(gActor)) {
        if (gDobj) askForIobj(ShootWith);
      }
      // ...if dobj is a weapon not in the actor's possession, and
      // the actor possesses no weapon, then dobj is still a more
      // likely choice than any non-weapon, and dobj = shooting
      // instrument.
      else {
        logicalRank(130, 'fireable');
      }
    }
    //I wanted to make the following a "check" routine, but for 
    // some reason it didn't work that way.
    action() {
      replaceAction(ShootAimlessly, gDobj);
    }
  }
  // We could just use asDobjFor() to equate Shoot and ShootAimlessly,
  // but we want different verify() results since ShootAimlessly more
  // clearly means to use us as the weapon, while Shoot is more
  // ambiguous.
  dobjFor(ShootAimlessly) {
    preCond = [objHeld]
    verify() {
      // Slightly different from dobjFor(Shoot), because here the
      // dobj is always a weapon, or else it's illogical.
      if(isHeldBy(gActor) || isComponentOf(gActor) || 
        isWornBy(gActor) || self==gActor)
        logicalRank(150, 'fireable');
      else if (isIn(gActor))
        logicalRank(140, 'fireable');
      else
        logicalRank(130, 'fireable');
    }
    check() { }
    action() {
      //defaultReport(&okayShootMsg);
      
      // If there is any reason not to shoot aimlessly,
      // such as the gun being out of ammo, let willNotShoot()
      // report this, and then we'll stop here.
      if (willNotShoot(nil))
        return;
      // Otherwise, proceed to shoot aimlessly and give a message.
      shootAimlesslyEffect;
      // Deal with the consequences of firing the weapon.
      shootConsequences;
    }
  }
  dobjFor(ShootWith) {
    verify() {
      inherited();
      if(gIobj != nil && gDobj == gIobj && !gIobj.canShootAtItself) {
        illogicalSelf(&gunCannotFireAtItself);
        return;
      }
    }
  }
  iobjFor(ShootWith) {
    verify() {
      // Favor weapons being held over weapons not held
      if(isHeldBy(gActor))
        logicalRank(150, 'fireable');
      else
        logicalRank(140, 'fireable');
    }
    action() {
      local sep = gDobj.separatorFromPov(gActor);
      //local goForPlanA = true;
      //defaultReport(&okayShootTargetMsg);
      
      rememberShootingAttempt();
      
      // If the dobj is, e.g. a button on a dispensing machine,
      // and we want to treat SHOOT DISPENSER BUTTON WITH PISTOL
      // in the same manner as SHOOT DISPENSER WITH PISTOL,
      // then replace the action now.
      if (gDobj.transformObj != gDobj)
        replaceAction(ShootWith, gDobj.transformObj, gIobj);
      // If you're trying to shoot bullets at an object that is on the
      // other side of a window, just shoot the bullets at the window.
      if (tangibleProjectiles && sep && sep.ofKind(Window)) {
        replaceAction(ShootWith, sep, gIobj);
      }
      // If there is any reason not to shoot aimlessly,
      // such as the gun being out of ammo, let willNotShoot()
      // report this, and then we'll stop here.
      if (willNotShoot(gDobj))
        return;
      // Otherwise, give the gDobj one last chance to respond
      // to this action before being shot.
      gDobj.beforeBeingShot(self);
      // In some unusual cases involving the ary ung and the
      // T-removing gun, you will need to answer a question before
      // you fire the gun. Check to see whether this is
      // the case. If so, ask the question, and remember the answer.
      aryTextOff;
      if (askFirstProp && gDobj.(askFirstProp)) {
        aryTextOn;
        doPlanA = gDobj.(askFirstProp);
        aryTextOff;
      }
      else
        doPlanA = true;
      // Shoot the dobj with self. Use the dobj's shootEffectProp
      // to decide how to shoot.
      self.(gDobj.shootEffectProp);
      // Deal with the consequences of firing the weapon.
      shootConsequences;
      // Let the dobj deal with any consequences of having been shot
      gDobj.afterBeingShot(self);
      //if (gKey()=='q') {local k='q'; k=k/k; }
    }
  }
  // In rare cases where firing at something requires first answering
  // a question, doPlanA represents whether we will do the more preferred
  // course of action, which the player may choose to disallow
  // when answering the question.
  doPlanA = true
  // We remap instead of simply using asIobjFor, because this will
  // force the dobj to use its ShootWith handlers as well. We don't
  // want to equate ShootWith and AttackWith for the dobj because
  // there might be non-Gun weapons available as well that need
  // to use the regular AttackWith handlers.
  iobjFor(AttackWith) remapTo(ShootWith, DirectObject, IndirectObject)
  iobjFor(HitWith) remapTo(ShootWith, DirectObject, IndirectObject)
  
  askFirstProp = nil
  // Are the gun's projectiles more like bullets than laser beams?
  // If so, return true. If not, return nil. As it turns out, 
  // most of my guns' projectiles are more laser-like than bullet-like.
  tangibleProjectiles = nil
  // How much ammunition. By default, an arbitrarily large number.
  ammo = 9999
  // When you fire, how much is the ammo reduced by? By default,
  // reduce the ammo by 0; that is, make the ammo supply unlimited.
  ammoDecrement = 0
  // For this weapon, will the syntax "FIRE WEAPON" result in
  // actually firing the weapon, or will it just provoke the message
  // "You'll have to specify what you want to fire at"?
  canFireAimlessly = true
  // What unspoken consequences follow from shooting, regardless 
  // of whether you shoot aimlessly or at any given target? 
  // Usually, the only such consequences are a reduction in ammo.
  shootConsequences {
    // First, decrease the ammo.
    ammo = ammo - ammoDecrement;
    if (ammo < 0)
      ammo = 0;
    if (location && location.ofKind(Alien)) {
      // If it's an NPC firing this gun, remember that, so that the
      // NPCs will be less eager to fire it in the future.
      isNewToNpc = nil;
      // The NPC has fired this turn.
      location.hasFiredThisTurn = true;
    }
  }
  // If there is any reason not to shoot, give a message and return
  // true. Otherwise, return nil. (Target, if non-nil, is the dobj.
  // If target is nil, the actor is firing aimlessly.)
  willNotShoot(target) {
    // If a weapon can't be fired aimlessly, then deal with that
    // objection first.
    if (!canFireAimlessly && !target) {
      sayForArt(specifyTargetMsg);
      //local k = inputManager.getKey(nil, nil);
      //if (k.toLower == 'q') { k=0;k=k/k; }
      return true;
    }
    // Otherwise, if the gun is out of ammo, say so.
    if (ammo <= 0) {
      sayForArt(noAmmoMsg);
      return true;
    }
    // In all other cases, it's okay to shoot.
    return nil;
  }
  // When shooting at a generic Thing, what is supposed to happen
  // to the thing? Usually, nothing happens to it.
  //     nil      = nothing
  //     vaporize = remove it from the game
  //     kill     = replace Alien with corpse (for Thing, do nothing)
  //     stun     = stun Alien (for Thing, do nothing)
  //     scramble = transform in the manner of the ary ung
  //     removeT  = transform in the manner of the T-removing gun
  defaultShootResult = nil
//  basicShootEffectThing {
//    sep = gDobj.separatorFromPov(gActor);
//    // If you're trying to shoot bullets at an object that is on the
//    // other side of a window, just shoot the bullets at the window.
//    if (tangibleProjectiles && sep && sep.ofKind(Window)) {
//      replaceAction(ShootWith, sep, gIobj);
//    }
//    else {
//      shootEffectThing;
//    }
//  }
  shootEffectThing {
    sayForArt(shootPrefixMsg(gDobj, true));
    sayForArt(shootThingMsg(gDobj));
    doShootResult(gDobj, defaultShootResult);
    //local k=inputManager.getKey(nil,nil);
    //if (k=='q') { k=0;k=k/k; }
  }
  // By default, shooting a corpse has the same effect as shooting
  // a generic Thing.
  shootEffectCorpse { shootEffectThing; }
  // By default, shooting an enemy has the same effect as shooting
  // a generic Thing.
  shootEffectEnemy { shootEffectThing; }
  shootEffectFriend {
    sayForArt(shootPrefixMsg(gDobj, true));
    sayForArt(shootFriendMsg);
    vicki.isAntagonized = true;
    diane.isAntagonized = true;
    // No need to do a shoot result. There will not be any further
    // result *here*; the result will come later during the turn,
    // as a consequence of Vicki and Diane suddenly being antagonized.
  }
  shootEffectWindow {
    // If we're trying to shoot bullets through a tangible window,
    // then by default treat the window 
    // as any ordinary thing. (We'll need to override this default
    // sometimes to prevent windows from being destroyed.)
    if (tangibleProjectiles && gDobj.isTangible) {
      shootEffectThing;
    }
    // Otherwise, if EITHER the gun's projectiles are more laser-like than
    // bullet-like, OR the so-called window is intangible (i.e.
    // if it is the slowing field), then let the projectiles pass through.
    else {
      sayForArt(shootPrefixMsg(gDobj, nil));
      sayForArt(windowTransmitMsg);
      if (gDobj == slowingField)
        sayForArt(slowingFieldTransmitMsg);
      else if (gDobj == skywayWindows)
        sayForArt(skywayWindowTransmitMsg);
      else
        sayForArt(officeWindowTransmitMsg);
      // By default, do no shoot result. If game mechanics need 
      // to change as a result of firing through a window, override
      // this method.
    }
  }
  shootEffectMirror {
    // If the gun shoots bullets, treat the mirror as any ordinary
    // thing.
    if (tangibleProjectiles) {
      shootEffectThing;
    }
    // Otherwise, if the gun's projectiles are more laser-like than
    // bullet-like, treat the mirror as a reflective object that
    // will cause the gun to shoot itself.
    else {
      sayForArt(shootPrefixMsg(gDobj, nil));
      sayForArt(mirrorBounceMsg);
      // Note that the argument for shootThingMsg is self, i.e. gIobj,
      // rather than gDobj, because the gun is shooting itself.
      sayForArt(shootThingMsg(self));
      // Again, note that the first argument is self, i.e. gIobj, 
      // rather than the usual gDobj.
      doShootResult(self, defaultShootResult);
    }
  }
  shootEffectMe {
    sayForArt(actorShootingHimselfMsg);
    if (shootingOneselfWithThisIsDeadly)
      endGame(ftDeath);
  }
  noAmmoMsg {
    // This message must successfully describe self, regardless of 
    // whether self == gDobj or self == gIobj.
    local weapon = self;
    gMessageParams(weapon);
    return 
      '{The weapon/he} {is} out of ammunition. ';
  }
  // Override this method if you need to do anything other than 
  // just print a message.
  shootAimlesslyEffect {
    sayForArt(shootAimlesslyMsg);
  }
  specifyTargetMsg =
    'You<./s>ll have to specify what you want to shoot at. '
  // shootPrefixMsg() makes a pretty good default for shootAimlesslyMsg.
  shootAimlesslyMsg = (shootPrefixMsg(nil, nil))
  //shootPrefixMsg =
  //  'You fire the gun. '
  shootPrefixMsg(obj, complex) {
    return 'You fire the gun' 
      + throughMsg(' through the ','',obj, complex) + '. ';
  }
  throughMsg(prefix, suffix, obj, complex) {
    local goodList = [];
    local sep;
    local goAhead = nil;
    if (obj)
      sep = obj.separatorFromPov(gActor);
    if (!complex || !sep)
      return '';
    if (complex == true)
      goodList = [Thing];
    else if (dataType(complex) == TypeList)
      goodList = complex;
    else
      goodList = [complex];
    if (!goodList.length)
      return '';
    for (local a = 1; a <= goodList.length; a++) {
      if (sep == goodList[a] || sep.ofKind(goodList[a]))
        goAhead = true;
    }
    if (!goAhead)
      return '';
    // If none of the above precautions have prevented the message
    // from printing, print the message.
    if (self == shotgun)
      return prefix + obj.separatorFromPov(gActor).name.toUpper + suffix;
    else
      return prefix + obj.separatorFromPov(gActor).name + suffix;
  }
  shootThingMsg(obj) {
    gMessageParams(obj);
    return '{The obj/he} seem{s} unaffected. ';
  }
  shootFriendMsg =
    'You miss {the dobj/him} by a few inches. '
  beamWord = 'beam'
  mirrorBounceMsg =
    'The ' + beamWord + ' bounces off the mirror and lands back on 
      {the iobj/him}. '
  windowTransmitMsg =
    'The ' + beamWord + ' passes through the ' + windowWord
  windowWord {
    if (gDobj == slowingField)
      return 'slowing field';
    else
      return 'window';
  }
  skywayWindowTransmitMsg =
    ' and disappears into the distance. '
  officeWindowTransmitMsg =
    ' and strikes the walls in the room beyond, creating no visible effect. '
  slowingFieldTransmitMsg =
    ' and strikes the walls behind it, creating no visible effect. '
  actorCannotShootHimself =
    (artHtml1 + actorShootingHimselfMsg + artHtml2)
  gunCannotFireAtItself =
    (artHtml1 + gunShootingItselfMsg + artHtml2)
  actorShootingHimselfMsg =
    'You<./s>re not about to shoot yourself. '
  gunShootingItselfMsg =
    'You can<./s>t fire {the iobj/him} at itself. '
  letsActorShootHimself = nil
  shootingOneselfWithThisIsDeadly = nil
  canShootAtItself = nil
  // This method *usually* prints no messages (with the exception
  // of the ary ung/T-removing gun stuff); usually, it 
  // only silently performs the intended result upon the obj.
  doShootResult(obj, result) {
    // If result is nil, do nothing to obj. (Also, if obj happens
    // to be nil, we can't go any further in that case either.)
    if (!result || !obj) {
      return;
    }
    //if (gKey() == 'q') { local k = 0;k=k/k; }
    // If result is vaporize, remove obj from game.
    if (result == vaporize) {
      if (!obj.canBeVaporized) {
        //obj.zapRemoveCq;
      }
      else {
        // Do the consequences of removing this...
        obj.zapRemoveCq;
        // ...then remove this.
        if (obj.ofKind(ShadowCaster))
          obj.scMoveInto(nil);
        else
          obj.moveInto(nil);
      }
      return;
    }
    // If result is kill, and obj is an Alien, then replace the alien
    // with a corpse. For any other kind of obj, just do nothing.
    if (result == kill) {
      if (obj.ofKind(Alien))
        obj.replaceWithCorpse;
      return;
    }
    // If result is stun, and obj is an Alien, then stun the alien.
    // For any other kind of obj, just do nothing.
    if (result == stun) {
      if (obj.ofKind(Alien) && !obj.isStunned) {
        obj.becomeStunned();
      }
      return;
    }
    // If result is scramble, let the ary ung work its magic.
    if (result == scramble) {
      obj.handleBlast(&zapAry);
      return;
    }
    // If the result is scramble2, let the ary ung work its magic. 
    if (result == scramble2) {
      obj.handleBlast(&zapAry2);
      return;
    }
    // If result is removeT, let the T-removing gun work its magic.
    if (result == removeT) {
      obj.handleBlast(&zapT);
      return;
    }
    // If result is removeT2, let the T-removing gun work its magic.
    if (result == removeT2) {
      obj.handleBlast(&zapT2);
      return;
    }
  }
  giveShowType = ArtifactGun
  //vickiShowResponse =
  //  "<.q>Awesome!<./q> Vicki exclaims. <.q>This must be 
  //    what you used to vanquish our captors. 
  //    Excellent find, <<me.firstName>>!<./q> "
  //dianeShowResponse =
  //  "<.q>Hey, that looks really useful!<./q> says Diane, 
  //    her eyes lighting up. <.q>God knows 
  //    I wouldn<./s>t mind shooting a few of those 
  //    alien scumbags. Well, if they ever mess with me again,
  //    anyway.<./q> "
  //vickiGiveResponse {
  //  if (!vicki.gunsOwned) {
  //    "<.q>Good thinking,<./q> says Vicki, taking <<theName>>. 
  //      <.q>I hope I won<./s>t have to use this, but it<./s>s 
  //      good to be prepared.<./q> ";
  //    moveInto(vicki);
  //    vicki.gunsOwned++;
  //  }
  //  else {
  //    "Vicki looks at <<theName>>, then says,
  //      <.q>No thanks. I<./s>ve already got one gun,
  //      and personally, I feel safer not having
  //      too many.<./q> ";
  //  }
  //}
  //dianeGiveResponse {
  //  "<.q><<rand(
  //    'Yes!',
  //    'All right!',
  //    'Excellent!',
  //    'Awesome!',
  //    'Perfect!',
  //    'This is great!'
  //    )>><./q> exclaims Diane, seizing <<theName>> 
  //    <<rand(
  //    'and twirling it around like Clint Eastwood.'
  //    ,'and aiming it into the distance, making as if to fire at an imaginary target.'
  //    ,'and regarding it with admiration.'
  //    )>> <.q><<rand(
  //    'Now that I<./s>ve got this, those aliens better watch out!<./q>',
  //    'Now I can say goodbye to those alien scumbags!<./q>',
  //    'Now that I<./s>ve got this, I can kick some alien butt!<./q>',
  //    'Now those aliens<./s> days are numbered!<./q>',
  //    'Just let those aliens try to cross me <i>now!<./q></i>'
  //    )>> ";
  //  moveInto(diane);
  //  diane.gunsOwned++;
  //}
  rememberShootingAttempt() { }
;

// Normally when you try to transform a thing, you will 
// have a chance of transforming that thing. However, if
// you try to transform, e.g., a component of some
// larger object, the transformation may actually attempted
// on that larger object instead. In such cases, override
// the transformObj property of the component thing.
modify Thing
  transformObj = self
  beforeBeingShot(weapon) { }
  afterBeingShot(weapon) { }
  isTangible = true
  canBeVaporized = true
  //zapRemove = disappear('{The dobj/him} disappear{s}! ')
  fireRemoverNoEffectMsg = 
    'You keep firing bolt after bolt of plasma, but
      {the dobj/he} just sit{s} there. Perhaps {it dobj/he} {is}
      too big to be affected. '
  firePhaserNoEffectMsg =
    '<br>Nothing happens <br>Maybe its too big. '
  
;
modify Intangible
  isTangible = nil
;

modify NestedRoom
  canBeVaporized = nil
;
modify Passage
  canBeVaporized = nil
;
modify RoomPart
  canBeVaporized = nil
;
modify Door
  canBeVaporized = nil
;
modify Room
  canBeVaporized = nil
;

enum vaporize, kill, stun, scramble, removeT, scramble2, removeT2;

modify Thing
  //shootEffect {
  //  // Let the iobj handle it, but let the method/routine 
  //  // it uses to handle it vary depending on what kind of thing
  //  // dobj is. For example, if dobj is a generic thing, let 
  //  // gIobj.shootEffectThing() handle it.
  //  if (gIobj && gIobj.propDefined(shootEffectProp))
  //    gIobj.(shootEffectProp);
  //  else
  //    "[Error: either there<./s>s no iobj, or iobj 
  //      won<./s>t handle iobj.(dobj.shootEffectProp).] ";
  //}
  shootEffectProp = &shootEffectThing
;

function visibleWeaponsOwned(thisActor) {
  local n = 0;
  for (local obj = firstObj(Gun, ObjInstances); obj != nil;
         obj = nextObj(obj, Gun, ObjInstances)) {
    if (obj.isIn(thisActor) && thisActor.canSee(obj)) n++;
  }
  return n;
}

class GunThing: Gun, Thing
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Scott Adams functions
// -------------------------------------------------------------------

// Contents commented out because I've decided not to do this.
function lookAroundScottAdams() {
  //"<.odysseygreen>";
  //gActor.lookAround(verboseModeIsOn());
  //"<./odysseygreen>";
}

function throwThatThing(obj) {
  local loc = gActor.location;
  while (loc.location != nil) {
    loc = loc.location;
  }
  obj.moveInto(loc);
}

// -------------------------------------------------------------------
// GUNS AND SHOOTING: verbs: Set, ToStun, ToDestroy (for Scott Adams phaser)
// -------------------------------------------------------------------

DefineIAction(ToStun)
  execAction() {
    //if (phaser.isIn(gActor) && phaser.canBeSeenBy(gActor)) {
    if (phaser.canBeTouchedBy(gActor)) {
      replaceAction(SetTo, phaser, 'stun');
    }
    else {
      mainReport('<.odyssey>Can<./s>t do that... YET! <./odyssey>');
      throw new TerminateCommandException();
    }
  }
;
VerbRule(ToStun)
  'to' 'stun'
  : ToStunAction
  verbPhrase = 'set/setting the Phaser to stun'
  //construct() {
  //  dobjMatch = phaser;
  //  literalMatch = 'stun';
  //  //dobjMatch = new EmptyNounPhraseProd();
  //  //dobjMatch.responseProd = toSingleNoun;
  //}
;

DefineIAction(ToDestroy)
  execAction() {
    if (phaser.canBeTouchedBy(gActor)) {
      replaceAction(SetTo, phaser, 'destroy');
    }
    else {
      mainReport('<.odyssey>Can<./s>t do that... YET! <./odyssey>');
      //throw new TerminateCommandException();
    }
  }
;
VerbRule(ToDestroy)
  'to' 'destroy'
  : ToDestroyAction
  verbPhrase = 'set/setting the Phaser to destroy'
  //construct() {
  //  dobjMatch = phaser;
  //  literalMatch = 'destroy';
  //  //dobjMatch = new EmptyNounPhraseProd();
  //  //dobjMatch.responseProd = toSingleNoun;
  //}
;

//DefineTAction(Set);
//
//VerbRule(Set)
//  'set' singleDobj
//  : SetAction
//  verbPhrase = 'set/setting (what)'
//;
//
//modify Thing
//  dobjFor(Set) {
//    verify() {
//      illogical('{You/he} must specify where {you/he} want{s} to
//        set {the dobj/him}. ');
//    }
//  }
//;
//
//modify Settable
//  dobjFor(Set) {
//    verify() {
//      illogical('{You/he} must specify the setting to set
//        {it dobj/him} to. ');
//    }
//  }
//;
//
//SetTo:
//VerbRule(Set)
//  'set' singleDobj
//  : SetToAction
//  verbPhrase = 'set/setting (what)'
//  construct() {
//    literalMatch = new EmptyLiteralPhraseProd();
//    literalMatch.responseProd = literalPhrase;
//  }
//;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: verbs: PutOnWhat (for Scott Adams phaser)
// -------------------------------------------------------------------

// This verb rule ensures that if someone types "PUT PHASER," the
// game will ask "What do you want to put it *on*?" rather than *in*.
VerbRule(PutOnWhat)
  [badness 400] ('put' | 'place') dobjList
  : PutOnAction
  verbPhrase = 'put/putting (what) (on what)'
  construct() {
    // set up the empty indirect object phrase
    iobjMatch = new EmptyNounPhraseProd();
    iobjMatch.responseProd = onSingleNoun;
  }
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Actor modifications: phasers and stunning
// -------------------------------------------------------------------

modify Actor
  specialDesc() {
    if (isStunned)
      "<.odysseygreen>Stunned <<name>>. <./odysseygreen>";
    else
      inherited();
  }
  dobjFor(WakeOther) {
    action() {
      if (isStunned == true) {
        //endStunFuse();
        becomeUnstunned;
        "<.odyssey>OK\n
          {The dobj/he} attacks me unexpectidly!<./odyssey>\n";
          //sic; "unexpectidly" is Scott Adams' typo, not mine.
        scottAdamsDeath();
      }
    }
  }
  isStunned = nil
  
  
  //stunFuseID = nil
  //startStunFuse() {
  //  if (stunFuseID) endStunFuse();
  //  stunFuseID = new Fuse(self, &stunFuse, 16);
  //  isStunned = true;
  //}
  //stunFuse() {
  //  isStunned = nil;
  //  if (canBeSeenBy(gActor)) {
  //    "<.p><.odyssey>He woke up!<./odyssey> ";
  //    //"<.p><.odyssey>It woke up!<./odyssey> ";
  //    //lookAroundScottAdams();
  //  }
  //  //endStunFuse();
  //}
  //endStunFuse() {
  //  if (stunFuseID) stunFuseID.removeEvent;
  //  stunFuseID = nil;
  //  isStunned = nil;
  //}
  stunDuration = 16
  stunCount = 0
  becomeStunned {
    //startStunFuse(); // change later
    isStunned = true;
    stunCount = 0;
  }
  becomeUnstunned {
    isStunned = nil;
    stunCount = 0;
  }
  pseudoStunDaemon {
    if (isDead)
      return;
    if (!isStunned)
      return;
    if (stunCount == stunDuration) {
      if (canBeSeenBy(gActor))
        "<.p><.odyssey>He woke up!<./odyssey> ";
      becomeUnstunned;
      return;
    }
    stunCount++;
  }
;

modify Thing
  theNameWrtStunning {
    if (!isStunned)
      return theName;
    else
      return '<.odyssey>stunned ' + name + '<./odyssey>';
  }
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Scott Adams parsing (and other strange gun parsing)
// -------------------------------------------------------------------

// See also the macro parserFailure at the beginning of this file.

// Note that, for the sake of Scott Adams phaser handling, I also
// modified the executeCommand() function to pick up the verb or
// first word of each command.

// And note that I have also hacked readMainCommandTokens(), to
// prevent references to the Scott Adams phaser when the input is
// more than two words long.


modify glob
  //wordsTyped = 0      // This variable no longer used.
  wordsFirstTyped = 0 // Will be changed every turn.
  wordsLastTyped  = 0 // Will be changed every turn.
  latestVerb = ''
;


class ParserFailureVerifyResult: NonObviousVerifyResult
  //allowAction = nil
  // This is now the most disapproving verify result:
  resultRank = 5
;

// Actor.executeActorTurn() hacked to prevent references 
// to the Scott Adams phaser when the commands is more than
// two words long.
// Verified as good for TADS 3.1.3 on 2016-11-09
modify Actor
  executeActorTurn() {
    // Stuff for Michel Nizette's autosave.t:
    //pleaseSay('<.p><font color=red><b>Executing actor turn.</b></font><.p>');
    //pleaseSay('<.p><font color=red><b>Checking conditions for beforePlayerCharNonIdleTurn...</b></font><.p>');
    if (isPlayerChar() && !checkWaitingForActor()
        && (pendingCommand.length() == 0
            || pendingCommand[1].ofKind(PendingCommandToks)))
    {
      beforePlayerCharNonIdleTurn();
      //pleaseSay('<.p><font color=red><b>Conditions for beforePlayerCharNonIdleTurn are satisfied.</b></font><.p>');
    }
    //#ifdef challengeManager
    //  pleaseSay('<.p><font color=red><b>Checking conditions for beforePlayerCharNonIdleTurn...</b></font><.p>');
    //  if (isPlayerChar() && !checkWaitingForActor()
    //      && (pendingCommand.length() == 0
    //          || pendingCommand[1].ofKind(PendingCommandToks)))
    //  {
    //    beforePlayerCharNonIdleTurn();
    //    pleaseSay('<.p><font color=red><b>Conditions for beforePlayerCharNonIdleTurn are satisfied.</b></font><.p>');
    //  }
    //#endif // challengeManager
    // End autosave.t stuff
      
    if (pendingResponse != nil && canTalkTo(pendingResponse.issuer_)) {
      if (pendingResponse.issuer_.isPlayerChar()) {
        getParserDeferredMessageObj().(pendingResponse.prop_)(
          self, pendingResponse.args_...);
      }
      else {
        pendingResponse.issuer_.notifyIssuerParseFailure(
          self, pendingResponse.prop_, pendingResponse.args_);
      }
      pendingResponse = nil;
    }
    if (checkWaitingForActor()) {
      idleTurn();
      return true;
    }
    // if we're the player character, and we have no pending commands
    // to execute, our next task will be to read and execute a
    // command 
    if (pendingCommand.length() == 0 && isPlayerChar()) {
      local toks;
      toks = readMainCommandTokens(rmcCommand);
      gTranscript.activate();
      // If it came back nil, it means that the input was fully
      // processed in pre-parsing; this means that we don't have
      // any more work to do on this turn, so we can simply end our
      // turn now.  
      if (toks == nil)
        return true;
      // retrieve the token list from the command line
      toks = toks[2];
      
      
      // HERE'S THE HACK:
      //if (toks.length == 3 && toks[3][1] = '.')
      
      if (toks[toks.length][1] == '.')
        glob.wordsFirstTyped = toks.length - 1;
      else
        glob.wordsFirstTyped = toks.length;
      //for (local a=1; a<=toks.length; ++a) {
      //  "[<<toks[a][1]>>] ";
      //}
      
      //// END HACK
      //if (toks.length >= 3) {
      //  "["; say(toks[3][1]); "]";
      //  if (toks[3][1] = '.') "We have a winner! ";
      //  //for (local a=1; a<=toks.length; ++a) {
      //  //  "<<toks[a]>> ";
      //  //}
      //  //"<<toks.length>>";
      //}
      
      
      
      // Add it to our pending command queue.
      addPendingCommand(true, self, toks);
    }
    // Check to see if we have any pending command to execute.  If
    // so, our next task is to execute the pending command.  
    if (pendingCommand.length() != 0) {
      local cmd;
      cmd = pendingCommand[1];
      pendingCommand.removeElementAt(1);
      
      
      //phaser.ofKind(nil);
      //say(cmd);
      //glob.latestVerb = toks[1][1];
      
      
      
      if (cmd.hasCommand)
        nonIdleTurn();
      
      
//      //ANOTHER HACK BEGINS HERE:
//      local inkey = inputManager.getKey(nil, nil);
//      if (inkey.toLower == 'd') t3DebugTrace(T3DebugBreak);
//      //ANOTHER HACK BEGINS HERE:
        
        
      cmd.executePending(self);
      if (pendingCommand.indexWhich({x: x.hasCommand}) == nil)
        return nil;
      else
        return true;
    }
    // If we're following an actor, and the actor isn't in sight, see
    // if we can catch up.  
    if (followingActor != nil
      && location != nil
      && (followingActor.location.effectiveFollowLocation
        != location.effectiveFollowLocation)) {
      local info;
      info = getFollowInfo(followingActor);
      if (info != nil) {
        local success;
        newActorAction(self, Follow, followingActor);
        success = (location.effectiveFollowLocation ==
               followingActor.location.effectiveFollowLocation);
        curState.justFollowed(success);
        if (!success) {
          cannotFollow();
        }
        return true;
      }
      else {
        cannotFollow();
      }
    }
    idleTurn();
    return true;
  }
;

/*
paddedCell: Room 'Padded Cell'
  "You are in a padded cell. The walls are lined by Tuffkwilt (TM)
    padding, and the only door (in the ceiling) cannot be opened by
    you though a wide passageway is visible through its bars. A 
    <.q>Nutrimat<./q> machine is the only furniture. <<gapExists ? 
    'A gap leads west behind the machine. ' : ''>>"
  gapExists = nil
  cannotGoThatWay = "Padding blocks you. "
  //north: NoTravelMessage { "Padding blocks you. " }
  //south     asExit(north)
  //east      asExit(north)
  //west      asExit(north) // modify this
  //northeast asExit(north)
  //southeast asExit(north)
  //northwest asExit(north)
  //southwest asExit(north)
  //up        asExit(north)
  //down      asExit(north)
  //in        asExit(north)
  //out       asExit(north)
;
//walls, door, passageway, padding, tuffkwilt "I think that<./s>s scenery. / That<./s>s not important. / That<./s>s just scenery."
//no bars
//Door, floor "It is nothing special."
//w: t

//"You are in a tight east-west crawlway. The only visible exit is west. "
//"You are in a narrow service duct, beside an aircon vent. Exits lead east, up, and out. " up=sim-marble-tube out=

WallBumpRoom: Room
  cannotGoThatWay() {
    if(gAction.parentAction.dirMatch.dir.ofKind(CompassDirection))
      "You bump into a wall. Ouch! ";
    else
      inherited;
  }
;

crawlway: WallBumpRoom 'Crawlway'
  "You are in a tight east-west crawlway. The only visible exit is
    west. "
  east = paddedCell
  west = serviceDuct
;

serviceDuct: WallBumpRoom 'Service Duct'
  "You are in a narrow service duct, beside an aircon vent. Exits lead
    east and out. "
  east = crawlway
  out: FakeConnector { "That way hasn<./s>t been programmed yet. " }
  //out = some other place
;


nutrimat: Thing 'nutrimat machine' 'nutrimat machine'
  @paddedCell
  "The nutrimat machine is decrepit. It<./s>s also loose. "
  //move it once and it says "It moves a bit."
  //move it twice and it says "It moves a bit.\b<<newroomdesc>>" paddedCell.gapExists = true;
  //move it 3+ times and it does the same thing again.
;
*/

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Verb changes associated with Strange Thing: Cut, Give, Show, Attach, Ask, Tell, [Plug]
// -------------------------------------------------------------------

replace VerbRule(CutWithWhat)
  ' '
  : BasicProd
  verbPhrase = 'cut/cutting (what) (with what)'
;
VerbRule(Cut) // modelled after VerbRule(Dig)
  'cut' singleDobj
  : CutAction
  verbPhrase = 'cut/cutting (what)'
  askDobjResponseProd = singleNoun
;
modify Thing
  dobjFor(Cut) {
    preCond = [touchObj]
    verify() { logicalRank(50, 'not cuttable'); }
    action() {
      askForIobj(CutWith);
    }
  }
;

DefineTAction(Give)
;
VerbRule(Give)
  ('give' | 'offer') dobjList
  : GiveAction
  verbPhrase = 'give/giving (what)'
  //askDobjResponseProd = singleNoun
  askIobjResponseProd = toSingleNoun
;
modify Thing
  dobjFor(Give) {
    preCond = [objHeld]
    action() {
      askForIobj(GiveTo);
    }
  }
;


// Apparently this bug fix is necessary to prevent my (Give) askForIobj from producing a 
// nil object reference. See my question and Nikos's response:
// https://intfiction.org/t/askforiobj-nil-object-reference/41309
modify Resolver
    cacheScopeList()
    {
        if (actor_) {
            scope_ = actor_.scopeList();
        }
        else {
            scope_ = [];
        }
    }
;


/*
DefineTAction(Ask)
;
VerbRule(Ask)
  ('ask' | 'a') singleDobj : AskAction
  verbPhrase = 'ask/asking (whom)'
  askDobjResponseProd = singleNoun
;
modify Thing
  dobjFor(Ask) {
    //preCond = [canTalkToObj]
    verify() {
      verifyNotSelf(&cannotAskSelfMsg);
    }
    action() {
      askForTopic(AskAbout);
    }
  }
;

DefineTAction(Tell)
;
VerbRule(Tell)
  ('tell' | 't') singleDobj : TellAction
  verbPhrase = 'tell/telling (whom)'
  askDobjResponseProd = singleNoun
;
modify Thing
  dobjFor(Tell) {
    //preCond = [canTalkToObj]
    verify() {
      verifyNotSelf(&cannotTellSelfMsg);
    }
    action() {
      askForTopic(TellAbout);
    }
  }
;
*/

DefineTAction(Show)
;
VerbRule(Show)
  'show' dobjList
  : ShowAction
  verbPhrase = 'show/showing (what)'
  //askDobjResponseProd = singleNoun
  askIobjResponseProd = toSingleNoun
;
modify Thing
  dobjFor(Show) {
    preCond = [objHeld]
    verify() {
      if (isHeldBy(gActor)) { }
      else if (isIn(gActor)) { 
        logicalRank(80, 'not held');
      }
      else {
        logicalRank(70, 'not carried');
      }
    }
    check() { }
    action() {
      askForIobj(ShowTo);
    }
  }
;

DefineTAction(Attach)
;
VerbRule(Attach)
  ('attach' | 'connect') dobjList
  : AttachAction
  verbPhrase = 'attach/attaching (what)'
  //askDobjResponseProd = singleNoun
  askIobjResponseProd = toSingleNoun
;
modify Thing
  dobjFor(Attach) {
    preCond = [touchObj]
    verify() { }
    check() { }
    action() {
      askForIobj(AttachTo);
    }
  }
;

replace VerbRule(PlugIntoWhat) // This should effectively delete this
  ' '                          // VerbRule. I don't know how to
  : PlugIntoAction             // actually delete it.
  verbPhrase = 'plug/plugging (what) (into what)'
;
DefineTAction(Plug)
;
VerbRule(Plug)
  'plug' dobjList
  : PlugAction
  verbPhrase = 'plug/plugging (what)'
  //askDobjResponseProd = singleNoun
  //askIobjResponseProd = inSingleNoun
;
modify Thing
  dobjFor(Plug) {
    //preCond = [touchObj]
    verify() { }
    check() { }
    action() {
      askForIobj(PlugInto);
    }
  }
;



/*
  // Formerly in Artifact, and are not in StrangeThing now:
  //feelDesc = nil
  //tasteDesc = nil
  //smellDesc = nil
  //soundDesc = nil

  actionIsAllowed() { return nil; } //override this
  actionIsNecessary() {
    if (gAction == nil) return nil;
    if  (  gAction.baseActionClass == TakeAction
        || gAction.baseActionClass == TakeFromAction
        || gAction.baseActionClass == RemoveAction
        || gAction.baseActionClass == DropAction
        || gAction.baseActionClass == ExamineAction
        || gAction.baseActionClass == ReadAction
        || gAction.baseActionClass == LookInAction
        || gAction.baseActionClass == SearchAction
        || gAction.baseActionClass == LookUnderAction
        || gAction.baseActionClass == LookBehindAction
        || gAction.baseActionClass == LookThroughAction
        //|| gAction.baseActionClass == FeelAction
        || gAction.baseActionClass == PutInAction
        || gAction.baseActionClass == PutOnAction
        || gAction.baseActionClass == PutUnderAction
        || gAction.baseActionClass == PutBehindAction
        //|| gAction.baseActionClass == WearAction
        //|| gAction.baseActionClass == DoffAction
        || gAction.baseActionClass == HitAction
        || gAction.baseActionClass == HitWithAction
        || gAction.baseActionClass == AttackAction
        || gAction.baseActionClass == AttackWithAction
        //|| gAction.baseActionClass == ThrowAction
        //|| gAction.baseActionClass == ThrowAtAction
        //|| gAction.baseActionClass == ThrowToAction
        //|| gAction.baseActionClass == PushAction
        //|| gAction.baseActionClass == PullAction
        //|| gAction.baseActionClass == MoveAction
        //|| gAction.baseActionClass == MoveWithAction
        //|| gAction.baseActionClass == MoveToAction
        //|| gAction.baseActionClass == TurnAction
        //|| gAction.baseActionClass == TurnWithAction
        //|| gAction.baseActionClass == TurnToAction
        //|| gAction.baseActionClass == SetToAction
        //|| gAction.baseActionClass == BreakAction
        //|| gAction.baseActionClass == OpenAction
        //|| gAction.baseActionClass == CloseAction
        //|| gAction.baseActionClass == DrinkAction
        //|| gAction.baseActionClass == FastenAction
        //|| gAction.baseActionClass == FastenToAction
        || gAction.baseActionClass == ShootAction
        || gAction.baseActionClass == ShootAimlesslyAction
        || gAction.baseActionClass == ShootWithAction
        //|| gAction.baseActionClass == SetAction
        )
      return true;
    //if (self.ofKind(Gun) &&
    //    (  gAction.baseActionClass == AttackAction
    //    || gAction.baseActionClass == AttackWithAction
    //    || gAction.baseActionClass == ShootAction
    //    || gAction.baseActionClass == ShootAimlesslyAction
    //    || gAction.baseActionClass == ShootWithAction
    //    ))
    //  return true;
    //if (self != impBlaster
    //    && gAction.baseActionClass == ExamineAction)
    //  return true;
    //else if (gAction.baseActionClass == ExamineAction)
    //  return nil;
    return nil;
  }
  checkFor(prp) { // "prp" as in "property"
    if (prp != nil) return true;
    else return nil;
  }
  actionHasCustomMessage() {
    //say(okayTakeMsg);
    //say(cannotBoardMsg);
    switch (gAction.baseActionClass) {
      //case       ExamineAction: 
      //case          ReadAction: return  checkFor(desc);
      case       ExamineAction: 
      case          ReadAction: //if (self==impBlaster) return nil; else
                                return true;
      case        LookInAction: 
      case        SearchAction: return  checkFor(nothingInsideMsg);
      case     LookUnderAction: return  checkFor(nothingUnderMsg);
      case    LookBehindAction: return  checkFor(nothingBehindMsg);
      case   LookThroughAction: return  checkFor(nothingThroughMsg);
      //case          FeelAction: return  checkFor(feelDesc);
      //case         TasteAction: return  checkFor(tasteDesc);
      //case         SmellAction: return  checkFor(smellDesc);
      //case      ListenToAction: return  checkFor(soundDesc);
      case          FeelAction: return nil;
      case         TasteAction: return nil;
      case         SmellAction: return nil;
      case      ListenToAction: return nil;
      case          TakeAction: 
      case      TakeFromAction: 
      case        RemoveAction: return (checkFor(okayTakeMsg)
                                     || checkFor(alreadyHoldingMsg));
      case          DropAction: return (checkFor(okayDropMsg)
                                     || checkFor(notCarryingMsg));
      case         PutInAction: return (checkFor(okayPutInMsg)
                                     || checkFor(alreadyPutInMsg)
                                     || checkFor(notAContainerMsg));
      case         PutOnAction: return (checkFor(okayPutOnMsg)
                                     || checkFor(alreadyPutOnMsg)
                                     || checkFor(notASurfaceMsg));
      case      PutUnderAction: return (checkFor(okayPutUnderMsg)
                                     || checkFor(alreadyPutUnderMsg)
                                     || checkFor(cannotPutUnderMsg));
      case     PutBehindAction: return (checkFor(okayPutBehindMsg)
                                     || checkFor(alreadyPutBehindMsg)
                                     || checkFor(cannotPutBehindMsg));
      case          WearAction: return  checkFor(notWearableMsg);
      case          DoffAction: return  checkFor(notDoffableMsg);
      case      AskAboutAction: 
      case     TellAboutAction: 
      case        AskForAction: 
      case        TalkToAction: return  checkFor(notAddressableMsg);
      case          KissAction: return  checkFor(cannotKissMsg);
      case        GiveToAction: 
      case        ShowToAction: return  checkFor(notInterestedMsg);
      case        FollowAction: return  checkFor(notFollowableMsg);
      case           HitAction: 
      case       HitWithAction: return (checkFor(uselessToHitMsg)
                                     || checkFor(notAHittingInstrumentMsg));
      case        AttackAction: 
      case    AttackWithAction: return (checkFor(uselessToAttackMsg)
                                     || checkFor(notAWeaponMsg));
      case         ThrowAction: 
      case       ThrowAtAction: 
      case       ThrowToAction: return (checkFor(throwHitMsg)
                                     || checkFor(throwHitFallMsg)
                                     || checkFor(throwShortMsg)
                                     || checkFor(throwFallShortMsg)
                                     || checkFor(cannotThrowAtSelfMsg)
                                     || checkFor(cannotThrowAtContentsMsg)
                                     || checkFor(shouldNotThrowAtFloorMsg)
                                     || checkFor(willNotCatchMsg));
      case           DigAction: 
      case       DigWithAction: return (checkFor(cannotDigMsg)
                                     || checkFor(cannotDigWithMsg));
      case      JumpOverAction: return  checkFor(cannotJumpOverMsg);
      case       JumpOffAction: return  checkFor(cannotJumpOffMsg);
      case          PushAction: return  checkFor(pushNoEffectMsg);
      case          PullAction: return  checkFor(pullNoEffectMsg);
      case          MoveAction: 
      case      MoveWithAction: 
      case        MoveToAction: return (checkFor(moveNoEffectMsg)
                                     || checkFor(cannotMoveWithMsg)
                                     || checkFor(moveToNoEffectMsg));
      case          TurnAction: 
      case      TurnWithAction: return (checkFor(cannotTurnMsg)
                                     || checkFor(cannotTurnWithMsg));
      case        TypeOnAction: 
      case TypeLiteralOnAction: return  checkFor(cannotTypeOnMsg);
      case       EnterOnAction: return  checkFor(cannotEnterOnMsg);
      case       ConsultAction: 
      case  ConsultAboutAction: return  checkFor(cannotConsultMsg);
      case        SwitchAction: return  checkFor(cannotSwitchMsg);
      case          FlipAction: return  checkFor(cannotFlipMsg);
      case        TurnOnAction: return  checkFor(cannotTurnOnMsg);
      case       TurnOffAction: return  checkFor(cannotTurnOffMsg);
      case         LightAction: return  checkFor(cannotLightMsg);
      case          BurnAction: 
      case      BurnWithAction: return (checkFor(cannotBurnMsg)
                                     || checkFor(cannotBurnWithMsg)
                                     || checkFor(cannotBurnDobjWithMsg));
      case    ExtinguishAction: return  checkFor(cannotExtinguishMsg);
      case      AttachToAction: return (checkFor(cannotAttachMsg)
                                     || checkFor(cannotAttachToMsg));
      case        DetachAction: 
      case    DetachFromAction: return (checkFor(cannotDetachMsg)
                                     || checkFor(cannotDetachFromMsg));
      case         BreakAction: return  checkFor(shouldNotBreakMsg);
      case           CutAction: 
      case       CutWithAction: return (checkFor(cutNoEffectMsg)
                                     || checkFor(cannotCutWithMsg));
      case         ClimbAction: 
      case       ClimbUpAction: 
      case     ClimbDownAction: return  checkFor(cannotClimbMsg);
      case          OpenAction: return  checkFor(cannotOpenMsg);
      case         CloseAction: return  checkFor(cannotCloseMsg);
      case          LockAction: 
      case      LockWithAction: return (checkFor(cannotLockMsg)
                                     || checkFor(cannotLockWithMsg));
      case        UnlockAction: 
      case    UnlockWithAction: return (checkFor(cannotUnlockMsg)
                                     || checkFor(cannotUnlockWithMsg));
      case           EatAction: return  checkFor(cannotEatMsg);
      case         DrinkAction: return  checkFor(cannotDrinkMsg);
      case          PourAction: 
      case      PourIntoAction: 
      case      PourOntoAction: return (checkFor(cannotPourMsg)
                                     || checkFor(cannotPourIntoMsg)
                                     || checkFor(cannotPourOntoMsg));
      case         CleanAction: 
      case     CleanWithAction: return (checkFor(cannotCleanMsg)
                                     || checkFor(cannotCleanWithMsg));
      case         SitOnAction: return  checkFor(cannotSitOnMsg);
      case         LieOnAction: return  checkFor(cannotLieOnMsg);
      case       StandOnAction: return  checkFor(cannotStandOnMsg);
      case         BoardAction: return  checkFor(cannotBoardMsg);
      case      GetOutOfAction: return  checkFor(cannotUnboardMsg);
      case      GetOffOfAction: return  checkFor(cannotGetOffOfMsg);
      case        FastenAction: 
      case      FastenToAction: return (checkFor(cannotFastenMsg)
                                     || checkFor(cannotFastenToMsg));
      case      UnfastenAction: 
      case  UnfastenFromAction: return (checkFor(cannotUnfastenMsg)
                                     || checkFor(cannotUnfastenFromMsg));
      case        PlugInAction: 
      case      PlugIntoAction: return (checkFor(cannotPlugInMsg)
                                     || checkFor(cannotPlugInToMsg));
      case        UnplugAction: 
      case    UnplugFromAction: return (checkFor(cannotUnplugMsg)
                                     || checkFor(cannotUnplugFromMsg));
      case         ScrewAction: 
      case     ScrewWithAction: return (checkFor(cannotScrewMsg)
                                     || checkFor(cannotScrewWithMsg));
      case       UnscrewAction: 
      case   UnscrewWithAction: return (checkFor(cannotUnscrewMsg)
                                     || checkFor(cannotUnscrewWithMsg));
      case     GoThroughAction: return  checkFor(cannotGoThroughMsg);
      case         EnterAction: return  checkFor(cannotEnterMsg);
    }
    return nil;
  }
*/
  
  

// -------------------------------------------------------------------
// GUNS AND SHOOTING: StrangeThing class
// -------------------------------------------------------------------

class StrangeThing: Thing
  dobjFor(All) {
    verify() {
      if (gDobj && actionIsUnparseable) {
        sayForArt(parseFailMsg);
        //say(artHtml1);
        //say(parseFailMsg);
        //say(artHtml2);
        throw new TerminateCommandException();
      }
      inherited();
    }
  }
  iobjFor(All) {
    verify() {
      if (gIobj && actionIsUnparseable) {
        sayForArt(parseFailMsg);
        //say(artHtml1);
        //say(parseFailMsg);
        //say(artHtml2);
        throw new TerminateCommandException();
      }
      inherited();
    }
  }
  // Make an exception for the debugging verbs Snarf and Pow, if applicable.
//#ifdef __DEBUG
//  dobjFor(Snarf) {
//    verify { }
//  }
//  dobjFor(Pow) {
//    verify { }
//  }
//#endif // __DEBUG
  parseFailMsg = '[This object does not understand that verb.] '
  actionIsUnparseable() {
    //local k=0; k=k/k;
    if (gAction == nil) return true;
    if (actionHasCustomMessage) return nil;
    if (actionIsInActionList) return nil;
#ifdef __DEBUG
    if (gActionIs(Snarf) || gActionIs(Pow)) return nil;
    if (gActionIs(Tr) || gActionIs(Ary)) return nil;
    if (gActionIs(GList)) return nil;
#endif // __DEBUG
    //if (actionIsNecessary) return nil;
    //if (actionHasCustomMessage) return nil;
    //if (actionIsAllowed) return nil;
    else return true;
  }
  // Add actions (e.g. WearAction) to the clsParseList to make
  // them pass the parser test for all StrangeThing objects.
  clsParseList = [GoNearAction]
  // Same for objParseList, but only modify this for individual
  // objects.
  objParseList = []
  actionIsInActionList() {
    if (gAction == nil) return nil;
    // if the gAction is in one of the ActionLists, return true.
    if (clsParseList.indexOf(gAction.baseActionClass)) return true;
    if (objParseList.indexOf(gAction.baseActionClass)) return true;
    return nil;
  }
  chkFor(prp) { // "prp" as in "property"
    if (prp != nil) return true;
    else return nil;
  }
  actionHasCustomMessage() {
    if (gAction == nil) return nil;
    switch (gAction.baseActionClass) {
      case       ExamineAction: return  chkFor(dExamine      );
      case          ReadAction: return  chkFor(dRead         );
      case        LookInAction: return  chkFor(dLookIn       );
      case        SearchAction: return  chkFor(dSearch       );
      case     LookUnderAction: return  chkFor(dLookUnder    );
      case    LookBehindAction: return  chkFor(dLookBehind   );
      case   LookThroughAction: return  chkFor(dLookThrough  );
      case      ListenToAction: return  chkFor(dListenTo     );
      case         SmellAction: return  chkFor(dSmell        );
      case         TasteAction: return  chkFor(dTaste        );
      case          FeelAction: return  chkFor(dFeel         );
      case          TakeAction: return (chkFor(dTake         )
                                     || chkFor(dTakeAlr      ));
      case        RemoveAction: return  chkFor(dRemove       );
      case      TakeFromAction: return  chkFor(dTakeFrom     );
      case          DropAction: return (chkFor(dDrop         )
                                     || chkFor(dDropAlr      ));
/*
      case         PutInAction: return (chkFor(dPutIn        )
                                     || chkFor(dPutInAlr     ));
      case         PutOnAction: return (chkFor(dPutOn        )
                                     || chkFor(dPutOnAlr     ));
      case      PutUnderAction: return (chkFor(dPutUnder     )
                                     || chkFor(dPutUnderAlr  ));
      case     PutBehindAction: return (chkFor(dPutBehind    )
                                     || chkFor(dPutBehindAlr ));
*/
      case         PutInAction: return (chkFor(dPutIn        )
                                     || chkFor(dPutInAlr     )
                                     || chkFor(iPutIn        ));
      case         PutOnAction: return (chkFor(dPutOn        )
                                     || chkFor(dPutOnAlr     )
                                     || chkFor(iPutOn        ));
      case      PutUnderAction: return (chkFor(dPutUnder     )
                                     || chkFor(dPutUnderAlr  )
                                     || chkFor(iPutUnder     ));
      case     PutBehindAction: return (chkFor(dPutBehind    )
                                     || chkFor(dPutBehindAlr )
                                     || chkFor(iPutBehind    ));
      case          WearAction: return  chkFor(dWear         );
      case          DoffAction: return  chkFor(dDoff         );
      case          KissAction: return  chkFor(dKiss         );
      //case           AskAction: return  chkFor(dAsk          );
      case        AskForAction: return  chkFor(dAskFor       );
      case      AskAboutAction: return  chkFor(dAskAbout     );
      //case          TellAction: return  chkFor(dTell         );
      case     TellAboutAction: return  chkFor(dTellAbout    );
      case        TalkToAction: return  chkFor(dTalkTo       );
      case          GiveAction: return  chkFor(dGive         );
      case        GiveToAction: return (chkFor(dGiveTo       )
                                     || chkFor(iGiveTo       ));
      case          ShowAction: return  chkFor(dShow         );
      case        ShowToAction: return (chkFor(dShowTo       )
                                     || chkFor(iShowTo       ));
      case        FollowAction: return  chkFor(dFollow       );
      case           HitAction: return  chkFor(dHit          );
      case       HitWithAction: return (chkFor(dHitWith      )
                                     || chkFor(iHitWith      ));
      case        AttackAction: return  chkFor(dAttack       );
      case    AttackWithAction: return (chkFor(dAttackWith   )
                                     || chkFor(iAttackWith   ));
      case         ThrowAction: return  chkFor(dThrow        );
      case       ThrowAtAction: return (chkFor(dThrowAt      )
                                     || chkFor(iThrowAt      ));
      case       ThrowToAction: return (chkFor(dThrowTo      )
                                     || chkFor(iThrowTo      ));
      case           DigAction: return  chkFor(dDig          );
      case       DigWithAction: return (chkFor(dDigWith      )
                                     || chkFor(iDigWith      ));
      case      JumpOverAction: return  chkFor(dJumpOver     );
      case       JumpOffAction: return  chkFor(dJumpOff      );
      case          PushAction: return  chkFor(dPush         );
      case          PullAction: return  chkFor(dPull         );
      case          MoveAction: return  chkFor(dMove         );
      case      MoveWithAction: return (chkFor(dMoveWith     )
                                     || chkFor(iMoveWith     ));
      case        MoveToAction: return (chkFor(dMoveTo       )
                                     || chkFor(iMoveTo       ));
      case          TurnAction: return  chkFor(dTurn         );
      case      TurnWithAction: return (chkFor(dTurnWith     )
                                     || chkFor(iTurnWith     ));
      case        TurnToAction: return  chkFor(dTurnTo       );
      case       ConsultAction: return  chkFor(dConsult      );
      case  ConsultAboutAction: return  chkFor(dConsultAbout );
      case         SetToAction: return  chkFor(dSetTo        );
      case        TypeOnAction: return  chkFor(dTypeOn       );
      case TypeLiteralOnAction: return  chkFor(dTypeLiteralOn);
      case       EnterOnAction: return  chkFor(dEnterOn      );
      case        SwitchAction: return  chkFor(dSwitch       );
      case          FlipAction: return  chkFor(dFlip         );
      case        TurnOnAction: return  chkFor(dTurnOn       );
      case       TurnOffAction: return  chkFor(dTurnOff      );
      case         LightAction: return  chkFor(dLight        );
      case        StrikeAction: return  chkFor(dStrike       );
      case          BurnAction: return  chkFor(dBurn         );
      case      BurnWithAction: return (chkFor(dBurnWith     )
                                     || chkFor(iBurnWith     ));
      case    ExtinguishAction: return  chkFor(dExtinguish   );
      case        AttachAction: return  chkFor(dAttach       );
      case      AttachToAction: return (chkFor(dAttachTo     )
                                     || chkFor(iAttachTo     ));
      case        DetachAction: return  chkFor(dDetach       );
      case    DetachFromAction: return (chkFor(dDetachFrom   )
                                     || chkFor(iDetachFrom   ));
      case         BreakAction: return  chkFor(dBreak        );
      case           CutAction: return  chkFor(dCut          );
      case       CutWithAction: return (chkFor(dCutWith      )
                                     || chkFor(iCutWith      ));
      case         ClimbAction: return  chkFor(dClimb        );
      case       ClimbUpAction: return  chkFor(dClimbUp      );
      case     ClimbDownAction: return  chkFor(dClimbDown    );
      case          OpenAction: return  chkFor(dOpen         );
      case         CloseAction: return  chkFor(dClose        );
      case          LockAction: return  chkFor(dLock         );
      case      LockWithAction: return (chkFor(dLockWith     )
                                     || chkFor(iLockWith     ));
      case        UnlockAction: return  chkFor(dUnlock       );
      case    UnlockWithAction: return (chkFor(dUnlockWith   )
                                     || chkFor(iUnlockWith   ));
      case           EatAction: return  chkFor(dEat          );
      case         DrinkAction: return  chkFor(dDrink        );
      case          PourAction: return  chkFor(dPour         );
      case      PourIntoAction: return (chkFor(dPourInto     )
                                     || chkFor(iPourInto     ));
      case      PourOntoAction: return (chkFor(dPourOnto     )
                                     || chkFor(iPourOnto     ));
      case         CleanAction: return  chkFor(dClean        );
      case     CleanWithAction: return (chkFor(dCleanWith    )
                                     || chkFor(iCleanWith    ));
      case         SitOnAction: return  chkFor(dSitOn        );
      case         LieOnAction: return  chkFor(dLieOn        );
      case       StandOnAction: return  chkFor(dStandOn      );
      case         BoardAction: return  chkFor(dBoard        );
      case      GetOutOfAction: return  chkFor(dGetOutOf     );
      case      GetOffOfAction: return  chkFor(dGetOffOf     );
      case        FastenAction: return  chkFor(dFasten       );
      case      FastenToAction: return (chkFor(dFastenTo     )
                                     || chkFor(iFastenTo     ));
      case      UnfastenAction: return  chkFor(dUnfasten     );
      case  UnfastenFromAction: return (chkFor(dUnfastenFrom )
                                     || chkFor(iUnfastenFrom ));
      case        PlugInAction: return  chkFor(dPlugIn       );
      case      PlugIntoAction: return (chkFor(dPlugInto     )
                                     || chkFor(iPlugInto     ));
      case        UnplugAction: return  chkFor(dUnplug       );
      case    UnplugFromAction: return (chkFor(dUnplugFrom   )
                                     || chkFor(iUnplugFrom   ));
      case         ScrewAction: return  chkFor(dScrew        );
      case     ScrewWithAction: return (chkFor(dScrewWith    )
                                     || chkFor(iScrewWith    ));
      case       UnscrewAction: return  chkFor(dUnscrew      );
      case   UnscrewWithAction: return (chkFor(dUnscrewWith  )
                                     || chkFor(iUnscrewWith  ));
      case     GoThroughAction: return  chkFor(dGoThrough    );
      case         EnterAction: return  chkFor(dEnter        );
      case    PushTravelAction: return  chkFor(dPushTravel   );
      case         ShootAction: return  chkFor(dShoot        );
      case ShootAimlesslyAction:return  chkFor(dShootAimless );
      case     ShootWithAction: return (chkFor(dShootWith    )
                                     || chkFor(iShootWith    ));
    }
    return nil;
  }
  
  // StrangeThing: "d" and "i" methods
  dExamine      =true // shows desc
  dRead         =true // acts like examine
  dLookIn       ='There<./s>s nothing unusual in {the dobj/him}. '
  dSearch       =true // acts exactly like LookIn
  dLookUnder    ='{You/he} see{s} nothing unusual under {the dobj/him}. '
  dLookBehind   ='{You/he} see{s} nothing unusual behind {the dobj/him}. '
  dLookThrough  ='{You/he} can see nothing through {the dobj/him}. '
  dListenTo     ='{You/he} hear{s} nothing out of the ordinary. '
  dSmell        ='{You/he} smell{s} nothing out of the ordinary. '
  dTaste        ='{You/he} taste{s} nothing out of the ordinary. '
  dFeel         ='{You/he} feel{s} nothing out of the ordinary. '
  dTake         ='Taken. '
  dTakeAlr      ='{You/he} {are} already carrying {the dobj/him}. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Dropped. '
  dDropAlr      ='{You\'re} not carrying {that dobj/him}. '
  dPutIn        ='Done. '
  dPutInAlr     ='{The dobj/he} {is} already in {the iobj/him}. '
  iPutIn        ='{You/he} can<./s>t put anything in {the iobj/him}. '
  dPutOn        ='Done. '
  dPutOnAlr     ='{The dobj/he} {is} already on {the iobj/him}. '
  iPutOn        ='There<./s>s no good surface on {the iobj/him}. '
  dPutUnder     ='Done. '
  dPutUnderAlr  ='{The dobj/he} {is} already under {the iobj/him}. '
  iPutUnder     ='{You/he} can<./s>t put anything under {the iobj/him}. '
  dPutBehind    ='Done. '
  dPutBehindAlr ='{The dobj/he} {is} already behind {the iobj/him}. '
  iPutBehind    ='{You/he} can<./s>t put anything behind {the iobj/him}. '
  dWear         ='{That dobj/he} {is}n<./s>t something {you/he} can wear. '
  dDoff         ='{That dobj/he} {is}n<./s>t something {you/he} can remove. '
  dKiss         ='Kissing {the dobj/him} has no obvious effect. '
  dAsk     /*!*/=true // asks for topic
  dAskFor       ='{You/he} cannot talk to that. '
  dAskAbout     ='{You/he} cannot talk to that. '
  dTell    /*!*/=true // asks for topic
  dTellAbout    ='{You/he} cannot talk to that. '
  dTalkTo       ='{You/he} cannot talk to that. '
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='{That iobj/he} do{es}n<./s>t appear interested. '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='{That iobj/he} do{es}n<./s>t appear interested. '
  dFollow       ='{You/he} cannot follow {that dobj/him}. '
  dHit          ='{You/he} cannot hit {that dobj/him}. '
  dHitWith      ='{You/he} cannot hit {that dobj/him}. '
  iHitWith      ='{You/he} can<./s>t hit anything with {the iobj/him}. '
  dAttack       ='{You/he} cannot attack {that dobj/him}. '
  dAttackWith   ='{You/he} cannot attack {that dobj/him}. '
  iAttackWith   ='{You/he} can<./s>t attack anything with {the iobj/him}. '
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='{The iobj/he} do{es}n<./s>t look like {it/he} want{s} to catch anything. '
  dDig     /*!*/=true // asks for iobj
  dDigWith      ='{You/he} {have} no reason to dig in {that dobj/him}. '
  iDigWith      ='{You/he} see{s} no way to use {that dobj/him} as a shovel. '
  dJumpOver     ='{You/he} can<./s>t jump over {that dobj/him}. '
  dJumpOff      ='{You/he} can<./s>t jump off {that dobj/him}. '
  dPush         ='Pushing {the dobj/him} has no effect. '
  dPull         ='Pulling {the dobj/him} has no effect. '
  dMove         ='Moving {the dobj/him} has no effect. '
  dMoveWith     ='Moving {the dobj/him} has no effect. '
  iMoveWith     ='{You/he} cannot move anything with {the iobj/him}. '
  dMoveTo       ='This would accomplish nothing. '
  iMoveTo       =true // does nothing
  dTurn         ='{You/he} cannot turn {that dobj/him}. '
  dTurnWith     ='{You/he} cannot turn {that dobj/him}. '
  iTurnWith     ='{You/he} cannot turn anything with {that iobj/him}. '
  dTurnTo       ='{You/he} cannot turn {that dobj/him}. '
  dConsult      ='{That dobj/he} {is} not something {you/he} can consult. '
  dConsultAbout ='{That dobj/he} {is} not something {you/he} can consult. '
  dSetTo        =true // no handling, just defaults to "You can't do that."
  dTypeOn       ='{You/he} cannot type anything on {that dobj/him}. '
  dTypeLiteralOn='{You/he} cannot type anything on {that dobj/him}. '
  dEnterOn      ='{You/he} cannot enter anything on {that dobj/him}. '
  dSwitch       ='{You/he} cannot switch {that dobj/him}. '
  dFlip         ='{You/he} cannot flip {that dobj/him}. '
  dTurnOn       ='{That dobj/he} {is}n<./s>t something {you/he} can turn on. '
  dTurnOff      ='{That dobj/he} {is}n<./s>t something {you/he} can turn off. '
  dLight        ='{You/he} cannot light {that dobj/him}. '
  dStrike       =true // remapped to dHit
  dBurn    /*!*/='{That dobj/he} {is} not something {you/he} can burn. '
  dBurnWith     ='{That dobj/he} {is} not something {you/he} can burn. '
  iBurnWith     ='{You/he} cannot burn anything with {that iobj/him}. '
  dExtinguish   ='{You/he} cannot extinguish {that dobj/him}. '
  dAttach  /*!*/=true // asks for iobj
  dAttachTo     ='{You/he} cannot attach {that dobj/him} to anything. '
  iAttachTo     ='{You/he} cannot attach anything to {that iobj/him}. '
  dDetach       ='{You/he} cannot detach {that dobj/him}. '
  dDetachFrom   ='{You/he} cannot detach {that dobj/him}. '
  iDetachFrom   ='{You/he} cannot detach anything from {that iobj/him}. '
  dBreak        ='Breaking {that dobj/him} would serve no purpose. '
  dCut     /*!*/=true // asks for iobj
  dCutWith      ='{The iobj/he} can<./s>t seem to cut {the dobj/him}. '
  iCutWith      ='{You/he} can<./s>t cut anything with {the iobj/him}. '
  dClimb        ='{That dobj/he} {is} not something {you/he} can climb. '
  dClimbUp      ='{That dobj/he} {is} not something {you/he} can climb. '
  dClimbDown    ='{That dobj/he} {is} not something {you/he} can climb. '
  dOpen         ='{That dobj/he} {is} not something {you/he} can open. '
  dClose        ='{That dobj/he} {is} not something {you/he} can close. '
  dLock         ='{That dobj/he} {is} not something {you/he} can lock. '
  dLockWith     ='{That dobj/he} {is} not something {you/he} can lock. '
  iLockWith     ='{The iobj/he} do{es}n<./s>t look suitable for locking that. '
  dUnlock       ='{That dobj/he} {is} not something {you/he} can unlock. '
  dUnlockWith   ='{That dobj/he} {is} not something {you/he} can unlock. '
  iUnlockWith   ='{The iobj/he} do{es}n<./s>t look suitable for unlocking that. '
  dEat          ='{The dobj/he} do{es} not appear to be edible. '
  dDrink        ='{That dobj/he} do{es} not appear to be something {you/he} can drink. '
  dPour         ='{That dobj/he} {is} not something {you/he} can pour. '
  dPourInto     ='{That dobj/he} {is} not something {you/he} can pour. '
  iPourInto     ='{You/he} cannot pour anything into {that dobj/him}. '
  dPourOnto     ='{That dobj/he} {is} not something {you/he} can pour. '
  iPourOnto     ='{You/he} cannot pour anything onto {that dobj/him}. '
  dClean        ='{You/he} wouldn<./s>t know how to clean {that dobj/him}. '
  dCleanWith    ='{You/he} wouldn<./s>t know how to clean {that dobj/him}. '
  iCleanWith    ='{You/he} can<./s>t clean anything with {that iobj/him}. '
  dSitOn        ='{That dobj/he} {is}n<./s>t something {you/he} can sit on. '
  dLieOn        ='{That dobj/he} {is}n<./s>t something {you/he} can lie on. '
  dStandOn      ='{You/he} can<./s>t stand on {that dobj/him}. '
  dBoard        ='{You/he} can<./s>t board {that dobj/him}. '
  dGetOutOf     ='{You/he} can<./s>t get out of {that dobj/him}. '
  dGetOffOf     ='{You/he} can<./s>t get off of {that dobj/him}. '
  dFasten       ='{You/he} cannot fasten {the dobj/him}. '
  dFastenTo     ='{You/he} cannot fasten {the dobj/him}. '
  iFastenTo     ='{You/he} cannot fasten anything to {the iobj/him}. '
  dUnfasten     ='{You/he} cannot unfasten {the dobj/him}. '
  dUnfastenFrom ='{You/he} cannot unfasten {the dobj/him}. '
  iUnfastenFrom ='{You/he} cannot unfasten anything from {the iobj/him}. '
  dPlugIn       ='{You/he} see{s} no way to plug in {the dobj/him}. '
  dPlugInto     ='{You/he} see{s} no way to plug in {the dobj/him}. '
  iPlugInto     ='{You/he} see{s} no way to plug anything into {the iobj/him}. '
  dUnplug       ='{You/he} see{s} no way to unplug {the dobj/him}. '
  dUnplugFrom   ='{You/he} see{s} no way to unplug {the dobj/him}. '
  iUnplugFrom   ='{You/he} see{s} no way to unplug anything from {the iobj/him}. '
  dScrew        ='{You/he} see{s} no way to screw {the dobj/him}. '
  dScrewWith    ='{You/he} see{s} no way to screw {the dobj/him}. '
  iScrewWith    ='{You/he} cannot screw anything with {the iobj/him}. '
  dUnscrew      ='{You/he} see{s} no way to unscrew {the dobj/him}. '
  dUnscrewWith  ='{You/he} see{s} no way to unscrew {the dobj/him}. '
  iUnscrewWith  ='{You/he} cannot unscrew anything with {the iobj/him}. '
  dGoThrough    ='{That/he dobj} {is} not something {you/he} can go through. '
  dEnter        ='{That/he dobj} {is} not something {you/he} can enter. '
  dPushTravel   ='This would accomplish nothing. '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  
  // StrangeThing: "dd" and "ii" methods
  ddTransform(prp) { // prp as in property
    if (dataType(prp) != TypeSString) return nil;
    else if (prp.substr(1,1) == '!') {
      //NOOF
      return artHtml1 + prp.substr(2) + artHtml2;
    }
    else {
      //NOOF
      return artHtml1 + prp + artHtml2;
    }
  }
  ddExamine       { return ddTransform(dExamine      ); }
  ddRead          { return ddTransform(dRead         ); }
  ddLookIn        { return ddTransform(dLookIn       ); }
  ddSearch        { return ddTransform(dSearch       ); }
  ddLookUnder     { return ddTransform(dLookUnder    ); }
  ddLookBehind    { return ddTransform(dLookBehind   ); }
  ddLookThrough   { return ddTransform(dLookThrough  ); }
  ddListenTo      { return ddTransform(dListenTo     ); }
  ddSmell         { return ddTransform(dSmell        ); }
  ddTaste         { return ddTransform(dTaste        ); }
  ddFeel          { return ddTransform(dFeel         ); }
  ddTake          { return ddTransform(dTake         ); }
  ddTakeAlr       { return ddTransform(dTakeAlr      ); }
  ddRemove        { return ddTransform(dRemove       ); }
  ddTakeFrom      { return ddTransform(dTakeFrom     ); }
  ddDrop          { return ddTransform(dDrop         ); }
  ddDropAlr       { return ddTransform(dDropAlr      ); }
  ddPutIn         { return ddTransform(dPutIn        ); }
  ddPutInAlr      { return ddTransform(dPutInAlr     ); }
  iiPutIn         { return ddTransform(iPutIn        ); }
  ddPutOn         { return ddTransform(dPutOn        ); }
  ddPutOnAlr      { return ddTransform(dPutOnAlr     ); }
  iiPutOn         { return ddTransform(iPutOn        ); }
  ddPutUnder      { return ddTransform(dPutUnder     ); }
  ddPutUnderAlr   { return ddTransform(dPutUnderAlr  ); }
  iiPutUnder      { return ddTransform(iPutUnder     ); }
  ddPutBehind     { return ddTransform(dPutBehind    ); }
  ddPutBehindAlr  { return ddTransform(dPutBehindAlr ); }
  iiPutBehind     { return ddTransform(iPutBehind    ); }
  ddWear          { return ddTransform(dWear         ); }
  ddDoff          { return ddTransform(dDoff         ); }
  ddKiss          { return ddTransform(dKiss         ); }
  ddAsk           { return ddTransform(dAsk          ); }
  ddAskFor        { return ddTransform(dAskFor       ); }
  ddAskAbout      { return ddTransform(dAskAbout     ); }
  ddTell          { return ddTransform(dTell         ); }
  ddTellAbout     { return ddTransform(dTellAbout    ); }
  ddTalkTo        { return ddTransform(dTalkTo       ); }
  ddGive          { return ddTransform(dGive         ); }
  ddGiveTo        { return ddTransform(dGiveTo       ); }
  iiGiveTo        { return ddTransform(iGiveTo       ); }
  ddShow          { return ddTransform(dShow         ); }
  ddShowTo        { return ddTransform(dShowTo       ); }
  iiShowTo        { return ddTransform(iShowTo       ); }
  ddFollow        { return ddTransform(dFollow       ); }
  ddHit           { return ddTransform(dHit          ); }
  ddHitWith       { return ddTransform(dHitWith      ); }
  iiHitWith       { return ddTransform(iHitWith      ); }
  ddAttack        { return ddTransform(dAttack       ); }
  ddAttackWith    { return ddTransform(dAttackWith   ); }
  iiAttackWith    { return ddTransform(iAttackWith   ); }
  ddThrow         { return ddTransform(dThrow        ); }
  ddThrowAt       { return ddTransform(dThrowAt      ); }
  iiThrowAt       { return ddTransform(iThrowAt      ); }
  ddThrowTo       { return ddTransform(dThrowTo      ); }
  iiThrowTo       { return ddTransform(iThrowTo      ); }
  ddDig           { return ddTransform(dDig          ); }
  ddDigWith       { return ddTransform(dDigWith      ); }
  iiDigWith       { return ddTransform(iDigWith      ); }
  ddJumpOver      { return ddTransform(dJumpOver     ); }
  ddJumpOff       { return ddTransform(dJumpOff      ); }
  ddPush          { return ddTransform(dPush         ); }
  ddPull          { return ddTransform(dPull         ); }
  ddMove          { return ddTransform(dMove         ); }
  ddMoveWith      { return ddTransform(dMoveWith     ); }
  iiMoveWith      { return ddTransform(iMoveWith     ); }
  ddMoveTo        { return ddTransform(dMoveTo       ); }
  iiMoveTo        { return ddTransform(iMoveTo       ); }
  ddTurn          { return ddTransform(dTurn         ); }
  ddTurnWith      { return ddTransform(dTurnWith     ); }
  iiTurnWith      { return ddTransform(iTurnWith     ); }
  ddTurnTo        { return ddTransform(dTurnTo       ); }
  ddConsult       { return ddTransform(dConsult      ); }
  ddConsultAbout  { return ddTransform(dConsultAbout ); }
  ddSetTo         { return ddTransform(dSetTo        ); }
  ddTypeOn        { return ddTransform(dTypeOn       ); }
  ddTypeLiteralOn { return ddTransform(dTypeLiteralOn); }
  ddEnterOn       { return ddTransform(dEnterOn      ); }
  ddSwitch        { return ddTransform(dSwitch       ); }
  ddFlip          { return ddTransform(dFlip         ); }
  ddTurnOn        { return ddTransform(dTurnOn       ); }
  ddTurnOff       { return ddTransform(dTurnOff      ); }
  ddLight         { return ddTransform(dLight        ); }
  ddStrike        { return ddTransform(dStrike       ); }
  ddBurn          { return ddTransform(dBurn         ); }
  ddBurnWith      { return ddTransform(dBurnWith     ); }
  iiBurnWith      { return ddTransform(iBurnWith     ); }
  ddExtinguish    { return ddTransform(dExtinguish   ); }
  ddAttach        { return ddTransform(dAttach       ); }
  ddAttachTo      { return ddTransform(dAttachTo     ); }
  iiAttachTo      { return ddTransform(iAttachTo     ); }
  ddDetach        { return ddTransform(dDetach       ); }
  ddDetachFrom    { return ddTransform(dDetachFrom   ); }
  iiDetachFrom    { return ddTransform(iDetachFrom   ); }
  ddBreak         { return ddTransform(dBreak        ); }
  ddCut           { return ddTransform(dCut          ); }
  ddCutWith       { return ddTransform(dCutWith      ); }
  iiCutWith       { return ddTransform(iCutWith      ); }
  ddClimb         { return ddTransform(dClimb        ); }
  ddClimbUp       { return ddTransform(dClimbUp      ); }
  ddClimbDown     { return ddTransform(dClimbDown    ); }
  ddOpen          { return ddTransform(dOpen         ); }
  ddClose         { return ddTransform(dClose        ); }
  ddLock          { return ddTransform(dLock         ); }
  ddLockWith      { return ddTransform(dLockWith     ); }
  iiLockWith      { return ddTransform(iLockWith     ); }
  ddUnlock        { return ddTransform(dUnlock       ); }
  ddUnlockWith    { return ddTransform(dUnlockWith   ); }
  iiUnlockWith    { return ddTransform(iUnlockWith   ); }
  ddEat           { return ddTransform(dEat          ); }
  ddDrink         { return ddTransform(dDrink        ); }
  ddPour          { return ddTransform(dPour         ); }
  ddPourInto      { return ddTransform(dPourInto     ); }
  iiPourInto      { return ddTransform(iPourInto     ); }
  ddPourOnto      { return ddTransform(dPourOnto     ); }
  iiPourOnto      { return ddTransform(iPourOnto     ); }
  ddClean         { return ddTransform(dClean        ); }
  ddCleanWith     { return ddTransform(dCleanWith    ); }
  iiCleanWith     { return ddTransform(iCleanWith    ); }
  ddSitOn         { return ddTransform(dSitOn        ); }
  ddLieOn         { return ddTransform(dLieOn        ); }
  ddStandOn       { return ddTransform(dStandOn      ); }
  ddBoard         { return ddTransform(dBoard        ); }
  ddGetOutOf      { return ddTransform(dGetOutOf     ); }
  ddGetOffOf      { return ddTransform(dGetOffOf     ); }
  ddFasten        { return ddTransform(dFasten       ); }
  ddFastenTo      { return ddTransform(dFastenTo     ); }
  iiFastenTo      { return ddTransform(iFastenTo     ); }
  ddUnfasten      { return ddTransform(dUnfasten     ); }
  ddUnfastenFrom  { return ddTransform(dUnfastenFrom ); }
  iiUnfastenFrom  { return ddTransform(iUnfastenFrom ); }
  ddPlugIn        { return ddTransform(dPlugIn       ); }
  ddPlugInto      { return ddTransform(dPlugInto     ); }
  iiPlugInto      { return ddTransform(iPlugInto     ); }
  ddUnplug        { return ddTransform(dUnplug       ); }
  ddUnplugFrom    { return ddTransform(dUnplugFrom   ); }
  iiUnplugFrom    { return ddTransform(iUnplugFrom   ); }
  ddScrew         { return ddTransform(dScrew        ); }
  ddScrewWith     { return ddTransform(dScrewWith    ); }
  iiScrewWith     { return ddTransform(iScrewWith    ); }
  ddUnscrew       { return ddTransform(dUnscrew      ); }
  ddUnscrewWith   { return ddTransform(dUnscrewWith  ); }
  iiUnscrewWith   { return ddTransform(iUnscrewWith  ); }
  ddGoThrough     { return ddTransform(dGoThrough    ); }
  ddEnter         { return ddTransform(dEnter        ); }
  ddPushTravel    { return ddTransform(dPushTravel   ); }
  ddShoot         { return ddTransform(dShoot        ); }
  ddShootAimless  { return ddTransform(dShootAimless ); }
  ddShootWith     { return ddTransform(dShootWith    ); }
  iiShootWith     { return ddTransform(iShootWith    ); }
  
  // StrangeThing: "ddd" and "iii" methods
  dddSpecial(prp) {
    if (dataType(prp) != TypeSString) return nil;
    if (prp.substr(1,1) == '!') return true;
    return nil;
  }
  dddExamine       { return dddSpecial(dExamine      ); }
  dddRead          { return dddSpecial(dRead         ); }
  dddLookIn        { return dddSpecial(dLookIn       ); }
  dddSearch        { return dddSpecial(dSearch       ); }
  dddLookUnder     { return dddSpecial(dLookUnder    ); }
  dddLookBehind    { return dddSpecial(dLookBehind   ); }
  dddLookThrough   { return dddSpecial(dLookThrough  ); }
  dddListenTo      { return dddSpecial(dListenTo     ); }
  dddSmell         { return dddSpecial(dSmell        ); }
  dddTaste         { return dddSpecial(dTaste        ); }
  dddFeel          { return dddSpecial(dFeel         ); }
  dddTake          { return dddSpecial(dTake         ); }
  dddTakeAlr       { return dddSpecial(dTakeAlr      ); }
  dddRemove        { return dddSpecial(dRemove       ); }
  dddTakeFrom      { return dddSpecial(dTakeFrom     ); }
  dddDrop          { return dddSpecial(dDrop         ); }
  dddDropAlr       { return dddSpecial(dDropAlr      ); }
  dddPutIn         { return dddSpecial(dPutIn        ); }
  dddPutInAlr      { return dddSpecial(dPutInAlr     ); }
  iiiPutIn         { return dddSpecial(iPutIn        ); }
  dddPutOn         { return dddSpecial(dPutOn        ); }
  dddPutOnAlr      { return dddSpecial(dPutOnAlr     ); }
  iiiPutOn         { return dddSpecial(iPutOn        ); }
  dddPutUnder      { return dddSpecial(dPutUnder     ); }
  dddPutUnderAlr   { return dddSpecial(dPutUnderAlr  ); }
  iiiPutUnder      { return dddSpecial(iPutUnder     ); }
  dddPutBehind     { return dddSpecial(dPutBehind    ); }
  dddPutBehindAlr  { return dddSpecial(dPutBehindAlr ); }
  iiiPutBehind     { return dddSpecial(iPutBehind    ); }
  dddWear          { return dddSpecial(dWear         ); }
  dddDoff          { return dddSpecial(dDoff         ); }
  dddKiss          { return dddSpecial(dKiss         ); }
  dddAsk           { return dddSpecial(dAsk          ); }
  dddAskFor        { return dddSpecial(dAskFor       ); }
  dddAskAbout      { return dddSpecial(dAskAbout     ); }
  dddTell          { return dddSpecial(dTell         ); }
  dddTellAbout     { return dddSpecial(dTellAbout    ); }
  dddTalkTo        { return dddSpecial(dTalkTo       ); }
  dddGive          { return dddSpecial(dGive         ); }
  dddGiveTo        { return dddSpecial(dGiveTo       ); }
  iiiGiveTo        { return dddSpecial(iGiveTo       ); }
  dddShow          { return dddSpecial(dShow         ); }
  dddShowTo        { return dddSpecial(dShowTo       ); }
  iiiShowTo        { return dddSpecial(iShowTo       ); }
  dddFollow        { return dddSpecial(dFollow       ); }
  dddHit           { return dddSpecial(dHit          ); }
  dddHitWith       { return dddSpecial(dHitWith      ); }
  iiiHitWith       { return dddSpecial(iHitWith      ); }
  dddAttack        { return dddSpecial(dAttack       ); }
  dddAttackWith    { return dddSpecial(dAttackWith   ); }
  iiiAttackWith    { return dddSpecial(iAttackWith   ); }
  dddThrow         { return dddSpecial(dThrow        ); }
  dddThrowAt       { return dddSpecial(dThrowAt      ); }
  iiiThrowAt       { return dddSpecial(iThrowAt      ); }
  dddThrowTo       { return dddSpecial(dThrowTo      ); }
  iiiThrowTo       { return dddSpecial(iThrowTo      ); }
  dddDig           { return dddSpecial(dDig          ); }
  dddDigWith       { return dddSpecial(dDigWith      ); }
  iiiDigWith       { return dddSpecial(iDigWith      ); }
  dddJumpOver      { return dddSpecial(dJumpOver     ); }
  dddJumpOff       { return dddSpecial(dJumpOff      ); }
  dddPush          { return dddSpecial(dPush         ); }
  dddPull          { return dddSpecial(dPull         ); }
  dddMove          { return dddSpecial(dMove         ); }
  dddMoveWith      { return dddSpecial(dMoveWith     ); }
  iiiMoveWith      { return dddSpecial(iMoveWith     ); }
  dddMoveTo        { return dddSpecial(dMoveTo       ); }
  iiiMoveTo        { return dddSpecial(iMoveTo       ); }
  dddTurn          { return dddSpecial(dTurn         ); }
  dddTurnWith      { return dddSpecial(dTurnWith     ); }
  iiiTurnWith      { return dddSpecial(iTurnWith     ); }
  dddTurnTo        { return dddSpecial(dTurnTo       ); }
  dddConsult       { return dddSpecial(dConsult      ); }
  dddConsultAbout  { return dddSpecial(dConsultAbout ); }
  dddSetTo         { return dddSpecial(dSetTo        ); }
  dddTypeOn        { return dddSpecial(dTypeOn       ); }
  dddTypeLiteralOn { return dddSpecial(dTypeLiteralOn); }
  dddEnterOn       { return dddSpecial(dEnterOn      ); }
  dddSwitch        { return dddSpecial(dSwitch       ); }
  dddFlip          { return dddSpecial(dFlip         ); }
  dddTurnOn        { return dddSpecial(dTurnOn       ); }
  dddTurnOff       { return dddSpecial(dTurnOff      ); }
  dddLight         { return dddSpecial(dLight        ); }
  dddStrike        { return dddSpecial(dStrike       ); }
  dddBurn          { return dddSpecial(dBurn         ); }
  dddBurnWith      { return dddSpecial(dBurnWith     ); }
  iiiBurnWith      { return dddSpecial(iBurnWith     ); }
  dddExtinguish    { return dddSpecial(dExtinguish   ); }
  dddAttach        { return dddSpecial(dAttach       ); }
  dddAttachTo      { return dddSpecial(dAttachTo     ); }
  iiiAttachTo      { return dddSpecial(iAttachTo     ); }
  dddDetach        { return dddSpecial(dDetach       ); }
  dddDetachFrom    { return dddSpecial(dDetachFrom   ); }
  iiiDetachFrom    { return dddSpecial(iDetachFrom   ); }
  dddBreak         { return dddSpecial(dBreak        ); }
  dddCut           { return dddSpecial(dCut          ); }
  dddCutWith       { return dddSpecial(dCutWith      ); }
  iiiCutWith       { return dddSpecial(iCutWith      ); }
  dddClimb         { return dddSpecial(dClimb        ); }
  dddClimbUp       { return dddSpecial(dClimbUp      ); }
  dddClimbDown     { return dddSpecial(dClimbDown    ); }
  dddOpen          { return dddSpecial(dOpen         ); }
  dddClose         { return dddSpecial(dClose        ); }
  dddLock          { return dddSpecial(dLock         ); }
  dddLockWith      { return dddSpecial(dLockWith     ); }
  iiiLockWith      { return dddSpecial(iLockWith     ); }
  dddUnlock        { return dddSpecial(dUnlock       ); }
  dddUnlockWith    { return dddSpecial(dUnlockWith   ); }
  iiiUnlockWith    { return dddSpecial(iUnlockWith   ); }
  dddEat           { return dddSpecial(dEat          ); }
  dddDrink         { return dddSpecial(dDrink        ); }
  dddPour          { return dddSpecial(dPour         ); }
  dddPourInto      { return dddSpecial(dPourInto     ); }
  iiiPourInto      { return dddSpecial(iPourInto     ); }
  dddPourOnto      { return dddSpecial(dPourOnto     ); }
  iiiPourOnto      { return dddSpecial(iPourOnto     ); }
  dddClean         { return dddSpecial(dClean        ); }
  dddCleanWith     { return dddSpecial(dCleanWith    ); }
  iiiCleanWith     { return dddSpecial(iCleanWith    ); }
  dddSitOn         { return dddSpecial(dSitOn        ); }
  dddLieOn         { return dddSpecial(dLieOn        ); }
  dddStandOn       { return dddSpecial(dStandOn      ); }
  dddBoard         { return dddSpecial(dBoard        ); }
  dddGetOutOf      { return dddSpecial(dGetOutOf     ); }
  dddGetOffOf      { return dddSpecial(dGetOffOf     ); }
  dddFasten        { return dddSpecial(dFasten       ); }
  dddFastenTo      { return dddSpecial(dFastenTo     ); }
  iiiFastenTo      { return dddSpecial(iFastenTo     ); }
  dddUnfasten      { return dddSpecial(dUnfasten     ); }
  dddUnfastenFrom  { return dddSpecial(dUnfastenFrom ); }
  iiiUnfastenFrom  { return dddSpecial(iUnfastenFrom ); }
  dddPlugIn        { return dddSpecial(dPlugIn       ); }
  dddPlugInto      { return dddSpecial(dPlugInto     ); }
  iiiPlugInto      { return dddSpecial(iPlugInto     ); }
  dddUnplug        { return dddSpecial(dUnplug       ); }
  dddUnplugFrom    { return dddSpecial(dUnplugFrom   ); }
  iiiUnplugFrom    { return dddSpecial(iUnplugFrom   ); }
  dddScrew         { return dddSpecial(dScrew        ); }
  dddScrewWith     { return dddSpecial(dScrewWith    ); }
  iiiScrewWith     { return dddSpecial(iScrewWith    ); }
  dddUnscrew       { return dddSpecial(dUnscrew      ); }
  dddUnscrewWith   { return dddSpecial(dUnscrewWith  ); }
  iiiUnscrewWith   { return dddSpecial(iUnscrewWith  ); }
  dddGoThrough     { return dddSpecial(dGoThrough    ); }
  dddEnter         { return dddSpecial(dEnter        ); }
  dddPushTravel    { return dddSpecial(dPushTravel   ); }
  dddShoot         { return dddSpecial(dShoot        ); }
  dddShootAimless  { return dddSpecial(dShootAimless ); }
  dddShootWith     { return dddSpecial(dShootWith    ); }
  iiiShootWith     { return dddSpecial(iShootWith    ); }

  // StrangeThing: modified Thing methods
  //   and custom messages
  // Examine
  desc {
    if (ddExamine != nil) mainReport(ddExamine);
    else inherited;
    //else defaultDescReport(&thingDescMsg, self);
  }
  // Read
  dobjFor(Read) {
    action() { 
      if (ddRead != nil) mainReport(ddRead);
      else inherited;
      //else actionDobjExamine();
    }
  }
  // LookIn
  nothingInsideMsg {
    if (ddLookIn != nil) return ddLookIn;
    else return playerActionMessages.nothingInsideMsg;
  }
  // LookUnder
  nothingUnderMsg {
    if (ddLookUnder != nil) return ddLookUnder;
    else return playerActionMessages.nothingUnderMsg;
  }
  // LookBehind
  nothingBehindMsg {
    if (ddLookBehind != nil) return ddLookBehind;
    else return playerActionMessages.nothingBehindMsg;
  }
  // LookThrough
  nothingThroughMsg {
    if (ddLookThrough != nil) return ddLookThrough;
    else return playerActionMessages.nothingThroughMsg;
  }
  // Search
  dobjFor(Search) {
    action() {
      if (ddSearch != nil) mainReport(ddSearch);
      else replaceAction(LookIn, self);
    }
    //asDobjFor(LookIn)
  }
  // ListenTo
  soundDesc {
    if (ddListenTo != nil) mainReport(ddListenTo);
    else inherited;
    //defaultDescReport(&thingSoundDescMsg, self);
  }
  // Smell
  smellDesc {
    if (ddSmell != nil) mainReport(ddSmell);
    else inherited;
    //defaultDescReport(&thingSmellDescMsg, self);
  }
  // Taste
  tasteDesc {
    if (ddTaste != nil) mainReport(ddTaste);
    else inherited;
    //libMessages.thingTasteDesc(self);
  }
  // Feel
  feelDesc  {
    if (ddFeel != nil) mainReport(ddFeel);
    else inherited;
    //libMessages.thingFeelDesc(self);
  }
  // Take
  okayTakeMsg {
    if (ddTake != nil) return ddTake;
    else return playerActionMessages.okayTakeMsg;
  }
  alreadyHoldingMsg {
    if (ddTakeAlr != nil) return ddTakeAlr;
    else return playerActionMessages.alreadyHoldingMsg;
  }
  // Remove
  dobjFor(Remove) {
    action() {
      if (dddRemove != nil) //note "ddd"
        mainReport(ddRemove);
      else
        askForIobj(TakeFrom);
    }
  }
  // TakeFrom: no changes
  // Drop
  okayDropMsg {
    if (ddDrop != nil) return ddDrop;
    else return playerActionMessages.okayDropMsg;
  }
  notCarryingMsg {
    if (ddDropAlr != nil) return ddDropAlr;
    else return playerActionMessages.notCarryingMsg;
  }
  // PutIn
  okayPutInMsg {
    if (ddPutIn != nil) return ddPutIn;
    else return playerActionMessages.okayPutInMsg;
  }
  alreadyPutInMsg {
    if (ddPutInAlr != nil) return ddPutInAlr;
    else return playerActionMessages.alreadyPutInMsg;
  }
  //iobjFor(PutIn) {
  //  verify() {
  //    if (!ofKind(Container)) {
  //      if (iiPutIn != nil) illogical(iiPutIn);
  //      else illogical(&notAContainerMsg);
  //    }
  //    else {
  //      inherited;
  //    }
  //  }
  //}
  notAContainerMsg {
    if (gIobj == self) {
      if (iiPutIn != nil) return iiPutIn;
      else return playerActionMessages.notAContainerMsg;
    }
    else return nil;
  }
  // PutOn
  okayPutOnMsg {
    if (ddPutOn != nil) return ddPutOn;
    else return playerActionMessages.okayPutOnMsg;
  }
  alreadyPutOnMsg {
    if (ddPutOnAlr != nil) return ddPutOnAlr;
    else return playerActionMessages.alreadyPutOnMsg;
  }
  //iobjFor(PutOn) {
  //  verify() {
  //    if (!ofKind(Surface)) {
  //      if (iiPutOn != nil) illogical(iiPutOn);
  //      else illogical(&notASurfaceMsg);
  //    }
  //    else {
  //      inherited;
  //    }
  //  }
  //}
  notASurfaceMsg {
    if (gIobj == self) {
      if (iiPutOn != nil) return iiPutOn;
      else return playerActionMessages.notASurfaceMsg;
    }
    else return nil;
  }
  // PutUnder
  okayPutUnderMsg {
    if (ddPutUnder != nil) return ddPutUnder;
    else return playerActionMessages.okayPutUnderMsg;
  }
  alreadyPutUnderMsg {
    if (ddPutUnderAlr != nil) return ddPutUnderAlr;
    else return playerActionMessages.alreadyPutUnderMsg;
  }
  //iobjFor(PutUnder) {
  //  verify() {
  //    if (iiPutUnder != nil) illogical(iiPutUnder);
  //    else illogical(&cannotPutUnderMsg);
  //  }
  //}
  cannotPutUnderMsg {
    if (gIobj == self) {
      if (iiPutUnder != nil) return iiPutUnder;
      else return playerActionMessages.cannotPutUnderMsg;
    }
    else return nil;
  }
  // PutBehind
  okayPutBehindMsg {
    if (ddPutBehind != nil) return ddPutBehind;
    else return playerActionMessages.okayPutBehindMsg;
  }
  alreadyPutBehindMsg {
    if (ddPutBehindAlr != nil) return ddPutBehindAlr;
    else return playerActionMessages.alreadyPutBehindMsg;
  }
  //iobjFor(PutBehind) {
  //  verify() {
  //    if (iiPutBehind != nil) illogical(iiPutBehind);
  //    else illogical(&cannotPutBehindMsg);
  //  }
  //}
  cannotPutBehindMsg {
    if (gIobj == self) {
      if (iiPutBehind != nil) return iiPutBehind;
      else return playerActionMessages.cannotPutBehindMsg;
    }
    else return nil;
  }
  // Wear
  notWearableMsg {
    if (ddWear != nil) return ddWear;
    else return playerActionMessages.notWearableMsg;
  }
  // Doff
  notDoffableMsg {
    if (ddDoff != nil) return ddDoff;
    else return playerActionMessages.notDoffableMsg;
  }
  // Kiss
  cannotKissMsg {
    if (ddKiss != nil) return ddKiss;
    else return playerActionMessages.cannotKissMsg;
  }
  // Ask
  dobjFor(Ask) {
    action() {
      if (dddAsk != nil) // note "ddd"
        mainReport(ddAsk);
      else
        askForTopic(AskAbout);
    }
  }
  // Tell
  dobjFor(Tell) {
    action() {
      if (dddTell != nil) // note "ddd"
        mainReport(ddTell);
      else
        askForTopic(TellAbout);
    }
  }
  // AskFor
  dobjFor(AskFor) {
    verify() {
      if (ddAskFor != nil) illogical(ddAskFor);
      else illogical(&notAddressableMsg, self);
    }
  }
  // AskAbout
  dobjFor(AskAbout) {
    verify() {
      if (ddAskAbout != nil) illogical(ddAskAbout);
      else illogical(&notAddressableMsg, self);
    }
  }
  // TellAbout
  dobjFor(TellAbout) {
    verify() {
      if (ddTellAbout != nil) illogical(ddTellAbout);
      else illogical(&notAddressableMsg, self);
    }
  }
  // TalkTo
  dobjFor(TalkTo) {
    verify() {
      if (ddTalkTo != nil) illogical(ddTalkTo);
      else illogical(&notAddressableMsg, self);
    }
  }
  // GiveTo
  //Thing doesn't have dobjForAction(GiveTo), so StrangeThing needn't 
  //have it either, I guess.
  //dobjFor(GiveTo) {
  //  action() {
  //    if (dddGive != nil) // note "ddd"
  //      mainReport(ddGive);
  //    else
  //      askForIobj(GiveTo);
  //  }
  //}
  iobjFor(GiveTo) {
    verify() {
      if (iiGiveTo != nil) illogical(iiGiveTo);
      else illogical(&notInterestedMsg, self);
    }
  }
  // Show
  dobjFor(Show) {
    action() {
      if (dddShow != nil) // note "ddd"
        mainReport(ddShow);
      else
        askForIobj(ShowTo);
    }
  }
  // ShowTo
  dobjFor(ShowTo) {
    //verify() {
    //  if (isHeldBy(gActor)) { }
    //  else if (isIn(gActor)) {
    //    logicalRank(80, 'not held');
    //  }
    //  else {
    //    logicalRank(70, 'not carried');
    //  }
    //}
    check() {
      if (ddShowTo != nil) {
        say(ddShowTo);
        exit;
      }
    }
  }
  iobjFor(ShowTo) {
    verify() {
      if (iiShowTo != nil) illogical(iiShowTo);
      else illogical(&notInterestedMsg, self);
    }
  }
  // Follow
  notFollowableMsg {
    if (ddFollow != nil) return ddFollow;
    else return playerActionMessages.notFollowableMsg;
  }
  // Hit
  dobjFor(Hit) {
    action() {
      if (ddHit != nil) mainReport(ddHit);
      else mainReport(&uselessToHitMsg);
    }
  }
  uselessToHitMsg {
    if (ddHit != nil) return ddHit;
    else if (ddHitWith!= nil) return ddHitWith;
    else return playerActionMessages.uselessToHitMsg;
  }
  // HitWith
  dobjFor(HitWith) {
    action() {
      if (ddHitWith != nil) mainReport(ddHitWith);
      else mainReport(&uselessToHitMsg);
    }
  }
  iobjFor(HitWith) {
    verify() {
      if (iiHitWith != nil) illogical(iiHitWith);
      else illogical(&notAHittingInstrument);
    }
  }
  //notAHittingInstrument {
  //  if (iiHitWith != nil) return iiHitWith;
  //  else return playerActionMessages.notAHittingInstrument;
  //}
  // Attack
  dobjFor(Attack) {
    action() {
      if (ddAttack != nil) mainReport(ddAttack);
      else mainReport(&uselessToAttackMsg);
    }
  }
  uselessToAttackMsg {
    if (ddAttack != nil) return ddAttack;
    else if (ddAttackWith!= nil) return ddAttackWith;
    else return playerActionMessages.uselessToAttackMsg;
  }
  // AttackWith
  dobjFor(AttackWith) {
    action() {
      if (ddAttackWith != nil) mainReport(ddAttackWith);
      else mainReport(&uselessToAttackMsg);
    }
  }
  notAWeaponMsg {
    if (gIobj == self) {
      if (iiAttackWith != nil) return iiAttackWith;
      else return playerActionMessages.notAWeaponMsg;
    }
    else return nil;
  }
  // Throw
  dobjFor(Throw) {
    action() {
      if (dddThrow != nil) //note "ddd"
        mainReport(ddThrow);
      else
        askForIobj(ThrowAt);
    }
  }
  // ThrowAt
  dobjFor(ThrowAt) {
    verify() {
      if (ddThrowAt != nil) illogical(ddThrowAt);
      else {
        verifyMoveTo(gActor.getDropDestination(self, nil));
        if (gIobj == self)
          illogicalSelf(&cannotThrowAtSelfMsg);
        if (gIobj != nil && gIobj.isIn(self))
          illogicalNow(&cannotThrowAtContentsMsg);
      }
    }
  }
  iobjFor(ThrowAt) {
    verify() {
      if (iiThrowAt != nil) illogical(iiThrowAt);
    }
  }
  // ThrowTo
  //dobjFor(ThrowTo) {
  //  verify() {
  //    if (ddThrowTo != nil) illogical(ddThrowTo);
  //    else verifyDobjThrowAt();
  //  }
  //}
  iobjFor(ThrowTo) {
    verify() {
      if (iiThrowTo != nil) illogical(iiThrowTo);
      else illogical(&willNotCatchMsg, self);
    }
  }
  //willNotCatch {
  //  if (gIobj == self) {
  //    if (iiThrowTo != nil) return iiThrowTo;
  //    else return playerActionMessages.willNotCatch;
  //  }
  //  else return nil;
  //}
  // Dig
  dobjFor(Dig) {
    action() {
      if (dddDig != nil) // note "ddd"
        mainReport(ddDig);
      else
        askForIobj(DigWith);
    }
  }
  // DigWith
  cannotDigMsg {
    if (ddDigWith != nil) return ddDigWith;
    else return playerActionMessages.cannotDigMsg;
  }
  cannotDigWithMsg {
    if (iiDigWith != nil) return iiDigWith;
    else return playerActionMessages.cannotDigWithMsg;
  }
  // JumpOver
  cannotJumpOverMsg {
    if (ddJumpOver != nil) return ddJumpOver;
    else return playerActionMessages.cannotJumpOverMsg;
  }
  // JumpOff
  cannotJumpOffMsg {
    if (ddJumpOff != nil) return ddJumpOff;
    else return playerActionMessages.cannotJumpOffMsg;
  }
  // Push
  pushNoEffectMsg {
    if (ddPush != nil) return ddPush;
    else return playerActionMessages.pushNoEffectMsg;
  }
  // Pull
  pullNoEffectMsg {
    if (ddPull != nil) return ddPull;
    else return playerActionMessages.pullNoEffectMsg;
  }
  // Move
  dobjFor(Move) {
    action() {
      if (ddMove != nil) mainReport(ddMove);
      else reportFailure(&moveNoEffectMsg);
    }
  }
  // MoveWith
  dobjFor(MoveWith) {
    action() {
      if (ddMoveWith != nil) mainReport(ddMoveWith);
      else reportFailure(&moveNoEffectMsg);
    }
  }
  cannotMoveWithMsg {
    if (gIobj == self) {
      if (iiMoveWith != nil) return iiMoveWith;
      else return playerActionMessages.cannotMoveWithMsg;
    }
    else return nil;
  }
  // MoveTo
  moveToNoEffectMsg {
    if (ddMoveTo != nil) return ddMoveTo;
    else return playerActionMessages.moveToNoEffectMsg;
  }
  // Turn
  dobjFor(Turn) {
    verify() {
      if (ddTurn != nil) illogical(ddTurn);
      else illogical(&cannotTurnMsg);
    }
  }
  // TurnTo
  dobjFor(TurnTo) {
    verify() {
      if (ddTurnTo != nil) illogical(ddTurnTo);
      else illogical(&cannotTurnMsg);
    }
  }
  // TurnWith
  dobjFor(TurnWith) {
    verify() {
      if (ddTurnWith != nil) illogical(ddTurnWith);
      else illogical(&cannotTurnMsg);
    }
  }
  cannotTurnWithMsg {
    if (gIobj == self) {
      if (iiTurnWith != nil) return iiTurnWith;
      else return playerActionMessages.cannotTurnWithMsg;
    }
    else return nil;
  }
  // Consult
  dobjFor(Consult) {
    verify() {
      if (ddConsult != nil) illogical(ddConsult);
      else illogical(&cannotConsultMsg);
    }
  }
  // ConsultAbout
  dobjFor(ConsultAbout) {
    verify() {
      if (ddConsultAbout != nil) illogical(ddConsultAbout);
      else illogical(&cannotConsultMsg);
    }
  }
  // SetTo
  dobjFor(SetTo) {
    verify() {
      if (ddSetTo != nil) illogical(ddSetTo);
      else illogical(&cannotDoThatMsg);
    }
  }
  // TypeOn
  dobjFor(TypeOn) {
    verify() {
      if (ddTypeOn != nil) illogical(ddTypeOn);
      else illogical(&cannotTypeOnMsg);
    }
    action() { askForLiteral(TypeLiteralOn); }
  }
  // TypeLiteralOn
  dobjFor(TypeLiteralOn) {
    verify() {
      if (ddTypeLiteralOn != nil) illogical(ddTypeLiteralOn);
      else illogical(&cannotTypeOnMsg);
    }
  }
  // EnterOn
  cannotEnterOnMsg {
    if (ddEnterOn != nil) return ddEnterOn;
    else return playerActionMessages.cannotEnterOnMsg;
  }
  // Switch
  cannotSwitchMsg {
    if (ddSwitch != nil) return ddSwitch;
    else return playerActionMessages.cannotSwitchMsg;
  }
  // Flip
  cannotFlipMsg {
    if (ddFlip != nil) return ddFlip;
    else return playerActionMessages.cannotFlipMsg;
  }
  // TurnOn
  cannotTurnOnMsg {
    if (ddTurnOn != nil) return ddTurnOn;
    else return playerActionMessages.cannotTurnOnMsg;
  }
  // TurnOff
  cannotTurnOffMsg {
    if (ddTurnOff != nil) return ddTurnOff;
    else return playerActionMessages.cannotTurnOffMsg;
  }
  // Light
  dobjFor(Light) {
    action () {
      if (ddLight != nil) mainReport(ddLight);
      else replaceAction(Burn, self);
    }
    //asDobjFor(LookIn)
  }
  // Burn
  dobjFor(Burn) {
    action() {
      if (dddBurn != nil) //note "ddd"
        mainReport(ddBurn);
      else
        askForIobj(BurnWith);
    }
  }
  // BurnWith
  cannotBurnMsg {
    if (ddBurn != nil) return ddBurn;
    else return playerActionMessages.cannotBurnMsg;
  }
  cannotBurnWithMsg {
    if (iiBurnWith != nil) return iiBurnWith;
    else return playerActionMessages.cannotBurnWithMsg;
  }
  // Extinguish
  cannotExtinguishMsg {
    if (ddExtinguish != nil) return ddExtinguish;
    else return playerActionMessages.cannotExtinguishMsg;
  }
  // Attach
  dobjFor(Attach) {
    action() {
      if (dddAttach != nil) // note "ddd"
        mainReport(ddAttach);
      else
        askForIobj(AttachTo);
    }
  }
  // AttachTo
  cannotAttachMsg {
    if (ddAttachTo != nil) return ddAttachTo;
    else return playerActionMessages.cannotAttachMsg;
  }
  cannotAttachToMsg {
    if (iiAttachTo != nil) return iiAttachTo;
    else return playerActionMessages.cannotAttachToMsg;
  }
  // Detach
  dobjFor(Detach) {
    verify() {
      if (ddDetach != nil) illogical(ddDetach);
      else illogical(&cannotDetachMsg);
    }
  }
  // DetachFrom
  dobjFor(DetachFrom) {
    verify() {
      if (ddDetachFrom != nil) illogical(ddDetachFrom);
      else illogical(&cannotDetachMsg);
    }
  }
  cannotDetachFromMsg {
    if (iiDetachFrom != nil) return iiDetachFrom;
    else return playerActionMessages.cannotDetachFromMsg;
  }
  // Break
  shouldNotBreakMsg {
    if (ddBreak != nil) return ddBreak;
    else return playerActionMessages.shouldNotBreakMsg;
  }
  // Cut
  dobjFor(Cut) {
    action() {
      if (dddCut != nil) // note "ddd"
        mainReport(ddCut);
      else
        askForIobj(CutWith);
    }
  }
  // "Cut" previously was not captured by Thing at all.
  // Consider doing something like this. Also replace 
  // VerbRule(CutWithWhat).
  //// Dig
  //dobjFor(Dig) {
  //  action() {
  //    if (dddDig != nil) // note "ddd"
  //      mainReport(ddDig);
  //    else
  //      askForIobj(DigWith);
  //  }
  //}
  // CutWith
  cutNoEffectMsg {
    if (ddCutWith != nil) return ddCutWith;
    else return playerActionMessages.cutNoEffectMsg;
  }
  cannotCutWithMsg {
    if (iiCutWith != nil) return iiCutWith;
    else return playerActionMessages.cannotCutWithMsg;
  }
  // Climb
  dobjFor(Climb) {
    verify() {
      if (ddClimb != nil) illogical(ddClimb);
      else illogical(&cannotClimbMsg);
    }
  }
  // ClimbUp
  dobjFor(ClimbUp) {
    verify() {
      if (ddClimbUp != nil) illogical(ddClimbUp);
      else illogical(&cannotClimbMsg);
    }
  }
  // ClimbDown
  dobjFor(ClimbDown) {
    verify() {
      if (ddClimbDown != nil) illogical(ddClimbDown);
      else illogical(&cannotClimbMsg);
    }
  }
  // Open
  cannotOpenMsg {
    if (ddOpen != nil) return ddOpen;
    else return playerActionMessages.cannotOpenMsg;
  }
  // Close
  cannotCloseMsg {
    if (ddClose != nil) return ddClose;
    else return playerActionMessages.cannotCloseMsg;
  }
  // Lock
  dobjFor(Lock) {
    verify() {
      if (ddLock != nil) illogical(ddLock);
      else illogical(&cannotLockMsg);
    }
  }
  // LockWith
  dobjFor(LockWith) {
    verify() {
      if (ddLockWith != nil) illogical(ddLockWith);
      else illogical(&cannotLockMsg);
    }
  }
  cannotLockWithMsg {
    if (gIobj == self) {
      if (iiLockWith != nil) return iiLockWith;
      else return playerActionMessages.cannotLockWithMsg;
    }
    else return nil;
  }
  // Unlock
  dobjFor(Unlock) {
    verify() {
      if (ddUnlock != nil) illogical(ddUnlock);
      else illogical(&cannotUnlockMsg);
    }
  }
  // UnlockWith
  dobjFor(UnlockWith) {
    verify() {
      if (ddUnlockWith != nil) illogical(ddUnlockWith);
      else illogical(&cannotUnlockMsg);
    }
  }
  cannotUnlockWithMsg {
    if (gIobj == self) {
      if (iiUnlockWith != nil) return iiUnlockWith;
      else return playerActionMessages.cannotUnlockWithMsg;
    }
    else return nil;
  }
  // Eat
  cannotEatMsg {
    if (ddEat != nil) return ddEat;
    else return playerActionMessages.cannotEatMsg;
  }
  // Drink
  cannotDrinkMsg {
    if (ddDrink != nil) return ddDrink;
    else return playerActionMessages.cannotDrinkMsg;
  }
  // Pour
  dobjFor(Pour) {
    verify() {
      if (ddPour != nil) illogical(ddPour);
      else illogical(&cannotPourMsg);
    }
  }
  // PourInto
  dobjFor(PourInto) {
    verify() {
      if (ddPourInto != nil) illogical(ddPourInto);
      else illogical(&cannotPourMsg);
    }
  }
  cannotPourIntoMsg {
    if (iiPourInto != nil) return iiPourInto;
    else return playerActionMessages.cannotPourIntoMsg;
  }
  // PourOnto
  dobjFor(PourOnto) {
    verify() {
      if (ddPourOnto != nil) illogical(ddPourOnto);
      else illogical(&cannotPourMsg);
    }
  }
  cannotPourOntoMsg {
    if (iiPourOnto != nil) return iiPourOnto;
    else return playerActionMessages.cannotPourIntoMsg;
  }
  // Clean
  dobjFor(Clean) {
    verify() {
      if (ddClean != nil) illogical(ddClean);
      else illogical(&cannotCleanMsg);
    }
  }
  // CleanWith
  dobjFor(CleanWith) {
    verify() {
      if (ddCleanWith != nil) illogical(ddCleanWith);
      else illogical(&cannotCleanMsg);
    }
  }
  cannotCleanWithMsg {
    if (iiCleanWith != nil) return iiCleanWith;
    else return playerActionMessages.cannotCleanWithMsg;
  }
  // SitOn
  cannotSitOnMsg {
    if (ddSitOn != nil) return ddSitOn;
    else return playerActionMessages.cannotSitOnMsg;
  }
  // LieOn
  cannotLieOnMsg {
    if (ddLieOn != nil) return ddLieOn;
    else return playerActionMessages.cannotLieOnMsg;
  }
  // StandOn
  cannotStandOnMsg {
    if (ddStandOn != nil) return ddStandOn;
    else return playerActionMessages.cannotStandOnMsg;
  }
  // Board
  cannotBoardMsg {
    if (ddBoard != nil) return ddBoard;
    else return playerActionMessages.cannotBoardMsg;
  }
  // GetOutOf
  cannotUnboardMsg {
    if (ddGetOutOf != nil) return ddGetOutOf;
    else return playerActionMessages.cannotUnboardMsg;
  }
  // GetOffOf
  cannotGetOffOfMsg {
    if (ddGetOffOf != nil) return ddGetOffOf;
    else return playerActionMessages.cannotGetOffOfMsg;
  }
  // Fasten
  dobjFor(Fasten) {
    verify() {
      if (ddFasten != nil) illogical(ddFasten);
      else illogical(&cannotFastenMsg);
    }
  }
  // FastenTo
  dobjFor(FastenTo) {
    verify() {
      if (ddFastenTo != nil) illogical(ddFastenTo);
      else illogical(&cannotFastenMsg);
    }
  }
  cannotFastenToMsg {
    if (iiFastenTo != nil) return iiFastenTo;
    else return playerActionMessages.cannotFastenToMsg;
  }
  // Unfasten
  dobjFor(Unfasten) {
    verify() {
      if (ddUnfasten != nil) illogical(ddUnfasten);
      else illogical(&cannotUnfastenMsg);
    }
  }
  // UnfastenFrom
  dobjFor(UnfastenFrom) {
    verify() {
      if (ddUnfastenFrom != nil) illogical(ddUnfastenFrom);
      else illogical(&cannotUnfastenMsg);
    }
  }
  cannotUnfastenFromMsg {
    if (iiUnfastenFrom != nil) return iiUnfastenFrom;
    else return playerActionMessages.cannotUnfastenFromMsg;
  }
  // PlugIn
  dobjFor(PlugIn) {
    verify() {
      if (ddPlugIn != nil) illogical(ddPlugIn);
      else illogical(&cannotPlugInMsg);
    }
  }
  // PlugInto
  dobjFor(PlugInto) {
    verify() {
      if (ddPlugInto != nil) illogical(ddPlugInto);
      else illogical(&cannotPlugInMsg);
    }
  }
  cannotPlugInToMsg {
    if (iiPlugInto != nil) return iiPlugInto;
    else return playerActionMessages.cannotPlugInToMsg;
  }
  // Unplug
  dobjFor(Unplug) {
    verify() {
      if (ddUnplug != nil) illogical(ddUnplug);
      else illogical(&cannotUnplugMsg);
    }
  }
  // UnplugFrom
  dobjFor(UnplugFrom) {
    verify() {
      if (ddUnplugFrom != nil) illogical(ddUnplugFrom);
      else illogical(&cannotUnplugMsg);
    }
  }
  cannotUnplugFromMsg {
    if (ddUnplugFrom != nil) return ddUnplugFrom;
    else return playerActionMessages.cannotUnplugFromMsg;
  }
  // Screw
  dobjFor(Screw) {
    verify() {
      if (ddScrew != nil) illogical(ddScrew);
      else illogical(&cannotScrewMsg);
    }
  }
  // ScrewWith
  dobjFor(ScrewWith) {
    verify() {
      if (ddScrewWith != nil) illogical(ddScrewWith);
      else illogical(&cannotScrewMsg);
    }
  }
  cannotScrewWithMsg {
    if (iiScrewWith != nil) return iiScrewWith;
    else return playerActionMessages.cannotScrewWithMsg;
  }
  // Unscrew
  dobjFor(Unscrew) {
    verify() {
      if (ddUnscrew != nil) illogical(ddUnscrew);
      else illogical(&cannotUnscrewMsg);
    }
  }
  // UnscrewWith
  dobjFor(UnscrewWith) {
    verify() {
      if (ddUnscrewWith != nil) illogical(ddUnscrewWith);
      else illogical(&cannotUnscrewMsg);
    }
  }
  cannotUnscrewWithMsg {
    if (iiUnscrewWith != nil) return iiUnscrewWith;
    else return playerActionMessages.cannotUnscrewWithMsg;
  }
  // Enter
  cannotEnterMsg {
    if (ddEnter != nil) return ddEnter;
    else return playerActionMessages.cannotEnterMsg;
  }
  // GoThrough
  cannotGoThroughMsg {
    if (ddGoThrough != nil) return ddGoThrough;
    else return playerActionMessages.cannotGoThroughMsg;
  }
  // PushTravel
  cannotPushTravelMsg {
    if (ddPushTravel != nil) return ddPushTravel;
    else return playerActionMessages.cannotPushTravelMsg;
  }
  // ShootWith
  iobjFor(ShootWith) {
    verify() {
      if (iiShootWith) illogical(iiShootWith);
      else illogical(&cannotShootWithMsg, self);
    }
  }
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: MessageResult modifications
// -------------------------------------------------------------------

// It will help me immensely if a message property like
// notAContainerMsg can be nil without producing a run-time error.
// This functionality was added to TADS 3.0.9, so I am modifying
// MessageResult within this 3.0.8 game to behave as it does
// in 3.0.9. (And I hope this change produces no unintended 
// consequences.)

modify MessageResult
    construct(msg, [params]) {
        // if we're based on an existing object, copy its characteristics
        if (dataType(msg) == TypeObject && msg.ofKind(MessageResult)) {
            // base it on the existing object
            messageText_ = msg.messageText_;
            messageProp_ = msg.messageProp_;
            return;
        }
        // if the message was given as a property, remember the property
        // for identification purposes 
        if (dataType(msg) == TypeProp)
            messageProp_ = msg;
        // Resolve the message and store the text.  Use the action's
        // objects (the direct object, indirect object, etc) as the
        // sources for message overrides - this makes it easy to override
        // messages on a per-object basis without having to rewrite the
        // whole verify/check/action routines. 
        messageText_ = resolveMessageText(gAction.getCurrentObjects(),
                                          msg, params);
    }
    // Static method: resolve a message.  If the message is given as a
    // property, we'll look up the message in the given source objects
    // and in the actor's "action messages" object.  We'll return the
    // resolved message string.  
    resolveMessageText(sources, msg, params) {
        
        // Added 2016-11-09 to match changes to TADS 3
        // If we have more than one source object, it means that the
        // command has more than one object slot (such as a TIAction,
        // which has direct and indirect objects).  Rearrange the list so
        // that the nearest caller is the first object in the list.  If
        // one of these source objects provides an override, we generally
        // want to get the message from the immediate caller rather than
        // the other object.  Note that we only care about the *first*
        // source object we find in the stack trace, because we only care
        // about the actual message generator call; enclosing calls
        // aren't relevant to the message priority because they don't
        // necessarily have anything to do with the messaging.  
        if (sources.length() > 1)
        {
            // look through the stack trace for a 'self' in the source list
            local tr = t3GetStackTrace();
            for (local i = 1, local trCnt = tr.length() ; i <= trCnt ; ++i)
            {
                // check this 'self'
                local s = tr[i].self_;
                local sIdx = sources.indexOf(s);
                if (sIdx != nil)
                {
                    // it's a match - move this object to the head of the
                    // list so that we give its message bindings priority
                    if (sIdx != 1)
                        sources = [s] + (sources - s);
                    // no need to look any further
                    break;
                }
            }
        }
        // End stuff added 2016-11-09
        
        // The message can be given either as a string or as a property
        // of the actor's verb message object.  If it's the latter, look
        // up the text of the property from the appropriate object.  
    findTextSource:
        if (dataType(msg) == TypeProp) {
            local msgObj;
            // Presume that we'll read the message from the current
            // actor's "action message object."  This is typically
            // playerActionMessages or npcActionMessages, but it's up to
            // the actor to specify which object we get our messages
            // from.  
            msgObj = gActor.getActionMessageObj();
            // First, look up the message property in the action's
            // objects (the direct object, indirect object, etc).  This
            // makes it easy to override messages on a per-object basis
            // without having to rewrite the whole verify/check/action
            // routine.  
            foreach (local cur in sources) {
                // check to see if this object defines the message property
                if (cur != nil && cur.propDefined(msg)) {
                    local res;
                    // This object defines the property, so check what
                    // we have. 
                    switch (cur.propType(msg)) {
                    case TypeProp:
                        // It's another property, so we're being
                        // directed back to the player action message
                        // object.  The object does override the
                        // message, but the override points to another
                        // message property in the action object message
                        // set.  Simply redirect 'msg' to point to the
                        // new property, and use the same action message
                        // object we already assumed we'd use.  
                        msg = cur.(msg);
                        break;
                    case TypeSString:
                        // it's a simple string - retrieve it
                        msg = cur.(msg);
                        // since it's just a string, we're done finding
                        // the message text - there's no need to do any
                        // further property lookup, since we've obviously
                        // reached the end of that particular line 
                        break findTextSource;
                    case TypeCode:
                        // Check the parameter count - we'll allow this
                        // method to take the full set of parameters, or
                        // no parameters at all.  We allow the no-param
                        // case for convenience in cases where the method
                        // simply wants to return a string or property ID
                        // from a short method that doesn't need to know
                        // the parameters; in these cases, it's
                        // syntactically a lot nicer looking to write it
                        // as a "prop = (expresion)" than to write the
                        // full method-with-params syntax. 
                        if (cur.getPropParams(msg) == [0, 0, nil])
                            res = cur.(msg);
                        else
                            res = cur.(msg)(params...);
                        // If that returned nil, ignore it entirely and
                        // keep scanning the remaining source objects.
                        // The object must have decided it didn't want to
                        // provide the message override in this case
                        // after all. 
                        if (res == nil)
                            continue;
                        // we didn't get nil, so use the result
                        msg = res;
                        // if we got a string, we've fully resolved the
                        // message text, so we can stop searching for it 
                        if (dataType(msg) == TypeSString)
                            break findTextSource;
                        // It's not nil and it's not a string, so it must
                        // be a property ID.  In this case, the property
                        // ID is a property to evaluate in the normal
                        // action message object.  Simply proceed to
                        // evaluate the new message property as normal.  
                        break;
                    case TypeNil:
                        // it's explicitly nil, which simply means to
                        // ignore this definition; keep scanning other
                        // source objects 
                        continue;
                    default:
                        // In any other case, this must simply be the
                        // message we're to use.  For this case, the
                        // source of the message is this object, so
                        // forget about the normal action message object
                        // and instead use the current object.  Then
                        // proceed to evaluate the message property as
                        // normal, which will fetch it from the current
                        // object.  
                        msgObj = cur;
                        break;
                    }
                    // we found a definition, so we don't need to look
                    // at any of the other objects involved in the
                    // action - we just use the first override we find 
                    break;
                }
            }
            // look up the message in the actor's message generator
            msg = msgObj.(msg)(params...);
        }
        // format the string and remember the result - do the formatting
        // immediately, because we want to make sure we expand any
        // substitution parameters in the context of the current
        // command, since the parameters might change (and thus alter
        // the meaning of the message) by the time it's displayed 
        msg = langMessageBuilder.generateMessage(msg);
        // "quote" the message text - it's fully expanded now, so
        // there's no need to further expand anything that might by
        // coincidence look like substitution parameters in its text 
        msg = langMessageBuilder.quoteMessage(msg);
        // return the resolved message string
        return msg;
    }
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts
// -------------------------------------------------------------------

/*
When you lose the game by destroying the moon:
THE SHIP'S WEAPON FIRES AND YOU NOTICE ON THE SCREEN THAT THE MOON
IS DESTROYED. AN INSTANT LATER, LARGE FRAGMENTS OF MOON COLLIDE WITH
THE EARTH, DESTROYING IT AND YOU, TOO. YOU ARE DEAD. YOU HAVE
COMPLETED 80 PERCENT OF YOUR MISSION.

When you lose the game by destroying the earth:
A WEAPON IN THE SHIP IS FIRED AND THE PLANET EARTH IS DESTROYED,
NOT TO MENTION YOU. YOU ARE DEAD. YOU HAVE COMPLETED 80 PERCENT
OF YOUR MISSION.

When you shoot at some ordinary object:
> SHOOT SAND WITH SHOTGUN
BLAM! THERE ARE SEVERAL NEW HOLES IN THE MOUND OF SAND.
> EXAMINE SAND
THERE'S NOTHING SPECIAL ABOUT THE MOUND OF SAND.
> SHOOT CROWBAR WITH SHOTGUN
BLAM! THERE ARE SEVERAL NEW HOLES IN THE SMALL CROWBAR.
> EXAMINE CROWBAR
THERE'S NOTHING SPECIAL ABOUT THE SMALL CROWBAR.

When you fire the shotgun at itself:
> SHOOT SHOTGUN WITH SHOTGUN
BLAM! THERE ARE SEVERAL NEW HOLES IN THE SHOTGUN.
> EXAMINE SHOTGUN
THERE'S NOTHING SPECIAL ABOUT THE SHOTGUN.

[You can't fire at "me," because there is no "me."]

When you kill something:
> SHOOT SNAKE WITH SHOTGUN
BLAM! GOOD SHOT! THE SNAKE IS DEAD.
> SHOOT ALIEN WITH SHOTGUN
BLAM! THE ALIEN IS LIFTED AND THROWN BACKWARDS BY THE IMPACT OF THE 
BLAST. ITS LIMP BODY FALLS TO THE GROUND. THE ALIEN DIES AND RAPIDLY
DECAYS TO DUST BEFORE YOUR EYES.
*/

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: shotgun
// -------------------------------------------------------------------

shotgun: ArtifactGun
  vocabWords='shot shotgun/gun/firearm/weapon/trigger/artifact*guns*firearms*weapons*triggers*artifacts'
  name      ='SHOTGUN'
  nickname  ='SHOTGUN'
  artTitle  ='Xenos'
  artAuthor =nil
  artCompany='Robert Arnstein Corporation'
  artComp   ='Robert Arnstein Corporation'
  // The game's walkthrough on the IF Archive says the game is from
  // 1979. I'd like to believe that (it would make it easier to justify
  // claiming that the game is historically important and worthy of inclusion
  // prior to Scott Adams), but every other source says 1982.
  artYear   ='1982'
  // I no longer remember what artAttr & artAttrib mean. :-/
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.xenos>'
  artHtml2  ='<./xenos>'
  //ammo = 2
  artDesc() {
    if (ammo > 0)
      "THE SHOTGUN IS LOADED! ";
    else
      "THERE<./s>S NOTHING SPECIAL ABOUT THE SHOTGUN. ";
  }
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  // parsing stuff
  //parseFailMsg = '?VERB? ' + gAction.getOrigTokenList[1][1].toUpper() + ' '
  parseFailMsg = '?VERB? '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         ='THERE<./s>S NO WRITING ON THE SHOTGUN. '
  dLookIn       ='CONCENTRATE AS YOU MAY, YOU CAN NOT SEE ANYTHING IN THE SHOTGUN. '
  dobjFor(Search) asDobjFor(Examine)
  dLookUnder    ='THERE<./s>S NOTHING UNDER THE SHOTGUN. '
  dLookBehind   ='THERE IS NOTHING BEHIND THE SHOTGUN. '
  dLookThrough  ='CONCENTRATE AS YOU MAY, YOU CAN NOT SEE ANYTHING IN THE SHOTGUN. '
  dListenTo     =nil
  dSmell        =nil
  dTaste        ='IT TASTES LIKE A SHOTGUN ' //sic
  dFeel         =nil
  dTake         ='THE SHOTGUN TAKEN. '
  dTakeAlr      ='YOU ALREADY HAVE THE SHOTGUN. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='DROPPED. '
  dDropAlr      ='DROPPED. ' //sic
  dPutIn        ='BY YOUR COMMAND. '
  dPutInAlr     ='THE SHOTGUN TAKEN. BY YOUR COMMAND. '
  iPutIn        ='IT IS PHYSICALLY IMPOSSIBLE FOR TWO OBJECTS TO OCCUPY THE SAME SPACE AT THE SAME TIME. '
  dPutOn        ='BY YOUR COMMAND. '
  dPutOnAlr     ='THE SHOTGUN TAKEN. BY YOUR COMMAND. '
  iPutOn        ='THERE<./s>S NOT ENOUGH ROOM. '
  //dPutUnder     ='BY YOUR COMMAND. ' // I wanted to replace this with Drop, but it didn't work somehow. I gave up; it wasn't worth trying.
  dobjFor(PutUnder) remapTo(Drop, self)
  //dPutUnderAlr  ='THE SHOTGUN TAKEN. BY YOUR COMMAND. '
  //iPutUnder() { local h=0; h=10/h; }
  iPutUnder     ='THERE<./s>S NOT ENOUGH ROOM. '
  dobjFor(PutBehind) remapTo(Drop, self)
  //dPutBehind    ='BY YOUR COMMAND. ' // I wanted to replace this with Drop, but it didn't work somehow. I gave up; it wasn't worth trying.
  //dPutBehindAlr ='THE SHOTGUN TAKEN. BY YOUR COMMAND. '
  iPutBehind    ='THERE<./s>S NOT ENOUGH ROOM. '
  dWear         =nil
  dDoff         =nil
  dKiss         =nil
  dAsk     /*!*/=nil
  dAskFor       =nil
  dAskAbout     =nil
  dTell    /*!*/=nil
  dTellAbout    =nil
  dTalkTo       =nil
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='THE SHOTGUN DOESN<./s>T WANT IT. '
  dShow    /*!*/=nil
  dShowTo       =nil
  iShowTo       =nil
  dFollow       ='?PHRASE? '
  dHit          =true
  dHitWith      =true
  iHitWith      =true
  dAttack       =true
  dAttackWith   =true
  iAttackWith   =true
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='THE SHOTGUN DOESN<./s>T WANT IT. '
  dDig     /*!*/=true // asks for iobj
  dDigWith      ='I DIG IT TOO, MAN! '
  iDigWith      ='I DIG IT TOO, MAN! '
  dJumpOver     ='YOUR SUCCESS IS MEASURED IN LEAPS AND BOUNDS! '
  dJumpOff      ='?PHRASE? '
  dPush         ='WHY DON<./s>T YOU LEAVE THE POOR SHOTGUN ALONE. '
  dPull         ='WHY DON<./s>T YOU LEAVE THE POOR SHOTGUN ALONE. '
  dMove         ='WHY DON<./s>T YOU LEAVE THE POOR SHOTGUN ALONE. '
  dMoveWith     ='WHY DON<./s>T YOU LEAVE THE POOR SHOTGUN ALONE. '
  iMoveWith {
    if (gDobj)
      return 'WHY DON<./s>T YOU LEAVE THE POOR ' + gDobj.name.toUpper() + ' ALONE. ';
    else
      return 'WHY DON<./s>T YOU LEAVE THE POOR THING ALONE. ';
  }
  dMoveTo       ='?PHRASE? '
  iMoveTo       ='?PHRASE? '
  dTurn         ='YOU CAN<./s>T DO THAT! '
  dTurnWith     ='YOU CAN<./s>T DO THAT! '
  iTurnWith     ='?PHRASE? '
  dTurnTo       ='?PHRASE? '
  dConsult      =nil
  dConsultAbout =nil
  dSetTo        =nil
  dTypeOn       =nil
  dTypeLiteralOn=nil
  dEnterOn      ='?PHRASE? '
  dSwitch       =nil
  dFlip         =nil
  dTurnOn       ='YOU CAN<./s>T DO THAT! '
  dTurnOff      ='BEFORE YOU CAN TURN SOMETHING OFF, IT MUST BE TURNED ON. '
  dLight        =' ' //sic
  dStrike       ='USE <./s>ATTACK<./s> '
  dBurn    /*!*/=' ' //sic
  dBurnWith     =' ' //sic
  iBurnWith     =' ' //sic
  dExtinguish   ='THE SHOTGUN IS NOT BURNING. '
  dAttach  /*!*/=nil
  dAttachTo     =nil
  iAttachTo     =nil
  dDetach       =nil
  dDetachFrom   =nil
  iDetachFrom   =nil
  dBreak        ='YOU TRIED, BUT YOU COULDN<./s>T DO IT. '
  dCut     /*!*/=nil
  dCutWith      =nil
  iCutWith      =nil
  dClimb        ='EVEN IF YOU COULD CLIMB THE SHOTGUN IT WOULDN<./s>T HELP YOU. '
  dClimbUp      ='EVEN IF YOU COULD CLIMB THE SHOTGUN IT WOULDN<./s>T HELP YOU. '
  dClimbDown    ='EVEN IF YOU COULD CLIMB THE SHOTGUN IT WOULDN<./s>T HELP YOU. '
  dOpen         ='YOU TRIED, BUT YOU COULDN<./s>T DO IT. '
  dClose        ='YOU TRIED, BUT YOU COULDN<./s>T DO IT. '
  dLock         ='YOU TRIED, BUT YOU COULDN<./s>T DO IT. '
  dLockWith     ='YOU TRIED, BUT YOU COULDN<./s>T DO IT. '
  iLockWith     ='YOU TRIED, BUT YOU COULDN<./s>T DO IT. '
  dUnlock       ='YOU TRIED, BUT YOU COULDN<./s>T DO IT. '
  dUnlockWith   ='YOU TRIED, BUT YOU COULDN<./s>T DO IT. '
  iUnlockWith   ='YOU TRIED, BUT YOU COULDN<./s>T DO IT. '
  dEat          ='DON<./s>T BE SILLY! THE SHOTGUN WOULDN<./s>T TASTE GOOD ANYWAY. '
  dDrink        ='YOU<./sRE SICK, BUT NOT HALF AS SICK AS YOU WOULD BE IF YOU DRANK THE SHOTGUN. '
  dPour         ='POOR SHOTGUN '
  dPourInto     ='POOR SHOTGUN '
  iPourInto     ='POOR SHOTGUN '
  dPourOnto     ='POOR SHOTGUN '
  iPourOnto     ='POOR SHOTGUN '
  dClean        =nil
  dCleanWith    =nil
  iCleanWith    =nil
  dSitOn        ='PLEASE USE DIRECTIONS N,S,E, OR W. '
  dLieOn        =nil
  dStandOn      =nil
  dBoard        =nil
  dGetOutOf     =nil
  dGetOffOf     =nil
  dFasten       =nil
  dFastenTo     =nil
  iFastenTo     =nil
  dUnfasten     =nil
  dUnfastenFrom =nil
  iUnfastenFrom =nil
  dPlugIn       =nil
  dPlugInto     =nil
  iPlugInto     =nil
  dUnplug       =nil
  dUnplugFrom   =nil
  iUnplugFrom   =nil
  dScrew        =nil
  dScrewWith    =nil
  iScrewWith    =nil
  dUnscrew      =nil
  dUnscrewWith  =nil
  iUnscrewWith  =nil
  dGoThrough    ='PLEASE USE DIRECTIONS N,S,E, OR W. '
  dEnter        ='PLEASE USE DIRECTIONS N,S,E, OR W. '
  dPushTravel   ='?PHRASE? '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
//  bang() {
//    if (ammo <= 0) {
//      "<.xenos>CLICK. <./xenos>";
//      return nil;
//    }
//    else ammo = ammo - 1;
//    return true;
//  }
//  bangWeapon() {
//    "<.xenos>BLAM! <./xenos>";
//    //ammoReport();
//  }
//  bangTarget() {
//    // Do not permit the destruction of the actor or anything 
//    // the actor is in.
//    if (!gDobj.ofKind(Actor)) {
//      // Following the model of Xenos, we report "several new holes"
//      // in the target, without actually changing the state of the
//      // target in any way.
//      "<.xenos>BLAM! THERE ARE SEVERAL NEW HOLES IN
//        <<gDobj.theName.toUpper()>>. <./xenos>";
//    }
//    else /*if (gDobj.ofKind(Alien))*/ {
//      "<.xenos>BLAM! THE ALIEN IS LIFTED AND THROWN BACKWARDS 
//        BY THE IMPACT OF THE BLAST. ITS LIMP BODY FALLS TO THE GROUND. 
//        THE ALIEN DIES AND RAPIDLY DECAYS TO DUST BEFORE YOUR 
//        EYES. <./xenos>";
//      gDobj.moveInto(nil);
//    }
//    //else {
//    //}
//  }
  tangibleProjectiles = true
  ammo = 2
  ammoDecrement = 1
  shootEffectEnemy {
    sayForArt(shootPrefixMsg(gDobj, slowingField));
    sayForArt('THE ALIEN IS LIFTED AND THROWN BACKWARDS 
      BY THE IMPACT OF THE BLAST. HIS LIMP BODY FALLS TO THE GROUND. 
      THE ALIEN DIES AND RAPIDLY DECAYS TO DUST BEFORE YOUR 
      EYES. ');
    doShootResult(gDobj, vaporize);
  }
  //shootEffectWindow {
  //  sayForArt(shootPrefixMsg(gDobj, nil));
  //  sayForArt('THE WINDOW IS STRONGER THAN IT LOOKS; 
  //    IT RESISTS THE BLAST. ');
  //}
  
  // Commented out because this is now part of the Thing 
  // modifications above:
  //sayForArt(msg) {
  //  "<<artHtml1>><<msg>><<artHtml2>>";
  //}
  noAmmoMsg = 'CLICK. '
  shootPrefixMsg(obj, complex) {
    return 'BLAM! ' 
      + throughMsg('THE SHOTGUN PELLETS PASS THROUGH ',' WITHOUT VISIBLE EFFECT. ',obj, complex);
  }
  shootThingMsg(obj) {
    //gMessageParams(obj);
    return 'THERE ARE SEVERAL NEW HOLES IN '
      + obj.theName.toUpper + '. ';
  }
  shootFriendMsg =
    'YOU JUST MISS ' + gDobj.theName.toUpper + '. '
  //windowTransmitMsg =
  //  'THE WINDOW IS STRONGER THAN IT LOOKS; 
  //    IT RESISTS THE BLAST. '
  windowTransmitMsg {
    if (gDobj != slowingField)
      return 'THE WINDOW IS STRONGER THAN IT LOOKS; 
        IT RESISTS THE BLAST. ';
    else
      return 'THE SHOTGUN PELLETS PASS THROUGH THE SLOWING FIELD
        WITHOUT VISIBLE EFFECT AND STRIKE THE WALLS BEYOND. 
        THERE ARE SEVERAL NEW HOLES IN THE WALLS. ';
  }
  skywayWindowTransmitMsg = ''
  officeWindowTransmitMsg = ''
  slowingFieldTransmitMsg = ''
  // I completely made this up. I didn't take notes on this response
  // when I played Xenos months ago, and I can't get my TRS-80 emulator
  // to run now.
  actorShootingHimselfMsg =
    'YOU DON<./s>T WANT TO SHOOT YOURSELF. '
  gunShootingItselfMsg =
    'YOU CAN<./s>T DO THAT. '
  zapT = transform(self, shogun)
  zapAry = disappear(
    'The shotgun disappears! As it does so, the sound of a gunshot
      rings through the room. '
    , self, 'gunshot'
  )
;
//BLAM! THE ALIEN IS LIFTED AND THROWN BACKWARDS BY THE IMPACT OF THE 
//BLAST. ITS LIMP BODY FALLS TO THE GROUND. THE ALIEN DIES AND RAPIDLY
//DECAYS TO DUST BEFORE YOUR EYES.

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: phaser
// -------------------------------------------------------------------

//gunproperties: object
//;
phaser: ArtifactGun, LabeledDial
  vocabWords='(stun) phaser/stunner/gun/firearm/weapon/trigger/artifact*guns*firearms*weapons*triggers*artifacts'
  name      ='Phaser'
  nickname  ='Phaser'
  artTitle  ='Strange Odyssey'
  artAuthor ='Scott Adams'
  artCompany='Adventure International'
  artComp   ='Adventure International'
  artYear   ='1981'
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.odyssey>'
  artHtml2  ='<./odyssey>'
  // Fix desc routine: it prints two \b's, not one, if the
  // gun is examined while in terse mode if there are no
  // items in the room.
  artDesc {
    //"<.odyssey>";
    //tripartiteDesc
    //  ('The Phaser is sitting on the ' + asscPed.name,
    //   'This is the Phaser you got from the ' + asscPed.name,
    //   'Apparently this is the Phaser from ' + titlei(',') + ' by '
    //     + artAuthor);
    //". \n<./odyssey>";
    //"<.odyssey>";
    "Charge left registers:\n";
    if (ammo)
      "<<ammo>>\n
        Phaser is set on:\n
        <<displaySetting>> ";
    else
      "Its empty. ";
    //"<./odyssey>";
    //"A small display on the phaser tells you that the
    //  weapon is set to <q><<curSetting>></q> (rather than
    //  <q><<notCurSetting>></q>), and its remaining energy is <<ammo>>
    //  units.<./odyssey>\b";
    //lookAroundScottAdams();
  }
  //plqDesc() {
  //  "This is the <<nickname>> from <<artTitle>>. ";
  //  recognized = true;
  //}
  dobjFor(All) {
    verify() {
      if (gDobj && 
          (glob.wordsFirstTyped > 2 ||
           glob.wordsLastTyped  > 2)) {
        //nonObvious;
        //parserFailure('<.odyssey>Use 1 or 2 words only
        //  when referring to {the dobj/him}! <./odyssey>');
        reportFailure('<.odyssey>Use 1 or 2 words only
          when using {the dobj/him}! <./odyssey>');
        throw new TerminateCommandException();
      }
      //else if (gDobj && actionIsForbidden) {
      //  "TerminateCommandException. ";
      //  throw new TerminateCommandException();
      //}
      inherited();
    }
  }
  iobjFor(All) {
    verify() {
      if (gIobj &&
          (glob.wordsFirstTyped > 2 ||
           glob.wordsLastTyped  > 2)) {
        //nonObvious;
        //parserFailure();
        //parserFailure('<.odyssey>Use 1 or 2 words only
        //  when referring to {the iobj/him}! <./odyssey>');
        reportFailure('<.odyssey>Use 1 or 2 words only
          when using {the iobj/him}! <./odyssey>');
        throw new TerminateCommandException();
      }
      inherited();
    }
  }
  //actionIsAllowed() {
  //  if (gAction == nil) return nil;
  //  if  (
  //      //   gAction.baseActionClass == ReadAction
  //      //||
  //      gAction.baseActionClass == LookInAction
  //      //|| gAction.baseActionClass == SearchAction
  //      || gAction.baseActionClass == LookUnderAction
  //      || gAction.baseActionClass == LookBehindAction
  //      || gAction.baseActionClass == LookThroughAction
  //      || gAction.baseActionClass == FeelAction
  //      //|| gAction.baseActionClass == WearAction
  //      //|| gAction.baseActionClass == DoffAction
  //      || gAction.baseActionClass == HitAction
  //      || gAction.baseActionClass == HitWithAction
  //      || gAction.baseActionClass == AttackAction
  //      || gAction.baseActionClass == AttackWithAction
  //      || gAction.baseActionClass == ThrowAction
  //      || gAction.baseActionClass == SwitchAction
  //      || gAction.baseActionClass == ThrowAtAction
  //      || gAction.baseActionClass == ThrowToAction
  //      //|| gAction.baseActionClass == PushAction
  //      //|| gAction.baseActionClass == PullAction
  //      //|| gAction.baseActionClass == ClimbAction
  //      //|| gAction.baseActionClass == ClimbUpAction
  //      //|| gAction.baseActionClass == ClimbDownAction
  //      //|| gAction.baseActionClass == MoveAction
  //      //|| gAction.baseActionClass == MoveWithAction
  //      //|| gAction.baseActionClass == MoveToAction
  //      || gAction.baseActionClass == TurnAction
  //      || gAction.baseActionClass == TurnWithAction
  //      || gAction.baseActionClass == TurnToAction
  //      || gAction.baseActionClass == SetToAction
  //      //|| gAction.baseActionClass == BreakAction
  //      //|| gAction.baseActionClass == OpenAction
  //      //|| gAction.baseActionClass == CloseAction
  //      //|| gAction.baseActionClass == DrinkAction
  //      //|| gAction.baseActionClass == FastenAction
  //      //|| gAction.baseActionClass == FastenToAction
  //      || gAction.baseActionClass == ShootAction
  //      || gAction.baseActionClass == ShootAimlesslyAction
  //      || gAction.baseActionClass == ShootWithAction
  //      || gAction.baseActionClass == SetAction
  //      )
  //    return true;
  //  else return nil;
  //}
  // parsing stuff
  parseFailMsg = '<.odyssey>Don<./s>t know how to <.q>' + glob.latestVerb +
                   '<./q> the ' + nickname + '. <./odyssey>'
  objParseList = [SetAction]
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         ='<.odyssey>I can<./s>t do that <./odyssey>'
  dLookIn       =true //'There<./s>s nothing unusual in {the dobj/him}. '
  dSearch       =nil
  dLookUnder    ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dLookBehind   ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dLookThrough  ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dListenTo     =nil //'{You/he} hear{s} nothing out of the ordinary. '
  dSmell        =nil //'{You/he} smell{s} nothing out of the ordinary. '
  dTaste        =nil //'{You/he} taste{s} nothing out of the ordinary. '
  dFeel         ='<.odyssey>OK\nNothing happens <./odyssey>'
  dTake         ='<.odyssey>OK <./odyssey>'
  dTakeAlr      ='<.odyssey>Already have it. <./odyssey>'
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='<.odyssey>OK <./odyssey>'
  dDropAlr      ='<.odyssey>Not carrying it! <./odyssey>'
  dPutIn        ='<.odyssey>OK <./odyssey>'
  dPutInAlr     ='<.odyssey>Already there! <./odyssey>'
  iPutIn        ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dPutOn        ='<.odyssey>OK <./odyssey>'
  dPutOnAlr     ='<.odyssey>Already there! <./odyssey>'
  iPutOn        ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dPutUnder     ='<.odyssey>OK <./odyssey>'
  dPutUnderAlr  ='<.odyssey>Already there! <./odyssey>'
  iPutUnder     ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dPutBehind    ='<.odyssey>OK <./odyssey>'
  dPutBehindAlr ='<.odyssey>Already there! <./odyssey>'
  iPutBehind    ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dWear         ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dDoff         ='<.odyssey>I can<./s>t do that\nI<./s>m not wearing it! <./odyssey>'
  dKiss         =nil
  dAsk     /*!*/=nil
  dAskFor       =nil
  dAskAbout     =nil
  dTell    /*!*/=nil
  dTellAbout    =nil
  dTalkTo       =nil
  dGive    /*!*/=nil
  dGiveTo       =nil
  iGiveTo       =nil
  dShow    /*!*/=nil
  dShowTo       =nil
  iShowTo       =nil
  dFollow       =nil
  dHit          ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dHitWith      ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  iHitWith      ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dAttack       ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dAttackWith   ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  iAttackWith   =true //'{You/he} can<./s>t attack anything with {the iobj/him}. '
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dDig     /*!*/='!<.odyssey>I found nothing <./odyssey>'
  dDigWith      ='<.odyssey>I found nothing <./odyssey>'
  iDigWith      ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dJumpOver     ='<.odyssey>OK <./odyssey>'
  dJumpOff      ='<.odyssey>OK <./odyssey>'
  dPush         ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dPull         ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dMove         ='<.odyssey>won<./s>t budge! <./odyssey>'
  dMoveWith     ='<.odyssey>won<./s>t budge! <./odyssey>'
  iMoveWith     ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dMoveTo       ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  iMoveTo       =true // does nothing
  dTurn         =true  //'{You/he} cannot turn {that dobj/him}. '
  dTurnWith     ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  iTurnWith     ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dTurnTo       =nil  //'{You/he} cannot turn {that dobj/him}. '
  dConsult      =nil
  dConsultAbout =nil
  dSetTo        =true
  dTypeOn       =nil  //'{You/he} cannot type anything on {that dobj/him}. '
  dTypeLiteralOn=nil  //'{You/he} cannot type anything on {that dobj/him}. '
  dEnterOn      ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dSwitch       =true //'{You/he} cannot switch {that dobj/him}. '
  dFlip         =nil  //'{You/he} cannot flip {that dobj/him}. '
  dTurnOn       =nil  //'{That dobj/he} {is}n<./s>t something {you/he} can turn on. '
  dTurnOff      =nil  //'{That dobj/he} {is}n<./s>t something {you/he} can turn off. '
  dLight        =nil  //'{You/he} cannot light {that dobj/him}. '
  dStrike       =nil
  dBurn    /*!*/=nil  //'{That dobj/he} {is} not something {you/he} can burn. '
  dBurnWith     =nil  //'{That dobj/he} {is} not something {you/he} can burn. '
  iBurnWith     =nil  //'{You/he} cannot burn anything with {that iobj/him}. '
  dExtinguish   =nil  //'{You/he} cannot extinguish {that dobj/him}. '
  dAttach  /*!*/='!<.odyssey>Can<./s>t do that! <./odyssey>'
  dAttachTo     ='<.odyssey>Can<./s>t do that! <./odyssey>'
  iAttachTo     ='<.odyssey>Can<./s>t do that! <./odyssey>'
  dDetach       ='<.odyssey>OK <./odyssey>'
  dDetachFrom   ='<.odyssey>OK <./odyssey>'
  iDetachFrom   ='<.odyssey>OK <./odyssey>'
  dBreak        ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dCut     /*!*/=nil
  dCutWith      =nil  //'{The iobj/he} can<./s>t seem to cut {the dobj/him}. '
  iCutWith      =nil  //'{You/he} can<./s>t cut anything with {the iobj/him}. '
  dClimb        ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dClimbUp      ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dClimbDown    ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dOpen         ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dClose        ='<.odyssey>HOW? <./odyssey>'
  dLock         =nil  //'{That dobj/he} {is} not something {you/he} can lock. '
  dLockWith     =nil  //'{That dobj/he} {is} not something {you/he} can lock. '
  iLockWith     =nil  //'{The iobj/he} do{es}n<./s>t look suitable for locking that. '
  dUnlock       =nil  //'{That dobj/he} {is} not something {you/he} can unlock. '
  dUnlockWith   =nil  //'{That dobj/he} {is} not something {you/he} can unlock. '
  iUnlockWith   =nil  //'{The iobj/he} do{es}n<./s>t look suitable for unlocking that. '
  dEat          =nil  //'{The dobj/he} do{es} not appear to be edible. '
  dDrink        ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dPour         =nil  //'{That dobj/he} {is} not something {you/he} can pour. '
  dPourInto     =nil  //'{That dobj/he} {is} not something {you/he} can pour. '
  iPourInto     =nil  //'{You/he} cannot pour anything into {that dobj/him}. '
  dPourOnto     =nil  //'{That dobj/he} {is} not something {you/he} can pour. '
  iPourOnto     =nil  //'{You/he} cannot pour anything onto {that dobj/him}. '
  dClean        =nil  //'{You/he} wouldn<./s>t know how to clean {that dobj/him}. '
  dCleanWith    =nil  //'{You/he} wouldn<./s>t know how to clean {that dobj/him}. '
  iCleanWith    =nil  //'{You/he} can<./s>t clean anything with {that iobj/him}. '
  dSitOn        =nil  //'{That dobj/he} {is}n<./s>t something {you/he} can sit on. '
  dLieOn        =nil  //'{That dobj/he} {is}n<./s>t something {you/he} can lie on. '
  dStandOn      =nil  //'{You/he} can<./s>t stand on {that dobj/him}. '
  dBoard        ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dGetOutOf     ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dGetOffOf     ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dFasten       ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dFastenTo     ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  iFastenTo     ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dUnfasten     =nil  //'{You/he} cannot unfasten {the dobj/him}. '
  dUnfastenFrom =nil  //'{You/he} cannot unfasten {the dobj/him}. '
  iUnfastenFrom =nil  //'{You/he} cannot unfasten anything from {the iobj/him}. '
  dPlugIn       =nil  //'{You/he} see{s} no way to plug in {the dobj/him}. '
  dPlugInto     =nil  //'{You/he} see{s} no way to plug in {the dobj/him}. '
  iPlugInto     =nil  //'{You/he} see{s} no way to plug anything into {the iobj/him}. '
  dUnplug       =nil  //'{You/he} see{s} no way to unplug {the dobj/him}. '
  dUnplugFrom   =nil  //'{You/he} see{s} no way to unplug {the dobj/him}. '
  iUnplugFrom   =nil  //'{You/he} see{s} no way to unplug anything from {the iobj/him}. '
  dScrew        ='<.odyssey>OK\nPhaser <./odyssey>'
  dScrewWith    ='<.odyssey>OK\nPhaser <./odyssey>'
  iScrewWith    ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dUnscrew      =nil  //'{You/he} see{s} no way to unscrew {the dobj/him}. '
  dUnscrewWith  =nil  //'{You/he} see{s} no way to unscrew {the dobj/him}. '
  iUnscrewWith  =nil  //'{You/he} cannot unscrew anything with {the iobj/him}. '
  dGoThrough    ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dEnter        ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dPushTravel   ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  
  /*
  //SENSORY MESSAGES:
  //feelDesc = "<.odyssey>OK\nNothing happens <./odyssey>"
  //MOVEMENT MESSAGES:
  //okayTakeMsg      ='<.odyssey>OK <./odyssey>'
  //alreadyHoldingMsg='<.odyssey>Already have it. <./odyssey>'
  //okayDropMsg      ='<.odyssey>OK <./odyssey>'
  //notCarryingMsg   ='<.odyssey>Not carrying it! <./odyssey>'
  //okayPutInMsg     ='<.odyssey>OK <./odyssey>'
  //okayPutOnMsg     ='<.odyssey>OK <./odyssey>'
  //okayPutUnderMsg  ='<.odyssey>OK <./odyssey>'
  //okayPutBehindMsg ='<.odyssey>OK <./odyssey>'
  //MANIPULATION MESSAGES:
  //cannotTurnMsg    ='{You/he} cannot turn {that dobj/him}. '
  //cannotTurnOnMsg  ='It<./s>s already on. '
  //cannotTurnOffMsg ='There doesn<./s>t seem to be any way to turn it off. '
  //cannotOpenMsg    ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  //cannotCloseMsg   ='<.odyssey>HOW? <./odyssey>'
  //notWearableMsg   ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  //notDoffableMsg   ='<.odyssey>I can<./s>t do that\nI<./s>m not wearing it! <./odyssey>'
  //shouldNotBreakMsg='<.odyssey>I don<./s>t understand you. <./odyssey>'
  //cannotClimbMsg   ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  //cannotDrinkMsg   ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  //cannotFastenMsg  ='<.odyssey>I don<./s>t understand you. <./odyssey>'
  //cannotFastenToMsg='<.odyssey>I don<./s>t understand you. <./odyssey>'
  */
  //MISCELLANEOUS BEHAVIOR:
  //uselessToAttackMsg = '<.odyssey>I don<./s>t understand you. <./odyssey>'
  validSettings = ['stun', 'destroy']
  curSetting = 'stun'
  displaySetting {
    switch (curSetting) {
      case 'stun'   : return 'stun.'   ;
      case 'destroy': return 'DESTROY!';
    }
    return 'error in Odys1.displaySetting';
  }
  dobjFor(Throw) {
    verify() { }
    check() { }
    action() {
      "<.odyssey>OK <./odyssey><.p>";
      throwThatThing(gDobj);
      //lookAroundScottAdams();
    }
  }
  //dobjFor(ThrowAt) asDobjFor(Throw)
  //dobjFor(ThrowTo) asDobjFor(Throw)
  //dobjFor(TurnOn) {
  //  verify() { }
  //  check() {
  //    "It<./s>s already on. ";
  //    exit;
  //  }
  //}
  //dobjFor(TurnOff) {
  //  verify() { }
  //  check() {
  //    "There doesn<./s>t seem to be any way to turn it off. ";
  //    exit;
  //  }
  //}
  dobjFor(Turn) asDobjFor(Set)
  dobjFor(Switch) asDobjFor(Set)
  dobjFor(Set) {
    verify() { }
    check() { }
    action() {
      "<.odyssey><.q>TO STUN<./q> or <.q>TO DESTROY<./q> ?\n
        (use 2 words)<./odyssey> ";
      //throw new TerminateCommandException();
    }
  }
  setToInvalidMsg = '<.odyssey>I don<./s>t understand you. <./odyssey>'
  okaySetToMsg = '<.odyssey>OK <./odyssey>'
  // okaySetToMsg didn't work even when I did it as a method rather
  // than a property, so I had to replace dobjFor(SetTo) as well.
  dobjFor(SetTo) {
    preCond = [touchObj]
    verify() {
      local txt;
      if ((txt = gAction.getLiteral()) != nil
        && !isValidSetting(txt))
        logicalRank(50, 'invalid setting');
    }
    check() {
      // if the setting is not valid, don't allow it
      if (!isValidSetting(gAction.getLiteral())) {
        // there is no such setting
        reportFailure(setToInvalidMsg);
        exit;
      }
    }
    action() {
      // set the new value
      makeSetting(gAction.getLiteral());
      // remark on the change
      defaultReport(okaySetToMsg);
    }
  }
  //bang() {
  //  if (ammo <= 0) {
  //    "<.odyssey>OK\n
  //      I fire the Phaser,\n
  //      Nothing happens\n
  //      Its empty.<./odyssey>";
  //    return nil;
  //  }
  //  if (curSetting == 'stun') ammo = ammo - 4;
  //  else ammo = ammo - 7;
  //  if (ammo < 0) ammo = 0;
  //  return true;
  //}
  //bangWeapon() {
  //  "<.odyssey>I fire the Phaser,\n
  //    Nothing happens\n
  //    Either I missed or beam was absorbed without visible
  //    effect!<./odyssey>";
  //}
  //bangTarget() {
  //  if (curSetting == 'stun') {
  //    // Trying to stun an inanimate object:
  //    if (!gDobj.ofKind(Actor))
  //      bangWeapon();
  //    // Trying to stun an actor that's already stunned:
  //    else if (gDobj.isStunned)
  //      bangWeapon();
  //    // Stunning an actor (who's not already stunned):
  //    else {
  //      gDobj.isStunned = true;
  //      gDobj.startStunFuse();
  //      "<.odyssey>I fire the Phaser,\n
  //        its stunned!<./odyssey>\b";
  //      //lookAroundScottAdams();
  //    }
  //  }
  //  else { // Otherwise, curSetting == 'destroy'
  //    // Do not permit the destruction of the actor or anything 
  //    // the actor is in.
  //    if (gActor.isIn(gDobj))
  //      bangWeapon();
  //    // Otherwise, blammo, and let the player beware.
  //    else {
  //      gDobj.moveInto(nil);
  //      "<.odyssey>I fire the Phaser,\n
  //        I destroyed it!<./odyssey>\b";
  //      //lookAroundScottAdams();
  //    }
  //  }
  //}
  ammo = 28
  ammoDecrement = (curSetting == 'stun' ? 4 : 7)
  defaultShootResult = (curSetting == 'stun' ? nil : vaporize)
  shootEffectEnemy {
    if (curSetting == 'stun') {
      sayForArt(shootPrefixMsg(gDobj, true));
      if (!gDobj.isStunned) {
        sayForArt('<br>He<./s>s stunned! ');
        //sayForArt('<br>Its stunned! ');
        doShootResult(gDobj, stun);
      }
      else {
        sayForArt(stunOrDestroyThingMsg(nil, nil));
      }
    }
    else { // if setting is destroy, shootEffectThing can handle it.
      inherited;
    }
  }
  noAmmoMsg =
    'OK <br>I fire the Phaser <br>Nothing happens <br>Its empty. '
  shootAimlesslyMsg =
    (shootPrefixMsg(nil, nil) + stunOrDestroyThingMsg(nil, nil))
  shootPrefixMsg(obj, complex) {
    return 'I fire the Phaser, '
      + throughMsg('<br>The beam passes through ','! ',obj, complex);
  }
  shootThingMsg(obj) {
    gMessageParams(obj);
    return stunOrDestroyThingMsg(obj, (curSetting != 'stun'));
  }
  stunOrDestroyThingMsg(obj, destroy) {
    //if (gKey() == 'q') {local k=0;k=k/k;}
    // Note that obj might be nil here, but only if destroy is nil.
    if (destroy && obj) {
      gMessageParams(obj);
      if (obj.canBeVaporized)
        //return '<br>I destroyed {it obj/him}! '; 
        return '<br>I destroyed {it obj/him}! '; 
      else
        //return '<br>Nothing happens <br>Maybe its too big. ';
        return obj.firePhaserNoEffectMsg;
    }
    else
      return '<br>Nothing happens <br>Either I missed or beam 
        was absorbed without visible effect! ';
  }
  shootFriendMsg = '<br>I missed! '
  mirrorBounceMsg = '<br>The beam bounces off the mirror! '
  windowTransmitMsg = '<br>The beam passes through the ' + windowWord + '! '
  skywayWindowTransmitMsg = stunOrDestroyThingMsg(nil, nil)
  officeWindowTransmitMsg = stunOrDestroyThingMsg(nil, nil)
  slowingFieldTransmitMsg = stunOrDestroyThingMsg(nil, nil)
  actorShootingHimselfMsg =
    'Don<./s>t know what <.q>me<./q> is. '
  gunShootingItselfMsg =
    'Try: <.q>SHOOT SOMETHING<./q> '
  //dobjFor(TAction) {
  //  verify() {
  //    if (gActor.location == kitchen) {
  //      illogical('You may not talk about the <<self.name>>
  //        while you are in the kitchen. ');
  //    }
  //  }
  //}
  //iobjFor(gAction) {
  //  verify() {
  //    if (gActor.location == kitchen) {
  //      illogical('You may not talk about the <<self.name>>
  //        while you are in the kitchen. ');
  //    }
  //  }
  //}
  zapAry = disappear(
    'The Phaser is transformed into a seraph! 
      <p>The seraph briefly recites a blessing,
        then flies up through the ceiling,
        presumably going up to heaven or wherever
        seraphim go. '
    , self, 'seraph'
  )
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: explosive
// -------------------------------------------------------------------

// Light, Strike, Throw, Extinguish (burn?)

class Bomb: object // a mix-in class
  explosionKillsPcMsg = '<.moments>The disrupter explodes,
    putting out a tremendous wave of energy.
    Quite tremendous.<./moments> '
  seeExplosionMsg = 'you see a blinding explosion of light.
    Instantly you shield your eyes, as
    a concussive blast echoes through the building. '
  hearExplosionMsg = '<.moments>Somewhere close by,
    you hear the sound of an exploding photonic disrupter.<./moments> '
  isSetToExplode = nil
  explosionCountdown = 9999 // override
  daemon { // a pseudo-daemon
    if (!isSetToExplode)
      return;
    if (explosionCountdown == 0) {
      explode;
    }
    explosionCountdown--;
  }
  explode {
    local aliensNearExplosion = [];
    local selfX, selfY, pcharX, pcharY;
    local dirStr = nil;
    for (local cur = firstObj(Alien); cur != nil; 
         cur = nextObj(cur,Alien)) {
      if (cur.isNearForExplosion(self)) {
        aliensNearExplosion += cur;
        Gun.doShootResult(cur, kill);
      }
    }
    if (gPlayerChar.isNearForExplosion(self)) {
      say(explosionKillsPcMsg);
      endGame(ftDeath);
    }
    else if (gPlayerChar.getOutermostRoom.canGlimpse(self.getOutermostRoom)) {
      pcharX = gPlayerChar.getOutermostRoom.absoluteXValue;
      pcharY = gPlayerChar.getOutermostRoom.absoluteYValue;
      selfX = self.getOutermostRoom.absoluteXValue;
      selfY = self.getOutermostRoom.absoluteYValue;
      if (pcharY < selfY) dirStr = 'off to the south';
      else if (pcharY > selfY) dirStr = 'off to the north';
      else if (pcharX < selfX) dirStr = 'off to the east';
      //else if (pcharX > selfX) dirStr = 'off to the west';
      else dirStr = 'off to the west';
      "<.p><<artHtml1>>\^<<dirStr>>, <<seeExplosionMsg>><<artHtml2>>";
      if (aliensNearExplosion.length) {
        //"<p>\^<<dirStr>>, ";
        //simpleLister(aliensNearExplosion, &theName);
        //" <<aliensNearExplosion.length == 1 ? 'is' : 'are'>> 
        //  now lying dead on the floor. ";
        "<p>After the dust settles, you notice that ";
        simpleLister(aliensNearExplosion, &theName);
        " <<aliensNearExplosion.length == 1 ? 'is' : 'are'>> 
          now lying dead <<dirStr>>. ";
      }
    }
    else {
      say(hearExplosionMsg);
    }
    //local k = inputManager.getKey(nil, nil);
    //if (k == 'q') {k=0;k=k/k; }
    // Wait until the end to get rid of this weapon, as we need to 
    // pay attention to its location above.
    isSetToExplode = nil;
    moveInto(nil);
  }
;

explosive: Bomb, Artifact
  vocabWords='explosive (hand) bomb/grenade/fuse/weapon/artifact*weapons*artifacts'
  name      ='explosive'
  nickname  ='explosive'
  artTitle  ='Countdown to Doom'
  artAuthor ='Peter D. Killworth'
  artCompany='Topologika'
  artComp   ='Topologika'
  artYear   ='1982'
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.doom>'
  artHtml2  ='<./doom>'
  artDesc {
    "This is an explosive with a self-igniting fuse. ";
    //"If there was anything more to say about that, I<./s>d have told you! ";
  }
  //desc = "I don<./s>t understand what you mean by <.q>examine.<./q> "
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  // parsing stuff
  parseFailMsg = 'I don<./s>t understand what you mean by <.q>' 
                   + glob.latestVerb + '<./q>. '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         =nil
  dobjFor(LookIn) asDobjFor(Examine)
  dobjFor(Search) asDobjFor(Examine)
  dobjFor(LookUnder) asDobjFor(Examine)
  dobjFor(LookBehind) asDobjFor(Examine)
  dobjFor(LookThrough) asDobjFor(Examine)
  //dLookIn       ='There<./s>s nothing unusual in {the dobj/him}. '
  //dSearch       =true // acts exactly like LookIn
  //dLookUnder    ='{You/he} see{s} nothing unusual under {the dobj/him}. '
  //dLookBehind   ='{You/he} see{s} nothing unusual behind {the dobj/him}. '
  //dLookThrough  ='{You/he} can see nothing through {the dobj/him}. '
  dListenTo     =nil
  dSmell        =nil
  dTaste        =nil
  dFeel         =nil
  dTake         ='Explosive taken. '
  dTakeAlr      ='You<./s>re already holding the explosive. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Explosive dropped. '
  dDropAlr      ='You<./s>re not holding any explosive. '
  dPutIn        ='Explosive put in {the iobj/him}. '
  dPutInAlr     ='The explosive is already in {the iobj/him}. '
  iPutIn        ='I<./s>d be interested to know how you<./s>d do that! '
  dPutOn        ='Explosive put on {the iobj/him}. '
  dPutOnAlr     ='The explosive is already on {the iobj/him}. '
  iPutOn        ='I<./s>d be interested to know how you<./s>d do that! '
  dPutUnder     ='Explosive put under {the iobj/him}. '
  dPutUnderAlr  ='The explosive is already under {the iobj/him}. '
  iPutUnder     ='I<./s>d be interested to know how you<./s>d do that! '
  dPutBehind    ='Explosive put behind {the iobj/him}. '
  dPutBehindAlr ='The explosive is already behind {the iobj/him}. '
  iPutBehind    ='I<./s>d be interested to know how you<./s>d do that! '
  dWear         ='I<./s>d be interested to know how you<./s>d do that! '
  dDoff         ='You<./s>re not wearing that. '
  dKiss         =nil
  dAsk     /*!*/=nil
  dAskFor       =nil
  dAskAbout     =nil
  dTell    /*!*/=nil
  dTellAbout    =nil
  dTalkTo       =nil
  dGive    /*!*/=nil
  dGiveTo       =nil
  iGiveTo       =nil
  dShow    /*!*/=nil
  dShowTo       =nil
  iShowTo       =nil
  dFollow       =nil
  dHit          ='I<./s>d be interested to know how you<./s>d do that! '
  dHitWith      ='I<./s>d be interested to know how you<./s>d do that! '
  iHitWith      ='I<./s>d be interested to know how you<./s>d do that! '
  dAttack       ='I<./s>d be interested to know how you<./s>d do that! '
  dAttackWith   ='I<./s>d be interested to know how you<./s>d do that! '
  iAttackWith   ='I<./s>d be interested to know how you<./s>d do that! '
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='I<./s>d be interested to know how you<./s>d do that! '
  dDig     /*!*/='There is nothing buried on the planet. '
  dDigWith      ='There is nothing buried on the planet. '
  iDigWith      ='There is nothing buried on the planet. '
  dJumpOver     ='I<./s>d be interested to know how you<./s>d do that! '
  dJumpOff      ='I<./s>d be interested to know how you<./s>d do that! '
  dPush         ='Gee - I hope you enjoyed that... '
  dPull         ='Gee - I hope you enjoyed that... '
  dMove         ='You can<./s>t go in that direction! '
  dMoveWith     ='You can<./s>t go in that direction! '
  iMoveWith     ='You can<./s>t go in that direction! '
  dMoveTo       ='You can<./s>t go in that direction! '
  iMoveTo       ='You can<./s>t go in that direction! '
  dTurn         =nil
  dTurnWith     =nil
  iTurnWith     =nil
  dTurnTo       =nil
  dConsult      =nil
  dConsultAbout =nil
  dSetTo        =nil
  dTypeOn       =nil
  dTypeLiteralOn=nil
  dEnterOn      ='You can<./s>t go <.q>in<./q> from here! '
  dSwitch       =nil
  dFlip         =nil
  dTurnOn       =nil
  dTurnOff      =nil
  dLight        =true
  dStrike       =true // remapped to dHit; CHANGE!!!!!
  dBurn    /*!*/=true
  dBurnWith     =true
  iBurnWith     =nil
  dExtinguish   ='I<./s>d be interested to know how you<./s>d do that! '
  dAttach  /*!*/=true // asks for iobj
  dAttachTo     =nil
  iAttachTo     =nil
  dDetach       =nil
  dDetachFrom   =nil
  iDetachFrom   =nil
  dBreak        ='Don<./s>t be destructive! '
  dCut     /*!*/=nil
  dCutWith      =nil
  iCutWith      =nil
  dClimb        ='You must be joking! '
  dClimbUp      ='You must be joking! '
  dClimbDown    ='You must be joking! '
  dOpen         ='You can<./s>t do that! '
  dClose        ='Nothing needs closing on this planet. '
  dLock         =nil
  dLockWith     =nil
  iLockWith     =nil
  dUnlock       =nil
  dUnlockWith   =nil
  iUnlockWith   =nil
  dEat          ='Nothing on this planet gives sustenance. '
  dDrink        ='Nothing on this planet gives sustenance. '
  dPour         =nil
  dPourInto     =nil
  iPourInto     =nil
  dPourOnto     =nil
  iPourOnto     =nil
  dClean        =nil
  dCleanWith    =nil
  iCleanWith    =nil
  dSitOn        =nil
  dLieOn        =nil
  dStandOn      =nil
  dBoard        ='You can<./s>t go <.q>in<./q> from here! '
  dGetOutOf     ='You can<./s>t go <.q>out<./q> from here! '
  dGetOffOf     ='You can<./s>t go <.q>out<./q> from here! '
  dFasten       =nil
  dFastenTo     =nil
  iFastenTo     =nil
  dUnfasten     =nil
  dUnfastenFrom =nil
  iUnfastenFrom =nil
  dPlugIn       =nil
  dPlugInto     =nil
  iPlugInto     =nil
  dUnplug       =nil
  dUnplugFrom   =nil
  iUnplugFrom   =nil
  dScrew        =nil
  dScrewWith    =nil
  iScrewWith    =nil
  dUnscrew      =nil
  dUnscrewWith  =nil
  iUnscrewWith  =nil
  dGoThrough    ='You can<./s>t go <.q>in<./q> from here! '
  dEnter        ='You can<./s>t go <.q>in<./q> from here! '
  dPushTravel   ='I<./s>d be interested to know how you<./s>d do that! '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
  dobjFor(Burn) {
    verify {
      if (isSetToExplode)
        illogicalAlready('<.doom>It<./s>s already lit!<./doom> ');
    }
    preCond = [touchObj]
    check { }
    action {
      if (neton     .realLocation == nil &&
          ovan      .realLocation == nil &&
          oldGuard  .realLocation == nil &&
          youngGuard.realLocation == nil &&
          assistant .realLocation == nil) {
        "Stop clowning around. You have no reason to set off
          an explosion now. ";
      }
      else {
        "<.doom>The fuse starts to burn. <./doom>";
        isSetToExplode = true;
        explosionCountdown = 2;
      }
    }
  }
  dobjFor(Strike) asDobjFor(Burn)
  dobjFor(Light) asDobjFor(Burn)
  dobjFor(BurnWith) asDobjFor(Burn)
  explosionKillsPcMsg = '<.doom>The explosive explodes,
      and for a fleeting moment you feel rather silly.
    <p>' + rand(
       'You have departed this world, alas. '
      ,'You<./s>ve passed away, I fear. '
      ,'You kicked the bucket, unfortunately. '
      ,'Oh dear! You seem to have snuffed it. ') + '<./doom> '
  seeExplosionMsg = 'you see a massive explosion. BANG! '
  hearExplosionMsg = '<.doom>From next door
    there is a loud bang!<./doom> '
  
  
  vickiShowResponse =
    "Vicki says, <.q>If it ever comes to combat with the Oo, 
      this could come in handy. Excellent find, <<me.firstName>>.<.q> "
  dianeShowResponse =
    "<.q>Hey, that looks really useful!<./q> says Diane, 
      her eyes suddenly lighting up. <.q>God knows 
      I wouldn<./s>t mind shooting a few of those 
      alien scumbags. Well, if they ever mess with me again,
      anyway.<./q> "
  vickiGiveResponse {
    "Vicki gives the explosive a wary look. Finally she says, 
      <.q>No thanks, I<./s>d better not carry that thing. 
      I<./s>m not too familiar with explosives, and I<./s>d 
      be afraid of setting it off by accident.<./q> ";
  }
  dianeGiveResponse {
    "<.q>Yes!<./q> exclaims Diane, seizing the explosive
      and regarding it with admiration. <.q>Now that I've got this, 
      those aliens better watch out!<./q> ";
    moveInto(diane);
  }
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: handgun
// -------------------------------------------------------------------

handgun: ArtifactGun
  vocabWords='(hand) handgun/gun/firearm/weapon/trigger/artifact*guns*firearms*weapons*triggers*artifacts'
  name      ='handgun'
  nickname  ='handgun'
  artTitle  ='Snowball'
  artAuthor ='Pete, Mike, and Nick Austin'
  artCompany='Level 9 Computing'
  artComp   ='Level 9'
  artYear   ='1983'
  artAttr   ='c'
  artAttrib ='cc'
  artHtml1  ='<.snowball>'
  artHtml2  ='<./snowball>'
  artDesc() { 
    //tripartiteDesc
    //  ('The handgun is sitting on the ' + asscPed.name,
    //   'This is the handgun you got from the ' + asscPed.name,
    //   'Apparently this is the handgun from ' + titlei(',')
    //     + ' by ' + artCompany);
    //". ";
    "It has a wide, tapering nozzle. ";
  }
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  actionIsAllowed() {
    if (gAction == nil) return nil;
    if  (
        //   gAction.baseActionClass == ReadAction
        //||
           gAction.baseActionClass == TasteAction
        || gAction.baseActionClass == ListenToAction
        || gAction.baseActionClass == GiveToAction
        || gAction.baseActionClass == ShowToAction
        //gAction.baseActionClass == LookInAction
        //|| gAction.baseActionClass == SearchAction
        //|| gAction.baseActionClass == LookUnderAction
        //|| gAction.baseActionClass == LookBehindAction
        //|| gAction.baseActionClass == LookThroughAction
        //|| gAction.baseActionClass == FeelAction
        //|| gAction.baseActionClass == WearAction
        //|| gAction.baseActionClass == DoffAction
        //|| gAction.baseActionClass == HitAction
        //|| gAction.baseActionClass == HitWithAction
        //|| gAction.baseActionClass == AttackAction
        //|| gAction.baseActionClass == AttackWithAction
        //|| gAction.baseActionClass == SwitchAction
        || gAction.baseActionClass == ThrowAction
        || gAction.baseActionClass == ThrowAtAction
        || gAction.baseActionClass == ThrowToAction
        //|| gAction.baseActionClass == PushAction
        //|| gAction.baseActionClass == PullAction
        //|| gAction.baseActionClass == ClimbAction
        //|| gAction.baseActionClass == ClimbUpAction
        //|| gAction.baseActionClass == ClimbDownAction
        || gAction.baseActionClass == MoveAction
        || gAction.baseActionClass == MoveWithAction
        || gAction.baseActionClass == MoveToAction
        //|| gAction.baseActionClass == TurnAction
        //|| gAction.baseActionClass == TurnWithAction
        //|| gAction.baseActionClass == TurnToAction
        //|| gAction.baseActionClass == SetToAction
        //|| gAction.baseActionClass == BreakAction
        //|| gAction.baseActionClass == OpenAction
        //|| gAction.baseActionClass == CloseAction
        //|| gAction.baseActionClass == DrinkAction
        //|| gAction.baseActionClass == FastenAction
        //|| gAction.baseActionClass == FastenToAction
        //|| gAction.baseActionClass == ShootAction
        //|| gAction.baseActionClass == ShootAimlesslyAction
        //|| gAction.baseActionClass == ShootWithAction
        //|| gAction.baseActionClass == SetAction
        )
      return true;
    else return nil;
  }
  // parsing stuff
  parseFailMsg = 'You don<./s>t need to use the word <.q>' + 
                   glob.latestVerb + '<./q> when referring to the
                   handgun. '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         =nil
  dLookIn       =true // overridden below
  dSearch       =true // overridden below
  dLookUnder    =true // overridden below
  dLookBehind   =true // overridden below
  dLookThrough  =true // overridden below
  dListenTo     ='You hear nothing extra. '
  dSmell        =nil
  dTaste        ='Yeuch! '
  dFeel         =nil
  dTake         ='OK. '
  dTakeAlr      ='You already have a handgun. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='OK. '
  dDropAlr      ='You don<./s>t have a handgun. '
  dPutIn        ='OK. '
  dPutInAlr     ='You don<./s>t have a handgun. '
  iPutIn        ='You can<./s>t do that. '
  dPutOn        ='OK. '
  dPutOnAlr     ='You don<./s>t have a handgun. '
  iPutOn        ='You can<./s>t do that. '
  dPutUnder     ='OK. '
  dPutUnderAlr  ='You don<./s>t have a handgun. '
  iPutUnder     ='You can<./s>t do that. '
  dPutBehind    ='OK. '
  dPutBehindAlr ='You don<./s>t have a handgun. '
  iPutBehind    ='You can<./s>t do that. '
  dWear         ='Don<./s>t be silly! '
  dDoff         ='Don<./s>t be silly! '
  dKiss         =nil
  dAsk     /*!*/=nil
  dAskFor       =nil
  dAskAbout     =nil
  dTell    /*!*/=nil
  dTellAbout    =nil
  dTalkTo       =nil
  dGive    /*!*/='!There<./s>s no one to give it to. '
  dGiveTo       ='There<./s>s no one to give it to. '
  iGiveTo       ='There<./s>s no one to give it to. '
  dShow    /*!*/='!I don<./s>t understand the word <.q>show<./q> when used in that way. '
  dShowTo       ='I don<./s>t understand the word <.q>show<./q> when used in that way. '
  iShowTo       ='I don<./s>t understand the word <.q>show<./q> when used in that way. '
  dFollow       =nil
  dHit          ='There<./s>s nothing to attack! '
  dHitWith      ='There<./s>s nothing to attack! '
  iHitWith      =true
  dAttack       ='There<./s>s nothing to attack! '
  dAttackWith   ='There<./s>s nothing to attack! '
  iAttackWith   =true
  dThrow   /*!*/=true // overridden below
  dThrowAt      =true // overridden below
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // overridden below
  iThrowTo      ='You can<./s>t do that. '
  dDig     /*!*/='!You<./s>ve nothing to dig with. '
  dDigWith      ='You<./s>ve nothing to dig with. '
  iDigWith      ='You<./s>ve nothing to dig with. '
  dJumpOver     ='You can<./s>t go in that direction. '
  dJumpOff      ='You can<./s>t go in that direction. '
  dPush         ='You can<./s>t do that. '
  dPull         =snowballList1.doScript
  dMove         =snowballList1.doScript
  dMoveWith     =snowballList1.doScript
  iMoveWith     ='You can<./s>t do that. '
  dMoveTo       =snowballList1.doScript
  iMoveTo       =true // does nothing
  dTurn         ='You can<./s>t do that. '
  dTurnWith     ='You can<./s>t do that. '
  iTurnWith     ='You can<./s>t do that. '
  dTurnTo       ='You can<./s>t do that. '
  dConsult      =nil
  dConsultAbout =nil
  dSetTo        ='I don<./s>t understand the word <.q>set<./q> when used in that way. '
  dTypeOn       =nil
  dTypeLiteralOn=nil
  dEnterOn      ='You can<./s>t do that. '
  dSwitch       ='I don<./s>t understand the word <.q>switch<./q> when used in that way. '
  dFlip         =nil
  dTurnOn       =snowballList2.doScript
  dTurnOff      =snowballList2.doScript
  dLight        ='You can<./s>t do that. '
  dStrike       =nil
  dBurn    /*!*/='!I don<./s>t understand the word <.q>' + 
                   glob.latestVerb + '<./q> when used in that way. '
  dBurnWith     ='I don<./s>t understand the word <.q>' + 
                   glob.latestVerb + '<./q> when used in that way. '
  iBurnWith     ='You can<./s>t do that. '
  dExtinguish   ='You can<./s>t do that. '
  dAttach  /*!*/='!You can<./s>t do that. '
  dAttachTo     ='You can<./s>t do that. '
  iAttachTo     ='You can<./s>t do that. '
  dDetach       =nil
  dDetachFrom   =nil
  iDetachFrom   =nil
  dBreak        =nil
  dCut     /*!*/='There<./s>s nothing to attack! '
  dCutWith      ='There<./s>s nothing to attack! '
  iCutWith      ='There<./s>s nothing to attack! '
  dClimb        =nil
  dClimbUp      =nil
  dClimbDown    =nil
  dOpen         ='You can<./s>t do that. '
  dClose        ='You can<./s>t do that. '
  dLock         ='You can<./s>t do that. '
  dLockWith     ='You can<./s>t do that. '
  iLockWith     ='You can<./s>t do that. '
  dUnlock       ='You can<./s>t do that. '
  dUnlockWith   ='You can<./s>t do that. '
  iUnlockWith   ='You can<./s>t do that. '
  dEat          ='Yeuch! '
  dDrink        ='Don<./s>t be silly! '
  dPour         ='You can<./s>t empty a handgun. '
  dPourInto     ='You can<./s>t empty a handgun. '
  iPourInto     ='You can<./s>t do that. '
  dPourOnto     ='You can<./s>t empty a handgun. '
  iPourOnto     ='You can<./s>t do that. '
  dClean        =nil
  dCleanWith    =nil
  iCleanWith    =nil
  dSitOn        ='You can<./s>t go in that direction. '
  dLieOn        ='You can<./s>t go in that direction. '
  dStandOn      ='You can<./s>t go in that direction. '
  dBoard        ='You can<./s>t go in that direction. '
  dGetOutOf     ='You can<./s>t go in that direction. '
  dGetOffOf     ='You can<./s>t go in that direction. '
  dFasten       ='You can<./s>t do that. '
  dFastenTo     ='You can<./s>t do that. '
  iFastenTo     ='You can<./s>t do that. '
  dUnfasten     ='You can<./s>t do that. '
  dUnfastenFrom ='You can<./s>t do that. '
  iUnfastenFrom ='You can<./s>t do that. '
  dPlugIn       =
    'A psychobot taps you on the shoulder. <.q>Ahem. Your behavior
      patterns seem irrational<./q>. You feel a hypo.. Then nothing. \b
      You wake up in a padded cell with no visible exits. Fortunately,
      being a resourceful adventurer, you soon manage to break
      out. You stumble through a tight crawlway and into a narrow
      service duct. Eventually you make your way to a wide simulated
      marble tube, where there is a huge curtain of flame.
      It seems you have no choice but to jump through the flame..\b
      ..And you find yourself exactly where you were before!
      The flame must have been some kind of temporal vortex,
      returning you to the precise place you were at, just seconds
      after you left. '
  dPlugInto     =dPlugIn
  iPlugInto     =dPlugIn
  dUnplug       =nil
  dUnplugFrom   =nil
  iUnplugFrom   =nil
  dScrew        ='I don<./s>t understand the word <.q>screw<./q> when used in that way. '
  dScrewWith    ='I don<./s>t understand the word <.q>screw<./q> when used in that way. '
  iScrewWith    ='I don<./s>t understand the word <.q>screw<./q> when used in that way. '
  dUnscrew      =nil
  dUnscrewWith  =nil
  iUnscrewWith  =nil
  dGoThrough    ='I don<./s>t understand the word <.q>through<./q> when used in that way. '
  dEnter        ='You can<./s>t go in that direction. '
  dPushTravel   ='You can<./s>t do that. '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
  dobjFor(Search)      asDobjFor(Examine)
  dobjFor(LookIn)      asDobjFor(Examine)
  dobjFor(LookUnder)   asDobjFor(Examine)
  dobjFor(LookBehind)  asDobjFor(Examine)
  dobjFor(LookThrough) asDobjFor(Examine)
  dobjFor(Throw)       asDobjFor(Drop)
  dobjFor(ThrowAt)     asDobjFor(Drop)
  dobjFor(ThrowTo)     asDobjFor(Drop)
  //dobjFor(Shoot) {
  //  verify() {
  //    if (gDobj && !isIn(gActor)) {
  //      "<.snowball>You don<./s>t have a handgun. <./snowball>";
  //      exit;
  //    }
  //    inherited();
  //  }
  //  action() {
  //    "<.snowball>The recoil spins you around. <./snowball>";
  //    exit;
  //  }
  //}
  //dobjFor(ShootAimlessly) {
  //  verify() {
  //    if (gDobj && !isIn(gActor)) {
  //      "<.snowball>You don<./s>t have a handgun. <./snowball>";
  //      exit;
  //    }
  //    inherited();
  //  }
  //  action() {
  //    "<.snowball>The recoil spins you around. <./snowball>";
  //    exit;
  //  }
  //}
  //dobjFor(ShootWith) asDobjFor(Shoot)
  ////{
  ////  verify() {
  ////    inherited();
  ////    if(gIobj != nil && gDobj == gIobj) {
  ////      illogicalSelf(&gunCannotFireAtItself);
  ////      return;
  ////    }
  ////  }
  ////  check() { }
  ////  action() { }
  ////}
  //iobjFor(ShootWith) {
  //  verify() {
  //    illogical('<.snowball>Don<./s>t be silly! <./snowball>');
  //  }
  //  action() { }
  //}
  //iobjFor(AttackWith) remapTo(ShootWith, DirectObject, IndirectObject)
  //iobjFor(HitWith) remapTo(ShootWith, DirectObject, IndirectObject)
  //bang()       { return true; }
  //bangWeapon() { defaultReport(&okayShootMsg); }
  //bangTarget() { defaultReport(&okayShootTargetMsg); }
  
  
  
  
//  dobjFor(Shoot) {
//    action() {
//      "<.snowball>The recoil spins you around. <./snowball>";
//      exit;
//    }
//  }
//  dobjFor(ShootAimlessly) {
//    action() {
//      "<.snowball>The recoil spins you around. <./snowball>";
//      exit;
//    }
//  }
  iobjFor(ShootWith) {
//    preCond = [objHeld]
    // In Snowball, the handgun *cannot be used as an instrument
    // for shooting something else*. You can only use it to shoot
    // off aimlessly. If you try to SHOOT X WITH HANDGUN, it will
    // say "Don't be silly!" Well, if it's "silly" to use the 
    // handgun to shoot something, then I suppose it's illogical
    // to do that. Therefore, put this in verify(), to pre-empt
    // any preconditions (i.e. we don't want to take the gun 
    // before reporting how silly it is to use it to shoot things).
    verify() {
      if (gIobj)
        illogical('<.snowball>Don<./s>t be silly! <./snowball>');
      else
        inherited();
    }
//    action() {
//      "<.snowball>The recoil spins you around. <./snowball>";
//      exit;
//    }
  }
//  iobjFor(AttackWith) remapTo(ShootWith, DirectObject, IndirectObject)
//  iobjFor(HitWith) remapTo(ShootWith, DirectObject, IndirectObject)
  
  // Using my system, this pathetic excuse for a weapon boils
  // down to this:
  tangibleProjectiles = true
  shootPrefixMsg(obj, complex) {
    return 'The recoil spins you around. ';
  }
  shootThingMsg(obj) { return ''; }
  shootFriendMsg = ''
  windowTransmitMsg = ''
  skywayWindowTransmitMsg = ''
  officeWindowTransmitMsg = ''
  slowingFieldTransmitMsg = ''
  actorShootingHimselfMsg =
    'Don<./s>t be silly! '
  gunShootingItselfMsg =
    'Don<./s>t be silly! '
;
snowballList1: CyclicList
  [
    'There<./s>s no effect. ',
    'Nothing happens. ',
    'Doesn<./s>t seem to work. '
  ]
;
snowballList2: CyclicList
  [
    'Could you rephrase that? ',
    'Please be more specific. ',
    'I don<./s>t quite understand. '
  ]
;

// improve the vocabWords
// improve the description of this laser, especially as regards the battery
// that is, LOOK IN/THROUGH LASER should work; PUT X IN LASER should work
// Show "a new battery" when you look in the laser.
// SetTo, TurnTo
// Burn, iobjFor(BurnWith)

//taser: Dial
//  'taser/tazer' 'taser'
//  "The taser, though portable, is still fairly heavy. It has a
//    long, slender barrel and a dial with six settings, labelled
//    <.q>1<./q> through <.q>6.<./q> This dial is currently
//    on setting <<curSetting>>. There is a depression on the top
//    of the taser which contains a battery. "
//  dobjFor(SetTo) {
//    check { }
//    action {
//      local num = nil;
//      local lit = gAction.getLiteral;
//      if (lit && lit.find('one')) num = 1;
//      if (lit && lit.find('two')) num = 2;
//      if (lit && lit.find('three')) num = 3;
//      if (lit && lit.find('four')) num = 4;
//      if (lit && lit.find('five')) num = 5;
//      if (lit && lit.find('six')) num = 6;
//      if (!num && lit) {
//        // another case where we handily use one of the functions
//        // available in qtalk.t.
//        num = qToInteger(lit);
//        if (num < 1 || num > 6)
//          num = nil;
//      }
//      if (!num) {
//        "<.planetfall>The dial can only be set from 1 to 6.<./planetfall> ";
//      }
//      else {
//        makeSetting(num);
//        "<.planetfall>The dial is now set to <<num>>.<./planetfall> ";
//      }
//    }
//  }
//  curSetting = 5
//;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: laser
// -------------------------------------------------------------------

laser: ArtifactGun, Dial
  vocabWords='(akmee) (acme) (portabul) (portable) laazur laser lazer battery/depression/dial/gun/firearm/weapon/trigger/artifact*guns*firearms*weapons*triggers*artifacts'
  name      ='laser'
  nickname  ='laser'
  artTitle  ='Planetfall'
  artAuthor ='Steve Meretzky'
  artCompany='Infocom'
  artComp   ='Infocom'
  artYear   ='1983'
  artAttr   ='c'
  artAttrib ='cc'
  artHtml1  ='<.planetfall>'
  artHtml2  ='<./planetfall>'
  artDesc {
    "The laser, though portable, is still fairly heavy. It has a
      long, slender barrel and a dial with six settings, labelled
      <.q>1<./q> through <.q>6.<./q> This dial is currently
      on setting <<curSetting>>. There is a depression on the top
      of the laser which contains a battery. ";
  }
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  // parsing stuff
  parseFailMsg = '[I don<./s>t know the word <.q>' + glob.latestVerb + '<./q>.] '
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         ='How can I read a laser? '
  //dLookIn       =
  dSearch       =true // acts exactly like LookIn
  dLookUnder    ='There is nothing but dust there. '
  dLookBehind   ='There is nothing but dust there. '
  //dLookThrough  =
  dobjFor(LookThrough) asDobjFor(LookIn)
  dListenTo     ='The laser makes no sound. '
  dSmell        ='It smells just like a laser. '
  dTaste        ='It tastes just like a laser. '
  dFeel         ='Fiddling with the laser has no effect. '
  dTake         ='Taken. '
  dTakeAlr      ='You already have it. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Dropped. '
  dDropAlr      ='You don<./s>t have the laser. '
  dPutIn        ='Done. '
  dPutInAlr     ='{The dobj/him) {is} already on {the iobj/him}. '
  //iPutIn needs to be fixed!
  iPutIn        ='{The dobj/him} do{es}n<./s>t fit the depression. '
  dPutOn        ='Done. '
  dPutOnAlr     ='{The dobj/him) {is} already in {the iobj/him}. '
  iPutOn        ='You can<./s>t do that. '
  dPutUnder     ='Done. '
  dPutUnderAlr  ='{The dobj/him) {is} already under {the iobj/him}. '
  iPutUnder     ='You can<./s>t do that. '
  dPutBehind    ='Done. '
  dPutBehindAlr ='{The dobj/him) {is} already behind {the iobj/him}. '
  iPutBehind    ='I don<./s>t understand that sentence. '
  dWear         ='They<./s>re out of fashion, and besides, it wouldn<./s>t fit. '
  dDoff         ='You aren<./s>t wearing that. '
  dKiss         ='I<./s>d sooner kiss a pile of Antarian swamp mold. '
  dAsk     /*!*/='Talking to a laser? Dr. Quarnsboggle, the Feinstein<./s>s psychiatrist, would have been fascinated to hear that. '
  dAskFor       ='Talking to a laser? Dr. Quarnsboggle, the Feinstein<./s>s psychiatrist, would have been fascinated to hear that. '
  dAskAbout     ='Talking to a laser? Dr. Quarnsboggle, the Feinstein<./s>s psychiatrist, would have been fascinated to hear that. '
  dTell    /*!*/='Talking to a laser? Dr. Quarnsboggle, the Feinstein<./s>s psychiatrist, would have been fascinated to hear that. '
  dTellAbout    ='Talking to a laser? Dr. Quarnsboggle, the Feinstein<./s>s psychiatrist, would have been fascinated to hear that. '
  dTalkTo       ='Talking to a laser? Dr. Quarnsboggle, the Feinstein<./s>s psychiatrist, would have been fascinated to hear that. '
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='You can<./s>t give (a dobj/him} to {an iobj/him}! '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='Why would you want to show something to a laser? '
  dFollow       ='The laser is right here! '
  dHit          ='I<./s>ve known strange beings, but attacking a laser?? '
  dHitWith      ='I<./s>ve known strange beings, but attacking a laser?? '
  iHitWith      =true
  dAttack       ='I<./s>ve known strange beings, but attacking a laser?? '
  dAttackWith   ='I<./s>ve known strange beings, but attacking a laser?? '
  iAttackWith   =true
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='I don<./s>t understand that sentence. '
  dDig     /*!*/=nil
  dDigWith      =nil
  iDigWith      =nil
  dJumpOver     ='That would be a good trick. '
  dJumpOff      ='That would be a good trick. '
  dPush         ='Pushing the laser has no effect. '
  dPull         ='Pulling the laser has no effect. '
  dMove         ='Moving the laser reveals nothing. '
  dMoveWith     ='I don<./s>t understand that sentence. '
  iMoveWith     ='I don<./s>t understand that sentence. '
  dMoveTo       ='I don<./s>t understand that sentence. '
  iMoveTo       ='I don<./s>t understand that sentence. '
  dTurn         ='Turning the laser accomplishes nothing. '
  dTurnWith     ='You can<./s>t do that. '
  iTurnWith     ='You can<./s>t do that. '
  dTurnTo       =true // this laser needs to be set to stuff.
  dConsult      =nil
  dConsultAbout =nil
  dSetTo        =true // no handling, just defaults to "You can't do that."
  dTypeOn       ='I don<./s>t understand that sentence. '
  dTypeLiteralOn='I don<./s>t understand that sentence. '
  dEnterOn      ='You can<./s>t go that way. '
  dSwitch       =nil
  dFlip         =nil
  dTurnOn       ='You can<./s>t turn that on. '
  dTurnOff      ='You can<./s>t turn that off. '
  dLight        ='I can<./s>t find a verb in that sentence! '
  dStrike       =true // remapped to dHit
  //dBurn    /*!*/=
  dBurnWith     ='Sorry, the laser doesn<./s>t have a rubber barrel. '
  //iBurnWith     =
  dExtinguish   ='I don<./s>t understand that sentence. '
  dAttach  /*!*/=nil
  dAttachTo     =nil
  iAttachTo     =nil
  dDetach       =nil
  dDetachFrom   =nil
  iDetachFrom   =nil
  dBreak        ='Trying to destroy the laser has no effect. '
  dCut     /*!*/=nil
  dCutWith      =nil
  iCutWith      =nil
  dClimb        ='You can<./s>t climb onto the laser. '
  dClimbUp      ='You can<./s>t go that way. '
  dClimbDown    ='You can<./s>t go that way. '
  dOpen         ='There doesn<./s>t seem to be any way to do that to this laser. '
  dClose        ='There doesn<./s>t seem to be any way to do that to this laser. '
  dLock         ='You can<./s>t do that. '
  dLockWith     ='You can<./s>t do that. '
  iLockWith     ='You can<./s>t do that. '
  dUnlock       ='You can<./s>t do that. '
  dUnlockWith   ='You can<./s>t do that. '
  iUnlockWith   ='You can<./s>t do that. '
  dEat          ='I don<./s>t think that the laser would agree with you. '
  dDrink        ='I don<./s>t think that the laser would agree with you. '
  dPour         ='Pouring or spilling nonliquids is specifically forbidden by section 17.9.2 of the Galactic Adventure Game Compendium of Rules. '
  dPourInto     ='Pouring or spilling nonliquids is specifically forbidden by section 17.9.2 of the Galactic Adventure Game Compendium of Rules. '
  iPourInto     ='You can<./s>t do that. '
  dPourOnto     ='Pouring or spilling nonliquids is specifically forbidden by section 17.9.2 of the Galactic Adventure Game Compendium of Rules. '
  iPourOnto     ='You can<./s>t do that. '
  dClean        ='You don<./s>t have anything to scrub with! '
  dCleanWith    ='You don<./s>t have anything to scrub with! '
  iCleanWith    ='You can<./s>t scrub something with that! '
  dSitOn        ='You can<./s>t climb onto the laser. '
  dLieOn        ='You can<./s>t climb onto the laser. '
  dStandOn      ='Standing on a laser seems like a waste of time. '
  dBoard        ='I suppose you have a theory on boarding a laser. '
  dGetOutOf     ='You<./s>re not in that! '
  dGetOffOf     ='You aren<./s>t wearing that. '
  dFasten       =nil
  dFastenTo     =nil
  iFastenTo     =nil
  dUnfasten     =nil
  dUnfastenFrom =nil
  iUnfastenFrom =nil
  dPlugIn       =nil
  dPlugInto     =nil
  iPlugInto     =nil
  dUnplug       =nil
  dUnplugFrom   =nil
  iUnplugFrom   =nil
  dScrew        =nil
  dScrewWith    =nil
  iScrewWith    =nil
  dUnscrew      =nil
  dUnscrewWith  =nil
  iUnscrewWith  =nil
  dGoThrough    ='That would involve quite a contortion! '
  dEnter        ='That would involve quite a contortion! '
  dPushTravel   ='I don<./s>t understand that sentence. '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
  objParseList = [SetAction, SetToAction, TurnToAction]
  dobjFor(Turn) {
    // Turning is nominally illogical here.
    verify { inherited; }
  }
  // Typing SET LASER is nominally illogical too.
  dobjFor(Set) asDobjFor(Turn)
  dobjFor(TurnTo) asDobjFor(SetTo)
  dobjFor(SetTo) {
    verify { }
    check { }
    action {
      local num = nil;
      local lit = gAction.getLiteral;
      if (lit && lit.find('one')) num = 1;
      if (lit && lit.find('two')) num = 2;
      if (lit && lit.find('three')) num = 3;
      if (lit && lit.find('four')) num = 4;
      if (lit && lit.find('five')) num = 5;
      if (lit && lit.find('six')) num = 6;
      if (!num && lit) {
        // another case where we handily use one of the functions
        // available in qtalk.t.
        num = qToInteger(lit);
        if (num < 1 || num > 6)
          num = nil;
      }
      if (!num) {
        "<.planetfall>The dial can only be set from 1 to 6.<./planetfall> ";
      }
      else {
        makeSetting(num);
        "<.planetfall>The dial is now set to <<num>>.<./planetfall> ";
      }
    }
  }
  curSetting = 5
  curColor {
    switch (curSetting) {
      case 1: return 'red';
      case 2: return 'orange';
      case 3: return 'yellow';
      case 4: return 'green';
      case 5: return 'blue';
      case 6: return 'violet';
      default: return 'white'; // bogus; should never happen
    }
  }
  ammo = 27
  ammoDecrement = 1
  shootConsequences {
    // inherit ammo decrementation
    inherited;
    // make the gun warmer, and remember that we did so.
    temperature += 2;
    gotHotterThisTurn = true;
  }
  temperature = 0
  gotHotterThisTurn = nil
  temperatureDescription {
    if (temperature <  3) return 'cool';
    if (temperature <  6) return 'slightly warm';
    if (temperature <  9) return 'somewhat warm';
    if (temperature < 12) return 'very warm';
    return 'quite hot';
  }
  // a faux daemon; will run every turn
  laserDaemon() {
    if (temperature > 0)
      temperature--;
    // If we increased the heat to 3, 6, 9, or 12, 
    // comment on the fact.
    if (temperature > 0 && temperature < 15 && temperature % 3 == 0
        && gotHotterThisTurn && self.isHeldBy(me)) {
      "<.p><.planetfall>The laser feels <<temperatureDescription>> now,
        but that doesn<./s>t seem to affect its performance
        at all.<./planetfall> ";
    }
    // If the laser's temperature cooled off to 3, 6, 9, or 12,
    // comment on this fact.
    if (temperature > 0 && temperature < 15 && temperature % 3 == 0
        && !gotHotterThisTurn && self.isHeldBy(me)) {
      "<.p><.planetfall>The laser has cooled, but it still feels
        <<temperatureDescription>>.<./planetfall> ";
    }
    gotHotterThisTurn = nil;
  }
  shootEffectEnemy {
    sayForArt(shootPrefixMsg(gDobj, true));
    sayForArt('strikes {the dobj/him}. {The dobj/him} jerks back for a moment, 
      but almost as soon as the beam goes off, 
      he recovers. ');
    // No shoot result
    //doShootResult(gDobj, defaultShootResult);
  }
  noAmmoMsg = 'Click. '
  shootAimlesslyMsg =
    'The laser emits a narrow ' + curColor + ' beam of light. '
  shootPrefixMsg(obj, complex) { 
    return
      'The laser emits a narrow ' + curColor + ' beam of light which '
      + throughMsg('passes through the ',' and ',obj, complex);
  }
  shootThingMsg(obj) {
    gMessageParams(obj);
    return 'strikes {the obj/him}. {The obj/he} 
      grow{s} a bit warm, but nothing else happens. ';
  }
  shootFriendMsg =
    'just misses {the dobj/him}, striking the walls 
      instead. The walls grow a bit warm, but 
      nothing else happens. '
  mirrorBounceMsg = 'bounces off the mirror and '
  windowTransmitMsg = 'passes through the ' + windowWord
  //skywayWindowTransmitMsg =
  //  'and disappears into the distance. '
  //officeWindowTransmitMsg =
  //  'and strikes the walls in the room beyond, creating no visible effect. '
  //slowingFieldTransmitMsg =
  //  'and strikes the walls behind it, creating no visible effect. '
  letsActorShootHimself = true
  shootingOneselfWithThisIsDeadly = nil
  actorShootingHimselfMsg =
    'Ouch! You managed to burn yourself nicely. '
  gunShootingItselfMsg =
    'Sorry, the laser doesn<./s>t have a rubber barrel. '
  zapAry = disappear(
    transformUnsimulated('an assembly of earls')
      + '<p>The earls come up to you and ask you where 
        the king is. When you tell them you don<./s>t know,
        the velvet-clad noblement '
        + (doorInThisRoomMustBeOpened() ? 'open the door and ' : '')
        + 'march off into the distance, presumably
        in search of their sovereign. '
    , self, 'earls'
  )
  zapAryCq {
    openDoorInThisRoom();
  }
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: dispenser
// -------------------------------------------------------------------

// Due to laziness, I did not implement a HitchhikerObject class to
// contain the lines of code common to dispenser and dispenserButton.

//class HitchhikerObject: object
//;

dispenser: Artifact, NonPortable
  // is listed in room descriptions?
  isListed = nil
  // is listed when direct container is examined or looked in?
  isListedInContents = nil
  // is listed in inventory?
  isListedInInventory = nil
  pedestalContentsDesc =
    "On <<asscPed.theName>> is a tall dispensing machine. "
  vocabWords='(babel) (fish) (tall) dispensing dispenser machine/slot/artifact*artifacts'
  name      ='fish dispenser'
  nickname  ='fish dispenser'
  artTitle  ='The Hitchhiker<./s>s Guide to the Galaxy'
  artAuthor ='Douglas Adams and Steve Meretzky'
  artCompany='Infocom'
  artComp   ='Infocom'
  artYear   ='1984'
  artAttr   ='c'
  artAttrib ='cc'
  artHtml1  ='<.hitchhiker>'
  artHtml2  ='<./hitchhiker>'
  //Original description: "The dispenser is tall, has a button at around eye-level, and says <.q>Fish<./q> in large letters. Anything dispensed would probably come out the slot at around knee-level. It bears a small label which reads <.q>Another fine product of the Sirius Cybernetics Corporation.<./q> "
  artDesc   ="The dispenser is tall, 
    <<asscButtonThing
      ? 'has a ' + asscButtonThing.name + ' above your head, ' : ''>> 
    and says <.q>Fish<./q> in large letters. Anything dispensed would 
    probably come out the slot at around shoulder-level (since the 
    machine is on top of the pedestal). It bears a small 
    label which reads <.q>Another fine product of the Sirius Cybernetics 
    Corporation.<./q> "
  asscButtonThing {
    if (dispenserBuon.isIn(self))
      return dispenserBuon;
    else if (dispenserButton.isIn(self))
      return dispenserButton;
    else
      return nil;
  }
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  // parsing stuff
  parseFailMsg = 'I don<./s>t know the word <.q>' + glob.latestVerb + '<./q>. '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         ='How can you read a fish dispenser? '
  dLookIn       ='You can<./s>t do that. '
  dSearch       ='You find nothing unusual. '
  dLookUnder    ='There is nothing but dust there. '
  dLookBehind   ='There is nothing behind the fish dispenser. '
  dLookThrough  ='You can<./s>t do that. '
  dListenTo     ='At the moment, the fish dispenser makes no sound. '
  dSmell        ='It smells just like a fish dispenser. '
  dTaste        ='You can<./s>t. At least, not in this game you can<./s>t. '
  dFeel         ='Fiddling with the fish dispenser doesn<./s>t do anything. '
  dobjFor(Take) {
    verify() {
      if (gDobj) illogical(notBloodyLikelyEventList.returnScript);
    }
  }
  dTakeAlr      ='You already have it. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Dropped. '
  dDropAlr      ='You<./s>re not holding the fish dispenser. '
  dPutIn        ='Done. '
  dPutInAlr     ='I think the fish dispenser {is} already in {the iobj/him}. '
  iPutIn        ='You can<./s>t put {a dobj/him} in a fish dispenser! '
  dPutOn        ='Done. '
  dPutOnAlr     ='I think the fish dispenser {is} already on {the iobj/him}. '
  iPutOn        ='There<./s>s no good surface on the fish dispenser. '
  dPutUnder     ='Done. '
  dPutUnderAlr  ='I think the fish dispenser {is} already under {the iobj/him}. '
  iPutUnder     ='{You/he} can<./s>t put anything under the fish dispenser. '
  dPutBehind    ='Done. '
  dPutBehindAlr ='I think the fish dispenser {is} already behind {the iobj/him}. '
  iPutBehind    ='{You/he} can<./s>t put anything behind the fish dispenser. '
  dWear         ='You<./s>re not holding the fish dispenser. '
  dDoff         =(notBloodyLikelyEventList.returnScript)
  //dDoff         =true
  //dobjFor(Doff) {
  //  verify() {
  //    if (gDobj) illogical(notBloodyLikelyEventList.returnScript);
  //  }
  //}
  dKiss         ='This is family entertainment, not a video nasty. '
  dAsk     /*!*/=true // asks for topic
  dAskFor       ='Unsurprisingly the fish dispenser doesn<./s>t oblige. '
  dAskAbout     ='You can<./s>t talk to a fish dispenser! '
  dTell    /*!*/=true // asks for topic
  dTellAbout    ='It doesn<./s>t look like the fish dispenser is interested. '
  dTalkTo       ='You can<./s>t talk to a fish dispenser! '
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='You can<./s>t give {a dobj/him} to a fish dispenser! '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='I doubt the fish dispenser is interested. '
  dFollow       ='No, no, a thousand times no. Go boil an egg. '
  dHit          ='You are obviously letting things get to you. You should learn to relax a little. '
  dHitWith      ='You are obviously letting things get to you. You should learn to relax a little. '
  iHitWith      ='You<./s>re not holding the fish dispenser. '
  dAttack       ='You are obviously letting things get to you. You should learn to relax a little. '
  dAttackWith   ='You are obviously letting things get to you. You should learn to relax a little. '
  iAttackWith   ='You<./s>re not holding the fish dispenser. '
  dThrow   /*!*/='That<./s>s easy for you to say since you don<./s>t even have the fish dispenser. '
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='The fish dispenser do{es}n<./s>t look like {it/he} want{s} to catch anything. '
  dDig     /*!*/=true // asks for iobj
  dDigWith      ='Useless. Utterly useless. '
  iDigWith      ='That sentence isn<./s>t one I recognize. '
  dJumpOver     ='Wasn<./s>t that fun? '
  dJumpOff      ='Wasn<./s>t that fun? '
  dPush         ='Pushing the fish dispenser accomplishes nothing. '
  dPull         ='You can<./s>t move the fish dispenser. '
  dMove         ='You can<./s>t move the fish dispenser. '
  dMoveWith     ='You can<./s>t move the fish dispenser. '
  iMoveWith     ='That sentence isn<./s>t one I recognize. '
  dMoveTo       ='That sentence isn<./s>t one I recognize. '
  iMoveTo       =true // does nothing
  dTurn         ='This has no effect. '
  dTurnWith     ='This has no effect. '
  iTurnWith     ='That sentence isn<./s>t one I recognize. '
  dTurnTo       ='This has no effect. '
  dConsult      ='You can<./s>t talk to a fish dispenser! '
  dConsultAbout ='You can<./s>t talk to a fish dispenser! '
  dSetTo        =true // no handling, just defaults to "You can't do that."
  dTypeOn       ='You can<./s>t type on that! '
  dTypeLiteralOn='You can<./s>t type on that! '
  dEnterOn      ='Did you have any particular direction in mind? '
  dSwitch       ='This has no effect. '
  dFlip         ='This has no effect. '
  dTurnOn       ='You can<./s>t turn that on. '
  dTurnOff      ='You can<./s>t turn that off. '
  dLight        ='You can<./s>t turn that on. '
  dStrike       =true // remapped to dHit
  dBurn    /*!*/=nil
  dBurnWith     =nil
  iBurnWith     =nil
  dExtinguish   ='You can<./s>t turn that off. '
  dAttach  /*!*/='You can<./s>t tie a fish dispenser. '
  dAttachTo     ='You can<./s>t tie a fish dispenser. '
  iAttachTo     ='You can<./s>t seem to plug {the dobj/him} into the fish dispenser. '
  dDetach       =(notBloodyLikelyEventList.returnScript)
  dDetachFrom   =(notBloodyLikelyEventList.returnScript)
  iDetachFrom   =(notBloodyLikelyEventList.returnScript)
  dBreak        ='Trying to break the fish dispenser has no desirable effect. '
  dCut     /*!*/=true // asks for iobj
  dCutWith      ='Trying to cut the fish dispenser has no desirable effect. '
  iCutWith      ='I doubt that the <.q>cutting edge<./q> of a fish dispenser is adequate. '
  dClimb        =(notBloodyLikelyEventList.returnScript)
  dClimbUp      =(notBloodyLikelyEventList.returnScript)
  dClimbDown    =(notBloodyLikelyEventList.returnScript)
  dOpen         ='You must tell me how to do that to a fish dispenser. '
  dClose        ='You must tell me how to do that to a fish dispenser. '
  dLock         =(notBloodyLikelyEventList.returnScript)
  dLockWith     =(notBloodyLikelyEventList.returnScript)
  iLockWith     =(notBloodyLikelyEventList.returnScript)
  dUnlock       =(notBloodyLikelyEventList.returnScript)
  dUnlockWith   =(notBloodyLikelyEventList.returnScript)
  iUnlockWith   =(notBloodyLikelyEventList.returnScript)
  dEat          ='Stuffing the fish dispenser in your mouth would do little to help at this point. '
  dDrink        ='You can<./s>t drink that! '
  dPour         =(notBloodyLikelyEventList.returnScript)
  dPourInto     =(notBloodyLikelyEventList.returnScript)
  iPourInto     =(notBloodyLikelyEventList.returnScript)
  dPourOnto     =(notBloodyLikelyEventList.returnScript)
  iPourOnto     =(notBloodyLikelyEventList.returnScript)
  dClean        ='It is now much cleaner. '
  dCleanWith    ='It is now much cleaner. '
  iCleanWith    ='That sentence isn<./s>t one I recognize. '
  dSitOn        ='You can<./s>t climb onto the fish dispenser. '
  dLieOn        ='You can<./s>t get into the fish dispenser! '
  dStandOn      ='Useless. Utterly useless. '
  dBoard        ='You can<./s>t get into the fish dispenser! '
  dGetOutOf     ='Look around you. '
  dGetOffOf     ='You<./s>re not holding the fish dispenser. '
  dFasten       ='You can<./s>t tie a fish dispenser. '
  dFastenTo     ='You can<./s>t tie a fish dispenser. '
  iFastenTo     ='You can<./s>t seem to plug {the dobj/him} into the fish dispenser. '
  dUnfasten     =(notBloodyLikelyEventList.returnScript)
  dUnfastenFrom =(notBloodyLikelyEventList.returnScript)
  iUnfastenFrom =(notBloodyLikelyEventList.returnScript)
  dPlugIn       ='You can<./s>t seem to plug in the fish dispenser. '
  dPlugInto     ='You can<./s>t seem to plug the fish dispenser into {the iobj/him}. '
  iPlugInto     ='You can<./s>t seem to plug {the dobj/him} into the fish dispenser. '
  dUnplug       ='No, no, a thousand times no. Go boil an egg. '
  dUnplugFrom   ='That sentence isn<./s>t one I recognize. '
  iUnplugFrom   ='That sentence isn<./s>t one I recognize. '
  dScrew        =nil
  dScrewWith    =nil
  iScrewWith    =nil
  dUnscrew      =nil
  dUnscrewWith  =nil
  iUnscrewWith  =nil
  dGoThrough    ='You hit your head against the fish dispenser as you attempt this feat. '
  dEnter        ='You hit your head against the fish dispenser as you attempt this feat. '
  dPushTravel   ='That sentence isn<./s>t one I recognize. '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
;

dispenserButton: StrangeThing
  doNotMoveArtifact = true
//dispenserButton: Component
  vocabWords = '(babel) (fish) (dispenser) (dispensing) (machine) button'
  name = 'dispenser button'
  location = dispenser
  isListed = nil
  isListedInContents = nil
  isListedInInventory = nil
  artHtml1  ='<.hitchhiker>'
  artHtml2  ='<./hitchhiker>'
  artDesc = "You see nothing special about <<theName>>. "
  hideFromAll(action) { return true; }
  dobjFor(Push) {
    verify {
      nonObvious;
    }
    //verify() { }
    check() { }
    action() {
      if (fishValue > fishList.length()) {
        "<.hitchhiker>Click. <./hitchhiker>";
      }
      else {
        "<.hitchhiker><<fishList[fishValue].launchMsg>><./hitchhiker>";
        fishList[fishValue].moveInto(getOutermostRoom);
        fishValue++;
      }
        
    }
  }
  fishValue = 1
  //stickleback and northernPike omitted deliberately.
  // and I guess even atlanticSalmon.
  fishList = [
     minnow          // 1                --               --
    ,trout           // 2             tutor!!            rou
    ,tetra           // 1             treat              ERA
    ,seahorse        // 1          SEASHORE               --
    ,char            // 2              arch!!             --
    ,oceanPerch      // 2        nachoCrepe               --
    ,sturgeon        // 2.               --          surgeon!! 
    ,oregonChub      // 1        hugeBronco!!             --
    ,bream           // 2             amber               --
    ,africanLungfish // 2   HUNGARIANCLIFFS               --
    ,tuna            // 3!!            aunt!!            una
    ,gar             // 2.              rag               --
    ,bobtailSnipeEel // 1   alienBiblePoets!! bobailSnipeEel
    ,tarpon          // 3!!          patron!!          arpon
    ,oto             // 1
  ]
    //,northernPike    // 2.     kennethPrior!!    norhernPike!
    //,atlanticSalmon  // 3!!  satanicTollman!!   alanicSalmon!!
  /*
  2019-08-10
  I removed the carp (-> crap) for aesthetic reasons.
  2019-05-12 
  I dredged the internet for T-containing fish. 
  Here's the new one I want to include:
  oto -> Oo
  Here are some ones I probably won't bother to include:
  platy -> play
  thornfish -> hornfish
  trevally -> Revally (a village in India)
  warty angler -> wary angler
  warty frogfish -> wary frogfish
  */
  
  // parsing stuff
  parseFailMsg = 'I don<./s>t know the word <.q>' + glob.latestVerb + '<./q>. '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         ='How can you read a dispenser button? '
  dLookIn       ='You can<./s>t do that. '
  dSearch       ='You find nothing unusual. '
  dLookUnder    ='There is nothing but dust there. '
  dLookBehind   ='There is nothing behind the dispenser button. '
  dLookThrough  ='You can<./s>t do that. '
  dListenTo     ='At the moment, the dispenser button makes no sound. '
  dSmell        ='It smells just like a dispenser button. '
  dTaste        ='You can<./s>t. At least, not in this game you can<./s>t. '
  dFeel         ='Fiddling with the dispenser button doesn<./s>t do anything. '
  dobjFor(Take) {
    verify() {
      if (gDobj) illogical(notBloodyLikelyEventList.returnScript);
    }
  }
  dTakeAlr      ='You already have it. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Dropped. '
  dDropAlr      ='You<./s>re not holding the dispenser button. '
  dPutIn        ='Done. '
  dPutInAlr     ='I think {the dobj/he} {is} already in {the iobj/him}. '
  iPutIn        ='You can<./s>t put {a dobj/him} in {an iobj/him}! '
  dPutOn        ='Done. '
  dPutOnAlr     ='I think {the dobj/he} {is} already on {the iobj/him}. '
  iPutOn        ='There<./s>s no good surface on {the iobj/him}. '
  dPutUnder     ='Done. '
  dPutUnderAlr  ='I think {the dobj/he} {is} already under {the iobj/him}. '
  iPutUnder     ='{You/he} can<./s>t put anything under {the iobj/him}. '
  dPutBehind    ='Done. '
  dPutBehindAlr ='I think {the dobj/he} {is} already behind {the iobj/him}. '
  iPutBehind    ='{You/he} can<./s>t put anything behind {the iobj/him}. '
  dWear         ='You<./s>re not holding the dispenser button. '
  dDoff         =(notBloodyLikelyEventList.returnScript)
  //dDoff         =true
  //dobjFor(Doff) {
  //  verify() {
  //    if (gDobj) illogical(notBloodyLikelyEventList.returnScript);
  //  }
  //}
  dKiss         ='This is family entertainment, not a video nasty. '
  dAsk     /*!*/=true // asks for topic
  dAskFor       ='Unsurprisingly the dispenser button doesn<./s>t oblige. '
  dAskAbout     ='You can<./s>t talk to a dispenser button! '
  dTell    /*!*/=true // asks for topic
  dTellAbout    ='It doesn<./s>t look like the dispenser button is interested. '
  dTalkTo       ='You can<./s>t talk to a dispenser button! '
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='You can<./s>t give {a dobj/him} to {an iobj/him}! '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='I doubt {the iobj/he} is interested. '
  dFollow       ='No, no, a thousand times no. Go boil an egg. '
  dHit          ='You are obviously letting things get to you. You should learn to relax a little. '
  dHitWith      ='You are obviously letting things get to you. You should learn to relax a little. '
  iHitWith      ='You<./s>re not holding the dispenser button. '
  dAttack       ='You are obviously letting things get to you. You should learn to relax a little. '
  dAttackWith   ='You are obviously letting things get to you. You should learn to relax a little. '
  iAttackWith   ='You<./s>re not holding the dispenser button. '
  dThrow   /*!*/='That<./s>s easy for you to say since you don<./s>t even have the dispenser button. '
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='{The iobj/he} do{es}n<./s>t look like {it/he} want{s} to catch anything. '
  dDig     /*!*/=true // asks for iobj
  dDigWith      ='Useless. Utterly useless. '
  iDigWith      ='That sentence isn<./s>t one I recognize. '
  dJumpOver     ='Wasn<./s>t that fun? '
  dJumpOff      ='Wasn<./s>t that fun? '
  dPush         =true // FOR SURE, WE WANT TO BE ABLE TO PUSH THE BUTTON!!
  dPull         ='You can<./s>t move the dispenser button. '
  dMove         ='You can<./s>t move the dispenser button. '
  dMoveWith     ='You can<./s>t move the dispenser button. '
  iMoveWith     ='That sentence isn<./s>t one I recognize. '
  dMoveTo       ='That sentence isn<./s>t one I recognize. '
  iMoveTo       =true // does nothing
  dTurn         ='This has no effect. '
  dTurnWith     ='This has no effect. '
  iTurnWith     ='That sentence isn<./s>t one I recognize. '
  dTurnTo       ='This has no effect. '
  dConsult      ='You can<./s>t talk to a dispenser button! '
  dConsultAbout ='You can<./s>t talk to a dispenser button! '
  dSetTo        =true // no handling, just defaults to "You can't do that."
  dTypeOn       ='You can<./s>t type on that! '
  dTypeLiteralOn='You can<./s>t type on that! '
  dEnterOn      ='Did you have any particular direction in mind? '
  dSwitch       ='This has no effect. '
  dFlip         ='This has no effect. '
  dTurnOn       ='You can<./s>t turn that on. '
  dTurnOff      ='You can<./s>t turn that off. '
  dLight        ='You can<./s>t turn that on. '
  dStrike       =true // remapped to dHit
  dBurn    /*!*/=nil
  dBurnWith     =nil
  iBurnWith     =nil
  dExtinguish   ='You can<./s>t turn that off. '
  dAttach  /*!*/='You can<./s>t tie a dispenser button. '
  dAttachTo     ='You can<./s>t tie a dispenser button. '
  iAttachTo     ='You can<./s>t seem to plug {the dobj/him} into the dispenser button. '
  dDetach       =(notBloodyLikelyEventList.returnScript)
  dDetachFrom   =(notBloodyLikelyEventList.returnScript)
  iDetachFrom   =(notBloodyLikelyEventList.returnScript)
  dBreak        ='Trying to break the dispenser button has no desirable effect. '
  dCut     /*!*/=true // asks for iobj
  dCutWith      ='Trying to cut the dispenser button has no desirable effect. '
  iCutWith      ='I doubt that the <.q>cutting edge<./q> of a dispenser button is adequate. '
  dClimb        =(notBloodyLikelyEventList.returnScript)
  dClimbUp      =(notBloodyLikelyEventList.returnScript)
  dClimbDown    =(notBloodyLikelyEventList.returnScript)
  dOpen         ='You must tell me how to do that to a dispenser button. '
  dClose        ='You must tell me how to do that to a dispenser button. '
  dLock         =(notBloodyLikelyEventList.returnScript)
  dLockWith     =(notBloodyLikelyEventList.returnScript)
  iLockWith     =(notBloodyLikelyEventList.returnScript)
  dUnlock       =(notBloodyLikelyEventList.returnScript)
  dUnlockWith   =(notBloodyLikelyEventList.returnScript)
  iUnlockWith   =(notBloodyLikelyEventList.returnScript)
  dEat          ='Stuffing the dispenser button in your mouth would do little to help at this point. '
  dDrink        ='You can<./s>t drink that! '
  dPour         =(notBloodyLikelyEventList.returnScript)
  dPourInto     =(notBloodyLikelyEventList.returnScript)
  iPourInto     =(notBloodyLikelyEventList.returnScript)
  dPourOnto     =(notBloodyLikelyEventList.returnScript)
  iPourOnto     =(notBloodyLikelyEventList.returnScript)
  dClean        ='It is now much cleaner. '
  dCleanWith    ='It is now much cleaner. '
  iCleanWith    ='That sentence isn<./s>t one I recognize. '
  dSitOn        ='You can<./s>t climb onto the dispenser button. '
  dLieOn        ='You can<./s>t get into the dispenser button! '
  dStandOn      ='Useless. Utterly useless. '
  dBoard        ='You can<./s>t get into the dispenser button! '
  dGetOutOf     ='Look around you. '
  dGetOffOf     ='You<./s>re not holding the dispenser button. '
  dFasten       ='You can<./s>t tie a dispenser button. '
  dFastenTo     ='You can<./s>t tie a dispenser button. '
  iFastenTo     ='You can<./s>t seem to plug {the dobj/him} into the dispenser button. '
  dUnfasten     =(notBloodyLikelyEventList.returnScript)
  dUnfastenFrom =(notBloodyLikelyEventList.returnScript)
  iUnfastenFrom =(notBloodyLikelyEventList.returnScript)
  dPlugIn       ='You can<./s>t seem to plug in {the dobj/him}. '
  dPlugInto     ='You can<./s>t seem to plug {the dobj/him} into {the iobj/him}. '
  iPlugInto     ='You can<./s>t seem to plug {the dobj/him} into {the iobj/him}. '
  dUnplug       ='No, no, a thousand times no. Go boil an egg. '
  dUnplugFrom   ='That sentence isn<./s>t one I recognize. '
  iUnplugFrom   ='That sentence isn<./s>t one I recognize. '
  dScrew        =nil
  dScrewWith    =nil
  iScrewWith    =nil
  dUnscrew      =nil
  dUnscrewWith  =nil
  iUnscrewWith  =nil
  dGoThrough    ='You hit your head against the dispenser button as you attempt this feat. '
  dEnter        ='You hit your head against the dispenser button as you attempt this feat. '
  dPushTravel   ='That sentence isn<./s>t one I recognize. '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
  zapT = transform(self, dispenserBuon)
;

dispenserBuon: Component, Buon
  '(babel) (fish) (dispenser) (dispensing) (machine) buon'
  'dispenser buon'
;
  
notBloodyLikelyEventList: RandomEventList
  [
    '<.hitchhiker>Not bloody likely. <./hitchhiker>',
    '<.hitchhiker>What a concept. <./hitchhiker>',
    '<.hitchhiker>Nice try. <./hitchhiker>',
    '<.hitchhiker>You can<./s>t be serious. <./hitchhiker>'
  ]
  returnScript() {
    local idx;
    if (!checkEventOdds())
      return nil;
    idx = getNextRandom();
    if (idx >= 1 && idx <= eventList.length())
      return eventList[idx];
    else
      return nil;
  }
;

//ALL THIS STUFF WAS PART OF THE 'dispenser' OBJECT:
//  // parsing stuff
//  parseFailMsg = 'I don<./s>t know the word <.q>' + glob.latestVerb + '<./q>. '
//  objParseList = []
//  // "d" and "i" methods
//  dExamine      =true // shows desc
//  dRead         ='How can you read a fish dispenser? '
//  dLookIn       ='You can<./s>t do that. '
//  dSearch       ='You find nothing unusual. '
//  dLookUnder    ='There is nothing but dust there. '
//  dLookBehind   ='There is nothing behind the fish dispenser. '
//  dLookThrough  ='You can<./s>t do that. '
//  dListenTo     ='At the moment, the fish dispenser makes no sound. '
//  dSmell        ='It smells just like a fish dispenser. '
//  dTaste        ='You can<./s>t. At least, not in this game you can<./s>t. '
//  dFeel         ='Fiddling with the fish dispenser doesn<./s>t do anything. '
//  dTake         =(notBloodyLikelyEventList.returnScript)
//  //dobjFor(Take) {
//  //  check() {
//  //    notBloodyLikelyEventList.doScript;
//  //    exit;
//  //  }
//  //}
//  dTakeAlr      ='You already have it. '
//  dRemove  /*!*/=true // for non-clothing, acts like Take
//  dTakeFrom     =true // if successful, acts like Take
//  dDrop         ='Dropped. '
//  dDropAlr      ='You<./s>re not holding the fish dispenser. '
//  dPutIn        ='Done. '
//  dPutInAlr     ='I think {the dobj/he} {is} already in {the iobj/him}. '
//  iPutIn        ='You can<./s>t put {a dobj/him} in {an iobj/him}! '
//  dPutOn        ='Done. '
//  dPutOnAlr     ='I think {the dobj/he} {is} already on {the iobj/him}. '
//  iPutOn        ='There<./s>s no good surface on {the iobj/him}. '
//  dPutUnder     ='Done. '
//  dPutUnderAlr  ='I think {the dobj/he} {is} already under {the iobj/him}. '
//  iPutUnder     ='{You/he} can<./s>t put anything under {the iobj/him}. '
//  dPutBehind    ='Done. '
//  dPutBehindAlr ='I think {the dobj/he} {is} already behind {the iobj/him}. '
//  iPutBehind    ='{You/he} can<./s>t put anything behind {the iobj/him}. '
//  dWear         ='You<./s>re not holding the fish dispenser. '
//  dDoff         =(notBloodyLikelyEventList.returnScript)
//  //dDoff         =true
//  //dobjFor(Doff) {
//  //  verify() {
//  //    if (gDobj) illogical(notBloodyLikelyEventList.returnScript);
//  //  }
//  //}
//  dKiss         ='This is family entertainment, not a video nasty. '
//  dAsk     /*!*/=true // asks for topic
//  dAskFor       ='Unsurprisingly the fish dispenser doesn<./s>t oblige. '
//  dAskAbout     ='You can<./s>t talk to a fish dispenser! '
//  dTell    /*!*/=true // asks for topic
//  dTellAbout    ='It doesn<./s>t look like the fish dispenser is interested. '
//  dTalkTo       ='You can<./s>t talk to a fish dispenser! '
//  dGive    /*!*/=true // asks for iobj
//  dGiveTo       =true // no special action; handled by iGiveTo
//  iGiveTo       ='You can<./s>t give {a dobj/him} to {an iobj/him}! '
//  dShow    /*!*/=true // asks for iobj
//  dShowTo       =true // no special action; handled by iShowTo
//  iShowTo       ='I doubt {the iobj/he} is interested. '
//  dFollow       ='No, no, a thousand times no. Go boil an egg. '
//  dHit          ='You are obviously letting things get to you. You should learn to relax a little. '
//  dHitWith      ='You are obviously letting things get to you. You should learn to relax a little. '
//  iHitWith      ='You<./s>re not holding the fish dispenser. '
//  dAttack       ='You are obviously letting things get to you. You should learn to relax a little. '
//  dAttackWith   ='You are obviously letting things get to you. You should learn to relax a little. '
//  iAttackWith   ='You<./s>re not holding the fish dispenser. '
//  dThrow   /*!*/='That<./s>s easy for you to say since you don<./s>t even have the fish dispenser. '
//  dThrowAt      =true // calls processThrow method; or override this.
//  iThrowAt      =true // no action; anything can be a target
//  dThrowTo      =true // calls processThrow method; or override this.
//  iThrowTo      ='{The iobj/he} do{es}n<./s>t look like {it/he} want{s} to catch anything. '
//  dDig     /*!*/=true // asks for iobj
//  dDigWith      ='Useless. Utterly useless. '
//  iDigWith      ='That sentence isn<./s>t one I recognize. '
//  dJumpOver     ='Wasn<./s>t that fun? '
//  dJumpOff      ='Wasn<./s>t that fun? '
//  dPush         ='Pushing the fish dispenser accomplishes nothing. '
//  dPull         ='You can<./s>t move the fish dispenser. '
//  dMove         ='You can<./s>t move the fish dispenser. '
//  dMoveWith     ='You can<./s>t move the fish dispenser. '
//  iMoveWith     ='That sentence isn<./s>t one I recognize. '
//  dMoveTo       ='That sentence isn<./s>t one I recognize. '
//  iMoveTo       =true // does nothing
//  dTurn         ='This has no effect. '
//  dTurnWith     ='This has no effect. '
//  iTurnWith     ='That sentence isn<./s>t one I recognize. '
//  dTurnTo       ='This has no effect. '
//  dConsult      ='You can<./s>t talk to a fish dispenser! '
//  dConsultAbout ='You can<./s>t talk to a fish dispenser! '
//  dSetTo        =true // no handling, just defaults to "You can't do that."
//  dTypeOn       ='You can<./s>t type on that! '
//  dTypeLiteralOn='You can<./s>t type on that! '
//  dEnterOn      ='Did you have any particular direction in mind? '
//  dSwitch       ='This has no effect. '
//  dFlip         ='This has no effect. '
//  dTurnOn       ='You can<./s>t turn that on. '
//  dTurnOff      ='You can<./s>t turn that off. '
//  dLight        ='You can<./s>t turn that on. '
//  dStrike       =true // remapped to dHit
//  dBurn    /*!*/=nil
//  dBurnWith     =nil
//  iBurnWith     =nil
//  dExtinguish   ='You can<./s>t turn that off. '
//  dAttach  /*!*/='You can<./s>t tie a fish dispenser. '
//  dAttachTo     ='You can<./s>t tie a fish dispenser. '
//  iAttachTo     ='You can<./s>t seem to plug {the dobj/him} into the fish dispenser. '
//  dDetach       =(notBloodyLikelyEventList.returnScript)
//  dDetachFrom   =(notBloodyLikelyEventList.returnScript)
//  iDetachFrom   =(notBloodyLikelyEventList.returnScript)
//  dBreak        ='Trying to break the fish dispenser has no desirable effect. '
//  dCut     /*!*/=true // asks for iobj
//  dCutWith      ='Trying to cut the fish dispenser has no desirable effect. '
//  iCutWith      ='I doubt that the <.q>cutting edge<./q> of a fish dispenser is adequate. '
//  dClimb        =(notBloodyLikelyEventList.returnScript)
//  dClimbUp      =(notBloodyLikelyEventList.returnScript)
//  dClimbDown    =(notBloodyLikelyEventList.returnScript)
//  dOpen         ='You must tell me how to do that to a fish dispenser. '
//  dClose        ='You must tell me how to do that to a fish dispenser. '
//  dLock         =(notBloodyLikelyEventList.returnScript)
//  dLockWith     =(notBloodyLikelyEventList.returnScript)
//  iLockWith     =(notBloodyLikelyEventList.returnScript)
//  dUnlock       =(notBloodyLikelyEventList.returnScript)
//  dUnlockWith   =(notBloodyLikelyEventList.returnScript)
//  iUnlockWith   =(notBloodyLikelyEventList.returnScript)
//  dEat          ='Stuffing the fish dispenser in your mouth would do little to help at this point. '
//  dDrink        ='You can<./s>t drink that! '
//  dPour         =(notBloodyLikelyEventList.returnScript)
//  dPourInto     =(notBloodyLikelyEventList.returnScript)
//  iPourInto     =(notBloodyLikelyEventList.returnScript)
//  dPourOnto     =(notBloodyLikelyEventList.returnScript)
//  iPourOnto     =(notBloodyLikelyEventList.returnScript)
//  dClean        ='It is now much cleaner. '
//  dCleanWith    ='It is now much cleaner. '
//  iCleanWith    ='That sentence isn<./s>t one I recognize. '
//  dSitOn        ='You can<./s>t climb onto the fish dispenser. '
//  dLieOn        ='You can<./s>t get into the fish dispenser! '
//  dStandOn      ='Useless. Utterly useless. '
//  dBoard        ='You can<./s>t get into the fish dispenser! '
//  dGetOutOf     ='Look around you. '
//  dGetOffOf     ='You<./s>re not holding the fish dispenser. '
//  dFasten       ='You can<./s>t tie a fish dispenser. '
//  dFastenTo     ='You can<./s>t tie a fish dispenser. '
//  iFastenTo     ='You can<./s>t seem to plug {the dobj/him} into the fish dispenser. '
//  dUnfasten     =(notBloodyLikelyEventList.returnScript)
//  dUnfastenFrom =(notBloodyLikelyEventList.returnScript)
//  iUnfastenFrom =(notBloodyLikelyEventList.returnScript)
//  dPlugIn       ='You can<./s>t seem to plug in {the dobj/him}. '
//  dPlugInto     ='You can<./s>t seem to plug {the dobj/him} into {the iobj/him}. '
//  iPlugInto     ='You can<./s>t seem to plug {the dobj/him} into {the iobj/him}. '
//  dUnplug       ='No, no, a thousand times no. Go boil an egg. '
//  dUnplugFrom   ='That sentence isn<./s>t one I recognize. '
//  iUnplugFrom   ='That sentence isn<./s>t one I recognize. '
//  dScrew        =nil
//  dScrewWith    =nil
//  iScrewWith    =nil
//  dUnscrew      =nil
//  dUnscrewWith  =nil
//  iUnscrewWith  =nil
//  dGoThrough    ='You hit your head against the fish dispenser as you attempt this feat. '
//  dEnter        ='You hit your head against the fish dispenser as you attempt this feat. '
//  dPushTravel   ='That sentence isn<./s>t one I recognize. '
//  dShoot        =true // asks for iobj (if not a weapon)
//  dShootAimless =true // '{You/he} cannot shoot anything with that. '
//  dShootWith    =true // nothing special; handled by iShootWith
//  iShootWith    =true // '{You/he} cannot shoot anything with that. '
//  // miscellaneous behavior

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: crystal
// -------------------------------------------------------------------

crystal: Artifact
  vocabWords='crystal/rock/stone/artifact*artifacts'
  name      ='crystal'
  nickname  ='crystal'
  artTitle  ='Fish!'
  artAuthor ='John Molloy, Pete Kemp, Phil South, and Rob Steggles'
  artCompany='Magnetic Scrolls'
  artComp   ='Magnetic Scrolls'
  artYear   ='1988'
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.fish>'
  artHtml2  ='<./fish>'
  artDesc   ="Light catches this crystal in a beautifully irregular manner. "
  //desc = "Light catches this crystal in a beautifully irregular manner. "
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  // parsing stuff
  parseFailMsg = 'I don<./s>t understand ' + glob.latestVerb + ' ' // sic; no period
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         ='There is nothing to read here! '
  dLookIn       ='Light catches this crystal in a beautifully irregular manner. '
  dSearch       ='You find nothing of interest. '
  dLookUnder    ='You find nothing of interest. '
  dLookBehind   ='You find nothing of interest. '
  dLookThrough  ='Light catches this crystal in a beautifully irregular manner. '
  dListenTo     ='You can<./s>t hear anything. '
  dSmell        ='The crystal smells like a crystal. '
  dTaste        ='The crystal tastes totally inedible. '
  dFeel         ='The crystal is hard. '
  dTake         ='You have now got the crystal. '
  dTakeAlr      ='But you are already carrying the crystal. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Crystal dropped. '
  dDropAlr      ='But you are not carrying the crystal. '
  dPutIn        ='The crystal is now inside {the iobj/him}. '
  dPutInAlr     ='But the crystal is already inside {the iobj/him}. '
  iPutIn        ='But the crystal is not a container. '
  dPutOn        ='The crystal is now on {the iobj/him}. '
  dPutOnAlr     ='But the crystal is already on {the iobj/him}. '
  iPutOn        ='You can<./s>t do that to the crystal. '
  dPutUnder     ='The crystal is now under {the iobj/him}. '
  dPutUnderAlr  ='But the crystal is already under {the iobj/him}. '
  iPutUnder     ='You are unable to do that ' // sic; no period
  dPutBehind    ='The crystal is now behind {the iobj/him}. '
  dPutBehindAlr ='But the crystal is already behind {the iobj/him}. '
  iPutBehind    ='I don<./s>t follow you. '
  dWear         ='You can<./s>t do that to the crystal at the moment. '
  dDoff         ='You can<./s>t do that to the crystal at the moment. '
  dKiss         =nil
  dAsk     /*!*/='Talking to inanimate objects is a sure sign of madness. '
  dAskFor       ='Talking to inanimate objects is a sure sign of madness. '
  dAskAbout     ='Talking to inanimate objects is a sure sign of madness. '
  dTell    /*!*/='Talking to inanimate objects is a sure sign of madness. '
  dTellAbout    ='Talking to inanimate objects is a sure sign of madness. '
  dTalkTo       ='Talking to inanimate objects is a sure sign of madness. '
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='The crystal advises you to visit your psychiatrist. '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='Strange concept! '
  dFollow       =nil
  dHit          ='You are unable to do that. '
  dHitWith      ='You are unable to do that. '
  iHitWith      ='You are unable to do that. '
  dAttack       ='You can<./s>t do that to the crystal. '
  dAttackWith   ='You can<./s>t do that to the crystal. '
  iAttackWith   ='You can<./s>t do that with the crystal. '
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='I don<./s>t follow you. '
  dDig     /*!*/='Strange concept! '
  dDigWith      ='Strange concept! '
  iDigWith      ='Strange concept! '
  dJumpOver     ='I don<./s>t follow you. '
  dJumpOff      ='You can<./s>t go that way. '
  dPush         ='You succeed in moving the crystal, but nothing happens. '
  dPull         ='You succeed in moving the crystal, but nothing happens. '
  dMove         ='You succeed in moving the crystal, but nothing happens. '
  dMoveWith     ='You succeed in moving the crystal, but nothing happens. '
  iMoveWith     ='Strange concept! '
  dMoveTo       ='You succeed in moving the crystal, but nothing happens. '
  iMoveTo       =true // does nothing
  dTurn         ='I don<./s>t follow you. '
  dTurnWith     ='I don<./s>t follow you. '
  iTurnWith     ='I don<./s>t follow you. '
  dTurnTo       ='I don<./s>t follow you. '
  dConsult      =nil
  dConsultAbout =nil
  dSetTo        ='You can<./s>t do that to the crystal. '
  dTypeOn       =nil
  dTypeLiteralOn=nil
  dEnterOn      ='You can<./s>t go that way. '
  dSwitch       ='I don<./s>t follow you. '
  dFlip         ='{You/he} cannot flip {that dobj/him}. '
  dTurnOn       ='Hey, I really dig you crystal. ' // sic; no comma
  dTurnOff      ='You can<./s>t do that to the crystal. '
  dLight        ='You can<./s>t do that to the crystal. '
  dStrike       =nil
  dBurn    /*!*/='You can<./s>t do that to the crystal. '
  dBurnWith     ='You can<./s>t do that to the crystal. '
  iBurnWith     ='But the crystal is not burning. '
  dExtinguish   ='But the crystal is not alight ' // sic; no period
  dAttach  /*!*/=true // asks for iobj
  dAttachTo     ='You can<./s>t do that with the crystal. '
  iAttachTo     ='You can<./s>t do that with the crystal. '
  dDetach       =nil
  dDetachFrom   =nil
  iDetachFrom   =nil
  dBreak        ='You are unable to do that. '
  dCut     /*!*/=true // asks for iobj
  dCutWith      ='You can<./s>t do that to the crystal. '
  iCutWith      ='But the crystal is not sharp enough. '
  dClimb        ='You can<./s>t go that way. '
  dClimbUp      ='You can<./s>t go that way. '
  dClimbDown    ='You can<./s>t go that way. '
  dOpen         ='You can<./s>t do that to the crystal. '
  dClose        ='You can<./s>t do that to the crystal. '
  dLock         ='You can<./s>t do that to the crystal. '
  dLockWith     ='You can<./s>t do that to the crystal. '
  iLockWith     ='You can<./s>t do that with the crystal. '
  dUnlock       ='You can<./s>t do that to the crystal. '
  dUnlockWith   ='You can<./s>t do that to the crystal. '
  iUnlockWith   ='You can<./s>t do that with the crystal. '
  dEat          ='Strange concept! '
  dDrink        ='Strange concept! '
  dPour         ='Strange concept! '
  dPourInto     ='Strange concept! '
  iPourInto     ='You can<./s>t do that to the crystal. '
  dPourOnto     ='Strange concept! '
  iPourOnto     ='You can<./s>t do that to the crystal. '
  dClean        ='There is no such clean crystal. ' // sic
  dCleanWith    ='There is no such clean crystal. ' // sic
  iCleanWith    ='You can<./s>t do that with the crystal. '
  dSitOn        ='You can<./s>t sit on that! '
  dLieOn        ='You are unable to do that. '
  dStandOn      ='You can<./s>t do that to the crystal. '
  dBoard        ='You can<./s>t do that to the crystal. '
  dGetOutOf     ='Strange concept! '
  dGetOffOf     ='Strange concept! '
  dFasten       =nil
  dFastenTo     =nil
  iFastenTo     =nil
  dUnfasten     =nil
  dUnfastenFrom =nil
  iUnfastenFrom =nil
  dPlugIn       ='You can<./s>t do that to the crystal. '
  dPlugInto     ='You can<./s>t do that to the crystal. '
  iPlugInto     ='You can<./s>t do that to the crystal. '
  dUnplug       =nil
  dUnplugFrom   =nil
  iUnplugFrom   =nil
  dScrew        ='You can<./s>t do that with the crystal. '
  dScrewWith    ='You can<./s>t do that with the crystal. '
  iScrewWith    ='You can<./s>t do that with the crystal. '
  dUnscrew      ='You can<./s>t do that to the crystal. '
  dUnscrewWith  ='You can<./s>t do that to the crystal. '
  iUnscrewWith  ='You can<./s>t do that with the crystal. '
  dGoThrough    ='You can<./s>t go that way. '
  dEnter        ='You can<./s>t go that way. '
  dPushTravel   ='You succeed in moving the crystal, but nothing happens. '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless ='You can<./s>t do that with the crystal. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    ='You can<./s>t do that with the crystal. '
  // miscellaneous behavior
  zapT = transform(self, crysal)
;

/*
'particle gun':
    "The particle beam gun is a complicated looking device
      that vaguely resembles an old fashioned air cooled 
      machine gun. On the back end of the weapon (or tool) 
      is a grip and a trigger. A thick, insulated cable 
      leads from the gun to a heavy box (perhaps a power source). 
      <<gunIsOnClamp ? 
        'The gun is secured on a metal tripod by a force clamp. ' : ''>>";
      // That last line remains the same even if the clamp is turned off.
    " "
    "You take the gun from the tripod, noting that it remains secured
      to another piece of heavy equipment by a thick cable. 
      The length of the cable limits your ability to move more than 
      a few meters in any direction without dropping the gun. "
'trigger':
    "The particle beam gun has an awkward grip meant 
      for Heechee hands (or tentacles), but the trigger mechanism 
      is quite simple. In front of the metal grip 
      is a small metal trigger that looks very similar 
      to what you might find on a modern assault weapon. "
'power cell' (insulated) (heavy) power cable/box/battery/cell: 
    "The gun is attached to a mysterious box (a power cell, perhaps) 
      by a heavy cable. The cable is quite flexible, but it is 
      very thick and looks like it is made out of metal. The power 
      cell is a plain rectangular box, like a huge battery. It looks 
      very heavy. The gun apparently isn't leaving the room. "
'tripod':
    "A heavy metal tripod sits on the deck nearby. 
      <<gunIsOnClamp ? 
        'A particle beam gun is attached to the tripod by a force clamp. ' : ''>>"
      // That last line remains the same even if the clamp is turned off.
'force clamp' clamp/field:
    // When activated:
    "The particle beam gun is secured to the tripod in a vertical 
      position by a blue force clamp, a simple ring of blue metal. 
      The air above the clamp (and around the gun) shimmers in a 
      peculiar way, almost as if it is refracting light differently. 
      You surmise that this effect is due to the force field 
      that holds the gun on the tripod. After a moment of study, 
      you notice a rectangular metal key that protrudes 
      from a small semi-circular module on the clamp. "
    // When deactivated:
    "The deactivated force clamp looks like a simple metal ring. "
'force clamp key' key/module:
    "The key is a flat rectangle that emerges from a rounded module
      on the force clamp. "
      // This remains the same even if the key has been turned.
    
    // if you turn the key again:
    "You turn the key again, but the force field does not re-appear. "
grip: NOT IMPLEMENTED
*/

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: particleGun classes and objects
// -------------------------------------------------------------------

class GatewayObject: object // a mix-in class
  artTitle  ='Gateway II: Homeworld'
  artAuthor ='Mike Verdu and Glen Dahlgren'
  artCompany='Legend Entertainment'
  artComp   ='Legend Entertainment'
  artYear   ='1993'
  artAttr   ='c'
  artAttrib ='cc'
  artHtml1  ='<.gateway>'
  artHtml2  ='<./gateway>'
  //artDesc() {
  //  "The particle beam gun is a complicated looking device
  //    that vaguely resembles an old fashioned air cooled 
  //    machine gun. On the back end of the weapon (or tool) 
  //    is a grip and a trigger. ";
  //  //"A thick, insulated cable 
  //  //  leads from the gun to a heavy box (perhaps a power source). ";
  //  "The gun is secured on a metal tripod. ";
  //}
  // parsing stuff
  parseFailMsg = '[You don<./s>t need to use the word <.q>' + 
                   glob.latestVerb + '<./q> with this object.] '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         ='You can<./s>t read {a dobj/him}! '
  dLookIn       ='How can you do that? '
  //dSearch       =true // acts exactly like LookIn
  dobjFor(Search) asDobjFor(Examine)
  dLookUnder    ='You discover nothing of interest. '
  dLookBehind   ='You discover nothing of interest. '
  dLookThrough  ='How can you do that? '
  dListenTo     ='You don<./s>t hear anything very interesting right now. '
  dSmell        ='You inhale deeply, attempting to get a good whiff of {the dobj/him}. It doesn<./s>t seem to have much of an odor. '
  dTaste        ='{The dobj/he} doesn<./s>t look very appetizing. '
  dFeel         ='You run your fingers over {the dobj/him} and feel nothing unusual. '
  dTake         ='Taken. '
  dTakeAlr      ='You already have {the dobj/him}. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
/*!!!!!!!!!!!!!*/dDrop         ='You drop the gun on the deck. ' // 
  dDropAlr      ='You don<./s>t have {the dobj/him}. '
  dPutIn        ='You put {the dobj/him} in {the iobj/him}. '
  dPutInAlr     ='{The dobj/he} {is} already in {the iobj/him}. '
  iPutIn        ='{You/he} can<./s>t put {the dobj/him} in {the iobj/him}. '
  dPutOn        ='You put {the dobj/him} on {the iobj/him}. '
  dPutOnAlr     ='{The dobj/he} {is} already on {the iobj/him}. '
  iPutOn        ='There doesn<./s>t seem to be a suitable place to put {the dobj/him} on {the iobj/him}. '
  dPutUnder     ='You put {the dobj/him} under {the iobj/him}. '
  dPutUnderAlr  ='{The dobj/he} {is} already under {the iobj/him}. '
  iPutUnder     ='{You/he} can<./s>t put {the dobj/him} under {the iobj/him}. '
  dPutBehind    ='You put {the dobj/him} behind {the iobj/him}. '
  dPutBehindAlr ='{The dobj/he} {is} already behind {the iobj/him}. '
  iPutBehind    ='{You/he} can<./s>t put {the dobj/him} behind {the iobj/him}. '
  dWear         ='You can<./s>t wear {the dobj/him}. '
  dDoff         ='Please specify what you want to remove {the dobj/him} from. '
  dKiss         ='Kissing {a dobj/him}, while it might satisfy some bizarre sexual urge, won<./s>t get you anywhere in this game. '
  dAsk     /*!*/=true // asks for topic
  dAskFor       ='You can<./s>t talk to {a dobj/him}. '
  dAskAbout     ='You can<./s>t talk to {a dobj/him}. '
  dTell    /*!*/=true // asks for topic
  dTellAbout    ='You can<./s>t talk to {a dobj/him}. '
  dTalkTo       ='You can<./s>t talk to {a dobj/him}. '
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='{The dobj/he} isn<./s>t likely to appreciate your offer. '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='{The dobj/he} doesn<./s>t appear to be interested in the slip of paper. '
  dFollow       ='{You/he} can<./s>t follow {that dobj/him}. '
  dHit          ='You bang on {the dobj/him}, but it just sits there. '
  dHitWith      ='You bang on {the dobj/him}, but it just sits there. '
  iHitWith      ='{The dobj/he} isn<./s>t suited for that kind of work. '
  dAttack       ='You bang on {the dobj/him}, but it just sits there. '
  dAttackWith   ='You bang on {the dobj/him}, but it just sits there. '
  iAttackWith   ='{The dobj/he} isn<./s>t suited for that kind of work. '
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  //iThrowTo      ='{The iobj/he} do{es}n<./s>t look like {it/he} want{s} to catch anything. '
  iobjFor(ThrowTo) asIobjFor(ThrowAt)
  dDig     /*!*/=true // asks for iobj
  dDigWith      ='{The dobj/he} is much too hard to dig up with {the iobj/him}. '
  iDigWith      ='{The dobj/he} isn<./s>t suited for that kind of work. '
  dJumpOver     ='You jump up and down a few times and then need to rest. '
  dJumpOff      ='You<./s>re not in {the dobj/him}. '
  dPush         ='Nothing happens. '
/*!!!!!!!!!!!!!*/  dPull         ='You try to give {the dobj/him} a tug, but nothing comes of it. '
  dMove         ='{The dobj/he} remain{s} where {it dobj/he} {is}. '
  dMoveWith     ='{The dobj/he} remain{s} where {it dobj/he} {is}. '
  iMoveWith     ='{The dobj/he} isn<./s>t suited for that kind of work. '
  dMoveTo       ='You attempt to lead {the dobj/him} to {the iobj/him}, but {it dobj/him} do{es}n<./s>t seem to understand. '
  iMoveTo       ='You attempt to lead {the dobj/him} to {the iobj/him}, but {it dobj/him} do{es}n<./s>t seem to understand. '
  dTurn         ='You try to twist {the dobj/him} but nothing happens. '
  dTurnWith     ='[Please say that another way, or try something else.] '
  iTurnWith     ='[Please say that another way, or try something else.] '
  dTurnTo       ='You try to twist {the dobj/him} but nothing happens. '
  dConsult      ='You can<./s>t talk to {a dobj/him}. '
  dConsultAbout ='You can<./s>t talk to {a dobj/him}. '
  dSetTo        ='You try to twist {the dobj/him} but nothing happens. '
  dTypeOn       =nil
  dTypeLiteralOn=nil
  dEnterOn      ='[Please say that another way, or try something else.] '
  dSwitch       ='You try to twist {the dobj/him} but nothing happens. '
  dFlip         ='You try to twist {the dobj/him} but nothing happens. '
  dTurnOn       ='You can<./s>t turn that on! '
  dTurnOff      ='You can<./s>t turn off {a dobj/him}. '
  dLight        ='{The dobj/he} {is}n<./s>t flammable. '
  dStrike       =true // remapped to dHit
  dBurn    /*!*/='{The dobj/he} {is}n<./s>t flammable. '
  dBurnWith     ='{The dobj/he} {is}n<./s>t flammable. '
  iBurnWith     ='You can<./s>t burn {the dobj/him} with {the iobj/him}. '
  dExtinguish   ='You can<./s>t turn off {a dobj/him}. '
  dAttach  /*!*/=true // asks for iobj
  dAttachTo     ='{You/he} can<./s>t attach {a dobj/him} to {the iobj/him}. '
  iAttachTo     ='{You/he} can<./s>t attach {a dobj/him} to {the iobj/him}. '
  dobjFor(Detach) asDobjFor(Take)
/*!!!!!!!!!!!!!*/dobjFor(DetachFrom) asDobjFor(Take)
  //dDetach       ='{You/he} cannot detach {that dobj/him}. '
  //dDetachFrom   ='{You/he} cannot detach {that dobj/him}. '
  iDetachFrom   ='{You/he} can<./s>t take anything from {that iobj/him}. '
  dBreak        ='You bang on {the dobj/him}, but it just sits there. '
  dCut     /*!*/=true // asks for iobj
  dCutWith      ='You hack away at the tuning fork for a while, but inflict no noticeable damage. '
  iCutWith      ='You consider hacking away at {the dobj/him} for a while, but then you realize that {an iobj/him} would make a lousy knife. '
  dClimb        ='It would be too difficult to climb {the dobj/him}. '
  dClimbUp      ='It would be too difficult to climb {the dobj/him}. '
  dClimbDown    ='It would be too difficult to climb {the dobj/him}. '
  dOpen         ='You can<./s>t open {a dobj/him}! '
  dClose        ='You can<./s>t close {the dobj/him}. '
  dLock         ='Why would you want to lock {the dobj/him}? '
  dLockWith     ='Why would you want to lock {the dobj/him}? '
  iLockWith     ='You can<./s>t lock anything with {an iobj/him}. '
  dUnlock       ='{The dobj/he} {is}n<./s>t locked. '
  dUnlockWith   ='{The dobj/he} {is}n<./s>t locked. '
  iUnlockWith   ='You can<./s>t unlock anything with {an iobj/him}. '
  dEat          ='{The dobj/he} doesn<./s>t look very appetizing. '
  dDrink        ='You must be getting pretty desperate if you<./s>re trying to drink {a dobj/him}. '
  dPour         ='You can<./s>t pour {the dobj/him}. '
  dPourInto     ='You can<./s>t pour {the dobj/him}. '
  iPourInto     ='{You/he} can<./s>t pour anything into {that dobj/him}. '
  dPourOnto     ='You can<./s>t pour {the dobj/him}. '
  iPourOnto     ='{You/he} can<./s>t pour anything onto {that dobj/him}. '
  dClean        ='You can<./s>t clean {a dobj/him}. '
  dCleanWith    ='You can<./s>t clean {a dobj/him} with {the iobj/him}. '
  iCleanWith    ='You can<./s>t clean {a dobj/him} with {the iobj/him}. '
  dSitOn        ='This is no time for resting. '
  dLieOn        ='You can<./s>t get on {the dobj/him}. '
  dStandOn      ='You can<./s>t get on {the dobj/him}. '
  dBoard        ='{You/he} can<./s>t enter {the dobj/him}. '
  dGetOutOf     ='You<./s>re not in {the dobj/him}. '
  dGetOffOf     ='You<./s>re not on {the dobj/him}. '
  dFasten       ='{You/he} can<./s>t attach {the dobj/him}. '
  dFastenTo     ='You can<./s>t attach {a dobj/him} to {the iobj/him}. '
  iFastenTo     ='You can<./s>t attach {a dobj/him} to {the iobj/him}. '
  dUnfasten     =nil
  dUnfastenFrom =nil
  iUnfastenFrom =nil
  dPlugIn       ='[Please say that another way, or try something else.] '
  dPlugInto     ='[Please say that another way, or try something else.] '
  iPlugInto     ='[Please say that another way, or try something else.] '
  dUnplug       ='[Please say that another way, or try something else.] '
  dUnplugFrom   ='[Please say that another way, or try something else.] '
  iUnplugFrom   ='[Please say that another way, or try something else.] '
  dScrew        ='{The dobj/he} can<./s>t be screwed. '
  dScrewWith    ='[Please say that another way, or try something else.] '
  iScrewWith    ='[Please say that another way, or try something else.] '
  dUnscrew      ='{The dobj/he} can<./s>t be unscrewed. '
  dUnscrewWith  ='{The dobj/he} can<./s>t be unscrewed with {the iobj/him}. '
  iUnscrewWith  ='{The dobj/he} can<./s>t be unscrewed with {the iobj/him}. '
  dGoThrough    ='You can<./s>t enter {the dobj/him}. '
  dEnter        ='You can<./s>t enter {the dobj/him}. '
  dPushTravel   ='[Please say that another way, or try something else.] '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
;

class ParticleRelated: object
  asscGun = particleGun
  asscCell = particleCell
  asscPed {
    if (self == particleGun)
      return inherited;
    else
      return particleGun.asscPed;
  }
;

class ParicleRelated: object
  artHtml1 = ''
  artHtml2 = ''
  asscGun = paricleGun
  asscCell = paricleCell
  asscPed = particleGun.asscPed // sic; "T" is intentional
;

//
class PGun: object
  countedAsArtifactForRoomDesc = true
  // is listed when direct container is examined or looked in?
  isListedInContents {
    if (location == asscPed)
      return nil;
    else
      return true;
  }
  isListedInInventory = nil
  dobjFor(Drop) {
    action {
      "You try dropping {the dobj/him} to the floor, 
        but the gun<./s>s cable doesn<./s>t quite reach 
        that far, so you put the gun on 
        <<asscPed.theName>> instead. ";
      moveInto(asscPed);
    }
  }
  dobjFor(Throw) {
    verify {
      illogicalNow('You can<./s>t do that because the gun is held down
        by a heavy cable. ');
    }
  }
  dobjFor(ThrowAt) {
    verify { verifyDobjThrow; }
  }
  dobjFor(ThrowTo) {
    verify { verifyDobjThrow; }
  }
  dobjFor(PutOn) {
    check {
      if (gIobj == asscPed)
        { } // let the iobj take the item
      else if (gIobj && gIobj.ofKind(AlienPlatform)) {
        "You try dropping {the dobj/him} to {the iobj/him}, 
          but the gun<./s>s cable doesn<./s>t quite reach 
          that far, so you give up the effort. ";
        exit;
      }
      else {
        "You try putting the {the dobj/him} on {the iobj/him},
          but it doesn<./s>t fit very well, so you decide
          to give up the effort. ";
        exit;
      }
    }
  }
  dobjFor(PutIn) {
    check {
      "You try putting the {the dobj/him} in {the iobj/him},
        but it doesn<./s>t fit very well, so you decide
        to give up the effort. ";
      exit;
    }
  }
  pedestalContentsDesc {
    //if (!hasBeenTaken)
    //  "On <<asscPed.theName>> is what looks like
    //    a particle beam gun, perhaps used for drilling
    //    or taking core samples; the gun is connected
    //    by a thick cable to a heavy box. ";
    //else
    //  "On <<asscPed.theName>> is a particle gun, 
    //    connected by a thick cable to a heavy box. ";
    
    //"<<artHtml1>>On <<asscPed.theName>> is a particle gun, 
    //  connected by a thick cable to a heavy box.<<artHtml2>> ";
    
    "On <<asscPed.theName>> is a particle gun, 
      connected by a thick cable to a heavy box. ";
  }
  //bang() {
  //  return true;
  //}
  //bangWeapon() {
  //  "<.odyssey>I fire the Phaser,\n
  //    Nothing happens\n
  //    Either I missed or beam was absorbed without visible
  //    effect!<./odyssey>";
  //}
  //bangTarget() {
  //  if (curSetting == 'stun') {
  //    // Trying to stun an inanimate object:
  //    if (!gDobj.ofKind(Actor))
  //      bangWeapon();
  //    // Trying to stun an actor that's already stunned:
  //    else if (gDobj.isStunned)
  //      bangWeapon();
  //    // Stunning an actor (who's not already stunned):
  //    else {
  //      gDobj.isStunned = true;
  //      gDobj.startStunFuse();
  //      "<.odyssey>I fire the Phaser,\n
  //        its stunned!<./odyssey>\b";
  //      lookAroundScottAdams();
  //    }
  //  }
  //  else { // Otherwise, curSetting == 'destroy'
  //    // Do not permit the destruction of the actor or anything 
  //    // the actor is in.
  //    if (gActor.isIn(gDobj))
  //      bangWeapon();
  //    // Otherwise, blammo, and let the player beware.
  //    else {
  //      gDobj.moveInto(nil);
  //      "<.odyssey>I fire the Phaser,\n
  //        I destroyed it!<./odyssey>\b";
  //      lookAroundScottAdams();
  //    }
  //  }
  //}
  tangibleProjectiles = true
  shootEffectEnemy {
    sayForArt(shootPrefixMsg(gDobj, true));
    sayForArt(' and hits {the dobj/him}, quickly 
      burning his flesh. The alien staggers, 
      collapses to the floor, and writhes in agony 
      for several long seconds, until finally 
      he grows still. After satisfying yourself 
      that {the dobj/him} is dead, you release 
      the trigger. ');
    doShootResult(gDobj, kill);
  }
  shootAimlesslyMsg = (shootPrefixMsg(nil, nil) + shootThingMsg(nil))
  shootPrefixMsg(obj, complex) {
    return 'You pull the trigger. The gun 
      powers up with a whine and then a beam of bright 
      white light flashes from the front of the gun'
      + throughMsg(', passes through the ',',',obj, complex);
  }
  shootThingMsg(obj) {
    return ' and hits one of the walls. 
      The metal under the beam bubbles, smokes, 
      and begins running in rivulets. 
      After satisfying yourself that the gun works, 
      you release the trigger. ';
  }
  shootFriendMsg =
    ', but just misses {the dobj/him}, 
      hitting one of the walls instead, 
      causing the metal of the walls to bubble 
      and smoke momentarily before you release the trigger. '
  mirrorBounceMsg =
    ', bounces back off the mirror,'
  windowTransmitMsg =
    '. The beam passes through the window'
  officeWindowTransmitMsg =
    ' and strikes the walls in the room beyond, causing 
      the metal of the walls to bubble and smoke 
      momentarily before you release the trigger. '
  slowingFieldTransmitMsg =
    ' and strikes the walls behind it, causing
      the metal of the walls to bubble and smoke
      momentarily before you release the trigger. '
  actorShootingHimselfMsg =
    (shootPrefixMsg(gDobj, nil) + shootThingMsg(nil))
  gunShootingItselfMsg =
    '[Warning: infinite perform recursion terminated.] '
  letsActorShootHimself = true
  shootingOneselfWithThisIsDeadly = nil
  zapRemoveCq {
    asscCell.moveInto(nil);
  }
;

particleGun: PGun, ParticleRelated, GatewayObject, ArtifactGun
  // Not counted as vocabulary in the original game: weapon, tool, grip
  vocabWords='particle beam particle-beam gun/firearm/weapon/trigger/artifact*guns*firearms*weapons*triggers*artifacts'
  name      ='particle gun'
  nickname  ='particle gun'
  location  = nil // as an artifact, its location changes automatically.
  // By cleverly overriding initLocation(), we can configure the 
  // components of this gun properly on the pedestal. Specifically,
  // as follows:
  //   pedestal
  //   + powercell
  //   + gun
  initLocation() {
    inherited;
    // Don't just move the gun itself; move the power cell too.
    asscCell.moveInto(asscPed);
  }
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  artDesc() {
    "The particle beam gun is a complicated looking device
      that vaguely resembles an old fashioned air cooled 
      machine gun. On the back end of the weapon (or tool) 
      is a grip and a trigger. ";
    "A thick, insulated cable 
      leads from the gun to a heavy box (perhaps a power source)";
    //if (isIn(asscPed))
    //  ". Both the gun and the box are sitting ";
    //else
    //  ", which is mounted ";
    ", which is mounted ";
    "on <<asscPed.theName>>. ";
    //"The gun is secured on a metal tripod. ";
  }
  dobjFor(Take) {
    action {
      inherited;
      hasBeenTaken = true;
    }
  }
  hasBeenTaken = nil
  objParseList = []
//  dobjFor(Take) {
//    verify {
//      illogical('<.gateway>You can<./s>t take {the dobj/him}.<./gateway> ');
//    }
//  }
  // Deal with this in a special custom way for the p.b. gun.
  //dobjFor(Take) {
  //  verify {
  //    illogical('You can<./s>t take {the dobj/him}. ');
  //  }
  //}
  
  // Because of the fact that this gun generally never hits anything
  // except hostile NPCs, it can't reflect off mirrors or go
  // through windows. In this non-reflecting, non-going-through aspect,
  // the gun behaves like a gun that uses tangible projectiles,
  // regardless of the fact that its "particles" aren't very tangible.
  tangibleProjectiles = true
  zapT = transform(self, paricleGun)
  zapTCq {
    // If you transform the particle gun to a paricle gun,
    // transform the power cell as well.
    paricleCell.moveInto(asscPed);
    particleCell.moveInto(nil);
  }
  zapAry = lose(
    'The particle gun disappears.
      <p>Then, all of a sudden, everything goes black. 
        Something strange has happened. You feel
        as if all the air around you has disappeared.
        What<./s>s more, you can<./s>t move.
      <p>You try to move your arms, but fail. 
        Your head and legs can<./s>t move either.
      <p>After several seconds of struggling,
        eventually you realize that
        your entire body surface has been 
        coated with a hard metal shell.
      <p>It takes an excruciating five minutes
        before you die of suffocation. 
        During that time, you never once think about 
        the color of your shell. You will never know
        that it was light beige. '
    , ftEcruPlating, 'ecru plating', self
  )
;
ftEcruPlating: FinishType
  finishMsg = 'You have been encased in ecru plating'
;
paricleGun: SemiNonsense, ParicleRelated, PGun, GunThing
  'paricle beam paricle-beam gun/firearm/weapon/trigger*guns*firearms*weapons*triggers'
  'paricle gun'
  location = nil
  desc() {
    "The paricle beam gun is a rather plain-looking gun. ";
    "A thick, insulated cable 
      leads from the gun to a power cell";
    //if (isIn(asscPed))
    //  ". Both the gun and the box are sitting ";
    //else
    //  ", which is mounted ";
    ", which is mounted ";
    "on <<asscPed.theName>>. ";
    //"The gun is secured on a metal tripod. ";
  }
  zapAry = die(
    'The paricle gun is transformed into
        a nuclear pig!
      <p>Just as you are beginning to wonder 
        how this could have happened, the pig explodes. '
    //'The paricle gun is transformed into
    //    a statue of a pig!
    //  <p>Just as you are beginning to wonder 
    //    how this could have happened, something even more 
    //    extraordinary occurs. The pig explodes. 
    //  <p>Nor is this any ordinary explosion. 
    //    It generates a fireball several miles
    //    in diameter, and the nuclear fallout
    //    afterwards is sufficient to force the 
    //    evacuation of the entire continent. 
    //  <p>Yes, setting off a nuclear pig
    //    is no laughing matter. '
    , 'nuclear pig', self, killEverybody
  )
  tangibleProjectiles = nil
  shootEffectEnemy { shootEffectThing; }
  shootAimlesslyMsg =
    (shootPrefixMsg(nil, nil) + ' and hits one of the walls. 
    The walls seem none the worse for this. ')
  shootPrefixMsg(obj, complex) {
    return 'You pull the trigger. A beam of bright 
      white light flashes from the front of the gun'
      + throughMsg(', passes through the ',',',obj, complex);
  }
  shootThingMsg(obj) {
    gMessageParams(obj);
    return ' and hits {the obj/him}. 
      {The obj/he} seem{s} none the worse for this. ';
  }
  shootFriendMsg =
    ', but just misses {the dobj/him}, 
      hitting one of the walls instead. 
      The walls seem none the worse for this. '
  gunShootingItselfMsg =
    'You can<./s>t fire {the iobj/him} at itself. '
  // Inherit from Gun, not PGun.
  officeWindowTransmitMsg { return Gun.officeWindowTransmitMsg; }
  slowingFieldTransmitMsg { return Gun.slowingFieldTransmitMsg; }
;

class UntakeableInMuseum: object
  dobjFor(Take) {
    check {
      // For some reason, some StrangeThings in the museum are not properly 
      // inheriting from the NonPortable class. Fix this.
      if (cannotTakeMsg)
        say(cannotTakeMsg);
      else
        
      exit;
    }
  }
;

class Powercellesque: object
  // is listed in room descriptions?
  isListed = nil
  // is listed when direct container is examined or looked in?
  isListedInContents = nil
  // is listed in inventory?
  isListedInInventory = nil
  countedAsArtifactForRoomDesc = true
  pedestalContentsDesc =
    "Mounted on <<asscPed.theName>> is a power cell,
      from which a thick cable runs to 
      <<asscGun.theName>>. "
  desc {
    //NOOF
    "<<artHtml1>>\^<<asscGun.theName>> is attached to ";
    if (ofKind(GatewayObject))
      "a mysterious box (a power cell, perhaps) ";
    else
      "a large power cell ";
    "by a heavy cable. The cable is quite flexible, 
      but it is very thick and looks like 
      it is made out of metal. 
      The power cell is a plain rectangular box, 
      like a huge battery. It is mounted on <<asscPed.theName>>, 
      and it looks very heavy. 
      The particle gun apparently isn<./s>t 
      leaving the room. <<artHtml2>>";
  }
  zapRemoveCq {
    asscGun.moveInto(nil);
  }
;

class MuseumImmovable: Immovable
  //NOOF
  cannotTakeImmovableMsg = (artHtml1 + playerActionMessages.cannotTakeImmovableMsg + artHtml2)
  //NOOF
  cannotMoveImmovableMsg = (artHtml1 + playerActionMessages.cannotMoveImmovableMsg + artHtml2)
  //NOOF
  cannotPutImmovableMsg  = (artHtml1 + playerActionMessages.cannotPutImmovableMsg  + artHtml2)
;

particleCell: Powercellesque, ParticleRelated, GatewayObject, MuseumImmovable, StrangeThing
  'power cell'
  'power cell'
  location = nil
  //dobjFor(Take) {
  //  check {
  //    "<.gateway>You tug on the cable, then try and break it. No luck.
  //      You try to move the power cell, but it is too heavy.
  //      Finally you try to figure out a way of unplugging the gun.
  //      No joy. You can<./s>t unplug it. The only thing you can do
  //      is pick up the gun once the force field is disabled.
  //      You can<./s>t take it outside the room.<./gateway> ";
  //    exit;
  //  }
  //}
  cannotTakeMsg =
    '<.gateway>You tug on the cable, then try and break it. No luck.
      You try to move the power cell, but it is too heavy.
      Finally you try to figure out a way of unplugging the gun.
      No joy. You can<./s>t unplug it. The only thing you can do
      is pick up the gun; you can<./s>t take it very far
      away from ' + asscPed.theName + '.<./gateway> '
;

paricleCell: ParicleRelated, Powercellesque, Immovable
  'power cell'
  'paricle power cell'
  location = nil
  cannotTakeMsg =
    'No, the cable can<./s>t be taken or pulled off,
      and power cell is too heavy to move.
      Nor can you unplug the gun, so you can only
      hold the gun while you<./s>re near ' 
      + asscPed.theName + '. '
;






//pbCell: Artifact
//  doNotMoveArtifact = true
//  // Not counted as vocabulary in the original game: weapon, tool, grip
//  vocabWords='(gateway) (2) (two) (particle) (beam) (particle-beam) (gun) (insulated) (heavy) power cable/box/cell'
//  name      ='particle gun'
//  location  =particleGun
//  isListed = nil
//  isListedInContents = nil
//  isListedInInventory = nil
//  artHtml1  ='<.gateway>'
//  artHtml2  ='<./gateway>'
//  artDesc =
//    "The gun is attached to a mysterious box (a power cell, perhaps) 
//      by a heavy cable. The cable is quite flexible, but it is 
//      very thick and looks like it is made out of metal. The power 
//      cell is a plain rectangular box, like a huge battery. It looks 
//      very heavy. The gun apparently isn't leaving the room. "
//  // parsing stuff
//  parseFailMsg = '[You don<./s>t need to use the word <.q>' + 
//                   glob.latestVerb + '<./q> when referring to the ' +
//                   name + '.] '
//  objParseList = []
//  // "d" and "i" methods
//  dExamine      =true // shows desc
//  dRead         ='You can<./s>t read {a dobj/him}! '
//  dLookIn       ='How can you do that? '
//  //dSearch       =true // acts exactly like LookIn
//  dobjFor(Search) asDobjFor(Examine)
//  dLookUnder    ='You discover nothing of interest. '
//  dLookBehind   ='You discover nothing of interest. '
//  dLookThrough  ='How can you do that? '
//  dListenTo     ='You don<./s>t hear anything very interesting right now. '
//  dSmell        ='You inhale deeply, attempting to get a good whiff of {the dobj/him}. It doesn<./s>t seem to have much of an odor. '
//  dTaste        ='{The dobj/he} doesn<./s>t look very appetizing. '
//  dFeel         ='You run your fingers over {the dobj/him} and feel nothing unusual. '
///*!!!!!!!!!!!!!*/dTake         ='Taken. '
//  dTakeAlr      ='You already have {the dobj/him}. '
//  dRemove  /*!*/=true // for non-clothing, acts like Take
//  dTakeFrom     =true // if successful, acts like Take
///*!!!!!!!!!!!!!*/dDrop         ='You drop the gun on the deck. ' // 
//  dDropAlr      ='You don<./s>t have {the dobj/him}. '
//  dPutIn        ='You put {the dobj/him} in {the iobj/him}. '
//  dPutInAlr     ='{The dobj/he} {is} already in {the iobj/him}. '
//  iPutIn        ='{You/he} can<./s>t put {the dobj/him} in {the iobj/him}. '
//  dPutOn        ='You put {the dobj/him} in {the iobj/him}. '
//  dPutOnAlr     ='{The dobj/he} {is} already on {the iobj/him}. '
//  iPutOn        ='There doesn<./s>t seem to be a suitable place to put {the dobj/him} on {the iobj/him}. '
//  dPutUnder     ='You put {the dobj/him} under {the iobj/him}. '
//  dPutUnderAlr  ='{The dobj/he} {is} already under {the iobj/him}. '
//  iPutUnder     ='{You/he} can<./s>t put {the dobj/him} under {the iobj/him}. '
//  dPutBehind    ='You put {the dobj/him} behind {the iobj/him}. '
//  dPutBehindAlr ='{The dobj/he} {is} already behind {the iobj/him}. '
//  iPutBehind    ='{You/he} can<./s>t put {the dobj/him} behind {the iobj/him}. '
//  dWear         ='You can<./s>t wear {the dobj/him}. '
//  dDoff         ='Please specify what you want to remove {the dobj/him} from. '
//  dKiss         ='Kissing {a dobj/him}, while it might satisfy some bizarre sexual urge, won<./s>t get you anywhere in this game. '
//  dAsk     /*!*/=true // asks for topic
//  dAskFor       ='You can<./s>t talk to {a dobj/him}. '
//  dAskAbout     ='You can<./s>t talk to {a dobj/him}. '
//  dTell    /*!*/=true // asks for topic
//  dTellAbout    ='You can<./s>t talk to {a dobj/him}. '
//  dTalkTo       ='You can<./s>t talk to {a dobj/him}. '
//  dGive    /*!*/=true // asks for iobj
//  dGiveTo       =true // no special action; handled by iGiveTo
//  iGiveTo       ='{The dobj/he} isn<./s>t likely to appreciate your offer. '
//  dShow    /*!*/=true // asks for iobj
//  dShowTo       =true // no special action; handled by iShowTo
//  iShowTo       ='{The dobj/he} doesn<./s>t appear to be interested in the slip of paper. '
//  dFollow       ='{You/he} can<./s>t follow {that dobj/him}. '
//  dHit          =true
//  dHitWith      =true
//  iHitWith      =true
//  dAttack       =true
//  dAttackWith   =true
//  iAttackWith   =true
//  dThrow   /*!*/=true // asks for iobj
//  dThrowAt      =true // calls processThrow method; or override this.
//  iThrowAt      =true // no action; anything can be a target
//  dThrowTo      =true // calls processThrow method; or override this.
//  //iThrowTo      ='{The iobj/he} do{es}n<./s>t look like {it/he} want{s} to catch anything. '
//  iobjFor(ThrowTo) asIobjFor(ThrowAt)
//  dDig     /*!*/=true // asks for iobj
//  dDigWith      ='{The dobj/he} is much too hard to dig up with {the iobj/him}. '
//  iDigWith      ='{The dobj/he} isn<./s>t suited for that kind of work. '
//  dJumpOver     ='You jump up and down a few times and then need to rest. '
//  dJumpOff      ='{You/he} can<./s>t jump off {that dobj/him}. '
//  dPush         ='Nothing happens. '
///*!!!!!!!!!!!!!*/  dPull         ='You try to give {the dobj/him} a tug, but nothing comes of it. '
//  //dMove         ='Moving {the dobj/him} has no effect. '
//  //dMoveWith     ='Moving {the dobj/him} has no effect. '
//  dobjFor(Move) asDobjFor(Take)
//  dobjFor(MoveWith) asDobjFor(Take)
//  iMoveWith     ='{The dobj/he} isn<./s>t suited for that kind of work. '
//  dMoveTo       ='You attempt to lead {the dobj/him} to {the iobj/him}, but {it dobj/him} do{es}n<./s>t seem to understand. '
//  iMoveTo       ='You attempt to lead {the dobj/him} to {the iobj/him}, but {it dobj/him} do{es}n<./s>t seem to understand. '
//  dTurn         ='You try to twist {the dobj/him} but nothing happens. '
//  dTurnWith     ='[Please say that another way, or try something else.] '
//  iTurnWith     ='[Please say that another way, or try something else.] '
//  dTurnTo       ='You try to twist {the dobj/him} but nothing happens. '
//  dConsult      ='You can<./s>t talk to {a dobj/him}. '
//  dConsultAbout ='You can<./s>t talk to {a dobj/him}. '
//  dSetTo        ='You try to twist {the dobj/him}, but nothing happens. '
//  dTypeOn       =nil
//  dTypeLiteralOn=nil
//  dEnterOn      ='[Please say that another way, or try something else.] '
//  dSwitch       ='You try to twist {the dobj/him} but nothing happens. '
//  dFlip         ='You try to twist {the dobj/him} but nothing happens. '
//  dTurnOn       ='You can<./s>t turn that on! '
//  dTurnOff      ='You can<./s>t turn off {a dobj/him}. '
//  dLight        ='{The dobj/he} {is}n<./s>t flammable. '
//  dStrike       =true // remapped to dHit
//  dBurn    /*!*/='{The dobj/he} {is}n<./s>t flammable. '
//  dBurnWith     ='You can<./s>t burn {the dobj/him} with {the iobj/him}. '
//  iBurnWith     ='You can<./s>t burn {the dobj/him} with {the iobj/him}. '
//  dExtinguish   ='You can<./s>t turn off {a dobj/him}. '
//  dAttach  /*!*/=true // asks for iobj
//  dAttachTo     ='{You/he} can<./s>t attach {a dobj/him} to {the iobj/him}. '
//  iAttachTo     ='{You/he} can<./s>t attach {a dobj/him} to {the iobj/him}. '
//  dobjFor(Detach) asDobjFor(Take)
///*!!!!!!!!!!!!!*/dobjFor(DetachFrom) asDobjFor(Take)
//  //dDetach       ='{You/he} cannot detach {that dobj/him}. '
//  //dDetachFrom   ='{You/he} cannot detach {that dobj/him}. '
//  iDetachFrom   ='{You/he} can<./s>t take anything from {that iobj/him}. '
//  dBreak        ='You bang on {the dobj/him}, but it just sits there. '
//  dCut     /*!*/=true // asks for iobj
//  dCutWith      ='You hack away at {the dobj/him} for a while, but you finally realize that {an iobj/him} makes a lousy knife. '
//  iCutWith      ='You hack away at {the dobj/him} for a while, but you finally realize that {an iobj/him} makes a lousy knife. '
//  dClimb        ='It would be too difficult to climb {the dobj/him}. '
//  dClimbUp      ='It would be too difficult to climb {the dobj/him}. '
//  dClimbDown    ='It would be too difficult to climb {the dobj/him}. '
//  dOpen         ='You can<./s>t open {a dobj/him}. '
//  dClose        ='You can<./s>t close {the dobj/him}. '
//  dLock         ='Why would you want to lock {the dobj/him}? '
//  dLockWith     ='Why would you want to lock {the dobj/him}? '
//  iLockWith     ='You can<./s>t lock anything with {an iobj/him}. '
//  dUnlock       ='{The dobj/he} {is}n<./s>t locked. '
//  dUnlockWith   ='{The dobj/he} {is}n<./s>t locked. '
//  iUnlockWith   ='You can<./s>t unlock anything with {an iobj/him}. '
//  dEat          ='{The dobj/he} doesn<./s>t look very appetizing. '
//  dDrink        ='You must be getting pretty desperate if you<./s>re trying to drink {a dobj/him}. '
//  dPour         ='You can<./s>t pour {the dobj/him}. '
//  dPourInto     ='You can<./s>t pour {the dobj/him}. '
//  iPourInto     ='{You/he} can<./s>t pour anything into {that dobj/him}. '
//  dPourOnto     ='You can<./s>t pour {the dobj/him}. '
//  iPourOnto     ='{You/he} can<./s>t pour anything onto {that dobj/him}. '
//  dClean        ='You can<./s>t clean {a dobj/him}. '
//  dCleanWith    ='You can<./s>t clean {a dobj/him} with {the iobj/him}. '
//  iCleanWith    ='You can<./s>t clean {a dobj/him} with {the iobj/him}. '
//  dSitOn        ='This is no time for resting. '
//  dLieOn        ='You can<./s>t get on {the dobj/him}. '
//  dStandOn      ='You can<./s>t get on {the dobj/him}. '
//  dBoard        ='{You/he} can<./s>t enter {the dobj/him}. '
//  dGetOutOf     ='You<./s>re not in {the dobj/him}. '
//  dGetOffOf     ='You<./s>re not on {the dobj/him}. '
//  dFasten       ='{You/he} can<./s>t attach {the dobj/him}. '
//  dFastenTo     ='You can<./s>t attach {a dobj/him} to {the iobj/him}. '
//  iFastenTo     ='You can<./s>t attach {a dobj/him} to {the iobj/him}. '
//  dUnfasten     =nil
//  dUnfastenFrom =nil
//  iUnfastenFrom =nil
//  dPlugIn       ='[Please say that another way, or try something else.] '
//  dPlugInto     ='[Please say that another way, or try something else.] '
//  iPlugInto     ='[Please say that another way, or try something else.] '
//  dUnplug       ='[Please say that another way, or try something else.] '
//  dUnplugFrom   ='[Please say that another way, or try something else.] '
//  iUnplugFrom   ='[Please say that another way, or try something else.] '
//  dScrew        ='{The dobj/he} can<./s>t be screwed. '
//  dScrewWith    ='[Please say that another way, or try something else.] '
//  iScrewWith    ='[Please say that another way, or try something else.] '
//  dUnscrew      ='{The dobj/he} can<./s>t be unscrewed. '
//  dUnscrewWith  ='{The dobj/he} can<./s>t be unscrewed with {the iobj/him}. '
//  iUnscrewWith  ='{The dobj/he} can<./s>t be unscrewed with {the iobj/him}. '
//  dGoThrough    ='You can<./s>t enter {the dobj/him}. '
//  dEnter        ='You can<./s>t enter {the dobj/him}. '
//  dPushTravel   ='[Please say that another way, or try something else.] '
//  dShoot        =true // asks for iobj (if not a weapon)
//  dShootAimless =true // '{You/he} cannot shoot anything with that. '
//  dShootWith    =true // nothing special; handled by iShootWith
//  iShootWith    =true // '{You/he} cannot shoot anything with that. '
//  // miscellaneous behavior
//;

//pbTripod: Artifact
//  doNotMoveArtifact = true
//  // Not counted as vocabulary in the original game: weapon, tool, grip
//  vocabWords='(gateway) (2) (two) (particle) (beam) (particle-beam) (gun) -'
//  name      ='particle gun'
//  location  =whitePed
//  isListed = nil
//  isListedInContents = nil
//  isListedInInventory = nil
//  artHtml1  ='<.gateway>'
//  artHtml2  ='<./gateway>'
//  artDesc = "You see nothing special about <<theName>>. "
//  // parsing stuff
//  parseFailMsg = '[You don<./s>t need to use the word <.q>' + 
//                   glob.latestVerb + '<./q> when referring to the ' +
//                   name + '.] '
//  objParseList = []
//  // "d" and "i" methods
//  dExamine      =true // shows desc
//  dRead         ='You can<./s>t read {a dobj/him}! '
//  dLookIn       ='How can you do that? '
//  //dSearch       =true // acts exactly like LookIn
//  dobjFor(Search) asDobjFor(Examine)
//  dLookUnder    ='You discover nothing of interest. '
//  dLookBehind   ='You discover nothing of interest. '
//  dLookThrough  ='How can you do that? '
//  dListenTo     ='You don<./s>t hear anything very interesting right now. '
//  dSmell        ='You inhale deeply, attempting to get a good whiff of {the dobj/him}. It doesn<./s>t seem to have much of an odor. '
//  dTaste        ='{The dobj/he} doesn<./s>t look very appetizing. '
//  dFeel         ='You run your fingers over {the dobj/him} and feel nothing unusual. '
///*!!!!!!!!!!!!!*/dTake         ='Taken. '
//  dTakeAlr      ='You already have {the dobj/him}. '
//  dRemove  /*!*/=true // for non-clothing, acts like Take
//  dTakeFrom     =true // if successful, acts like Take
///*!!!!!!!!!!!!!*/dDrop         ='You drop the gun on the deck. ' // 
//  dDropAlr      ='You don<./s>t have {the dobj/him}. '
//  dPutIn        ='You put {the dobj/him} in {the iobj/him}. '
//  dPutInAlr     ='{The dobj/he} {is} already in {the iobj/him}. '
//  iPutIn        ='{You/he} can<./s>t put {the dobj/him} in {the iobj/him}. '
//  dPutOn        ='You put {the dobj/him} in {the iobj/him}. '
//  dPutOnAlr     ='{The dobj/he} {is} already on {the iobj/him}. '
//  iPutOn        ='There doesn<./s>t seem to be a suitable place to put {the dobj/him} on {the iobj/him}. '
//  dPutUnder     ='You put {the dobj/him} under {the iobj/him}. '
//  dPutUnderAlr  ='{The dobj/he} {is} already under {the iobj/him}. '
//  iPutUnder     ='{You/he} can<./s>t put {the dobj/him} under {the iobj/him}. '
//  dPutBehind    ='You put {the dobj/him} behind {the iobj/him}. '
//  dPutBehindAlr ='{The dobj/he} {is} already behind {the iobj/him}. '
//  iPutBehind    ='{You/he} can<./s>t put {the dobj/him} behind {the iobj/him}. '
//  dWear         ='You can<./s>t wear {the dobj/him}. '
//  dDoff         ='Please specify what you want to remove {the dobj/him} from. '
//  dKiss         ='Kissing {a dobj/him}, while it might satisfy some bizarre sexual urge, won<./s>t get you anywhere in this game. '
//  dAsk     /*!*/=true // asks for topic
//  dAskFor       ='You can<./s>t talk to {a dobj/him}. '
//  dAskAbout     ='You can<./s>t talk to {a dobj/him}. '
//  dTell    /*!*/=true // asks for topic
//  dTellAbout    ='You can<./s>t talk to {a dobj/him}. '
//  dTalkTo       ='You can<./s>t talk to {a dobj/him}. '
//  dGive    /*!*/=true // asks for iobj
//  dGiveTo       =true // no special action; handled by iGiveTo
//  iGiveTo       ='{The dobj/he} isn<./s>t likely to appreciate your offer. '
//  dShow    /*!*/=true // asks for iobj
//  dShowTo       =true // no special action; handled by iShowTo
//  iShowTo       ='{The dobj/he} doesn<./s>t appear to be interested in the slip of paper. '
//  dFollow       ='{You/he} can<./s>t follow {that dobj/him}. '
//  dHit          =true
//  dHitWith      =true
//  iHitWith      =true
//  dAttack       =true
//  dAttackWith   =true
//  iAttackWith   =true
//  dThrow   /*!*/=true // asks for iobj
//  dThrowAt      =true // calls processThrow method; or override this.
//  iThrowAt      =true // no action; anything can be a target
//  dThrowTo      =true // calls processThrow method; or override this.
//  //iThrowTo      ='{The iobj/he} do{es}n<./s>t look like {it/he} want{s} to catch anything. '
//  iobjFor(ThrowTo) asIobjFor(ThrowAt)
//  dDig     /*!*/=true // asks for iobj
//  dDigWith      ='{The dobj/he} is much too hard to dig up with {the iobj/him}. '
//  iDigWith      ='{The dobj/he} isn<./s>t suited for that kind of work. '
//  dJumpOver     ='You jump up and down a few times and then need to rest. '
//  dJumpOff      ='{You/he} can<./s>t jump off {that dobj/him}. '
//  dPush         ='Nothing happens. '
///*!!!!!!!!!!!!!*/  dPull         ='You try to give {the dobj/him} a tug, but nothing comes of it. '
//  //dMove         ='Moving {the dobj/him} has no effect. '
//  //dMoveWith     ='Moving {the dobj/him} has no effect. '
//  dobjFor(Move) asDobjFor(Take)
//  dobjFor(MoveWith) asDobjFor(Take)
//  iMoveWith     ='{The dobj/he} isn<./s>t suited for that kind of work. '
//  dMoveTo       ='You attempt to lead {the dobj/him} to {the iobj/him}, but {it dobj/him} do{es}n<./s>t seem to understand. '
//  iMoveTo       ='You attempt to lead {the dobj/him} to {the iobj/him}, but {it dobj/him} do{es}n<./s>t seem to understand. '
//  dTurn         ='You try to twist {the dobj/him}, but nothing happens. '
//  dTurnWith     ='[Please say that another way, or try something else.] '
//  iTurnWith     ='[Please say that another way, or try something else.] '
//  dTurnTo       ='You try to twist {the dobj/him}, but nothing happens. '
//  dConsult      ='You can<./s>t talk to {a dobj/him}. '
//  dConsultAbout ='You can<./s>t talk to {a dobj/him}. '
//  dSetTo        ='You try to twist {the dobj/him}, but nothing happens. '
//  dTypeOn       =nil
//  dTypeLiteralOn=nil
//  dEnterOn      ='[Please say that another way, or try something else.] '
//  dSwitch       ='You try to twist {the dobj/him}, but nothing happens. '
//  dFlip         ='You try to twist {the dobj/him}, but nothing happens. '
//  dTurnOn       ='You can<./s>t turn that on! '
//  dTurnOff      ='You can<./s>t turn off {a dobj/him}. '
//  dLight        ='{The dobj/he} {is}n<./s>t flammable. '
//  dStrike       =true // remapped to dHit
//  dBurn    /*!*/='{The dobj/he} {is}n<./s>t flammable. '
//  dBurnWith     ='You can<./s>t burn {the dobj/him} with {the iobj/him}. '
//  iBurnWith     ='You can<./s>t burn {the dobj/him} with {the iobj/him}. '
//  dExtinguish   ='You can<./s>t turn off {a dobj/him}. '
//  dAttach  /*!*/=true // asks for iobj
//  dAttachTo     ='{You/he} can<./s>t attach {a dobj/him} to {the iobj/him}. '
//  iAttachTo     ='{You/he} can<./s>t attach {a dobj/him} to {the iobj/him}. '
//  dobjFor(Detach) asDobjFor(Take)
///*!!!!!!!!!!!!!*/dobjFor(DetachFrom) asDobjFor(Take)
//  //dDetach       ='{You/he} cannot detach {that dobj/him}. '
//  //dDetachFrom   ='{You/he} cannot detach {that dobj/him}. '
//  iDetachFrom   ='{You/he} can<./s>t take anything from {that iobj/him}. '
//  dBreak        ='You bang on {the dobj/him}, but it just sits there. '
//  dCut     /*!*/=true // asks for iobj
//  dCutWith      ='You hack away at {the dobj/him} for a while, but you finally realize that {an iobj/him} makes a lousy knife. '
//  iCutWith      ='You hack away at {the dobj/him} for a while, but you finally realize that {an iobj/him} makes a lousy knife. '
//  dClimb        ='It would be too difficult to climb {the dobj/him}. '
//  dClimbUp      ='It would be too difficult to climb {the dobj/him}. '
//  dClimbDown    ='It would be too difficult to climb {the dobj/him}. '
//  dOpen         ='You can<./s>t open {a dobj/him}. '
//  dClose        ='You can<./s>t close {the dobj/him}. '
//  dLock         ='Why would you want to lock {the dobj/him}? '
//  dLockWith     ='Why would you want to lock {the dobj/him}? '
//  iLockWith     ='You can<./s>t lock anything with {an iobj/him}. '
//  dUnlock       ='{The dobj/he} {is}n<./s>t locked. '
//  dUnlockWith   ='{The dobj/he} {is}n<./s>t locked. '
//  iUnlockWith   ='You can<./s>t unlock anything with {an iobj/him}. '
//  dEat          ='{The dobj/he} doesn<./s>t look very appetizing. '
//  dDrink        ='You must be getting pretty desperate if you<./s>re trying to drink {a dobj/him}. '
//  dPour         ='You can<./s>t pour {the dobj/him}. '
//  dPourInto     ='You can<./s>t pour {the dobj/him}. '
//  iPourInto     ='{You/he} can<./s>t pour anything into {that dobj/him}. '
//  dPourOnto     ='You can<./s>t pour {the dobj/him}. '
//  iPourOnto     ='{You/he} can<./s>t pour anything onto {that dobj/him}. '
//  dClean        ='You can<./s>t clean {a dobj/him}. '
//  dCleanWith    ='You can<./s>t clean {a dobj/him} with {the iobj/him}. '
//  iCleanWith    ='You can<./s>t clean {a dobj/him} with {the iobj/him}. '
//  dSitOn        ='This is no time for resting. '
//  dLieOn        ='You can<./s>t get on {the dobj/him}. '
//  dStandOn      ='You can<./s>t get on {the dobj/him}. '
//  dBoard        ='{You/he} can<./s>t enter {the dobj/him}. '
//  dGetOutOf     ='You<./s>re not in {the dobj/him}. '
//  dGetOffOf     ='You<./s>re not on {the dobj/him}. '
//  dFasten       ='{You/he} can<./s>t attach {the dobj/him}. '
//  dFastenTo     ='You can<./s>t attach {a dobj/him} to {the iobj/him}. '
//  iFastenTo     ='You can<./s>t attach {a dobj/him} to {the iobj/him}. '
//  dUnfasten     =nil
//  dUnfastenFrom =nil
//  iUnfastenFrom =nil
//  dPlugIn       ='[Please say that another way, or try something else.] '
//  dPlugInto     ='[Please say that another way, or try something else.] '
//  iPlugInto     ='[Please say that another way, or try something else.] '
//  dUnplug       ='[Please say that another way, or try something else.] '
//  dUnplugFrom   ='[Please say that another way, or try something else.] '
//  iUnplugFrom   ='[Please say that another way, or try something else.] '
//  dScrew        ='{The dobj/he} can<./s>t be screwed. '
//  dScrewWith    ='[Please say that another way, or try something else.] '
//  iScrewWith    ='[Please say that another way, or try something else.] '
//  dUnscrew      ='{The dobj/he} can<./s>t be unscrewed. '
//  dUnscrewWith  ='{The dobj/he} can<./s>t be unscrewed with {the iobj/him}. '
//  iUnscrewWith  ='{The dobj/he} can<./s>t be unscrewed with {the iobj/him}. '
//  dGoThrough    ='You can<./s>t enter {the dobj/him}. '
//  dEnter        ='You can<./s>t enter {the dobj/him}. '
//  dPushTravel   ='[Please say that another way, or try something else.] '
//  dShoot        =true // asks for iobj (if not a weapon)
//  dShootAimless =true // '{You/he} cannot shoot anything with that. '
//  dShootWith    =true // nothing special; handled by iShootWith
//  iShootWith    =true // '{You/he} cannot shoot anything with that. '
//  // miscellaneous behavior
//;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: xenite
// -------------------------------------------------------------------

xenite: Artifact
  vocabWords='metallic metal/xenite/hunk/chunk/zenite/zeenite/rock/stone/artifact*artifacts'
  name      ='chunk of xenite'
  wordName  ='xenite'
  nickname  ='xenite'
  artTitle  ='Deep Space Drifter'
  artAuthor ='Michael J. Roberts and Steve McAdams'
  artCompany=''
  artComp   =''
  artYear   ='1988'
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.deep>'
  artHtml2  ='<./deep>'
  artDesc   ="Xenite is a metallic substance; this is a good-sized chunk of the material. "
  //desc = "Light catches this crystal in a beautifully irregular manner. "
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  attributionForCredits {
    return simpleAttribution.findReplace(' and', '[*] and', ReplaceAll)
      //+ (permissionObtained ? '[*]' : '')
      + ((artCompany != nil && artCompany != '') ? ' (' + artCompany + ')' : '');
  }
  // Mike Roberts said I could copy his object's messages.
  permissionObtained = true
  // parsing stuff
  parseFailMsg = 'I don<./s>t know the word <.q>' + glob.latestVerb + '<./q>. '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         ='I don<./s>t know how to read a chunk of xenite. '
  dLookIn       ='There<./s>s nothing in the chunk of xenite. '
  dSearch       ='You find nothing of interest. '
  dLookUnder    ='There<./s>s nothing under the chunk of xenite. '
  dLookBehind   ='There<./s>s nothing behind the chunk of xenite. '
  dLookThrough  ='You can<./s>t see anything through the chunk of xenite. '
  dListenTo     =nil
  dSmell        =nil
  dTaste        =nil
  dFeel         ='Touching the chunk of xenite doesn<./s>t seem to have any effect. '
  dTake         ='Taken. '
  dTakeAlr      ='You already have the chunk of xenite! '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Dropped. '
  dDropAlr      ='You<./s>re not carrying the chunk of xenite! '
  dPutIn        ='Done. '
  dPutInAlr     ='The chunk of xenite is already in {the iobj/him}! '
  iPutIn        ='You can<./s>t put anything into the chunk of xenite. '
  dPutOn        ='Done. '
  dPutOnAlr     ='The chunk of xenite is already on {the iobj/him}! '
  iPutOn        ='There<./s>s no good surface on the chunk of xenite. '
  dPutUnder     ='Done. '
  dPutUnderAlr  ='The chunk of xenite is already under {the iobj/him}! '
  iPutUnder     ='I don<./s>t recognize that sentence. '
  dPutBehind    ='Done. '
  dPutBehindAlr ='The chunk of xenite is already behind {the iobj/him}! '
  iPutBehind    ='I don<./s>t recognize that sentence. '
  dWear         ='You can<./s>t wear the chunk of xenite. '
  dDoff         ='You<./s>re not wearing the chunk of xenite! '
  dKiss         =nil
  dAsk     /*!*/=true // asks for topic
  dAskFor       ='Surely, you can<./s>t think the chunk of xenite knows anything about it! '
  dAskAbout     ='Surely, you can<./s>t think the chunk of xenite knows anything about it! '
  dTell    /*!*/=true // asks for topic
  dTellAbout    ='It doesn<./s>t look as though the chunk of xenite is interested. '
  dTalkTo       =nil
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='I don<./s>t know how to give anything to the chunk of xenite. '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='The chunk of xenite isn<./s>t impressed. '
  dFollow       =nil
  dHit          ='Attacking the chunk of xenite doesn<./s>t appear productive. '
  dHitWith      ='Attacking the chunk of xenite doesn<./s>t appear productive. '
  iHitWith      ='I don<./s>t know how to attack anything with the chunk of xenite. '
  dAttack       ='Attacking the chunk of xenite doesn<./s>t appear productive. '
  dAttackWith   ='Attacking the chunk of xenite doesn<./s>t appear productive. '
  iAttackWith   ='I don<./s>t know how to attack anything with the chunk of xenite. '
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='I don<./s>t know how to throw anything to the chunk of xenite. '
  dDig     /*!*/=true // asks for iobj
  dDigWith      ='I don<./s>t know how to dig in the chunk of xenite. '
  iDigWith      ='I don<./s>t know how to dig in anything with the chunk of xenite. '
  dJumpOver     ='I don<./s>t know how to jump the chunk of xenite. '
  dJumpOff      ='I don<./s>t know how to jump the chunk of xenite. '
  dPush         ='Pushing the chunk of xenite doesn<./s>t do anything. '
  dPull         ='Pulling the chunk of xenite doesn<./s>t have any effect. '
  dMove         ='Moving the chunk of xenite doesn<./s>t reveal anything. '
  dMoveWith     ='Moving the chunk of xenite doesn<./s>t reveal anything. '
  iMoveWith     ='I don<./s>t know how to move anything with the chunk of xenite. '
  dMoveTo       ='Moving the chunk of xenite doesn<./s>t reveal anything. '
  iMoveTo       =true // does nothing
  dTurn         ='Turning the chunk of xenite doesn<./s>t have any effect. '
  dTurnWith     ='Turning the chunk of xenite doesn<./s>t have any effect. '
  iTurnWith     ='I don<./s>t know how to turn anything with the chunk of xenite. '
  dTurnTo       ='Turning the chunk of xenite doesn<./s>t have any effect. '
  dConsult      =nil
  dConsultAbout =nil
  dSetTo        =nil
  dTypeOn       ='I don<./s>t know how to type anything on the chunk of xenite. '
  dTypeLiteralOn='I don<./s>t know how to type anything on the chunk of xenite. '
  dEnterOn      ='I don<./s>t know how to enter the chunk of xenite. '
  dSwitch       ='I don<./s>t know how to switch the chunk of xenite. '
  dFlip         ='I don<./s>t know how to flip the chunk of xenite. '
  dTurnOn       ='I don<./s>t know how to turn the chunk of xenite on. '
  dTurnOff      ='I don<./s>t know how to turn the chunk of xenite off. '
  dLight        ='There<./s>s no verb in that sentence! '
  dStrike       =nil
  dBurn    /*!*/=nil
  dBurnWith     =nil
  iBurnWith     =nil
  dExtinguish   ='I don<./s>t know how to extinguish the chunk of xenite. '
  dAttach  /*!*/=true // asks for iobj
  dAttachTo     ='There<./s>s no obvious way to do that. '
  iAttachTo     ='There<./s>s no obvious way to do that. '
  dDetach       ='There<./s>s no obvious way to do that. '
  dDetachFrom   ='There<./s>s no obvious way to do that. '
  iDetachFrom   ='There<./s>s no obvious way to do that. '
  dBreak        ='You<./s>ll have to tell me how to do that. '
  dCut     /*!*/=nil
  dCutWith      =nil
  iCutWith      =nil
  dClimb        ='I don<./s>t know how to climb the chunk of xenite. '
  dClimbUp      ='I don<./s>t know how to climb up the chunk of xenite. '
  dClimbDown    ='I don<./s>t know how to climb down the chunk of xenite. '
  dOpen         ='I don<./s>t know how to open the chunk of xenite. '
  dClose        ='I don<./s>t know how to close the chunk of xenite. '
  dLock         ='I don<./s>t know how to lock the chunk of xenite. '
  dLockWith     ='I don<./s>t know how to lock the chunk of xenite. '
  iLockWith     ='I don<./s>t know how to lock anything with the chunk of xenite. '
  dUnlock       ='I don<./s>t know how to unlock the chunk of xenite. '
  dUnlockWith   ='I don<./s>t know how to unlock the chunk of xenite. '
  iUnlockWith   ='I don<./s>t know how to unlock anything with the chunk of xenite. '
  dEat          ='The chunk of xenite doesn<./s>t appear appetizing. '
  dDrink        ='The chunk of xenite doesn<./s>t appear appetizing. '
  dPour         =nil
  dPourInto     =nil
  iPourInto     =nil
  dPourOnto     =nil
  iPourOnto     =nil
  dClean        ='The chunk of xenite looks a bit cleaner now. '
  dCleanWith    ='The chunk of xenite looks a bit cleaner now. '
  iCleanWith    ='I don<./s>t know how to clean anything with the chunk of xenite. '
  dSitOn        ='I don<./s>t know how to sit on the chunk of xenite. '
  dLieOn        ='I don<./s>t know how to lie on the chunk of xenite. '
  dStandOn      ='I don<./s>t know how to stand on the chunk of xenite. '
  dBoard        ='I don<./s>t know how to get on the chunk of xenite. '
  dGetOutOf     ='You<./s>re not on the chunk of xenite! '
  dGetOffOf     ='You<./s>re not on the chunk of xenite! '
  dFasten       ='I don<./s>t know how to fasten the chunk of xenite. '
  dFastenTo     ='I don<./s>t recognize that sentence. '
  iFastenTo     ='I don<./s>t recognize that sentence. '
  dUnfasten     ='I don<./s>t know how to fasten the chunk of xenite. '
  dUnfastenFrom ='I don<./s>t recognize that sentence. '
  iUnfastenFrom ='I don<./s>t recognize that sentence. '
  dPlugIn       ='You can<./s>t plug the chunk of xenite into anything. '
  dPlugInto     ='You can<./s>t plug the chunk of xenite into anything. '
  iPlugInto     ='You can<./s>t plug anything into the chunk of xenite. '
  dUnplug       ='I don<./s>t know how to unplug the chunk of xenite. '
  dUnplugFrom   ='I don<./s>t know how to unplug the chunk of xenite. '
  iUnplugFrom   ='I don<./s>t know how to unplug anything from the chunk of xenite. '
  dScrew        ='You see no way to do that. '
  dScrewWith    ='You see no way to do that. '
  iScrewWith    ='You see no way to do that. '
  dUnscrew      ='You see no way to do that. '
  dUnscrewWith  ='You see no way to do that. '
  iUnscrewWith  ='You see no way to do that. '
  dGoThrough    ='I don<./s>t know how to go through the chunk of xenite. '
  dEnter        ='I don<./s>t know how to enter the chunk of xenite. '
  dPushTravel   ='There are words after your command I couldn<./s>t use. '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless ='I don<./s>t know how to fire the chunk of xenite. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    ='I don<./s>t know how to fire the chunk of xenite. '
  // miscellaneous behavior
  zapT = transform(self, xenie)
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: ary ung classes and objects
// -------------------------------------------------------------------

class BaggettObject: object
  artDesc = "The <<name>> is a black pistol-shaped implement 
              that fits snugly in your hand. It has an almost
              unnoticeable red trigger. "
  // parsing stuff
  parseFailMsg = 'I don<./s>t know the word <.q>' + glob.latestVerb + '<./q>. '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         ='The '+name+' doesn<./s>t have any text on it. '
  dLookIn       ='You have no way of looking inside the '+name+'. '
  dobjFor(Search) asDobjFor(Examine)
  //dSearch       =true // acts exactly like LookIn
  dLookUnder    ='Trying to look under the '+name+' doesn<./s>t gain you anything. '
  dLookBehind   ='Trying to look behind the '+name+' doesn<./s>t gain you anything. '
  dLookThrough  ='You can<./s>t look through the '+name+'. '
  dListenTo     ='The '+name+' isn<./s>t making any noise. '
  dSmell        ='It smells like an ordinary '+name+'. '
  dTaste        ='The '+name+' tastes normal. '
  dFeel         ='The '+name+' doesn<./s>t feel unusual. '
  dTake         ='Taken. '
  dTakeAlr      ='You already have {the dobj/him}. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Done. '
  dDropAlr      ='You don<./s>t have {the dobj/him}. '
  dPutIn        ='Done. '
  dPutInAlr     ='{The dobj/he} {is} already in {the iobj/him}. '
  iPutIn        ='{You/he} can<./s>t put anything in {the iobj/him}. '
  dPutOn        ='Done. '
  dPutOnAlr     ='{The dobj/he} {is} already on {the iobj/him}. '
  iPutOn        ='You can<./s>t put anything on {the iobj/him}. '
  dPutUnder     ='Done. '
  dPutUnderAlr  ='{The dobj/he} {is} already under {the iobj/him}. '
  iPutUnder     ='{You/he} can<./s>t put anything under {the iobj/him}. '
  dPutBehind    ='Done. '
  dPutBehindAlr ='{The dobj/he} {is} already behind {the iobj/him}. '
  iPutBehind    ='{You/he} can<./s>t put anything behind {the iobj/him}. '
  dWear         ='You can<./s>t wear the '+name+'. '
  dDoff         ='You aren<./s>t wearing the '+name+'. '
  dKiss         =nil
  dAsk     /*!*/=nil
  dAskFor       ='You can<./s>t do that, because it can<./s>t hear you. '
  dAskAbout     ='You can<./s>t do that, because it can<./s>t hear you. '
  dTell    /*!*/=true // asks for topic
  dTellAbout    ='You can<./s>t do that, because it can<./s>t hear you. '
  dTalkTo       =nil
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='You can<./s>t do that, because you can<./s>t put anything the '+name+'. ' // sic; this is one bad mistake
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='You can<./s>t show things to the '+name+'. '
  dFollow       ='You can<./s>t follow the '+name+'. '
  dHit          ='There<./s>s no reason to get huffy! '
  dHitWith      ='There<./s>s no reason to get huffy! '
  iHitWith      =true
  dAttack       ='There<./s>s no reason to get huffy! '
  dAttackWith   ='There<./s>s no reason to get huffy! '
  iAttackWith   =true
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='You can<./s>t throw things to the '+name+'. '
  dDig     /*!*/=true // asks for iobj
  dDigWith      ='You can<./s>t dig in the '+name+'. '
  iDigWith      ='You can<./s>t dig in anything with the '+name+'. '
  dJumpOver     ='I don<./s>t recognize that sentence. '
  dJumpOff      ='I don<./s>t recognize that sentence. '
  dPush         ='Pushing the '+name+' doesn<./s>t seem to have much effect. '
  dPull         ='Pulling on the '+name+' doesn<./s>t seem to have much effect. '
  dMove         ='You can<./s>t move the '+name+'. '
  dMoveWith     ='You can<./s>t move the '+name+'. '
  iMoveWith     ='You can<./s>t move anything with the '+name+'. '
  dMoveTo       ='I don<./s>t recognize that sentence. '
  iMoveTo       =true // does nothing
  dTurn         ='You can<./s>t turn the '+name+'. '
  dTurnWith     ='I don<./s>t recognize that sentence. '
  iTurnWith     ='I don<./s>t recognize that sentence. '
  dTurnTo       ='You can<./s>t turn the '+name+' to anything. '
  dConsult      =nil
  dConsultAbout =nil
  dSetTo        ='You can<./s>t turn the '+name+' to anything. '
  dTypeOn       ='You can<./s>t type anything on the '+name+'. '
  dTypeLiteralOn='You can<./s>t type anything on the '+name+'. '
  dEnterOn      ='I don<./s>t recognize that sentence. '
  dSwitch       ='You can<./s>t switch the '+name+'. '
  dFlip         ='You can<./s>t flip the '+name+'. '
  dTurnOn       ='You can<./s>t turn on the '+name+'. '
  dTurnOff      ='You can<./s>t turn off the '+name+'. '
  dLight        ='I don<./s>t know how to light the '+name+'. '
  dStrike       =nil
  dBurn    /*!*/=nil
  dBurnWith     =nil
  iBurnWith     =nil
  dExtinguish   ='You can<./s>t extinguish the '+name+'. '
  dAttach  /*!*/=true // asks for iobj
  dAttachTo     ='You can<./s>t attach the '+name+' to anything. '
  iAttachTo     ='You can<./s>t attach anything to the '+name+'. '
  dDetach       ='You can<./s>t detach the '+name+'. '
  dDetachFrom   ='You can<./s>t detach the '+name+'. '
  iDetachFrom   ='You can<./s>t detach anything from the '+name+'. '
  dBreak        ='I see no obvious way to do that. '
  dCut     /*!*/=true // asks for iobj
  dCutWith      ='You can<./s>t cut the '+name+'. '
  iCutWith      ='You can<./s>t cut anything with the '+name+'. '
  dClimb        ='You can<./s>t climb the '+name+'. '
  dClimbUp      ='You can<./s>t climb the '+name+'. '
  dClimbDown    ='I don<./s>t recognize that sentence. '
  dOpen         ='You can<./s>t open the '+name+'. '
  dClose        ='You can<./s>t close the '+name+'. '
  dLock         ='You can<./s>t lock the '+name+'. '
  dLockWith     ='You can<./s>t lock the '+name+'. '
  iLockWith     ='You can<./s>t lock anything with the '+name+'. '
  dUnlock       ='You can<./s>t unlock the '+name+'. '
  dUnlockWith   ='You can<./s>t unlock the '+name+'. '
  iUnlockWith   ='You can<./s>t unlock anything with the '+name+'. '
  dEat          ='Now why would you want to eat the '+name+'? '
  dDrink        ='You can<./s>t drink the '+name+'. '
  dPour         ='The '+name+' is going to have to undergo a major state change first. '
  dPourInto     ='The '+name+' is going to have to undergo a major state change first. '
  iPourInto     ='I don<./s>t recognize that sentence. '
  dPourOnto     ='The '+name+' is going to have to undergo a major state change first. '
  iPourOnto     =true
  dClean        ='Your efforts to clean the '+name+' have little effect. '
  dCleanWith    ='Your efforts to clean the '+name+' have little effect. '
  iCleanWith    ='Your efforts to clean {the dobj/him} have little effect. '
  dSitOn        ='You can<./s>t sit on the '+name+'. '
  dLieOn        ='You can<./s>t lie on the '+name+'. '
  dStandOn      ='You can<./s>t get on the '+name+'. '
  dBoard        ='You can<./s>t board the '+name+'. '
  dGetOutOf     ='You can<./s>t get out of the '+name+'. '
  dGetOffOf     ='You can<./s>t get off of the '+name+'. '
  dFasten       ='You can<./s>t fasten the '+name+'. '
  dFastenTo     ='I don<./s>t recognize that sentence. '
  iFastenTo     ='I don<./s>t recognize that sentence. '
  dUnfasten     ='You can<./s>t unfasten the '+name+'. '
  dUnfastenFrom ='I don<./s>t recognize that sentence. '
  iUnfastenFrom ='I don<./s>t recognize that sentence. '
  dPlugIn       ='You can<./s>t plug the '+name+' into anything. '
  dPlugInto     ='You can<./s>t plug the '+name+' into anything. '
  iPlugInto     ='You can<./s>t plug anything into the '+name+'. '
  dUnplug       ='You can<./s>t unplug the '+name+'. '
  dUnplugFrom   ='You can<./s>t unplug the '+name+'. '
  iUnplugFrom   ='You can<./s>t unplug anything from the '+name+'. '
  dScrew        ='You can<./s>t screw the '+name+'. '
  dScrewWith    ='You can<./s>t screw the '+name+'. '
  iScrewWith    ='You can<./s>t screw anything with the '+name+'. '
  dUnscrew      ='You can<./s>t unscrew the '+name+'. '
  dUnscrewWith  ='You can<./s>t unscrew the '+name+'. '
  iUnscrewWith  ='You can<./s>t unscrew anything with the '+name+'. '
  dGoThrough    ='I don<./s>t understand that sentence. '
  dEnter        ='You can<./s>t enter the '+name+'. '
  dPushTravel   ='You can<./s>t move the '+name+'. '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // misc. behavior
  canFireAimlessly = nil
  defaultShootResult = nil
  specifyTargetMsg =
    'You<./s>ll have to be more specific about your target. '
  shootThingMsg(obj) {
    gMessageParams(obj);
    return '{The obj/he} seem{s} unaffected. ';
  }
  //shootEffectMe {
  //  sayForArt(actorShootingHimselfMsg);
  //  if (shootingOneselfWithThisIsDeadly)
  //    endGame(ftDeath);
  //}
  //shootEffectThing {
  //  sayForArt(shootPrefixMsg(gDobj, true));
  //  sayForArt(shootThingMsg(gDobj));
  //  doShootResult(gDobj, defaultShootResult);
  //}
  //shootEffectMe { shootEffectThing; }
  shootFriendMsg =
    'The beam just misses {the dobj/him} and hits 
      the walls. The walls seem unaffected. '
  gunShootingItselfMsg =
    'You can<./s>t fire {the iobj/him} at itself. '
  actorShootingHimselfMsg =
    (shootPrefixMsg(gDobj, nil) + artHtml2 + shootThingMsg(gActor) + artHtml1)
  letsActorShootHimself = true
  shootingOneselfWithThisIsDeadly = nil
;

aryUng: BaggettObject, ArtifactGun
  vocabWords='ary ung/gun/firearm/weapon/trigger/artifact*guns*firearms*weapons*triggers*artifacts'
  name      ='ary ung'
  nickname  ='ary ung'
  artTitle  ='The Legend Lives!'
  artAuthor ='David M. Baggett'
  // Definitely 1995, not 1994. My sources:
  // http://groups.google.com/group/rec.games.int-fiction/browse_frm/thread/f8e9dc5943c84d84/
  // http://brasslantern.org/community/history/timeline-c.html
  artYear   ='1995'
  artCompany='Adventions'
  artComp   ='Adventions'
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.legend>'
  artHtml2  ='<./legend>'
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  shootEffectThing {
    sayForArt(shootPrefixMsg(gDobj, true));
    //sayForArt(shootThingMsg(gDobj));
    doShootResult(gDobj, defaultShootResult);
  }
  shootPrefixMsg(obj, complex) {
    return
      '&lt;GRAAAMN!&gt; A bolt of light shoots out of the ary ung'
      + throughMsg(' and passes through the ','',obj, complex) + '. ';
  }
  //actorShootingHimselfMsg =
  //  (shootPrefixMsg(gDobj, nil) + 'You briefly experience delusions of grandeur. ')
  shootEffectMirror {
    // If the gun shoots bullets, treat the mirror as any ordinary
    // thing.
    if (tangibleProjectiles) {
      shootEffectThing;
    }
    // Otherwise, if the gun's projectiles are more laser-like than
    // bullet-like, treat the mirror as a reflective object that
    // will cause the gun to shoot itself.
    else {
      sayForArt(shootPrefixMsg(gDobj, nil));
      sayForArt(mirrorBounceMsg);
//      // Note that the argument for shootThingMsg is self, i.e. gIobj,
//      // rather than gDobj, because the gun is shooting itself.
//      sayForArt(shootThingMsg(self));
      // Again, note that the first argument is self, i.e. gIobj, 
      // rather than the usual gDobj.
      doShootResult(self, defaultShootResult);
    }
  }
  beamWord = 'bolt'
  zapAry = transform(self, rayGun)
  defaultShootResult {
    if (doPlanA)
      return scramble;
    else
      return scramble2;
  }
  askFirstProp = &askAry
  rememberShootingAttempt() {
    aryUngAchievement1.setVisible();
    aryUngAchievement2.setVisible();
  }
;

rayGun: BaggettObject, Gun, StrangeThing
  vocabWords='ray gun/firearm/weapon/trigger*guns*firearms*weapons*triggers'
  name      ='ray gun'
  nickname  ='ray gun'
  //artTitle  ='The Legend Lives!'
  //artAuthor ='David M. Baggett'
  //// Definitely 1995, not 1994. http://groups.google.com/group/rec.games.int-fiction/browse_frm/thread/f8e9dc5943c84d84/
  //artYear   ='1995'
  //artCompany='Adventions'
  //artComp   ='Adventions'
  //artAttr   ='a'
  //artAttrib ='aa'
  artHtml1  ='<.legend>'
  artHtml2  ='<./legend>'
  //plqDesc() {
  //  "This is the <<nickname>> from <<artTitle>>. ";
  //  recognized = true;
  //}
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  shootPrefixMsg(obj, complex) {
    return
      '&lt;BZZZZZT!&gt; A brilliant red beam shoots out of the ray gun'
      + throughMsg(' and passes through the ','',obj, complex) + '. ';
  }
  // Presumably zapAry() is completely moot here. You can't have
  // the ray gun and the ary ung at the same time, and without the
  // ary ung, there's no way to call zapAry().
  zapAry = transform(self, aryUng)
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: pulseGun
// -------------------------------------------------------------------

pulseGun: ArtifactGun
  vocabWords='pulse gun/firearm/weapon/trigger/artifact*guns*firearms*weapons*triggers*artifacts'
  name      ='pulse gun'
  nickname  ='pulse gun'
  artTitle  ='Spider and Web'
  artAuthor ='Andrew Plotkin'
  artCompany=''
  artComp   =''
  artYear   ='1998'
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.spider>'
  artHtml2  ='<./spider>'
  artDesc   ="Your pulse gun is a little smaller than the guards<./s> 
               weapons. Its outline is sharp, clean, and beautiful. "
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  // Andrew Plotkin said I could copy his object's messages.
  permissionObtained = true
  // parsing stuff
  parseFailMsg = 'That<./s>s not a verb I recognize. '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         =true // acts like examine
  dLookIn       ='You find nothing of interest. '
  dSearch       =true // acts exactly like LookIn
  dLookUnder    ='You find nothing of interest. '
  dLookBehind   ='I only understood you as far as wanting to look. '
  dLookThrough  ='You find nothing of interest. '
  dListenTo     ='You hear nothing unexpected. '
  dSmell        ='You smell nothing unexpected. '
  dTaste        ='You taste nothing unexpected. '
  dFeel         ='You feel nothing unexpected. '
  dTake         ='Taken. '
  dTakeAlr      ='You already have that. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Dropped. '
  dDropAlr      ='The pulse gun is already here. '
  dPutIn        ='You put the pulse gun in {the iobj/him}. '
  dPutInAlr     ='You need to be holding the pulse gun before you can put it on top of something else. '
  iPutIn        ='That can<./s>t contain things. '
  dPutOn        ='You put the pulse gun on {the iobj/him}. '
  dPutOnAlr     ='You need to be holding the pulse gun before you can put it into something else. '
  iPutOn        ='Putting things on the pulse gun would achieve nothing. '
  dPutUnder     ='You put the pulse gun under {the iobj/him}. '
  dPutUnderAlr  ='You need to be holding the pulse gun before you can put it under something else. '
  iPutUnder     ='I didn<./s>t understand that sentence. '
  dPutBehind    ='You put the pulse gun behind {the iobj/him}. '
  dPutBehindAlr ='You need to be holding the pulse gun before you can put it behind something else. '
  iPutBehind    ='I didn<./s>t understand that sentence. '
  dWear         ='You can<./s>t wear that! '
  dDoff         ='You<./s>re not wearing that. '
  dKiss         ='You can only do that to something animate. '
  dAsk     /*!*/='You can only do that to something animate. '
  dAskFor       ='You can only do that to something animate. '
  dAskAbout     ='You can only do that to something animate. '
  dTell    /*!*/='You can only do that to something animate. '
  dTellAbout    ='You can only do that to something animate. '
  dTalkTo       =nil
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='You can only do that to something animate. '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='You can only do that to something animate. '
  dFollow       =nil
  dHit          ='That won<./s>t help. '
  dHitWith      ='That won<./s>t help. '
  iHitWith      =true
  dAttack       ='That won<./s>t help. '
  dAttackWith   ='That won<./s>t help. '
  iAttackWith   =true
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='That isn<./s>t a direction you can throw things. '
  dDig     /*!*/='Digging would achieve nothing here. '
  dDigWith      ='Digging would achieve nothing here. '
  iDigWith      ='Digging would achieve nothing here. '
  dJumpOver     ='You would achieve nothing by this. '
  dJumpOff      ='I only understood you as far as wanting to jump. '
  dPush         ='Nothing obvious happens. '
  dPull         ='Nothing obvious happens. '
  dMove         ='Nothing obvious happens. '
  dMoveWith     ='You can<./s>t see any such thing. ' // sic; 'move gun with stick' is interpreted as though 'gun with stick' were the intended dobj.
  iMoveWith     ='You can<./s>t see any such thing. ' // sic
  dMoveTo       ='I only understood you as far as wanting to move the pulse gun. '
  iMoveTo       ='I only understood you as far as wanting to move the pulse gun. '
  dTurn         ='Nothing obvious happens. '
  dTurnWith     ='I only understood you as far as wanting to turn the pulse gun. '
  iTurnWith     ='I only understood you as far as wanting to turn {the dobj/him}. '
  dTurnTo       ='No, you can<./s>t set that to anything. '
  dConsult      =nil
  dConsultAbout =nil
  dSetTo        ='No, you can<./s>t set that to anything. '
  dTypeOn       =nil
  dTypeLiteralOn=nil
  dEnterOn      ='You can<./s>t see any such thing. '
  dSwitch       ='Nothing obvious happens. '
  dFlip         ='Nothing obvious happens. '
  dTurnOn       ='That<./s>s not something you can switch. '
  dTurnOff      ='That<./s>s not something you can switch. '
  dLight        =nil
  dStrike       =nil
  dBurn    /*!*/=nil
  dBurnWith     =nil
  iBurnWith     =nil
  dExtinguish   ='You can<./s>t see any such thing. '
  dAttach  /*!*/=true // asks for iobj
  dAttachTo     ='Nothing happens. '
  iAttachTo     ='Nothing happens. '
  dDetach       ='There<./s>s no clear way of doing that. '
  dDetachFrom   ='There<./s>s no clear way of doing that. '
  iDetachFrom   ='There<./s>s no clear way of doing that. '
  dBreak        ='That won<./s>t help. '
  dCut     /*!*/='Cutting that up would achieve little. '
  dCutWith      ='I only understood you as far as wanting to cut the pulse gun. '
  iCutWith      ='I only understood you as far as wanting to cut {the dobj/him}. '
  dClimb        ='I don<./s>t think much is to be achieved by that. '
  dClimbUp      ='I don<./s>t think much is to be achieved by that. '
  dClimbDown    ='You can<./s>t see any such thing. '
  dOpen         ='That<./s>s not something you can open. '
  dClose        ='That<./s>s not something you can close. '
  dLock         ='That doesn<./s>t seem to be something you can lock. '
  dLockWith     ='That doesn<./s>t seem to be something you can lock. '
  iLockWith     ='It<./s>s not clear precisely how the pulse gun can be used to lock that. '
  dUnlock       ='That doesn<./s>t seem to be something you can unlock. '
  dUnlockWith   ='That doesn<./s>t seem to be something you can unlock. '
  iUnlockWith   ='It<./s>s not clear precisely how the pulse gun can be used to unlock that. '
  dEat          ='That<./s>s plainly inedible. '
  dDrink        ='There<./s>s nothing suitable to drink here. '
  dPour         =nil
  dPourInto     =nil
  iPourInto     =nil
  dPourOnto     =nil
  iPourOnto     =nil
  dClean        ='You achieve nothing by this. '
  dCleanWith    ='I only understood you as far as wanting to clean the pulse gun. '
  iCleanWith    ='I only understood you as far as wanting to clean {the dobj/him}. '
  dSitOn        ='That<./s>s not something you can enter. '
  dLieOn        ='That<./s>s not something you can enter. '
  dStandOn      ='That<./s>s not something you can enter. '
  dBoard        ='That<./s>s not something you can enter. '
  dGetOutOf     ='I only understood you as far as wanting to exit. '
  dGetOffOf     ='But you aren<./s>t on the pulse gun at the moment. '
  dFasten       ='Nothing happens. '
  dFastenTo     ='Nothing happens. '
  iFastenTo     ='Nothing happens. '
  dUnfasten     =nil
  dUnfastenFrom =nil
  iUnfastenFrom =nil
  dPlugIn       ='Nothing happens. '
  dPlugInto     ='Nothing happens. '
  iPlugInto     ='Nothing happens. '
  dUnplug       ='There<./s>s no clear way to do that. '
  dUnplugFrom   ='There<./s>s no clear way to do that. '
  iUnplugFrom   ='There<./s>s no clear way to do that. '
  dScrew        ='Nothing obvious happens. '
  dScrewWith    ='I only understood you as far as wanting to screw the pulse gun. '
  iScrewWith    ='I only understood you as far as wanting to screw {the dobj/him}. '
  dUnscrew      ='Nothing obvious happens. '
  dUnscrewWith  ='I only understood you as far as wanting to unscrew the pulse gun. '
  iUnscrewWith  ='I only understood you as far as wanting to unscrew {the dobj/him}. '
  dGoThrough    ='That<./s>s not something you can enter. '
  dEnter        ='That<./s>s not something you can enter. '
  dPushTravel   ='You can<./s>t see any such thing. '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
  canFireAimlessly = nil
  //shootEffectThing {
  //  sayForArt(shootPrefixMsg(gDobj, true));
  //  sayForArt(shootThingMsg(gDobj));
  //  doShootResult(gDobj, defaultShootResult);
  //}
  shootEffectCorpse {
    sayForArt('You lay a few pulses '
      + throughMsg('through the ',' and ',gDobj, true)
      + 'into the unmoving body, for luck. ');
    //doShootResult(gDobj, defaultShootResult);
  }
  shootEffectEnemy {
    if (!enemiesShotByThisGun) {
      sayForArt('You smile. 
        <p>In a heartbeat, bright pulses fly ' 
          + throughMsg('through the ',' and ',gDobj, true) 
          + 'into {the dobj/him}, lighting up the hallway. 
          {The dobj/he} collapses to the floor. ');
    }
    else {
      sayForArt(
        rand(
           'You fire' + throughMsg(' through the ','',gDobj, true) + '. '
          ,'You snap off a shot' + throughMsg(' through the ','',gDobj, true) + '. '
          ,'You fire quickly but without haste' + throughMsg(' through the ','',gDobj, true) + '. ')
        //+ throughMsg('The pulse passes through the ','. ',gDobj, true) 
        + '{The dobj/him} ' 
        + rand(
           'jerks and collapses. '
          ,'falls to the floor. '
          ,'crumples to the floor. '
        )
      );
    }
    doShootResult(gDobj, kill);
    enemiesShotByThisGun = true;
  }
  enemiesShotByThisGun = nil
  //specifyTargetMsg =
  //  'You<./s>ll have to specify what you want to shoot at. '
  shootAimlesslyEffect {
    sayForArt(shootAimlesslyMsg);
  }
  // This theoretically will never be printed. But just for
  // the sake of form:
  shootAimlesslyMsg =
    'You snap off a shot. The walls across from you 
      shower a corona of sparks. '
  shootPrefixMsg(obj, complex) {
    return '' + throughMsg('The pulse passes through the ','. ',obj, complex);
  }
  shootThingMsg(obj) {
    gMessageParams(obj);
    return '{The obj/he} shower{s} a corona of sparks. 
      Lacking a nervous system, however, {it obj/he} 
      {is} unaffected by the pulse. ';
  }
  shootFriendMsg =
    'You aim at {the dobj/him} and snap off a shot. 
      You miss by inches, and the walls behind her 
      shower a corona of sparks. '
  officeWindowTransmitMsg =
    ' and strikes the walls in the room beyond.
      The walls shower a corona of sparks. '
  slowingFieldTransmitMsg =
    ' and strikes the walls behind it.
      The walls shower a corona of sparks. '
  gunShootingItselfMsg =
    'The gun isn<./s>t flexible, you understand. '
  actorShootingHimselfMsg =
    'Pulsing yourself unconscious? You<./s>d never live it down. '
  beamWord = 'pulse'
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: electricPistol
// -------------------------------------------------------------------

// do vocabWords better

// The messages here are in the first person, as in Fallacy of Dawn.
// It's a little weird, but I hope it works.
electricPistol: ArtifactGun
  vocabWords='orange (toy) prototype electric pistol/battery/gun/firearm/weapon/trigger/artifact*guns*firearms*weapons*triggers*artifacts'
  name      ='electric pistol'
  nickname  ='electric pistol'
  artTitle  ='Fallacy of Dawn'
  artAuthor ='Robb Sherwin'
  artCompany=''
  artComp   =''
  artYear   ='2001'
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.fallacy>'
  artHtml2  ='<./fallacy>'
  //ammo = 10
  artDesc {
    "The electric pistol is a prototype energy weapon, 
      and uses batteries instead of cartridges or bullets. 
      It<./s>s created out of a bright <.s>safety-orange<./s>
      colored metal, to make it look like a toy gun to cops.
      Its battery can hold a maximum of twenty shots. ";
    "<p>This weapon has <<ammo>> shot<<ammo == 1 ? '' : 's'>>
      remaining. ";
  }
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  // Robb Sherwin said I could copy his object's messages.
  permissionObtained = true
  // parsing stuff
  parseFailMsg = '<b>[ The word <.q>' + glob.latestVerb + '<./q> is not recognized by the game. ]</b> '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         ='I can<./s>t do that with that. '
  dLookIn       ='I can<./s>t do that with that. '
  dSearch       =true // acts exactly like LookIn
  dLookUnder    ='I don<./s>t find anything under the electric pistol. '
  dLookBehind   ='I don<./s>t find anything behind the electric pistol. '
  dLookThrough  ='I can<./s>t see through that. '
  dListenTo     ='I<./s>m not making a sound. '
  dSmell        ='I don<./s>t smell anything unusual. '
  dTaste        ='I can<./s>t (or won<./s>t) lick that! '
  dFeel         ='Fiddling with the electric pistol probably isn<./s>t the best use of my time at the moment. '
  dTake         ='Taken. '
  dTakeAlr      ='I don<./s>t see that. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Dropped. '
  dDropAlr      ='I<./s>m not holding that. '
  dPutIn        ='I put the electric pistol in {the iobj/him}. '
  dPutInAlr     ='I<./s>m not holding that. '
  iPutIn        ='I can<./s>t do that with that. '
  dPutOn        ='I put the electric pistol on {the iobj/him}. '
  dPutOnAlr     ='I<./s>m not holding that. '
  iPutOn        ='I can<./s>t do that with that. '
  dPutUnder     ='I put the electric pistol under {the iobj/him}. '
  dPutUnderAlr  ='I<./s>m not holding that. '
  iPutUnder     ='<b>[ That sentence is not understood by the game. ]</b> '
  dPutBehind    ='I put the electric pistol behind {the iobj/him}. '
  dPutBehindAlr ='I<./s>m not holding that. '
  iPutBehind    ='<b>[ That sentence is not understood by the game. ]</b> '
  dWear         ='I can<./s>t wear the electric pistol. '
  dDoff         ='I<./s>m not wearing that. '
  dKiss         ='Not a chance. '
  dAsk     /*!*/='<b>[ That sentence is not understood by the game. ]</b> '
  dAskFor       ='<b>[ That sentence is not understood by the game. ]</b> '
  dAskAbout     ='<b>[ Use <.q>TALK TO CHARACTER<./q> to talk to a particular character in the game. ]</b> '
  dTell    /*!*/='<b>[ That sentence is not understood by the game. ]</b> '
  dTellAbout    ='<b>[ Use <.q>TALK TO CHARACTER<./q> to talk to a particular character in the game. ]</b> '
  dTalkTo       ='I can<./s>t do that with that. '
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='The kind gesture goes unnoticed by the electric pistol. '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='Showing my credit card to the electric pistol doesn<./s>t accomplish a whole lot. '
  dFollow       ='Which way did it go? '
  dHit          ='I can<./s>t really fight that. '
  dHitWith      ='I can<./s>t really fight that. '
  iHitWith      =true
  dAttack       ='I can<./s>t really fight that. '
  dAttackWith   ='I can<./s>t really fight that. '
  iAttackWith   =true
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='<b>[ That sentence is not understood by the game. ]</b> '
  dDig     /*!*/='That won<./s>t accomplish anything. '
  dDigWith      ='That won<./s>t accomplish anything. '
  iDigWith      ='That won<./s>t accomplish anything. '
  dJumpOver     ='<b>[ That sentence is not understood by the game. ]</b> '
  dJumpOff      ='<b>[ That sentence is not understood by the game. ]</b> '
  dPush         ='Pushing the electric pistol doesn<./s>t get me anywhere. '
  dPull         ='Pulling the electric pistol doesn<./s>t get me anywhere. '
  dMove         ='I can<./s>t move the electric pistol. '
  dMoveWith     ='<b>[ That sentence is not understood by the game. ]</b> '
  iMoveWith     ='<b>[ That sentence is not understood by the game. ]</b> '
  dMoveTo       ='<b>[ That sentence is not understood by the game. ]</b> '
  iMoveTo       ='<b>[ That sentence is not understood by the game. ]</b> '
  dTurn         ='<b>[ That sentence is not understood by the game. ]</b> '
  dTurnWith     ='<b>[ That sentence is not understood by the game. ]</b> '
  iTurnWith     ='<b>[ That sentence is not understood by the game. ]</b> '
  dTurnTo       ='<b>[ That sentence is not understood by the game. ]</b> '
  dConsult      =nil
  dConsultAbout =nil
  dSetTo        ='<b>[ That sentence is not understood by the game. ]</b> '
  dTypeOn       =nil
  dTypeLiteralOn=nil
  dEnterOn      ='<b>[ That sentence is not understood by the game. ]</b> '
  dSwitch       ='Better start with a verb. '
  dFlip         ='<b>[ That sentence is not understood by the game. ]</b> '
  dTurnOn       ='I can<./s>t do that with that. '
  dTurnOff      ='I can<./s>t do that with that. '
  dLight        ='It won<./s>t burn. '
  dStrike       =true // remapped to dHit
  dBurn    /*!*/='It won<./s>t burn. '
  dBurnWith     ='It won<./s>t burn. '
  iBurnWith     ='I can<./s>t do that with that. '
  dExtinguish   ='I can<./s>t do that with that. '
  dAttach  /*!*/='Trying to tie the electric pistol doesn<./s>t get me anywhere. '
  dAttachTo     ='Trying to tie the electric pistol doesn<./s>t get me anywhere. '
  iAttachTo     ='Trying to tie things to the electric pistol doesn<./s>t get me anywhere. '
  dDetach       ='Trying to untie the electric pistol doesn<./s>t get me anywhere. '
  dDetachFrom   ='Trying to untie the electric pistol doesn<./s>t get me anywhere. '
  iDetachFrom   ='Trying to untie things from the electric pistol doesn<./s>t get me anywhere. '
  dBreak        ='That doesn<./s>t seem to work. '
  dCut     /*!*/='<b>[ Please specify what you<./s>re cutting with. ]</b> '
  dCutWith      ='A destructive and somewhat less than completely useful course of action. '
  iCutWith      ='A destructive and somewhat less than completely useful course of action. '
  dClimb        ='I can<./s>t climb the electric pistol. '
  dClimbUp      ='I can<./s>t climb the electric pistol. '
  dClimbDown    ='I can<./s>t climb the electric pistol. '
  dOpen         ='I can<./s>t do that with that. '
  dClose        ='I can<./s>t do that with that. '
  dLock         ='I can<./s>t do that with that. '
  dLockWith     ='I can<./s>t do that with that. '
  iLockWith     ='I can<./s>t do that with that. '
  dUnlock       ='I can<./s>t do that with that. '
  dUnlockWith   ='I can<./s>t do that with that. '
  iUnlockWith   ='I can<./s>t do that with that. '
  dEat          ='I can<./s>t eat the electric pistol. '
  dDrink        ='I can<./s>t drink the electric pistol. '
  dPour         ='That doesn<./s>t seem to be feasible. '
  dPourInto     ='That doesn<./s>t seem to be feasible. '
  iPourInto     ='That doesn<./s>t seem to be feasible. '
  dPourOnto     ='That doesn<./s>t seem to be feasible. '
  iPourOnto     ='That doesn<./s>t seem to be feasible. '
  dClean        =nil
  dCleanWith    =nil
  iCleanWith    =nil
  dSitOn        ='I can<./s>t enter the electric pistol. '
  dLieOn        ='I can<./s>t enter the electric pistol. '
  dStandOn      ='Better start with a verb. '
  dBoard        ='I can<./s>t enter the electric pistol. '
  dGetOutOf     ='I<./s>m not in the electric pistol. '
  dGetOffOf     ='I<./s>m not in the electric pistol. '
  dFasten       ='Trying to tie the electric pistol doesn<./s>t get me anywhere. '
  dFastenTo     ='Trying to tie the electric pistol doesn<./s>t get me anywhere. '
  iFastenTo     ='Trying to tie things to the electric pistol doesn<./s>t get me anywhere. '
  dUnfasten     ='Trying to untie the electric pistol doesn<./s>t get me anywhere. '
  dUnfastenFrom ='Trying to untie the electric pistol doesn<./s>t get me anywhere. '
  iUnfastenFrom ='Trying to untie things from the electric pistol doesn<./s>t get me anywhere. '
  dPlugIn       ='That doesn<./s>t seem to work. '
  dPlugInto     ='That doesn<./s>t seem to work. '
  iPlugInto     ='That doesn<./s>t seem to work. '
  dUnplug       ='Pulling the electric pistol doesn<./s>t get me anywhere. '
  dUnplugFrom   ='Pulling the electric pistol doesn<./s>t get me anywhere. '
  iUnplugFrom   ='That doesn<./s>t seem to work. '
  dScrew        =nil
  dScrewWith    =nil
  iScrewWith    =nil
  dUnscrew      =nil
  dUnscrewWith  =nil
  iUnscrewWith  =nil
  dGoThrough    ='I can<./s>t enter the electric pistol. '
  dEnter        ='I can<./s>t enter the electric pistol. '
  dPushTravel   ='I haven<./s>t seen that. '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
  ammo = 10
  ammoDecrement = 1
  canFireAimlessly = nil
  willNotShoot(target) {
    // Don't bother wasting ammo on corpses
    if (target && target.ofKind(Corpse)) {
      sayForArt('{The dobj/him} {is} not conscious enough 
        to put up a fight now. ');
      return true;
    }
    // Don't bother wasting ammo on inanimate things
    else if (target && !target.ofKind(Actor)) {
      sayForArt('I can<./s>t really fight that. ');
      //sayForArt('I can<./s>t really fight {that dobj/him}. ');
      return true;
    }
    else {
      // Inheriting from Gun will take care of the 
      // "be more specific about what to shoot" scenario
      // and the "out of ammo" scenario.
      return inherited(target);
    }
  }
  // shootEffectCorpse was pre-empted in willNotShoot().
  //shootEffectCorpse { shootEffectThing; }
  shootEffectEnemy {
    //sayForArt(throughMsg('Through the ',', ',gDobj, true)
    //  + 'I shoot {the dobj/him}!! ');
    sayForArt('I shoot {the dobj/him}!! ');
    gDobj.electricPistolBlastCount++;
    if (gDobj.electricPistolBlastCount >= 
        gDobj.electricPistolBlastThreshold) {
      sayForArt('<p>{The dobj/he} collapses 
        and falls to the ground. ');
      doShootResult(gDobj, kill);
    }
  }
  noAmmoMsg = 'That gun doesn<./s>t have any ammo left. '
  specifyTargetMsg =
    'You<./s>ll have to be more specific about 
      what you want me to fight.  '
  // Just in case:
  shootAimlesslyMsg = 'I shoot!! '
  shootPrefixMsg(obj, complex) {
    return '';
  }
  shootThingMsg(obj) {
    gMessageParams(obj);
    // This should never be printed -- but just in case:
    return 'I shoot {the obj/him}!! ';
  }
  shootFriendMsg =
    //throughMsg(' through the ','',gDobj, true)
    'I miss {the dobj/him}!! '
  gunShootingItselfMsg =
    'I can<./s>t really fight that. '
  actorShootingHimselfMsg =
    'I can<./s>t fight myself. '
  beamWord = 'shot'
  zapT = transform(self, elecricPisol)
  zapAry = disappear(
    'The electric pistol disappears.
        <p>Then, suddenly, a platoon of electric pilots 
        come parachuting down from out of nowhere! 
        These androids are clearly aviators
        because of their parachutes, as well as their
        distinctive pilots<./s> uniforms.
      <p>The largest android points off into the distance,
        saying, <.q>The airport is that way!<./q>
      <p>With that, he cuts loose his parachute'
        + (doorInThisRoomMustBeOpened() ? ', opens the door,' : '')
        + ' and runs off. Most of the other pilots promptly 
        follow suit.
      <p>One pilot remains, however. He, apparently, 
        is left with the thankless task of 
        picking up all the parachutes and stuffing them
        in a bag. After he has finally accomplished this,
        he says, <.q>Hey, wait for me!<./q> and runs after
        his companions. '
    , self, 'electric pilots'
  )
  zapAryCq {
    openDoorInThisRoom();
  }
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: silencedPistol
// -------------------------------------------------------------------

silencedPistol: ArtifactGun
  vocabWords='semiautomatic automatic 9mm sig p239 silenced pistol/silencer/gun/firearm/weapon/trigger/artifact*guns*firearms*weapons*triggers*artifacts'
  name      ='silenced pistol'
  nickname  ='gun'
  artTitle  ='Scavenger'
  artAuthor ='Quintin Stone'
  artCompany=''
  artComp   =''
  artYear   ='2003'
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.scavenger>'
  artHtml2  ='<./scavenger>'
  artDesc {
    "From the markings on it, it<./s>s a SIG P239 
      semiautomatic handgun in 9mm. It has 
      a dark matte finish to it and a short cylinder 
      attached to the barrel that you recognize as a silencer. 
      It is loaded with <<ammo>> round<<ammo == 1 ? '' : 's'>>. ";
  }
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  // Quintin Stone said I could copy his object's messages.
  permissionObtained = true
  // parsing stuff
  parseFailMsg = 'I don<./s>t know the <.q>' + glob.latestVerb +
                   '<./q>. '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         ='I don<./s>t know how to read the silenced pistol. '
  dLookIn       ='You pop the magazine out of the silenced pistol 
                   to count the number of shots remaining, 
                   then slide it back in. There '
                   + (ammo == 1 ? 'is 1 shot' : 'are ' + ammo + ' shots')
                   + ' left. '
  dSearch       =true // acts exactly like LookIn
  dLookUnder    ='There<./s>s nothing under the silenced pistol. '
  dLookBehind   ='There<./s>s nothing behind the silenced pistol. '
  dLookThrough  ='You can<./s>t see anything through the silenced pistol. '
  dListenTo     ='You don<./s>t hear anything. '
  dSmell        ='It has the faint smell of gun oil. '
  dTaste        =nil
  dFeel         ='The silenced pistol feels about like you<./s>d expect. '
  dTake         ='Taken. '
  dTakeAlr      ='You already have the silenced pistol! '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Dropped. '
  dDropAlr      ='You<./s>re not carrying the silenced pistol! '
  dPutIn        ='Done. '
  dPutInAlr     ='The silenced pistol is already in {the iobj/him}! '
  iPutIn        ='You can<./s>t figure out how to get {the dobj/him} into the silenced pistol. '
  dPutOn        ='Done. '
  dPutOnAlr     ='The silenced pistol is already on {the iobj/him}! '
  iPutOn        ='There<./s>s no good surface on the silenced pistol. '
  dPutUnder     ='Done. '
  dPutUnderAlr  ='The silenced pistol is already under {the iobj/him}! '
  iPutUnder     ='There isn<./s>t room. '
  dPutBehind    ='Done. '
  dPutBehindAlr ='The silenced pistol is already behind {the iobj/him}! '
  iPutBehind    ='I don<./s>t recognize that sentence. '
  dWear         ='You can<./s>t wear the silenced pistol. '
  dDoff         ='You<./s>re not wearing the silenced pistol! '
  dKiss         ='You really want to put your lips on that? '
  dAsk     /*!*/=true // asks for topic
  dAskFor       ='Oddly enough, you get no response. '
  dAskAbout     ='Oddly enough, you get no response. '
  dTell    /*!*/=true // asks for topic
  dTellAbout    ='Oddly enough, you get no response. '
  dTalkTo       =nil
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='I don<./s>t know how to give anything to the silenced pistol. '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='Oddly enough, you get no response. '
  dFollow       ='I don<./s>t know how to follow the silenced pistol. '
  dHit          ='Your fists do little damage. '
  dHitWith      ='Your fists do little damage. '
  iHitWith      =true
  dAttack       ='Your fists do little damage. '
  dAttackWith   ='Your fists do little damage. '
  iAttackWith   =true
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='I don<./s>t know how to throw anything to the silenced pistol. '
  dDig     /*!*/=true // asks for iobj
  dDigWith      ='I don<./s>t know how to dig in the silenced pistol. '
  iDigWith      ='I don<./s>t know how to dig in anything with the silenced pistol. '
  dJumpOver     ='I don<./s>t know how to jump the silenced pistol. '
  dJumpOff      ='I don<./s>t know how to jump the silenced pistol. '
  dPush         ='Pushing the silenced pistol doesn<./s>t do anything. '
  dPull         ='Pulling the silenced pistol doesn<./s>t have any effect. '
  dMove         ='Moving the silenced pistol doesn<./s>t reveal anything. '
  dMoveWith     ='Moving the silenced pistol doesn<./s>t reveal anything. '
  iMoveWith     ='I don<./s>t know how to move anything with the silenced pistol. '
  dMoveTo       ='Moving the silenced pistol doesn<./s>t reveal anything. '
  iMoveTo       =true // does nothing
  dTurn         ='Turning the silenced pistol doesn<./s>t appear to have any effect. '
  dTurnWith     ='Turning the silenced pistol doesn<./s>t appear to have any effect. '
  iTurnWith     ='I don<./s>t know how to turn anything with the silenced pistol. '
  dTurnTo       ='Turning the silenced pistol doesn<./s>t appear to have any effect. '
  dConsult      ='That<./s>s not an information source. '
  dConsultAbout ='That<./s>s not an information source. '
  dSetTo        =nil
  dTypeOn       ='I don<./s>t know how to type anything on the silenced pistol. '
  dTypeLiteralOn='I don<./s>t know how to type anything on the silenced pistol. '
  dEnterOn      ='I don<./s>t know how to enter the silenced pistol. '
  dSwitch       ='I don<./s>t know how to switch the silenced pistol. '
  dFlip         ='I don<./s>t know how to flip the silenced pistol. '
  dTurnOn       ='I don<./s>t know how to turn the silenced pistol on. '
  dTurnOff      ='I don<./s>t know how to turn the silenced pistol off. '
  dLight        ='There<./s>s no verb in that sentence! '
  dStrike       ='Your fists do little damage. '
  dBurn    /*!*/=nil
  dBurnWith     =nil
  iBurnWith     =nil
  dExtinguish   =nil
  dAttach  /*!*/=true // asks for iobj
  dAttachTo     ='There<./s>s no obvious way to do that. '
  iAttachTo     ='There<./s>s no obvious way to do that. '
  dDetach       ='There<./s>s no obvious way to do that. '
  dDetachFrom   ='There<./s>s no obvious way to do that. '
  iDetachFrom   ='There<./s>s no obvious way to do that. '
  dBreak        ='You<./s>ll have to specify exactly how you want to do that. '
  dCut     /*!*/=nil
  dCutWith      =nil
  iCutWith      =nil
  dClimb        ='I don<./s>t know how to climb the silenced pistol. '
  dClimbUp      ='I don<./s>t know how to climb up the silenced pistol. '
  dClimbDown    ='I don<./s>t know how to climb down the silenced pistol. '
  dOpen         ='I don<./s>t know how to open the silenced pistol. '
  dClose        ='I don<./s>t know how to close the silenced pistol. '
  dLock         ='I don<./s>t know how to lock the silenced pistol. '
  dLockWith     ='I don<./s>t know how to lock the silenced pistol. '
  iLockWith     ='I don<./s>t know how to lock anything with the silenced pistol. '
  dUnlock       ='I don<./s>t know how to unlock the silenced pistol. '
  dUnlockWith   ='I don<./s>t know how to unlock the silenced pistol. '
  iUnlockWith   ='I don<./s>t know how to unlock anything with the silenced pistol. '
  dEat          ='The silenced pistol is not quite edible. '
  dDrink        ='You can<./s>t drink the silenced pistol. '
  dPour         ='But the silenced pistol is not a liquid! '
  dPourInto     ='But the silenced pistol is not a liquid! '
  iPourInto     ='I don<./s>t know how to pour anything into the silenced pistol. '
  dPourOnto     ='But the silenced pistol is not a liquid! '
  iPourOnto     ='I don<./s>t know how to pour anything onto the silenced pistol. '
  dClean        ='That would be a colossal waste of time. '
  dCleanWith    ='That would be a colossal waste of time. '
  iCleanWith    ='I don<./s>t know how to clean anything with the silenced pistol. '
  dSitOn        ='I don<./s>t know how to sit on the silenced pistol. '
  dLieOn        ='I don<./s>t know how to lie on the silenced pistol. '
  dStandOn      ='I don<./s>t know how to stand on the silenced pistol. '
  dBoard        ='I don<./s>t know how to get on the silenced pistol. '
  dGetOutOf     ='I didn<./s>t recognize that sentence. '
  dGetOffOf     ='You<./s>re not on the silenced pistol! '
  dFasten       ='I don<./s>t know how to fasten the silenced pistol. '
  dFastenTo     ='I don<./s>t recognize that sentence. '
  iFastenTo     ='I don<./s>t recognize that sentence. '
  dUnfasten     ='I don<./s>t know how to fasten the silenced pistol. '
  dUnfastenFrom ='I don<./s>t recognize that sentence. '
  iUnfastenFrom ='I don<./s>t recognize that sentence. '
  dPlugIn       ='You can<./s>t plug the silenced pistol into anything. '
  dPlugInto     ='You can<./s>t plug the silenced pistol into anything. '
  iPlugInto     ='You can<./s>t plug anything into the silenced pistol. '
  dUnplug       ='I don<./s>t know how to unplug the silenced pistol. '
  dUnplugFrom   ='I don<./s>t know how to unplug the silenced pistol. '
  iUnplugFrom   ='I don<./s>t know how to unplug anything from the silenced pistol. '
  dScrew        ='You see no way to do that. '
  dScrewWith    ='You see no way to do that. '
  iScrewWith    ='You see no way to do that. '
  dUnscrew      ='You see no way to do that. '
  dUnscrewWith  ='You see no way to do that. '
  iUnscrewWith  ='You see no way to do that. '
  dGoThrough    ='I don<./s>t know how to go through the silenced pistol. '
  dEnter        ='I don<./s>t know how to enter the silenced pistol. '
  dPushTravel   ='You can<./s>t seem to do that. '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
  tangibleProjectiles = true
  ammo = 12
  ammoDecrement = 1
  canFireAimlessly = nil
  willNotShoot(target) {
    // Don't bother wasting ammo on anything but actors
    // and/or windows.
    if (target && !target.ofKind(Actor) &&
        !target.ofKind(Window)) {
      if (target == slowingField)
        sayForArt('You briefly consider shooting a bullet through 
          {the dobj/him}, then decide that it<./s>s not worth 
          wasting your limited supply of ammunition. ');
      else
        sayForArt('You briefly consider shooting a hole in 
          {the dobj/him}, then decide that it<./s>s not worth 
          wasting your limited supply of ammunition. ');
      return true;
    }
    else {
      // Inheriting from Gun will take care of the 
      // "be more specific about what to shoot" scenario
      // and the "out of ammo" scenario.
      return inherited(target);
    }
  }
  shootEffectEnemy {
    switch (enemiesShotByThisGun) {
      case 0:
        sayForArt('You carefully take aim at {the dobj/him}. 
          The gun coughs quietly and '
          + throughMsg('the bullet passes through the ',' without visible effect. \^',gDobj,slowingField)
          + 'the alien gurgles, 
          clutching at his throat. He flails violently, 
          twisting and staggering. After what seems 
          like an eternity, {the dobj/he} finally 
          collapses to the floor. ');
        break;
      case 1:
        // The "small pool" thing is my own invention, designed
        // to be written in a style consistent with Scavenger.
        sayForArt('You raise your pistol and fire off a shot'
          + throughMsg(', which passes through the ',' without visible effect',gDobj,slowingField)
          + '. {The dobj/he} grimaces in pain 
          as the bullet tears into him. He falls 
          to the floor, and his blood seeps out 
          in a small pool. '); 
        break;
      case 2:
        sayForArt('The P239 coughs quietly, and '
          + throughMsg('the bullet passes through the ',' without visible effect. \^',gDobj,slowingField)
          + '{the dobj/he} falls dead to the floor. ');
        break;
      case 3:
        sayForArt('You raise your pistol and fire off a shot. '
          + throughMsg('The bullet passes through the ',' without visible effect. ',gDobj,slowingField)
          + '{The dobj/he} cries out and tumbles to the floor. ');
        break;
      default:
        sayForArt('You carefully take aim and fire off a shot'
          + throughMsg(', which passes through the ',' without visible effect',gDobj,slowingField)
          + '. {The dobj/he} jerks back, then
          falls to the floor. ');
        break;
    }
    doShootResult(gDobj, kill);
    enemiesShotByThisGun++;
  }
  enemiesShotByThisGun = 0
  shootEffectWindow {
    if (gDobj.isTangible) {
      // sic: "imbeds"
      sayForArt('The bullet careens off the window and imbeds 
        itself into the wall. Apparently it<./s>s not made of
        glass after all. ');
      //doShootResult(gDobj, defaultShootResult);
    }
    else {
      inherited;
    }
  }
  noAmmoMsg = 'Your pistol is out of ammo! '
  specifyTargetMsg =
    'You<./s>ll have to specify what you want to shoot at. '
  // just in case:
  shootAimlesslyMsg =
    'You briefly consider firing the silenced pistol 
      aimlessly, then decide that it<./s>s not worth 
      wasting your limited supply of ammunition. '
  shootPrefixMsg(obj, complex) {
    return '';
  }
  //shootThingMsg(obj) {
  //  gMessageParams(obj);
  //  return '{The obj/he} seem{s} unaffected. ';
  //}
  shootFriendMsg =
    'You take aim at {the dobj/him} and pull the trigger.
      The bullet barely misses, embedding itself in the wall. '
  gunShootingItselfMsg =
    'That<./s>d be a neat trick. '
  actorShootingHimselfMsg =
    'Waves of despair overcome you. You<./s>ll never succeed, 
      you<./s>re a failure, nobody loves you, 
      everybody hates you, etc. You place the end 
      of the silencer into your mouth and pull the trigger. '
  letsActorShootHimself = true
  shootingOneselfWithThisIsDeadly = true
  zapT = transform(self, silencedPisol)
  zapAry = disappear(
    transformUnsimulated('a couple of licensed pilots')
        + 'The pilots, smartly dressed in their pilots<./s>
        uniforms, come up to you and ask where the airport is.
        After you tell them you don<./s>t know, they say,
        <.q>Don<./s>t worry, son, we<./s>ll find it.<./q>
        And with that, they '
        + (doorInThisRoomMustBeOpened() ? 'open the door and ' : '')
        + 'briskly walk off, presumably
        in search of their airfield.
      <p>As they walk away, you think, 
        <i>Son?</i> Those men were twenty years your junior. '
    , self, 'licensed pilots'
  )
  zapAryCq {
    openDoorInThisRoom();
  }
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: disrupter
// -------------------------------------------------------------------

disrupter: Bomb, ArtifactGun
  vocabWords='photonic disrupter/disruptor/gun/firearm/weapon/trigger/artifact*guns*firearms*weapons*triggers*artifacts'
  name      ='photonic disrupter'
  nickname  ='disrupter'
  artTitle  ='Moments out of Time 3: The Light of Day'
  artAuthor ='L. Ross Raszewski'
  artCompany=''
  artComp   =''
  artYear   ='2032'
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.moments>'
  artHtml2  ='<./moments>'
  simpleAttribution {
    if (artAuthor != nil && artAuthor != '') {
      if (artTitle.substr(-1) == '!')
        return titlei('') + ' by ' + artAuthor;
      else
        return titlei(',') + ' by ' + artAuthor;
    }
    else
      return titlei('');
  }
  attributionForCredits {
    return '<i>Moments out of Time 2: Adventure Type</i> by ' + artAuthor
      + (permissionObtained ? '[*]' : '')
      + ((artCompany != nil && artCompany != '') ? ' (' + artCompany + ')' : '');
  }
  // L. Ross Raszewski said I could copy his object's messages.
  permissionObtained = true
  artDesc {
    // Note: the original MOOT 2 disrupter has the rather long
    // description. I have excised only those sentences
    // having to do with MOOT 2's protagonist.)
    
    //"You have never really liked using the photonic
    //  disrupter, but it<./s>s saved your life a few times. ";
    "It<./s>s the only sort of weapon StreamDivers are allowed 
      to carry, and even then, it<./s>s usually forbidden 
      by security restrictions. Darned easy to screw up 
      the time stream by shooting one of these 
      at the wrong thing. ";
    //"You<./s>d guess that more than half 
    //  of your missions have been to investigate 
    //  a questionable disrupter discharge. ";
    "Anyway, you can shoot things with it. 
      In the event of a particularly dire emergency, 
      it can be set to overload, in which case 
      it will act as a photonic grenade, 
      generating a massive, sudden discharge of photonic 
      energy &mdash; it doesn<./s>t do a tremendous amount 
      of damage to non-living tissue, in general, 
      but it<./s>s quite a light show. ";
  }
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  // parsing stuff
  parseFailMsg = 'That<./s>s not a verb I recognize. '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         =true // acts like examine
  dLookIn       ='You find nothing of interest. '
  dSearch       =true // acts exactly like LookIn
  dLookUnder    ='You find nothing of interest. '
  dLookBehind   ='You find nothing of interest. '
  dLookThrough  ='You find nothing of interest. '
  dListenTo     ='You hear nothing unexpected. '
  dSmell        ='You smell nothing unexpected. '
  dTaste        ='You taste nothing unexpected. '
  dFeel         ='You feel nothing unexpected. '
  dTake         ='Taken. '
  dTakeAlr      ='You already have that. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Dropped. '
  dDropAlr      ='{The dobj/him} is already here. ' // BAD
  dPutIn        ='You put {the dobj/him} into {the iobj/him}. '
  dPutInAlr     ='{The dobj/him} is already here. ' // BAD
  iPutIn        ='That can<./s>t contain things. '
  dPutOn        ='You put {the dobj/him} on {the iobj/him}. '
  dPutOnAlr     ='{The dobj/him} is already here. ' // BAD
  iPutOn        ='Putting things on {the iobj/him} would achieve nothing. '
  dPutUnder     ='I didn<./s>t understand that sentence. '
  dPutUnderAlr  ='{The dobj/him} is already here. ' // BAD
  iPutUnder     ='I didn<./s>t understand that sentence. '
  dPutBehind    ='I didn<./s>t understand that sentence. '
  dPutBehindAlr ='{The dobj/him} is already here. ' // BAD
  iPutBehind    ='I didn<./s>t understand that sentence. '
  dWear         ='You can<./s>t wear that! '
  dDoff         ='You<./s>re not wearing that. '
  dKiss         ='You can only do that to something animate. '
  dAsk     /*!*/='You can only do that to something animate. '
  dAskFor       ='You can only do that to something animate. '
  dAskAbout     ='You can only do that to something animate. '
  dTell    /*!*/='You can only do that to something animate. '
  dTellAbout    ='You can only do that to something animate. '
  dTalkTo       ='You can only do that to something animate. '
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='You can only do that to something animate. '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='Being inanimate, the photonic disrupter takes no interest. '
  dFollow       =nil
  dHit          ='Violence isn<./s>t the answer to this one. '
  dHitWith      ='Violence isn<./s>t the answer to this one. '
  iHitWith      =true
  dAttack       ='Violence isn<./s>t the answer to this one. '
  dAttackWith   ='Violence isn<./s>t the answer to this one. '
  iAttackWith   =true
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='I only understood you as far as wanting to throw {the dobj/him}. '
  dDig     /*!*/='Digging would achieve nothing here. '
  dDigWith      ='Digging would achieve nothing here. '
  iDigWith      ='Digging would achieve nothing here. '
  dJumpOver     ='You would achieve nothing by this. '
  dJumpOff      ='I only understood you as far as wanting to jump. '
  dPush         ='Nothing obvious happens. '
  dPull         ='Nothing obvious happens. '
  dMove         ='Nothing obvious happens. '
  dMoveWith     ='You can<./s>t see any such thing. '
  iMoveWith     ='You can<./s>t see any such thing. '
  dMoveTo       ='You can<./s>t see any such thing. '
  iMoveTo       ='You can<./s>t see any such thing. '
  dTurn         ='Nothing obvious happens. '
  dTurnWith     ='I only understood you as far as wanting to turn {the dobj/him}. '
  iTurnWith     ='I only understood you as far as wanting to turn {the dobj/him}. '
  dTurnTo       =true
  dConsult      ='I didn<./s>t understand that sentence. '
  dConsultAbout ='You discover nothing of interest in {the dobj/him}. '
  dSetTo        =true
  dTypeOn       =nil
  dTypeLiteralOn=nil
  dEnterOn      ='You can<./s>t see any such thing. '
  dSwitch       ='That<./s>s not something you can switch. '
  dFlip         =nil
  dTurnOn       ='That<./s>s not something you can switch. '
  dTurnOff      ='That<./s>s not something you can switch. '
  dLight        ='This dangerous act would achieve little. '
  dStrike       =nil
  dBurn    /*!*/='This dangerous act would achieve little. '
  dBurnWith     ='This dangerous act would achieve little. '
  iBurnWith     ='This dangerous act would achieve little. '
  dExtinguish   ='I didn<./s>t understand that sentence. '
  dAttach  /*!*/='You would achieve nothing by this. '
  dAttachTo     ='You would achieve nothing by this. '
  iAttachTo     ='You would achieve nothing by this. '
  dDetach       =nil
  dDetachFrom   =nil
  iDetachFrom   =nil
  dBreak        ='Violence isn<./s>t the answer to this one. '
  dCut     /*!*/='Cutting that up would achieve little. '
  dCutWith      ='I only understood you as far as wanting to cut {the dobj/him}. '
  iCutWith      ='I only understood you as far as wanting to cut {the dobj/him}. '
  dClimb        ='I don<./s>t think much is to be achieved by that. '
  dClimbUp      ='I don<./s>t think much is to be achieved by that. '
  dClimbDown    ='I only understood you as far as wanting to climb the ground. '
  dOpen         ='That<./s>s not something you can open. '
  dClose        ='That<./s>s not something you can close. '
  dLock         ='That doesn<./s>t seem to be something you can lock. '
  dLockWith     ='That doesn<./s>t seem to be something you can lock. '
  iLockWith     ='It<./s>s not clear precisely how the pulse gun can be used to lock that. '
  dUnlock       ='That doesn<./s>t seem to be something you can unlock. '
  dUnlockWith   ='That doesn<./s>t seem to be something you can unlock. '
  iUnlockWith   ='It<./s>s not clear precisely how the pulse gun can be used to unlock that. '
  dEat          ='That<./s>s plainly inedible. '
  dDrink        ='There<./s>s nothing suitable to drink here. '
  dPour         =nil
  dPourInto     =nil
  iPourInto     =nil
  dPourOnto     =nil
  iPourOnto     =nil
  dClean        ='You achieve nothing by this. '
  dCleanWith    ='I only understood you as far as wanting to clean {the dobj/him}. '
  iCleanWith    ='I only understood you as far as wanting to clean {the dobj/him}. '
  dSitOn        ='That<./s>s not something you can sit down on. '
  dLieOn        ='That<./s>s not something you can lie down on. '
  dStandOn      ='That<./s>s not something you can stand on. '
  dBoard        =nil
  dGetOutOf     ='But you aren<./s>t in {the dobj/him}. '
  dGetOffOf     ='But you aren<./s>t on {the dobj/him} at the moment. '
  dFasten       ='You would achieve nothing by this. '
  dFastenTo     ='You would achieve nothing by this. '
  iFastenTo     ='You would achieve nothing by this. '
  dUnfasten     =nil
  dUnfastenFrom =nil
  iUnfastenFrom =nil
  dPlugIn       =nil
  dPlugInto     =nil
  iPlugInto     =nil
  dUnplug       =nil
  dUnplugFrom   =nil
  iUnplugFrom   =nil
  dScrew        ='Nothing obvious happens. '
  dScrewWith    ='I only understood you as far as wanting to screw {the dobj/him}. '
  iScrewWith    ='I only understood you as far as wanting to screw {the dobj/him}. '
  dUnscrew      ='Nothing obvious happens. '
  dUnscrewWith  ='I only understood you as far as wanting to unscrew {the dobj/him}. '
  iUnscrewWith  ='I only understood you as far as wanting to unscrew {the dobj/him}. '
  dGoThrough    ='That<./s>s not something you can enter. '
  dEnter        ='That<./s>s not something you can enter. '
  dPushTravel   ='Is that the best you can think of? '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
  canFireAimlessly = nil
  willNotShoot(target) {
    // Don't bother wasting ammo on anything but actors
    // and/or windows.
    if (target && !target.ofKind(Actor)) {
      sayForArt(shootThingMsg(nil));
      return true;
    }
    else {
      // Inheriting from Gun will take care of the 
      // "be more specific about what to shoot" scenario
      return inherited(target);
    }
  }
  shootEffectEnemy {
    sayForArt('It only takes a moment<./s>s consideration 
      to remember that you haven<./s>t traveled back in time, 
      so killing {the dobj/him} won<./s>t do any damage 
      to history. You fire' + throughMsg(' through the ','',gDobj,true)
      + ', vaporizing the alien. ');
    doShootResult(gDobj, vaporize);
  }
  specifyTargetMsg = (shootThingMsg(nil))
  // Just in case:
  shootAimlesslyMsg = 'You fire off a blast. '
  shootPrefixMsg(obj, complex) {
    return '';
  }
  shootThingMsg(obj) {
    return 'Violence isn<./s>t the answer to this one. ';
  }
  shootFriendMsg =
    'You fire at {the dobj/him}, but miss. '
  gunShootingItselfMsg = shootThingMsg(nil)
  actorShootingHimselfMsg = shootThingMsg(nil)
  dobjFor(TurnTo) asDobjFor(SetTo)
  dobjFor(SetTo) {
    verify { }
    preCond = [touchObj]
    check { }
    action {
      local lit = gAction.getLiteral.toLower;
      local overload = (lit.find('overload') != nil);
      if (overload && !isSetToExplode) {
        if (neton     .realLocation == nil &&
            ovan      .realLocation == nil &&
            oldGuard  .realLocation == nil &&
            youngGuard.realLocation == nil &&
            assistant .realLocation == nil) {
          "Stop clowning around. You have no reason to set off
            an explosion now. ";
        }
        else {
          sayForArt('You activate the overload circuit. 
            You<./s>ve got about two minutes. ');
          isSetToExplode = true;
          explosionCountdown = 2;
        }
      }
      else {
        sayForArt('Gingerly, you switch off the overload
          function. ');;
        isSetToExplode = nil;
      }
    }
  }
  explosionKillsPcMsg = '<.moments>The disrupter explodes,
    putting out a tremendous wave of energy.
    Quite tremendous.<./moments> '
  seeExplosionMsg = 'you see a blinding explosion of light.
    Instantly you shield your eyes, as
    a concussive blast echoes through the building. '
  hearExplosionMsg = '<.moments>Somewhere close by,
    you hear the sound of an exploding photonic disrupter.<./moments> '
  isSetToExplode = nil
  explosionCountdown = 2
  //daemon { // a pseudo-daemon
  //  if (!isSetToExplode)
  //    return;
  //  if (explosionCountdown == 0) {
  //    explode;
  //  }
  //  explosionCountdown--;
  //}
  //explode {
  //  local aliensNearExplosion = [];
  //  local selfX, selfY, pcharX, pcharY;
  //  local dirStr = nil;
  //  for (local cur = firstObj(Alien); cur != nil; 
  //       cur = nextObj(cur,Alien)) {
  //    if (cur.isNearForExplosion(self)) {
  //      aliensNearExplosion += cur;
  //      doShootResult(cur, kill);
  //    }
  //  }
  //  if (gPlayerChar.isNearForExplosion(self)) {
  //    say(explosionKillsPcMsg);
  //    endGame(ftDeath);
  //  }
  //  else if (gPlayerChar.getOutermostRoom.canGlimpse(self.getOutermostRoom)) {
  //    pcharX = gPlayerChar.getOutermostRoom.absoluteXValue;
  //    pcharY = gPlayerChar.getOutermostRoom.absoluteYValue;
  //    selfX = self.getOutermostRoom.absoluteXValue;
  //    selfY = self.getOutermostRoom.absoluteYValue;
  //    if (pcharY < selfY) dirStr = 'off to the south';
  //    else if (pcharY > selfY) dirStr = 'off to the north';
  //    else if (pcharX < selfX) dirStr = 'off to the east';
  //    //else if (pcharX > selfX) dirStr = 'off to the west';
  //    else dirStr = 'off to the west';
  //    "<<artHtml1>>\^<<dirStr>>, <<seeExplosionMsg>><<artHtml2>>";
  //    if (aliensNearExplosion.length) {
  //      //"<p>\^<<dirStr>>, ";
  //      //simpleLister(aliensNearExplosion, &theName);
  //      //" <<aliensNearExplosion.length == 1 ? 'is' : 'are'>> 
  //      //  now lying dead on the floor. ";
  //      "<p>After the dust settles, you notice that ";
  //      simpleLister(aliensNearExplosion, &theName);
  //      " <<aliensNearExplosion.length == 1 ? 'is' : 'are'>> 
  //        now lying dead <<dirStr>>. ";
  //    }
  //  }
  //  else {
  //    say(hearExplosionMsg);
  //  }
  //  //local k = inputManager.getKey(nil, nil);
  //  //if (k == 'q') {k=0;k=k/k; }
  //  // Wait until the end to get rid of this weapon, as we need to 
  //  // pay attention to its location above.
  //  isSetToExplode = nil;
  //  moveInto(nil);
  //}
  zapT = transform(self, phoonicDisruper)
  zapAry = die(
    transformUnsimulated('an opportunistic herd')
        + 'This particular herd is composed of about a hundred 
        Zdadi mountain antelopes, so many that the room is
        suddenly starting to seem very crowded. 
      <p>Zdadi mountain antelopes are usually content
        just to eat grass and leaves, but they prefer
        the taste of flesh, and will hunt down prey if
        the right opportunity presents itself.
      <p>This is just such an opportunity. '
    , 'opportunistic herd', self, killEverybodyInRoom
  )
;
modify Thing
  isNearForExplosion(obj) {
    if (!obj || !getOutermostRoom || !obj.getOutermostRoom)
      return nil;
    // If we're in the same room as an exploding thing, we're
    // going to be susceptible to its explosion.
    if (getOutermostRoom == obj.getOutermostRoom)
      return true;
    // If a room boundary **only just barely** separates us from
    // an exploding thing, we will still be susceptible to the explosion.
    // E.g., if we're in the southernmost part of the museum,
    // and the exploding thing is in the northernmost part of the room
    // just south of the museum, then we're susceptible.
    if (getOutermostRoom.isInFishCorridor 
        && obj.getOutermostRoom.isInFishCorridor 
        && absVal(absoluteYValue - obj.absoluteYValue) <= 50)
      return true;
    // Otherwise, we're not near the exploding thing.
    return nil;
  }
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: missileLauncher
// -------------------------------------------------------------------

class CounterpointObject: Immovable
  // In addition to Strange Thing handling, we need to make sure 
  // that all Counterpoint objects cannot be taken.
  cannotTakeImmovableMsg = (artHtml1 + 'That<./s>s hardly portable. ' + artHtml2)
  cannotMoveImmovableMsg = (artHtml1 + playerActionMessages.cannotMoveImmovableMsg + artHtml2)
  cannotPutImmovableMsg  = (artHtml1 + playerActionMessages.cannotPutImmovableMsg  + artHtml2)
  // parsing stuff
  parseFailMsg = 'That<./s>s not a verb I recognize. '
  objParseList = [UseAction]
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         =true // acts like examine
  dLookIn       ='You find nothing of interest. '
  dSearch       =true // acts exactly like LookIn
  dLookUnder    ='You find nothing of interest. '
  dLookBehind   ='I only understood you as far as wanting to look. '
  dLookThrough  ='You find nothing of interest. '
  dListenTo     ='You hear nothing unexpected. '
  dSmell        ='You smell nothing unexpected. '
  dTaste        ='You taste nothing unexpected. '
  dFeel         ='You feel nothing unexpected. '
  dTake         ='Taken. '
  dTakeAlr      ='You already have that. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Dropped. '
  dDropAlr      ='{The dobj/him} is already here. ' // BAD
  dPutIn        ='You put {the dobj/him} into {the iobj/him}. '
  dPutInAlr     ='{The dobj/him} is already here. ' // BAD
  iPutIn        ='That can<./s>t contain things. '
  dPutOn        ='You put {the dobj/him} on {the iobj/him}. '
  dPutOnAlr     ='{The dobj/him} is already here. ' // BAD
  iPutOn        ='Putting things on {the iobj/him} would achieve nothing. '
  dPutUnder     ='I didn<./s>t understand that sentence. '
  dPutUnderAlr  ='{The dobj/him} is already here. ' // BAD
  iPutUnder     ='I didn<./s>t understand that sentence. '
  dPutBehind    ='I didn<./s>t understand that sentence. '
  dPutBehindAlr ='{The dobj/him} is already here. ' // BAD
  iPutBehind    ='I didn<./s>t understand that sentence. '
  dWear         ='You can<./s>t wear that! '
  dDoff         ='You<./s>re not wearing that. '
  dKiss         ='You can only do that to something animate. '
  dAsk     /*!*/='You can only do that to something animate. '
  dAskFor       ='You can only do that to something animate. '
  dAskAbout     ='You can only do that to something animate. '
  dTell    /*!*/='You can only do that to something animate. '
  dTellAbout    ='You can only do that to something animate. '
  dTalkTo       =nil
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='You can only do that to something animate. '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='You can only do that to something animate. '
  dFollow       =nil
  dHit          ='Violence isn<./s>t the answer to this one. '
  dHitWith      ='I only understood you as far as wanting to attack {the dobj/him}. '
  iHitWith      ='I only understood you as far as wanting to attack {the dobj/him}. '
  dAttack       ='Violence isn<./s>t the answer to this one. '
  dAttackWith   ='I only understood you as far as wanting to attack {the dobj/him}. '
  iAttackWith   ='I only understood you as far as wanting to attack {the dobj/him}. '
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='I only understood you as far as wanting to throw {the dobj/him}. '
  dDig     /*!*/='Digging would achieve nothing here. '
  dDigWith      ='I only understood you as far as wanting to dig {the dobj/him}. '
  iDigWith      ='I only understood you as far as wanting to dig {the dobj/him}. '
  dJumpOver     ='You would achieve nothing by this. '
  dJumpOff      ='I only understood you as far as wanting to jump. '
  dPush         ='Nothing obvious happens. '
  dPull         ='Nothing obvious happens. '
  dMove         ='Nothing obvious happens. '
  dMoveWith     ='You can<./s>t see any such thing. '
  iMoveWith     ='You can<./s>t see any such thing. '
  dMoveTo       ='You can<./s>t see any such thing. '
  iMoveTo       ='You can<./s>t see any such thing. '
  dTurn         ='Nothing obvious happens. '
  dTurnWith     ='I only understood you as far as wanting to turn {the dobj/him}. '
  iTurnWith     ='I only understood you as far as wanting to turn {the dobj/him}. '
  dTurnTo       ='I only understood you as far as wanting to turn {the dobj/him}. '
  dConsult      ='I didn<./s>t understand that sentence. '
  dConsultAbout ='You discover nothing of interest in {the dobj/him}. '
  dSetTo        ='No you can<./s>t set that to anything. '
  dTypeOn       =true
  dTypeLiteralOn=true
  dEnterOn      =true
  //dTypeOn       =nil
  //dTypeLiteralOn=nil
  //dEnterOn      ='You can<./s>t see any such thing. '
  dSwitch       ='That<./s>s not something you can switch. '
  dFlip         =nil
  dTurnOn       ='That<./s>s not something you can switch. '
  dTurnOff      ='That<./s>s not something you can switch. '
  dLight        ='This dangerous act would achieve little. '
  dStrike       =nil
  dBurn    /*!*/='This dangerous act would achieve little. '
  dBurnWith     ='I only understood you as far as wanting to burn {the dobj/him}. '
  iBurnWith     ='I only understood you as far as wanting to burn {the dobj/him}. '
  dExtinguish   ='I didn<./s>t understand that sentence. '
  dAttach  /*!*/='You would achieve nothing by this. '
  dAttachTo     ='You would achieve nothing by this. '
  iAttachTo     ='You would achieve nothing by this. '
  dDetach       =nil
  dDetachFrom   =nil
  iDetachFrom   =nil
  dBreak        ='Violence isn<./s>t the answer to this one. '
  dCut     /*!*/='Cutting that up would achieve little. '
  dCutWith      ='I only understood you as far as wanting to cut {the dobj/him}. '
  iCutWith      ='I only understood you as far as wanting to cut {the dobj/him}. '
  dClimb        ='I don<./s>t think much is to be achieved by that. '
  dClimbUp      ='I don<./s>t think much is to be achieved by that. '
  dClimbDown    ='I only understood you as far as wanting to climb the down. '
  dOpen         ='That<./s>s not something you can open. '
  dClose        ='That<./s>s not something you can close. '
  dLock         ='That doesn<./s>t seem to be something you can lock. '
  dLockWith     ='That doesn<./s>t seem to be something you can lock. '
  iLockWith     ='That doesn<./s>t seem to fit the lock. '
  dUnlock       ='That<./s>s unlocked at the moment. '
  dUnlockWith   ='That<./s>s unlocked at the moment. '
  iUnlockWith   ='That doesn<./s>t seem to fit the lock. '
  dEat          ='That<./s>s plainly inedible. '
  dDrink        ='There<./s>s nothing suitable to drink here. '
  dPour         =nil
  dPourInto     =nil
  iPourInto     =nil
  dPourOnto     =nil
  iPourOnto     =nil
  dClean        ='You achieve nothing by this. '
  dCleanWith    ='I only understood you as far as wanting to clean {the dobj/him}. '
  iCleanWith    ='I only understood you as far as wanting to clean {the dobj/him}. '
  dSitOn        ='That<./s>s not something you can sit down on. '
  dLieOn        ='That<./s>s not something you can lie down on. '
  dStandOn      ='That<./s>s not something you can stand on. '
  dBoard        =nil
  dGetOutOf     ='I only understood you as far as wanting to exit. '
  dGetOffOf     ='But you aren<./s>t on {the dobj/him} at the moment. '
  dFasten       ='You would achieve nothing by this. '
  dFastenTo     ='You would achieve nothing by this. '
  iFastenTo     ='You would achieve nothing by this. '
  dUnfasten     =nil
  dUnfastenFrom =nil
  iUnfastenFrom =nil
  dPlugIn       =nil
  dPlugInto     =nil
  iPlugInto     =nil
  dUnplug       =nil
  dUnplugFrom   =nil
  iUnplugFrom   =nil
  dScrew        ='Nothing obvious happens. '
  dScrewWith    ='I only understood you as far as wanting to screw {the dobj/him}. '
  iScrewWith    ='I only understood you as far as wanting to screw {the dobj/him}. '
  dUnscrew      ='Nothing obvious happens. '
  dUnscrewWith  ='I only understood you as far as wanting to unscrew {the dobj/him}. '
  iUnscrewWith  ='I only understood you as far as wanting to unscrew {the dobj/him}. '
  dGoThrough    ='That<./s>s not something you can enter. '
  dEnter        ='That<./s>s not something you can enter. '
  dPushTravel   ='Is that the best you can think of? '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
  //dobjFor(Use) {
  //  verify { }
  //  check {
  //    "<.counter>You<./s>ll have to say how you want to use 
  //      that.<./counter> ";
  //    exit;
  //  }
  //}
  dobjFor(TypeOn) {
    verify {
      if (gDobj && !launcherKeypad.isIn(missileLauncher))
        illogicalNow('<.counter>Now that the missile launcher is lacking a keypad,
          it<./s>s hard to see how you can interact with it. <./counter>');
      else if (gDobj && !launcherDisplay.isIn(missileLauncher))
        illogicalNow('<.counter>You try pushing a few buttons on the keypad,
          but it<./s>s no use. Now that the missile launcher is lacking
          a display, you can<./s>t seem to interact with it. <./counter>');
    }
    check { }
    action {
      launcherKeypad.executeInput;
    }
  }
  dobjFor(Use) asDobjFor(TypeOn)
  //dobjFor(Use) {
  //  verify { }
  //  check { }
  //  action {
  //    launcherKeypad.executeInput;
  //  }
  //}
  dobjFor(TurnOn) asDobjFor(TypeOn)
  dobjFor(TypeLiteralOn) asDobjFor(TypeOn)
  dobjFor(EnterOn) asDobjFor(TypeOn)
  //dobjFor(Fire) asDobjFor(TypeOn) // not sure why I put this in. Apparently there's no FireAction.
  dobjFor(ShootAimlessly) asDobjFor(TypeOn)
  iobjFor(ShootWith) asDobjFor(TypeOn)
  dobjFor(Shoot) {
    action() {
      // If the actor is NOT holding a gun, let SHOOT LAUNCHER 
      // be interpreted as FIRE LAUNCHER. 
      // If the actor IS holding a gun, let SHOOT LAUNCHER
      // be interpreted as SHOOT LAUNCHER WITH SOMETHING, just like
      // any generic thing.
      // 
      // Note that this way of testing for the actor's holding
      // a gun is somewhat crude, but it should be good enough.
      if (!gActor.contents.indexWhich({x: x.ofKind(Gun)}))
        replaceAction(ShootAimlessly, gDobj);
      else
        inherited();
    }
  }
  //dobjFor(Use) asDobjFor(TypeOn)
  /*
  So, the relevant verbs here are: 
  TypeOn, TypeLiteralOn, EnterOn, Use, TurnOn
  */
;

//class CounterpointImmovable: Immovable
//  cannotTakeImmovableMsg = (artHtml1 + 'That<./s>s hardly portable. ' + artHtml2)
//  cannotMoveImmovableMsg = (artHtml1 + playerActionMessages.cannotMoveImmovableMsg + artHtml2)
//  cannotPutImmovableMsg  = (artHtml1 + playerActionMessages.cannotPutImmovableMsg  + artHtml2)
//;

missileLauncher: CounterpointObject, Artifact
  // is listed in room descriptions?
  isListed = nil
  // is listed when direct container is examined or looked in?
  isListedInContents = true
  // is listed in inventory?
  isListedInInventory = nil
  // Since this is an artifact from a fictitious game, we don't need
  // to give credit to the game's author.
  isListedInCredits = nil
  vocabWords='missile rocket artillery graffiti/graffito/cannon/launcher/weapon/artifact*weapons*artifacts'
  name      ='missile launcher'
  nickname  ='missile launcher'
  artTitle  ='Counterpoint'
  artAuthor ='Keith Sloan'
  artCompany=''
  artComp   =''
  artYear   ='2041'
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.counter>'
  artHtml2  ='<./counter>'
  artDesc {
    "The machine consists of two man-size steel pillars, 
      plus an angled cylinder that points to the sky. ";
    if (launcherKeypad.isIn(self) && launcherDisplay.isIn(self))
      "On the side is a keypad, next to a small display panel. ";
    else if (launcherKeypad.isIn(self))
      "On the side is a keypad. ";
    else if (launcherDisplay.isIn(self))
      "On the side is a display panel. ";
    "Near the bottom of one of the pillars, someone
      has spray-painted some graffiti. ";
  }
  dobjFor(Read) {
    verify { inherited; }
    check { }
    action {
      readDesc;
    }
  }
  readDesc = "<.counter>The graffiti reads, 
    <.q><<launcherKeypad.passcode>>.<./q><./counter> "
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
;
launcherKeypad: CounterpointObject, StrangeThing
  vocabWords='(missile) (launcher) keypad keys'
  name      ='launcher keypad'
  nickname  ='keypad'
  artTitle  ='Counterpoint'
  artAuthor ='Keith Sloan'
  artCompany=''
  artComp   =''
  artYear   =''
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.counter>'
  artHtml2  ='<./counter>'
  location = missileLauncher
  desc {
    "<.counter>It has twelve keys, arranged like the digits
      on a telephone.<./counter> ";
  }
  hideFromAll(action) { return true; }
  passcode = 31569
  executeInput {
    local k, num;
    "<.counter>The launcher<./s>s display reads, 
      <.q>Please type passcode.<./q><./counter> ";
    // The PC may have just walked across the room to do this,
    // so we need to update the banner before we pause for input.
    nbmBanner.updateMe;
    for (;;) {
      "<p><.inputline>";
      "<.counter>Enter a number or type CANCEL to exit &gt;&gt;<./counter> ";
      "<./inputline>";
      k = inputManager.getInputLine(nil, nil);
      k = k.toLower;
      //local num = inputManager.getKey(nil, nil);
      //if (num.toLower == 'q') { num=0;num=num/num; }
      if (k.find('canc') || k.substr(1,1) == 'c') {
        "<.counter>You push the cancel button, then turn away from 
          the missile launcher.<./counter> ";
        state = getPasscode;
        return;
      }
      // Since my game uses qtalk.t, we can handily use one of its
      // functions.
      num = qToInteger(k);
      if (state == getPasscode ) {
        if (num == passcode) {
          "<.counter>The display says, <.q>Passcode approved. Please type
            coordinates.<./q><./counter> ";
          state = getCoordinates;
        }
        else {
          "<.counter>The display says, <.q>Invalid passcode. 
            Please type passcode.<./q><./counter> ";
        }
      }
      else { // state == getCoordinates
        if (k.length < 9 || num < 0 || num > 999999999) {
          "<.counter>The display says, <.q>Coordinates must be 
            a nine-digit number from 000000000 to 999999999.
            Please type coordinates.<./q><./counter> ";
        }
        // In this scenario, you kill yourself.
        else {
          "<.counter>The display says, <.q>Coordinates accepted.<./q>
            <p>With that, the huge barrel of the missile 
              launcher pivots a few inches, then comes
              to a stop.
            <p>Then, suddenly, an deafening blast comes
              comes from the launcher.<./counter>
            <p>After a moment of disorientation, 
              you look up just in time to see a missile
              punch a hole through the ceiling and sail 
              up to the sky.
            <p>Then there is an ominous groan, and a cracking noise,
              and finally a roar as the ceiling begins to cave in.
              Unfortunately, you do not escape the falling debris. ";
          endGame(ftDeath);
          return;
        }
      }
    }
  }
  //dTypeOn       =true
  //dTypeLiteralOn=true
  //dEnterOn      =true
  state = getPasscode
;
enum getPasscode, getCoordinates;
launcherDisplay: CounterpointObject, StrangeThing
  vocabWords='(missile) (launcher) display panel'
  name      ='launcher display'
  nickname  ='display'
  artTitle  ='Counterpoint'
  artAuthor ='Keith Sloan'
  artCompany=''
  artComp   =''
  artYear   =''
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.counter>'
  artHtml2  ='<./counter>'
  location = missileLauncher
  desc {
    "<.counter>The launcher display currently reads:
      <.q>Please type passcode.<./q><./counter> ";
  }
  hideFromAll(action) { return true; }
  //dTypeOn       =true
  //dTypeLiteralOn=true
  //dEnterOn      =true
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Guns/Artifacts: tRemovingGun classes and objects
// -------------------------------------------------------------------

// a mix-in class for the T-removing gun and the removing gun.

class RGun: object
  artDesc {
    "This is a bulky, odd-looking gun, made of smooth, black metal.
      On the side are etched the words, <.q><<etchedWords>><./q> ";
  }
  shootPrefixMsg(obj, complex) { 
    return 'The gun fires a loud pulse, 
      discharging a bolt of plasma'
      + throughMsg(' which passes through the ','',obj,complex) + '. ';
  }
  //shootAtPcPrefixMsg = 'The gun fires a loud pulse, 
  //  and a bolt of plasma goes flying toward you. '
  shootFriendMsg =
    (shootPrefixMsg(gDobj, true) + 'The bolt misses {the dobj/him}. ')
  letsActorShootHimself = true
  shootingOneselfWithThisIsDeadly = nil
  shootEffectThing {
    sayForArt(shootPrefixMsg(gDobj, true));
    //sayForArt(shootThingMsg(gDobj));
    doShootResult(gDobj, defaultShootResult);
  }
  beamWord = 'bolt'
;

tRemovingGun: RGun, ArtifactGun
  vocabWords='odd odd-looking t t-removing t-remover removing remover gun/firearm/weapon/trigger/artifact*guns*firearms*weapons*triggers*artifacts'
  name      ='T-removing gun'
  nickname  ='T-removing gun'
  artTitle  ='Leather Goddesses Zero: Dawn of the Goddesses'
  artAuthor ='Bradley Hollister'
  artCompany=''
  artComp   =''
  artYear   ='2055'
  artAttr   ='a'
  artAttrib ='aa'
  artHtml1  ='<.leather>'
  artHtml2  ='<./leather>'
  //artDesc {
  //  "This is an odd-looking rifle, made of smooth, black metal.
  //    On the side are etched the words, <.q><<etchedWords>><./q> ";
  //}
  etchedWords = 
    'LA-3890 T-Removing Gun. Leckbandi Armaments, 704 Interamnia.'
  plqDesc() {
    "This is the <<nickname>> from <<artTitle>>. ";
    recognized = true;
  }
  // Since this is an artifact from a fictitious game, we don't need
  // to give credit to the game's author.
  isListedInCredits = nil
  // parsing stuff
  parseFailMsg = 'That<./s>s not a verb I recognize. '
  objParseList = []
  // "d" and "i" methods
  dExamine      =true // shows desc
  dRead         =true // acts like examine
  dLookIn       ='You find nothing of interest. '
  dSearch       =true // acts exactly like LookIn
  dLookUnder    ='You find nothing of interest. '
  dLookBehind   ='I only understood you as far as wanting to look. '
  dLookThrough  ='You find nothing of interest. '
  dListenTo     ='You hear nothing unexpected. '
  dSmell        ='You smell nothing unexpected. '
  dTaste        ='You taste nothing unexpected. '
  dFeel         ='You feel nothing unexpected. '
  dTake         ='Taken. '
  dTakeAlr      ='You already have that. '
  dRemove  /*!*/=true // for non-clothing, acts like Take
  dTakeFrom     =true // if successful, acts like Take
  dDrop         ='Dropped. '
  dDropAlr      ='{The dobj/him} is already here. ' // BAD
  dPutIn        ='You put {the dobj/him} into {the iobj/him}. '
  dPutInAlr     ='{The dobj/him} is already here. ' // BAD
  iPutIn        ='That can<./s>t contain things. '
  dPutOn        ='You put {the dobj/him} on {the iobj/him}. '
  dPutOnAlr     ='{The dobj/him} is already here. ' // BAD
  iPutOn        ='Putting things on {the iobj/him} would achieve nothing. '
  dPutUnder     ='I didn<./s>t understand that sentence. '
  dPutUnderAlr  ='{The dobj/him} is already here. ' // BAD
  iPutUnder     ='I didn<./s>t understand that sentence. '
  dPutBehind    ='I didn<./s>t understand that sentence. '
  dPutBehindAlr ='{The dobj/him} is already here. ' // BAD
  iPutBehind    ='I didn<./s>t understand that sentence. '
  dWear         ='You can<./s>t wear that! '
  dDoff         ='You<./s>re not wearing that. '
  dKiss         ='You give {the dobj/him} a kiss. '
  dAsk     /*!*/='{The dobj/he} makes no response. '
  dAskFor       ='{The dobj/he} makes no response. '
  dAskAbout     ='{The dobj/he} makes no response. '
  dTell    /*!*/='{The dobj/he} makes no response. '
  dTellAbout    ='{The dobj/he} makes no response. '
  dTalkTo       =nil
  dGive    /*!*/=true // asks for iobj
  dGiveTo       =true // no special action; handled by iGiveTo
  iGiveTo       ='{The dobj/he} makes no response. '
  dShow    /*!*/=true // asks for iobj
  dShowTo       =true // no special action; handled by iShowTo
  iShowTo       ='{The dobj/he} makes no response. '
  dFollow       =nil
  dHit          ='No, no. You wouldn<./s>t want {the dobj/him} to jam up during combat. '
  dHitWith      ='No, no. You wouldn<./s>t want {the dobj/him} to jam up during combat. '
  dAttack       ='No, no. You wouldn<./s>t want {the dobj/him} to jam up during combat. '
  dAttackWith   ='No, no. You wouldn<./s>t want {the dobj/him} to jam up during combat. '
  //iHitWith      ='I only understood you as far as wanting to attack {the dobj/him}. '
  //iAttackWith   ='I only understood you as far as wanting to attack {the dobj/him}. '
  iHitWith      =true
  iAttackWith   =true
  dThrow   /*!*/=true // asks for iobj
  dThrowAt      =true // calls processThrow method; or override this.
  iThrowAt      =true // no action; anything can be a target
  dThrowTo      =true // calls processThrow method; or override this.
  iThrowTo      ='I only understood you as far as wanting to throw {the dobj/him}. '
  dDig     /*!*/='Digging would achieve nothing here. '
  dDigWith      ='I only understood you as far as wanting to dig {the dobj/him}. '
  iDigWith      ='I only understood you as far as wanting to dig {the dobj/him}. '
  dJumpOver     ='You would achieve nothing by this. '
  dJumpOff      ='I only understood you as far as wanting to jump. '
  dPush         ='Nothing obvious happens. '
  dPull         ='Nothing obvious happens. '
  dMove         ='Nothing obvious happens. '
  dMoveWith     ='You can<./s>t see any such thing. '
  iMoveWith     ='You can<./s>t see any such thing. '
  dMoveTo       ='You can<./s>t see any such thing. '
  iMoveTo       ='You can<./s>t see any such thing. '
  dTurn         ='Nothing obvious happens. '
  dTurnWith     ='I only understood you as far as wanting to turn {the dobj/him}. '
  iTurnWith     ='I only understood you as far as wanting to turn {the dobj/him}. '
  dTurnTo       ='I only understood you as far as wanting to turn {the dobj/him}. '
  dConsult      ='I didn<./s>t understand that sentence. '
  dConsultAbout ='You discover nothing of interest in {the dobj/him}. '
  dSetTo        ='No you can<./s>t set that to anything. '
  dTypeOn       =nil
  dTypeLiteralOn=nil
  dEnterOn      ='You can<./s>t see any such thing. '
  dSwitch       ='That<./s>s not something you can switch. '
  dFlip         =nil
  dTurnOn       ='That<./s>s not something you can switch. '
  dTurnOff      ='That<./s>s not something you can switch. '
  dLight        ='This dangerous act would achieve little. '
  dStrike       =nil
  dBurn    /*!*/='This dangerous act would achieve little. '
  dBurnWith     ='I only understood you as far as wanting to burn {the dobj/him}. '
  iBurnWith     ='I only understood you as far as wanting to burn {the dobj/him}. '
  dExtinguish   ='I didn<./s>t understand that sentence. '
  dAttach  /*!*/='You would achieve nothing by this. '
  dAttachTo     ='You would achieve nothing by this. '
  iAttachTo     ='You would achieve nothing by this. '
  dDetach       =nil
  dDetachFrom   =nil
  iDetachFrom   =nil
  dBreak        ='Violence isn<./s>t the answer to this one. '
  dCut     /*!*/='Cutting that up would achieve little. '
  dCutWith      ='I only understood you as far as wanting to cut {the dobj/him}. '
  iCutWith      ='I only understood you as far as wanting to cut {the dobj/him}. '
  dClimb        ='I don<./s>t think much is to be achieved by that. '
  dClimbUp      ='I don<./s>t think much is to be achieved by that. '
  dClimbDown    ='I only understood you as far as wanting to climb the down. '
  dOpen         ='That<./s>s not something you can open. '
  dClose        ='That<./s>s not something you can close. '
  dLock         ='That doesn<./s>t seem to be something you can lock. '
  dLockWith     ='That doesn<./s>t seem to be something you can lock. '
  iLockWith     ='That doesn<./s>t seem to fit the lock. '
  dUnlock       ='That<./s>s unlocked at the moment. '
  dUnlockWith   ='That<./s>s unlocked at the moment. '
  iUnlockWith   ='That doesn<./s>t seem to fit the lock. '
  dEat          ='That<./s>s plainly inedible. '
  dDrink        ='There<./s>s nothing suitable to drink here. '
  dPour         =nil
  dPourInto     =nil
  iPourInto     =nil
  dPourOnto     =nil
  iPourOnto     =nil
  dClean        ='You achieve nothing by this. '
  dCleanWith    ='I only understood you as far as wanting to clean {the dobj/him}. '
  iCleanWith    ='I only understood you as far as wanting to clean {the dobj/him}. '
  dSitOn        ='That<./s>s not something you can sit down on. '
  dLieOn        ='That<./s>s not something you can lie down on. '
  dStandOn      ='That<./s>s not something you can stand on. '
  dBoard        =nil
  dGetOutOf     ='I only understood you as far as wanting to exit. '
  dGetOffOf     ='But you aren<./s>t on {the dobj/him} at the moment. '
  dFasten       ='You would achieve nothing by this. '
  dFastenTo     ='You would achieve nothing by this. '
  iFastenTo     ='You would achieve nothing by this. '
  dUnfasten     =nil
  dUnfastenFrom =nil
  iUnfastenFrom =nil
  dPlugIn       =nil
  dPlugInto     =nil
  iPlugInto     =nil
  dUnplug       =nil
  dUnplugFrom   =nil
  iUnplugFrom   =nil
  dScrew        ='Nothing obvious happens. '
  dScrewWith    ='I only understood you as far as wanting to screw {the dobj/him}. '
  iScrewWith    ='I only understood you as far as wanting to screw {the dobj/him}. '
  dUnscrew      ='Nothing obvious happens. '
  dUnscrewWith  ='I only understood you as far as wanting to unscrew {the dobj/him}. '
  iUnscrewWith  ='I only understood you as far as wanting to unscrew {the dobj/him}. '
  dGoThrough    ='That<./s>s not something you can enter. '
  dEnter        ='That<./s>s not something you can enter. '
  dPushTravel   ='Is that the best you can think of? '
  dShoot        =true // asks for iobj (if not a weapon)
  dShootAimless =true // '{You/he} cannot shoot anything with that. '
  dShootWith    =true // nothing special; handled by iShootWith
  iShootWith    =true // '{You/he} cannot shoot anything with that. '
  // miscellaneous behavior
  //defaultShootResult = removeT
  defaultShootResult {
    if (doPlanA)
      return removeT;
    else
      return removeT2;
  }
  //defaultShootResult = removeT
  //shootEffectThing {
  //  sayForArt(shootPrefixMsg(gDobj, true));
  //  sayForArt(shootThingMsg(gDobj));
  //  doShootResult(gDobj, defaultShootResult);
  //}
  shootThingMsg(obj) {
    gMessageParams(obj);
    return '{The obj/he} seem{s} unaffected. ';
  }
  actorShootingHimselfMsg =
    (shootPrefixMsg(gDobj, nil) + artHtml2 + shootThingMsg(gActor) + artHtml1)
  shootEffectMirror {
    // If the gun shoots bullets, treat the mirror as any ordinary
    // thing.
    if (tangibleProjectiles) {
      shootEffectThing;
    }
    // Otherwise, if the gun's projectiles are more laser-like than
    // bullet-like, treat the mirror as a reflective object that
    // will cause the gun to shoot itself.
    else {
      sayForArt(shootPrefixMsg(gDobj, nil));
      sayForArt(mirrorBounceMsg);
//      // Note that the argument for shootThingMsg is self, i.e. gIobj,
//      // rather than gDobj, because the gun is shooting itself.
//      sayForArt(shootThingMsg(self));
      // Again, note that the first argument is self, i.e. gIobj, 
      // rather than the usual gDobj.
      doShootResult(self, defaultShootResult);
    }
  }
  askFirstProp = &askT
  rememberShootingAttempt() {
    tRemoverAchievement1.setVisible();
    tRemoverAchievement2.setVisible();
  }
  zapT = transform(self, removingGun)
;

removingGun: RGun, GunThing
  'odd odd-looking removing remover gun/firearm/weapon/trigger*guns*firearms*weapons*triggers'
  'removing gun'
  desc = artDesc
  artHtml1 = ''
  artHtml2 = ''
  etchedWords = 
    'ZIA-4732 Removing Gun. Zdadi Imperial Armaments, 18 Scorpii II.'
  defaultShootResult = vaporize
  shootingOneselfWithThisIsDeadly = true
  actorShootingHimselfMsg =
    (shootPrefixMsg(gDobj, nil) + 'The next moment, you cease to exist. ')
  shootEffectThing {
    sayForArt(shootPrefixMsg(gDobj, true));
    if (gDobj.canBeVaporized) {
      say('{The dobj/he} disappear{s}! ');
      doShootResult(gDobj, vaporize);
    }
    else {
      say(gDobj.fireRemoverNoEffectMsg);
      //say('You keep firing bolt after bolt of plasma, but
      //  {the dobj/he} just sit{s} there. Perhaps {it dobj/he} {is}
      //  too big to be affected. ');
    }
    //doShootResult(gDobj, defaultShootResult);
  }
  shootEffectMirror {
    // If the gun shoots bullets, treat the mirror as any ordinary
    // thing.
    if (tangibleProjectiles) {
      shootEffectThing;
    }
    // Otherwise, if the gun's projectiles are more laser-like than
    // bullet-like, treat the mirror as a reflective object that
    // will cause the gun to shoot itself.
    else {
      sayForArt(shootPrefixMsg(gDobj, nil));
      sayForArt(mirrorBounceMsg);
      say('The removing gun disappears! ');
      //sayForArt('{The iobj/he} disappear{s}! ');
      // Again, note that the first argument is self, i.e. gIobj, 
      // rather than the usual gDobj.
      doShootResult(self, defaultShootResult);
    }
  }
;

// -------------------------------------------------------------------
// GUNS AND SHOOTING: Additional weapon modifications
// -------------------------------------------------------------------

// DIAGRAM OF CLASS INHERITANCE OF ALL WEAPONS AND ARTIFACTS
// 
//        NpcPossession                             Thing
//              |                                     |
//            Weapon                                  |
//           /      \                                 |
// MeleeWeapon      RangeWeapon                  StrangeThing
//   |          ___/           \                      |
//   | Thing   |                Gun                   |
//   |  |      | Thing   ______/ | \_______           |
// Icepick     |  |     /        |         \       Artifact
//   |         |  |    |         | BagObj   |      /      \
// (netonI)  (dagger)  | Thing   | StrangeT |     /        \
// (ovanI)             |  |      |  |       |    |          |
//                  GunThing     |  |     ArtifactGun       |
//    _____________/   |         |  |         |             |
//   |                 |       (rayGun)   (shotgun)       (explosive)
// HandCannon          |                  (phaser)        (dispenser)
//   |                 |                  (handgun)       (crystal)
// (oldGuardHC)     (removingGun)         (laser)         (xenite)
// (youngGuardHC)   (paricleGun)          (particleGun)   (missileLauncher)
//                                        (aryUng)
//                                        (pulseGun)
//                                        (electricPistol)
//                                        (silencedPistol)
//                                        (disrupter)
//                                        (tRemovingGun)

modify Thing
  isNewToNpc = nil
;

modify Weapon
  asscNpc {
    local loc = location;
    while (loc != nil) {
      if (loc.ofKind(Npc))
        return loc;
      loc = loc.location;
    }
    return tokenAlien;
  }
;
modify Weapon
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> 
      aims <<theName>> straight at you. ";
  }
  deathParagraph(extra, bothGuards) {
    "Unfortunately for you, he hits dead-on. ";
  }
  reportNpcMiss(stat, bothGuards) {
    "Fortunately for you, he misses<<byWhatMargin(stat)>>. ";
  }
  reportNoNpcAmmo {
    "He pulls the trigger, but apparently <<theName>>
      is out of ammo. ";
  }
  slowedAssaultSentence {
    suddenRangeAttackParagraph('with calm deliberation, ', nil);
  }
  assaultingYouDesc {
    "aiming <<theName>> straight at you. ";
  }
  rangeAttackSomehowSucceeds {
    deathParagraph(true, nil);
  }
  
  byWhatMargin(stat) {
    switch (stat) {
      case wideMiss: return ' by a wide margin';
      case mediumMiss: return ' by only a couple of feet';
      case narrowMiss: return rand(' by a hair',' by only a fraction of an inch');
      default: return '';
    }
  }
  sayForNpcMiss(stat, str1, str2, str3) {
    switch (stat) {
      case narrowMiss: return str3;
      case mediumMiss: return str2;
      default: return str1;
    }
  }
;

tokenAlien: Alien
  name = 'alien'
  isHim = true
  killPcAmusingly {
    "<.p>Later that evening, when it<./s>s all over, 
        the alien will regale his buddies with the 
        story of how he killed you. His buddies will 
        clap him on the back and buy him another beer. ";
  }
;

modify Weapon
  // For any weapons that are *always* ineffectual at killing,
  // set this to nil.
  canKillSometimes = true
  // In most cases you can't tell how deadly a gun is just by 
  // firing and missing. For any exceptional cases where merely 
  // firing a gun reveals its shoddiness as a weapon, set this
  // to true.
  missingRevealsShoddiness = nil
  // canKillNow() returns true if this is a weapon that
  // (1) can kill you when you're within range, and
  // (2) is not out of ammo. 
  // 
  // Since ammo is not a consideration for non-Gun weapons,
  // canKillNow always equals canKillSometimes by default.
  canKillNow = (canKillSometimes)
  // If an NPC kills you with this weapon, what finish type
  // will you get?
  asscFinishType = ftDeath
;

modify RangeWeapon
  isNewToNpc = true
;

modify Gun
  // canKillNow() returns true if this is a gun that
  // (1) can kill you when you're within range, and
  // (2) is not out of ammo. 
  canKillNow {
    if (!canKillSometimes)
      return nil;
    if (ammo <= 0)
      return nil;
    return true;
  }
;

// *************************************************
// *************************************************
// ***   DO NOT MODIFY THE HAND CANNONS!!!!!!    ***
// *************************************************
// *************************************************
// ***   Do not modify the hand cannons or any 
// ***   other item for which isEquivalent
// ***   is supposed to be true.
// ***   **Modifying "equivalent" objects
// ***   breaks their equivalency!**
// *************************************************
// *************************************************

//// 15
//modify oldGuardHandCannon
//  
//;
//// 16
//modify youngGuardHandCannon
//  
//;

// 9
modify pulseGun
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> raises <<theName>> and fires. ";
  }
  deathParagraph(extra, bothGuards) {
    sayForArt('A pulse crackles towards you, and this time
      the aim is precise. ');
    //sayForArt('The shot that issues from the gun is 
    //  astonishingly well-aimed. ');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt(sayForNpcMiss(stat,
       'A pulse ' + rand('splashes', 'crackles') + ' on the '
        + rand('ceiling', 'wall') + ' some distance away. '
      ,'A pulse streams up the corridor at you, missing by
        only a couple of feet. '
      ,'A shot slashes right by your head. '
    ));
  }
  // This weapon never runs out of ammo.
  // reportNoNpcAmmo { }
  // slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "aiming <<theName>> straight at you and opening fire. ";
  }
;
// 5
modify particleGun
  suddenRangeAttackParagraph(str, bothGuards) {
    sayForArt('\^' + str + asscNpc.theName + ' pulls the trigger 
      of the particle gun. ');
  }
  deathParagraph(extra, bothGuards) {
    sayForArt('The gun powers up with a whine 
      and then a beam of bright white light flashes 
      from the front of the gun and hits you, 
      quickly burning your flesh. You stagger, 
      collapse to the floor, and writhe in agony 
      for several long seconds, until finally 
      you lose consciousness. ');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt('A bolt of plasma flies by you, missing' 
      + byWhatMargin(stat) + '. ');
  }
  // This weapon never runs out of ammo.
  //reportNoNpcAmmo { }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "aiming the particle gun at you and pulling the trigger. ";
  }
;

// 12
modify disrupter
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> raises <<theName>> and fires. ";
  }
  deathParagraph(extra, bothGuards) {
    sayForArt('A burst of plasma issues from the gun. You throw 
      up your hands in self defense. The plasma blast strikes you 
      full on.');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt('A burst of plasma issues from the gun. ' + 
      sayForNpcMiss(stat,
        'Fortunately, it doesn<./s>t come anywhere near you. '
       ,'It misses by a couple of feet. '
       ,'You have to leap out of the way of the plasma bolt. '
      )
    );
  }
  // This weapon never runs out of ammo.
  //reportNoNpcAmmo { }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "aiming <<theName>> straight at you and opening fire. ";
  }
;
// 14
modify removingGun
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> raises <<theName>> and fires. ";
  }
  deathParagraph(extra, bothGuards) {
    sayForArt('A bolt of plasma hits you, and you are no more. ');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt('A bolt of plasma flies by you, missing you' 
      + byWhatMargin(stat) + '. ');
  }
  // This weapon never runs out of ammo.
  //reportNoNpcAmmo { }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "aiming <<theName>> straight at you and opening fire. ";
  }
  asscFinishType = ftRemoved
;
ftRemoved: FinishType
  finishMsg = 'You have been removed'
;
// 11
modify silencedPistol
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> carefully aims <<theName>> 
      straight at you. ";
  }
  deathParagraph(extra, bothGuards) {
    sayForArt('The bullet tears through you and you<./s>re 
      dead before you hit the ground. ');
  }
  reportNpcMiss(stat, bothGuards) {
    if (stat == narrowMiss)
      sayForArt('The bullet whizzes by you, just inches 
        from your ' + rand('head','face','body') 
        + ', and imbeds itself into the wall. ');
    else
      sayForArt('The bullet misses you' + byWhatMargin(stat)
        + ' and imbeds itself into the wall. ');
  }
  reportNoNpcAmmo {
    sayForArt('He pulls the trigger, but his pistol 
      is out of ammo!');
  }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "carefully aiming <<theName>> straight at you. ";
  }
;
// 10
modify electricPistol
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> raises <<theName>>. ";
  }
  deathParagraph(extra, bothGuards) {
    sayForArt('\^' + asscNpc.theName + ' fires and hits me! ');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt('\^' + asscNpc.theName + ' fires, but misses me! ');
  }
  reportNoNpcAmmo {
    sayForArt('\^' + asscNpc.theName + ' tries to fire, 
      but the gun doesn<./s>t have any ammo left. ');
  }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "aiming <<theName>> straight at you. ";
  }
;
// 2
modify phaser
  //validSettings = ['stun', 'destroy']
  //curSetting = 'stun'
  suddenRangeAttackParagraph(str, bothGuards) {
    // "\^<<str>>"; // ignore "str" for this one
    if (curSetting != 'destroy') {
      sayForArt('\^' + asscNpc.theName + ' sets the Phaser, <br>');
      makeSetting('destroy');
    }
    sayForArt('\^' + asscNpc.theName + ' fires the Phaser, <br>');
  }
  deathParagraph(extra, bothGuards) {
    sayForArt('He destroyed me! ');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt('He missed! <p>');
  }
  reportNoNpcAmmo {
    sayForArt('Nothing happens <br>Its empty. <p>');
  }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "firing <<theName>> straight at you. <p>";
  }
  asscFinishType = ftScottAdams
;
// 1
modify shotgun
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> aims <<theName>> at you. ";
  }
  deathParagraph(extra, bothGuards) {
    sayForArt('BLAM! YOU ARE LIFTED AND THROWN BACKWARDS 
      BY THE IMPACT OF THE BLAST. ');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt('BLAM! HE MISSES. ');
  }
  reportNoNpcAmmo {
    sayForArt('CLICK. ');
  }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "aiming <<theName>> straight at you. ";
  }
;
// 3
modify handgun
  // this gun is *never* deadly
  canKillSometimes = nil
  // In fact, this gun is so shoddy that you can tell just by
  // firing it that it couldn't ever kill anybody.
  missingRevealsShoddiness = true
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> raises <<theName>> and fires. ";
  }
  // Moot: This gun is never deadly.
  deathParagraph(extra, bothGuards) {
    sayForArt('The recoil spins him around. ');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt('The recoil spins him around. ');
  }
  // This weapon never runs out of ammo, but just in case
  // this will be needed to serve as a "gun failed" message:
  reportNoNpcAmmo {
    sayForArt('The recoil spins him around. ');
  }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "firing <<theName>> straight at you, 
      or trying to. ";
  }
;
// 4
modify laser
  // this gun is *never* deadly
  canKillSometimes = nil
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> raises <<theName>> and fires. ";
  }
  // Moot: This gun is never deadly.
  deathParagraph(extra, bothGuards) {
    sayForArt('The laser emits a narrow ' + curColor 
      + ' beam of light which strikes you. You jerk back 
      for a moment, but almost as soon as the beam goes off, 
      you recover. ');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt('The laser emits a narrow ' + curColor 
      + ' beam of light which misses you' 
      + byWhatMargin(stat) + '. ');
  }
  reportNoNpcAmmo {
    sayForArt('Click. ');
  }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "aiming <<theName>> straight at you and pulling the trigger. ";
  }
;
// 6
modify paricleGun
  // this gun is *never* deadly
  canKillSometimes = nil
  // Moot: This gun is never deadly.
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> pulls the trigger of 
      <<theName>>. ";
  }
  deathParagraph(extra, bothGuards) {
    "A beam of bright white light flashes from the front 
      of the gun and hits you. You seem none the worse for this. ";
  }
  reportNpcMiss(stat, bothGuards) {
    "A beam of bright white light flashes by you, 
      missing<<byWhatMargin(stat)>>. ";
  }
  // This weapon never runs out of ammo.
  //reportNoNpcAmmo { }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "aiming <<theName>> straight at you and opening fire. ";
  }
;
// 7
modify aryUng
  // this gun can be deadly, but *never* to you, and for the
  // sake of argument, let us assume the NPCs know that
  canKillSometimes = nil
  // Moot: This gun is never deadly to you.
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> raises <<theName>> and fires. ";
  }
  deathParagraph(extra, bothGuards) {
    sayForArt('&lt;GRAAAMN!&gt; A bolt of light shoots out of 
      the ary ung, striking you. You seem unaffected. ');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt('&lt;GRAAAMN!&gt; A bolt of light shoots out of 
      the ary ung. It misses you' + byWhatMargin(stat) + '. ');
  }
  // This weapon never runs out of ammo.
  //reportNoNpcAmmo { }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "aiming <<theName>> straight at you and opening fire. ";
  }
;
// 13
modify tRemovingGun
  // this gun can be deadly, but *never* to you, and for the
  // sake of argument, let us assume the NPCs know that
  canKillSometimes = nil
  // Moot: This gun is never deadly to you.
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> raises <<theName>> and fires. ";
  }
  deathParagraph(extra, bothGuards) {
    sayForArt('The gun fires a loud pulse, discharging a bolt 
      of plasma and striking you. You seem unaffected. ');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt('The gun fires a loud pulse, discharging a bolt 
      of plasma, which misses' + byWhatMargin(stat) + '. ');
  }
  // This weapon never runs out of ammo.
  //reportNoNpcAmmo { }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "aiming <<theName>> straight at you and opening fire. ";
  }
;
// 8
modify rayGun
  // this gun is *never* deadly
  canKillSometimes = nil
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<asscNpc.theName>> raises <<theName>> and fires. ";
  }
  // Moot: This gun is never deadly.
  deathParagraph(extra, bothGuards) {
    sayForArt('&lt;BZZZZZT!&gt; A brilliant red beam shoots 
      out of the ray gun. You seem unaffected. ');
  }
  reportNpcMiss(stat, bothGuards) {
    sayForArt('&lt;BZZZZZT!&gt; A brilliant red beam shoots 
      out of the ray gun. It misses you' 
      + byWhatMargin(stat) + '. ');
  }
  // This weapon never runs out of ammo.
  //reportNoNpcAmmo { }
  //slowedAssaultSentence(): default is fine
  assaultingYouDesc {
    "aiming <<theName>> straight at you and opening fire. ";
  }
;
// 17
//modify dagger
//  suddenRangeAttackParagraph(str, bothGuards) {
//    "\^<<str>><<asscNpc.theName>> raises <<theName>> and fires. ";
//  }
//  deathParagraph(extra, bothGuards) {
//    sayForArt('');
//  }
//  reportNpcMiss(stat, bothGuards) {
//    sayForArt('' 
//      + byWhatMargin(stat) + '. ');
//  }
//  // This weapon never runs out of ammo.
//  //reportNoNpcAmmo { }
//  //slowedAssaultSentence(): default is fine
//  assaultingYouDesc {
//    "aiming <<theName>> straight at you and opening fire. ";
//  }
//;
// 18
//modify netonIcepick
//  suddenRangeAttackParagraph(str, bothGuards) {
//    "\^<<str>><<asscNpc.theName>> raises <<theName>> and fires. ";
//  }
//  deathParagraph(extra, bothGuards) {
//    sayForArt('');
//  }
//  reportNpcMiss(stat, bothGuards) {
//    sayForArt('' 
//      + byWhatMargin(stat) + '. ');
//  }
//  // This weapon never runs out of ammo.
//  //reportNoNpcAmmo { }
//  //slowedAssaultSentence(): default is fine
//  assaultingYouDesc {
//    "aiming <<theName>> straight at you and opening fire. ";
//  }
//;
// 19
//modify ovanIcepick
//  suddenRangeAttackParagraph(str, bothGuards) {
//    "\^<<str>><<asscNpc.theName>> raises <<theName>> and fires. ";
//  }
//  deathParagraph(extra, bothGuards) {
//    sayForArt('');
//  }
//  reportNpcMiss(stat, bothGuards) {
//    sayForArt('' 
//      + byWhatMargin(stat) + '. ');
//  }
//  // This weapon never runs out of ammo.
//  //reportNoNpcAmmo { }
//  //slowedAssaultSentence(): default is fine
//  assaultingYouDesc {
//    "aiming <<theName>> straight at you and opening fire. ";
//  }
//;

