#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// NOTES
// ANIMAL MAZE: GENERAL CLASSES
// ANIMAL MAZE: ANIMALS
// ANIMAL MAZE: ROOM CONNECTORS
// ANIMAL MAZE: FAKE CONNECTORS
// ANIMAL MAZE: ROOMS
// ANIMAL MAZE: MAP STUFF
// DEBUG STUFF

// -------------------------------------------------------------------
// NOTES
// -------------------------------------------------------------------

/*
To do:
//typo alligator "logn"
//bee and butterfly - I thought "alight" meant to land, not to take off?
//elephant - "lifts is trunk"
//elephant and giraffe - should "switches" be "swishes"?
ray - "touch stinger"?
//Xerxes blue butterfly - "X shaped butterfly"
//"AN x-shaped," not "a"
//message where Sheila recognizes the butterfly
//"x rocks" -- "*IT* appears normal"

add response to "talk to animals"?
*/

// -------------------------------------------------------------------
// ANIMAL MAZE: GENERAL CLASSES
// -------------------------------------------------------------------

class AnimalRoom: Room
  //roomDesc = "You are in an animal room. "
  //roomDesc = "e.sw.se.se.w.ne.nw.ne.se.ne.s.se.   s.nw.sw.e.s.w.sw.s.nw.ne.se.se.e"
  roomDesc {
    "Your bot is in a spartan room. Exits lead
      <<exitsDesc>>. ";
  }
  exitsDesc = "north, northeast, east, southeast, south,
    southwest, west, and northwest"
  bannerValue = animals
  potentialScoreProp = &potentialScoreAnimals
  initialPsp = &initialPotentialScoreAnimals
  beenThere = nil
  enteringRoom(traveler) {
    beenThere = true;
    nbmBanner.updateMe();
    hasJustBeenEntered = true;
  }
  roomBeforeAction {
    if (gActionIs(ListenImplicit) && asscAnimal 
        && asscAnimal.propDefined(&animalSoundDesc)) {
      asscAnimal.animalSoundDesc;
      exit;
    }
  }
  hasJustBeenEntered = nil
  firstRoomInThisMazeSet = alligatorRoom
  holeSound = 'the sound of an animal walking across the ground'
  roomDaemon() {
    if (hasJustBeenEntered)
      hasJustBeenEntered = nil;
    else
      inherited();
  }
  atmosphereList : ShuffledEventList { 
    [ 
      bot.getOutermostRoom.asscAnimal.doStuff1, 
      bot.getOutermostRoom.asscAnimal.doStuff2,
      nil, nil, nil, nil
    ]  
  }
  resetThisMazeSet {
    for(local cur=firstObj(AnimalRoom); cur != nil; cur=nextObj(cur,AnimalRoom)) {
      cur.beenThere = nil;
    }
    for(local cur=firstObj(AnimalConnector); cur != nil; cur=nextObj(cur,AnimalConnector)) {
      cur.beenThere = nil;
    }
    for(local cur=firstObj(FakeAnimalConnector); cur != nil; cur=nextObj(cur,FakeAnimalConnector)) {
      cur.curScriptState = 1;
    }
    glob.animalHintState = 0;
    inherited();
  }
  giveHint {
    glob.animalHintState++;
    switch (glob.animalHintState) {
      case 1:
        "Sheila says, <.q>If you ask me, this maze isn<./s>t 
          really all that hard. One thing to note 
          is that the animals will sometimes prevent you 
          from entering their rooms, but not always. 
          It depends on what room you<./s>re coming from. 
          If you can discern the pattern behind this, 
          you can solve the maze.<./q> ";
        if (glob.(potentialScoreProp) > (glob.(initialPsp) - 10))
          glob.(potentialScoreProp) = glob.(initialPsp) - 10;
        break;
      case 2:
        "Sheila says, <.q>Consider this: the first room 
          in this maze contains an alligator. 
          I don<./s>t know if you can tell what<./s>s 
          in the last room, but if you can, 
          that might give you a clue.<./q> ";
        if (glob.(potentialScoreProp) > (glob.(initialPsp) - 30))
          glob.(potentialScoreProp) = glob.(initialPsp) - 30;
        break;
      case 3:
        "Sheila says, <.q>I<./s>ve given you all the hints I can.
          All I can do now is give you the complete solution.
          Is that what you want?<./q> ";
        if (!sayYesOrNo()) {
          "<.q>No problem,<./q> says Sheila. <.q>Back to the game, 
            then!<./q> ";
          glob.animalHintState--;
        }
        else {
          giveCompleteSolution();
        }
        break;
      default:
        giveCompleteSolution();
        break;
    }
  }
  giveCompleteSolution() {
    "<.q>Okay, here<./s>s the solution,<./q> Sheila says. 
      <.q>Starting in the room with the alligator, 
      go to the bee, crab, dolphin, elephant, frog, giraffe, 
      hummingbird, iguana, jellyfish, kangaroo, ladybug, 
      monkey, newt, octopus, penguin, quail, ray, seahorse, 
      turtle, urchin, vulture, walrus, <<xerces.name>>, 
      yak, and zebra.<./q> ";
    glob.(potentialScoreProp) = 0;
  }
;

// Mix-in animal room classes

class ArNorthwest: object
  exitsDesc = "east, southeast, and south"
;
class ArNorth: object
  exitsDesc = "west, southwest, south, southeast, and east"
;
class ArWest: object
  exitsDesc = "north, northeast, east, southeast, and south"
;
class ArEast: object
  exitsDesc = "north, northwest, west, southwest, and south"
;
class ArSouth: object
  exitsDesc = "west, northwest, north, northeast, and east"
;
class ArSoutheast: object
  exitsDesc = "west, northwest, and north"
;

modify glob
  animalHintState = 0
;

holeInAnimalMaze: StairwayDown
  vocabWords = 'hole'
  name = 'hole'
  location = zebraRoom
  specialDesc = "There is a hole in the floor here. "
  desc = "The hole is rather wide, and goes down into the floor 
    so far that it disappears into darkness. 
    There are no handholds in it, so be careful.
    If you went there, I can't imagine how you'd ever
    get back up again. "
  soundDesc {
    "From deep inside the hole, your bot thinks she can hear 
      the sound of a hollow cave. ";
  }
  dobjFor(LookThrough) {
    action() {
      "The hole goes down, way down, vanishing into darkness. ";
    }
  }
  dobjFor(Enter) remapTo(TravelVia, self)
  dobjFor(TravelVia) {
    action {
      "<.q>You want me to jump down a bottomless pit?<./q> 
          Sheila says. Then she shrugs. 
          <.q>Well, I guess that sounds better than hanging around here
          with this zebra for the rest of my life.<./q>
        <p>With that, she promptly jumps into the hole 
          and plummets down and down\ .\ .\ . ";
      returnToCaveVictoriously('Oof. Well, so much for that zoo.');
    }
  }
;

class AnimalConnector: RoomConnector
  beenThere = nil
  noteTraversal(traveler) {
    beenThere = true;
  }
;

enum hostile, inaccessible, permissive;

class Animal: UntakeableActor
  alwaysFlying = nil
  sometimesFlying = nil
  alwaysSwimming = nil
  sometimesSwimming = nil
  isSmallAnimal = nil
  isLargeAnimal = nil
  isInert = nil
  hasNoEyes = nil
  actorHereDesc = "\^<<aName>> is <<animalPostureDesc>> here. "
  specialDescBeforeContents = true
  specialDescOrder = 50
  animalPostureDesc {
    if (isSmallAnimal) return 'sitting';
    else return 'standing';
  }
  touchingAttitude {
    if (isLargeAnimal) return permissive;
    if (isInert) return permissive;
    if (sometimesSwimming) return inaccessible;
    if (sometimesFlying) return inaccessible;
    return inaccessible;
  }
  swimmingPhrase {
    if (alwaysSwimming) return ', which, oddly enough, seems to be swimming through the air';
    else return '';
  }
  dobjFor(ListenTo) {
    action {
      if (propDefined(&animalSoundDesc))
        animalSoundDesc;
      else
        inherited;
    }
  }
  nickname = (name)
  noticesPhrase {
    if (hasNoEyes) return 'senses';
    else return 'sees';
  }
  meanlookPhrase {
    if (hasNoEyes)
      return 'starts to look decidedly peeved';
    else
      return 'gives her a mean look';
  }
  movesVerb {
    if (sometimesFlying) return 'flies';
    if (sometimesSwimming) return 'swims';
    if (isSmallAnimal) return 'races';
    return 'runs';
  }
  textureDesc = 'pretty normal'
  threatensPhrase = 'assumes an attack posture'
  threatensRefsBot {
    if (threatensPhrase.find(' her')) return true;
    else return nil;
  }
  hasBeak = nil
  killPhrase = '' // override
  killPhraseIsShort = nil
  iThinkSo = true
  startledFall =
    'Sheila is so startled by this that she wheels backwards, 
      loses her balance, falls, and hits her head against the floor. '
  insectKillPhrase =
    'circles aggressively around her, locates a gap in her body armor,
      flies up inside of Sheila, and then attacks her circuitry. 
      This electrocutes the ' + nickname + ', but
      also short-circuits the bot. '
  tentacledKillPhrase =
    'suddenly rushes through the air, attaches itself directly
      to Sheila<./s>s face, wriggles its tentacles inside of 
      Sheila<./s>s body, and starts trying to pull apart
      her circuitry. This electrocutes the ' + nickname + ', but
      also short-circuits the bot. '
  
  
  
  
  
  
  
  //greatAdj      = 'great '
  //alwaysAquatic  = nil
  //alwaysFlying   = nil
  //movesVerb {
  //  //if (is
  //  return 'races';
  //}
  scaresPhrase() {
    local who;
    if (threatensRefsBot) who = 'her';
    else who = 'your bot';
    return 'gives ' + who + ' quite a scare';
  }
  nearlyMakesOffWithArm() {
    local whose;
    if (threatensRefsBot) whose = 'her';
    else whose = 'your bot<./s>s';
    return 'nearly makes off with ' + whose + ' arm';
  }
  //killPhrase = 'kills your bot.'
  //killPhraseIsShort = true
  //noticesPhrase {
  //  if (hasNoEyes) return 'senses';
  //  else return 'sees';
  //}
  //meanlookPhrase {
  //  if (hasNoEyes)
  //    return ', and it gives {it/him actor} a hostile vibe';
  //  else
  //    return ', and it gives your bot a mean look';
  //}
  dobjFor(Taste) asDobjFor(Eat)
  //dobjFor(Kiss) {
  //  check {
  //    "Sheila shakes her head, then says, <.q><./q> ";
  //  }
  //}
  door1(conn) {
    "Sheila starts off down the passageway, but soon runs into
      <<aNameObj>><<swimmingPhrase>>! 
      The <<nickname>> <<noticesPhrase>> 
      that she is coming from the direction of the
      <<conn.origAnimal.name>>, and it <<meanlookPhrase>>.
      <p>The <<nickname>> <<movesVerb>> up to Sheila, 
      <<threatensPhrase>>, and 
      <<scaresPhrase>>. ";
    say(rand(
       'Sheila flinches in surprise, then '
      ,'Sheila yelps in astonishment, then '
      ,'Sheila reels back instinctively, then '
    ));
    "quickly <<rand('hightails it', 'heads', 'retreats')>>
      back the way she came. ";
  }
  door3(conn) {
    "<.q>Okay, you<./s>re the boss,<./q> says Sheila. 
      <p>With that,
        she boldly returns down the passageway. This time, the 
        <<name>> is ready for her. And, knowing that she is coming
        from the direction of the hated
        <<conn.origAnimal.name>>, it ";
    if (killPhraseIsShort)
      "<<killPhrase>>";
    else
      "springs into action.
        It <<killPhrase>>";
  }
  hitText {
    "<.q>Okay, you<./s>re the boss,<./q> says Sheila. 
      With that, she hauls back and prepares to hit the <<nickname>>. ";
    "<p>But the <<nickname>> is vigilant, and it springs into action.
      Before Sheila can make a move, it <<killPhrase>>";
  }
  feelText {
    "<.q>Okay, you<./s>re the boss,<./q> says Sheila. 
      With that, she wheels over and 
      <<touchingAttitude == permissive ? 'touches' : 'attempts to touch'>> 
      the <<nickname>>";
    if (touchingAttitude == hostile) {
      ". In response, the <<nickname>> <<meanlookPhrase>>,
        and it <<threatensPhrase>>. ";
      say(rand(
         'Sheila flinches in surprise, then '
        ,'Sheila yelps in astonishment, then '
      ));
      "instinctively wheels herself away. ";
    }
    else if (touchingAttitude == inaccessible) {
      ", but it just <<movesVerb>> to the other side of the room,
        out of reach. ";
    }
    else if (touchingAttitude == permissive) {
      ". 
        <p><.q>It feels <<textureDesc>>,<./q> Sheila remarks. ";
    }
  }
  dobjFor(Attack) {
    check {
      if (!glob.hitAnimalFuseIsOn) {
        "<.q>Hmm,<./q> says Sheila. <.q>Maybe I<./s>m overly cautious,
          but I<./s>m not so sure that<./s>s a good idea.
          Are you sure you want me to attack the <<nickname>>?<./q> ";
        glob.hitAnimalFuseIsOn = true;
        ncYesNo.set(
          new function { reallyHitAnimal(); }
         ,'<.q>Yeah, it<./s>s probably better to play it safe,<./q>
            says Sheila. '
        );
      }
      else {
        reallyHitAnimal();
      }
      exit;
    }
  }
  reallyHitAnimal {
    hitText;
    endGame(ftDeath);
  }
  dobjFor(Feel) {
    check {
      if (touchingAttitude != permissive) {
        feelText;
        exit;
      }
    }
    action {
      feelText;
    }
  }
  dobjFor(TalkTo) {
    action {
      "Sheila says, <.q>Hey, <<gDobj.name>>. How<./s>s it going?<./q> 
        <p>{The dobj/he} doesn<./s>t reply.  ";
    }
  }
;

class SmallAnimal: Animal
  isSmallAnimal = true
;
class LargeAnimal: Animal
  isLargeAnimal = true
;
class Flying: SometimesFlying
  actorHereDesc = "\^<<aName>> is here, flying through the air. "
  animalPostureDesc = 'flying'
  alwaysFlying = true
  sometimesFlying = true
;
class SometimesFlying: object
  sometimesFlying = true
  threatensPhrase {
    if (self == bee || self == dragonfly)
      return 'buzzes around her';
    if (!hasBeak)
      return 'circles around her';
    else
      return inherited;
  }
  //threatensRefsBot {
  //  if (!hasBeak)
  //    return true;
  //  else
  //    return inherited;
  //}
;
class Swimming: SometimesSwimming
  actorHereDesc = "\^<<aName>> is here. Oddly enough, it is 
    swimming through the air. "
  animalPostureDesc = 'swimming'
  alwaysSwimming = true
  sometimesSwimming = true
;
class SometimesSwimming: object
  sometimesSwimming = true
;
class Furry: object
  textureDesc = 'furry'
;
class Beaked: object
  hasBeak = true
  threatensPhrase = 'pecks at her'
  //threatensRefsBot = true
;

//// This way of classifying creatures turned out to be far from 
//// ideal.
//
//class Aquatic: object
//  alwaysAquatic = true
//  movesVerb = 'swims'
//;
//class Invertebrate: Animal
//;
//class Insect: Invertebrate
//  movesVerb = 'flies'
//  alwaysFlying = true
//  threatensPhrase = 'buzzes around him'
//  threatensRefsBot = true
//;
//class AquaticInvertebrate: Aquatic, Invertebrate
//;
//class Fish: Aquatic, Animal
//  threatensPhrase = 'glares at him'
//  threatensRefsBot = true
//;
//class Amphibian: Animal
//  threatensPhrase = 'snaps its jaws with surprising ferocity'
//;
//class Reptile: Animal
//  threatensPhrase = 'snaps its jaws at him'
//  threatensRefsBot = true
//;
//class Bird: Animal
//  movesVerb = 'runs'
//  threatensPhrase = 'pecks at him'
//  threatensRefsBot = true
//;
//class FlyingBird: Bird
//  movesVerb = 'flies'
//  alwaysFlying = true
//;
//class Mammal: Animal
//  threatensPhrase = 'growls ferociously at him'
//  threatensRefsBot = true
//;
//class AquaticMammal: Aquatic, Mammal
//  threatensPhrase = 'glares at him'
//  threatensRefsBot = true
//;
//class LargeMammal: Mammal
//  movesVerb = 'runs'
//;

// -------------------------------------------------------------------
// ANIMAL MAZE: ANIMALS
// -------------------------------------------------------------------

alligator: LargeAnimal
  'leathery gray grey green gray-green grey-green leather jaws skin alligator/reptile/beast/creature/animal/gator' 'alligator'
  @alligatorRoom
  "The alligator is ten feet long, with leathery, gray-green skin,
    but perhaps its most notable feature is its powerful jaws,
    with which it could easily rip your bot in two. "
  touchingAttitude = hostile
  animalPostureDesc = 'crouching'
  threatensPhrase = 'snaps its jaws at her'
  //threatensRefsBot = true
  //greatAdj      = 'great'
  scaresPhrase() { return nearlyMakesOffWithArm(); }
  killPhrase  = 'lunges and bites your bot in two.'
  killPhraseIsShort = true
  doStuff1 = 
    'In a flash, the alligator snaps its jaws shut. Then, 
      apparently not having accomplished much with this gesture, 
      it resumes its usual gaping of its jaws. '
  doStuff2 = 
    'The alligator walks forward a couple of paces, then pauses
      to smell the air. '
;
bee: Flying, SmallAnimal
  'buzz bee/insect/invertebrate/beast/creature/animal' 'bee'
  @beeRoom
  "The bee is circling slowly around the room, emitting a low buzz. 
    Fortunately, it is staying away from your bot at the moment. "
  touchingAttitude = hostile
  nearKillPhrase = 'flies up to her, buzzes around her, and gives her quite a scare. {You/he}'
  killPhrase = (insectKillPhrase)
  doStuff1 = 
    'The bee, buzzing loudly, attempts to fly through one of the walls. 
      When this fails, it goes back to aimlessly circling through the air. '
  doStuff2 = 
    'The bee lands on the wall. Then, five seconds later, it takes off
      and starts flying around again. '
  animalSoundDesc =
    "The bee emits a low buzz as it flies around the room. "
;
crab: SmallAnimal
  'bright red pincer pincers odd deep-sea variety crab/crustacean/invertebrate/beast/creature/animal' 'crab'
  @crabRoom
  "The crab is bright red, with sharp pincers, and seems to be 
    a rather odd, deep-sea variety. "
  touchingAttitude = hostile
  threatensPhrase = 'snaps its pincers at her'
  //threatensRefsBot = true
  //scaresPhrase() { return nearlyMakesOffWithArm(); }
  killPhrase = 
    'jumps up on top of her and attempts 
      to remove her left arm. '
      + startledFall
  doStuff1 = 
    'Abruptly, the crab scurries to the other side of the room.
      Then, just as abruptly, it goes back to being motionless. '
  doStuff2 = 
    'The crab snaps its pincers at the floor, as if out of sheer boredom. '
;
dolphin: Swimming, LargeAnimal // not Furry, despite being a mammal
  'bottle nosed bottle-nosed dolphin/mammal/beast/creature/animal' 'dolphin'
  @dolphinRoom
  "Mysteriously, the bottle-nosed dolphin is swimming through the air,
    just as it would through the water. 
    In fact, it keeps on circling through the room 
    at a good clip. "
  touchingAttitude = inaccessible
  threatensPhrase = 'glares at her'
  textureDesc = 'pretty normal'
  killPhrase = 
    'lowers its head, then deftly sends a shower of water
      through its blowhole, drenching Sheila and ruining her circuits.
      Sheila promptly loses consciousness and never wakes up. '
  doStuff1 = 
    'The dolphin does an impressive loop as it swims through the air
      on the other side of the room. '
  doStuff2 = 
    'The dolphin circles contentedly as it swims across the room. '
;
elephant: LargeAnimal // not Furry, despite being a mammal
  'leg legs trunk elephant/mammal/beast/creature/animal' 'elephant'
  @elephantRoom
  "With legs like gum trees and a trunk like an anaconda, 
    this elephant is not what you<./s>d call tiny. "
  movesVerb = 'stomps'
  threatensPhrase = 'trumpets thunderously'
  //threatensRefsBot = nil
  killPhrase = 
    'stomps her into a pancake without breaking a sweat. '
  killPhraseIsShort = true
  doStuff1 = 
    'The elephant lifts its trunk to the ceiling, apparently trying
      to pull off a chunk of it. When this fails, he lowers his trunk 
      again. '
  doStuff2 = 
    'The elephant swishes its tail contemplatively. '
;
frog: SmallAnimal
  'ordinary green motionless frog/amphibian/beast/creature/animal' 'frog'
  @frogRoom
  "It<./s>s an ordinary green frog, presently as motionless 
    as a statue. "
  movesVerb = 'hops'
  threatensPhrase = 'snaps its jaws with surprising ferocity'
  killPhrase = 
    'leaps up in a lightning flash and lands on Sheila<./s>s face
      with a thump. '
      + startledFall
  doStuff1 = 
    'The frog suddenly hops a couple of feet across the floor. '
  doStuff2 = 
    'The frog looks at the ceiling for a moment, then goes back
      to staring off into space. '
;
giraffe: Furry, LargeAnimal
  'tall head coat brown white mosaic giraffe/mammal/beast/creature/animal' 'giraffe'
  @giraffeRoom
  "This giraffe must be at least twelve feet tall, its head reaching
    to within inches of the ceiling. Its coat is a trim mosaic of 
    brown and white. "
  movesVerb = 'walks'
  threatensPhrase = 'kicks its hooves towards her'
  //threatensRefsBot = true
  textureDesc = 'hairy'
  killPhrase = 
    'kicks Sheila hard with its hoof. The bot promptly flies back and 
      smashes into the wall. '
  doStuff1 = 
    'The giraffe stares disdainfully for a few moments at the ceiling
      directly above its head. '
  doStuff2 = 
    'The giraffe swishes its tail contemplatively. '
;
hummingbird: Beaked, Flying, SmallAnimal
  'wings blur hummingbird/bird/beast/creature/animal' 'hummingbird'
  @hummingbirdRoom
  "The hummingbird<./s>s wings are a blur as it hovers incessantly
    through the air. "
  threatensPhrase = 'brandishes its bill'
  //threatensRefsBot = true
  killPhrase = 
    'somehow locates a gap in her body armor,
      flies up inside of her body, and then attacks her circuitry. 
      This electrocutes the ' + name + ', but
      also short-circuits the bot. '
  doStuff1 = 
    'The hummingbird flies up to investigate the ceiling. 
      After a few seconds of this,
      it flies back down to mid-air. '
  doStuff2 = 
    'The hummingbird does a little circle as it flies through 
      the air. '
;
iguana: SmallAnimal
  'large long yellow brown yellow-brown skin iguana/lizard/reptile/beast/creature/animal' 'iguana'
  @iguanaRoom
  "The iguana is quite large for a lizard, perhaps three
    feet long. Its skin is a mottled yellow-brown. "
  animalPostureDesc = 'crouching'
  threatensPhrase = 'snaps its jaws with surprising ferocity'
  //threatensRefsBot = nil
  killPhrase = (frog.killPhrase)
  doStuff1 = 
    'The iguana walks a few paces across the floor. '
  doStuff2 = 
    'The iguana moves its head this way and that, then becomes
      still again. '
;
jellyfish: Swimming, Animal
  'tentacles jellyfish/medusa/invertebrate/beast/creature/animal' 'jellyfish'
  @jellyfishRoom
  "Mysteriously, the jellyfish is gliding through the air 
    just as it would through water. It is very serene right now, 
    but something about its tentacles tells your bot 
    not to get too close. "
  hasNoEyes = true
  threatensPhrase = 'brandishes its tentacles at her'
  //threatensRefsBot = true
  killPhrase = (tentacledKillPhrase)
  doStuff1 = 
    'The jellyfish swims down to the floor and touches it
      speculatively. Then, moments later, it swims back up
      to mid-air. '
  doStuff2 = 
    'The jellyfish stops swimming and flexes its tentacles for a moment.
      Then it goes back to swimming through the air. '
;
kangaroo: Furry, LargeAnimal
  'leg legs tail kangaroo/mammal/beast/creature/animal' 'kangaroo'
  @kangarooRoom
  "The legs alone of this kangaroo are almost as tall as your bot,
    and it also wields a powerful tail. Right now the animal is minding 
    its own business, but your bot is reluctant to get 
    too close. "
  touchingAttitude = inaccessible
  movesVerb = 'hops'
  threatensPhrase = 'glares at her'
  //threatensRefsBot = true
  killPhrase = 
    'leaps up in a high arc all the way to the ceiling,
      then falls and lands on Sheila. After that, 
      there<./s>s not much left of your bot. '
  doStuff1 = 
    'The kangaroo gives a few short hops to the other side
      of the room. '
  doStuff2 = 
    'The kangaroo lowers its head and stiffs
      the floor for a few seconds. '
;
ladybug: SometimesFlying, SmallAnimal
  'red black carapace wings lady beetle/ladybird/bug/ladybug/insect/invertebrate/beast/creature/animal' 'ladybug'
  @ladybugRoom
  "Whether you call it a ladybug, a ladybird, or a lady beetle,
    this insect has the familiar dotted red carapace, which
    it can lift as needed to in order to fly. "
  killPhrase = (insectKillPhrase)
  doStuff1 = 
    'The ladybug walks across the floor a few inches. '
  doStuff2 = 
    'Suddenly the ladybug lifts its carapace and flies to the other
      side of the room, where it goes back to studiously examining 
      the floor. '
;
monkey: Furry, Animal
  'small monkey/primate/mammal/beast/creature/animal' 'monkey'
  @monkeyRoom
  "This monkey is small, but it seems to hold enough pent-up energy 
    to power a large neighborhood. Your bot eyes the creature
    warily. "
  movesVerb = 'scampers'
  threatensPhrase = 'makes a bunch of threatening gestures'
  //threatensRefsBot = nil
  killPhrase = 
    'leaps up deftly on top of her head. Despite Sheila<./s>s
      best efforts, she is powerless to prevent the monkey 
      from unscrewing her bolts, removing her body armor, 
      and then dismantling her into a thousand pieces. '
  doStuff1 = 
    'Suddenly the monkey jumps up in the air, waves its arms,
      and screeches like a madman. After a few seconds of this,
      it seeems to get tired, and it settles back down again. '
  doStuff2 = 
    'Jumping and screaming, the monkey bounds over to the other
      side of the room. '
  animalSoundDesc =
    "Right at this moment, the monkey is not making any noise. "
;
newt: SmallAnimal
  'striking bright orange black dots newt/amphibian/beast/creature/animal' 'newt'
  @newtRoom
  "This is a very striking newt specimen, bright orange
    with black dots. "
  threatensPhrase = 'snaps its jaws with surprising ferocity'
  killPhrase = (frog.killPhrase)
  doStuff1 = 
    'The newt crawls across the floor a few feet. '
  doStuff2 = 
    'The newt sniffs the floor contemplatively for a few moments. '
;
octopus: Swimming, Animal
  'white pink tentacles octopus/invertebrate/beast/creature/animal' 'octopus'
  @octopusRoom
  "The octopus is about four feet long, with a white body and 
    pink tentacles. Mysteriously, it is swimming through the air 
    just as it would through water. "
  threatensPhrase = 'brandishes its tentacles at her'
  //threatensRefsBot = true
  killPhrase = (tentacledKillPhrase)
  doStuff1 = 
    'The octopus swims down to the floor and touches it
      speculatively. Then, moments later, it swims back up
      to mid-air. '
  doStuff2 = 
    'The octopus stops swimming and flexes its tentacles for a moment.
      Then it goes back to swimming through the air. '
;
penguin: Beaked, Animal
  'black feathers white black-and-white penguin/bird/beast/creature/animal' 'penguin'
  @penguinRoom
  "This bird is short and stout, with the usual 
    black and white feathers. As a creature adapted for swimming,
    it looks a bit out of its element standing here in this room. "
  killPhrase = 
    'jumps up and gives Sheila a surprisingly powerful body-slam. '
      + startledFall
  doStuff1 = 
    'Waddling at a leisurely pace, the penguin stalks over to the
      other side of the room. '
  doStuff2 = 
    'The penguin looks down at its feet for a few moments, 
      then looks up again. '
;
quail: Beaked, Animal
  'nervous quail/bird/beast/creature/animal' 'quail'
  @quailRoom
  "This bird is only about a foot long, but seems full of nervous
    energy.  "
  killPhrase = (duck.killPhrase)
  doStuff1 = 
    'The quail opens its wings as if to fly, then changes
      its mind and closes them again. '
  doStuff2 = 
    'The quail makes a start, as if suddenly frightened,
      and trots over to the other side of the room. '
;
ray: Swimming, Animal
  'sting stinger ray/fish/beast/creature/animal' 'ray'
  @rayRoom
  // When redoing this ray description, please note that the ray
  // has a stinger.
  "Mysteriously, this fish is gliding through the air just as it
    would through water. It has a large stinger, but fortunately,
    it seems to have no plans to use it for the moment. "
  threatensPhrase = 'assumes an attack posture'
  //threatensRefsBot = nil
  killPhrase = 
    'deftly swings its stinger straight at Sheila<./s>s body. '
      + startledFall
  doStuff1 = 
    'The ray swims down to investigate the floor for a few seconds.
      Then, rippling its body, it swims back up to mid-air. '
  doStuff2 = 
    'The ray swims over to the wall and raises its stinger 
      as if to attack. Then, coming to its senses, it cuts off
      its offensive and swims away. '
;
seahAnimal: Swimming, SmallAnimal
  'yellow yellowish brown yellowish-brown seahorse/fish/beast/creature/animal' 'seahorse'
  @seahorseRoom
  "This seahorse is a muddy shade of yellowish-brown. 
    Mysteriously, it is swimming through the air just as it would
    through water. "
  threatensPhrase = 'glares at her'
  //threatensRefsBot = true
  killPhrase = 
    'somehow locates a gap in her body armor,
      swims up inside of her body, and then attacks her circuitry. 
      This electrocutes the ' + name + ', but
      also short-circuits the bot. '
  doStuff1 = 
    'Uncoiling its body, the seahorse suddenly swims as fast as it can
      to the other side of the room. '
  doStuff2 = 
    'The seahorse does a little circle as it swims through the air. '
;
turtle: Animal
  'sea sharp powerful jaws turtle/reptile/beast/creature/animal' 'turtle'
  @turtleRoom
  "This turtle looks like it would be more at home in the ocean
    than in a sterile room like this. It has sharp, powerful jaws. "
  touchingAttitude = hostile
  animalPostureDesc = 'squatting'
  threatensPhrase = 'snaps its jaws at her'
  scaresPhrase() { return nearlyMakesOffWithArm(); }
  killPhrase = 
    'lunges at her with surprising agility and attempts 
      to remove her left arm. '
      + startledFall
  doStuff1 = 
    'Very slowly, the turtle drags itself six or seven paces 
      across the floor. '
  doStuff2 = 
    'The turtle draws its head into its shell for a moment, then
      draws it back out again, as if having failed to find what
      it was looking for. '
;
urchin: SmallAnimal
  'sea dark body long sharp red spines spine urchin/invertebrate/beast/creature/animal' 'urchin'
  @urchinRoom
  "This sea urchin has a dark body with long, sharp, red spines. "
  movesVerb = 'scurries'
  hasNoEyes = true
  isInert = true
  textureDesc = 'prickly'
  killPhrase = (starfish.killPhrase)
  // No doStuff1 or doStuff2, since the urchin is inert
  //doStuff1 = ' '
  //doStuff2 = ' '
;
vulture: Beaked, Animal
  'vulture/bird/beast/creature/animal' 'vulture'
  @vultureRoom
  "This vulture, the color of dust, is perched on the ground 
    a few feet away, ominously eyeing your bot with a hungry look. "
  killPhrase = (duck.killPhrase)
  doStuff1 = 
    'The vulture opens its wings as if to fly, then changes
      its mind and closes them again. '
  doStuff2 = 
    'The vulture walks slowly to the other side of the room. '
;
walrus: LargeAnimal // not Furry, despite being a mammal
  'hulking blubbery gigantic tusks walrus/mammal/beast/creature/animal' 'walrus'
  @walrusRoom
  "Your bot eyes the walrus with understandable wariness. 
    The hulking, blubbery beast weighs at least two tons, and its gigantic 
    tusks make your bot uneasy as well. "
  movesVerb = 'lumbers'
  threatensPhrase = 'roars thunderously'
  //threatensRefsBot = nil
  animalPostureDesc = 'sitting'
  killPhrase = 
    'sidles up to Sheila, gets up on its haunches,
      jumps into the air, and lands on Sheila. 
      After that, your bot isn<./s>t even fit for a salvage yard. '
  doStuff1 = 
    'The walrus gives a low, loud grunt, like something from a badly
      damaged diesel engine. '
  doStuff2 = 
    'Making a tremendous effort, the walrus shoves its body forward
      a couple of feet. The floor creaks as it does so. '
  animalSoundDesc =
    "Right at this moment, the walrus is not making any noise. "
;
xerces: Flying, SmallAnimal
  'x x-shaped (shaped) xerces striking extinct blue bluish violet butterfly/insect/beast/creature/animal' 
  name {
    if (!butterflyIdM.isInExe)
      return 'X-shaped butterfly';
    else
      return 'Xerces blue butterfly';
  }
  aName {
    if (!butterflyIdM.isInExe)
      return 'an ' + name;
    else
      return 'a ' + name;
  }
  location = xercesRoom
  desc {
    if (!butterflyIdM.isInExe)
      "The butterfly is a striking shade of bluish violet. 
        It flutters around the room serenely. ";
    else
      "Even to the casual observer, this butterfly would be striking.
        But to the discerning eye it is even more remarkable,
        for it has all the characteristic markings of the 
        Xerces blue butterfly. In the real world, this species
        is extinct, perhaps the first butterfly species to become so
        due to human activity. In this virtual world,
        however, the species seems to be alive and well. ";
  }
  nickname = 'butterfly'
  killPhrase = (insectKillPhrase)
  doStuff1 = 
    'The butterfly lands on the wall. Then, five seconds later, it takes off
      and circles through the air again. '
  doStuff2 = 
    'The butterfly does a little circle as it flies through the air.  '
;
yak: Furry, LargeAnimal
  'shaggy hair fur furry yak/ungulate/bovine/mammal/beast/creature/animal' 'yak'
  @yakRoom
  "The one-ton bovine has hair so shaggy that it stretches almost 
    to the floor. "
  textureDesc = 'shaggy'
  threatensPhrase = 'brandishes its horns at her'
  //threatensRefsBot = true
  killPhrase = (cow.killPhrase)
  //  'lowers its head and charges at Sheila, smashing her into oblivion. '
  killPhraseIsShort = iThinkSo
  doStuff1 = 
    'The yak bellows with a low yak equivalent of a moo. After a few
      seconds of this, it falls silent again. '
  doStuff2 = 
    'The yak swishes its tail contemplatively. '
  animalSoundDesc =
    "Right at this moment, the yak is not making any noise. "
;
zebra: Furry, LargeAnimal
  'black-and-white striped zebra/ungulate/mammal/beast/creature/animal' 'zebra'
  @zebraRoom
  "The black-and-white striped beast stands here docilely, 
    seemingly gazing into the distance at nothing in particular. "
  threatensPhrase = 'growls ferociously at her'
  killPhrase = (cow.killPhrase)
  //  'lowers its head and charges at Sheila, smashing her into oblivion. '
  killPhraseIsShort = iThinkSo
  doStuff1 = 
    'The zebra lowers its head to the ground and sniffs
      the ground for a few moments. '
  doStuff2 = 
    'The zebra swishes its tail contemplatively. '
;
caribou: Furry, LargeAnimal
  'caribou/ungulate/mammal/beast/creature/animal' 'caribou'
  "It<./s>s a caribou."
  threatensPhrase = 'snorts ferociously at her'
  killPhrase = 
    'lowers its antlers and charges at Sheila, smashing her into smithereens. '
  killPhraseIsShort = iThinkSo
;
catAnimal: Furry, Animal
  'cat/feline/mammal/beast/creature/animal' 'cat'
  "It<./s>s a cat."
  movesVerb = 'races'
  threatensPhrase = 'brandishes its claws at her'
  //threatensRefsBot = true
  killPhrase =
    'leaps at her, somehow manages to find
      a particularly delicate piece of circuitry, and digs in
      with its incisors. This electrocutes the ' + name + ', but also
      short-circuits the bot. '
;
clam: SmallAnimal
  'clam/oyster/bivalve/invertebrate/beast/creature/animal' 'clam'
  "It<./s>s a clam."
  movesVerb = 'swims'
  hasNoEyes = true
  isInert = true
  textureDesc = 'rough'
  killPhrase = 
    'opens its shell and emits a mysterious cloud of black smoke. 
      It<./s>s not clear what<./s>s in this smoke, but ten seconds later, 
      your bot is lying dead on the floor. '
  // Because the clam is immobile, we must override door1
  door1(conn) {
    "Sheila starts off down the passageway, but soon runs into
      <<aNameObj>><<swimmingPhrase>>! 
      The <<nickname>> <<noticesPhrase>> 
      that she is coming from the direction of the
      <<conn.origAnimal.name>>, and it <<meanlookPhrase>>.
      <p>The <<nickname>> opens its shell. Perhaps this does not sound
      like such a menacing gesture, but something about it
      throws your bot into a panic. She
      quickly <<rand('hightails it', 'wheels', 'retreats')>>
      back the way she came. ";
  }
  // I'm not sure why I did this; hitText for this creature will never be seen.
  hitText {
    "<.q>Okay, you<./s>re the boss,<./q> says Sheila. 
      With that, she hauls back and prepares to hit the <<nickname>>. ";
    "<p>But the <<nickname>> is vigilant, and it springs into action.
      Before Sheila can make a move, it 
      opens its shell and emits a mysterious cloud of black smoke. 
      Your bot does manage to deliver a powerful blow to the clam, 
      but ten seconds later, 
      she is lying dead on the floor. ";
  }
;
cow: Furry, LargeAnimal
  'cow/ungulate/mammal/beast/creature/animal' 'cow'
  "It<./s>s a cow."
  threatensPhrase = 'moos ferociously'
  killPhrase =
    'lowers its head and charges at Sheila, smashing her into oblivion. '
  killPhraseIsShort = iThinkSo
;
dragonfly: Flying, SmallAnimal
  'dragonfly/insect/beast/creature/animal' 'dragonfly'
  "It<./s>s a dragonfly."
  killPhrase = (insectKillPhrase)
;
duck: Beaked, Animal
  'duck/bird/beast/creature/animal' 'duck'
  "It<./s>s a duck."
  killPhrase = 
    'flaps up high, then plunges down, smacking its feet right
      into Sheila<./s>s face. '
      + startledFall
;
fox: Furry, LargeAnimal
  'fox/carnivore/mammal/beast/creature/animal' 'fox'
  "It<./s>s a fox."
  touchingAttitude = hostile
  threatensPhrase = 'snaps its jaws at her'
  //threatensRefsBot = true
  scaresPhrase() { return nearlyMakesOffWithArm(); }
  killPhrase = 
    'leaps at Sheila and starts trying to bite her face. '
      + startledFall
;
pelican: Beaked, Animal
  'pelican/bird/beast/creature/animal' 'pelican'
  "It<./s>s a pelican."
  killPhrase = 
    'rushes forward, its bill agape, and attempts to swallow
      Sheila whole. '
      + startledFall
;
rabbit: Animal
  'rabbit/mammal/beast/creature/animal' 'rabbit'
  "It<./s>s a rabbit."
  movesVerb = 'races'
  threatensPhrase = 'glares at her'
  //threatensRefsBot = true
  killPhrase = 
    'leaps at her, somehow manages to find
      a particularly delicate piece of circuitry, and digs in
      with its incisors. This electrocutes the ' + name + ', but also
      short-circuits the bot. '
;
ram: Furry, LargeAnimal
  'ram/ungulate/mammal/beast/creature/animal' 'ram'
  "It<./s>s a ram."
  touchingAttitude = hostile
  threatensPhrase = 'brandishes its horns at her'
  //threatensRefsBot = true
  killPhrase = 
    'hauls back and rams Sheila into oblivion. '
  killPhraseIsShort = true
;
// The scallop's hitText doesn't really make sense, but it doesn't
// have to. The hitText only needs to work for animals that you
// can be in the same room with.
scallop: SometimesSwimming, SmallAnimal
  'scallop/invertebrate/beast/creature/animal' 'scallop'
  "It<./s>s a scallop."
  hasNoEyes = true
  isInert = true
  textureDesc = 'rough'
  killPhrase = 
    'suddenly starts opening and closing its shell spasmodically,
      which, fantastically, allows it to swim through the air.
      Sheila gazes in fascination as the scallop swims
      closer and closer.
      Then, abruptly, the scallop turns and propels itself
      straight at Sheila<./s>s face. '
      + startledFall
  // door1 must be overridden because of the scallop's unique
  // method of propulsion.
  door1(conn) {
    "Sheila starts off down the passageway, but soon runs into
      <<aNameObj>><<swimmingPhrase>>! 
      The <<nickname>> <<noticesPhrase>> 
      that she is coming from the direction of the
      <<conn.origAnimal.name>><<meanlookPhrase>>.
      <p>The scallop, amazingly enough, starts swimming 
      through the air towards Sheila 
      by thrusting a jet of air down beneath itself.
      It then assumes an attack posture, and this
      <<scaresPhrase>>. ";
    say(rand(
       'Sheila flinches in surprise, then '
      ,'Sheila yelps in astonishment, then '
      ,'Sheila reels back instinctively, then '
    ));
    "quickly <<rand('hightails it', 'wheels', 'retreats')>>
      back the way she came. ";
  }
;
squid: Swimming, Animal
  'squid/invertebrate/beast/creature/animal' 'squid'
  "It<./s>s a squid."
  threatensPhrase = 'brandishes its tentacles at her'
  //threatensRefsBot = true
  killPhrase = (tentacledKillPhrase)
;
starfish: SmallAnimal
  'starfish/echinoderm/invertebrate/beast/creature/animal' 'starfish'
  "It<./s>s a starfish."
  movesVerb = 'scurries'
  hasNoEyes = true
  isInert = true
  textureDesc = 'rough'
  killPhrase = 
    'leaps up at her with amazing speed and lands directly on her face
      with a thump. '
      + startledFall
;
turkey: Beaked, Animal
  'turkey/bird/beast/creature/animal' 'turkey'
  "It<./s>s a turkey."
  killPhrase = 
    'thrusts its beak forward in a barrage of fierce pecking. '
      + startledFall
;
whale: Swimming, LargeAnimal // not Furry, despite being a mammal
  'whale/mammal/beast/creature/animal' 'whale'
  "It<./s>s a whale."
  textureDesc = 'pretty normal'
  threatensPhrase = 'glares at her'
  killPhrase = 
    'flicks its tail and swiftly bashes her into oblivion. '
  killPhraseIsShort = true
;
woodpecker: Beaked, SometimesFlying, SmallAnimal
  'woodpecker/bird/beast/creature/animal' 'woodpecker'
  "It<./s>s a woodpecker."
  killPhrase = 
    'flaps its wings around her and pecks at her fiercely. '
      + startledFall
;

grue: Animal name='ERROR'
  //greatAdj      = 'ERROR'
  swimmingPhrase= 'ERROR'
  noticesPhrase = 'ERROR'
  nearKillPhrase  = 'ERROR'
  killPhrase  = 'ERROR'
;

/*
alligator: Reptile
  'alligator/reptile/beast/creature/animal' 'alligator'
  @alligatorRoom
  "It<./s>s an alligator."
  //greatAdj      = 'great'
  scaresPhrase() { return nearlyMakesOffWithArm(); }
  killPhrase  = 'lunges and bites your bot in two.'
;
bee: Insect
  'bee/insect/invertebrate/beast/creature/animal' 'bee'
  @beeRoom
  "It<./s>s a bee."
  nearKillPhrase = 'flies up to {you/him}, buzzes around {it/him}, and gives {it/him} quite a scare. {You/he}'
;
crab: Invertebrate
  'crab/invertebrate/beast/creature/animal' 'crab'
  @crabRoom
  "It<./s>s a crab."
  threatensPhrase = 'snaps its pincers at him'
  threatensRefsBot = true
  scaresPhrase() { return nearlyMakesOffWithArm(); }
;
dolphin: AquaticMammal
  'dolphin/mammal/beast/creature/animal' 'dolphin'
  @dolphinRoom
  "It<./s>s a dolphin."
;
elephant: LargeMammal
  'elephant/mammal/beast/creature/animal' 'elephant'
  @elephantRoom
  "It<./s>s a elephant."
  movesVerb = 'stomps'
  threatensPhrase = 'trumpets thunderously'
  threatensRefsBot = nil
;
frog: Amphibian
  'frog/amphibian/beast/creature/animal' 'frog'
  @frogRoom
  "It<./s>s a frog."
  movesVerb = 'hops'
;
giraffe: LargeMammal
  'giraffe/mammal/beast/creature/animal' 'giraffe'
  @giraffeRoom
  "It<./s>s a giraffe."
  movesVerb = 'walks'
  threatensPhrase = 'kicks its hooves towards him'
  threatensRefsBot = true
;
hummingbird: FlyingBird
  'hummingbird/bird/beast/creature/animal' 'hummingbird'
  @hummingbirdRoom
  "It<./s>s a hummingbird."
  threatensPhrase = 'brandishes its bill'
  threatensRefsBot = true
;
iguana: Reptile
  'iguana/lizard/reptile/beast/creature/animal' 'iguana'
  @iguanaRoom
  "It<./s>s a iguana."
  threatensPhrase = 'snaps its jaws with surprising ferocity'
  threatensRefsBot = nil
;
jellyfish: AquaticInvertebrate
  'jellyfish/medusa/invertebrate/beast/creature/animal' 'jellyfish'
  @jellyfishRoom
  "It<./s>s a jellyfish."
  hasNoEyes = true
  threatensPhrase = 'brandishes its tentacles at him'
  threatensRefsBot = true
;
kangaroo: LargeMammal
  'kangaroo/mammal/beast/creature/animal' 'kangaroo'
  @kangarooRoom
  "It<./s>s a kangaroo."
  movesVerb = 'hops'
  threatensPhrase = 'glares at him'
  threatensRefsBot = true
;
ladybug: Insect
  'ladybug/insect/invertebrate/beast/creature/animal' 'ladybug'
  @ladybugRoom
  "It<./s>s a ladybug."
;
monkey: Mammal
  'monkey/primate/mammal/beast/creature/animal' 'monkey'
  @monkeyRoom
  "It<./s>s a monkey."
  movesVerb = 'scampers'
  threatensPhrase = 'makes a bunch of threatening gestures'
  threatensRefsBot = nil
;
newt: Amphibian 
  'newt/amphibian/beast/creature/animal' 'newt'
  @newtRoom
  "It<./s>s a newt."
;
octopus: AquaticInvertebrate
  'octopus/invertebrate/beast/creature/animal' 'octopus'
  @octopusRoom
  "It<./s>s a octopus."
  threatensPhrase = 'brandishes its tentacles at him'
  threatensRefsBot = true
;
penguin: Bird
  'penguin/bird/beast/creature/animal' 'penguin'
  @penguinRoom
  "It<./s>s a penguin."
;
quail: Bird
  'quail/bird/beast/creature/animal' 'quail'
  @quailRoom
  "It<./s>s a quail."
;
ray: Fish
  'ray/fish/beast/creature/animal' 'ray'
  @rayRoom
  "It<./s>s a ray."
  threatensPhrase = 'assumes an attack posture'
  threatensRefsBot = nil
;
seahAnimal: Fish
  'seahorse/fish/beast/creature/animal' 'seahorse'
  @seahorseRoom
  "It<./s>s a seahorse."
;
turtle: Reptile
  'turtle/reptile/beast/creature/animal' 'turtle'
  @turtleRoom
  "It<./s>s a turtle."
  scaresPhrase() { return nearlyMakesOffWithArm(); }
;
urchin: Invertebrate
  'sea urchin/invertebrate/beast/creature/animal' 'urchin'
  @urchinRoom
  "It<./s>s a urchin."
  movesVerb = 'scurries'
  hasNoEyes = true
;
vulture: Bird
  'vulture/bird/beast/creature/animal' 'vulture'
  @vultureRoom
  "It<./s>s a vulture."
;
walrus: LargeMammal
  'walrus/mammal/beast/creature/animal' 'walrus'
  @walrusRoom
  "It<./s>s a walrus."
  movesVerb = 'lumbers'
  threatensPhrase = 'roars thunderously'
  threatensRefsBot = nil
;
xerces: Insect
  'xerces blue butterfly/insect/beast/creature/animal' 'Xerces blue butterfly'
  @xercesRoom
  "It<./s>s a xerces."
;
yak: LargeMammal
  'yak/ungulate/mammal/beast/creature/animal' 'yak'
  @yakRoom
  "It<./s>s a yak."
  threatensPhrase = 'brandishes its horns at him'
  threatensRefsBot = true
;
zebra: LargeMammal
  'zebra/ungulate/mammal/beast/creature/animal' 'zebra'
  @zebraRoom
  "It<./s>s a zebra."
;
caribou: LargeMammal
  'caribou/ungulate/mammal/beast/creature/animal' 'caribou'
  "It<./s>s a caribou."
  threatensPhrase = 'snorts ferociously at him'
;
catAnimal: Mammal
  'cat/feline/mammal/beast/creature/animal' 'cat'
  "It<./s>s a cat."
  threatensPhrase = 'brandishes its claws at him'
  threatensRefsBot = true
;
clam: Invertebrate
  'clam/oyster/bivalve/invertebrate/beast/creature/animal' 'clam'
  "It<./s>s a clam."
  movesVerb = 'swims'
  hasNoEyes = true
;
cow: LargeMammal
  'cow/ungulate/mammal/beast/creature/animal' 'cow'
  "It<./s>s a cow."
  threatensPhrase = 'moos ferociously'
;
dragonfly: Insect
  'dragonfly/insect/beast/creature/animal' 'dragonfly'
  "It<./s>s a dragonfly."
;
duck: Bird
  'duck/bird/beast/creature/animal' 'duck'
  "It<./s>s a duck."
;
fox: LargeMammal
  'fox/carnivore/mammal/beast/creature/animal' 'fox'
  "It<./s>s a fox."
  threatensPhrase = 'snaps its jaws at him'
  threatensRefsBot = true
  scaresPhrase() { return nearlyMakesOffWithArm(); }
;
pelican: Bird
  'pelican/bird/beast/creature/animal' 'pelican'
  "It<./s>s a pelican."
;
rabbit: Mammal
  'rabbit/mammal/beast/creature/animal' 'rabbit'
  "It<./s>s a rabbit."
  threatensPhrase = 'glares at him'
  threatensRefsBot = true
;
ram: LargeMammal
  'ram/ungulate/mammal/beast/creature/animal' 'ram'
  "It<./s>s a ram."
  threatensPhrase = 'brandishes its horns at him'
  threatensRefsBot = true
;
scallop: AquaticInvertebrate
  'scallop/invertebrate/beast/creature/animal' 'scallop'
  "It<./s>s a scallop."
  hasNoEyes = true
;
squid: AquaticInvertebrate
  'squid/invertebrate/beast/creature/animal' 'squid'
  "It<./s>s a squid."
  threatensPhrase = 'brandishes its tentacles at him'
  threatensRefsBot = true
;
starfish: Invertebrate
  'starfish/echinoderm/invertebrate/beast/creature/animal' 'starfish'
  "It<./s>s a starfish."
  movesVerb = 'scurries'
  hasNoEyes = true
;
turkey: Bird
  'turkey/bird/beast/creature/animal' 'turkey'
  "It<./s>s a turkey."
;
whale: AquaticMammal
  'whale/mammal/beast/creature/animal' 'whale'
  "It<./s>s a whale."
;
woodpecker: FlyingBird
  'woodpecker/bird/beast/creature/animal' 'woodpecker'
  "It<./s>s a woodpecker."
;
*/

// -------------------------------------------------------------------
// ANIMAL MAZE: ROOM CONNECTORS
// -------------------------------------------------------------------

animConnAllBee: AnimalConnector room1=alligatorRoom   room2=beeRoom        ;
animConnBeeCra: AnimalConnector room1=beeRoom         room2=crabRoom       ;
animConnCraDol: AnimalConnector room1=crabRoom        room2=dolphinRoom    ;
animConnDolEle: AnimalConnector room1=dolphinRoom     room2=elephantRoom   ;
animConnEleFro: AnimalConnector room1=elephantRoom    room2=frogRoom       ;
animConnFroGir: AnimalConnector room1=frogRoom        room2=giraffeRoom    ;
animConnGirHum: AnimalConnector room1=giraffeRoom     room2=hummingbirdRoom;
animConnHumIgu: AnimalConnector room1=hummingbirdRoom room2=iguanaRoom     ;
animConnIguJel: AnimalConnector room1=iguanaRoom      room2=jellyfishRoom  ;
animConnJelKan: AnimalConnector room1=jellyfishRoom   room2=kangarooRoom   ;
animConnKanLad: AnimalConnector room1=kangarooRoom    room2=ladybugRoom    ;
animConnLadMon: AnimalConnector room1=ladybugRoom     room2=monkeyRoom     ;
animConnMonNew: AnimalConnector room1=monkeyRoom      room2=newtRoom       ;
animConnNewOct: AnimalConnector room1=newtRoom        room2=octopusRoom    ;
animConnOctPen: AnimalConnector room1=octopusRoom     room2=penguinRoom    ;
animConnPenQua: AnimalConnector room1=penguinRoom     room2=quailRoom      ;
animConnQuaRay: AnimalConnector room1=quailRoom       room2=rayRoom        ;
animConnRaySea: AnimalConnector room1=rayRoom         room2=seahorseRoom   ;
animConnSeaTrt: AnimalConnector room1=seahorseRoom    room2=turtleRoom     ;
animConnTrtUrc: AnimalConnector room1=turtleRoom      room2=urchinRoom     ;
animConnUrcVul: AnimalConnector room1=urchinRoom      room2=vultureRoom    ;
animConnVulWal: AnimalConnector room1=vultureRoom     room2=walrusRoom     ;
animConnWalXer: AnimalConnector room1=walrusRoom      room2=xercesRoom     ;
animConnXerYak: AnimalConnector room1=xercesRoom      room2=yakRoom        ;
animConnYakZeb: AnimalConnector room1=yakRoom         room2=zebraRoom      ;

// -------------------------------------------------------------------
// ANIMAL MAZE: FAKE CONNECTORS
// -------------------------------------------------------------------

//class FakeAlligatorConnector: FakeAnimalConnector
//  destAnimal = alligator
//;

class FakeAnimalConnector: FakeConnector, StopEventList
  destAnimal = grue
  origAnimal = grue
  travelDesc { doScript; }
  eventList = [
     &door1
    ,new function {
       if (!glob.goAnimalFuseIsOn) {
         glob.goAnimalFuseIsOn = true;
         "<.q>Last time I went down that passage, it didn<./s>t seem
           to go too well,<./q> says Sheila. <.q>Are you sure 
           you want me to go down that way again?<./q> ";
         ncYesNo.set(
           // YES:
           new function { doordeath; },
           // NO:
           '<.q>Right, let<./s>s play it safe for now,<./q>
             says Sheila. <.q>If we need to go down that way,
             we can always do it later.<./q> '
         );
       }
       else {
         doordeath;
       }
     }
    //,&doordeath
  ]
  doordeath {
    destAnimal.door3(self);
    endGame(ftDeath);
  }
  // NOTE! Change "an" to "the" *OR* "an," depending on context.
  
//  door1 {
//    "You start off in that direction, but run into ";
//    say(destAnimal.aNameObj);
//    "! The ";
//    say(destAnimal.greatAdj);
//    " ";
//    say(destAnimal.beastNoun);
//    " ";
//    say(destAnimal.noticesPhrase);
//    " that you are coming from the direction of its ";
//    say(rand('hated', 'bitter'));
//    " ";
//    say(rand('enemy', 'rival', 'adversary'));
//    ", the ";
//    say(self.origAnimal.name);
//    ". It ";
//    say(destAnimal.nearKillPhrase);
//    " before you ";
//    say(rand('wisely', 'prudently'));
//    " ";
//    say(rand('hightail it', 'run', 'retreat', 'hurry', 'flee'));
//    " back the way you came. ";
//  }
  door1 {
    destAnimal.door1(self);
    //"{You/he} start{s} off, but soon run{s} into
    //<<destAnimal.aNameObj>><<destAnimal.swimmingPhrase>>! The 
    //<<destAnimal.name>> 
    //<<destAnimal.noticesPhrase>> 
    //that {you/he} {is} coming from the direction of the
    //<<self.origAnimal.name>><<destAnimal.meanlookPhrase>>.\b
    //The <<destAnimal.name>> <<destAnimal.movesVerb>> up to your bot, 
    //<<destAnimal.threatensPhrase>>, and 
    //<<destAnimal.scaresPhrase()>>. {You/he} quickly
    //<<rand('hightail{s} it', 'run{s}', 'retreat{s}')>>
    //back the way {it/he} came. ";
  }
  nearKillPhrase  = movesVerb + ' up to him, ' + threatensPhrase + ', and ' + scaresPhrase() + ''
//  door1 {
//    "You start off, but soon run into
//    <<destAnimal.aNameObj>><<destAnimal.swimmingPhrase>>! The 
//    <<destAnimal.beastNoun>> 
//    <<destAnimal.noticesPhrase>> 
//    that you are coming from the direction of the
//    <<self.origAnimal.name>>, its 
//    <<rand('hated', 'bitter')>>
//    <<rand('enemy', 'rival', 'adversary')>>. It
//    <<destAnimal.nearKillPhrase>> before you
//    <<rand('wisely', 'prudently')>>
//    <<rand('hightail it', 'run', 'retreat')>>
//    back the way you came. ";
//  }
  
  //door1 = 'ERROR: You go that way, but the animal in that direction
  //          nearly kills you! There is an error here, because I<./s>m 
  //          supposed to be able to tell you what kind of animal it 
  //          is, but I can<./s>t! '
  door2 = 'Last time {you/he} went down that way, it seemed awfully dangerous. 
            Are you sure you want to go there again? '
//  door3 {
//    "You boldly return down the passageway. This time, the 
//    <<destAnimal.name>> is ready for you. And, knowing you are coming
//    from the direction of the hated
//    <<self.origAnimal.name>>, it 
//    <<destAnimal.killPhrase>>. ";
//  }
;

class FakeAllConn: FakeAnimalConnector destAnimal=alligator;
class FakeBeeConn: FakeAnimalConnector destAnimal=bee;
class FakeCarConn: FakeAnimalConnector destAnimal=caribou;
class FakeCatConn: FakeAnimalConnector destAnimal=catAnimal;
class FakeClaConn: FakeAnimalConnector destAnimal=clam;
class FakeCowConn: FakeAnimalConnector destAnimal=cow;
class FakeCraConn: FakeAnimalConnector destAnimal=crab;
class FakeDolConn: FakeAnimalConnector destAnimal=dolphin;
class FakeDraConn: FakeAnimalConnector destAnimal=dragonfly;
class FakeDucConn: FakeAnimalConnector destAnimal=duck;
class FakeEleConn: FakeAnimalConnector destAnimal=elephant;
class FakeFoxConn: FakeAnimalConnector destAnimal=fox;
class FakeFroConn: FakeAnimalConnector destAnimal=frog;
class FakeGirConn: FakeAnimalConnector destAnimal=giraffe;
class FakeHumConn: FakeAnimalConnector destAnimal=hummingbird;
class FakeIguConn: FakeAnimalConnector destAnimal=iguana;
class FakeJelConn: FakeAnimalConnector destAnimal=jellyfish;
class FakeKanConn: FakeAnimalConnector destAnimal=kangaroo;
class FakeLadConn: FakeAnimalConnector destAnimal=ladybug;
class FakeMonConn: FakeAnimalConnector destAnimal=monkey;
class FakeNewConn: FakeAnimalConnector destAnimal=newt;
class FakeOctConn: FakeAnimalConnector destAnimal=octopus;
class FakePelConn: FakeAnimalConnector destAnimal=pelican;
class FakePenConn: FakeAnimalConnector destAnimal=penguin;
class FakeQuaConn: FakeAnimalConnector destAnimal=quail;
class FakeRabConn: FakeAnimalConnector destAnimal=rabbit;
class FakeRamConn: FakeAnimalConnector destAnimal=ram;
class FakeRayConn: FakeAnimalConnector destAnimal=ray;
class FakeScaConn: FakeAnimalConnector destAnimal=scallop;
class FakeSeaConn: FakeAnimalConnector destAnimal=seahAnimal;
class FakeSquConn: FakeAnimalConnector destAnimal=squid;
class FakeStaConn: FakeAnimalConnector destAnimal=starfish;
class FakeTrkConn: FakeAnimalConnector destAnimal=turkey;
class FakeTrtConn: FakeAnimalConnector destAnimal=turtle;
class FakeUrcConn: FakeAnimalConnector destAnimal=urchin;
class FakeVulConn: FakeAnimalConnector destAnimal=vulture;
class FakeWalConn: FakeAnimalConnector destAnimal=walrus;
class FakeWhaConn: FakeAnimalConnector destAnimal=whale;
class FakeWooConn: FakeAnimalConnector destAnimal=woodpecker;
class FakeXerConn: FakeAnimalConnector destAnimal=xerces;
class FakeYakConn: FakeAnimalConnector destAnimal=yak;
class FakeZebConn: FakeAnimalConnector destAnimal=zebra;

fakeAnimConnAllCra: FakeCraConn origAnimal=alligator;
fakeAnimConnAllHum: FakeHumConn origAnimal=alligator;
fakeAnimConnBeeHum: FakeHumConn origAnimal=bee;
fakeAnimConnBeeIgu: FakeIguConn origAnimal=bee;
fakeAnimConnBeeTrk: FakeTrkConn origAnimal=bee;
fakeAnimConnCraAll: FakeAllConn origAnimal=crab;
fakeAnimConnCraHum: FakeHumConn origAnimal=crab;
fakeAnimConnCraWoo: FakeWooConn origAnimal=crab;
fakeAnimConnDolFro: FakeFroConn origAnimal=dolphin;
fakeAnimConnDolGir: FakeGirConn origAnimal=dolphin;
fakeAnimConnDolHum: FakeHumConn origAnimal=dolphin;
fakeAnimConnDolRab: FakeRabConn origAnimal=dolphin;
fakeAnimConnDolTrk: FakeTrkConn origAnimal=dolphin;
fakeAnimConnDolWoo: FakeWooConn origAnimal=dolphin;
fakeAnimConnEleCow: FakeCowConn origAnimal=elephant;
fakeAnimConnEleGir: FakeGirConn origAnimal=elephant;
fakeAnimConnElePel: FakePelConn origAnimal=elephant;
fakeAnimConnElePen: FakePenConn origAnimal=elephant;
fakeAnimConnEleSea: FakeSeaConn origAnimal=elephant;
fakeAnimConnEleWal: FakeWalConn origAnimal=elephant;
fakeAnimConnFroDol: FakeDolConn origAnimal=frog;
fakeAnimConnFroPel: FakePelConn origAnimal=frog;
fakeAnimConnFroRab: FakeRabConn origAnimal=frog;
fakeAnimConnFroSca: FakeScaConn origAnimal=frog;
fakeAnimConnFroWal: FakeWalConn origAnimal=frog;
fakeAnimConnFroWoo: FakeWooConn origAnimal=frog;
fakeAnimConnGirCow: FakeCowConn origAnimal=giraffe;
fakeAnimConnGirDol: FakeDolConn origAnimal=giraffe;
fakeAnimConnGirEle: FakeEleConn origAnimal=giraffe;
fakeAnimConnGirJel: FakeJelConn origAnimal=giraffe;
fakeAnimConnGirPen: FakePenConn origAnimal=giraffe;
fakeAnimConnGirTrk: FakeTrkConn origAnimal=giraffe;
fakeAnimConnHumAll: FakeAllConn origAnimal=hummingbird;
fakeAnimConnHumBee: FakeBeeConn origAnimal=hummingbird;
fakeAnimConnHumCra: FakeCraConn origAnimal=hummingbird;
fakeAnimConnHumDol: FakeDolConn origAnimal=hummingbird;
fakeAnimConnHumTrk: FakeTrkConn origAnimal=hummingbird;
fakeAnimConnHumWoo: FakeWooConn origAnimal=hummingbird;
fakeAnimConnIguBee: FakeBeeConn origAnimal=iguana;
fakeAnimConnIguFox: FakeFoxConn origAnimal=iguana;
fakeAnimConnIguTrk: FakeTrkConn origAnimal=iguana;
fakeAnimConnJelCow: FakeCowConn origAnimal=jellyfish;
fakeAnimConnJelFox: FakeFoxConn origAnimal=jellyfish;
fakeAnimConnJelGir: FakeGirConn origAnimal=jellyfish;
fakeAnimConnJelLad: FakeLadConn origAnimal=jellyfish;
fakeAnimConnJelOct: FakeOctConn origAnimal=jellyfish;
fakeAnimConnJelTrk: FakeTrkConn origAnimal=jellyfish;
fakeAnimConnKanDra: FakeDraConn origAnimal=kangaroo;
fakeAnimConnKanFox: FakeFoxConn origAnimal=kangaroo;
fakeAnimConnKanSqu: FakeSquConn origAnimal=kangaroo;
fakeAnimConnLadCow: FakeCowConn origAnimal=ladybug;
fakeAnimConnLadDra: FakeDraConn origAnimal=ladybug;
fakeAnimConnLadFox: FakeFoxConn origAnimal=ladybug;
fakeAnimConnLadJel: FakeJelConn origAnimal=ladybug;
fakeAnimConnLadOct: FakeOctConn origAnimal=ladybug;
fakeAnimConnLadSqu: FakeSquConn origAnimal=ladybug;
fakeAnimConnMonDra: FakeDraConn origAnimal=monkey;
fakeAnimConnMonOct: FakeOctConn origAnimal=monkey;
fakeAnimConnMonQua: FakeQuaConn origAnimal=monkey;
fakeAnimConnNewQua: FakeQuaConn origAnimal=newt;
fakeAnimConnNewRay: FakeRayConn origAnimal=newt;
fakeAnimConnNewWha: FakeWhaConn origAnimal=newt;
fakeAnimConnOctCow: FakeCowConn origAnimal=octopus;
fakeAnimConnOctDra: FakeDraConn origAnimal=octopus;
fakeAnimConnOctJel: FakeJelConn origAnimal=octopus;
fakeAnimConnOctLad: FakeLadConn origAnimal=octopus;
fakeAnimConnOctMon: FakeMonConn origAnimal=octopus;
fakeAnimConnOctQua: FakeQuaConn origAnimal=octopus;
fakeAnimConnPenCow: FakeCowConn origAnimal=penguin;
fakeAnimConnPenEle: FakeEleConn origAnimal=penguin;
fakeAnimConnPenGir: FakeGirConn origAnimal=penguin;
fakeAnimConnPenRay: FakeRayConn origAnimal=penguin;
fakeAnimConnPenSea: FakeSeaConn origAnimal=penguin;
fakeAnimConnPenWal: FakeWalConn origAnimal=penguin;
fakeAnimConnQuaCow: FakeCowConn origAnimal=quail;
fakeAnimConnQuaMon: FakeMonConn origAnimal=quail;
fakeAnimConnQuaNew: FakeNewConn origAnimal=quail;
fakeAnimConnQuaOct: FakeOctConn origAnimal=quail;
fakeAnimConnQuaSea: FakeSeaConn origAnimal=quail;
fakeAnimConnQuaWha: FakeWhaConn origAnimal=quail;
fakeAnimConnRayCla: FakeClaConn origAnimal=ray;
fakeAnimConnRayDuc: FakeDucConn origAnimal=ray;
fakeAnimConnRayNew: FakeNewConn origAnimal=ray;
fakeAnimConnRayPen: FakePenConn origAnimal=ray;
fakeAnimConnRayWha: FakeWhaConn origAnimal=ray;
fakeAnimConnRayXer: FakeXerConn origAnimal=ray;
fakeAnimConnSeaDuc: FakeDucConn origAnimal=seahAnimal;
fakeAnimConnSeaEle: FakeEleConn origAnimal=seahAnimal;
fakeAnimConnSeaPen: FakePenConn origAnimal=seahAnimal;
fakeAnimConnSeaQua: FakeQuaConn origAnimal=seahAnimal;
fakeAnimConnSeaWal: FakeWalConn origAnimal=seahAnimal;
fakeAnimConnSeaXer: FakeXerConn origAnimal=seahAnimal;
fakeAnimConnTrtCar: FakeCarConn origAnimal=turtle;
fakeAnimConnTrtPel: FakePelConn origAnimal=turtle;
fakeAnimConnTrtRam: FakeRamConn origAnimal=turtle;
fakeAnimConnTrtVul: FakeVulConn origAnimal=turtle;
fakeAnimConnTrtWal: FakeWalConn origAnimal=turtle;
fakeAnimConnTrtXer: FakeXerConn origAnimal=turtle;
fakeAnimConnUrcCar: FakeCarConn origAnimal=urchin;
fakeAnimConnUrcRam: FakeRamConn origAnimal=urchin;
fakeAnimConnUrcXer: FakeXerConn origAnimal=urchin;
fakeAnimConnVulCat: FakeCatConn origAnimal=vulture;
fakeAnimConnVulPel: FakePelConn origAnimal=vulture;
fakeAnimConnVulRam: FakeRamConn origAnimal=vulture;
fakeAnimConnVulSca: FakeScaConn origAnimal=vulture;
fakeAnimConnVulSta: FakeStaConn origAnimal=vulture;
fakeAnimConnVulTrt: FakeTrtConn origAnimal=vulture;
fakeAnimConnWalEle: FakeEleConn origAnimal=walrus;
fakeAnimConnWalFro: FakeFroConn origAnimal=walrus;
fakeAnimConnWalPel: FakePelConn origAnimal=walrus;
fakeAnimConnWalPen: FakePenConn origAnimal=walrus;
fakeAnimConnWalSea: FakeSeaConn origAnimal=walrus;
fakeAnimConnWalTrt: FakeTrtConn origAnimal=walrus;
fakeAnimConnXerCar: FakeCarConn origAnimal=xerces;
fakeAnimConnXerDuc: FakeDucConn origAnimal=xerces;
fakeAnimConnXerRay: FakeRayConn origAnimal=xerces;
fakeAnimConnXerSea: FakeSeaConn origAnimal=xerces;
fakeAnimConnXerTrt: FakeTrtConn origAnimal=xerces;
fakeAnimConnXerUrc: FakeUrcConn origAnimal=xerces;
fakeAnimConnYakCar: FakeCarConn origAnimal=yak;
fakeAnimConnYakCla: FakeClaConn origAnimal=yak;
fakeAnimConnYakDuc: FakeDucConn origAnimal=yak;
fakeAnimConnZebCla: FakeClaConn origAnimal=zebra;
fakeAnimConnZebDuc: FakeDucConn origAnimal=zebra;

// -------------------------------------------------------------------
// ANIMAL MAZE: ROOMS
// -------------------------------------------------------------------

alligatorRoom: ArNorthwest, AnimalRoom 'By the Alligator' 'the alligator'
  east      =     animConnAllBee
  south     = fakeAnimConnAllCra
  southeast = fakeAnimConnAllHum
;
beeRoom: ArNorth, AnimalRoom 'By the Bee' 'the bee'
  west      =     animConnAllBee
  southwest =     animConnBeeCra
  south     = fakeAnimConnBeeHum
  east      = fakeAnimConnBeeIgu
  southeast = fakeAnimConnBeeTrk
;
crabRoom: ArWest, AnimalRoom 'By the Crab' 'the crab'
  northeast =     animConnBeeCra
  southeast =     animConnCraDol
  north     = fakeAnimConnCraAll
  east      = fakeAnimConnCraHum
  south     = fakeAnimConnCraWoo
;
dolphinRoom: AnimalRoom 'By the Dolphin' 'the dolphin'
  northwest =     animConnCraDol
  southeast =     animConnDolEle
  south     = fakeAnimConnDolFro
  east      = fakeAnimConnDolGir
  north     = fakeAnimConnDolHum
  southwest = fakeAnimConnDolRab
  northeast = fakeAnimConnDolTrk
  west      = fakeAnimConnDolWoo
;
elephantRoom: AnimalRoom 'By the Elephant' 'the elephant'
  northwest =     animConnDolEle
  west      =     animConnEleFro
  northeast = fakeAnimConnEleCow
  north     = fakeAnimConnEleGir
  southwest = fakeAnimConnElePel
  east      = fakeAnimConnElePen
  southeast = fakeAnimConnEleSea
  south     = fakeAnimConnEleWal
;
frogRoom: AnimalRoom 'By the Frog' 'the frog'
  east      =     animConnEleFro
  northeast =     animConnFroGir
  north     = fakeAnimConnFroDol
  south     = fakeAnimConnFroPel
  west      = fakeAnimConnFroRab
  southwest = fakeAnimConnFroSca
  southeast = fakeAnimConnFroWal
  northwest = fakeAnimConnFroWoo
;
giraffeRoom: AnimalRoom 'By the Giraffe' 'the giraffe'
  southwest =     animConnFroGir
  northwest =     animConnGirHum
  east      = fakeAnimConnGirCow
  west      = fakeAnimConnGirDol
  south     = fakeAnimConnGirEle
  northeast = fakeAnimConnGirJel
  southeast = fakeAnimConnGirPen
  north     = fakeAnimConnGirTrk
;
hummingbirdRoom: AnimalRoom 'By the Hummingbird' 'the hummingbird'
  southeast =     animConnGirHum
  northeast =     animConnHumIgu
  northwest = fakeAnimConnHumAll
  north     = fakeAnimConnHumBee
  west      = fakeAnimConnHumCra
  south     = fakeAnimConnHumDol
  east      = fakeAnimConnHumTrk
  southwest = fakeAnimConnHumWoo
;
iguanaRoom: ArNorth, AnimalRoom 'By the Iguana' 'the iguana'
  southwest =     animConnHumIgu
  southeast =     animConnIguJel
  west      = fakeAnimConnIguBee
  east      = fakeAnimConnIguFox
  south     = fakeAnimConnIguTrk
;
jellyfishRoom: AnimalRoom 'By the Jellyfish' 'the jellyfish'
  northwest =     animConnIguJel
  northeast =     animConnJelKan
  south     = fakeAnimConnJelCow
  north     = fakeAnimConnJelFox
  southwest = fakeAnimConnJelGir
  east      = fakeAnimConnJelLad
  southeast = fakeAnimConnJelOct
  west      = fakeAnimConnJelTrk
;
kangarooRoom: ArNorth, AnimalRoom 'By the Kangaroo' 'the kangaroo'
  southwest =     animConnJelKan
  south     =     animConnKanLad
  southeast = fakeAnimConnKanDra
  west      = fakeAnimConnKanFox
  east      = fakeAnimConnKanSqu
;
ladybugRoom: AnimalRoom 'By the Ladybug' 'the ladybug'
  north     =     animConnKanLad
  southeast =     animConnLadMon
  southwest = fakeAnimConnLadCow
  east      = fakeAnimConnLadDra
  northwest = fakeAnimConnLadFox
  west      = fakeAnimConnLadJel
  south     = fakeAnimConnLadOct
  northeast = fakeAnimConnLadSqu
;
monkeyRoom: ArEast, AnimalRoom 'By the Monkey' 'the monkey'
  northwest =     animConnLadMon
  south     =     animConnMonNew
  north     = fakeAnimConnMonDra
  west      = fakeAnimConnMonOct
  southwest = fakeAnimConnMonQua
;
newtRoom: ArEast, AnimalRoom 'By the Newt' 'the newt'
  north     =     animConnMonNew
  northwest =     animConnNewOct
  west      = fakeAnimConnNewQua
  southwest = fakeAnimConnNewRay
  south     = fakeAnimConnNewWha
;
octopusRoom: AnimalRoom 'By the Octopus' 'the octopus'
  southeast =     animConnNewOct
  southwest =     animConnOctPen
  west      = fakeAnimConnOctCow
  northeast = fakeAnimConnOctDra
  northwest = fakeAnimConnOctJel
  north     = fakeAnimConnOctLad
  east      = fakeAnimConnOctMon
  south     = fakeAnimConnOctQua
;
penguinRoom: AnimalRoom 'By the Penguin' 'the penguin'
  northeast =     animConnOctPen
  east      =     animConnPenQua
  north     = fakeAnimConnPenCow
  west      = fakeAnimConnPenEle
  northwest = fakeAnimConnPenGir
  southeast = fakeAnimConnPenRay
  south     = fakeAnimConnPenSea
  southwest = fakeAnimConnPenWal
;
quailRoom: AnimalRoom 'By the Quail' 'the quail'
  west      =     animConnPenQua
  south     =     animConnQuaRay
  northwest = fakeAnimConnQuaCow
  northeast = fakeAnimConnQuaMon
  east      = fakeAnimConnQuaNew
  north     = fakeAnimConnQuaOct
  southwest = fakeAnimConnQuaSea
  southeast = fakeAnimConnQuaWha
;
rayRoom: AnimalRoom 'By the Ray' 'the ray'
  north     =     animConnQuaRay
  west      =     animConnRaySea
  southeast = fakeAnimConnRayCla
  south     = fakeAnimConnRayDuc
  northeast = fakeAnimConnRayNew
  northwest = fakeAnimConnRayPen
  east      = fakeAnimConnRayWha
  southwest = fakeAnimConnRayXer
;
seahorseRoom: AnimalRoom 'By the Seahorse' 'the seahorse'
  east      =     animConnRaySea
  southwest =     animConnSeaTrt
  southeast = fakeAnimConnSeaDuc
  northwest = fakeAnimConnSeaEle
  north     = fakeAnimConnSeaPen
  northeast = fakeAnimConnSeaQua
  west      = fakeAnimConnSeaWal
  south     = fakeAnimConnSeaXer
;
turtleRoom: AnimalRoom 'By the Turtle' 'the turtle'
  northeast =     animConnSeaTrt
  south     =     animConnTrtUrc
  southeast = fakeAnimConnTrtCar
  northwest = fakeAnimConnTrtPel
  southwest = fakeAnimConnTrtRam
  west      = fakeAnimConnTrtVul
  north     = fakeAnimConnTrtWal
  east      = fakeAnimConnTrtXer
;
urchinRoom: ArSouth, AnimalRoom 'By the Urchin' 'the urchin'
  north     =     animConnTrtUrc
  northwest =     animConnUrcVul
  east      = fakeAnimConnUrcCar
  west      = fakeAnimConnUrcRam
  northeast = fakeAnimConnUrcXer
;
vultureRoom: AnimalRoom 'By the Vulture' 'the vulture'
  southeast =     animConnUrcVul
  northeast =     animConnVulWal
  west      = fakeAnimConnVulCat
  north     = fakeAnimConnVulPel
  south     = fakeAnimConnVulRam
  northwest = fakeAnimConnVulSca
  southwest = fakeAnimConnVulSta
  east      = fakeAnimConnVulTrt
;
walrusRoom: AnimalRoom 'By the Walrus' 'the walrus'
  southwest =     animConnVulWal
  southeast =     animConnWalXer
  north     = fakeAnimConnWalEle
  northwest = fakeAnimConnWalFro
  west      = fakeAnimConnWalPel
  northeast = fakeAnimConnWalPen
  east      = fakeAnimConnWalSea
  south     = fakeAnimConnWalTrt
;
// change this later to reflect the butterfly state
xercesRoom: AnimalRoom 
  roomName {
    if (!butterflyIdM.isInExe)
      return 'By the X-Shaped Butterfly';
    else
      return 'By the Xerces Blue Butterfly';
  }
  destName {
    if (!butterflyIdM.isInExe)
      return 'the X-shaped butterfly';
    else
      return 'the Xerces blue butterfly';
  }
  enteringRoom(traveler) {
    if (!beenThere) {
      "As Sheila enters the next room, 
        she points to a butterfly and cries, ";
      if (!butterflyIdM.isInExe) {
        "<.q>Hey, look! That butterfly
          is shaped just like the letter X!<./q> ";
      }
      else {
        "<.q>Hey, look! That<./s>s 
          a Xerces blue butterfly, <i>Glaucopsyche xerces!</i>
          That<./s>s amazing! 
          I thought they were extinct!<./q> ";
      }
    }
    inherited(traveler);
  }
  northwest =     animConnWalXer
  southeast =     animConnXerYak
  south     = fakeAnimConnXerCar
  east      = fakeAnimConnXerDuc
  northeast = fakeAnimConnXerRay
  north     = fakeAnimConnXerSea
  west      = fakeAnimConnXerTrt
  southwest = fakeAnimConnXerUrc
;
yakRoom: ArSouth, AnimalRoom 'By the Yak' 'the yak'
  northwest =     animConnXerYak
  east      =     animConnYakZeb
  west      = fakeAnimConnYakCar
  northeast = fakeAnimConnYakCla
  north     = fakeAnimConnYakDuc
;
zebraRoom: ArSoutheast, AnimalRoom 'By the Zebra' 'the zebra'
  west      =     animConnYakZeb
  north     = fakeAnimConnZebCla
  northwest = fakeAnimConnZebDuc
  down      = holeInAnimalMaze
;

modify alligatorRoom   asscAnimal = alligator  ;
modify beeRoom         asscAnimal = bee        ;
modify crabRoom        asscAnimal = crab       ;
modify dolphinRoom     asscAnimal = dolphin    ;
modify elephantRoom    asscAnimal = elephant   ;
modify frogRoom        asscAnimal = frog       ;
modify giraffeRoom     asscAnimal = giraffe    ;
modify hummingbirdRoom asscAnimal = hummingbird;
modify iguanaRoom      asscAnimal = iguana     ;
modify jellyfishRoom   asscAnimal = jellyfish  ;
modify kangarooRoom    asscAnimal = kangaroo   ;
modify ladybugRoom     asscAnimal = ladybug    ;
modify monkeyRoom      asscAnimal = monkey     ;
modify newtRoom        asscAnimal = newt       ;
modify octopusRoom     asscAnimal = octopus    ;
modify penguinRoom     asscAnimal = penguin    ;
modify quailRoom       asscAnimal = quail      ;
modify rayRoom         asscAnimal = ray        ;
modify seahorseRoom    asscAnimal = seahAnimal ;
modify turtleRoom      asscAnimal = turtle     ;
modify urchinRoom      asscAnimal = urchin     ;
modify vultureRoom     asscAnimal = vulture    ;
modify walrusRoom      asscAnimal = walrus     ;
modify xercesRoom      asscAnimal = xerces     ;
modify yakRoom         asscAnimal = yak        ;
modify zebraRoom       asscAnimal = zebra      ;


// -------------------------------------------------------------------
// ANIMAL MAZE: MAP STUFF
// -------------------------------------------------------------------

function animRoomState(x) {
  if (gActor && gActor.location == x)
    return '2';
  else
    return '1';
}

function animConnState(x) {
  if (x.beenThere)
    return '2';
  else
    return '1';
}

function animalMapPrint() {
return '<table border="0" cellpadding="0" cellspacing="0">
<tr>
    <td><img src=\"animals/8x8-a00' + animRoomState(alligatorRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a0' + animRoomState(alligatorRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b00' + animRoomState(alligatorRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a00' + animRoomState(beeRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a0' + animRoomState(beeRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b00' + animRoomState(beeRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a00' + animRoomState(iguanaRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a0' + animRoomState(iguanaRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b00' + animRoomState(iguanaRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a0111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b001.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a00' + animRoomState(kangarooRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a0' + animRoomState(kangarooRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b00' + animRoomState(kangarooRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a0111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b001.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x49-a0' + animRoomState(alligatorRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/alligator.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b' + animConnState(animConnAllBee) + animRoomState(alligatorRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a' + animConnState(animConnAllBee) + animRoomState(beeRoom) + '1' + animConnState(animConnBeeCra) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/bee.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(beeRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(iguanaRoom) + '1' + animConnState(animConnHumIgu) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/iguana.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(iguanaRoom) + '1' + animConnState(animConnIguJel) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/fox.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(kangarooRoom) + '1' + animConnState(animConnJelKan) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/kangaroo.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(kangarooRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/squid.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b0111.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-c00' + animRoomState(alligatorRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(alligatorRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d1' + animConnState(animConnBeeCra) + animRoomState(alligatorRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c' + animConnState(animConnBeeCra) + '1' + animRoomState(beeRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(beeRoom) + animConnState(animConnBeeCra) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d1' + animConnState(animConnHumIgu) + animRoomState(beeRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c' + animConnState(animConnHumIgu) + '1' + animRoomState(iguanaRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(iguanaRoom) + animConnState(animConnHumIgu) + animConnState(animConnIguJel)+ '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d' + animConnState(animConnIguJel) + '1' + animRoomState(iguanaRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c1' + animConnState(animConnIguJel) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d1' + animConnState(animConnJelKan) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c' + animConnState(animConnJelKan) + '1' + animRoomState(kangarooRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b' + animConnState(animConnKanLad) + animRoomState(kangarooRoom) + animConnState(animConnJelKan) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d11' + animRoomState(kangarooRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d001.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-a00' + animRoomState(crabRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(crabRoom) + '1' + animConnState(animConnBeeCra) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b' + animConnState(animConnBeeCra) + '1' + animRoomState(crabRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a1' + animConnState(animConnBeeCra) + animRoomState(hummingbirdRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(hummingbirdRoom) + '1' + animConnState(animConnHumIgu) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b' + animConnState(animConnHumIgu) + '1' + animRoomState(hummingbirdRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a1' + animConnState(animConnHumIgu) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b1' + animConnState(animConnIguJel) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a' + animConnState(animConnIguJel) + '1' + animRoomState(jellyfishRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(jellyfishRoom) +  animConnState(animConnIguJel) +  animConnState(animConnJelKan) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b' + animConnState(animConnJelKan) + '1' + animRoomState(jellyfishRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a1' + animConnState(animConnJelKan) + animRoomState(ladybugRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a' + animConnState(animConnKanLad) + animRoomState(ladybugRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b11' + animRoomState(ladybugRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b001.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x49-a0' + animRoomState(crabRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/crab.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(crabRoom) + animConnState(animConnBeeCra) + animConnState(animConnCraDol) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(hummingbirdRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/hummingbird.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(hummingbirdRoom) + animConnState(animConnHumIgu) + animConnState(animConnGirHum) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/turkey.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(jellyfishRoom) + animConnState(animConnIguJel) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/jellyfish.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(jellyfishRoom) + animConnState(animConnJelKan) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(ladybugRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/ladybug.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(ladybugRoom) + '1' + animConnState(animConnLadMon) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/dragonfly.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b0111.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-c00' + animRoomState(crabRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(crabRoom) + '1' + animConnState(animConnCraDol) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d' + animConnState(animConnCraDol) + '1' + animRoomState(crabRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c1' + animConnState(animConnCraDol) + animRoomState(hummingbirdRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(hummingbirdRoom) + '1' + animConnState(animConnGirHum) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d' + animConnState(animConnGirHum) + '1' + animRoomState(hummingbirdRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c1' + animConnState(animConnGirHum) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c11' + animRoomState(jellyfishRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(jellyfishRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d11' + animRoomState(jellyfishRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c11' + animRoomState(ladybugRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(ladybugRoom) + '1' + animConnState(animConnLadMon) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d' + animConnState(animConnLadMon) + '1' + animRoomState(ladybugRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c1' + animConnState(animConnLadMon) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d001.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-a001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b1' + animConnState(animConnCraDol) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a' + animConnState(animConnCraDol) + '1' + animRoomState(dolphinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(dolphinRoom) + animConnState(animConnCraDol) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b1' + animConnState(animConnGirHum) + animRoomState(dolphinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a' + animConnState(animConnGirHum) + '1' + animRoomState(giraffeRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(giraffeRoom) + animConnState(animConnGirHum) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b11' + animRoomState(giraffeRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a11' + animRoomState(octopusRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(octopusRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b1' + animConnState(animConnLadMon) + animRoomState(octopusRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a' + animConnState(animConnLadMon) + '1' + animRoomState(monkeyRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(monkeyRoom) + animConnState(animConnLadMon) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b00' + animRoomState(monkeyRoom) + '.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x49-a0111.png\" border=\"0\"></td>
    <td><img src=\"animals/woodpecker.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(dolphinRoom) + animConnState(animConnCraDol) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/dolphin.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(dolphinRoom) + '1' + animConnState(animConnDolEle) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(giraffeRoom) + animConnState(animConnGirHum) + animConnState(animConnFroGir) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/giraffe.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(giraffeRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/cow.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(octopusRoom) + '1' + animConnState(animConnOctPen) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/octopus.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(octopusRoom) + '1' + animConnState(animConnNewOct) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(monkeyRoom) + animConnState(animConnLadMon) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/monkey.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b0' + animRoomState(monkeyRoom) + '11.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-c001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c11' + animRoomState(dolphinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(dolphinRoom) + '1' + animConnState(animConnDolEle) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d' + animConnState(animConnDolEle) + animConnState(animConnFroGir) + animRoomState(dolphinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c' + animConnState(animConnFroGir) + animConnState(animConnDolEle) + animRoomState(giraffeRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(giraffeRoom) + animConnState(animConnFroGir) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d11' + animRoomState(giraffeRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d1' + animConnState(animConnOctPen) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c' + animConnState(animConnOctPen) + '1' + animRoomState(octopusRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(octopusRoom) + animConnState(animConnOctPen) + animConnState(animConnNewOct)+ '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d' + animConnState(animConnNewOct) + '1' + animRoomState(octopusRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c1' + animConnState(animConnNewOct) + animRoomState(monkeyRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b' + animConnState(animConnMonNew) + animRoomState(monkeyRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d00' + animRoomState(monkeyRoom) + '.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-a001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a11' + animRoomState(frogRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(frogRoom) + '1' + animConnState(animConnFroGir) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b' + animConnState(animConnFroGir) + animConnState(animConnDolEle) + animRoomState(frogRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a' + animConnState(animConnDolEle) + animConnState(animConnFroGir) + animRoomState(elephantRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(elephantRoom) + animConnState(animConnDolEle) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b11' + animRoomState(elephantRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a11' + animRoomState(penguinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(penguinRoom) + '1' + animConnState(animConnOctPen) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b' + animConnState(animConnOctPen) + '1' + animRoomState(penguinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a1' + animConnState(animConnOctPen) + animRoomState(quailRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(quailRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b1' + animConnState(animConnNewOct) + animRoomState(quailRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a' + animConnState(animConnNewOct) + '1' + animRoomState(newtRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a' + animConnState(animConnMonNew) + animRoomState(newtRoom) + animConnState(animConnNewOct) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b00' + animRoomState(newtRoom) + '.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x49-a0111.png\" border=\"0\"></td>
    <td><img src=\"animals/rabbit.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(frogRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/frog.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b' + animConnState(animConnEleFro) + animRoomState(frogRoom) + animConnState(animConnFroGir) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a' + animConnState(animConnEleFro) + animRoomState(elephantRoom) + animConnState(animConnDolEle) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/elephant.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(elephantRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(penguinRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/penguin.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b' + animConnState(animConnPenQua) + animRoomState(penguinRoom) + animConnState(animConnOctPen) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a' + animConnState(animConnPenQua) + animRoomState(quailRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/quail.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(quailRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(newtRoom) + animConnState(animConnNewOct) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/newt.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b0' + animRoomState(newtRoom) + '11.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-c001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c11' + animRoomState(frogRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(frogRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d11' + animRoomState(frogRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c11' + animRoomState(elephantRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(elephantRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d11' + animRoomState(elephantRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c11' + animRoomState(penguinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(penguinRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d11' + animRoomState(penguinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c11' + animRoomState(quailRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b' + animConnState(animConnQuaRay) + animRoomState(quailRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d11' + animRoomState(quailRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c11' + animRoomState(newtRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(newtRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d00' + animRoomState(newtRoom) + '.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-a001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a11' + animRoomState(walrusRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(walrusRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b11' + animRoomState(walrusRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a11' + animRoomState(seahorseRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(seahorseRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b11' + animRoomState(seahorseRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a11' + animRoomState(rayRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a' + animConnState(animConnQuaRay) + animRoomState(rayRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b11' + animRoomState(rayRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b001.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x49-a0111.png\" border=\"0\"></td>
    <td><img src=\"animals/scallop.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/pelican.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(walrusRoom) + '1' + animConnState(animConnVulWal) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/walrus.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(walrusRoom) + '1' + animConnState(animConnWalXer) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(seahorseRoom) + '1' + animConnState(animConnSeaTrt) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/seahorse.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b' + animConnState(animConnRaySea) + animRoomState(seahorseRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a' + animConnState(animConnRaySea) + animRoomState(rayRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/ray.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(rayRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/whale.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b0111.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-c001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d1' + animConnState(animConnVulWal) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c' + animConnState(animConnVulWal) + '1' + animRoomState(walrusRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(walrusRoom) + animConnState(animConnVulWal) + animConnState(animConnWalXer)+ '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d' + animConnState(animConnWalXer) + animConnState(animConnSeaTrt) + animRoomState(walrusRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c' + animConnState(animConnSeaTrt) + animConnState(animConnWalXer) + animRoomState(seahorseRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(seahorseRoom) + animConnState(animConnSeaTrt) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d11' + animRoomState(seahorseRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c11' + animRoomState(rayRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(rayRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d11' + animRoomState(rayRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d001.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-a001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a11' + animRoomState(vultureRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(vultureRoom) + '1' + animConnState(animConnVulWal) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b' + animConnState(animConnVulWal) + '1' + animRoomState(vultureRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a1' + animConnState(animConnVulWal) + animRoomState(turtleRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(turtleRoom) + '1' + animConnState(animConnSeaTrt) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b' + animConnState(animConnSeaTrt) + animConnState(animConnWalXer) + animRoomState(turtleRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a' + animConnState(animConnWalXer) + animConnState(animConnSeaTrt) + animRoomState(xercesRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(xercesRoom) + animConnState(animConnWalXer) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b11' + animRoomState(xercesRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b001.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x49-a0111.png\" border=\"0\"></td>
    <td><img src=\"animals/cat.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(vultureRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/vulture.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(vultureRoom) + animConnState(animConnVulWal) + animConnState(animConnUrcVul) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(turtleRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/turtle.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(turtleRoom) + animConnState(animConnSeaTrt) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(xercesRoom) + animConnState(animConnWalXer) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/xerces.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(xercesRoom) + '1' + animConnState(animConnXerYak) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/duck.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/clam.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b0111.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-c001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c11' + animRoomState(vultureRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(vultureRoom) + '1' + animConnState(animConnUrcVul) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d' + animConnState(animConnUrcVul) + '1' + animRoomState(vultureRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c1' + animConnState(animConnUrcVul) + animRoomState(turtleRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b' + animConnState(animConnTrtUrc) + animRoomState(turtleRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d11' + animRoomState(turtleRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c11' + animRoomState(xercesRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1' + animRoomState(xercesRoom) + '1' + animConnState(animConnXerYak) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d' + animConnState(animConnXerYak) + '1' + animRoomState(xercesRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c1' + animConnState(animConnXerYak) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d001.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-a001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b1' + animConnState(animConnUrcVul) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a' + animConnState(animConnUrcVul) + '1' + animRoomState(urchinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a' + animConnState(animConnTrtUrc) + animRoomState(urchinRoom) + animConnState(animConnUrcVul) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b11' + animRoomState(urchinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a111.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b1' + animConnState(animConnXerYak) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a' + animConnState(animConnXerYak) + '1' + animRoomState(yakRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(yakRoom) + animConnState(animConnXerYak) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b11' + animRoomState(yakRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-a11' + animRoomState(zebraRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-a1' + animRoomState(zebraRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-b00' + animRoomState(zebraRoom) + '.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x49-a0111.png\" border=\"0\"></td>
    <td><img src=\"animals/starfish.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/ram.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(urchinRoom) + animConnState(animConnUrcVul) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/urchin.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1' + animRoomState(urchinRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1111.png\" border=\"0\"></td>
    <td><img src=\"animals/caribou.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b1111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a1' + animRoomState(yakRoom) + animConnState(animConnXerYak) + '1.png\" border=\"0\"></td>
    <td><img src=\"animals/yak.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b' + animConnState(animConnYakZeb) + animRoomState(yakRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x49-a' + animConnState(animConnYakZeb) + animRoomState(zebraRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/zebra.jpg\" border=\"0\"></td>
    <td><img src=\"animals/8x49-b0' + animRoomState(zebraRoom) + '11.png\" border=\"0\"></td>
</tr>
<tr>
    <td><img src=\"animals/8x8-c001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b0111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d001.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b0111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d001.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c00' + animRoomState(urchinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b0' + animRoomState(urchinRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d00' + animRoomState(urchinRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c001.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b0111.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d001.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c00' + animRoomState(yakRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b0' + animRoomState(yakRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d00' + animRoomState(yakRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-c00' + animRoomState(zebraRoom) + '.png\" border=\"0\"></td>
    <td><img src=\"animals/49x8-b0' + animRoomState(zebraRoom) + '11.png\" border=\"0\"></td>
    <td><img src=\"animals/8x8-d00' + animRoomState(zebraRoom) + '.png\" border=\"0\"></td>
</tr>
</table>'
+ doCompass(true);
}

/*
I could have used the following style tag, but it only saved 8k in the 
size of the compiled .t3 game file, and it caused the map to output
almost three times slower.

animalStyleTag: StyleTag
  tagName   = 'animals'
  openText  = '<td><img src=\"animals/'
  closeText = '.png\" border=\"0\"></td>'
;

function animalMapPrint() {
return '<table border="0" cellpadding="0" cellspacing="0">
<tr>
    <.animals>8x8-a00' + animRoomState(alligatorRoom) + '<./animals>
    <.animals>49x8-a0' + animRoomState(alligatorRoom) + '11<./animals>
    <.animals>8x8-b00' + animRoomState(alligatorRoom) + '<./animals>
    <.animals>8x8-a00' + animRoomState(beeRoom) + '<./animals>
    <.animals>49x8-a0' + animRoomState(beeRoom) + '11<./animals>
    <.animals>8x8-b00' + animRoomState(beeRoom) + '<./animals>
    <.animals>8x8-a00' + animRoomState(iguanaRoom) + '<./animals>
    <.animals>49x8-a0' + animRoomState(iguanaRoom) + '11<./animals>
    <.animals>8x8-b00' + animRoomState(iguanaRoom) + '<./animals>
    <.animals>8x8-a001<./animals>
    <.animals>49x8-a0111<./animals>
    <.animals>8x8-b001<./animals>
    <.animals>8x8-a00' + animRoomState(kangarooRoom) + '<./animals>
    <.animals>49x8-a0' + animRoomState(kangarooRoom) + '11<./animals>
    <.animals>8x8-b00' + animRoomState(kangarooRoom) + '<./animals>
    <.animals>8x8-a001<./animals>
    <.animals>49x8-a0111<./animals>
    <.animals>8x8-b001<./animals>
</tr>
<tr>
    <.animals>8x49-a0' + animRoomState(alligatorRoom) + '11<./animals>
    <.animals>alligator.jpg\" border=\"0\"></td>
    <.animals>8x49-b' + animConnState(animConnAllBee) + animRoomState(alligatorRoom) + '11<./animals>
    <.animals>8x49-a' + animConnState(animConnAllBee) + animRoomState(beeRoom) + '1' + animConnState(animConnBeeCra) + '<./animals>
    <.animals>bee.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(beeRoom) + '11<./animals>
    <.animals>8x49-a1' + animRoomState(iguanaRoom) + '1' + animConnState(animConnHumIgu) + '<./animals>
    <.animals>iguana.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(iguanaRoom) + '1' + animConnState(animConnIguJel) + '<./animals>
    <.animals>8x49-a1111<./animals>
    <.animals>fox.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1' + animRoomState(kangarooRoom) + '1' + animConnState(animConnJelKan) + '<./animals>
    <.animals>kangaroo.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(kangarooRoom) + '11<./animals>
    <.animals>8x49-a1111<./animals>
    <.animals>squid.jpg\" border=\"0\"></td>
    <.animals>8x49-b0111<./animals>
</tr>
<tr>
    <.animals>8x8-c00' + animRoomState(alligatorRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(alligatorRoom) + '11<./animals>
    <.animals>8x8-d1' + animConnState(animConnBeeCra) + animRoomState(alligatorRoom) + '<./animals>
    <.animals>8x8-c' + animConnState(animConnBeeCra) + '1' + animRoomState(beeRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(beeRoom) + animConnState(animConnBeeCra) + '1<./animals>
    <.animals>8x8-d1' + animConnState(animConnHumIgu) + animRoomState(beeRoom) + '<./animals>
    <.animals>8x8-c' + animConnState(animConnHumIgu) + '1' + animRoomState(iguanaRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(iguanaRoom) + animConnState(animConnHumIgu) + animConnState(animConnIguJel)+ '<./animals>
    <.animals>8x8-d' + animConnState(animConnIguJel) + '1' + animRoomState(iguanaRoom) + '<./animals>
    <.animals>8x8-c1' + animConnState(animConnIguJel) + '1<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d1' + animConnState(animConnJelKan) + '1<./animals>
    <.animals>8x8-c' + animConnState(animConnJelKan) + '1' + animRoomState(kangarooRoom) + '<./animals>
    <.animals>49x8-b' + animConnState(animConnKanLad) + animRoomState(kangarooRoom) + animConnState(animConnJelKan) + '1<./animals>
    <.animals>8x8-d11' + animRoomState(kangarooRoom) + '<./animals>
    <.animals>8x8-c111<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d001<./animals>
</tr>
<tr>
    <.animals>8x8-a00' + animRoomState(crabRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(crabRoom) + '1' + animConnState(animConnBeeCra) + '<./animals>
    <.animals>8x8-b' + animConnState(animConnBeeCra) + '1' + animRoomState(crabRoom) + '<./animals>
    <.animals>8x8-a1' + animConnState(animConnBeeCra) + animRoomState(hummingbirdRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(hummingbirdRoom) + '1' + animConnState(animConnHumIgu) + '<./animals>
    <.animals>8x8-b' + animConnState(animConnHumIgu) + '1' + animRoomState(hummingbirdRoom) + '<./animals>
    <.animals>8x8-a1' + animConnState(animConnHumIgu) + '1<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b1' + animConnState(animConnIguJel) + '1<./animals>
    <.animals>8x8-a' + animConnState(animConnIguJel) + '1' + animRoomState(jellyfishRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(jellyfishRoom) +  animConnState(animConnIguJel) +  animConnState(animConnJelKan) + '<./animals>
    <.animals>8x8-b' + animConnState(animConnJelKan) + '1' + animRoomState(jellyfishRoom) + '<./animals>
    <.animals>8x8-a1' + animConnState(animConnJelKan) + animRoomState(ladybugRoom) + '<./animals>
    <.animals>49x8-a' + animConnState(animConnKanLad) + animRoomState(ladybugRoom) + '11<./animals>
    <.animals>8x8-b11' + animRoomState(ladybugRoom) + '<./animals>
    <.animals>8x8-a111<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b001<./animals>
</tr>
<tr>
    <.animals>8x49-a0' + animRoomState(crabRoom) + '11<./animals>
    <.animals>crab.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(crabRoom) + animConnState(animConnBeeCra) + animConnState(animConnCraDol) + '<./animals>
    <.animals>8x49-a1' + animRoomState(hummingbirdRoom) + '11<./animals>
    <.animals>hummingbird.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(hummingbirdRoom) + animConnState(animConnHumIgu) + animConnState(animConnGirHum) + '<./animals>
    <.animals>8x49-a1111<./animals>
    <.animals>turkey.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1' + animRoomState(jellyfishRoom) + animConnState(animConnIguJel) + '1<./animals>
    <.animals>jellyfish.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(jellyfishRoom) + animConnState(animConnJelKan) + '1<./animals>
    <.animals>8x49-a1' + animRoomState(ladybugRoom) + '11<./animals>
    <.animals>ladybug.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(ladybugRoom) + '1' + animConnState(animConnLadMon) + '<./animals>
    <.animals>8x49-a1111<./animals>
    <.animals>dragonfly.jpg\" border=\"0\"></td>
    <.animals>8x49-b0111<./animals>
</tr>
<tr>
    <.animals>8x8-c00' + animRoomState(crabRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(crabRoom) + '1' + animConnState(animConnCraDol) + '<./animals>
    <.animals>8x8-d' + animConnState(animConnCraDol) + '1' + animRoomState(crabRoom) + '<./animals>
    <.animals>8x8-c1' + animConnState(animConnCraDol) + animRoomState(hummingbirdRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(hummingbirdRoom) + '1' + animConnState(animConnGirHum) + '<./animals>
    <.animals>8x8-d' + animConnState(animConnGirHum) + '1' + animRoomState(hummingbirdRoom) + '<./animals>
    <.animals>8x8-c1' + animConnState(animConnGirHum) + '1<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d111<./animals>
    <.animals>8x8-c11' + animRoomState(jellyfishRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(jellyfishRoom) + '11<./animals>
    <.animals>8x8-d11' + animRoomState(jellyfishRoom) + '<./animals>
    <.animals>8x8-c11' + animRoomState(ladybugRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(ladybugRoom) + '1' + animConnState(animConnLadMon) + '<./animals>
    <.animals>8x8-d' + animConnState(animConnLadMon) + '1' + animRoomState(ladybugRoom) + '<./animals>
    <.animals>8x8-c1' + animConnState(animConnLadMon) + '1<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d001<./animals>
</tr>
<tr>
    <.animals>8x8-a001<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b1' + animConnState(animConnCraDol) + '1<./animals>
    <.animals>8x8-a' + animConnState(animConnCraDol) + '1' + animRoomState(dolphinRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(dolphinRoom) + animConnState(animConnCraDol) + '1<./animals>
    <.animals>8x8-b1' + animConnState(animConnGirHum) + animRoomState(dolphinRoom) + '<./animals>
    <.animals>8x8-a' + animConnState(animConnGirHum) + '1' + animRoomState(giraffeRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(giraffeRoom) + animConnState(animConnGirHum) + '1<./animals>
    <.animals>8x8-b11' + animRoomState(giraffeRoom) + '<./animals>
    <.animals>8x8-a111<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b111<./animals>
    <.animals>8x8-a11' + animRoomState(octopusRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(octopusRoom) + '11<./animals>
    <.animals>8x8-b1' + animConnState(animConnLadMon) + animRoomState(octopusRoom) + '<./animals>
    <.animals>8x8-a' + animConnState(animConnLadMon) + '1' + animRoomState(monkeyRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(monkeyRoom) + animConnState(animConnLadMon) + '1<./animals>
    <.animals>8x8-b00' + animRoomState(monkeyRoom) + '<./animals>
</tr>
<tr>
    <.animals>8x49-a0111<./animals>
    <.animals>woodpecker.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1' + animRoomState(dolphinRoom) + animConnState(animConnCraDol) + '1<./animals>
    <.animals>dolphin.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(dolphinRoom) + '1' + animConnState(animConnDolEle) + '<./animals>
    <.animals>8x49-a1' + animRoomState(giraffeRoom) + animConnState(animConnGirHum) + animConnState(animConnFroGir) + '<./animals>
    <.animals>giraffe.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(giraffeRoom) + '11<./animals>
    <.animals>8x49-a1111<./animals>
    <.animals>cow.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1' + animRoomState(octopusRoom) + '1' + animConnState(animConnOctPen) + '<./animals>
    <.animals>octopus.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(octopusRoom) + '1' + animConnState(animConnNewOct) + '<./animals>
    <.animals>8x49-a1' + animRoomState(monkeyRoom) + animConnState(animConnLadMon) + '1<./animals>
    <.animals>monkey.jpg\" border=\"0\"></td>
    <.animals>8x49-b0' + animRoomState(monkeyRoom) + '11<./animals>
</tr>
<tr>
    <.animals>8x8-c001<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d111<./animals>
    <.animals>8x8-c11' + animRoomState(dolphinRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(dolphinRoom) + '1' + animConnState(animConnDolEle) + '<./animals>
    <.animals>8x8-d' + animConnState(animConnDolEle) + animConnState(animConnFroGir) + animRoomState(dolphinRoom) + '<./animals>
    <.animals>8x8-c' + animConnState(animConnFroGir) + animConnState(animConnDolEle) + animRoomState(giraffeRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(giraffeRoom) + animConnState(animConnFroGir) + '1<./animals>
    <.animals>8x8-d11' + animRoomState(giraffeRoom) + '<./animals>
    <.animals>8x8-c111<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d1' + animConnState(animConnOctPen) + '1<./animals>
    <.animals>8x8-c' + animConnState(animConnOctPen) + '1' + animRoomState(octopusRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(octopusRoom) + animConnState(animConnOctPen) + animConnState(animConnNewOct)+ '<./animals>
    <.animals>8x8-d' + animConnState(animConnNewOct) + '1' + animRoomState(octopusRoom) + '<./animals>
    <.animals>8x8-c1' + animConnState(animConnNewOct) + animRoomState(monkeyRoom) + '<./animals>
    <.animals>49x8-b' + animConnState(animConnMonNew) + animRoomState(monkeyRoom) + '11<./animals>
    <.animals>8x8-d00' + animRoomState(monkeyRoom) + '<./animals>
</tr>
<tr>
    <.animals>8x8-a001<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b111<./animals>
    <.animals>8x8-a11' + animRoomState(frogRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(frogRoom) + '1' + animConnState(animConnFroGir) + '<./animals>
    <.animals>8x8-b' + animConnState(animConnFroGir) + animConnState(animConnDolEle) + animRoomState(frogRoom) + '<./animals>
    <.animals>8x8-a' + animConnState(animConnDolEle) + animConnState(animConnFroGir) + animRoomState(elephantRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(elephantRoom) + animConnState(animConnDolEle) + '1<./animals>
    <.animals>8x8-b11' + animRoomState(elephantRoom) + '<./animals>
    <.animals>8x8-a11' + animRoomState(penguinRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(penguinRoom) + '1' + animConnState(animConnOctPen) + '<./animals>
    <.animals>8x8-b' + animConnState(animConnOctPen) + '1' + animRoomState(penguinRoom) + '<./animals>
    <.animals>8x8-a1' + animConnState(animConnOctPen) + animRoomState(quailRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(quailRoom) + '11<./animals>
    <.animals>8x8-b1' + animConnState(animConnNewOct) + animRoomState(quailRoom) + '<./animals>
    <.animals>8x8-a' + animConnState(animConnNewOct) + '1' + animRoomState(newtRoom) + '<./animals>
    <.animals>49x8-a' + animConnState(animConnMonNew) + animRoomState(newtRoom) + animConnState(animConnNewOct) + '1<./animals>
    <.animals>8x8-b00' + animRoomState(newtRoom) + '<./animals>
</tr>
<tr>
    <.animals>8x49-a0111<./animals>
    <.animals>rabbit.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1' + animRoomState(frogRoom) + '11<./animals>
    <.animals>frog.jpg\" border=\"0\"></td>
    <.animals>8x49-b' + animConnState(animConnEleFro) + animRoomState(frogRoom) + animConnState(animConnFroGir) + '1<./animals>
    <.animals>8x49-a' + animConnState(animConnEleFro) + animRoomState(elephantRoom) + animConnState(animConnDolEle) + '1<./animals>
    <.animals>elephant.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(elephantRoom) + '11<./animals>
    <.animals>8x49-a1' + animRoomState(penguinRoom) + '11<./animals>
    <.animals>penguin.jpg\" border=\"0\"></td>
    <.animals>8x49-b' + animConnState(animConnPenQua) + animRoomState(penguinRoom) + animConnState(animConnOctPen) + '1<./animals>
    <.animals>8x49-a' + animConnState(animConnPenQua) + animRoomState(quailRoom) + '11<./animals>
    <.animals>quail.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(quailRoom) + '11<./animals>
    <.animals>8x49-a1' + animRoomState(newtRoom) + animConnState(animConnNewOct) + '1<./animals>
    <.animals>newt.jpg\" border=\"0\"></td>
    <.animals>8x49-b0' + animRoomState(newtRoom) + '11<./animals>
</tr>
<tr>
    <.animals>8x8-c001<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d111<./animals>
    <.animals>8x8-c11' + animRoomState(frogRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(frogRoom) + '11<./animals>
    <.animals>8x8-d11' + animRoomState(frogRoom) + '<./animals>
    <.animals>8x8-c11' + animRoomState(elephantRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(elephantRoom) + '11<./animals>
    <.animals>8x8-d11' + animRoomState(elephantRoom) + '<./animals>
    <.animals>8x8-c11' + animRoomState(penguinRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(penguinRoom) + '11<./animals>
    <.animals>8x8-d11' + animRoomState(penguinRoom) + '<./animals>
    <.animals>8x8-c11' + animRoomState(quailRoom) + '<./animals>
    <.animals>49x8-b' + animConnState(animConnQuaRay) + animRoomState(quailRoom) + '11<./animals>
    <.animals>8x8-d11' + animRoomState(quailRoom) + '<./animals>
    <.animals>8x8-c11' + animRoomState(newtRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(newtRoom) + '11<./animals>
    <.animals>8x8-d00' + animRoomState(newtRoom) + '<./animals>
</tr>
<tr>
    <.animals>8x8-a001<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b111<./animals>
    <.animals>8x8-a111<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b111<./animals>
    <.animals>8x8-a11' + animRoomState(walrusRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(walrusRoom) + '11<./animals>
    <.animals>8x8-b11' + animRoomState(walrusRoom) + '<./animals>
    <.animals>8x8-a11' + animRoomState(seahorseRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(seahorseRoom) + '11<./animals>
    <.animals>8x8-b11' + animRoomState(seahorseRoom) + '<./animals>
    <.animals>8x8-a11' + animRoomState(rayRoom) + '<./animals>
    <.animals>49x8-a' + animConnState(animConnQuaRay) + animRoomState(rayRoom) + '11<./animals>
    <.animals>8x8-b11' + animRoomState(rayRoom) + '<./animals>
    <.animals>8x8-a111<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b001<./animals>
</tr>
<tr>
    <.animals>8x49-a0111<./animals>
    <.animals>scallop.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1111<./animals>
    <.animals>pelican.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1' + animRoomState(walrusRoom) + '1' + animConnState(animConnVulWal) + '<./animals>
    <.animals>walrus.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(walrusRoom) + '1' + animConnState(animConnWalXer) + '<./animals>
    <.animals>8x49-a1' + animRoomState(seahorseRoom) + '1' + animConnState(animConnSeaTrt) + '<./animals>
    <.animals>seahorse.jpg\" border=\"0\"></td>
    <.animals>8x49-b' + animConnState(animConnRaySea) + animRoomState(seahorseRoom) + '11<./animals>
    <.animals>8x49-a' + animConnState(animConnRaySea) + animRoomState(rayRoom) + '11<./animals>
    <.animals>ray.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(rayRoom) + '11<./animals>
    <.animals>8x49-a1111<./animals>
    <.animals>whale.jpg\" border=\"0\"></td>
    <.animals>8x49-b0111<./animals>
</tr>
<tr>
    <.animals>8x8-c001<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d111<./animals>
    <.animals>8x8-c111<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d1' + animConnState(animConnVulWal) + '1<./animals>
    <.animals>8x8-c' + animConnState(animConnVulWal) + '1' + animRoomState(walrusRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(walrusRoom) + animConnState(animConnVulWal) + animConnState(animConnWalXer)+ '<./animals>
    <.animals>8x8-d' + animConnState(animConnWalXer) + animConnState(animConnSeaTrt) + animRoomState(walrusRoom) + '<./animals>
    <.animals>8x8-c' + animConnState(animConnSeaTrt) + animConnState(animConnWalXer) + animRoomState(seahorseRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(seahorseRoom) + animConnState(animConnSeaTrt) + '1<./animals>
    <.animals>8x8-d11' + animRoomState(seahorseRoom) + '<./animals>
    <.animals>8x8-c11' + animRoomState(rayRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(rayRoom) + '11<./animals>
    <.animals>8x8-d11' + animRoomState(rayRoom) + '<./animals>
    <.animals>8x8-c111<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d001<./animals>
</tr>
<tr>
    <.animals>8x8-a001<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b111<./animals>
    <.animals>8x8-a11' + animRoomState(vultureRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(vultureRoom) + '1' + animConnState(animConnVulWal) + '<./animals>
    <.animals>8x8-b' + animConnState(animConnVulWal) + '1' + animRoomState(vultureRoom) + '<./animals>
    <.animals>8x8-a1' + animConnState(animConnVulWal) + animRoomState(turtleRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(turtleRoom) + '1' + animConnState(animConnSeaTrt) + '<./animals>
    <.animals>8x8-b' + animConnState(animConnSeaTrt) + animConnState(animConnWalXer) + animRoomState(turtleRoom) + '<./animals>
    <.animals>8x8-a' + animConnState(animConnWalXer) + animConnState(animConnSeaTrt) + animRoomState(xercesRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(xercesRoom) + animConnState(animConnWalXer) + '1<./animals>
    <.animals>8x8-b11' + animRoomState(xercesRoom) + '<./animals>
    <.animals>8x8-a111<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b111<./animals>
    <.animals>8x8-a111<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b001<./animals>
</tr>
<tr>
    <.animals>8x49-a0111<./animals>
    <.animals>cat.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1' + animRoomState(vultureRoom) + '11<./animals>
    <.animals>vulture.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(vultureRoom) + animConnState(animConnVulWal) + animConnState(animConnUrcVul) + '<./animals>
    <.animals>8x49-a1' + animRoomState(turtleRoom) + '11<./animals>
    <.animals>turtle.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(turtleRoom) + animConnState(animConnSeaTrt) + '1<./animals>
    <.animals>8x49-a1' + animRoomState(xercesRoom) + animConnState(animConnWalXer) + '1<./animals>
    <.animals>xerces.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(xercesRoom) + '1' + animConnState(animConnXerYak) + '<./animals>
    <.animals>8x49-a1111<./animals>
    <.animals>duck.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1111<./animals>
    <.animals>clam.jpg\" border=\"0\"></td>
    <.animals>8x49-b0111<./animals>
</tr>
<tr>
    <.animals>8x8-c001<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d111<./animals>
    <.animals>8x8-c11' + animRoomState(vultureRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(vultureRoom) + '1' + animConnState(animConnUrcVul) + '<./animals>
    <.animals>8x8-d' + animConnState(animConnUrcVul) + '1' + animRoomState(vultureRoom) + '<./animals>
    <.animals>8x8-c1' + animConnState(animConnUrcVul) + animRoomState(turtleRoom) + '<./animals>
    <.animals>49x8-b' + animConnState(animConnTrtUrc) + animRoomState(turtleRoom) + '11<./animals>
    <.animals>8x8-d11' + animRoomState(turtleRoom) + '<./animals>
    <.animals>8x8-c11' + animRoomState(xercesRoom) + '<./animals>
    <.animals>49x8-b1' + animRoomState(xercesRoom) + '1' + animConnState(animConnXerYak) + '<./animals>
    <.animals>8x8-d' + animConnState(animConnXerYak) + '1' + animRoomState(xercesRoom) + '<./animals>
    <.animals>8x8-c1' + animConnState(animConnXerYak) + '1<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d111<./animals>
    <.animals>8x8-c111<./animals>
    <.animals>49x8-b1111<./animals>
    <.animals>8x8-d001<./animals>
</tr>
<tr>
    <.animals>8x8-a001<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b111<./animals>
    <.animals>8x8-a111<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b1' + animConnState(animConnUrcVul) + '1<./animals>
    <.animals>8x8-a' + animConnState(animConnUrcVul) + '1' + animRoomState(urchinRoom) + '<./animals>
    <.animals>49x8-a' + animConnState(animConnTrtUrc) + animRoomState(urchinRoom) + animConnState(animConnUrcVul) + '1<./animals>
    <.animals>8x8-b11' + animRoomState(urchinRoom) + '<./animals>
    <.animals>8x8-a111<./animals>
    <.animals>49x8-a1111<./animals>
    <.animals>8x8-b1' + animConnState(animConnXerYak) + '1<./animals>
    <.animals>8x8-a' + animConnState(animConnXerYak) + '1' + animRoomState(yakRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(yakRoom) + animConnState(animConnXerYak) + '1<./animals>
    <.animals>8x8-b11' + animRoomState(yakRoom) + '<./animals>
    <.animals>8x8-a11' + animRoomState(zebraRoom) + '<./animals>
    <.animals>49x8-a1' + animRoomState(zebraRoom) + '11<./animals>
    <.animals>8x8-b00' + animRoomState(zebraRoom) + '<./animals>
</tr>
<tr>
    <.animals>8x49-a0111<./animals>
    <.animals>starfish.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1111<./animals>
    <.animals>ram.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1' + animRoomState(urchinRoom) + animConnState(animConnUrcVul) + '1<./animals>
    <.animals>urchin.jpg\" border=\"0\"></td>
    <.animals>8x49-b1' + animRoomState(urchinRoom) + '11<./animals>
    <.animals>8x49-a1111<./animals>
    <.animals>caribou.jpg\" border=\"0\"></td>
    <.animals>8x49-b1111<./animals>
    <.animals>8x49-a1' + animRoomState(yakRoom) + animConnState(animConnXerYak) + '1<./animals>
    <.animals>yak.jpg\" border=\"0\"></td>
    <.animals>8x49-b' + animConnState(animConnYakZeb) + animRoomState(yakRoom) + '11<./animals>
    <.animals>8x49-a' + animConnState(animConnYakZeb) + animRoomState(zebraRoom) + '11<./animals>
    <.animals>zebra.jpg\" border=\"0\"></td>
    <.animals>8x49-b0' + animRoomState(zebraRoom) + '11<./animals>
</tr>
<tr>
    <.animals>8x8-c001<./animals>
    <.animals>49x8-b0111<./animals>
    <.animals>8x8-d001<./animals>
    <.animals>8x8-c001<./animals>
    <.animals>49x8-b0111<./animals>
    <.animals>8x8-d001<./animals>
    <.animals>8x8-c00' + animRoomState(urchinRoom) + '<./animals>
    <.animals>49x8-b0' + animRoomState(urchinRoom) + '11<./animals>
    <.animals>8x8-d00' + animRoomState(urchinRoom) + '<./animals>
    <.animals>8x8-c001<./animals>
    <.animals>49x8-b0111<./animals>
    <.animals>8x8-d001<./animals>
    <.animals>8x8-c00' + animRoomState(yakRoom) + '<./animals>
    <.animals>49x8-b0' + animRoomState(yakRoom) + '11<./animals>
    <.animals>8x8-d00' + animRoomState(yakRoom) + '<./animals>
    <.animals>8x8-c00' + animRoomState(zebraRoom) + '<./animals>
    <.animals>49x8-b0' + animRoomState(zebraRoom) + '11<./animals>
    <.animals>8x8-d00' + animRoomState(zebraRoom) + '<./animals>
</tr>
</table>';
}
*/

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

DefineIAction(Zoo)
  execAction() {
    local anim;
    "Here is what the test property is for various animals: <p>";
    "<font size=\"2\" face=\"Verdana, Tahoma, Geneva, TADS-Sans\">";
    "<table ";/*"width=\"100%\";*/"border=\"0\" cellspacing=\"0\" cellpadding=\"0\">";
//      <tr> 
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//      </tr>
//      <tr> 
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//      </tr>
//      <tr> 
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//      </tr>
//      <tr> 
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//        <td>&nbsp;</td>
//      </tr>
    for (local a = 1; a <= 42; a++) {
      anim = animList[a];
      
      "<tr>"; "<td valign=\"top\">";
      if (anim != xerces) say(anim.name); else "xerces";
      "&nbsp;";
      "</td>";
      
//      "<td valign=\"top\">";
//      if (testPropType == TypeDString) {
//        "\""; anim.(testProp); "\""; 
//      }
//      else if (dataType(anim.(testProp)) == TypeSString) {
//        "\'"; say(anim.(testProp)); "\'"; 
//      }
//      else if (dataType(anim.(testProp)) == TypeNil ||
//               dataType(anim.(testProp)) == TypeTrue) {
//        if (anim.(testProp)) "true";
//        else "nil";
//      }
//      else if (dataType(anim.(testProp)) == TypeInt) {
//        say(anim.(testProp));
//      }
//      else if (dataType(anim.(testProp)) == TypeEnum) {
//        if (anim.(testProp) == hostile) "hostile";
//        else if (anim.(testProp) == inaccessible) "inaccessible";
//        else if (anim.(testProp) == permissive) "permissive";
//        else "unidentified enum";
//        //"enum";
//        //say(anim.(testProp));
//      }
//      else {
//        "unrecognized data type";
//      }
//      "</td>";
      
      "<td valign=\"top\"><<anim.door3(fakeAnimConnAllCra)>><p>";
      "</td>"; 
      "</tr>";
    }
    "</table>";
    "</font>";
  }
  testProp = &threatensPhrase
  testPropType = nil // set this to TypeDString or nil
  //  1 TypeNil         
  //  2 TypeTrue        
  //  5 TypeObject      
  //  6 TypeProp        
  //  7 TypeInt         
  //  8 TypeSString     
  //  9 TypeDString     
  // 10 TypeList        
  // 11 TypeCode        
  // 12 TypeFuncPtr     
  // 14 TypeNativeCode  
  // 15 TypeEnum        
  animList = [
     crab
    ,urchin
    ,clam
    ,starfish
    ,bee
    ,ladybug
    ,xerces
    ,dragonfly
    ,jellyfish
    ,octopus
    ,scallop
    ,squid
    ,ray
    ,seahAnimal
    ,frog
    ,newt
    ,alligator
    ,iguana
    ,turtle
    ,hummingbird
    ,woodpecker
    ,penguin
    ,quail
    ,vulture
    ,duck
    ,pelican
    ,turkey
    ,monkey
    ,catAnimal
    ,rabbit
    ,elephant
    ,giraffe
    ,kangaroo
    ,walrus
    ,yak
    ,zebra
    ,caribou
    ,cow
    ,fox
    ,ram
    ,dolphin
    ,whale
  ]
;
VerbRule(Zoo)
  'zoo'
  : ZooAction
  verbPhrase = 'zoo/zooing'
;

#endif // __DEBUG

