#include <adv3.h>
#include <en_us.h>


yvonne: Person
    'Emma\'s best friend/yvonne'
    'Yvonne'
    @lawnWest
    "Yvonne is tall, with short dark hair and a loud voice. One of the grownups
    said she's Emma's best friend, but Emma seems to boss her around a lot. 
    At the moment she's <<reportActivity(true)>>. "
    isProperName = true
    globalParamName = 'yvonne'
    
    /* 
     *   How Yvonne is described in the room description varies by which 
     *   room she's in (which in turn is governed by where we are in the 
     *   plot).
     */
    specialDesc()
    {
        /* 
         *   If Yvonne is playing Hide and Seek and the PC is supposed to be 
         *   counting, note that she's waiting for the PC to do her stuff.
         */
        if (yvonne.isPlayingHnS && gPlayerChar.roleInHnS == roleCounting)
        {
            local loc = location;
            gMessageParams(loc);
            "Yvonne is hanging around {in loc}, waiting for you to start
            counting. ";
            return;
        }
        
        switch(location)
        {
        case lawnWest:
            if (isCheating)
                "Yvonne is staring at the other end of the lawn. A tiny
                smile flickers on her face. ";
            else
                "Yvonne looks doubtfully across the lawn. ";
            break;
        
        case bushNearCubby:
            "Yvonne is crouching in the bush with Emma. ";
            break;
            
        /* If Yvonne goes east before the player does... */
        case lawnEast:
            if (isCheating)
                "Yvonne is at the other end of the lawn, with her back to 
                you. ";
            else
                "Yvonne dithers about at the other end of the lawn. ";
            break;
            
        case cubbyArea:
            if (isCheating)
                "Yvonne is hanging around the cubby house, occasionally glancing
                back towards you. ";
            else
                "Yvonne is standing near the cubby house, frowning slightly. ";
            break;
            
        /* If the player cheats and goes east before Yvonne can... */
        case lotsaBushes:
            "Yvonne is messing around <<lotsaBushes.actorInName>>. ";
            break;
            
        default:
            "Yvonne is <<reportActivity(true)>>. ";
        }
    }
    
    /* 
     *   Remote and distant specialDescs redirect to the ordinary 
     *   specialDesc.
     */
    distantSpecialDesc() { specialDesc; }
    remoteSpecialDesc(actor) { specialDesc; }
    
    /* Yvonne always cheats (unless the player catches her at it). */
    isCheating = true
    isCheatingOfHerOwnAccord = true
    
    /* Choose and remember a pathway for Yvonne to take. */
    calcPathToHidingSpot()
    {
        local path;

        if (gPlayerChar.isIn(lawnEast))
        {
            /* 
             *   If the PC is cheating and goes east before Yvonne can, 
             *   Yvonne goes behind the shed, none too happily.
             */
            path = pathBehindShed;
        }
        else
        {
            /* In any other circumstances, Yvonne goes across the lawn. */
            path = pathAcrossLawn;
        }
        
        pathToHidingSpot = path;
        return path;
    }
    
    
    /* 
     *   Attacking Yvonne ends the story. Painfully. This is tricky because 
     *   in some situations the PC can't approach Yvonne, but I still want 
     *   her to be able to attack Yvonne in these situations.
     */
    dobjFor(Attack)
    {
        /* 
         *   Change the precondition requiring her to be touchable; now you 
         *   only have to be able to see her.
         */
        preCond = [objVisible]
        
        /* 
         *   Well, you also have to be on the ground, since attacking her 
         *   from the tree is hardly sensical...
         */
        check()
        {
            if (gActor.isIn(upTree))
                failCheck('You can\'t get at her from up here. ');
        }
        
        action()
        {
            inherited();
            "You make a dash at Yvonne and jump on her. You even manage to hit
            her a few times before she shakes you off and hits back. Emma and 
            {the Tiana/she} scream, and the grownups come running and pull you
            and Yvonne away from each other. Emma cries and tells the grownups
            how you <q>just went crazy and attacked Yvonne for <i>no</i> reason 
            at all, I thought she would <i>kill</i> her!</q> Mum gets very
            serious and apologises a lot and hustles you back to the car.<.p>
            On the way home, she gives you a huge lecture, and you say nothing 
            and wiggle your new loose tooth. ";
            endGame('You are in big trouble');
        }
    }
    
    dobjFor(Hug)
    {
        action()
        {
            "<q>Whoa, what are you doing?</q> Yvonne backs away from you. 
            <q>Don't be so <i>weird</i>.</q> ";
        }
    }
    
    /* 
     *   Yvonne always acts before Tiana, so lower her scheduleOrder. (The 
     *   defaults for NPCs are 200 and 400, and lower numbered actors move 
     *   earlier.)
     */
    calcScheduleOrder()
    {
        /* determine if we're ready to run */
        if (readyForTurn())
            scheduleOrder = 190;
        else
            scheduleOrder = 390;

        /* return the scheduling order */
        return scheduleOrder;
    }
    
    
    /* Better NPC travel messages */
    
    /*
     *   Yvonne is departing locally (staying within view throughout
     *   the travel, and moving further away from the PC) 
     */
    sayDepartingLocally(dest, conn)
    {
        /* get the travel direction */
        local dir = getDirection(location, dest);
        
        /* Yvonne moves purposefully when cheating, less so when not cheating */
        if (isPlayingHnS)
            "\^<<travelerName(nil)>> heads <<dir.name>> towards 
            <<dest.destName>>, looking for a place to hide. ";
        else if (isCheating)
            "\^<<travelerName(nil)>> strides <<dir.name>>wards to 
            <<dest.destName>>. ";
        else
            "\^<<travelerName(nil)>> hesitates, then moves <<dir.name>> 
            towards <<dest.destName>>. ";
    }

    /*
     *   Yvonne is traveling remotely (staying within view through the
     *   travel, and moving from one remote top-level location to another) 
     */
    sayTravelingRemotely(dest, conn)
    {
        /* get the direction */
        local loc = lastTravelBack.getDestination(location, self);
        local dir = getDirection(loc, dest);
        
        if (isCheating)
            "\^<<travelerName(nil)>> heads <<dir.name>> from
            <<loc.theName>> to <<travelerLocName>>. ";
        else
            "\^<<travelerName(nil)>> decides not to bother with
            <<loc.theName>> any more and heads <<dir.name>> to 
            <<travelerLocName>>. ";
    }

    /* Yvonne is leaving in a given compass direction */
    sayDepartingDir(dir, conn)
    {
        local nm = travelerRemoteLocName;
        
        if (isCheating)
            "\^<<travelerName(nil)>> hurries off to the 
            <<dir.name>><<nm != '' ? ', barely glancing at ' + nm : ''>>. ";
        else
            "\^<<travelerName(nil)>> leaves <<nm != '' ? nm : ''>> to the
            <<dir.name>>. ";
    }

    /* Yvonne is arriving from a compass direction */
    sayArrivingDir(dir, conn)
    {
        gMessageParams(location);
        
        if (isCheating)
            "\^<<travelerName(true)>> strides {into location} 
            from the <<dir.name>>. ";
        else
            "\^<<travelerName(true)>> wanders {into location}
            from the <<dir.name>>. ";
    }
;



/* Yvonne's response to being bossed around by the PC. */
+ DefaultCommandTopic
    "<q>No way,</q> says Yvonne. <q>Do it yourself.</q> "
;



/* 
 *   If the player looks at Yvonne during the counting scene (to do this, 
 *   the player must be cheating), she and Yvonne see each other cheating. 
 *   This makes Yvonne stop cheating.
 */
+ AfterAction
    actor = gPlayerChar
    action = ExamineAction
    dobj = yvonne
    condition = (counting.active_)
    
    react()
    {
        if (yvonne.isCheating)
        {
            "<.p>As soon as you look at her, Yvonne closes her eyes --- but not
            quickly enough. She was cheating! ";
            yvonne.isCheating = nil;
            yvonne.isCheatingOfHerOwnAccord = nil;
            gAction.actionTime = 1;
        }
        else
        {
            "She has her eyes closed. Guess she isn't going to risk 
            cheating again. ";
        }
    }
;


/* 
 *   If Yvonne sees the player going inside the house or the shed she calls 
 *   out, stopping the player. This only happens once.
 */
+ BeforeAction
    actor = gPlayerChar
    action = TravelViaAction
    condition = (!yvonne.isIn(bushNearCubby) && gDobj.isOutOfBounds &&
                 yvonne.canSee(gPlayerChar))
    
    isOneOff = true
    stopAction = true
    
    react()
    {
        "Yvonne sees you head towards <<gDobj.apparentDestName>> and calls 
        out, <q>Inside is out of bounds, remember!</q> You hesitate. ";
    }
;


/* 
 *   If Yvonne is heading across the lawn towards Emma's hiding spot and the 
 *   player tries to follow her, Yvonne confronts the player and stops her.
 */
+ BeforeAction
    actor = gPlayerChar
    action = TravelViaAction
    dobj = [lawnEast, cubbyArea]
    
    condition()
    {
        if (yvonne.isIn(bushNearCubby))
            return nil;
        
        if (yvonne.isPlayingHnS)
            return nil;
        
        if (yvonne.isCheating && !yvonne.isCheatingOfHerOwnAccord)
            return nil;
        
        if (gPlayerChar && gPlayerChar.wentEastBeforeYvonne)
            return nil;
        
        if (yvonne.getOutermostRoom not in (lawnEast, cubbyArea))
            return nil;
        
        return true;
    }
    
    stopAction = true
    
    react()
    {
        if (!gPlayerChar.isScaredOfYvonne)
        {
            "<<yvonne.isIn(gDobj) ? 'Yvonne steps into your path, scowling.' :
              'Yvonne sees you moving towards her and yells at you.'>> <q>I\'m 
            going this way! Go find your own place to look. I got here 
            first.</q> ";
        }
        else if (gPlayerChar.isScaredOfYvonne == 1)
        {
            "<<yvonne.isIn(gDobj) ? 'Yvonne gives you a shove.' : 'Yvonne makes
                a threatening movement towards you.'>> <q>Stop trying to follow 
            me! Go away, or I\'ll <i>make</i> you.</q><.p>
            She\'s a lot bigger than you. Maybe you shouldn\'t push it. ";
        }
        else
        {
            "DEBUG: Something went wrong. The PC is 
            <<gPlayerChar.isScaredOfYvonne>> scared of Yvonne. Yvonne is
            <<yvonne.isHidden ? '' : 'not'>> hidden. The PC
            <<gPlayerChar.wentEastBeforeYvonne ? 'went' : 'didn\'t go'>> east
            before Yvonne. Yvonne is <<yvonne.location.actorInName>>. The
            current action is <<gAction.getVerbPhrase(nil, nil)>>, and the
            actor is <<gActor.theName>>. ";
        }
        gPlayerChar.isScaredOfYvonne++;
    }
;



/* Yvonne's AgendaItems */
+ HideAgendaItem;
+ SearchAgendaItem;
+ MoveAgendaItem;


/* 
 *   Alternative AgendaItems for when she's playing Hide and Seek. Unlike 
 *   her main AgendaItems, Yvonne won't perform these if she's talked to the 
 *   PC on the same turn.
 */

/* 
 *   If she's close to a hiding spot, enter it (but don't use the cubby or 
 *   the bush near the cubby).
 */
+ AgendaItem
    cond = (yvonne.isPlayingHnS && gPlayerChar.roleInHnS == roleHiding &&
            !yvonne.location.ofKind(HidingSpot) && 
            !yvonne.canTouch(bushNearCubby) &&
            yvonne.getNearbyHidingSpots(nil).length > 0 &&
            !getActor().conversedThisTurn())
    
    invokeItem()
    {
        /* grab the list of nearby hiding spots */
        local hsList = yvonne.getNearbyHidingSpots(nil);
        
        /* just hide in the first one */
        yvonne.enterHidingSpot(hsList[1]);
    }
;


/* 
 *   If she isn't close to a good hiding spot, wander about randomly until 
 *   she is 
 */
+ AgendaItem
    cond = (yvonne.isPlayingHnS && gPlayerChar.roleInHnS == roleHiding &&
            !yvonne.location.ofKind(HidingSpot) && 
            (yvonne.canTouch(bushNearCubby) ||
             yvonne.getNearbyHidingSpots(nil).length == 0) &&
            !getActor().conversedThisTurn())
    
    invokeItem()
    {
        /* remember her current location */
        local oldLoc = yvonne.location;
        
        /* 
         *   Keep looping until we find a viable room and get to it. This 
         *   probably isn't terribly efficient code, but I DON'T CARE.
         */
        while (yvonne.location == oldLoc)
        {
            /* choose a random direction */
            local dir = rand(Direction.allDirections);
            
            /* does this direction lead to another room? */
            local conn = yvonne.location.(dir.dirProp);
            if (conn && conn.getDestination(oldLoc, yvonne) && 
                conn.getDestination(oldLoc, yvonne).ofKind(Room))
            {
                /* if so, try going there */
                nestedActorAction(yvonne, TravelVia, conn);
            }
        }
    }
;



/* Yvonne's counting state. */
+ yvonneCounting: ActorState
    isInitState = true
;


/* When counting, she doesn't respond to anything the PC has to say. */
++ DefaultSayAskTellTopic
    "<q>Stop asking silly questions and just count!</q> Yvonne says. "
;


/* Yvonne's default state.*/
+ yvonneSearching: ActorState;
    



/* Yvonne's conversation topics */

/* Default response to being spoken to - brush the PC off */
+ DefaultSayAskTellTopic, ShuffledEventList
    [
        'Yvonne pointedly ignores you. ',
        '<q>Whatever,</q> Yvonne says. ',
        '<q>Just get on with the game!</q> Yvonne snaps. ',
        'Yvonne replies, <q>I couldn\'t care less.</q> ',
        'Yvonne just rolls her eyes. ',
        '<q>You\'re supposed to be looking for Emma,</q> Yvonne says. <q>How
        about you do that, and stop being annoying.</q> '
    ]
;


/* Telling her about the bird - turns out Yvonne has a soft spot for birds */
+ AskTellGiveShowTopic
    [babyBird, nest, tBirds]
    
    topicResponse()
    {
        "<q>Yvonne!</q> you call<<gPlayerChar.isIn(upTree) ? ' down' : ''>>.
        <q>Guess what!</q><.p>
        Yvonne ignores you.<.p>
        <q>I found a baby bird! Come and see!</q><.p>
        Yvonne's head jerks up. <q>Really? Where?</q><.p> ";
        
        if (gPlayerChar.isIn(upTree))
        {
            "She <<yvonne.lastAction.ofKind(SearchAction) ? 'stops ' +
              yvonne.lastAction.getVerbPhrase(nil, nil) + ' and ' : ''>> comes 
            running. You hold out your hand to help her climb the tree, but she
            scrambles up easily and curls up on the branch, staring at the baby 
            bird.<.p>";
        }
        else
        {
            "The two of you clamber up the tree. You hold out your hand 
            to help Yvonne, but she scrambles up easily. ";
            gPlayerChar.moveIntoForTravel(upTree);
        }

        "Yvonne whispers to you, <q>If we wait very quietly, maybe we can see 
        the grownup birds come back to look after the baby. But we have to be
        really quiet, and stay still and keep away from the nest.</q> She helps 
        you climb over to another branch, on the other side of the tree from the 
        nest.<.p>
        The two of you sit in silence for a long time. A couple of times you 
        try to whisper something, but Yvonne shushes you. Emma and {the tiana/she}
        come looking for you, but Emma isn't interested in the bird, so they go 
        away again. Finally, you see the mother bird flutters down and start 
        tending to the baby.<.p>
        By the time you have to go home, Yvonne has invited you to visit her 
        and meet her pet budgies. ";
        
        endGame('You have made a friend');
    }
;


/* 
 *   Asking Yvonne about birds in general, before encountering the baby 
 *   bird. This happens to be one of Yvonne's favourite conversation topics 
 *   - fortunately or unfortunately, depending on your point of view.
 */
++ AltTopic, StopEventList
    [
        new function()
        {
            "<q>Hey, Yvonne,</q> you say. <q>Do you like birds?</q><.p>
            Yvonne stares at you for a moment, and then smiles suddenly. 
            <q>Yes!</q> she says. <q>I love birds, actually I\'ve got two pet
            budgies. Do you like them too?</q><.p>
            You nod, and Yvonne grins at you. ";
            
            /* 
             *   Now you've got her interest, she'll stick around another 
             *   turn instead of dashing off straight away.
             */
            yvonne.nextRunTime++;
        },
        
        new function()
        {
            "<q>What are your budgies like?</q> you ask. Possibly a bad idea.<.p>
            Yvonne grins and launches into a detailed description of both her pets.
            <q>They're lovely! One's blue and the other is yellow, the blue one is 
            called Cloud and the yellow one is called Sol. Cloud can kind of talk a
            bit, he says hello and he can make the sound of the phone ringing
            too. Sol doesn\'t talk but I\'m still trying to teach him...</q><.p>
            By the time Yvonne stops talking and you find Emma's hiding spot, Emma 
            and {the tiana/she} have been waiting quite a while. Emma isn't very 
            happy, but that's okay, because next weekend you're going to Yvonne's
            house instead, to meet Cloud and Sol and hear Cloud say hello. ";
            endGame('You have made a friend');
        }
    ]
    
    isActive = (!gPlayerChar.hasSeen(babyBird))
;
        



/* Telling Yvonne about Emma's hiding spot */
+ TellTopic, StopEventList
    [emma, tHidingSpot, bushNearCubby, tCheating]
    [
        new function()
        {
            "<q>Yvonne!</q> you <<gPlayerChar.getOutermostRoom == 
                yvonne.getOutermostRoom ? 'whisper' : 'call softly'>>. <q>Emma
            is hiding in the bush near the cubby!</q><.p>
            Yvonne pretends not to hear you, but you see her glance over
            towards Emma's hiding spot. ";
            yvonne.isCheating = true;
        },
        
        'Just to be sure she heard, you repeat yourself. <q>Emma\'s hiding near
        the cubby house, in that big bush!</q><.p>
        Yvonne scowls at you. <q>I heard you the first time!</q> she whispers
        furiously. '
    ]
;

++ AltTopic, StopEventList
    [
        new function()
        {
            "<q>Yvonne!</q> you <<gPlayerChar.getOutermostRoom == 
                    yvonne.getOutermostRoom ? 'whisper' : 'call softly'>>. 
            <q>Emma is hiding in the bush near the cubby!</q><.p>
            <q>I know---</q> Yvonne catches herself a moment too late and 
            scowls at you. So she was cheating too? ";
        },
        
        '<q>How did you know where Emma was hiding?</q> you demand. <q>You\'re
        cheating!</q><.p>
        <q>So are you!</q> Yvonne hisses, <q>so just shut up!</q> '
    ]
    
    isActive = (gActor.isCheating && yvonne.isCheatingOfHerOwnAccord)
;

++ AltTopic
    topicResponse()
    {
        replaceAction(AskAbout, yvonne, emma);
    }
    
    isActive = (!gActor.isCheating && gTopic.getBestMatch() == emma)
;

++ AltTopic
    "You're not sure what to tell Yvonne about that, and you really don't feel 
    like just chatting randomly to her. "
    
    isActive = (!gActor.isCheating && gTopic.getBestMatch() != emma)
;


/* Asking her about Emma */
+ AskTopic, StopEventList
    @emma
    [
        '<q>Do you really like Emma?</q> you ask. <q>She\'s not very nice to 
        people sometimes.</q><.p>
        Yvonne glares at you. <q>None of your business.</q> ',
        
        'You already tried asking Yvonne whether she really liked Emma. It 
        didn\'t go well. '
    ]
    
    /* more likely than telling Yvonne about Emma's hiding spot */
    matchScore = 110
;


/* Accusing her of cheating */
+ AskTellTopic, StopEventList
    [tCheating, yvonne]
    [
        '<q>I saw you with your eyes open when we were counting,</q> you say.
        <q>You were cheating!</q><.p>
        <q>And I saw <i>you</i> cheating too,</q> Yvonne says, <q>so what are
        you going to do about it?</q> ',
        
        'You already told Yvonne you saw her cheating, and she didn\'t seem
        sorry. But you can\'t tell Emma without admitting that you were cheating
        too, so you\'re kind of stuck. '
    ]
    
    /* more likely than telling Yvonne about Emma's hiding spot */
    matchScore = 110
    
    isActive = (!yvonne.isCheating)
;







/* Asking her about the game, or about Hide and Seek */
+ AskTellTopic, StopEventList [tGame, tHnS]
    [
        '<q>Do you like this game?</q> you ask.<.p>
        Yvonne stares at you. <q>Do I --- of course I do, why would I be playing
        if I...</q> Her voice trails off. A pause. Suddenly she snaps, <q>Just
        stop asking weird questions, why don\'t you!</q> ',
        
        'You already tried asking her if she liked the game. It didn\'t go too 
        well. '
    ]
;


/* Talking about Hide and Seek when the PC and Tiana have started to play it. */
++ AltTopic
    topicResponse()
    {
        playingHnS.invitationToPlay();
        
        if (yvonne.location == emma.location)
        {
            /* 
             *   If Yvonne and Emma are in the same place, Emma overhears 
             *   and tries to influence Yvonne's decision. It works - the 
             *   wrong way.
             */
            "Yvonne glances at Emma, but before she can say anything Emma 
            jumps in.<.p>
            <q>Of course not, we're already playing a game! We don't even like
            Hide and Seek. We want to keep playing <i>this</i> game.</q><.p>
            Yvonne frowns. <q>Actually, I like Hide and Seek,</q> she says.<.p>
            <q>But my game is better! They didn't even ask what we wanted to play,
            they just went ahead and decided by themselves.</q> Emma's voice
            rises slightly. <q>We're just going to play by ourselves, and you
            can do what you want, we don't care, right, Yvonne?</q><.p>
            <q>No!</q> Yvonne <<yvonne.isIn(bushNearCubby) ? 'jumps to her feet' :
              'stamps her foot'>>. <q>I want to play Hide and Seek, 
            and I'm going to play Hide and Seek. You're not the boss of 
            everyone. Come on,</q> she says to you, <q>let's go.</q><.p>
            Emma gapes and says, <q>But... Yvonne...</q><.p>
            Yvonne ignores her. ";
            
            /* Emma knows what's going on with the game now. */
            emma.knowsEveryoneIsPlayingHnS = true;
            
            /* 
             *   I just said Yvonne jumped to her feet, so if she's in the 
             *   bush near the cubby, I'd better get her out of it.
             */
            if (yvonne.isIn(bushNearCubby))
            {
                yvonne.moveIntoForTravel(bushNearCubby.location);
                yvonne.makePosture(standing);
            }
        }
        else
        {
            /* Otherwise, Yvonne agrees more easily. */
            "Yvonne stares at you. <q>What about Emma's game? You can't just
            stop playing and do something else.</q><.p>
            <q>Why not? Come on, you don't like this game of Emma's either,
            right? And Hide and Seek will be more fun with more of us
            playing.</q><.p>
            Yvonne says, <q>Emma's going to be heaps mad if you just start 
            playing something else without even asking her.</q><.p>
            <q>So what?</q><.p>
            Yvonne laughs suddenly. <q>Okay then,</q> she says. <q>Who's
            going to count?</q><.p>
            <<gPlayerChar.roleInHnS == roleCounting ? '<q>I will --- in a
                minute,</q> you reply.' : 'You point to {the tiana/her}.
                    <q>She\'s already counting.</q>'>> ";
        }
        
        /* Either way, Yvonne ends up playing Hide and Seek too. */
        Person.peoplePlayingHnS += yvonne;
        yvonne.roleInHnS = roleHiding;
    }
    
    isActive = (gPlayerChar.isPlayingHnS)
;


++ AltTopic
    "Yvonne has already agreed to play with you. "
    
    isActive = (yvonne.isPlayingHnS)
;


++ AltTopic
    "<q>Hey, Yvonne,</q> you say. <q>Do you want to play Hide and Seek with
    me?</q><.p>
    Emma jumps in before Yvonne can answer. <q>You can't play Hide and Seek,
    we're in the middle of this game! Anyway Hide and Seek is boring.</q><.p>
    You think Yvonne looks a bit disappointed, but she doesn't say anything.
    <.p>"
    
    isActive = (!gPlayerChar.isPlayingHnS && yvonne.location == emma.location)
;


++ AltTopic, StopEventList
    [
        '<q>Yvonne!</q> you call. <q>Do you want to play Hide and Seek 
        with me?</q><.p>
        Yvonne hesitates a moment. <q>We\'re already playing Emma\'s game,</q>
        she says. <q>She\'ll be heaps mad if we just run off and play
        something else without her.</q><.p>
        <q>But---</q><.p>
        <q>Just get on with the game!</q> Yvonne snaps. ',
        
        'You already asked Yvonne to play Hide and Seek with you. For a
        moment it seemed like she was interested, but then she said no. And 
        yelled at you. '
    ]
    
    isActive = (!gPlayerChar.isPlayingHnS && gAction.originalAction && 
                gAction.originalAction.ofKind(PlayWithAction))
;



/* Saying hello to Yvonne. */
+ HelloTopic
    "<q>Hi, Yvonne!</q> you say.<.p>
    Yvonne stares at you for a moment and then turns away. "
;



/* 
 *   Asking Yvonne to play on various items of playground equipment. She 
 *   always says no, for some reason.
 */
+ AskTellTopic [swing, cubbySlide, cubbyHouse, sandpit]
    topicResponse()
    {
        local obj = gTopic.getBestMatch();
        
        "<q>Hey, Yvonne, do you want to play <<obj.actorInName>> with 
        me?</q> you call.<.p>
        Yvonne stares at you for a moment. <q>No thanks,</q> she says,
        and turns away. ";
    }
;



/* Asking Yvonne about herself. */
+ AskTopic @yvonne
    "You're not sure what to ask. And not sure she'd answer anyway. "
;



/* Asking Yvonne about Tiana. */
+ AskTellTopic, StopEventList @tiana
    [
        new function()
        {
            "<q>Yvonne, what do you think about<<tiana.isProperName ?
              ' Tiana?</q>' : '... her?</q> pointing vaguely in 
                  {the\'s tiana/her} direction.'>><.p>
            <q>Tiana?</q> ";
            
            if (!tiana.isProperName)
            {
                tiana.learnName();
                "(Of course, that's the red-haired girl's name.) ";
            }
            
            "Yvonne stares at you. <q>She's okay, I guess. A bit of a
            baby sometimes.</q> ";
        },
        
        'You already asked Yvonne what she thought of Tiana. She said
        Tiana was all right, but sometimes a bit babyish. '
    ]
;



/* Yvonne's Unperson */
yvonneUnperson: Unperson
    linkedPerson = yvonne
;