/* $Id: items.t 1.12 2001/08/16 19:18:52 mol Exp $
 * --------------------------------------------------------------
 * Miscellaneous items for Aayela 1.2
 *
 * This file is a part of the source distribution of
 *
 * Aaylea - an Interactive Vision, release 1.2
 *
 * Copyright 1996-2001 by Magnus Olsson (mol@pobox.com).
 * All rights reserved.
 *
 * THIS CODE MAY BE DISTRIBUTED FREELY AS LONG AS IT IS NOT MODIFIED
 * IN ANY WAY, NO FEE IS CHARGED EXCEPT FOR DISTRIBUTION COST, AND
 * THIS COPYRIGHT NOTICE IS NOT ALTERED OR DELETED.
 * You may use the code, classes and algorithms as part of your
 * own programs as long as the following conditions are met:
 *
 * 1) No use of the characters, plot or text of the game
 *    "Aayela" are used in the derivative work (i.e. you may
 *    write another game set in darkness using this code, but
 *    you may not publish an "improved" version of Aayela)
 *    without the author's permission.
 * 2) The use of this code, and its origin, are acknowledged in 
 *    the derivative work.
 *
 * This version is tested with the Linux TADS compiler v2.5.5
 * --------------------------------------------------------------
 */

paper : readable
    noun = 'paper' 'page' 'piece'
    adjective = 'paper'  
    sdesc = "piece of paper"        

    ldesc = "It is a fragment of a larger document, rather badly
        burned. You can still make out the following words:\b
	\"...captured within the crystal; only the crystal structure
	keeps her inside, and when it is destroyed she will be released.
	... use its power ... must be holding it ... when attuned,
	it can be controlled by willpower alone, but there are magic words
	that force the spirit to obey. One such word is 
	QUELTUYA ... smite one's enemies...\"\b
	The rest of the paper is too charred to read."
	
    touchdesc = "The edges are uneven, and the paper feels brittle, as 
        if it has been burned."

    darkReachable(verb, actor) = {
        return (self.isIn(actor) or self.isIn(crack));
    }
    discovered = nil
;
    
whistle : item
    noun = 'object'
    adjective = 'metal'
    sdesc = {
        if (self.discovered)
	    "penny whistle";
	else
	    "metal object";
    }
    location = side_tunnel
    discovered = nil
    
    makeknown = {
        if (not self.discovered) {
	    self.discovered := true;
            // Add some new vocabulary (but continue to let it
	    // be referenced as an 'object').
	    addAdjectives(self, ['penny' 'tin']);
	    addNouns(self, ['whistle' 'flute' 'pipe']);
	}
    }
	
    touchdesc = {
        self.makeknown;
        "A metal pipe, about a centimetre in diameter, with
        some drilled holes along the side, and a wooden mouthpiece
	at one end - some kind of flute, or perhaps a penny whistle.";
    }
    
    doSynonym('Play') = 'Blow'
    verDoPlay(actor) = {
    }
    doPlay(actor) = {
        local wasknown := self.discovered;
        self.makeknown;
	
	if (music.state = 1) {
  	    if (wasknown)
                "You start playing a merry tune on << self.thedesc >>. ";
	    else
	        "Recognizing the object as << self.adesc >>, 
	        you start playing a merry tune. ";
	}
        music.respond(outerLoc(Me));
    }
;
    
scroll : item
    noun = 'scroll' 'spell'
    adjective = 'opening'
    sdesc = "scroll"    
    ldesc = {
        "Grodrig the court wizard gave you this scroll before you
	left. It contains a spell of opening: words
        in an ancient language, channelling the magic energy of the
	wizard who wrote it. Even though you're ignorant of magic
	yourself, by reading the scroll you can open
	any lock - or so old Grodrig told you.
	He also told you that it can only be used once.";
	self.isseen := true;
    }
	
    isseen = nil
    verDoRead(actor) = { }
    doRead(actor) = {
        if (not self.isseen) {
	    self.ldesc;
	    "\bVery well. This seem like a good time to use it.\b";
	}
        "As you pronounce the archaic words of the spell, you feel
	power builing up around you; your hair and whiskers stand on end, 
	the air feels charged, and your lamp flickers even 
	worse than before. 
        Then, the power is released, and the door slowly glides open.
	Beyond it, the tunnel continues north for some distance.\b
	The scroll has turned to dust in your hands.";
	door_s.isopen := true;
	self.moveInto(nil);
    }
    verDoBurn(actor) = {
        "Such senseless vandalism won't help you. ";
    }

    location = Me
;
        
lamp : lightsource
    noun = 'lamp' 'lantern' 'light'
    adjective = 'brass' 'oil' 'old' 'battered'
    sdesc = "brass lantern"
    ldesc = {
        "A battered old brass lantern, inefficient but better 
	than nothing. ";
	if (self.islit)
	    "It's flickering badly - probably running out of oil. ";
	else
	    "It's burned out. ";
    }
    darkdesc = "It's not burning (obviously), but still too hot to
        touch."
    touchdesc = "It's too hot to touch."
    
    islit = self.isActive
    isActive = true
    
    doSynonym('Turnon') = 'Light'
    doSynonym('Turnoff') = 'Extinguish'
    verDoTurnon(actor) = {
        if (self.islit)
	    "But it's already lit! ";
    }
    doTurnon(actor) = {
        "It's no use - it seems to be out of oil.";
    }
    verDoTurnoff(actor) = {
        if (not self.islit)
	    "But it's already off! ";
    }
    doTurnoff(actor) = {
        "That would leave you in total darkness.";
    }
    location = Me
;    
    
stone : lightsource
    noun = 'spark' 'light' 'star'
    adjective = 'tiny' 'blue' 'bluish'
    sdesc = {
        if (self.isActive)
	    "crystal";
	else
	    "spark";
    }

    musicresponse = {
   	"You play a few notes, and << self.thedesc >> flashes in time.";
    }
     
    ldesc = "It is a perfect, multi-faceted crystal, about the size of
        your fist. It burns with a pure, white light, yet is quite cold
	to the touch."
	
    darkdesc = "Just a tiny little spark of bluish light, far too 
        faint to illuminate anything, but the first thing you have
	seen since your lamp went out."

    istouched = nil
    touchdesc = {
        if (not self.isActive) {
	    "You reach out towards the spark, and touch a cold,
	    smooth object, glassy, faceted, about as large 
	    as your fist -
	    the spark seems to be caught inside a crystal. 
	    \bA tingling sensation runs up your arm, and for
	    a moment you hear that strange harmony again.";
	    self.istouched := true;
	    addNouns(self, ['crystal' 'stone' 'gem' 'diamond' 
	                    'facet' 'facets']);   
	}
	else 
	    "\^<< self.thedesc >> feels cold to the touch.";
    }

    verDoTouch(actor) = {
        if (self.isIn(heliax))
	    self.verDoTake(actor);
    }
        
    doTake(actor) = {
        if (not self.istouched) {
	    self.touchdesc;
	    " Startled, you let go of it.";
	}
	else if (not isActive) {   
	    self.isActive := true;
	    spark.isActive := nil;
	    
	    "When you pick up << self.thedesc >>, it bursts into
	    blinding, white light, and triumphant music fills the
	    air: a song of joy, of liberation. Then the music turns
	    hesitant, uncertain, and ends on an unresolved
	    chord, as an unanswered question. The light
	    fades slightly, or perhaps it is your eyes that have adjusted 
	    to it; anyway, for the first time since you entered the tunnels,
	    you can now see your surroundings.\b";

	    self.moveInto(actor);
	    actor.travelTo(endgame);
	}
	else
	    pass doTake;
    }
    darkReachable(verb, actor) = {
        return true;
    }
    verIoAttackWith(actor) = {
  	"How do you propose to do that?";
    }

    verDoBreak(actor) = {
        if (not self.isIn(actor))
            "%You% %are%n't holding << self.thedesc >>.";
    }
    doBreak(actor) = {
	heliax.breakStone(theFloor);
    }

    doThrowAt(actor, io) = {
        heliax.breakStone(io);
    }
    doSynonym('ThrowAt') = 'ThrowTo'
    
    queltuya(actor) = {
        if (self.isIn(heliax)) {
	    "Heliax looks up, startled, as << self.thedesc >> turns
	    dark for a moment. Almost immediately, however, it starts 
	    to shine again. He shakes his head and repeats the 
	    word: \"Queltuya\". This time, a bolt of incandescent white
	    light shoots out of << self.thedesc >> and hits you right
	    between the eyes.\n";
	    die();
	}
	else if (not self.isIn(Me))
	    "\^<< self.thedesc >> turns dark for a moment, and then
	    starts shining again. Nothing further happens. ";
	else if (heliax.isIn(endgame) and Me.isIn(endgame)) 
	    ending1();
 	else
	    "\^<< self.thedesc >> goes dark for a moment, and a chill
	    runs up your arm. Your head is filled with music: first
	    a dark, violent melody of utmost horror and disgust; 
	    then it calms
	    down, brightens, turns into a song of relief. When the music
	    dies out you are left with a feeling of having done something
	    at the wrong time.";
    }
    islit = self.isActive
    isActive = nil
;

spark : distantItem, floatingItem
    noun = 'spark' 'light' 'star'
    adjective = 'tiny' 'blue' 'bluish'
    sdesc = "spark"
    darkdesc = "A tiny little spark of bluish light, far too faint
        to illuminate anything. It is somewhere near the centre
	of the room."
    darkReachable(verb, actor) = {
        return true;
    }
    isActive = nil
    location = {
        if (self.isActive and isclass(outerLoc(Me), wallroom))
	    return Me.location;
	else
	    return nil;
    }
;
    
	        