#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


connectorIntoFroggerRoadside : FroggerRoomSet,OneWayRoomConnector
	-> froggerRoadsideC
	noteTraversal(traveler) {
		if(traveler==gPlayerChar) {
			gPlayerChar.posture = standing;
			gPlayerChar.returnPath = connectorIntoArcadeBasement;
		}
	}
;

class FroggerRoomSet : RoomInSet
	roomSetId = 'FroggerRoomSet'
	
	notifyBeforeArriving() {
		for(local i=1; i<=daemonList.length; ++i)
			daemonList[i].startDaemon();
	}
	
	notifyBeforeLeaving() {
		for(local i=1; i<=daemonList.length; ++i)
			daemonList[i].stopDaemon();
	}
	
	daemonList = static [riverDaemon
//		raceCar,log,turtle
		]
;


class FroggerRoadside : FroggerRoomSet,OutdoorRoom
	desc {
		if(froggerWreckage.carWreckOccurred) { 
			"You are on the south side of an east-west road. There is no longer any
			traffic on the road. Instead there is plenty of wreckage all over the place on
			the road. In the distance you can see a river running along the other side of the road. ";
		} else {
			"You are on the south side of an east-west road. Traffic is heavy, so crossing could
			be dangerous. In the distance you can see a river running along the other side of the road. ";
		}
	}
/*	
	atmosphereList : ShuffledEventList {
	[
		'\nA flight of birds disappears off to the west. ',
		{: "\nA <<rand('small', 'large')>> <<rand('green', 'red', 'blue', 'black', 'white')>> car
			pulls out of the car park and drives off to the north. " },
		'\nAn aeroplane flies far overhead. ',
		nil
	] 
*/	
;


FroggerRoadCrossingConnector template @room1 @room2;


froggerRoadsideB : FroggerRoadside
	name = 'roadside west'
	west = froggerRoadsideD
	east = froggerRoadsideC
	
	northwest : FroggerRoadCrossingConnector {@froggerRoadsideB @froggerRoadway3d}
	north : FroggerRoadCrossingConnector {@froggerRoadsideB @froggerRoadway3b}
	northeast : FroggerRoadCrossingConnector {@froggerRoadsideB @froggerRoadway3c}
;
//+ chickenB : Chicken;
froggerRoadsideC : FroggerRoadside
	name = 'roadside'
	west = froggerRoadsideB
	east = froggerRoadsideD
	
	northwest : FroggerRoadCrossingConnector {@froggerRoadsideC @froggerRoadway3b}
	north : FroggerRoadCrossingConnector {@froggerRoadsideC @froggerRoadway3c}
	northeast : FroggerRoadCrossingConnector {@froggerRoadsideC @froggerRoadway3d}
;
//+ chickenC : Chicken;
froggerRoadsideD : FroggerRoadside
	name = 'roadside east'
	west = froggerRoadsideC
	east = froggerRoadsideB
	
	northwest : FroggerRoadCrossingConnector {@froggerRoadsideD @froggerRoadway3c}
	north : FroggerRoadCrossingConnector {@froggerRoadsideD @froggerRoadway3d}
	northeast : FroggerRoadCrossingConnector {@froggerRoadsideD @froggerRoadway3b}
;
//+ chickenD : Chicken;



class FroggerRoadway3Type : FroggerRoomSet,OutdoorRoom
	desc {
		if(froggerWreckage.carWreckOccurred) { 
			froggerWreckage.desc;
		} else {
			"You are now living dangerously by standing in the middle of the road.
			You can continue north across the road to reach the river or go back
			south to the side of the road. Plenty of traffic is whizzing by you
			on both sides of the road. ";
		}
	}
;

froggerRoadway3b : FroggerRoadway3Type
	name = 'roadway west'
	west = froggerRoadway3d
	east = froggerRoadway3c
	
	northwest : FroggerRoadCrossingConnector {@froggerRoadway3b @froggerRiverbankD}
	north : FroggerRoadCrossingConnector {@froggerRoadway3b @froggerRiverbankB}
	northeast : FroggerRoadCrossingConnector {@froggerRoadway3b @froggerRiverbankC}
	
	southwest : FroggerRoadCrossingConnector {@froggerRoadway3b @froggerRoadsideD}
	south : FroggerRoadCrossingConnector {@froggerRoadway3b @froggerRoadsideB}
	southeast : FroggerRoadCrossingConnector {@froggerRoadway3b @froggerRoadsideC}
;
froggerRoadway3c : FroggerRoadway3Type
	name = 'roadway'
	west = froggerRoadway3b
	east = froggerRoadway3d
	
	northwest : FroggerRoadCrossingConnector {@froggerRoadway3c @froggerRiverbankB}
	north : FroggerRoadCrossingConnector {@froggerRoadway3c @froggerRiverbankC}
	northeast : FroggerRoadCrossingConnector {@froggerRoadway3c @froggerRiverbankD}
	
	southwest : FroggerRoadCrossingConnector {@froggerRoadway3c @froggerRoadsideB}
	south : FroggerRoadCrossingConnector {@froggerRoadway3c @froggerRoadsideC}
	southeast : FroggerRoadCrossingConnector {@froggerRoadway3c @froggerRoadsideD}
;
froggerRoadway3d : FroggerRoadway3Type
	name = 'roadway east'
	west = froggerRoadway3c
	east = froggerRoadway3b
	
	northwest : FroggerRoadCrossingConnector {@froggerRoadway3d @froggerRiverbankC}
	north : FroggerRoadCrossingConnector {@froggerRoadway3d @froggerRiverbankD}
	northeast : FroggerRoadCrossingConnector {@froggerRoadway3d @froggerRiverbankB}
	
	southwest : FroggerRoadCrossingConnector {@froggerRoadway3d @froggerRoadsideC}
	south : FroggerRoadCrossingConnector {@froggerRoadway3d @froggerRoadsideD}
	southeast : FroggerRoadCrossingConnector {@froggerRoadway3d @froggerRoadsideB}
;



MultiLoc,Decoration 'lane/road/traffic*lanes' 'road'
	desc {
		if(froggerWreckage.carWreckOccurred) { 
			"The road is silent now. ";
		} else {
			"It's a road full of heavy traffic. It looks very dangerous. ";
		}
	}
	
	isInitiallyIn(obj) {
		return obj.ofKind(FroggerRagingRiverbank) || obj.ofKind(FroggerRoadside) || obj.ofKind(FroggerRoadway3Type);
	}
;

class FroggerRoadCrossingConnector : FroggerRoomSet,RoomConnector
	
	canTravelerPass(traveler) {return true;}
	
	noteTraversal(traveler) {	
		if(traveler==gPlayerChar) {
			runAcrossTraffic;
		} else if(traveler==froggerLittleCar) {
			"You steer into a lane of oncoming traffic. Is this a cunning attempt to cause
			a pileup? I'm sure that all jaywalkers in the area (and anyone or anything else that might
			want to cross the road) would thank you for clearing
			out the traffic, but they will not get the opportunity because the most obvious
			consequence of your action is that you are crushed in a rather horrific collision.
			Perhaps there is a safer way to create an accident with this car? ";
			endGame('You have died (rather horrifically).');
		}
	}
	
	runAcrossTraffic {
		if(froggerWreckage.carWreckOccurred) {
			"You stroll across the road through the wreckage. ";
		} else {
			"You rush forward with reckless abandon, dashing back and forth in between cars as
			they race by. Somehow you make it across. ";
		}
	}
;


#define perInstanceWithParent(expr) ((self.(targetprop) = (expr)).instanceLexicalParent=self)


class FroggerRagingRiverbank : FroggerRoomSet,OutdoorRoom
	desc {
		"To the north is a raging river. It looks very dangerous.
		You could go east or west along the bank or south back across the road. ";
	}
	
	north = perInstanceWithParent(riverNorthConnector.createInstance())
	
	crocInThisRoom() {
		local whichClass = Crocodile;
		for(local cur=firstObj(whichClass); cur != nil; cur=nextObj(cur,whichClass)) {
			if(cur.isIn(self))
				return cur;
		}
		return nil;
	}
	
	riverNorthConnector : FakeConnector {
		instanceLexicalParent = nil
		travelDesc {
			if(instanceLexicalParent.crocInThisRoom.crocodileHungry) {
				"As you near the bank a crocodile lunges at you and sinks its teeth into your thigh.
				It pulls you into the river and turns over and over until you stop struggling.
				Apparently entering a river near a hungry crocodile just isn't a very good idea. ";
				endGame(ftDeath);
			} else {
				"So you have aspirations to become a deity do you? Sadly, you do not have the ability
				to walk on water. You could try jumping into the water if you wanted to though. ";
			}
		}
	}

	dobjFor(JumpTo) {
//		verifyPreCondition() {
//			"VERIFY PRECOND()\n";
//			
//		}
//		verifyPreCondition(obj) {
//			"VERIFY PRECOND(obj)\n";
//		}
//		preCond = [actorStanding]
		verify() {
			if(gDobj==gActor.roomLocation)
				illogical('You are already on it. ');
		}
//		check() {}
		action() {
			if(crocInThisRoom.crocodileHungry) {
				"You crouch down and then spring towards the riverbank with all your strength.
				You are unable to get enough height though because as you pass over the crocodile it
				snaps up at you and sinks its teeth into you leg.
				It pulls you into the river and turns over and over until you stop struggling.
				Apparently jumping over a hungry crocodile is not a very good idea. ";
				
				endGame(ftDeath);
			} else {
				"You crouch down and then spring towards the riverbank with all your strength. You
				do a poor tuck and roll, but come up unscathed. ";
				nestedAction(TravelVia,self);
			}
		}
	}

	roomBeforeAction() {
		if(gActionIs(JumpTo) || gActionIs(SwimIn)) {
			if(crocInThisRoom.crocodileHungry) {
				"You crouch down and then spring forward with all your strength.
				You are unable to get enough height though because as you pass over the crocodile it
				snaps up at you and sinks its teeth into you leg.
				It pulls you into the river and turns over and over until you stop struggling.
				Apparently jumping over a hungry crocodile is not a very good idea. ";
				
				endGame(ftDeath);
			}			
		}
	}

/*	
	roomBeforeAction() {	
		if(gActionIs(JumpTo)) {
"JUMPING TO\n";		
			gPlayerChar.moveIntoForTravel(gDobj);
		}
//		 else if(gActionIs(ThrowAt)) {
//		}
	}		
*/	
;

froggerRiverbankB : FroggerRagingRiverbank
	name = 'riverside west'
	vocabWords = '(west) bank/riverbank/riverside'
	west = froggerRiverbankD
	east = froggerRiverbankC
	
	southwest : FroggerRoadCrossingConnector {@froggerRiverbankB @froggerRoadway3d}
	south : FroggerRoadCrossingConnector {@froggerRiverbankB @froggerRoadway3b}
	southeast : FroggerRoadCrossingConnector {@froggerRiverbankB @froggerRoadway3c}
;
	+ NominalPlatform name='ground' actorInPrep='on';
		++ crocodileB : Crocodile
			name = 'chartreuse crocodile'
			vocabWords = name
		;
froggerRiverbankC : FroggerRagingRiverbank
	name = 'riverside'
	vocabWords = 'bank/riverbank/riverside'
	west = froggerRiverbankB
	east = froggerRiverbankD
	
	southwest : FroggerRoadCrossingConnector {@froggerRiverbankC @froggerRoadway3b}
	south : FroggerRoadCrossingConnector {@froggerRiverbankC @froggerRoadway3c}
	southeast : FroggerRoadCrossingConnector {@froggerRiverbankC @froggerRoadway3d}
;
	+ NominalPlatform name='ground' actorInPrep='on';
		++ crocodileC : Crocodile
			name = 'olive crocodile'
			vocabWords = name
		;
froggerRiverbankD : FroggerRagingRiverbank
	name = 'riverside east'
	vocabWords = '(east) bank/riverbank/riverside'
	west = froggerRiverbankC
	east = froggerRiverbankB
	
	southwest : FroggerRoadCrossingConnector {@froggerRiverbankD @froggerRoadway3c}
	south : FroggerRoadCrossingConnector {@froggerRiverbankD @froggerRoadway3d}
	southeast : FroggerRoadCrossingConnector {@froggerRiverbankD @froggerRoadway3b}
;
	+ NominalPlatform name='ground' actorInPrep='on';
		++ crocodileD : Crocodile
			name = 'lime crocodile'
			vocabWords = name
		;


class Crocodile : UntakeableActor 'crocodile/alligator' 'crocodile'
	desc {
		if(crocodileHungry) {
			"The <<name>> looks very hungry. It would be unwise to get too close. ";
		} else {
			"The <<name>> looks pretty docile. ";
		}
	}
	
	specialDesc {
		if(crocodileHungry) {
			"There is a very hungry looking <<name>> lying on the bank of the river. ";
//			if(gPlayerChar.isIn(roomLocation))
//				"Attempting to get close to the river at this point would probably not be a good idea. ";
		} else {
			"A docile looking <<name>> is lying here. It looks well fed. ";
		}
	}
	
	distantSpecialDesc = specialDesc
	
	posture = lying
	
	dobjFor(Attack) {
		verify() {}
		check() {}
		action() {
			"It would not be wise to take offensive action against the crocodile. ";
		}
	}
	
	dobjFor(Push) asDobjFor(Attack)
	dobjFor(Pull) asDobjFor(Attack)
	
	iobjFor(ThrowAt) {
		check() {
			"It would not be wise to take offensive action against the crocodile. ";
			exit;
		}
	}
	
	dobjFor(Kiss) {
		verify() {}
		check() {}
		action() {
			"Love at first site does tend to cloud judgement, but most people would realize
			personal peril when it attempted to bite them in the jugular.
			Luckily you are able to overcome your reptilian lust in time to prevent yourself from
			becoming this crocodile's next meal. ";
		}
	}
	
	dobjFor(JumpTo) {
		verify() {
			illogical('Jumping onto a crocodile would not be a wise course of action. ');
		}
	}
	
	dobjFor(JumpOver) {
		verify() {}
		check() {}
		action() {
			"You crouch down and then spring over the crocodile with all your strength.
			You are unable to get enough height though because as you pass over the crocodile it
			snaps up at you and sinks its teeth into you leg.
			It pulls you into the river and turns over and over until you stop struggling.
			Apparently jumping over a hungry crocodile is not a very good idea. ";
			
			endGame(ftDeath);
		}
	}

	feedCrocodile() {
		crocodileHungry = nil;
		crocodileAchievement.achieve.awardPointsOnce();
	}

	crocodileHungry = true
;

crocodileAchievement : object
	achieve : Achievement {+1 "feeding crocodile";}	
;
/*
+ Decoration 'river' 'river'
	"The river is reasonably calm and shallow at this point, so you could probably cross here.
	Watch out for the crocodile though. "

//	dobjFor(ThrowAt) {
//		verify() {}
//		check() {
//			"That's not a good idea. You would lose anything you throw into the river. ";
//			exit;
//		}
//	}
	
	dobjFor(SwimIn) {
		verify() {}
		check() {}
		action() {
			"The river is too shallow to swim in here. ";
		}
	}
;
*/


MultiLoc,Fixture 'raging river/water' 'river'
	"The river is moving pretty fast here. If a lifeguard were around they would tell you to
	stay out of the water. "
	locationList = [
		froggerRiverbankB,froggerRiverbankC,froggerRiverbankD
		,froggerRiver1B,froggerRiver1C,froggerRiver1D
		,froggerRiver2B,froggerRiver2C,froggerRiver2D
        ,froggerExitRowB,froggerExitRowC,froggerExitRowD
		]
//	initialLocationClass = FroggerRagingRiverbank
/*
	dobjFor(ThrowAt) {
		verify() {}
		check() {
			"That's not a good idea. You would lose anything you throw into the river. ";
			exit;
		}
	}
*/	
	
	dobjFor(SwimIn) {
		verify() {}
		check() {}
		action() {
//			"This would not be a safe river to take a swim in. ";
			"You jump into the river with a splash and soon find that, struggle as you might,
			you are completely unable to stay above water in the swift river and are soon swept under. ";
			endGame('You have drowned.');
		}
	}
	
	dobjFor(JumpTo) {
		verify() {}
		check() {}
		action() {
			"You sail through the air with perfect grace and land in the river with a splash.
			Struggle as you might, you are completely unable to stay above water in the swift
			river and are soon swept under. ";
			endGame('You have drowned.');
		}
	}

	dobjFor(JumpOver) {
		verify() {illogical('The river is far too wide to jump over.');}
	}
;
MultiLoc,Distant 'river' 'river'
	"It's a wide east-west river running next to the north side of the road. "
	isInitiallyIn(obj) {
		return obj.ofKind(FroggerRoadside) || obj.ofKind(FroggerRoadway3Type);
	}
;



/*
raceCar : Distant,SimpleDaemonEvent 'race car' 'race car'
	"The race car is speeding to the east along the road with absolute reckless abandon.
	Its paint scheme is simple green, but it is covered with what appear to be ads. "
	
	location = froggerRoadway3d
	specialDesc = "A race car is here rapidly moving to the east. "
	
	daemonDelay = 1
	
	doStuff() {
		if(!froggerWreckage.carWreckOccurred) {		
			callWithSenseContext(self,sight,{:"A race car zips out of view to the east. "});
			moveIntoForTravel(roomLocation.east);
			callWithSenseContext(self,sight,{:"A race car zips into view from the west. "});
			callWithSenseContext(self,sound,{:"<Q>HONK!</q>"});
		}
	}
;
+ Decoration 'paint scheme' 'paint scheme'
	"It's a simple green paint scheme. "
;
+ Decoration,Readable 'ad*ads' 'ad'
	"You can't make out most of the ads, but one stands out clearly. It says, <q>Flathead
	Plastic Surgery: You bring the head, we'll flatten it.</q>"
;
*/

froggerWreckage : MultiLoc,Hidden,Heavy 'wreckage*cars' 'wreckage'
	"The wreckage is horrible! Cars are piled such that all traffic along the road has halted.
	No bodies seem in evidence though, so it looks like everyone ejected safely.
	It's a good thing that car manufacturers learned the lesson that fighter plane
	manufacturers have known for so long. All modern cars now have ejection seats
	with automatically deploying parachutes. They beat air bags and seat belts any day. "
	
//	specialDesc = "Wreckage is all over the place! "
	
	initialLocationClass = FroggerRoadway3Type

	wreckCars() {
		carWreckOccurred = true;
		// eliminate little car
		froggerLittleCar.moveInto(nil);
		// put wreckage in room
		froggerWreckage.discover();
		
		chicken.startCrossingRoad();
//		chickenB.startCrossingRoad();
//		chickenC.startCrossingRoad();
//		chickenD.startCrossingRoad();
		
//		raceCar.stopDaemon();
//		raceCar.allowedToStart = nil;
//		raceCar.moveInto(nil);

		achieve.awardPointsOnce();
	}
	
	carWreckOccurred = nil
	achieve : Achievement {+1 "causing car wreck";}
;



class RoomPairSenseConnector : SenseConnector, Intangible
	transSensingThru(sense) {
		if(sense==sound)
			return distant;
		else
			return distant;
//			return opaque;
	}
	
	locationList = nil
;

RoomPairSenseConnector template [locationList];

RoomPairSenseConnector [froggerRoadsideB,froggerRoadway3b];
RoomPairSenseConnector [froggerRoadsideC,froggerRoadway3c];
RoomPairSenseConnector [froggerRoadsideD,froggerRoadway3d];




//DistanceConnector [froggerRoadsideC,froggerRiver];
/*
DistanceConnector
	transSensingThru(sense) {
		return distant;
	}

//     [
//     froggerTrafficCrossingRiverTo3a
//     ,froggerTrafficCrossingRiverTo3b
//     ,froggerTrafficCrossingRiverTo3c
//     ,froggerTrafficCrossingRiverTo3d
//     ,froggerTrafficCrossingRiverTo3e
//
//     ,froggerTrafficCrossingRoadsideTo3a
//     ,froggerTrafficCrossingRoadsideTo3b
//     ,froggerTrafficCrossingRoadsideTo3c
//     ,froggerTrafficCrossingRoadsideTo3d
//     ,froggerTrafficCrossingRoadsideTo3e
//
//     ,froggerRoadway3a
//     ,froggerRoadway3b
//     ,froggerRoadway3c
//     ,froggerRoadway3d
//     ,froggerRoadway3e
//     ]

//	initialLocationClass = FroggerRoomSet
;
*/
