# protoparser.js

Protoparser.js – легковесный веб-движок (библиотека) для [интерактивных текстовых игр](https://ru.wikipedia.org/wiki/Interactive_fiction) с вводом команд («парсеров»).

Приставка *«прото»* в названии движка, в переводе с древнегреческого, означает «первый». Интерфейс командной строки протопарсера оперирует всего двумя понятиями: ГЛАГОЛ и СУЩЕСТВИТЕЛЬНОЕ. В этом он похож на первые текстовые игры-приключения. 

## Основные особенности и возможности protoparser.js

* Protoparser.js платформонезависимый. Вы можете запускать и писать игры на любом устройстве, в котором есть браузер с поддержкой JavaScript. Не нужно компилировать исходники, устанавливать интерпретаторы, библиотеки, и пр. Все, что нужно, чтобы начать писать игру – любая программа в которой можно набрать и сохранить текст. Протопарсер работает даже на старых устройствах.
+ При желании, вы можете писать игру прямо в браузере, переключившись в «режим разработчика», если ваш браузер поддерживает такой режим.
* Законченную игру можно выложить на сайт, где она будет доступна онлайн. Вы также можете запускать ее локально. 
+ В протопарсере есть система автотестирования, которая избавит вас от необходимости после каждой правки вручную вбивать команды и проверять как все работает. Кроме того, благодаря наличию во многих современных браузерах «режима разработчика» вы можете в реальном времени проверять и изменять состояние игровых объектов.
* Если вы даже не собираетесь писать игры на протопарсере, вы, тем не менее, можете использовать его как инструмент для быстрого прототипирования.
+ Protoparser.js написан на чистом JavaScript'е и не использует иных библиотек и зависимостей. Protoparser.js является одним из самых легковесных парсерных движков на сегодняшний день. Его размер составляет всего несколько десятков килобайт.
* В протопарсере доступны различные системы управления игрой помимо традиционного ввода команд: «горячие клавиши», делающие управление похожим на то, какое используется в традиционных компьютерных играх; история команд, дающая быстрый доступ к раннее введенным командам; а также сокращенный ввод, позволяющий использовать команды, состоящие всего из нескольких символов.
+ Поскольку protoparser.js является веб-приложением вы можете использовать все возможности HTML, CSS и JS в своих играх: вставлять картинки, музыку, звуки, видео; устанавливать стили оформления; подключать дополнительные js-библиотеки, и многое другое.
* Protoparser.js выполняется полностью на стороне клиента, и там же хранит все данные.
+ Protoparser.js поддерживает мульти-сохранение и загрузку игр.
* Игры для протопарсера пишутся на языке JavaScript. В настоящее время, это один из самых распространенных языков программирования. Даже если вы напишите всего одну игру, опыт приобретенный при ее написании, может помочь вам, если вы в дальнейшем захотите заняться программированием на этом языке.
+ Protoparser.js позволяет автору менять поведение стандартных команд и создавать новые.
* Protoparser.js распространяется на условиях лицензии [MIT](../LICENSE.txt). Вы можете изменять и использовать его в своих проектах.

## Системные требования

Большинство браузеров с поддержкой JavaScript.

## Запуск

Запустите файл **index.html**.

## Демонстрационная игра

Protoparser.js распространяется вместе с игрой «[Фантазия](examples/Fantasia)». Данная игра была написана для демонстрации возможностей движка и используется в качестве обучающего примера в [руководстве автора](manual/protoparser_manual.md).

## Руководство

Для того, чтобы начать писать игры на протопарсере необходимо ознакомиться с [руководством автора](manual/protoparser_manual.md). Кроме того, желательно, обладать хотя бы начальными знаниями JavaScript'а.

## Список изменений в версии 8

- protoparser.js отвязан от terminal.js
- функционал хоткеев и истории команд перенесен из terminal.js в protoparser.js
- удалены неиспользуемые свойства game: fireCursorInterval, cursor, shouldBlinkCursor
- изменена структура index.html
- обновлено руководство
- обновлена демо-игра "Фантазия"
- добавлено сокращение "ж" для команды "ждать"
- исправлен баг с невозможностью взаимодействовать с дверью в "Фантазии"
- при окончании игры поле ввода становится недоступно для ввода команд
- добавлен запрос-подтверждение на закрытие окна с игрой (если пользователь совершал какие-либо действия)
- функция clearScreen не удаляет содержимое #output, а скрывает его
- добавлено свойство game.downloadLogMsg для вывода текста ссылки на загрузку игрового лога после окончания игры
- после окончания игры появляется ссылка на загрузку игрового лога
- изменена работа команды "лог": команда выводит ссылку на скачивание игрового лога
- исправлен баг с появлением удаленного предмета при загрузке сохранения
- добавлена поддержка работы с программами чтения с экрана

## ЧАВО

* **При загрузке/сохранении интерпретатор пишет «Ошибка загрузки/сохранения.»**   
  Причины могут быть следующие: 
  + В вашем браузере отсутствует объект `localStorage`, либо браузер не предоставляет к нему доступ.
  + Вы очистили кэш браузера после того как сохранили игру.
  + Вы сохранили игру, находясь в режиме «инкогнито».
  + Вы сохранили игру под другим именем.
*  **Игра не понимает мои команды.**  
Команда должна состоять не более, чем из двух слов. Регистр и лишние пробелы не учитываются. Стандартный список распознаваемых команд можно посмотреть в «Приложении 1. Стандартные функции-обработчики (API)» [руководства](manual/protoparser_manual.pdf). Также автор игры может добавлять свои команды и менять существующие.
* **Как сохранить лог (транскрипт) игры?**  
Используйте команду ЛОГ / Alt + J для вывода ссылки на скачивание лога.

## Лицензия

protoparser.js is copyright (c) 2018-2020, 2022 Alexey Galkin, released under the [MIT license](LICENSE.txt). 

## Обратная связь

Если вы хотите задать вопрос или сообщить об ошибке в движке или руководстве это можно сделать на форуме [ifiction.ru](http://forum.ifiction.ru/viewtopic.php?id=2342).

## Благодарности

Выражаю благодарность **Никите Цейковцу**, **Oreolek**, **realsonic**, **Dwarf Vader** за помощь в разработке protoparser.js.