! ===========================================================================
!   Inform Language Definition File: Swedish 20080404
!   Derived from English.h dated 000629. Updated to be compatible with
!   English.h dated 040227
!
!   Supplied for use with Inform 6 -- Release 6/11 -- Serial number 040227
!
!   Copyright Graham Nelson 1993-2004 but freely usable (see manuals)
!   Translation (c) Fredrik Ramsberg 2003-2008
!
!   This translation has a license which should always be distributed
!   along with it. It basically says that you're free to use the translation,
!   as long as you don't sell it and don't claim that you've written it.
!   You may sell games compiled using this translation though.
!
!   This file is automatically Included in your game file by "parserm".
!   Strictly, "parserm" includes the file named in the "language__" variable,
!   whose contents can be defined by +language_name=XXX compiler setting (with
!   a default of "english").
!
! ---------------------------------------------------------------------------

System_file;

! Konventioner i kllkoden:
! *#* betyder kvarvarande problem
! # betyder tgrdat problem

#ifndef LIBRARY_VERSION;
  Message warning "This version of Swedish.h was made for use with library 6/11.";
#endif;
#iftrue LIBRARY_VERSION < 611;
  Message warning "This version of Swedish.h was made for use with library 6/11.";
#endif;

! ---------------------------------------------------------------------------
!   First we need to replace some routines
! ---------------------------------------------------------------------------

! Routines in Parserm.h, to be replaced by routines in SweRout.h
Replace ResetDescriptors;
Replace Descriptors;
Replace ScoreMatchL;
Replace PrintCommand;
Replace CantSee;
Replace GetGNAOfObject;
Replace PronounNotice;
Replace PrefaceByArticle;

Replace Indefart;
Replace CInDefart;
Replace Defart;
Replace CDefart;

! Routines in Verblibm.h, to be replaced by routines in SweRout.h

Replace WriteAfterEntry;
Replace Objects1Sub;



! ---------------------------------------------------------------------------
!   Part I.   Preliminaries
! ---------------------------------------------------------------------------

Constant LanguageVersion = "versttning av biblioteket till svenska v1.6 (c) Fredrik Ramsberg 2003-2008";

Global caps_mode;
Global transcribe_mode;

Attribute def_article;
Attribute uter;

Property short_name_def;

[check_caps obj   c k;
  c = k;
  if(metaclass(obj)==String)
    print (string) obj;
  else
    print (object) obj;
  rtrue;
];

[PrintBuffer buffer_name   i;
  for (i=0 : i<buffer_name-->0 : i++)
    print (char) buffer_name->(i+WORDSIZE);
];


#ifdef DEBUG;

Constant _MAXPARSE 15;
Array _NameTestBuffer -> (160 + 2);

#ifdef TARGET_ZCODE;

Array _BadWords -> _MAXPARSE;

#ifnot; !Glulx

Array _BadWords -> MAX_BUFFER_WORDS;

#endif;


[_CheckName o prop   i badcount;
  caps_mode=false;
  indef_mode=false;
  PrintToBuffer(_NameTestBuffer, 160, o, prop);
#ifdef TARGET_ZCODE;
  parse->0 = _MAXPARSE;
  for(i=2:i < (2 + _NameTestBuffer -> 1): i++) {
    _NameTestBuffer -> i = LowerCase(_NameTestBuffer -> i);
    if((_NameTestBuffer -> i)==','  or '.'  or '"')
    _NameTestBuffer -> i = ' ';
  }
#ifnot; !Glulx
  for(i=4:i < (4 + _NameTestBuffer --> 0): i++) {
    _NameTestBuffer -> i = LowerCase(_NameTestBuffer -> i);
    if((_NameTestBuffer -> i)==','  or '.'  or '"')
    _NameTestBuffer -> i = ' ';
  }
#endif;
  Tokenise__(_NameTestBuffer, parse);
  if(o.parse_name~=0) { ! Metod 1: Frga objektets parse_name-rutin
    parser_action = NULL;
    wn=1;
    i = RunRoutines(o, parse_name);
#ifdef TARGET_ZCODE;
    if(i < parse->1)
      _BadWords->(badcount++) = i;
  } else {! Metod 2: Kolla objektets name-property
    for(i=0:i < parse->1 && i < _MAXPARSE: i++)
      if(~~WordInProperty(parse-->(1+i*2), o, name))
        _BadWords->(badcount++) = i;
  }
#ifnot; !Glulx
    if(i < parse-->0)
      _BadWords->(badcount++) = i;
  } else {! Metod 2: Kolla objektets name-property
    for(i=0:i < parse-->0 && i < MAX_BUFFER_WORDS: i++)
      if(~~WordInProperty(parse-->(1+i*3), o, name))
        _BadWords->(badcount++) = i;
  }
#endif;
  return badcount;
];

[_PrintBadWords count  i j k;
  print "(";
  for(k=0: k<count: k++) {
    i = _BadWords -> k;
#ifdef TARGET_ZCODE;
    for(j=0: j < parse -> (4+i*4): j++) {
      print (char) _NameTestBuffer -> (j + parse->(5+i*4));
    }
#ifnot; !Glulx
    for(j=0: j < parse --> (2+i*3): j++) {
      print (char) _NameTestBuffer -> (j + parse-->(3+i*3));
    }
#endif;
    if(k < count - 1)
      print ", ";
  }
  print ")";
];

[_CheckThisObj obj   j isNormalObj;
  isNormalObj=parent(obj)~=0 || obj hasnt light;
  if(isNormalObj && parent(obj)==0) { ! Check if dark, lonely objects have exits
    objectloop(j in compass) isNormalObj=isNormalObj && (obj.(j.door_dir)==0);
  }
  return isNormalObj;
];

[CheckGameSub  i err anyerr wordno specific;
  specific=noun;
#ifdef TARGET_GLULX;
  if(specific==10000 && TryNumber(2)==10000) {
    ! Parse object number manually
    specific=0;
    for(i=0:i<WordLength(2):i++) {
      specific=10 * specific + ((WordAddress(2)->i) - '0');
    }
  }
#endif;
  style bold;
  if(specific) print "Undersker endast: ", (name) specific, "^";
  print  "Kollar efter fljande indikatorer p problem:
    ^* Saknar bde short_name_def och short_name.
    ^* Har short_name OCH short_name_indef eller short_name_def.
    ^* Har ord i ngon av namnstrngarna/-rutinerna som saknas som synonym till objektet.
    ^^";
  style roman;
  anyerr=false;
  objectloop(i>LibraryMessages && ~~(i ofclass class)) {
    err=false;
!    isNormalObj=parent(i)~=0 || i hasnt light;
!    if(isNormalObj && parent(i)==0) { ! Check if dark, lonely objects have exits
!      objectloop(j in compass) isnormalobj=isnormalobj && (i.(j.door_dir)==0);
!    }
    if((specific==0 && _CheckThisObj(i)) || specific==i) {
      if(i.short_name_def==0 && i.short_name==0 && i hasnt proper) {
        err=true;
        print "Saknar bde short_name_def och short_name: ", (name) i, ".^";
      } else if(i.short_name~=0 && (i.short_name_def~=0 || i.short_name_indef~=0)) {
        err=true;
        print "Har short_name OCH short_name_indef eller short_name_def: ", (name) i, ".^";
      }
      if(i.short_name~=0) {
        wordno=_CheckName(i, short_name);
        if(wordno) {
          print "Har ord i short_name som saknas som synonym: ", (name) i, " ",(_PrintBadWords) (wordno),".^";
          err=true;
        }
      }
      if(i.short_name_def~=0) {
        wordno=_CheckName(i, short_name_def);
        if(wordno) {
          print "Har ord i short_name_def som saknas som synonym: ", (name) i, " ",(_PrintBadWords) (wordno),".^";
          err=true;
        }
      }
      if(i.short_name_indef~=0) {
        wordno=_CheckName(i, short_name_indef);
        if(wordno) {
          print "Har ord i short_name_indef som saknas som synonym: ", (name) i, " ",(_PrintBadWords) (wordno),".^";
          err=true;
        }
      }
      if(i.short_name==0 && i.short_name_indef==0) {
        wordno=_CheckName(i);
        if(wordno) {
          print "Har ord i objektets namnstrng som saknas som synonym: ", (name) i, " ",(_PrintBadWords) (wordno),".^";
          err=true;
        }
      }
    }


    if(err) {
      anyerr=true;
    }

  }
  if(~~anyerr) "Inga problem hittades.";
];

[CheckGameSelectSub  i;
  style bold;
  print  "Objekt med asterisker runt namnet undersks INTE av rnkolla:^";
  style roman;
  objectloop(i>LibraryMessages && ~~(i ofclass class)) {
    if(_CheckThisObj(i)) {
      print "(",i,")  ", (name) i, "^";
    } else {
      print "(",i,") *** ", (name) i, " ***^";
    }
  }
];

#endif;

[SetGender x gender;
  if(gender == 0) {
    if(x has male or female or uter or neuter) rtrue;
    if(x has animate) gender = LanguageAnimateGender;
    else gender = LanguageInanimateGender;
  } else {
    give x ~male;
    give x ~female;
    give x ~neuter;
    give x ~uter;
  }
  switch(gender) {
    male: give x male;
    female: give x female;
    uter: give x uter;
    neuter: give x neuter;
  }
];

Class   CompassDirection
  with  number 0,
        description [;
            if (location provides compass_look && location.compass_look(self)) rtrue;
            if (self.compass_look()) rtrue;
            L__M(##Look, 7, self);
        ],
        compass_look false,
  has   scenery proper;
Object Compass "compass" has concealed;
IFNDEF WITHOUT_DIRECTIONS;
CompassDirection -> n_obj "norr"
                    with door_dir n_to, name 'n//' 'norra' 'norr' 'norrut' 'norrver' 'nord';
CompassDirection -> s_obj "sder"
                    with door_dir s_to, name 's//' 'sdra' 'sder' 'sderut' 'sderver' 'syd';
CompassDirection -> e_obj "ster"
                    with door_dir e_to, name '//' 'stra' 'ster' 'sterut' 'st' 'stver' 'sterver' 'o//';
CompassDirection -> w_obj "vster"
                    with door_dir w_to, name 'v//' 'vstra' 'vster' 'vsterut' 'vst' 'vstver' 'vsterver';
CompassDirection -> ne_obj "nordost"
                    with door_dir ne_to, name 'n' 'no' 'nordstra' 'nordster' 'nordst' 'nordost';
CompassDirection -> nw_obj "nordvst"
                    with door_dir nw_to, name 'nv' 'nordvstra' 'nordvster' 'nordvst';
CompassDirection -> se_obj "sydost"
                    with door_dir se_to, name 's' 'so' 'sydstra' 'sydster' 'sydst' 'sydost';
CompassDirection -> sw_obj "sydvst"
                    with door_dir sw_to, name 'sv' 'sydvstra' 'sydvster' 'sydvst';
CompassDirection -> u_obj "upp"
                    with door_dir u_to, name 'u//' 'upp' 'uppt' 'tak' 'taket' 'himlen' 'skyn';
CompassDirection -> d_obj "marken"
                    with door_dir d_to, name 'ner' 'nert' 'golv' 'golvet' 'mark' 'marken' 'ned' 'nedt';
ENDIF;
CompassDirection -> in_obj "insidan"
                    with door_dir in_to;
CompassDirection -> out_obj "utsidan"
                    with door_dir out_to, name 'ut';
! ---------------------------------------------------------------------------
!   Part II.   Vocabulary
! ---------------------------------------------------------------------------

! ndringar fr CustomTense:
! Numera r fljande variabler globala istllet fr konstanter:
! De gamla konstanterna r bortkommenterade fr att visa var de tidigare var.

Global IS__TX        = " r";
Global ARE__TX       = " r";
Global IS2__TX       = "r ";
Global ARE2__TX      = "r ";

Global YOU__TX       = "Du";
Global LYOU__TX       = "du";
Global FORMER__TX    = "ditt tidigare jag";
Global YOURSELF__TX  = "dig sjlv";
Constant MYSELF__TX    = "mig sjlv";

! Slut ndringar fr CustomTense:

Constant AGAIN1__WD   = 'igen';
Constant AGAIN2__WD   = 'g//';
Constant AGAIN3__WD   = 'igen';
Constant OOPS1__WD    = 'oj';
Constant OOPS2__WD    = 'ojd';
Constant OOPS3__WD    = 'ojsan';
Constant UNDO1__WD    = 'ogr';
Constant UNDO2__WD    = 'ngra';
Constant UNDO3__WD    = 'ngra';

Constant ALL1__WD     = 'alla';
Constant ALL2__WD     = 'varje';
Constant ALL3__WD     = 'allihop';
Constant ALL4__WD     = 'samtliga';
Constant ALL5__WD     = 'allt';
Constant AND1__WD     = 'och';
Constant AND2__WD     = 'samt';
Constant AND3__WD     = 'ven';
Constant BUT1__WD     = 'utom';
Constant BUT2__WD     = 'frutom';
Constant BUT3__WD     = 'utom';
Constant ME1__WD      = 'jag';
Constant ME2__WD      = 'mig';
Constant ME3__WD      = 'sjlv';
Constant OF1__WD      = 'av';
Constant OF2__WD      = 'bland';
Constant OF3__WD      = 'utav';
Constant OF4__WD      = 'av';
Constant OTHER1__WD   = 'andra';
Constant OTHER2__WD   = 'andre';
Constant OTHER3__WD   = 'annan';
Constant THEN1__WD    = 'och,';
Constant THEN2__WD    = 'och,';
Constant THEN3__WD    = 'och,';

Constant NO1__WD      = 'n//';
Constant NO2__WD      = 'nej';
Constant NO3__WD      = 'n';
Constant YES1__WD     = 'j//';
Constant YES2__WD     = 'ja';
Constant YES3__WD     = 'jo';

Constant AMUSING__WD  = 'roliga';
Constant FULLSCORE1__WD = 'fullpong';
Constant FULLSCORE2__WD = 'full';
Constant QUIT1__WD    = 'avsluta';
Constant QUIT2__WD    = 'sluta';
Constant RESTART__WD  = 'brja';
Constant RESTORE__WD  = 'hmta';

! # The need for uter, in addition to male, female and neuter,
! necessitates the adding of four bits to every GNA-word. While
! there was indeed room for these bits, it still implies that
! one or more of the other library files will have to be modified
! as well to interpret these words correctly in order to handle
! the four genders correctly.

Array LanguagePronouns table ! # Usage of this array must be modified to add uter

   !  word       possible GNAs                   connected
   !             to follow:                      to:
   !             a       i
   !             s   p   s   p
   !             mfunmfunmfunmfun

      'honom'  $$1000000010000000                NULL
      'henne'  $$0100000001000000                NULL
      'den'    $$0010000000100000                NULL
      'det'    $$0001000000010000                NULL
      'dem'    $$0000111100001111                NULL;
!      'dom'    $$0000111100001111                NULL; !# Decided to leave this out because it gets ugly when player types "pronomen" (pronouns)

Array LanguageDescriptors table ! # Usage of this array must be modified to add uter

   !  word       possible GNAs    descriptor     connected
   !             to follow:       type:          to:
   !             a       i
   !             s   p   s   p
   !             mfunmfunmfunmfun

      'min'    $$1110000011100000 POSSESS_PK      0
      'mitt'   $$0001000000010000 POSSESS_PK      0
      'mina'   $$0000111100001111 POSSESS_PK      0
! *#* Hard to translate and not very important, skipping
!      'this'   $$111111111111    POSSESS_PK      0
!      'these'  $$000111000111    POSSESS_PK      0
!      'that'   $$111111111111    POSSESS_PK      1
!      'those'  $$000111000111    POSSESS_PK      1
      'hans'   $$1111111111111111 POSSESS_PK      'honom'
      'hennes' $$1111111111111111 POSSESS_PK      'henne'
      'deras'  $$1111111111111111 POSSESS_PK      'dem'
      'dess'   $$1111111111111111 POSSESS_PK      'den' ! *#* Not quite correct, it may also refer to "det"
      'den'    $$1110000011100000 DEFART_PK       NULL ! # These have been commented out because their usage
      'det'    $$0001000000010000 DEFART_PK       NULL !     as definite articles conflict with their usage as
      'de'     $$0000111100001111 DEFART_PK       NULL !     it-words. Should be corrected in the parser somehow.
      'en'     $$1110000011100000 INDEFART_PK     NULL
      'ett'    $$0001000000010000 INDEFART_PK     NULL
      'ngra'  $$0000111100001111 INDEFART_PK     NULL
      'tnd'   $$1110000011100000 light           NULL
      'tnt'   $$0001000000010000 light           NULL
      'tnda'  $$1111111111111111 light           NULL
      'tnde'  $$1000000010000000 light           NULL
      'slckt' $$1111000011110000 (-light)        NULL
     'slckte' $$1000000010000000 (-light)        NULL
     'slckta' $$1111111111111111 (-light)        NULL;

Array LanguageNumbers table
    'en' 1 'ett' 1 'tv' 2 'tvenne' 2 'tre' 3 'trenne' 3 'fyra' 4 'fem' 5
    'sex' 6 'sju' 7 'tta' 8 'nio' 9 'tio' 10
    'elva' 11 'tolv' 12 'tretton' 13 'fjorton' 14 'femton' 15
    'sexton' 16 'sjutton' 17 'arton' 18 'aderton' 18 'nitton' 19 'tjugo' 20;

! ---------------------------------------------------------------------------
!   Part III.   Translation
! ---------------------------------------------------------------------------

[LTI_delete pos n   k m;
!  print pos,",", n, ".";
  if(n<1) n=1;
#ifdef TARGET_ZCODE;
  m=(buffer->1)+3-n;
#ifnot; ! TARGET_GLULX
  m=(buffer-->0)+5-n;
#endif; ! TARGET_
  for(k=pos:k<m:k++)
    buffer->k=buffer->(k+n);
#ifdef TARGET_ZCODE;
  buffer->1=(buffer->1)-n;
#ifnot; ! TARGET_GLULX
  buffer-->0=(buffer-->0)-n;
#endif; ! TARGET_
];

! *#* One could definitely do a lot more work here...

[ LanguageToInformese   i c1 c2 cnew no_transcribe changed printed_first charcount;

! This section handles transciption of aa, ae and oe into ,  and  respectively

#ifdef TARGET_ZCODE;
  if(transcribe_mode && buffer->1>1) {
    for(i=2:i<1+buffer->1:i++) { ! Stop one character before the last
#ifnot; ! TARGET_GLULX
  if(transcribe_mode && buffer-->0>1) {
    for(i=4:i<3+buffer-->0:i++) { ! Stop one character before the last
#endif; ! TARGET_
!      print "#";
      c1=buffer->i;
      c2=buffer->(i+1);
      if(c1=='.')
        break;
      if(c1=='!') {
        no_transcribe++;
        LTI_delete(i);
        i--;
        changed=1;
        continue;
      }

#ifdef TARGET_ZCODE;
      if(c1=='a') {
        if(c2=='a')
          cnew='';
        else if(c2=='e')
          cnew='';
      } else if(c1=='o' && c2=='e')
        cnew='';
#ifnot; ! TARGET_GLULX
      if(c1=='a') {
        if(c2=='a' or 'A')
          cnew='';
        else if(c2=='e' or 'E')
          cnew='';
      } else if(c1=='o' && c2=='e' or 'E')
        cnew='';
      else if(c1=='A') {
        if(c2=='a' or 'A')
          cnew='';
        else if(c2=='e' or 'E')
          cnew='';
      } else if(c1=='O' && c2=='e' or 'E')
        cnew='';
#endif; ! TARGET_

      if(cnew) {
        if(no_transcribe)
          no_transcribe--;
        else {
          buffer->i=cnew;
          LTI_delete(i+1);
          changed=1;
        }
        cnew=0;
      }
    }
    if(changed)
      Tokenise__(buffer,parse);

    if(transcribe_mode>1 && changed) {
      print "(transkriberades till ~";
      printed_first = false;
#ifdef TARGET_ZCODE;
      charcount = 2+buffer->1;
#ifnot; ! TARGET_GLULX
      charcount = 4+buffer-->0;
#endif; ! TARGET_
      for(i=WORDSIZE:i<charcount:i++) {
        if(printed_first || buffer->i~=' ') {
          printed_first=true;
          if(buffer->i=='.')
            break;
          print (char) buffer->i;
        }
      }

      print "~)";
      new_line;
    }

  }

! This section changes "mig sjlv" to "mig", to avoid a pronoun consisting of two words

#ifdef TARGET_ZCODE;
  for(i=2:i<=parse->1:i++)
    if(parse-->(2*i-1)=='sjlv' && parse-->(2*i-3)=='mig' or 'mej') {
      LTI_delete((parse->(4*i+1))-1,(parse->(4*i))+1);
      Tokenise__(buffer,parse);
    }
#ifnot; ! TARGET_GLULX
  for(i=2:i<=parse-->0:i++)
    if(parse-->(3*i-2)=='sjlv' && parse-->(3*i-5)=='mig' or 'mej') {
      LTI_delete((parse-->(3*i))-1,(parse-->(3*i-1))+1);
      Tokenise__(buffer,parse);
    }
#endif; ! TARGET_

];

[ TranscribeOnSub;
  if(transcribe_mode==0 or 2)
    L__M(##TranscribeOn,2);
  else
    L__M(##TranscribeOn,1);
  transcribe_mode=1;
];

[ TranscribeShowSub;
  if(transcribe_mode==0 or 1)
    L__M(##TranscribeShow,2);
  else
    L__M(##TranscribeShow,1);
  transcribe_mode=2;
];

[ TranscribeOffSub;
  if(transcribe_mode>0)
    L__M(##TranscribeOff,2);
  else
    L__M(##TranscribeOff,1);
  transcribe_mode=0;
];


! ---------------------------------------------------------------------------
!   Part IV.   Printing
! ---------------------------------------------------------------------------

Constant LanguageAnimateGender   = male;
Constant LanguageInanimateGender = uter;

Constant LanguageContractionForms = 1;     ! Swedish has only 1:
                                           ! 0 = no matter what

[ LanguageContraction text x;
  x=text; ! # Only here to avoid a warning
  return 0;
];

Array LanguageArticles -->

 !   Contraction form 0:
 !   Cdef   Def    Indef

! # Cdef and Def should not be printed unless there is an adjective before the noun

     "Den " "den " "en "        ! masc/fem/uter sing
     "Det " "det " "ett "       ! neuter sing
     "De "  "de "  "ngra ";    ! plural

                   !             a               i
                   !             s       p       s       p
                   !             m f u n m f u n m f u n m f u n

Array LanguageGNAsToArticles --> 0 0 0 1 2 2 2 2 0 0 0 1 2 2 2 2; ! # Usage of this array must be modified to add uter

[LanguagePrintShortName o  i;
  if(indef_mode==false)
    i=short_name_def;
  else
    i=short_name_indef;
   if(o.&i~=0) {
     if(metaclass(o.i)==String) {
       print (string) o.i;
       rtrue;
     }
     else if(metaclass(o.i)==Routine) {
       if(PrintOrRun(o, i)==true)
         rtrue;
     } else
       rtrue; ! Incorrect type of value
   }
   if(o.&short_name~=0) {
     if(metaclass(o.short_name)==String) {
       print (string) o.short_name;
       rtrue;
     }
     else if(metaclass(o.short_name)==Routine) {
       if(PrintOrRun(o, short_name)==true)
         rtrue;
     } else
       rtrue; ! Incorrect type of value
   }
  print (object) o;
  rtrue;
];

[ LanguageDirection d;
  switch(d)
  {
     n_to: print "norrut";
     s_to: print "sderut";
     e_to: print "sterut";
     w_to: print "vsterut";
     ne_to: print "nordost";
     nw_to: print "nordvst";
     se_to: print "sydost";
     sw_to: print "sydvst";
     u_to: print "uppt";
     d_to: print "nert";
     in_to: print "in";
     out_to: print "ut";
     default: return RunTimeError(9,d);
  }
];

Constant ENDS_WITH_T = 2;

[ LanguageNumber n force_neuter_1 obj gender f;
  if(obj~=0 && metaclass(obj)==Object) {
    if(obj has neuter) gender=neuter;
    else gender=uter;
  }
  if((gender==neuter || force_neuter_1~=0) && n==1) { print "ett"; return ENDS_WITH_T;}
  if (n==0)    { print "noll"; rfalse; }
  if (n<0)     { print "minus "; n=-n; }
  if (n>=1000) {
    if(LanguageNumber(n/1000, force_neuter_1, false, neuter)~=ENDS_WITH_T)
      print "t";
    print "usen";
    n=n%1000;
    f=1;
  }
  if (n>=100)  { LanguageNumber(n/100, force_neuter_1, false, neuter); print "hundra"; n=n%100; f=1; }
  if (n==0) rfalse;
  switch(n)
  {   1:  if(force_neuter_1) { print "ett"; return ENDS_WITH_T; } else print "en";
      2:  print "tv";
      3:  print "tre";
      4:  print "fyra";
      5:  print "fem";
      6:  print "sex";
      7:  print "sju";
      8:  print "tta";
      9:  print "nio";
      10: print "tio";
      11: print "elva";
      12: print "tolv";
      13: print "tretton";
      14: print "fjorton";
      15: print "femton";
      16: print "sexton";
      17: print "sjutton";
      18: print "arton";
      19: print "nitton";
      20 to 99:
          switch(n/10)
          {  2: print "tjugo";
             3: print "trettio";
             4: print "fyrtio";
             5: print "femtio";
             6: print "sextio";
             7: print "sjuttio";
             8: print "ttio";
             9: print "nittio";
          }
          if (n%10 ~= 0) return LanguageNumber(n%10, force_neuter_1);
  }
];

Constant SwedishNumber LanguageNumber;

[ LanguageTimeOfDay hours mins;
   print hours/10, hours%10, ":", mins/10, mins%10;
];

[ LanguageVerb i;
    switch (i) {
      'l//', 'lista':   print "lista mina tillhrigheter";
      't//':            print "titta";
      'x//':            print "undersk";
      'z//':            print "vnta";
      'inspelning':     print "inspelning";
      'meddelanden':    print "meddelanden";
      'substantiv':     print "substantiv";
      'transkribera':   print "transkribera";
      'transkription':  print "transkription";
      'uppspelning':    print "uppspelning";
      'dubbeltusan':    print "dubbeltusan";
      'jrnspikar':     print "jrnspikar";
      default: rfalse;
    }
    rtrue;
];

! ----------------------------------------------------------------------------
!  LanguageVerbIsDebugging is called by SearchScope.  It should return true
!  if word w is a debugging verb which needs all objects to be in scope.
! ----------------------------------------------------------------------------

#Ifdef DEBUG;
[ LanguageVerbIsDebugging w;
    if (w == 'purloin' or 'tree' or 'abstract'
                       or 'gonear' or 'scope' or 'showobj')
        rtrue;
    rfalse;
];
#Endif;

! ----------------------------------------------------------------------------
!  LanguageVerbLikesAdverb is called by PrintCommand when printing an UPTO_PE
!  error or an inference message.  Words which are intransitive verbs, i.e.,
!  which require a direction name as an adverb ('walk west'), not a noun
!  ('I only understood you as far as wanting to touch /the/ ground'), should
!  cause the routine to return true.
! ----------------------------------------------------------------------------

[ LanguageVerbLikesAdverb w;
    if (w == 'titta' or 'g' or 'spring' or 'flytta' or 'tryck' or 'knuffa'
          or 'putta')
        rtrue;
    rfalse;
];

! ----------------------------------------------------------------------------
!  LanguageVerbMayBeName is called by NounDomain when dealing with the
!  player's reply to a "Which do you mean, the short stick or the long
!  stick?" prompt from the parser. If the reply is another verb (for example,
!  LOOK) then then previous ambiguous command is discarded /unless/
!  it is one of these words which could be both a verb /and/ an
!  adjective in a 'name' property.
! ----------------------------------------------------------------------------

[ LanguageVerbMayBeName w;
    if (w == 'full' or 'lng' or 'lngt' or 'lnga' or 'normalt' or 'normal'
          or 'normala' or 'kort' or 'korta' or 'visa' or 'ppna' or 'vakna'
          or 'tnd')
        rtrue;
    rfalse;
];


Constant NKEY__TX     = "N=nsta mne";
Constant PKEY__TX     = "F=fregende";
Constant QKEY1__TX    = "X=ter till spelet";
Constant QKEY2__TX    = "X=fregende meny";
Constant RKEY__TX     = "RETURN=ls mne";

Constant NKEY1__KY    = 'N';
Constant NKEY2__KY    = 'n';
Constant PKEY1__KY    = 'F';
Constant PKEY2__KY    = 'f';
Constant QKEY1__KY    = 'X';
Constant QKEY2__KY    = 'x';

Constant SCORE__TX    = "Pong: ";
Constant MOVES__TX    = "Drag: ";
Constant TIME__TX     = "Tid: ";
Constant CANTGO__TX   = "Du kan inte g drt.";
!Constant FORMER__TX   = "ditt tidigare jag";
!Constant YOURSELF__TX = "dig sjlv";
!Constant YOU__TX      = "Du";
Constant DARKNESS__TX = "Mrker";

Constant THOSET__TX   = "dem";
Constant THAT__TX     = "den"; ! # Should this be "det" in case we're talking about something neuter?
Constant OR__TX       = " eller ";
Constant NOTHING__TX  = "ingenting";
!Constant IS__TX       = " r";
!Constant ARE__TX      = " r";
!Constant IS2__TX      = "r ";
!Constant ARE2__TX     = "r ";
Constant AND__TX      = " och ";
Constant WHOM__TX     = "vilken ";
Constant WHICH__TX    = "vilken ";
Constant COMMA__TX      = ", ";

[ GetSecondaryGNAOfObject obj case gender;
   if (obj hasnt animate) case = 8;

   if (obj has uter) gender = uter;
   if (obj has neuter) gender = neuter;
   if (obj has female) gender = female;
   if (obj has male) gender = male;

   if (gender == 0)
   {   if (case == 0) gender = LanguageAnimateGender;
       else gender = LanguageInanimateGender;
   }
   if (gender == female) case = case + 1;

   if (gender == uter) case = case + 2;
   if (gender == neuter) case = case + 3;
   if (obj has pluralname) case = case + 4;
   return case;
];

[ DenEllerHan obj;   ! Used in the nominative
  SetGender(obj);
  if (obj == player) { print (string) LYOU__TX; return; }
  if (obj has pluralname) { print "de"; return; }
  if (obj has uter) { print "den"; return; }
  if (obj has neuter) { print "det"; return; }
  if (obj has female) { print "hon"; return; }
  print "han";
];
[ CDenEllerHan obj;   ! Used in the accusative
  SetGender(obj);
  if (obj == player) { print (string) YOU__TX; return; }
  if (obj has pluralname) { print "De"; return; }
  if (obj has uter) { print "Den"; return; }
  if (obj has neuter) { print "Det"; return; }
  if (obj has female) { print "Hon"; return; }
  print "Han";
];
[ DenEllerHonom obj;   ! Used in the accusative
  SetGender(obj);
  if (obj == player) { print (string) YOURSELF__TX; return; }
  if (obj has pluralname) { print "dem"; return; }
  if (obj has uter) { print "den"; return; }
  if (obj has neuter) { print "det"; return; }
  if (obj has female) { print "henne"; return; }
  print "honom";
];
[ CDenEllerHonom obj;   ! Used in the accusative
  SetGender(obj);
  if (obj == player) {
    PrintToBuffer(StorageForShortName, 160, YOURSELF__TX);
    StorageForShortName->WORDSIZE =
        UpperCase(StorageForShortName->WORDSIZE);
    PrintBuffer(StorageForShortName);
    return;
  }
  if (obj has pluralname) { print "Dem"; return; }
  if (obj has uter) { print "Den"; return; }
  if (obj has neuter) { print "Det"; return; }
  if (obj has female) { print "Henne"; return; }
  print "Honom";
];

[ IndefAdjOpen obj;
  if (obj hasnt pluralname) {
    if (obj has neuter) { print "ppet"; return; }
    print "ppen"; return;
  }
  print "ppna";
];
[ IndefAdjClosed obj;
  if (obj hasnt pluralname) {
    if (obj has neuter) { print "stngt"; return; }
    print "stngd"; return;
  }
  print "stngda";
];
[ IndefAdjEmpty obj;
  if (obj hasnt pluralname) {
    if (obj has neuter) { print "tomt"; return; }
    print "tom"; return;
  }
  print "tomma";
];
[ IndefAdjWorn obj;
  if (obj hasnt pluralname) {
    if (obj has neuter) { print "ptaget"; return; }
    print "ptagen"; return;
  }
  print "ptagna";
];
[ IndefAdjLocked obj;
  if (obj hasnt pluralname) { print "lst"; return; }
  print "lsta";
];
[ IndefAdjHeld obj;
  if (obj hasnt pluralname) {
    if (obj has neuter) { print "buret"; return; }
    print "buren"; return;
  }
  print "burna";
];
[ IndefAdjGiven obj;
  if (obj hasnt pluralname) {
    if (obj has neuter) { print "bortgivet"; return; }
    print "bortgiven"; return;
  }
  print "bortgivna";
];


[ WhichorWhom obj;
  if (obj has pluralname) {print "vilka"; return; }
  if (obj has neuter) {print "vilket"; return; }
  print "vilken";
];

[ LanguageLM n x1;

  Prompt:  print "^>";

  Answer, Ask:    "Du fr inget svar.";
  Attack:         "Vld r knappast lsningen hr.";
  Blow:           "Det vore meningslst att blsa p ", (DenEllerHonom) x1, ".";
  Burn:           "Det vore farligt och fga produktivt.";
  Buy:            "Det finns just inget att kpa.";
  Climb:          "Det verkar inte s konstruktivt.";
  Close:   switch(n)
           {   1: print_ret (CDenEllerHan) x1,"  r inte ngot du kan stnga.";
               2: print_ret (CDenEllerHan) x1,
                  " r redan ",(indefadjclosed) x1,".";
               3: "Du stnger ", (the) x1, ".";
           }
  CommandsOff: switch (n) {
        1: "[Kommandoinspelning avslutad.]";
        #Ifdef TARGET_GLULX;
        2: "[Kommandoinspelning var redan avslagen.]";
        #Endif; ! TARGET_
    }
  CommandsOn: switch (n) {
        1: "[Kommandoinspelning startad.]";
        #Ifdef TARGET_GLULX;
        2: "[Kommandon spelas just nu upp.]";
        3: "[Kommandoinspelning var redan pslagen.]";
        4: "[Kommandoinspelning misslyckades.]";
        #Endif; ! TARGET_
    }
  CommandsRead: switch (n) {
        1: "[Spelar upp kommandon.]";
        #Ifdef TARGET_GLULX;
        2: "[Kommandon hller redan p att spelas upp.]";
        3: "[Uppspelning av kommandon misslyckades. Kommandoinspelning pgr.]";
        4: "[Uppspelning av kommandon misslyckades.]";
        5: "[Uppspelning av kommandon avslutad.]";
        #Endif; ! TARGET_
    }
  Consult:        "Du upptcker inget intressant i ", (the) x1, ".";
  Cut:            "Att skra i ", (DenEllerHonom) x1, " verkar inte srskilt konstruktivt.";
  Dig:            "Det kan inte ge s mycket att grva hr.";
  Disrobe: switch(n)
           {   1: print_ret (CDenEllerHonom) x1, " har du inte p dig.";
               2: "Du tar av ", (the) x1, ".";
           }
  Drink:          "Det finns inget vrt att dricka hr.";
  Drop:    switch(n)
           {   1: print_ret (CDenEllerHan) x1, " r redan hr.";
               2: "Du har inte ", (DenEllerHonom) x1, ".";
               3: "(tar frst av ", (the) x1, ")";
               4: "Slppt.";
           }
  Eat:     switch(n)
           {   1: print (CDenEllerHan) x1," r helt enkelt otlig";
                  if(x1 has pluralname) "a.";
                  if(x1 has neuter) "t."; else ".";
               2: "Du ter ", (the) x1, ". Inte illa.";
           }
  EmptyT:  switch(n)
           {   1: print_ret (The) x1, " kan inte innehlla saker.";
               2: print_ret (The) x1, " r ",(indefadjclosed) x1,".";
               3: print_ret (The) x1, " r redan ",(indefadjempty) x1,".";
               4: "Det skulle just inte tmma ngonting alls.";
           }
  Enter:   switch(n)
           {   1: print "Men du r ju redan ";
                  if (x1 has supporter) print "p "; else print "i ";
                  print_ret (the) x1, ".";
               2: print (CDenEllerHan) x1, " r inte till fr "; ! # Should be more varied.
                  switch (verb_word) {
                      'st','stll': "att st p.";
                      'sitt': "att sitta p.";
                      'ligg': "att ligga p.";
                      default: "det.";
                  }
               3: print_ret (The) x1, " r ",(indefadjclosed) x1,", s det blir nog svrt.";
               4: "Frst mste du st p dina egna ftter igen.";
               5: switch (verb_word) {
                      'st','stll': print "Du stller dig";
                      'sitt','stt': print "Du stter dig";
                      'ligg','lgg': print "Du lgger dig";
                      default: print "Du kliver "; if(x1 has supporter) print "upp"; else print "in";
                  }
                  if (x1 has supporter) print " p "; else print " i ";
                  print_ret (the) x1, ".";
               6: "(du lmnar ",(the) x1, ")";
               7: if (x1 has supporter) "(kliver p ", (the) x1, ")^";
                  if (x1 has container) "(kliver in i ", (the) x1, ")^";
                  "(gr p ", (the) x1, ")^";
           }
  Examine: switch(n)
           {   1: "Mrker, substantiv. En frnvaro av ljus att se i.";
               2: "Du ser inget speciellt med ", (the) x1, ".";
               3: print (The) x1, " r just nu ";
                  if (x1 has on) "p."; else "av.";
           }
  Exit:    switch(n)
           {   1: "Men du r ju inte i ngot fr tillfllet.";
               2: "Det kan bli svrt, efterom ", (the) x1, " r ",(indefadjclosed) x1,".";
               3: "Du lmnar ",(the) x1, ".";
               4: print "Men du r inte ";
                  if (x1 has supporter) print "p "; else print "i ";
                  print_ret (the) x1, ".";
           }
  Fill:           "Men det finns inget vatten hr att fylla p.";
  FullScore: switch(n)
           {   1: if (deadflag) print "Du fick ";
                  else          print "Du har ";
                  "pong, frdelat enligt fljande:^";
               2: "hitta viktiga freml";
               3: "beska viktiga platser";
               4: print "totalt (av ", MAX_SCORE; ")";
           }
  GetOff:         "Men du r ju inte p ", (the) x1, " fr tillfllet.";
  Give:    switch(n)
           {   1: "Du hller inte i ", (the) x1, ".";
               2: "Du bollar lite med ", (the) x1,
                  ", men det ger inte s mycket.";
               3: print_ret (The) x1, " verkar inte bry sig om ditt erbjudande.";
           }
  Go:      switch(n)
           {   1: print "Frst mste du kliva ";
                  if (x1 has supporter) print "av "; else print "ur ";
                  print_ret (the) x1, ".";
               2: print_ret (string) CANTGO__TX;   ! "You can't go that way."
               3: "Du kan inte klttra upp p ", (the) x1, ".";
               4: "Du kan inte klttra ner p ", (the) x1, ".";
               5: "Det blir svrt, eftersom ", (the) x1, " r i vgen.";
               6: "Det kan du inte, eftersom ", (the) x1," inte leder ngonstans.";
           }
  Insert:  switch(n)
           {   1: "Du mste hlla i ", (the) x1,
                  " innan du kan lgga ", (DenEllerHonom) x1,
                  " i ngot annat.";
               2: print_ret (CDenEllerHan) x1, " kan inte innehlla saker.";
               3: print_ret (The) x1, " r ",(indefadjclosed) x1,".";
               4: "Frst mste du ta av ", (DenEllerHonom) x1, ".";
               5: "Du kan inte lgga ngot i sig sjlvt.";
               6: "(tar frst av ", (DenEllerHonom) x1, ")^";
               7: "Det finns inte plats fr ngot mer i ", (the) x1, ".";
               8: "Gjort.";
               9: "Du placerar ", (the) x1, " i ", (the) second, ".";
           }
  Inv:     switch(n)
           {   1: "Du har ingenting.";
               2: print "Du har";
               3: print ":^";
               4: print ".^";
           }
  Jump:           "Du hoppar p stllet. Det ger inget.";
  JumpOver, Tie:  "Det skulle inte vara till ngon strre hjlp.";
  Kiss:           "Tnk lite mer p spelet istllet.";
  Listen:         "Du hr inget ovntat.";
  ListMiscellany:
           switch(n)
           {   1: print " (lyser)";
               2: print " (",(indefadjclosed) x1,")";
               3: print " (som r ",(indefadjclosed) x1," och lyser)";
               4: print " (",(indefadjempty) x1,")";
               5: print " (som r ",(indefadjempty) x1," och lyser)";
               6: print " (som r ",(indefadjclosed) x1," och ",(indefadjempty) x1,")";
               7: print " (som r ",(indefadjclosed) x1,", ",(indefadjempty) x1," och lyser)";
               8: print " (som lyser och r ",(indefadjworn) x1;
               9: print " (lyser";
              10: print " (",(indefadjworn) x1;
              11: print " (som ";
              12: print "r ", (indefadjopen) x1;
              13: print "r ", (indefadjopen) x1," men ",(indefadjempty) x1;
              14: print "r ", (indefadjclosed) x1;
              15: print "r ", (indefadjclosed) x1," och ",(indefadjlocked) x1;
              16: print " och ",(indefadjempty) x1;
              17: print " (som r ",(indefadjempty) x1,")";
              18: print " innehllande ";
              19: print " (p ";
              20: print ", ovanp ";
              21: print " (i ";
              22: print ", inuti ";
           }
  LMode1:         " r nu i ~normalt~ utskriftslge, vilket ger
                    lnga beskrivningar av platser du aldrig varit p tidigare
                    och annars korta beskrivningar.";
  LMode2:         " r nu i ~lngt~ utskriftslge, vilket alltid ger lnga
                   beskrivningar av platser
                   (ven om du har varit dr frut).";
  LMode3:         " r nu i ~kort~ utskriftslge, vilket alltid ger korta
                   beskrivningar av platser
                   (ven om du inte har varit dr frut).";
  Lock:    switch(n)
           {   1: print_ret (CDenEllerHan) x1, " verkar inte vara ngot du kan lsa.";
               2: print_ret (CDenEllerHan) x1, " r redan ",(indefadjlocked) x1,".";
               3: "Frst mste du stnga ", (the) x1, ".";
               4: print_ret (CDenEllerHan) x1, " verkar inte passa lset.";
               5:  "Du lser ", (the) x1, ".";
           }
  Look:    switch(n)
           {   1: print " (p ", (the) x1, ")";
               2: print " (i ", (the) x1, ")";
               3: print " (som ", (object) x1, ")";
               4: print "^P ", (the) x1;
                  WriteListFrom(child(x1),
                    ENGLISH_BIT+RECURSE_BIT+PARTINV_BIT+TERSE_BIT+CONCEAL_BIT+ISARE_BIT);
                  ".";
               5,6:
                   if (x1 ~= location) {
                       if (x1 has supporter) print "^P "; else print "^I ";
                       print (the) x1, " kan du";
                   }
                   else print "^Du kan";
                   if (n==5) print " ocks";
                   print " se ";
                   WriteListFrom(child(x1),
                     ENGLISH_BIT+RECURSE_BIT+PARTINV_BIT+TERSE_BIT+CONCEAL_BIT+WORKFLAG_BIT);
                   if (x1 ~= location) ".";
                   " hr.";
               7:  "Du ser inget srskilt i den riktningen.";
           }
  LookUnder: switch(n)
           {   1: "Men det r ju mrkt.";
               2: "Du hittar inget av intresse.";
           }
  Mild:           "Precis vad jag tnkte.";
  Miscellany:
           switch(n)
           {   1: "(tar bara hnsyn till de frsta sexton fremlen)^";
               2: "Inget att gra!";
               3: print " Du har dtt ";
               4: print " Du har vunnit ";
               5: print "^Vill du BRJA OM, HMTA ett sparat spel";
                  #IFDEF DEATH_MENTION_UNDO;
                  print ", NGRA ditt senaste drag";
                  #ENDIF;
                  if (TASKS_PROVIDED==0)
                      print ", visa FULL information om dina pong";
                  if (deadflag==2 && AMUSING_PROVIDED==0)
                      print ", se ngra frslag p ROLIGA saker att prova";
                  " eller SLUTA?";
               6: "[Din speltolk har tyvrr inte ~ngra~.]";
               7: "~ngra~ misslyckades.  [Det r inte alla speltolkar som har ~ngra~.]";
               8: "Skriv ett av svaren ovan.";
               9: "^Nu r det kolsvart hr inne!";
              10: "Urskta?";
              11: "[Du kan inte ~ngra~ ngot som du inte har gjort!]";
              12: "[Du kan tyvrr inte ~ngra~ tv gnger i rad.]";
              13: "[Senaste draget ngrat.]";
              14: "Tyvrr, det kan inte rttas till.";
              15: "Det var s lite s.";
              16: "~Hoppsan~ kan bara rtta till ett enda ord.";
              17: "Det r kolsvart, och du kan inte se ngonting alls.";
              18: print "dig sjlv";
              19: "Lika snygg som alltid.";
              20: "Fr att upprepa ett kommando som ~groda, hoppa~, skriv bara
                   ~igen~, inte ~groda, igen~.";
              21: "Det verkar inte rimligt att gra det igen.";
              22: "Du kan inte brja en mening med ett komma.";
              23: "Du verkar vilja prata med ngon, men jag frstr inte vem.";
              24: "Du kan inte prata med ", (the) x1, ".";
              25: "Fr att prata med ngon, prova ~ngon, hej~ eller ngot liknande.";
              26: "(tar frst upp ", (the) not_holding, ")";
              27: "Den meningen frstod jag inte.";
              28: print "Jag tror jag frstod ~";
              29: "Det talet frstod jag inte.";
              30: "Ngon sdan ser du inte till.";
              31: "Du verkar ha sagt fr lite!";
              32: print_ret (CDenEllerHonom) x1, " hller du inte i!"; ! # Could be rephrased to include the correct Den/Det, using ThatorThose?
              33: "Du kan inte anvnda flera freml med det verbet.";
              34: "Du kan bara anvnda flera freml en gng per rad.";
              35: "Jag r inte sker p vad ~", (address) pronoun_word,
                  "~ refererar till.";
              36: "Du undantog ngot som nd inte var med!";
              37: "Det kan du bara gra med ngot levande.";
              38: "Det verbet knner jag inte igen.";
              39: "Det r inte ngot du har ngon anvndning av i det hr spelet.";
              40: "Du kan inte se ~", (address) pronoun_word,
                  "~ (", (the) pronoun_obj, ") just nu.";
              41: "Jag frstod inte riktigt den avslutningen.";
              42: print "Det finns ";
                  if (x1==0) print "inga";
                  else { print "bara "; LanguageNumber(x1, 0, multiple_object-->1); }
                  if (x1==1) {
                    if(multiple_object-->1 has neuter)
                      " sdant tillgngligt.";
                    " sdan tillgnglig.";
                  } else
                    " sdana tillgngliga."; ! # Tries to care about gender
              43: "Inget att gra!";
              44: switch(action_to_be) {
                    ##Drop, ##Insert, ##PutOn: "Du har inget att slppa!";
                    default: "Det finns inget att ta!";
                  }
              45: print "Vem menar du, ";
              46: print "Menar du ";
              47: "Tyvrr kan du bara ange ett freml hr. Exakt vilket menar du?";
              48: print "Jag antar att du menar ~"; ! # This message should work now
                  if (actor~=player) print (name) actor, ", ";
                  PrintCommand();
                  style bold;
                  print " ngon";
                  style roman;
                  print "~, men vem?^";
              49: print "Jag antar att du menar ~";
                  if (actor~=player) print (the) actor, ", ";
                  PrintCommand();
                  style bold;
                  print " ngot";
                  style roman;
                  print "~, men vad?^";
              50: print "Du ";
                  if (x1 > 0) print "fick"; else { x1 = -x1; print "frlorade"; }
                  print " just ";
                  LanguageNumber(x1,false,false,neuter);
                  print " pong";
              51: "(Eftersom ngot dramatiskt har hnt
                   har din sekvens av kommandon avbrutits.)";
              52: "^Skriv ett tal mellan 1 och ", x1,
                  ", 0 fr att visa det hr igen eller tryck RETURN.";
              53: "^[Tryck MELLANSLAG.]";
              54: "[Kommentar sparad.]";
              55: "[Kommentar INTE sparad.]";
              56: "~, men sedan tappade du bort mig.";
              57: print "?^";
           }
  NotifyOn:       "Pongmeddelanden pslaget.";
  NotifyOff:      "Pongmeddelanden avslaget.";
  Objects: switch(n)
           {   1: "Freml du har anvnt:^";
               2: "Inga.";
               3: print "   (",(indefadjworn) x1,")"; ! # Is x1 actually set to the object# in question here? (It is now)
               4: print "   (",(indefadjheld) x1,")"; ! # Is x1 actually set to the object# in question here? (It is now)
               5: print "   (",(indefadjgiven) x1,")"; ! # Is x1 actually set to the object# in question here? (It is now)
               6: print "   (i ", (name) x1, ")";
               7: print "   (i ", (the) x1, ")";
               8: print "   (inuti ", (the) x1, ")";
               9: print "   (p ", (the) x1, ")";
              10: print "   (borta)";
           }
  Open:    switch(n)
           {   1: print_ret (CDenEllerHan) x1,
                  " kan inte ppnas.";
               2: print_ret (CDenEllerHan) x1," verkar ",(indefadjlocked) x1,".";
               3: print_ret (CDenEllerHan) x1," r redan ",(indefadjopen) x1,".";
               4: print "Du ppnar ", (the) x1, " och finner d ";
                  if (WriteListFrom(child(x1),
                      ENGLISH_BIT + TERSE_BIT + CONCEAL_BIT)==0) "nothing.";
                  ".";
               5: "Du ppnar ", (the) x1, ".";
           }
  Order:          print_ret (The) x1," har viktigare saker fr sig.";
  Places: switch (n) {
        1:  print "Du har beskt: ";
        2:  print ".^";
    }
  Pray:           "Inget direkt uppenbart hnder.";
  Pronouns: switch(n)
           {   1: print "Fr tillfllet refererar ";
               2: print "till ";
               3: print "inte till ngot srskilt";
               4: "inga pronomen till ngot alls.";
               5: ".";
           }
  Pull, Push, Turn:
           switch(n)
           {   1: print_ret (CDenEllerHan) x1, " sitter fast.";
               2: "Det misslyckas.";
               3: "Inget verkar hnda.";
               4: "Det vore direkt ohyfsat.";
           }
  PushDir: switch(n)
           {   1: "Var det det bsta du kunde komma p?";
               2: "Det r ingen riktning.";
               3: "I den riktningen gr det i alla fall inte.";
           }
  PutOn:   switch(n)
           {   1: "Du mste hlla i ", (the) x1,
                  " innan du kan lgga ", (DenEllerHonom) x1,
                  " p ngot annat.";
               2: "Du kan inte lgga ngot p sig sjlvt.";
               3: "Att lgga saker p ", (the) x1, " skulle inte leda ngon vart.";
               4: "Du r inte smidig nog.";
               5: "(tar frst av ", (DenEllerHonom) x1, ")^";
               6: "Det finns inte plats fr ngot mer p ", (the) x1, ".";
               7: "Gjort.";
               8: "Du placerar ", (the) x1, " p ", (the) second, ".";
           }
  Quit:    switch(n)
           {   1: print "Svara ja eller nej.";
               2: print "r du sker p att du vill sluta? ";
           }
  Remove:  switch(n)
           {   1: print_ret (CDenEllerHan) x1, " r tyvrr in",(indefadjclosed) x1, ".";
               2: print_ret "Men ",(DenEllerHan) x1, " r inte dr nu.";
               3: "Borttagen.";
           }
  Restart: switch(n)
           {   1: print "r du sker p att du vill brja om? ";
               2: "Misslyckades.";
           }
  Restore: switch(n)
           {   1: "Hmtningen misslyckades.";
               2: "Ok.";
           }
  Rub:            "Det ger inget anvndbart resultat.";
  Save:    switch(n)
           {   1: "Sparningen misslyckades.";
               2: "Ok.";
           }
  Score:   switch (n) {
               1: if (deadflag) print "I det spelet fick du ";
                  else print "Du har hittills ftt ihop ";
                  print score, " pong av ", MAX_SCORE,
                  " mjliga p ", turns, " drag";
                  return;
               2: "Det finns inga pong i detta spel.";
           }
  ScriptOn: switch(n)
           {   1: "Utskrift r redan pslaget.";
               2: "Hr brjar en utskrift av";
               3: "Frsket att pbrja en utskrift misslyckades.";
           }
  ScriptOff: switch(n)
           {   1: "Utskrift r redan avslaget.";
               2: "^Hr slutar utskriften.";
               3: "Frsket att avsluta utskriften misslyckades.";
           }
  Search:  switch(n)
           {   1: "Men det r ju mrkt.";
               2: "Det finns inget p ", (the) x1, ".";
               3: print "P ", (the) x1;
                  WriteListFrom(child(x1),
                      TERSE_BIT + ENGLISH_BIT + ISARE_BIT + CONCEAL_BIT);
                  ".";
               4: "Du hittar inget av intresse.";
               5: "Du ser inte vad som finns i ", (the) x1, ", eftersom ",
                  (DenEllerHan) x1, " r ",(indefadjclosed) x1,".";
               6: print_ret (The) x1, " r ",(indefadjempty) x1,".";
               7: print "I ", (the) x1;
                  WriteListFrom(child(x1),
                      TERSE_BIT + ENGLISH_BIT + ISARE_BIT + CONCEAL_BIT);
                  ".";
           }
  Set:            "Nej, du kan inte stta ", (DenEllerHonom) x1, ".";
  SetTo:          "Nej, du kan inte stta ", (DenEllerHonom) x1, " till ngot.";
  Show:    switch(n)
           {   1: "Du hller inte i ", (the) x1, ".";
               2: print (The) x1, " r inte imponera";
                  if (x1 has pluralname) "de.";
                  if (x1 has neuter) "t."; else "d.";
           }
  Sing:           "Din sngrst r inte mycket att hurra fr.";
  Sleep:          "Du knner dig inte direkt smnig.";
  Smell:          "Du knner inga ovntade lukter.";
  Sorry:          "Det r okej. Fr den hr gngen.";
  Squeeze: switch(n)
           {   1: "Tafsa inte!";
               2: "Det ger inget mrkbart resultat.";
           }
  Strong:         "Riktiga ventyrare anvnder inte sdana ord.";
  Swim:           "Det finns inte s mycket vatten att simma i.";
  Swing:          "Det finns just inget vettigt att gunga hr.";
  SwitchOn: switch(n)
           {   1: print_ret (CDenEllerHan) x1," verkar inte vara ngot du kan sl av och p.";
               2: print_ret (CDenEllerHan) x1,
                  " r redan p.";
               3: "Du slr p ", (the) x1, ".";
           }
  SwitchOff: switch(n)
           {   1: print_ret (CDenEllerHan) x1," verkar inte vara ngot du kan sl av och p.";
               2: print_ret (CDenEllerHan) x1,
                  " r redan av.";
               3: "Du slr av ", (the) x1, ".";
           }
  Take:    switch(n)
           {   1: print "Tag";
                  if(noun has pluralname) "na.";
                  if(noun has neuter) "et."; else "en.";
               2: "Du r alltid sjlvupptagen.";
               3: "Det vill ",(DenEllerHan) x1," nog inte.";
               4: print_ret "D mste du frst lmna ",(the) x1, ".";
               5: "Du har redan ", (DenEllerHonom) x1, ".";
               6: print_ret (CDenEllerHan) noun, " verkar tillhra ", (the) x1, ".";
               7: print_ret (CDenEllerHan) noun, " verkar vara en del av ", (the) x1, ".";
               8: print_ret "Du kan inte komma t ",(DenEllerHonom) x1, ".";
               9: print_ret (The) x1, " r inte ",(indefadjopen) x1, ".";
              10: print_ret "Du kan knappast flytta ", (DenEllerHonom) x1, ".";
              11: print_ret (CDenEllerHan) x1, " sitter fast.";
              12: "Du br redan p fr mycket.";
              13: "(lgger ", (the) x1, " i ", (the) SACK_OBJECT,
                  " fr att f plats)";
           }
  Taste:          "Du knner ingen ovntad smak.";
  Tell:    switch(n)
           {   1: "Du pratar lite med dig sjlv.";
               2: "Ingen reaktion.";
           }
  Think:          "En utmrkt id!";
  ThrowAt: switch(n)
           {   1: "Meningslst.";
               2: "Nr det vl kommer till kritan vgar du inte.";
           }
  Touch:   switch(n)
           {   1: "Bort med tassarna!";
               2: "Det knns ungefr som du hade frvntat dig.";
               3: "Om du tror att det hjlper, s visst.";
           }
  TranscribeOn:
           switch(n)
           {   1: "Transkriptionslge r redan pslaget.";
               2: "Transkriptionslge pslaget. ~aa~ betyder nu , ~ae~ betyder 
                   och ~oe~ betyder . Skriv ett utropstecken fre varje sdan
                   bokstavskombination som INTE ska transkriberas, som t ex i ~oeppna b!oetten~.
                   Skriv ~transkription visa~ fr att f meddelande nr transkription anvnds.";
           }
  TranscribeOff:
           switch(n)
           {   1: "Transkriptionslge r redan avslaget.";
               2: "Transkriptionslge avslaget.";
           }
  TranscribeShow:
           switch(n)
           {   1: "Transkriptionslge med visning r redan pslaget.";
               2: "Transkriptionslge med visning pslaget. ~aa~ betyder nu , ~ae~ betyder 
                   och ~oe~ betyder . Skriv ett utropstecken fre varje sdan
                   bokstavskombination som INTE ska transkriberas, som t ex i ~oeppna b!oetten~.";
           }
  Unlock:  switch(n)
           {   1: print_ret (CDenEllerHan) x1, " verkar inte vara ngot du kan lsa upp.";
               2: print_ret (CDenEllerHan) x1," r redan o",(indefadjlocked) x1,".";
               3: print_ret (CDenEllerHan) x1, " verkar inte passa lset.";
               4: "Du lser upp ", (the) x1, ".";
           }
  VagueGo:       "Du mste tala om i vilken kompassriktning du vill g.";
  Verify:  switch(n)
           {   1: "Spelfilen testades och verkar vara intakt.";
               2: "Spelfilen testades men verkar inte vara intakt.
                   Det kan finnas allvarliga fel p den.";
           }
  Wait:           "Du vntar.";
  Wake:           "Den grymma sanningen r att det hr inte r ngon drm.";
  WakeOther:      "Det verkar ondigt.";
  Wave:    switch(n)
           {   1: "Men du hller inte i ", (DenEllerHonom) x1, ".";
               2: "Du ser fnig ut nr du viftar med ", (the) x1, ".";
           }
  WaveHands:      "Du vinkar, ven om det knns lite fnigt.";
  Wear:    switch(n)
           {   1: "Du kan inte ta p dig ", (DenEllerHonom) x1, "!";
               2: "Du hller inte i ", (DenEllerHonom) x1, "!";
               3: print_ret (CDenEllerHonom) x1, " har du redan p dig!";
               4: "Du tar p dig ", (the) x1, ".";
           }
  Yes, No:        "Det var en retorisk frga.";
];

! ==============================================================================

Constant LIBRARY_SWEDISH;       ! for dependency checking.

! ==============================================================================
