! ==============================================================================
!
!   * * * SLOVENIAN GRAMMAR * * *
!
!
!   Slovenian grammar table entries for the standard verbs library.
!
!   Release 2, 22. June 2007
!
!
!   Copyright (c) 2007 by Benjamin Lipovsek
!
!   e-mail:   benolipovsek@yahoo.com
!
! ==============================================================================
!
!   Original file created by Graham Nelson, (c) 1993-2004
!
!   Supplied for use with Inform 6.
!
! ==============================================================================
!
!   NAVODILA:
!
!
!   Knjiznico SlovenianG.h moras najprej namestiti v mapo LIB paketa Inform.
!   Za njeno vkljucitev pa nato v kodi le se zamenjaj vrstico:
!
!      Inlcude "Grammar";
!
!   Z vrstico:
!
!      Include "SlovenianG";
!
! ==============================================================================
!
!   Dodatne informacije, napotke za uporabo in razlage novih funkcij najdes
!   v pdf knjizici "Slovenska interaktivna fikcija", ki jo dobis na naslovu:
!
!      http://sloif.freehost386.com
!
! ==============================================================================
!
! ******************************************************************************
! * Ta verzija knjiznice je se vedno v zgodnji fazi testiranja. Lepo prosim,   *
! * poslji vse najdene napake in hrosce, prav tako pa tudi morebitne ideje,    *
! * predloge in vprasanja, na zgoraj napisani e-naslov. Najlepsa hvala!        *
! ******************************************************************************
!
! ==============================================================================

System_file;

! ------------------------------------------------------------------------------
!    1.   Metaukazi
! ------------------------------------------------------------------------------

Verb meta 'normalno' 'opisno'
    *                                           -> LMode1;
Verb meta 'dolgo' 'gostobesedno'
    *                                           -> LMode2;
Verb meta 'kratko' 'okrnjeno'
    *                                           -> LMode3;
Verb meta 'opombe'
    *                                           -> NotifyOn
    * 'vkljucene'                               -> NotifyOn
    * 'izkljucene'                              -> NotifyOff;
Verb meta 'zaimki'
    *                                           -> Pronouns;
Verb meta 'izhod' 'koncaj' 'konec'
    *                                           -> Quit;
Verb meta 'snemanje'
    *                                           -> CommandsOn
    * 'vkljuceno'                               -> CommandsOn
    * 'izkljuceno'                              -> CommandsOff;
Verb meta 'predvajanje'
    *                                           -> CommandsRead;
Verb meta 'zacni' 'znova'
    *                                           -> Restart
    * 'znova'					-> Restart;
Verb meta 'nalozi'
    *                                           -> Restore
    * 'shranjeno'				-> Restore;
Verb meta 'shrani'
    *                                           -> Save;
Verb meta 'tocke'
    *                                           -> Score;
Verb meta 'tockovnik'
    * 		                                -> FullScore;
Verb meta 'scenarij'
    *                                           -> ScriptOn
    * 'vkljucen'                                -> ScriptOn
    * 'izkljucen'                               -> ScriptOff;
Verb meta 'verify'
    *                                           -> Verify;
Verb meta 'izdaja' 'verzija'
    *                                           -> Version;

#Ifndef NO_PLACES;
Verb meta 'objekti'
    *                                           -> Objects;
Verb meta 'kraji' 'lokacije'
    *                                           -> Places;
#Endif; ! NO_PLACES

! ------------------------------------------------------------------------------
!    2.   Razhroscevalni ukazi
! ------------------------------------------------------------------------------

#Ifdef DEBUG;
Verb meta 'actions'
    *                                           -> ActionsOn
    * 'on'                                      -> ActionsOn
    * 'off'                                     -> ActionsOff;
Verb meta 'changes'
    *                                           -> ChangesOn
    * 'on'                                	-> ChangesOn
    * 'off'                              	-> ChangesOff;
Verb meta 'gonear'
    * noun                                      -> Gonear;
Verb meta 'goto'
    * number                                    -> Goto;
Verb meta 'random'
    *                                           -> Predictable;
Verb meta 'routines' 'messages'
    *                                           -> RoutinesOn
    * 'on'                                      -> RoutinesOn
    * 'off'                                     -> RoutinesOff;
Verb meta 'scope'
    *                                           -> Scope
    * noun                                      -> Scope;
Verb meta 'showobj'
    *                                           -> Showobj
    * number                                    -> Showobj
    * multi                                     -> Showobj;
Verb meta 'showverb'
    * special                                   -> Showverb;
Verb meta 'timers' 'daemons'
    *                                           -> TimersOn
    * 'on'                                      -> TimersOn
    * 'off'                                     -> TimersOff;
Verb meta 'trace'
    *                                           -> TraceOn
    * number                                    -> TraceLevel
    * 'on'                                      -> TraceOn
    * 'off'                                     -> TraceOff;
Verb meta 'abstract'
    * noun 'to' noun                            -> XAbstract;
Verb meta 'purloin'
    * multi                                     -> XPurloin;
Verb meta 'tree'
    *                                           -> XTree
    * noun                                      -> XTree;

#Ifdef TARGET_GLULX;
Verb meta 'glklist'
    *                                           -> Glklist;
#Endif; ! TARGET_

#Endif; ! DEBUG

! ------------------------------------------------------------------------------
!    3.   Standardni ukazi
! ------------------------------------------------------------------------------

[ ADirection; if (noun in compass) rtrue; rfalse; ];

Verb 'odgovori' 'reci' 'zakrici' 'zavpij'
    * creature topic				-> Answer;
Verb 'pobaraj' 'vprasaj'
    * creature 'o//'/'glede'/'po' topic         -> Ask;
Verb 'prosi' 'zaprosi'
    * creature 'za' noun			-> AskFor;
Verb 'brcni' 'muci' 'napadi' 'razbij' 'sesuj'
     'ubij' 'udari' 'umori' 'unici' 'zlamaj'
     'zlomi'
    * noun                                      -> Attack;
Verb 'napihni'
    * held                                      -> Blow;
Verb 'krucifiks' 'sment' 'presneto' 'zlomka'
    *                                           -> Mild;
Verb 'skuri' 'vzgi' 'zakuri' 'zazgi'
    * noun                                      -> Burn
    * noun 'z//'/'s//' held			-> Burn;
Verb 'kupi' 'nabavi' 'placaj'
    * noun                                      -> Buy;
Verb 'splezaj' 'preplezaj'
    * noun                                      -> Climb
    * 'na'/'preko'/'cez' noun                   -> Climb;
Verb 'pokrij' 'zaloputni' 'zapri'
    * noun                                      -> Close;
Verb 'narezi' 'nasekaj' 'razrezi' 'razsekaj'
     'rezi' 'posekaj' 'prerezi' 'sekaj'
    * noun                                      -> Cut;
Verb 'kopaj' 'koplji' 'zakopaj' 'zakoplji'
    * noun                                      -> Dig
    * noun 'z//'/'s//' held			-> Dig
    * 'v//'/'po' noun				-> Dig
    * 'v//'/'po' noun 'z//'/'s//' held          -> Dig;
Verb 'pogoltni' 'popij' 'posrkaj' 'spij'
     'srkni'
    * noun                                      -> Drink;
Verb 'izpusti' 'odvrzi' 'spusti' 'zavrzi'
    * multiheld                                 -> Drop
    * multiexcept 'v//' noun		        -> Insert
    * multiexcept 'na' noun                     -> PutOn;
Verb 'vrzi' 'zalucaj'
    * held 'v//'/'proti'/'na' noun		-> ThrowAt;
Verb 'jej' 'malicaj' 'pojej' 'pomalicaj'
    * held                                      -> Eat;
Verb 'izprazni' 'sprazni'
    * noun                                      -> Empty
    * noun 'v//'/'na' noun                      -> EmptyT;
Verb 'vstopi'
    *                                           -> GoIn
    * 'v//'/'skozi' noun         		-> Enter;
Verb 'glej' 'p//' 'poglej' 'preveri'
    * noun                                      -> Examine
    * 'okrog'					-> Look
    * 'okrog' 'sebe'				-> Look
    * 'v//'/'skozi'/'na' noun			-> Search
    * 'pod' noun				-> LookUnder
    * noun=ADirection				-> Examine
    * 'proti'/'na'/'v//' noun=ADirection	-> Examine;
Verb 'opisi' 'orisi'
    * noun					-> Examine
    * noun=ADirection				-> Examine
    * creature 'o//'/'glede' topic              -> Tell;
Verb 'oglej'
    * 'si' noun					-> Examine;
Verb 'izstopi' 'ven'
    *                                           -> Exit
    * 'iz'/'skozi' noun          		-> Exit;
Verb 'izpolni' 'napolni' 'zapolni'
    * noun                                      -> Fill;
Verb 'dvigni' 'izvleci' 'poberi' 'odstrani'
     'vzemi'
    * multi                                     -> Take
    * multiinside 'iz'/'z//'/'s//' noun         -> Remove;
Verb 'daj' 'izroci' 'ponudi' 'podari'
    * held creature                       	-> Give
    * creature held                             -> Give reverse
    * multiexcept 'na' noun			-> PutOn
    * multiexcept 'v//' noun			-> Insert;
Verb 'hodi' 'odidi' 'pojdi' 'steci' 'stopi'
     'teci' 'zlezi'
    *                                           -> VagueGo
    * noun=ADirection				-> Go
    * 'na'/'proti' noun=ADirection              -> Go
    * 'v//'/'skozi'/'na' noun     		-> Enter
    * 'cez'/'preko' noun			-> Climb
    * 'ven'					-> Exit
    * 'iz' noun					-> Exit
    * 'ven' 'iz' noun				-> Exit
    * 'z//'/'s//' noun				-> GetOff
    * 'dol' 'z//'/'s//' noun			-> GetOff;
Verb 'splazi' 'spravi'
    * 'se' 'v//'/'skozi'/'na' noun		-> Enter
    * 'se' 'cez'/'preko' noun			-> Climb
    * 'se' 'ven'				-> Exit
    * 'se' 'iz' noun				-> Exit
    * 'se' 'ven' 'iz' noun			-> Exit
    * 'se' 'z//'/'s//' noun			-> GetOff
    * 'se' 'dol' 'z//'/'s//' noun		-> GetOff;
Verb 'noter' 'notri'
    *                                           -> GoIn;
Verb 'vstavi' 'vtakni'
    * multiexcept 'v//' noun             	-> Insert;
Verb 'imetje' 'i//' 'inv' 'inventar'
    *                                           -> Inv
    * 'pokoncno'                                -> InvTall
    * 'lezece'                                  -> InvWide;
Verb 'hop' 'poskakuj' 'preskoci' 'skaci'
     'skoci'
    * 						-> Jump
    * noun					-> JumpOver
    * 'preko'/'cez' noun                        -> JumpOver
    * 'z//'/'s//' noun				-> GetOff
    * 'v//'/'skozi'/'na' noun			-> Enter;
Verb 'objemi' 'poljubi'
    * creature                                  -> Kiss;
Verb 'zapusti'
    * noun					-> Exit
    * 'igro'/'zgodbo'/'program'			-> Quit;
Verb 'poslusaj' 'prisluhni' 'slisi'
    *                                           -> Listen
    * noun                                      -> Listen;
Verb 'zakleni'
    * noun 'z//'/'s//' held                     -> Lock;
Verb 'opis' 'o//' 'razgled' 'razglej'
    *                                           -> Look
    * 'lokacije'/'prostora'/'sobe'		-> Look
    * 'se'                                 	-> Look;
Verb 'ne' 'nak'
    *                                           -> No;
Verb 'odkrij' 'odpri' 'razvij'
    * noun                                      -> Open
    * noun 'z//'/'s//' held                     -> Unlock;
Verb 'odlepi' 'odlusci'
    * noun                                      -> Take;
Verb 'moli'
    *                                           -> Pray;
Verb 'potegni' 'povleci' 'vleci'
    * noun                                      -> Pull
    * multiinside 'iz' noun			-> Remove;
Verb 'porini' 'potisni' 'premakni' 'premikaj'
     'prestavi' 'pritisni' 'rini'
    * noun                                      -> Push
    * noun 'k//'/'h//'/'proti' noun             -> PushDir
    * noun 'v//'/'na' noun                      -> Transfer;
Verb 'polozi' 'postavi'
    * multiexcept 'v//' noun                    -> Insert
    * multiexcept 'na' noun                     -> PutOn;
Verb 'beri' 'citaj' 'listaj' 'preberi'
     'precitaj' 'prelistaj'
    * noun                                      -> Examine
    * 'o//'/'glede' topic
      'v//'/'na'/'po'/'iz' noun 		-> Consult
    * 'v//'/'na'/'po'/'iz' noun
      'o//'/'glede' topic 			-> Consult
    * topic 'v//'/'na'/'po'/'iz' noun           -> Consult
    * noun 'o//'/'glede' topic			-> Consult;
Verb 'brisi' 'cisti' 'drgni' 'obrisi' 'ocisti'
     'pobrisi' 'pocisti' 'podrgni' 'pometaj'
     'pometi' 'zbrisi'
    * noun                                      -> Rub
    * 'po' noun					-> Rub;
Verb 'isci' 'pobrskaj' 'poisci' 'preglej'
     'preisci' 'razisci'
    * noun                                      -> Search
    * 'po' noun					-> Search
    * 'o//'/'glede' topic
      'v//'/'na'/'po'/'iz' noun 		-> Consult
    * 'v//'/'na'/'po'/'iz' noun
      'o//'/'glede' topic 			-> Consult
    * topic 'v//'/'na'/'po'/'iz' noun           -> Consult
    * noun 'o//'/'glede' topic			-> Consult;
Verb 'nastavi'
    * noun                                      -> Set
    * noun 'na' special                         -> SetTo;
Verb 'sleci'
    * held                                      -> Disrobe
    * 'si' held					-> Disrobe;
Verb 'pokazi' 'predstavi'
    * creature held                             -> Show reverse
    * held creature                        	-> Show;
Verb 'hudica' 'jebemti' 'jebenti' 'kurba'
     'picka' 'pizda' 'prekleto' 'sranje'
    *                                           -> Strong
    * topic					-> Strong;
Verb 'poj' 'prepevaj'
    *                                           -> Sing;
Verb 'lezi' 'sedi'
    * 'v//'/'na'/'vrh' noun           	        -> Enter
    * 'na' 'vrh' noun				-> Enter;
Verb 'ulezi' 'usedi'
    * 'se' 'v//'/'na'/'vrh' noun		-> Enter
    * 'se' 'na' 'vrh' noun			-> Enter;
Verb 'dremaj' 'pocivaj' 'spi' 'zadremaj'
     'zaspi'
    *                                           -> Sleep;
Verb 'poduhaj' 'povohaj' 'vohaj' 'vonjaj'
    *                                           -> Smell
    * noun                                      -> Smell;
Verb 'oprosti' 'oprostite' 'pardon'
    *                                           -> Sorry;
Verb 'stisni' 'zmeckaj' 'zdrobi'
    * noun                                      -> Squeeze;
Verb 'stoj' 'vstani'
    *                                           -> Exit
    * 'se'					-> Exit;
Verb 'plavaj' 'potapljaj' 'potopi' 'zaplavaj'
    *                                           -> Swim
    * 'se'					-> Swim;
Verb 'nihaj' 'zanihaj' 'zazibaj' 'zibaj'
    * noun                                      -> Swing;
Verb 'prizgi' 'vkljuci' 'vklopi'
    * noun                                      -> Switchon;
Verb 'izkljuci' 'izklopi' 'ugasni'
    * noun					-> Switchoff;
Verb 'okusi' 'pokusi'
    * noun                                      -> Taste;
Verb 'obrazlozi' 'povej' 'razlozi' 'sporoci'
    * creature 'o//'/'glede' topic              -> Tell;
Verb 'misli' 'pomisli' 'premisli' 'razmisli'
     'razmisljaj'
    *                                           -> Think;
Verb 'povezi' 'pricvrsti' 'pritrdi' 'privezi'
     'zavezi' 'zvezi'
    * noun                                      -> Tie
    * noun 'na'/'k//'/'h//'/'s//'/'z//' noun    -> Tie;
Verb 'bozaj' 'obcuti' 'otipaj' 'pobozaj'
     'potipaj' 'tipaj' 'zacuti'
    * noun                                      -> Touch;
Verb 'dotakni' 'dotikaj'
    * 'se' noun					-> Touch;
Verb 'obrni' 'odvij' 'privij' 'rotiraj'
     'sukaj' 'zarotiraj' 'zasukaj'
    * noun                                      -> Turn;
Verb 'mahaj' 'pomahaj'
    *                                           -> WaveHands
    * 'z//' 'roko'/'rokami'			-> WaveHands
    * 'z//'/'s//' noun                          -> Wave;
Verb 'nadeni' 'obleci'
    * held                                      -> Wear
    * 'si' held					-> Wear
    * 'se' 'v//' held				-> Wear;
Verb 'da' 'd//' 'ja' 'seveda'
    *                                           -> Yes;
Verb 'odkleni'
    * noun 'z//'/'s//' held                     -> Unlock;
Verb 'cakaj' 'c//' 'pocakaj'
    *                                           -> Wait;
Verb 'prebudi' 'zbudi'
    * 'se'                                      -> Wake
    * creature                                  -> WakeOther;

! ------------------------------------------------------------------------------
!  This routine is no longer used here, but provided to help existing games
!  which use it as a general parsing routine:
! ------------------------------------------------------------------------------

[ ConTopic w;
    consult_from = wn;
    do w = NextWordStopped();
    until (w == -1 || (w == 'to' && action_to_be == ##Answer));
    wn--;
    consult_words = wn - consult_from;
    if (consult_words == 0) return -1;
    if (action_to_be == ##Answer or ##Ask or ##Tell) {
        w = wn; wn = consult_from; parsed_number = NextWord();
        if (parsed_number == 'the' && consult_words > 1) parsed_number = NextWord();
        wn = w;
        return 1;
    }
    return 0;
];

! ------------------------------------------------------------------------------
!  Final task: provide trivial routines if the user hasnt already:
! ------------------------------------------------------------------------------

#Stub AfterLife         0;
#Stub AfterPrompt       0;
#Stub Amusing           0;
#Stub BeforeParsing     0;
#Stub ChooseObjects     2;
#Stub DarkToDark        0;
#Stub DeathMessage      0;
#Stub GamePostRoutine   0;
#Stub GamePreRoutine    0;
#Stub InScope           1;
#Stub LookRoutine       0;
#Stub NewRoom           0;
#Stub ParseNumber       2;
#Stub ParserError       1;
#Stub PrintTaskName     1;
#Stub PrintVerb         1;
#Stub TimePasses        0;
#Stub UnknownVerb       1;

#Ifdef TARGET_GLULX;
#Stub HandleGlkEvent    2;
#Stub IdentifyGlkObject 4;
#Stub InitGlkWindow     1;
#Endif; ! TARGET_GLULX

#Ifndef PrintRank;
! Constant Make__PR;
! #Endif;
! #Ifdef Make__PR;
[ PrintRank; "."; ];
#Endif;

#Ifndef ParseNoun;
! Constant Make__PN;
! #Endif;
! #Ifdef Make__PN;
[ ParseNoun obj; obj = obj; return -1; ];
#Endif;

#Default Story 0;
#Default Headline 0;

#Ifdef INFIX;
#Include "infix";
#Endif;

! ==============================================================================

Constant LIBRARY_GRAMMAR;       ! for dependency checking

! ==============================================================================

