!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.08.31 ORChooseObjects	[Z, GLULX] [REMOVED]
!   -----------------------------------------------------------------------------------
! NOTE: This module has been retired as is no longer considered to be part of the 
! ORLibrary proper. It has been replaced with the OREntryPoints.h module.
!   -----------------------------------------------------------------------------------
! This is an implementation of the the ORRoutineList class to implement multiple
! ChooseObjects() routines. Additionally, this implements ChooseObjects at an object
! level, that is each object can specify their own ChooseObjects routine.  The return 
! value of which will overrun the normal ChooseObjects() routine(s).
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep:	ORRoutinesList
!--------------------------------------------------------------------------------------
! This module adds ChooseObjects functionality in two ways:
! 1)This module leverages the ORRoutineList class to allow multiple definitions of 
! ChooseObjects to be defined and peacefully coexist.
! To leverage this, simply define the new ChooseObjects routine (named something else):
!
!	[myChooseObj obj code;
!		!--do choose object stuff here...
!	];
!
! and register it with the ORChooseObjects object in the begining of the game like so:
!
!	ORChooseObjects.add_routine(myChooseObj);
!
! 2)This module also checks to see if the object in question supplies a chooseobjects 
! property.  If so, that is called first and the other ChooseObjects routines are called
! only if the object level one has chosen not to return a value.
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORChooseObjects";					!Constant USE_ORChooseObjects; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORChooseObjects; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.01.01	Initial Creation
! 2002.02.26	Fit to new template.
! 2002.04.03	modified faulty WORDSIZE definition.
! 2002.05.14	modified faulty run mode.
! 2002.05.22	Added the ability for an object to specify its own chooseobjects property.
! 2002.08.31	retired module.
!--------------------------------------------------------------------------------------
#ifdef USE_ORChooseObjects;message "          Processing library extension ORChooseObjects...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORRoutinesList; Constant USE_ORRoutinesList; message "          ****Forcing inclusion of ORRoutinesList****"; #include "ORRoutinesList"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORChooseObjects_DONEREPLACE; constant ORChooseObjects_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORChooseObjects_DONEMESSAGE; constant ORChooseObjects_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORChooseObjects requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORChooseObjects_DONECODE;constant ORChooseObjects_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	ORRoutinesList ORChooseObjects;
	[ChooseObjects obj code retval;
		if(obj provides chooseobject) retval=obj.chooseobject(code);
		if(retval==0) retval=ORChooseObjects.run_until_not(0,obj,code);
		return retval;
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORChooseObjects_DONEGRAMMAR; constant ORChooseObjects_DONEGRAMMAR; #ifdef ORChooseObjects_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;