/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.encoding;

import java.util.ArrayList;
import java.util.Iterator;
import org.zmpp.encoding.ZsciiString;
import org.zmpp.encoding.ZsciiStringBuilder;

public class ZsciiStringTokenizer {
    private Iterator<ZsciiString> iterator;

    public ZsciiStringTokenizer(ZsciiString zsciiString, ZsciiString zsciiString2) {
        this.tokenize(zsciiString, zsciiString2);
    }

    public boolean hasMoreTokens() {
        return this.iterator.hasNext();
    }

    public ZsciiString nextToken() {
        return this.iterator.next();
    }

    private void tokenize(ZsciiString zsciiString, ZsciiString zsciiString2) {
        ArrayList<ZsciiString> arrayList = new ArrayList<ZsciiString>();
        int n = zsciiString.length();
        ZsciiStringBuilder zsciiStringBuilder = new ZsciiStringBuilder();
        for (int i = 0; i < n; ++i) {
            short s = zsciiString.charAt(i);
            if (ZsciiStringTokenizer.isDelimiter(s, zsciiString2)) {
                if (zsciiStringBuilder.length() > 0) {
                    arrayList.add(zsciiStringBuilder.toZsciiString());
                    zsciiStringBuilder = new ZsciiStringBuilder();
                }
                arrayList.add(new ZsciiString(new short[]{s}));
                continue;
            }
            zsciiStringBuilder.append(s);
        }
        if (zsciiStringBuilder.length() > 0) {
            arrayList.add(zsciiStringBuilder.toZsciiString());
        }
        this.iterator = arrayList.iterator();
    }

    private static boolean isDelimiter(short s, ZsciiString zsciiString) {
        int n = zsciiString.length();
        for (int i = 0; i < n; ++i) {
            if (s != zsciiString.charAt(i)) continue;
            return true;
        }
        return false;
    }
}

