/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.encoding;

import org.zmpp.encoding.AlphabetElement;
import org.zmpp.encoding.AlphabetTable;
import org.zmpp.encoding.ZCharTranslator;

public class DefaultZCharTranslator
implements Cloneable,
ZCharTranslator {
    private AlphabetTable alphabetTable;
    private AlphabetTable.Alphabet currentAlphabet;
    private AlphabetTable.Alphabet lockAlphabet;
    private boolean shiftLock;

    public DefaultZCharTranslator(AlphabetTable alphabetTable) {
        this.alphabetTable = alphabetTable;
        this.reset();
    }

    public final void reset() {
        this.currentAlphabet = AlphabetTable.Alphabet.A0;
        this.lockAlphabet = null;
        this.shiftLock = false;
    }

    public void resetToLastAlphabet() {
        if (this.lockAlphabet == null) {
            this.currentAlphabet = AlphabetTable.Alphabet.A0;
        } else {
            this.currentAlphabet = this.lockAlphabet;
            this.shiftLock = true;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultZCharTranslator defaultZCharTranslator = null;
        defaultZCharTranslator = (DefaultZCharTranslator)super.clone();
        defaultZCharTranslator.reset();
        return defaultZCharTranslator;
    }

    public AlphabetTable.Alphabet getCurrentAlphabet() {
        return this.currentAlphabet;
    }

    public char translate(short s) {
        char c;
        if (this.shift(s)) {
            return '\u0000';
        }
        if (DefaultZCharTranslator.isInAlphabetRange(s)) {
            switch (this.currentAlphabet) {
                case A0: {
                    c = (char)this.alphabetTable.getA0Char((byte)s);
                    break;
                }
                case A1: {
                    c = (char)this.alphabetTable.getA1Char((byte)s);
                    break;
                }
                default: {
                    c = (char)this.alphabetTable.getA2Char((byte)s);
                    break;
                }
            }
        } else {
            c = '?';
        }
        if (!this.shiftLock) {
            this.resetToLastAlphabet();
        }
        return c;
    }

    public boolean willEscapeA2(short s) {
        return this.currentAlphabet == AlphabetTable.Alphabet.A2 && s == 6;
    }

    public boolean isAbbreviation(short s) {
        return this.alphabetTable.isAbbreviation(s);
    }

    public AlphabetElement getAlphabetElementFor(short s) {
        if (s == 10) {
            return new AlphabetElement(AlphabetTable.Alphabet.A2, 7);
        }
        AlphabetTable.Alphabet alphabet = null;
        short s2 = this.alphabetTable.getA0CharCode(s);
        if (s2 >= 0) {
            alphabet = AlphabetTable.Alphabet.A0;
        } else {
            s2 = this.alphabetTable.getA1CharCode(s);
            if (s2 >= 0) {
                alphabet = AlphabetTable.Alphabet.A1;
            } else {
                s2 = this.alphabetTable.getA2CharCode(s);
                if (s2 >= 0) {
                    alphabet = AlphabetTable.Alphabet.A2;
                }
            }
        }
        if (alphabet == null) {
            s2 = s;
        }
        return new AlphabetElement(alphabet, s2);
    }

    private static boolean isInAlphabetRange(short s) {
        return 0 <= s && s <= 31;
    }

    private boolean shift(short s) {
        if (this.alphabetTable.isShift(s)) {
            this.currentAlphabet = this.shiftFrom(this.currentAlphabet, s);
            if (this.alphabetTable.isShiftLock(s)) {
                this.lockAlphabet = this.currentAlphabet;
            }
            return true;
        }
        return false;
    }

    private AlphabetTable.Alphabet shiftFrom(AlphabetTable.Alphabet alphabet, short s) {
        AlphabetTable.Alphabet alphabet2 = null;
        if (this.alphabetTable.isShift1(s)) {
            if (alphabet == AlphabetTable.Alphabet.A0) {
                alphabet2 = AlphabetTable.Alphabet.A1;
            } else if (alphabet == AlphabetTable.Alphabet.A1) {
                alphabet2 = AlphabetTable.Alphabet.A2;
            } else if (alphabet == AlphabetTable.Alphabet.A2) {
                alphabet2 = AlphabetTable.Alphabet.A0;
            }
        } else if (this.alphabetTable.isShift2(s)) {
            if (alphabet == AlphabetTable.Alphabet.A0) {
                alphabet2 = AlphabetTable.Alphabet.A2;
            } else if (alphabet == AlphabetTable.Alphabet.A1) {
                alphabet2 = AlphabetTable.Alphabet.A0;
            } else if (alphabet == AlphabetTable.Alphabet.A2) {
                alphabet2 = AlphabetTable.Alphabet.A1;
            }
        } else {
            alphabet2 = alphabet;
        }
        this.shiftLock = this.alphabetTable.isShiftLock(s);
        return alphabet2;
    }
}

