/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.media;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.zmpp.media.SoundEffect;
import org.zmpp.media.SoundStopListener;

public class DefaultSoundEffect
implements SoundEffect,
LineListener {
    public static final int MAX_VOLUME = 64;
    private Clip clip;
    private List<SoundStopListener> listeners;

    public DefaultSoundEffect(Clip clip) {
        this.clip = clip;
        this.listeners = new ArrayList<SoundStopListener>();
        clip.addLineListener(this);
    }

    public void play(int n, int n2) {
        this.setVolume(n2);
        if (n == 1) {
            this.clip.start();
        } else {
            this.clip.loop(n - 1);
        }
    }

    private void setVolume(int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 = 64;
        }
        float f = 0.0f;
        FloatControl floatControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        if (n2 == 0) {
            f = floatControl.getMinimum();
        } else if (n2 < 64) {
            f = (float)(Math.log10(64 - n2) * 13.0);
        }
        floatControl.setValue(-f);
    }

    public void stop() {
        this.clip.stop();
    }

    public void addSoundStopListener(SoundStopListener soundStopListener) {
        this.listeners.add(soundStopListener);
    }

    public void removeSoundStopListener(SoundStopListener soundStopListener) {
        this.listeners.remove(soundStopListener);
    }

    public void update(LineEvent lineEvent) {
        if (lineEvent.getType() == LineEvent.Type.STOP) {
            this.notifySoundStopped();
        }
    }

    private void notifySoundStopped() {
        for (SoundStopListener soundStopListener : this.listeners) {
            soundStopListener.soundStopped(this);
        }
    }
}

