"Flight of the Hummingbird" by "Michael Martin"

The release number is 2.
The story headline is "An Interactive Costumed Caper".
The story genre is "Science Fiction".
The story description is "Dr. Sinister is at it again! The Concordance of Powered Response isn't entirely clear on what it is he's planning, but it's big and it's based in his island fortress. This is clearly a task for one of the world's mightiest champions!

Unfortunately, they've had to send you instead."

Use American dialect, manual pronouns, the serial comma, authorial modesty, and full-length room descriptions.
Use no deprecated features.[* If you compile this on your own, it may be necessary to modify the extensions to not use deprecated features. At the time of the comp release, for instance, David Fisher's Default Messages still used forbidden phrasings.]
[Use memory economy.][* This use option is necessary during development, because we're riding the ragged edge of the Z-Code barrier here. However, we disable it for full releases as a courtesy to people disassembling it for hints.]
Include Default Messages by David Fisher.
Include Plurality by Emily Short.
Include Reactable Quips by Michael Martin.

Release along with cover art, the source text, the library card, an interpreter and a website.

[This source code, overall, is available under the Creative Commons Attribution-NonCommercial license. If you wish to excerpt components of it that do not directly generate story text, you may do so under the terms of the Creative Commons Attribution license. In short, don't sell fanfic, but if you see some mechanics you like, feel free to loot them, just give credit.]

Book I - New Mechanics

Part 1 - The Player Character

The description of the player is "You are The Hummingbird. Not really the kind of totemic resonance that lets you play in the [italic type]really[roman type] big leagues, but you've managed a bit of recognition, and a lot of the other heroes give you credit for coming by your powers the hard way.[paragraph break]Your Hummingbird Suit lets you, when suitably charged up, flap your arms fast enough to actually maintain flight. You've got to have a lot of energy available to do that, of course, but you can still manage it.[paragraph break]You're particularly proud of the fact that unlike most of your heroic comrades-in-arms, you have a [italic type]proper excuse[roman type] for your ridiculously overdeveloped pectoral muscles[if yourself is flying].[paragraph break]You cut a fine figure, defying gravity with your mighty wings[end if]."

Understand "hummingbird" or "suit" or "wing" or "wings" as yourself.[* Truly, clothes make the man.]
Before wearing yourself, say "You're already wearing the Hummingbird suit." instead.
Before taking or dropping or taking off yourself, say "Those wings aren't for show; there's no way you're taking this suit off until you get back home." instead. Before cutting yourself, say "You're not about to clip your [italic type]own[roman type] wings." instead. Understand the command "clip" as "cut".

Yourself has a number called height. The height of yourself is 0.
Yourself has a number called energy. The energy of yourself is 0.
A room has a number called height. The height of a room is usually 0.
A room has a number called maximum height. The maximum height of a room is usually 0.
A room has a text called the too high rejection. The too high rejection of a room is usually "There isn't room to go any further up."

Yourself is either grounded, flying, or plummeting. Yourself is grounded.

Carry out going (this is the normalize heights rule):
	if yourself is grounded, now the height of yourself is the height of the location;
	if the height of yourself is less than the height of the location, now the height of yourself is the height of the location;
	if the height of yourself is greater than the maximum height of the location, now the height of yourself is the maximum height of the location.

[The Hummingbelt is our carryall. We have a lot of stuff that nominally shouldn't hang well from a belt. We hang a lampshade on it if necessary, but to do so we need to know which items are unreasonable to be kept on our belt.]
A thing can be improbable. A thing is seldom improbable.

The HummingBelt is worn. The HummingBelt is a player's holdall. The description is "This is a masterpiece of engineering, built to your specifications. It lets you carry an enormous amount of stuff without unbalancing your flight at all[if the HummingBelt encloses an improbable thing].[paragraph break]No, really, even [the random improbable thing enclosed by the HummingBelt][end if]." The indefinite article is "the". Understand "belt" or "humming belt" or "pouch" or "pouches" as the HummingBelt. The HummingBelt is not openable. Check taking off the HummingBelt: say "This is a critical component of your costume. You can't part with it." instead.

[Starting in 6xxx of I7, examining containers automatically lists their contents under all circumstances. We don't want this, so we put in an abort.]
Carry out examining the HummingBelt (this is the bypass container rule): rule succeeds.
The bypass container rule is listed before the examine containers rule in the carry out examining rules.
The bypass container rule is listed after the standard examining rule in the carry out examining rules.

Does the player mean doing something with the HummingBelt: it is very unlikely.[* Seriously, the parser seems to want to make this a first resort for everything.]

In the HummingBelt is an energy drink. The description of the energy drink is "This drink is an incredibly powerful concoction of sugar and electrolytes. It is not much of an exaggeration to say that it is the source of all your power. Given the energy contained within it, the properties of your suit, and your superhuman pectorals, you can fly and even hover under your own power.[paragraph break]You only need a small amount to activate your powers, so this canteen has more than enough to keep you supplied for the duration of the mission." Understand "sugar" or "sports" or "sugar" or "water" or "fluid" or "canteen" or "flask" or "bottle" as the energy drink.

Before dropping the energy drink, say "Drop the source of all your power? I think not!" instead.
Check inserting the energy drink into something (called the receptacle):
	if the receptacle is not the HummingBelt, say "Your power source must be ever ready. If you aren't carrying it, it must be stowed in the HummingBelt." instead.

Understand "stow [other things] in/inside/into [something]" as inserting it into.
Understand "stow [things]" as inserting it into.
Rule for supplying a missing second noun when inserting: now the second noun is the HummingBelt.

Check tasting the energy drink: say "It's scientifically engineered to have an acceptable taste, but it's still rather cloying. That said, you dare not taste it unless you intend to drink enough to take wing. It's really that powerful." instead.

Before drinking the energy drink when yourself is flying (this is the PowerThirst[* I can name my rules after ill-advised YouTube videos if I want.] rule):
	now flight-failure is true;
	say "You're already too energetic for mundane activity; you won't be able to recharge until your current surge is fully spent.";
	stop the action;

The PowerThirst rule is listed before the flying occupies your hands rule in the before rules.

[Takeoff is basically instantaneous if you're carrying only the energy drink. Otherwise you may need a turn to draw the energy drink and another turn to stow everything else.]
Before drinking the energy drink (this is the basic takeoff rule):
	now flight prep active is true;
	if the energy drink is not carried:
		say "(first taking the energy drink)[command clarification break]";
		silently try taking the energy drink;
		follow the turn sequence rules;
		if the energy drink is not carried, stop;
	let done-stow be false; [This tracks whether we've charged for stowing items or not yet.]
	while more than one thing is carried by yourself:
		let the dross be a random thing carried by yourself;
		if the dross is not the energy drink:
			say "(first stowing [the dross])[command clarification break]";
			silently try inserting the dross into the HummingBelt;
			if done-stow is false:
				follow the turn sequence rules;
				now done-stow is true;
			if the dross is carried, stop.
	

The basic takeoff rule is listed after the flying occupies your hands rule in the before rules.

Instead of drinking the energy drink:
	now the drink is in the HummingBelt;
	now the energy of yourself is 6;
	if yourself is plummeting and the height of yourself is greater than the height of the location:
		decrease the height of the player by 1;
	if yourself is plummeting:
		say "[one of]You frantically refuel as you fall earthwards. After a few sips you've regained enough power to renew your flapping and stay aloft[or]You perform another mid-air refueling and regain your flight capability[or]You recharge and renew your flight[stopping].";
	otherwise:
		say "[one of]You take a quick swig of your mighty energy drink and are charged with unbelievable energy. You quickly re-stow the drink and begin to flap your arms with all your might[or]You take another sip of your energy drink and are fully recharged. You flap your arms with all your power and again defy gravity[or]You take a drink, and take wing, once again[or]You recharge and start flying[stopping].";
	now yourself is flying;
	unless the achievement "taking flight for the first time" is scored:
		say "[line break][bracket]Now that you've charged up, you may start or stop flying with FLY or LAND. You may change your altitude with UP and DOWN as usual.[close bracket][paragraph break][bracket]Your altitude will be marked in the status line at the top of the screen[if status-line-free play is true], and in the main text with brackets after each turn. If you would rather restrict this information to the status line, keeping the main text less cluttered, the command STATUS OFF will do so[otherwise]. If you are using a restricted interpreter that cannot render status lines, the command STATUS ON will cause this data to also be dumped to the main window every turn that it is relevant[end if].[close bracket][paragraph break]";
		score the achievement with message "taking flight for the first time";
	now flight prep active is false;
	carry out the lifting off from activity with the location.

Understand "drink" as drinking.
Rule for supplying a missing noun when drinking:
	now the noun is the energy drink.

Does the player mean drinking the energy drink: it is likely.
Understand "drink from [something]" or "take sip/drink/swig from [something]" as drinking.

Understand the command "siphon" as "drink".

The block jumping rule is not listed in the check jumping rulebook.

Check an actor jumping (this is the new block jumping rule):
	unless the achievement "taking flight for the first time" is scored:
		say "A little hop like that won't let you take off." instead;
	otherwise:
		say "If you're going to clear obstacles, you'll be doing it with flight, not jumps." instead.

[Seen-sharks is a flag for whether or not we've warned this run about the mutant sharks in the ocean; it's here instead of in the sea code because it's part of the general energy warnings.  Height shift is a flag that tells us if our altitude changed this turn; relative altitude announcements will generally only trigger if this is true so that hovering level with a catwalk won't harass the player about it constantly.]
Seen-sharks is a truth state that varies. Seen-sharks is false.
Height shift is a truth state that varies. Height shift is false.

Every turn when yourself is not grounded (this is the passive flight mechanics rule):
	if yourself is flying:
		decrease the energy of yourself by 1;
		let n be the energy of yourself;
		if n is 3:
			if the location is a sea-room and seen-sharks is false:
				now seen-sharks is true;
				say "Your energy is beginning to flag. Below you, you think you catch sight of a green fin breaking the waves, and some larger things lurking in the deeps.[paragraph break]Looks like the Doctor has been modifying the local sea life. At least it isn't a synthetic plague of poisonous frogs like the last time he made headlines.";
			otherwise:
				say "Your energy is beginning to flag.";
		if n is 2 and the location is a sea-room and seen-sharks is false:
			now seen-sharks is true;
			say "Below you, you think you catch sight of a green fin breaking the waves, and some larger things lurking in the deeps.[paragraph break]Looks like the Doctor has been modifying the local sea life. At least it isn't a synthetic plague of poisonous frogs like the last time he made headlines.";
		if n is 1:
			if the location is a sea-room and seen-sharks is false:
				now seen-sharks is true;
				say "Your energy is about to run out. Below you, you think you catch sight of a green fin breaking the waves, and some larger things lurking in the deeps.[paragraph break]Looks like the Doctor has been modifying the local sea life. At least it isn't a synthetic plague of poisonous frogs like the last time he made headlines.";
			otherwise:
				say "Your energy is about to run out.";
		if n is less than 1:
			carry out the running out of power in activity with the location;
			if the height of yourself is the height of the location:
				carry out the touching down on activity with the location;
			otherwise:
				now yourself is plummeting;
				say "Your energy fails you, and your old nemesis gravity reasserts his dominance.";
	otherwise if yourself is plummeting:
		decrease the height of yourself by 1;
		now height shift is true;
		if the height of the player is greater than the height of the location:
			say "You continue your plummet earthwards.";
		otherwise:
			carry out the crashlanding on activity with the location.

[This was tedious to write.]
Taking is hands-required behavior. Removing from is hands-required behavior. Dropping is hands-required behavior. Putting on is hands-required behavior. Inserting into is hands-required behavior. Eating is hands-required behavior. Looking under is hands-required behavior. Searching is hands-required behavior. Consulting about is hands-required behavior. Locking is hands-required behavior. Unlocking is hands-required behavior. Switching on is hands-required behavior. Switching off is hands-required behavior. Opening is hands-required behavior. Closing is hands-required behavior. Giving to is hands-required behavior. Showing to is hands-required behavior. Waking is hands-required behavior. Throwing at is hands-required behavior. Attacking is hands-required behavior. Touching is hands-required behavior. Waving is hands-required behavior. Pulling is hands-required behavior. Pushing is hands-required behavior. Turning is hands-required behavior. Pushing to is hands-required behavior. Squeezing is hands-required behavior. Burning is hands-required behavior. Cutting is hands-required behavior. Tying to is hands-required behavior. Drinking is hands-required behavior. Swinging is hands-required behavior. Rubbing is hands-required behavior. Setting to is hands-required behavior. Climbing is hands-required behavior. Wearing is hands-required behavior. Taking off is hands-required behavior. 

[As a courtesy to the player, reasonable moves while flying that happen to not work due to the nature of the Hummingbird's powers do not cost energy or time. We use this flag to indicate whether or not we should skip the turn sequence.]
Flight-failure is a truth state that varies. Flight-failure is false.

Before hands-required behavior while yourself is flying (this is the flying occupies your hands rule):
	now flight-failure is true;
	say "[one of]You can't really do that while flapping your arms[or]Your arms are too busy keeping you aloft to let you do that[or]While energized to fly, you can't do much with your arms besides buzz[or]That's not something you can do while powering your flight[at random]." instead.

Before hands-required behavior when the height of the player is not the height of the location (this is the can't reach the ground rule):
	if the noun is not nothing and the player does not enclose the noun:
		now flight-failure is true;
		say "You can't reach it at this height." instead;
	if the second noun is not nothing and the player does not enclose the second noun:
		now flight-failure is true;
		say "You can't reach it at this height." instead. 

[This gets overridden by Before rules when flying through an open ceiling or floor.]
Check going to somewhere while yourself is not grounded (this is the doors are on the ground rule):
	if the location is not an outdoor-room and the height of the player is not the height of the location:
		now flight-failure is true;
		say "You aren't level with the door." instead.

Rule for listing nondescript items of a room when the height of the player is not the height of the location:
	say "Down below, you can see ";
	list the contents of the location, as a sentence, tersely, listing marked items only, and giving brief inventory information;
	say ".".

Instead of waving hands while yourself is flying:
	say "You're waving your arms pretty fast already."

Before going up while yourself is flying (this is the ascent rule):
	if the height of yourself is the maximum height of the location:
		say "[too high rejection of the location][paragraph break]";
	otherwise:
		increase the height of yourself by 1;
		say "Flapping your arms mightily, you ascend.";
		now height shift is true;
	stop the action.

Before going down while yourself is flying (this is the descent rule):
	if the height of yourself is the height of the location:
		try landing;
	otherwise:
		decrease the height of yourself by 1;
		say "You lower yourself down a bit.";
		now height shift is true;
	stop the action.

Instead of going up when yourself is grounded and the room up from the location is not a room:
	say "You're not flying at the moment." instead.

After waiting while yourself is flying, say "You hover in place."

Before going down while yourself is plummeting, say "[one of]Gravity's handling that for you[or]Yep[or]Down - the easiest direction when depowered[or]Yeah, that's about the size of it[at random]." instead.
Before going while yourself is plummeting, say "[one of]Your wings cannot glide; without some more energy, [or]You're out of energy, so [or]Since you've exhausted your energy reserves, [or]You aren't charged, so [or]At the moment, [stopping]the only available direction for travel is down." instead.

Reporting flight status of something is an activity.
After printing the name of the location: 
	if yourself is not grounded begin;
		say " (";
		carry out the reporting flight status activity with the location;
		say ")";
	end if.

To say current altitude:
	let differential be (height of yourself) - (height of location);
	say (25 * differential).

Rule for reporting flight status while yourself is flying:
	if the height of yourself is the height of the location, say "flying";
	otherwise say "[current altitude] feet above the [if the location is an outdoor-room]ground[otherwise]floor[end if]".

Rule for reporting flight status while yourself is plummeting:
	if the height of yourself is the height of the location, say "crashed";
	otherwise say "[current altitude] feet and falling".

[This is the safe-landing activity.]
Touching down on something is an activity.
Rule for touching down on:
	now the player is grounded;
	if the energy of yourself is less than two:
		say "You settle back to earth, your energy exhausted.";
	otherwise:
		say "You force yourself into an early landing[shakes]."

To say shakes:
	say " and then concentrate for a few seconds until the shakes from the excess energy go away[one of]. It's never pleasant to have to do this[or]. It doesn't get easier with time[or][or]. Ugh[stopping]".

[If a room needs to make takeoffs do something special, this is the activity for that.]
Lifting off from something is an activity.
Rule for lifting off from: do nothing.

[Automatic saves at zero energy take place here. The main one in-game is to automatically settle on a catwalk if you power down while level to it.]
Running out of power in something is an activity.
Rule for running out of power in: do nothing.

Fly-verbing is an action applying to nothing. Understand "fly" or "start flying" or "take flight/wing/off" or "flap" or "flap arms/wings" as fly-verbing.

Check fly-verbing:
	unless the achievement "taking flight for the first time" is scored, say "You flap your arms a little, but aren't properly charged up yet." instead.

Check fly-verbing:
	try drinking the energy drink instead.

Landing is an action applying to nothing. Understand "land" or "stop flying/flapping" as landing.

Check landing: if yourself is grounded, say "You aren't flying at the moment." instead.
Check landing: if yourself is plummeting, say "You'll be landing faster than you'd like soon enough, unless you do something!" instead.
Check landing:
	if the height of yourself is not the height of the location:
		now flight-failure is true;
		say "You can't just stop flying in midair like that; the excess energy has to go somewhere, and you'd just plummet, twitching, from the sky." instead.

Carry out landing: carry out the touching down on activity with the location.

[This is almost always fatal, but wouldn't be in a training mode (where a crash becomes a state reset) and doesn't if the 'crash' actually becomes "fall through a hole in the room".]
Crashlanding on something is an activity. Flight prep active is a truth state that varies. Flight prep active is false.
Rule for crashlanding on:
	say "[if flight prep active is true]Your recharge didn't quite have enough altitude to work in; [otherwise]After a long fall with no power, [end if]you slam into the ground at incredible speed. Though you do have superhuman strength, it doesn't translate into resistance to that kind of damage.";
	end the story saying "You have made a good impression".

After printing the player's obituary:
	if yourself is plummeting:
		say "[line break]You seem to have had a flight mishap. These are rather severe; a single UNDO is unlikely to put you in a position where you can continue. Two, however, should usually suffice for a safe landing, and three should guarantee you a survivable option in even the most extreme of circumstances.[no line break]"

This is the refused flight actions is instantaneous rule:
	if flight-failure is true:
		now flight-failure is false;
		rule succeeds.

The refused flight actions is instantaneous rule is listed before the every turn stage rule in the turn sequence rules.

Part 2 - The world model

Before going through a closed door (called the obstruction) (this is the automatic door rule):
	say "(first opening [the obstruction])[command clarification break]";
	silently try opening the obstruction;
	if the obstruction is closed, stop the action.

The automatic door rule is listed after the ascent rule in the before rules.
The automatic door rule is listed after the descent rule in the before rules.

Instead of pulling a door (called the portal), try opening the portal.
Instead of pushing a door (called the portal), try opening the portal.

Rule for deciding whether all includes scenery: it does not.
Rule for deciding whether all includes people: it does not.
Rule for deciding whether all includes backdrops: it does not.
Rule for deciding whether all includes something enclosed by the Hummingbelt when taking: it does not.[* TAKE ALL FROM BELT still works here, because that action is "removing it from", not "taking".]

Does the player mean entering something enterable: it is likely.

A thing can be harmless or dangerous. A thing is usually harmless. [Dangerous items can be used as weapons with ATTACK X WITH Y.]
A thing can be disposable or critical. A thing is usually disposable. The Hummingbelt is critical. The energy drink is critical. Yourself is critical. [Critical items are necessary to complete the plot, or sufficiently so that the Hummingbird isn't willing to mess with them to see how destructive weapons systems are.]
A thing can be inflammable. A thing is usually not inflammable.[* Flammable, or inflammable? Can't remember. Doesn't matter. --Mordin, Mass Effect 2]

Attacking it with is an action applying to two things. Understand "attack [something] with [something preferably held]" as attacking it with. Attacking with is hands-required behavior.

Before attacking something with something (called the weapon):
	if the weapon is not carried:
		say "(first taking [the weapon])[command clarification break]";
		silently try taking the weapon;
		if the weapon is not carried, stop the action.

Check attacking something with a harmless thing:
	say "[The second noun] [if the second noun is plural-named]don't[otherwise]doesn't[end if] make a very good weapon." instead.
Check attacking it with: try attacking the noun instead.

Does the player mean attacking something with a harmless thing: it is unlikely.

[Keys are for people who aren't superheroes or environment-suited scientists. Most doors can have their locks destroyed. These rules cover those situations generally.]
A door can be free-swinging, stuck, or forced. A door is usually free-swinging.
Check opening a closed stuck door:
	say "It's stuck; you don't seem able to pry it open with your bare hands." instead.
Check attacking a stuck door:
	say "You punch [the noun], but your mighty blow does not free it." instead.
Check attacking a stuck door with:
	say "You smite [the noun] with [the second noun], to no great effect." instead.

Lockforcing it with is an action applying to two things. Understand "force [something] with [something preferably held]" as lockforcing it with. Understand "force open [something] with [something preferably held]" as lockforcing it with. Understand "force [something] open with [something preferably held]" as lockforcing it with. Understand "force [something]" as lockforcing it with. Understand "force open [something]" as lockforcing it with. Understand "force [something] open" as lockforcing it with.
Understand the commands "pry" or "prise" or "lever" as "force".

Before lockforcing something with something (called the improvised key):
	if the improvised key is not carried:
		say "(first taking [the improvised key])[command clarification break]";
		silently try taking the improvised key;
		if the improvised key is not carried, stop the action.

The first check lockforcing it with (this is the can only force closed things rule): if the noun provides the property open and the noun is open, say "[The noun] is already open." instead.
Check lockforcing a forced door with: say "You've already forced it." instead.
Check lockforcing an unlocked free-swinging door with: say "[The noun] doesn't appear to need that kind of force." instead.
Check lockforcing a person with: say "That sounds vaguely unsanitary." instead.
Check lockforcing it with (this is the check non-door forcability rule): 
	If the noun is not a door begin;
		if the noun does not provide the property lockable or the noun is not lockable, say "[The noun] has no obvious lock to force." instead;
		if the noun is unlocked, say "[The noun] is already unlocked." instead;
	end if.

Carry out lockforcing it with:
	if the noun provides the property open, now the noun is open;
	if the noun provides the property lockable, now the noun is unlocked;
	if the noun is a door, now the noun is forced.

Report lockforcing it with:
	say "You make short work of the lock on [the noun] with [the second noun], and open it."

Check locking a forced door with: say "The lock on [the noun] has been destroyed." instead.

Lockforcing with is hands-required behavior.

Understand "force lock" or "attack lock" or "force the lock" or "attack the lock" as lockforcing it with.

[The natural way of handling a nounless FORCE LOCK is trickier than it looks. We basically allow it only when there's only one locked thing in the room.]
Rule for supplying a missing noun when lockforcing:
	let D be the number of locked doors in the location;
	let C be the number of locked containers in the location;
	let T be D plus C;
	if T is 1 begin;
		if D is 1, now the noun is a random locked door in the location;
		otherwise now the noun is a random locked container in the location;
	otherwise if T is 0;
		say "There isn't any lock here in need of forcing.";
	otherwise;
		say "You will have to be more specific about what you want to force.";
	end if.
	
The crowbar is a dangerous improbable thing. The description is "This is a short length of metal with a thin, bent tip. You salvaged it from the destroyed building on Shalestorm Shingle." Understand "bar" or "crow bar" or "metal" or "piece of metal" or "piece" as the crowbar.

Rule for supplying a missing second noun when lockforcing with:
	if the player can see the crowbar, now the second noun is the crowbar;
	otherwise say "You don't have anything suitable to force [the noun] with."

Instead of unlocking something with the crowbar, try lockforcing the noun with the crowbar.

Does the player mean lockforcing a door with: It is likely.
Does the player mean lockforcing a closed door with: It is very likely.

Check lockforcing it with (this is the only the crowbar can force locks rule): if the second noun is not the crowbar, say "You can't really wedge [the second noun] anywhere useful in [the noun]."

Instead of attacking a door with the crowbar, try lockforcing the noun with the second noun.

Understand "wave arms" or "wave hands" as waving hands.

[The parser is too persnickety about these, and people like to SNUGGLE BLANKETS or KISS GROUND.]
Understand "hug [something]" or "kiss [something]" as kissing.
Check kissing (this is the should only kiss animate objects rule):
	if the noun is not a person, say "You don't typically express your affection for objects that way." instead.

The block kissing rule is listed last in the check kissing rules.

[Some useful synonyms, utility verbs, and togglers.]
Understand "pull [something] [direction]" or "pull [something] to [direction]" as pushing it to.

Moving it relatively is an action applying to one thing. Understand "push [something] left/right/forward/back" or "pull [something] left/right/forward/back" or "move [something] left/right/forward/back" as moving it relatively. Check moving relatively: say "[bracket]It's never useful to give relative directions like that.[close bracket][line break]".

Understand "use [text]" as a mistake ("[bracket]USE is an overly generic verb; you must supply a more specific verb.[close bracket]"). [If you want a list of commonly available rules, check the beginner's guide by typing HELP.]

Understand "activate [something]" or "arm [something]" or "start [something]" as switching on. Understand "deactivate [something]" or "disarm [something]" or "park [something]" or "stop [something]" as switching off.

Understand "flip [something switched off]" as switching on. Understand "flip [something switched on]" as switching off. Understand "flip [something]" as switching on. Understand the command "toggle" as "flip".

Understand "switch [something switched off]" as switching on. Understand "switch [something switched on]" as switching off.

Instead of pushing or pulling a device (called the toggle):
	if the toggle is switched off:
		try switching on the toggle;
	otherwise:
		try switching off the toggle.

[Inform default is for LEAVE to be synonymous with GO. This is horrifically wrong, as it means, for instance, LEAVE TRUCK translates to entering it.]
Understand the command "leave" as something new. Understand "leave" as exiting.

Understand the command "spin" as "turn".[* It would be nice if SPIN could also be short for SPINWARDS but that really doesn't get to happen. Oh well.]

Understand "look behind [something]" as searching.
Understand "search inside/in/into/through [something]" as searching.

[Some silliness.]
Yelling is an action applying to nothing. Understand "yell" or "scream" as yelling.

Check yelling when yourself is plummeting (this is the fall screaming rule):
	if the height of yourself minus one is the height of the location:
		say "Well, nothing else to do at this point.  'AaaaaAAaaaAAAaaAAAAaAAAAA--'[line break]" instead;
	otherwise:
		say "'AaaaaAAaaaAAAaaAAAAaAAAAA---'[paragraph break]Cathartic, but not immediately helpful to your present situation." instead.

Check yelling (this is the block yelling rule):
	say "There is no real need for a cathartic scream at the moment." instead.

Understand "take nap" as sleeping.

[As this is a four-color universe, violence needs to stay clean.]

Understand the commands "murder", "kill", and "torture" as something new.

Understand "kill [something switched on]" as switching off. Understand "kill [switched off device]" as switching off.[* As a rule, heroes are OK with killing the lights.]

Understand "murder [text]" or "kill [text]" or "torture [text]" as a mistake ("Heroes do not lower themselves to that sort of violence.").

[But a few nods to plausibility.]

Understand "kick [text]" as a mistake ("You've really spent most of your career focusing on your upper body strength. If you're going to hit things, you should stick to punches or hand weapons.").

[POUR and EMPTY stopped being standard verbs in I7. People still want them, but we really don't want to deal with it, so we do redirection.]

Understand the command "pour" as "put".

Emptying is an action applying to one thing. Understand "pour [something] on/onto ground/floor" as emptying. Understand "empty [something]" or "empty out [something]" as emptying.

Check emptying a container (this is the default block emptying containers rule):
	if the number of things enclosed by the noun is zero:
		say "[The noun] is already empty." instead;
	otherwise:
		let N be an indexed text;
		let N be the printed name of the noun in upper case;
		say "[bracket]To do something en masse to the contents of a container like [the noun], use commands like TAKE ALL FROM [N].[close bracket][line break]" instead.

Check emptying (this is the default block emptying rule):
	say "That's not something you can empty." instead.

Instead of emptying the energy drink, say "You need this to enable your powers! You can't just waste it like that."

[And a little fun.]

Understand the command "smite" as "attack".

Check waving a thing (called the garment) worn by yourself:
	say "You can't wave [the garment] while wearing [it-them]." instead.

Part 3 - New default messages

Table of custom library messages (continued)
message id	message text
LibMsg <empty line>	"[bracket]No input found. Please type a command and press ENTER.[close bracket][line break]"
LibMsg <oops failed>	"[bracket]There wasn't anything in the previous command that could be corrected with OOPS.[close bracket][line break]"
LibMsg <oops too many arguments>	"[bracket]OOPS can only correct a single word[close bracket][line break]"
LibMsg <oops no arguments>	"[bracket]OOPS is actually a command for fixing typos in nouns; if LOOK AT FORG failed, for instance, you could maybe correct it to LOOK AT FROG by typing OOPS FROG[close bracket][line break]"
LibMsg <cannot do again>	"[bracket]AGAIN cannot repeat that action.[close bracket][line break]"
LibMsg <again usage>	"[bracket]To repeat a command like FROG, JUMP, just say AGAIN, not FROG, AGAIN.[close bracket][line break]"
LibMsg <command not understood>	"[bracket]The parser couldn't handle that sentence. Try rephrasing it, or use a different verb.[close bracket][line break]"
LibMsg <command badly ended>	"[bracket]The parser couldn't understand the way that finished.[close bracket][line break]"
LibMsg <command incomplete>	"[bracket]You seem to have said too little![close bracket][line break]"
LibMsg <command cut short>	"[bracket]Since something dramatic has happened, your list of commands has been cut short.[close bracket][line break]"
LibMsg <number not understood>	"[bracket]The parser expected a number there, but didn't find one.[close bracket][line break]"
LibMsg <cannot begin at comma>	"[bracket]You can't begin with a comma.[close bracket][line break]"
LibMsg <undo failed>	"[bracket]You've reached the limit of your interpreter's undo buffer; you cannot rewind past this point.[close bracket][line break]"
LibMsg <cannot undo twice in a row>	"[bracket]Your interpreter doesn't support multiple undo. FLIGHT OF THE HUMMINGBIRD expects this capability; your play experience may suffer.[close bracket][line break]"
LibMsg <extra words before comma>	"[bracket]That looked like an attempt to talk to someone; conversation doesn't work that way in this game.[close bracket][line break]"
LibMsg <something more substantial needed>	"[bracket]You can't do that to a direction.[close bracket][line break]"
LibMsg <Restart failed>    	"[bracket]Restart failed.[close bracket][line break]"
LibMsg <Restore failed>    	"[bracket]Restore failed.[close bracket][line break]"
LibMsg <Restore succeeded>    	"[bracket]Restore succeeded.[close bracket][line break]"
LibMsg <Save failed>    	"[bracket]Save failed.[close bracket][line break]"
LibMsg <Save succeeded>    	"[bracket]Save succeeded.[close bracket][line break]"
LibMsg <Verify succeeded>    	"[bracket]The game file has verified as intact.[close bracket][line break]"
LibMsg <Verify failed>    	"[bracket]The game file did not verify as intact, and may be corrupt.[close bracket][line break]"
LibMsg <score notification turned on>    	"[bracket]Score notification on.[close bracket][line break]"
LibMsg <score notification turned off>    	"[bracket]Score notification off.[close bracket][line break]"
LibMsg <transcript already on>    	"[bracket]Transcripting is already on.[close bracket][line break]"
LibMsg <transcript already off>    	"[bracket]Transcripting is already off.[close bracket][line break]"
LibMsg <transcript failed>    	"[bracket]Attempt to begin transcript failed.[close bracket][line break]"
LibMsg <end transcript failed>    	"[bracket]Attempt to end transcript failed.[close bracket][line break]"
LibMsg <block drinking>    	"You can't drink [the main object].[line break]"
LibMsg <block tasting>    	"That sounds vaguely unsanitary.[line break]"
LibMsg <block saying yes>    	"[bracket]Yes/no questions are handled by the conversation system.[close bracket][line break]"
LibMsg <block saying no>    	"[bracket]Yes/no questions are handled by the conversation system.[close bracket][line break]"
LibMsg <block saying sorry>    	"Not as sorry as Doc Sinister's going to be.[line break]"
LibMsg <block swearing obscenely>    	"Tsk. You're safely away from innocent eyes, but what would the children think?[line break]"
LibMsg <block attacking>    	"Violence definitely has its uses, but that isn't one of them.[line break]"
LibMsg <report player waving things>	"You give a jaunty wave with [the main object].[line break]"
LibMsg <block waving hands>    	"Your legions of adoring fans seem entirely absent. There really [italic type]is[roman type] no justice in the world but that which we make.[line break]"
LibMsg <block throwing at>    	"That wouldn't do any good.[line break]"
LibMsg <throw at inanimate object>    	"That won't accomplish anything.[line break]"
LibMsg <block answering>    	"As a hero, you prefer action to talk unless there's no other choice.[line break]"
LibMsg <block asking>    	"As a hero, you prefer action to talk unless there's no other choice.[line break]"
LibMsg <block buying>    	"Justice is not for sale![line break]"
LibMsg <block kissing>    	"This isn't really the time.[line break]"
LibMsg <block singing>    	"You haven't come up with a properly dramatic theme tune yet.[line break]"
LibMsg <block telling>    	"As a hero, you prefer action to talk unless there's no other choice.[line break]"
LibMsg <block waking up>    	"You're already awake.[line break]"
LibMsg <block thinking>    	"You ponder your next move.[line break]"

Table of Quip Texts (continued)
quip	quiptext
q_selftalk	"You try to leave the endless internal monologues to the grimmer heroes."

The default tell quip of yourself is q_selftalk. The default ask quip of yourself is q_selftalk.

Part 4 - Hands-free Challenge

Hands-free challenge is a truth state that varies. Hands-free challenge is true.

To decide if (O - an object) is hands-free-violating:
	if O is not a thing, decide no;
	if O is the HummingBelt, decide no;
	if O is the energy drink, decide no;
	if O is held by the player, decide yes;
	decide no.

Before (this is the hands-free enforcement rule):
	if the actor part of the current action is not the player, continue the action;
	if the action name part of the current action is the examining action, continue the action;
	if the current action involves the HummingBelt, continue the action;
	if the noun part of the current action is hands-free-violating or the second noun part of the current action is hands-free-violating:
		now hands-free challenge is false.

Section Hands-free Monitor - not for release

Hands-free-ness is a scene. Hands-free-ness begins when play begins. Hands-free-ness ends when hands-free challenge is false.

When hands-free-ness ends:
	say "[bracket]The SELF-RELIANCE challenge has just been failed.[close bracket][line break]".

Book II - The Scenario

Part 1 - Infiltration

Chapter 1 - The opening

When play begins, say "December 31st, 2014.[paragraph break]Dr. Sinister is at it again! The Concordance of Powered Response isn't entirely clear on what it is he's planning, but it's big and it's based in his island fortress. This is clearly a task for one of the world's mightiest champions![paragraph break]Unfortunately, they've had to send you instead; the world's mightiest champions have [italic type]other[roman type] emergencies to deal with. New Year's Eve is always rough.[paragraph break]Regardless, this looks by-the-book so far. The containment fields have been put in place. Now all you have to do is get over to his island base, infiltrate it, defeat him, and bring him in."

When play begins, the escape launch happens in 10 turns from now.

At the time when the escape launch happens:
	activate the Table of Rocket Panic hints;
	say "An enormous rumbling noise comes from the tower on the island. [if yourself is flying]You struggle to stay aloft[otherwise]You cover your eyes[end if] as the shockwave hits, and as you recover, you see a rocket streaking up towards the sky.[paragraph break]You think you can hear Dr. Sinister's malicious laughter, but it's surely just a trick of the wind. He's far too far away to be audible.[paragraph break]Great. Well, hopefully you'll still be able to thwart him with what's left in the base."

Chapter 2 - The mainland

The force field is a backdrop.[* Force field on loan from Paragon City Police Department.] The description is "In the interests of containing the forces of villainy, the local authorities have surrounded the area with impenetrable green force walls. It should go down once you get your man." Understand "fields" or "wall" or "walls" or "green" or "impenetrable" or "containment" as the force field. Instead of touching the force field, say "Despite being immaterial, the fields feel like smooth stone." Instead of entering the force field, say "You can't walk through the containment fields; that's why they're called 'containment fields.'"

An outdoor-room is a kind of room. Instead of going nowhere from an outdoor-room when the noun is not up and the noun is not down and the noun is not inside and the noun is not outside, say "[description of the force field][paragraph break]".

The maximum height of an outdoor-room is always 20. The too high rejection of an outdoor-room is always "You're practically a tenth of a mile up. That's more than enough. Really.".

Shalestorm Shingle is an outdoor-room. "City Hall teleported you here to Shalestorm Shingle mainly for the drama of the name. Small rocks and stones litter the ground here, but it dissolves to good clean sand a little ways to the south.[paragraph break]The city's containment force fields wall off the area to the north and east. The great Pacific Ocean stretches out to the west. Across the sea some distance, you can see Dr. Sinister's island fortress."

Sable Strand is an outdoor-room. Sable Strand is south of Shalestorm Shingle. "The rocky beach from the north tapers off a bit; down here, closer to the water, the rocks have been worn down to black sand. To the west is the ocean itself (and beyond that, Sinister's island fortress); the sand gives way to concrete to the south."

Some rocks are a backdrop. The rocks are in Shalestorm Shingle and Sable Strand. Understand "rock" or "stone" or "stones" or "shingle" or "shalestorm" as the rocks. The description is "The north end of the beach is covered in smooth, round, black rocks." Check taking the rocks: say "You don't need any rocks." instead.

Shattered Shack is an outdoor-room. Shattered Shack is south of Sable Strand. "The containment field makes a sharp turn here, blocking travel to the south as well as the east. Metallic wreckage is strewn throughout this corner of the beach. Possibly this is the work of Dr. Sinister on his latest rampage, but you suspect that this is actually what's left of some innocent building torn apart by the creation of the containment field.

The coastline extends to the north, while the Pacific Ocean lies to the west. You can also make out Dr. Sinister's island fortress out at sea."

Concrete is a backdrop. The concrete is in Sable Strand and Shattered Shack. The description is "This concrete slab was laid here as the beach gives way to civilization." Understand "slab" as the concrete.

Black sand is a backdrop. The black sand is in Shalestorm Shingle, Sable Strand, and Shattered Shack. The description is "The sand on this beach is dark and gritty, no doubt ground down from the rocks to the north." Check taking the sand: say "You don't need any sand." instead.

The wreckage is in Shattered Shack. It is scenery. It is ambiguously plural. The description is "It's a pile of metal beams, once an innocent building." Understand "metal" or "beams" or "innocent" or "building" as the wreckage.
Check taking the wreckage: say "While you probably [italic type]could[roman type] take it all, it's not really practical to do so. You could perhaps search through it if you want a suitable piece." instead.
Instead of searching or looking under the wreckage:
	if the crowbar is off-stage:
		say "You select a small, crowbar-like piece of metal, and pick it up.";
		have the parser notice the crowbar;
		now the player carries the crowbar;
	otherwise if the player encloses the crowbar:
		say "You don't find any other metal that suits your needs.";
	otherwise if the location encloses the crowbar:
		say "You've already separated a crowbar-like piece of metal from the general wreckage.";
	otherwise:
		say "You don't immediately find any other metal that suits your needs. If you recall aright, you left your makeshift crowbar in [location of the crowbar]."

Understand "twisted" or "shredded" or "remnants" or "building" or "shattered" or "shack" or "metal" or "pile" or "beam" or "beams" or "metallic" as the wreckage.

The force field is in Shalestorm Shingle, Sable Strand, and Shattered Shack.

The distant tower is a backdrop. The description is "It juts out of the island to the west, probably reaching at least a hundred feet into the air." The distant tower is in Shalestorm Shingle, Sable Strand, and Shattered Shack.  Understand "fortress" or "island fortress" or "island tower" or "Sinister's" or "dr" as the distant tower.

[One danger here is that the name 'Dr. Sinister' will read the period as being the end of a command. So we get rid of that.]
After reading a command:
	let T be indexed text;
	let T be the player's command;
	replace the text "dr." in T with "dr";
	change the text of the player's command to T.

The distant island is a backdrop. The description is "Dr. Sinister has built his base on an island a short ways out to sea. It awaits you to the west." The distant island is in Shalestorm Shingle, Sable Strand, and Shattered Shack. 

Before doing something other than examining with the distant tower, say "It's too far away." instead.
Before doing something other than examining with the distant island, say "It's too far away." instead.

Chapter 3 - Handwritten portions of the ocean

A sea-room is a kind of outdoor-room. A sea-room has a number called an x-coordinate. The x-coordinate of a sea-room is usually 0. The printed name of a sea-room is usually "Above the Ocean". The description of a sea-room is usually "The sea extends in all directions. An island lies [vague distance of (7 - x-coordinate of the location)] to the west, while the main shore is [vague distance of the x-coordinate of the location] to the east."

To say vague distance of (N - a number):
	if N is:
	-- 1: say "just";
	-- 2: say "a bit";
	-- 3: say "off";
	-- 4: say "off";
	-- otherwise: say "a good distance".

Swimming is an action applying to nothing. Understand "swim" or "dive" as swimming. Check swimming: If the location is adjacent to a sea-room, say "Water isn't particularly good for your suit. Besides, Dr. Sinister has an ugly penchant for genetically engineering nasty sea life." instead. Check swimming: say "There isn't any suitable water to swim in here." instead.

Instead of going to a sea-room when the player is grounded, say "Water isn't particularly good for your suit. Besides, Dr. Sinister has an ugly penchant for genetically engineering nasty sea life."

Definition: A room is landlubbing if it is not a sea-room.
Definition: A room is shark-infested if it is a sea-room or it is adjacent to a sea-room.

After going to a sea-room from a landlubbing room:
	say "You fly off the shore and out to sea.";
	continue the action.

After going to a landlubbing room from a sea-room:
	say "Below you, the sea gives way to solid ground once again.";
	continue the action.

Check landing:
	if the location is a sea-room, say "Water isn't particularly good for your suit. Besides, Dr. Sinister has an ugly penchant for genetically engineering nasty sea life." instead.

Some genetically modified sharks are a backdrop. Understand "super-sharks" or "super sharks" or "supersharks" or "fin" or "fins" or "mutant" or "warrior" or "warriors" or "sea warrior" or "sea warriors" as the sharks. The description is "[if seen-sharks is false]Dr. Sinister has a reputation for mutant sea warriors, but you haven't found evidence of any yet[otherwise]You still think you can see some dark shapes below, but no more fins have broken the water[end if]." 

Before throwing something (called the missile) at the sharks (this is the shark attack rule):
	if yourself is flying:
		say "[if seen-sharks is false]You've found no targets yet, and it's not like you can reasonably aim with your arms buzzing like this anyway[otherwise][The missile] wouldn't do much damage after going through that much water, even if you could aim with your arms buzzing like this[end if]." instead;
	otherwise:
		say "[if seen-sharks is false]You've found no targets yet[otherwise][The missile] wouldn't do much damage after going through that much water[end if]." instead.

The shark attack rule is listed before the flying occupies your hands rule in the before rules.

When play begins, move the sharks backdrop to all shark-infested rooms.

Rule for reporting flight status of a sea-room while yourself is flying:
	if the height of yourself is the height of the location, say "skimming the waves";
	otherwise say "[current altitude] feet above the water".

Gaining Altitude is a scene. Gaining Altitude begins when play begins. Gaining Altitude ends when yourself is flying and the height of yourself is greater than the height of the location.

Rule for touching down on a sea-room:
	say "You land in the water with a splash. Your suit doesn't really play well with water, so you are quickly waterlogged.[paragraph break]Fortunately, you're strong enough to still be able to manage a decent breast stroke.[paragraph break]Unfortunately, that's not fast enough to outpace Dr. Sinister's genetically modified sharks[if Gaining Altitude is happening]. Putting some distance between you and the ocean might have given you more time to react[end if]."; 
	end the story saying "Game over, chum".

Rule for crashlanding on a sea-room:
	say "[if flight prep active is false]Several hundred movies and comic books to the contrary, water makes a [italic type]terrible[roman type] cushion for crash landings. Falling that far without a recharge,[otherwise]Your recharge didn't have quite enough altitude to work in, so you hit the water at great speed. At this height[end if] it's only slightly less resilient than concrete, really.[paragraph break]Well, at least that means you don't have to worry about drowning.";
	end the story saying "You are a shooting star".

The ocean below is a backdrop. The description is "The seas look deceptively quiet, but they nevertheless unnerve you." Instead of putting something on the ocean below, try dropping the noun. Instead of inserting something into the ocean below, try dropping the noun. Understand "pacific" or "wave" or "waves" or "water" or "waters" or "sea" or "seas" as the ocean below.

Check dropping something critical in the presence of the ocean below:
	say "You don't want to consign [the noun] to the vasty deep." instead.

After dropping something in the presence of the ocean below:
	remove the noun from play;
	say "The ocean swallows [the noun], never to be seen again."

The ocean shore is a backdrop. The printed name is "ocean". The description is "The seas look deceptively quiet, but they nevertheless unnerve you." Understand "pacific" or "wave" or "waves" or "water" or "waters" or "sea" or "seas" as the ocean shore.

Instead of putting something on the ocean shore when the player encloses the noun:
	silently try dropping the noun;
	if the noun is in the location, say "The waves gently push [the noun] back to shore."

Instead of inserting something into the ocean shore when the player encloses the noun, try putting the noun on the ocean shore.

The ocean shore is in Shalestorm Shingle, Sable Strand, and Shattered Shack. Instead of drinking the ocean shore, say "Norse gods couldn't drink up the sea. You don't have a chance."

Chapter 4 - Autogenerated portions of the ocean

[This section was autogenerated by makesea.py. Ideally, changes to this section should be made by changing and rerunning that script, then pasting the results in here.]

Sea11 is a sea-room. The x-coordinate of Sea11 is 1.
Sea11 is west of Shalestorm Shingle and northwest of Sable Strand.
The force field is in Sea11. The distant tower is in Sea11. The distant island is in Sea11. The ocean below is in Sea11.

Sea12 is a sea-room. The x-coordinate of Sea12 is 1.
Sea12 is southwest of Shalestorm Shingle, south of Sea11, west of Sable Strand, and northwest of Shattered Shack.
The distant tower is in Sea12. The distant island is in Sea12. The ocean below is in Sea12.

Sea13 is a sea-room. The x-coordinate of Sea13 is 1.
Sea13 is southwest of Sable Strand, south of Sea12, and west of Shattered Shack.
The force field is in Sea13. The distant tower is in Sea13. The distant island is in Sea13. The ocean below is in Sea13.

Sea21 is a sea-room. The x-coordinate of Sea21 is 2.
Sea21 is west of Sea11 and northwest of Sea12.
The force field is in Sea21. The distant tower is in Sea21. The distant island is in Sea21. The ocean below is in Sea21.

Sea22 is a sea-room. The x-coordinate of Sea22 is 2.
Sea22 is southwest of Sea11, south of Sea21, west of Sea12, and northwest of Sea13.
The distant tower is in Sea22. The distant island is in Sea22. The ocean below is in Sea22.

Sea23 is a sea-room. The x-coordinate of Sea23 is 2.
Sea23 is southwest of Sea12, south of Sea22, and west of Sea13.
The force field is in Sea23. The distant tower is in Sea23. The distant island is in Sea23. The ocean below is in Sea23.

Sea31 is a sea-room. The x-coordinate of Sea31 is 3.
Sea31 is west of Sea21 and northwest of Sea22.
The force field is in Sea31. The distant tower is in Sea31. The distant island is in Sea31. The ocean below is in Sea31.

Sea32 is a sea-room. The x-coordinate of Sea32 is 3.
Sea32 is southwest of Sea21, south of Sea31, west of Sea22, and northwest of Sea23.
The distant tower is in Sea32. The distant island is in Sea32. The ocean below is in Sea32.

Sea33 is a sea-room. The x-coordinate of Sea33 is 3.
Sea33 is southwest of Sea22, south of Sea32, and west of Sea23.
The force field is in Sea33. The distant tower is in Sea33. The distant island is in Sea33. The ocean below is in Sea33.

Sea41 is a sea-room. The x-coordinate of Sea41 is 4.
Sea41 is west of Sea31 and northwest of Sea32.
The force field is in Sea41. The distant tower is in Sea41. The distant island is in Sea41. The ocean below is in Sea41.

Sea42 is a sea-room. The x-coordinate of Sea42 is 4.
Sea42 is southwest of Sea31, south of Sea41, west of Sea32, and northwest of Sea33.
The distant tower is in Sea42. The distant island is in Sea42. The ocean below is in Sea42.

Sea43 is a sea-room. The x-coordinate of Sea43 is 4.
Sea43 is southwest of Sea32, south of Sea42, and west of Sea33.
The force field is in Sea43. The distant tower is in Sea43. The distant island is in Sea43. The ocean below is in Sea43.

Sea51 is a sea-room. The x-coordinate of Sea51 is 5.
Sea51 is west of Sea41 and northwest of Sea42.
The force field is in Sea51. The distant tower is in Sea51. The distant island is in Sea51. The ocean below is in Sea51.

Sea52 is a sea-room. The x-coordinate of Sea52 is 5.
Sea52 is southwest of Sea41, south of Sea51, west of Sea42, and northwest of Sea43.
The distant tower is in Sea52. The distant island is in Sea52. The ocean below is in Sea52.

Sea53 is a sea-room. The x-coordinate of Sea53 is 5.
Sea53 is southwest of Sea42, south of Sea52, and west of Sea43.
The force field is in Sea53. The distant tower is in Sea53. The distant island is in Sea53. The ocean below is in Sea53.

Sea61 is a sea-room. The x-coordinate of Sea61 is 6.
Sea61 is west of Sea51 and northwest of Sea52.
The force field is in Sea61. The distant tower is in Sea61. The distant island is in Sea61. The ocean below is in Sea61.

Sea62 is a sea-room. The x-coordinate of Sea62 is 6.
Sea62 is southwest of Sea51, south of Sea61, west of Sea52, and northwest of Sea53.
The distant tower is in Sea62. The distant island is in Sea62. The ocean below is in Sea62.

Sea63 is a sea-room. The x-coordinate of Sea63 is 6.
Sea63 is southwest of Sea52, south of Sea62, and west of Sea53.
The force field is in Sea63. The distant tower is in Sea63. The distant island is in Sea63. The ocean below is in Sea63.

Chapter 5 - Sinister Isle

[These next three rooms refer to the SeaXX rooms defined in the autogenerated section. They'll have to change if the width of the ocean changes.]
Isle NE is an outdoor-room. "Sinister Isle's beach is full of sparkling sand, and would make an excellent vacation spot were it not for the enormous tower of doom to the southwest. The shore continues for some distance to the south, while the containment fields prevent further travel north. The island itself continues off to the west." The printed name is "Sinister Isle Shore". Isle NE is west of Sea61 and northwest of Sea62.

Isle E is an outdoor-room. "The shore of Sinister Isle continues to the north and south from here, while the Doctor's imposing tower stands directly to the west." The printed name is "Sinister Isle Shore". Isle E is south of Isle NE, southwest of Sea61, west of Sea62, and northwest of Sea63.

Isle SE is an outdoor-room. "This is the southernmost reach of Sinister Isle's shoreline reachable inside the containment fields. The rest of the beach stretches out to the north, while the island itself spreads off to the west. Dr. Sinister's enormous tower awaits you to the northwest." The printed name is "Sinister Isle Shore". Isle SE is south of Isle E, southwest of Sea62, and west of Sea63.

The sparkling beach sand is a backdrop. The printed name is "sand". The description is "Unlike the black, gritty sand on the mainland, this island's shoreline is full of sparkling sand only a few shades off from white. It would make an excellent vacation spot, if you discount the whole Evil Lair thing." Check taking the beach sand: say "You don't need any sand." instead. The beach sand is in Isle E, Isle NE, and Isle SE.

Isle S is an outdoor-room. "Dr. Sinister clearly doesn't follow the usual rules for evil strongholds. His evil tower is on a lovely coastline and is surrounded on all other sides by well-kept grass. This section of the island could almost be a lawn.[paragraph break]The tower is to the north of you, and the containment fields block you to the south. A path cut out of the grass leads east to the beach and west to the rest of the island." The printed name is "Sinister Isle". Isle S is west of Isle SE and southwest of Isle E.

Isle SW is an outdoor-room. "The containment fields block you from moving any further to the south or west here, while the tower rises to the northeast. A neatly-trimmed path cut into the grass here leads north and east." The printed name is "Sinister Isle". Isle SW is west of Isle S.

Isle W is an outdoor-room. "The tower of Dr. Sinister stands proudly to the east of here, its grey bulk left a bit greenish by the glow of the containment fields to the west.[paragraph break]A path leads from north to south around the tower." The printed name is "Sinister Isle". Isle W is north of Isle SW and northwest of Isle S.

Isle NW is an outdoor-room. "The force field shifts direction here, forming the northwest corner of the containment zone. The tower itself is off to the southeast.[paragraph break]A path is cut into the grass leading south and east." The printed name is "Sinister Isle". Isle NW is north of Isle W.

Isle N is an outdoor-room. "Dr. Sinister may be evil, but he's obviously not part of the desolate and blasted stronghold school. West of the sparkling sands of this beach, the island shifts over to verdant fields. It's also clear that he or his minions take good care of it; the grass around here is so well-kept it could practically be a lawn.[paragraph break]The massive main door of the tower is to the south, and a path cut out of the grass leads from it off to the west." The printed name is "Sinister Isle". Isle N is west of Isle NE, northwest of Isle E, east of Isle NW, and northeast of Isle W.

The main gate is a locked door. The gate is inside from Isle N. The gate is scenery. The description is "[if the height of yourself is 0]The massive door towers impressively above you[otherwise]It's hard to get a good look at it from this height[end if]." Check opening the main gate: say "The door is too heavy to open by main strength." instead. Check attacking the main gate: say "You set your mighty physique to overcoming the door. Unfortunately, it does not seem sufficient to do so." instead. Understand "massive" or "huge" or "ominous" or "door/entrance/gates/doors" as the gate. The printed name is "massive door". Instead of pulling the gate, try attacking the gate. Check lockforcing the main gate with the crowbar: say "Even with the help of the crowbar, you cannot pry open this massive door." instead. The main gate is ambiguously plural.

Knocking is an action applying to one thing. Understand "knock [thing]" or "knock on [thing]" as knocking. Carry out knocking: try attacking the noun. Understand the command "rap" as "knock".

Instead of knocking the main gate, say "You rap smartly on the massive doors, producing a hollow sound but no response."

[If we're at ground level, the south exit is the door; otherwise it's the the tower roof.]
Before going south when the location is Isle N and the height of the player is 0, try going inside instead.

The neatly trimmed path is a backdrop. Understand "good" or "landscaping" or "grass" as the neatly trimmed path. The description is "A path is cut into the grass, leading in a neat path around the tower. You suppose even evil masterminds appreciate the occasional bit of good landscaping." It is in Isle S, Isle SW, Isle W, Isle NW, and Isle N.

The force field is in Isle NE, Isle N, Isle NW, Isle W, Isle SW, Isle S, and Isle SE.

The tower wall is a backdrop. The description is "[if the height of yourself is less than the height of the tower roof]Dr. Sinister's evil tower looms high above you[otherwise if the height of yourself is greater than the height of the tower roof]The tower below dominates this island[otherwise]From here you can just see the lip of the tower roof[end if]." Instead of taking the tower wall, say tower-taking refusal.

The tower wall is in Isle NE, Isle N, Isle NW, Isle W, Isle SW, Isle S, and Isle SE.

The ocean shore is in Isle NE, Isle E, and Isle SE.

The tower roof is an outdoor-room. The height is 4. The printed name is "Dr. Sinister's Tower". The description is "You're [tower roof relative position] the top of Dr. Sinister's stronghold. Most of the roof is curved into a retractable dome, except for the access path ringing the roof[if the retractable dome is open]. The dome is currently open, revealing the cavernous hangar below[end if]."

After going to the tower roof from an outdoor-room:
	if the height of yourself is the height of the tower roof:
		say "You fly over the lip of the tower roof.";
	otherwise:
		say "You position yourself directly above the tower.";
	continue the action.

After going from the tower roof to an outdoor-room:
	if the height of yourself is the height of the tower roof:
		say "You cast off from the tower.";
	otherwise:
		say "You leave the tower behind.";
	continue the action.

The tower-roof-scenery is a privately-named scenery thing in the tower roof. The printed name is "tower roof". Understand "tower" or "roof" or "path" or "access" as the tower-roof-scenery. The description is "Most of the roof is curved into a retractable dome, except for the access path ringing the roof[if the retractable dome is open]. The dome is currently open, revealing the cavernous hangar below[end if]." Instead of taking the tower-roof-scenery, say tower-taking refusal.

To say tower-taking refusal: say "If you could pick up giant works of architecture, the Coalition of Powered Response wouldn't consider you to be a mere Class III."

Every turn when yourself is not grounded and height shift is true and the location is adjacent to the tower roof and the height of yourself is the height of the tower roof (this is the roof announcement rule):
	now height shift is false;
	say "You are now level with the tower's roof. You could land on the roof by going to the [best route from the location to the tower roof]."

The roof announcement rule is listed after the passive flight mechanics rule in the every turn rules.

To say tower roof relative position:
	if the height of yourself is greater than the height of the tower roof:
		say "high above";
	otherwise if the player is flying:
		say "hovering above";
	otherwise:
		say "standing on".

Rule for reporting flight status of the tower roof while yourself is flying:
	if the height of yourself is the height of the location, say "flying";
	otherwise say "[current altitude] feet above the roof".

Rule for touching down on the tower roof:
	now the player is grounded;
	say "You settle down on the walkway[if the energy of yourself is greater than 2][shakes][end if]."

The tower roof is southeast of Isle NW, south of Isle N, southwest of Isle NE, east of Isle W, west of Isle E, northeast of Isle SW, north of Isle S, and northwest of Isle SE.

Instead of going from an outdoor-room to the tower roof when the height of yourself is less than the height of the tower roof:
	say "[if yourself is flying]At this height, you'd just crash into the wall of the tower[otherwise]There are no doors on this side of the tower[end if]."

Instead of going from the tower roof to an outdoor-room when the player is grounded:
	say "Even though you could plausibly recover before you hit the ground, it's really quite hard to convince your body to just leap off into space like that."

The retractable dome is a closed openable enterable container in the tower roof. The dome is scenery. Understand "large" or "huge" or "hatch" or "rocket hatch" or "launch" as the retractable dome. Does the player mean doing something with the dome: it is unlikely. The description is "Most of the roof is in fact a huge launch hatch for Dr. Sinister's rockets. It's [if open]open, letting you see the rocket in the bay[otherwise]closed, though the footing still looks much safer on the access path that rings it[end if]."

Instead of opening or closing the retractable dome, say "The launch door is enormous. There's no way you'll be able to budge it with personal strength."

Instead of entering the open retractable dome when yourself is grounded:
	say "You don't like to jump uncontrolled into empty space like that. You'd rather be flying."
	
Before entering the open retractable dome when yourself is flying, try going down instead.

Instead of inserting something into the open retractable dome, say "If you want to put things into the hangar, you can just go there yourself."

The access hatch is a door. The tower roof is above the access hatch. The initial appearance of the access hatch is "A small round access hatch [if the location is the tower roof and the access hatch is closed]sits on the floor of the walkway[otherwise if the location is the tower roof and the access hatch is open]stands open, leading down into the tower[otherwise if the access hatch is closed]is just above you, on the ceiling[otherwise]stands open on the ceiling, leading up and out of the tower[end if]." Understand "small" and "round" and "circular" and "handle" as the access hatch. The description of the access hatch is "[access hatch status]." 

To say access hatch status:
	if the access hatch is closed:
		say "It's flush with the rest of the [if the access hatch is in the tower roof]walkway[otherwise]ceiling[end if], except for a small handle";
	otherwise:
		say "The access hatch now stands open".

The access hatch is stuck.

Instead of entering the open access hatch when yourself is flying:
	say "[if the height of yourself is the height of the location]It looks like there's a ladder in there. You'll have to land to be able to get through without breaking your arms on the rungs[otherwise]You're far above the hatch. You'll have to get closer before you can get through[end if]."

After lockforcing the access hatch with something:
	say "Ah, [the second noun]. Truly a tool with a thousand uses. You make quick work of whatever was making the hatch stick, and it pops open with a gratifying hiss."

The access hatch has a number called stuckness. The stuckness of the access hatch is 3.

[We don't need to handle PULL here even though we cue it because we automatically map PULL DOOR to OPEN.]
Instead of opening the stuck access hatch:
	decrement the stuckness of the access hatch;
	if the stuckness of the access hatch is:
		-- 2: say "It's stuck; you don't seem able to pry it open with your bare hands. There is a grip for a good solid pull on it, though." instead;
		-- 1: say "You heave with might and main against the door. Was it your imagination, or did something give a little there?" instead;
		-- 0: flip out instead.

To flip out:
	say "You set yourself up for another powerful pull, but halfway through, the door suddenly gives. It flies open, and you tumble off the roof.";
	now the access hatch is free-swinging;
	now the access hatch is open;
	let target be a random room adjacent to the Tower Roof that is not the Hangar Catwalk;
	now the height of the player is 4;
	now the player is plummeting;
	move the player to the target.

[While getting hurled off the building *is* a solution, most players are likely to just use the general lockforcing rules in Book 1 to solve that.]

Sinister Isle is a region. Isle NE, Isle N, Isle NW, Isle W, Isle SW, Isle S, Isle SE, Isle E, and the tower roof are in Sinister Isle.

Crossing the Sea is a scene. Crossing the Sea begins when play begins. Crossing the Sea ends when the location is in Sinister Isle and yourself is grounded.

When Crossing the Sea ends:
	deactivate the Table of Ocean Crossing Hints;
	activate the Table of Tower Panic Hints;
	score the achievement with message "making it to Sinister Isle";
	if the location is the tower roof, complete the "TWO BIRDS WITH ONE STONE" challenge;
	say "Finally. Man, that was a pain. One of these days you're going to have to get one of those hats with the drink holders and the long straws."

Finding the Hatch is a scene. Finding the Hatch begins when play begins. Finding the Hatch ends when the location is the tower roof.

When Finding the Hatch ends:
	deactivate the Table of Tower Panic hints;
	activate the Table of Tower Entry hints.

Chapter 6 - Giving Up And Going Home

Section 1 - The text

Table of Quip Texts (continued)
quip	quiptext
q_midgame_1	"As you catch your breath, you hear a soft chime. The Coalition wants to talk.[paragraph break]You activate the communicator in your Hummingbird suit. 'Hummingbird here. I'm on the island, but there's been a complication.'[paragraph break]The voice on the other end is half frantic. 'We had no idea Sinister was space capable! We've been tracking his rocket since launch, and have found both him and the base he's flying to. North American Space Command is ready to scramble a full set of LEO hunter-killer drones. Incidentally, don't even try to get to the island - it's out of your range and he's probably infested the waters.'"
q_midgame_2	"'You may want to update that profile. I'm on the island now.'[paragraph break]'What? But...'[paragraph break]'Later. For now...'"
q_midgame_3	"'Thanks for the warning, guys, but next time could you maybe send it [italic type]before[roman type]I actually make it to the island?'[paragraph break]'Did you fight off his creatures, or...'[paragraph break]'Flew the whole way.'[paragraph break]'But...'[paragraph break]'Looks like we're all full of surprises today, aren't we? But for now...'"
q_midgame_4	"'...for now, you're all going off half-cocked. We've seen a rocket launch. That might be the Doctor. It might be the key to his plan. It might be part of it. It might be a feint to throw us off the scent. I'm here, so I'm going to see what's going on.'[paragraph break]'Fair enough, Hummingbird. We'll tell NASC to stand by until we know more. We'll be in touch later.'"
q_midgame_5	"'A strike force? I'd just as soon it not come to that. Rocket or not, Sinister's still just a blip - CPR policy says a Class III should be able to handle him. That's me, and I'm on the scene.'[paragraph break]'How much of your Class III rating is crisis management, and how much is your violation of traditional concepts of thrust-to-weight ratios?'[paragraph break]'Don't start that again. Look. I'm at his base. There could be anything in there. It would be stupid to give up before seeing what all our options are.'[paragraph break]'All right, fine. We'll be in touch again once you've finished your investigation.'"
q_midgame_6	"'We have no idea what he's got up there. Is it really safe to wait?'[paragraph break]'Probably not. NASC will complete the intercept before he can reach his target. Maybe we can learn what his plan was from the wreckage.'[paragraph break]'Roger.'[paragraph break]'Sorry for tangling you up in this, Hummingbird. We should have sent a Class II to begin with. An extraction team should be by in an hour or so to pick you up. In the meantime, enjoy the fireworks.'"
q_midgame_7	"Your suit chimes again. 'Hummingbird here. Good timing; I've finished my investigation.'[paragraph break]'What did you find?'[paragraph break]'The base is abandoned. Whatever Sinister's up to is entirely in orbit.'[paragraph break]'So does that mean the strike force gets a green light?'"
q_midgame_8	"Your suit chimes again. 'Hummingbird here.'[paragraph break]'North American Space Command has run out of patience. Do you have any reason to stop them?'[paragraph break]'Yes. I've found a rocket and fuel to chase him. We can still stop this without bloodshed.'[paragraph break]Mission Control sounds amused. 'You realize that the only lives you're saving here are the villains['].'"
q_midgame_9	"'Looks like. I can't find anything in here of what his plan even was, though.'[paragraph break]'NASC will complete the intercept before he can reach his target. Maybe we can learn what is plan was from the wreckage. In the mean time we'll send an extraction team by in an hour or so to pick you up. Enjoy the fireworks.'"
q_midgame_10	"'No. Dr. Sinister always keeps redundant backup plans - in this case, he has a separate launch rocket and fuel still in the base. I can give chase.'[paragraph break]'All right, but be quick about it. They won't wait forever.'"
q_midgame_11	"'Well, that is usually part of the job. It's not usually so stark though, I admit.'[paragraph break]'Copy that. Be quick, though. NASC won't wait forever.'[paragraph break]'All right. I'm getting to work now.'"
q_midgame_12	"'This is exactly why we send us in instead of the military. We haven't been stymied yet, so we're still in business.' Silence from the other end. '[italic type]My[roman type] job is to get that rocket going and give chase. [italic type]Your[roman type] job is to hold off NASC long enough for me to talk him down or shut him down. Are we clear here?'[paragraph break]'...copy that, Hummingbird. But they won't wait forever.'[paragraph break]'I wouldn't expect them to. Now let's go save some lives.'"

Table of Quip Followups (continued)
quip	option	result
q_midgame_1	"'Beyond my range?'"	q_midgame_2
q_midgame_1	"'Way to warn me in advance, guys - I'm on the island [italic type]now[roman type].'"	q_midgame_3
q_midgame_2	"'We don't have the full story yet. I'm going to investigate.'"	q_midgame_4
q_midgame_2	"'I'm not willing to let NASC kill everyone unless it's our last option.'"	q_midgame_5
q_midgame_2	"'Have NASC take the shot. It's the only way to be sure.'"	q_midgame_6
q_midgame_3	"'We don't have the full story yet. I'm going to investigate.'"	q_midgame_4
q_midgame_3	"'I'm not willing to let NASC kill everyone unless it's our last option.'"	q_midgame_5
q_midgame_3	"'Have NASC take the shot. It's the only way to be sure.'"	q_midgame_6
q_midgame_7	"'Yes - that should stop him.'"	q_midgame_9
q_midgame_7	"'No - there's enough here that I can stop him.'"	q_midgame_10
q_midgame_8	"'That's the way it goes sometimes.'"	q_midgame_11
q_midgame_8	"'That's the [italic type]whole point[roman type].'"	q_midgame_12

Section 2 - The logic

[Conversation with CPR dispatch happens in two parts. The first is basically when Crossing The Sea ends; once you've solved the first puzzle, CPR tries to convince you to give up. Here you buy some time. The second conversation happens once your investigation is complete; we test for this by ensuring that all bottleneck locations in the base are visited, and that they PC has seen the fuel truck.]

When Crossing the Sea ends, deliver the q_midgame_1 quip.

[We remember how the conversation goes because we want to call back to it later on.]
Contact result is a number that varies. Contact result is zero.

After quipping when the current quip is q_midgame_4, now  contact result is 4.
After quipping when the current quip is q_midgame_5, now contact result is 5.
After quipping when the current quip is q_midgame_6, end the story saying "You have passed the buck".
After quipping when the current quip is q_midgame_9, end the story saying "You have passed the buck".
After quipping when the current quip is q_midgame_12, now contact result is 12.

Buying Time is a scene. Buying Time begins when Base Infiltration ends. Buying Time ends when Isle SW is visited and Entrance Hall is visited and Command Center is visited and the player is grounded.

When Buying Time ends:
	if contact result is 4:
		deliver the q_midgame_7 quip;
	otherwise:
		deliver the q_midgame_8 quip.

Section 3 - Consistency

Calling is an action applying to one topic.
Understand "call [text]" as calling. Understand "phone [text]" as calling. Understand "communicate [text]" as calling.
Check calling: say comm refusal instead.

To say comm refusal:
	unless the achievement "making it to Sinister Isle" is scored:
		say "You have nothing to report yet.";
	otherwise if the achievement "reaching the station" is scored:
		say "You are unlikely to get reception up here.";
	otherwise if Docking is happening:
		say "You are unlikely to get reception up here.";
	otherwise if Buying Time is happening:
		say "You haven't finished investigating the base yet. You don't want to talk until you get a definitive answer.";
	otherwise:
		say "You said you were going to handle this, and you're going to see it through."
		

Part 2 - Repair

Chapter 1 - The Main Base

The Entrance Hall is a room. North of the entrance hall is the main gate.

South of the Entrance Hall is the Main Hall. West of the Main Hall is the Staging Area. West of the Staging Area is the Minions' Chambers.

The description of the Entrance Hall is "This is, in all likelihood, more of an 'exit hall' than an 'entrance hall.' Dr. Sinister is unlikely to be receiving visitors often, and this 'entrance' is broad enough to let a budding overlord's armies march out twenty abreast and still have room to move out vehicles after them[if unvisited].[paragraph break]That does raise the question of how he planned on getting them to the mainland, but you suppose that's neither here nor there[end if].[paragraph break]The huge doors to the north [if the main gate is open]stand open to the island[otherwise]bar your passage[end if]." The maximum height of the Entrance Hall is 2.

After going from an outdoor-room to the Entrance Hall:
	announce tower entry;
	continue the action.

After going from the Entrance Hall to an outdoor-room:
	announce tower exit;
	continue the action.

To announce tower entry:
	say "[one of]You climb down into Dr. Sinister's island tower[or]You once again infiltrate the Doctor's compound[or]You go back into the tower[stopping]."

To announce tower exit:
	say "You [if yourself is flying]fly[otherwise if the location is the tower roof]climb[otherwise]walk[end if] back out into the sunlight."

Instead of going north from the Entrance Hall when the height of yourself is not 0, say "The door is noticably below you; up here, the walls of the tower are in your way."

The description of the Main Hall is "Colorful tapestries hang on the wall here. Most of them carry the series of red slashes that are Dr. Sinister's trademark insignia, but a few others show his benevolent face smiling down upon any visitors from the main entrance to the north, or perhaps to inspire his troops marching out from the west."

Some tapestries are a scenery thing in the Main Hall. The description is "Dr. Sinister's logo looks pretty good at that scale, but his face doesn't. It's a little too clean-shaven and managerial-looking." Instead of attacking the tapestries, say "Vandalism isn't the answer to this one." Understand "red" and "slash" and "slashes" and "insignia" and "trademark" and "sinister" and "dr" and "sinister's" and "logo" and "face" and "logos" and "faces" as the tapestries.

The description of the Staging Area is "This large area looks like it was once central to Dr. Sinister's operations. However, any signs of his plots based here have been removed. There hasn't been much time for dust to accumulate, either; he must have been expecting to leave this base behind[if unvisited].[paragraph break]You suppress an involuntary but unheroic shudder. If he was willing to abandon an entire base to further his plot, it must be a big one[end if].[paragraph break]This area continues off to the east, and narrows considerably to the west. The rocket hangar lies through the huge archway to the north[if the defense grid is full of lasery doom]. However, access to the hangar is currently blocked by a grid of shimmering light beams[end if]."

The description of the Minions' Chambers is "The base continues from east to west. This area looks like a barracks; rows and rows of empty bunk beds line the halls. This must be where his minions slept when they weren't on-duty.[paragraph break]To the west you can see a fancy desk[if the Tower Office is trapped] and an enormous pit taking up most of the room. Looks like the boss had an open-floor policy to go with his open-door one[otherwise]. Looks like the boss had an open-door policy[end if]."

The distant desk is a scenery thing in Minions' Chambers. The printed name is "desk". The description is "You can only see part of it from here, but it's pretty imposing even from this distance." Instead of doing something other than examining to the distant desk, say "It's too far away."

The distant-minion-pit-hole-floor is a privately-named scenery thing in Minions' Chambers. The printed name is "[if the Tower Office is trapped]pit[otherwise]floor[end if]". The description is "[if the Tower Office is trapped]Most of the floor in the next room is gone, revealing an enormous pit. However, there is still more than enough room to walk around the edges; going west would be safe[otherwise]You see nothing special about the floor[end if]." Instead of doing something other than examining to the distant-minion-pit-hole-floor when the Tower Office is trapped, say "The pit is too far away." Instead of doing something other than examining to the distant-minion-pit-hole-floor when the Tower Office is innocuous, say "Leave the floor alone. You have a job to do." Understand "pit" or "hole" or "floor" as the distant-minion-pit-hole-floor.

Check sleeping in the Minions' Chambers: say "You've got vastly more important things to be doing." instead.

Some bunk beds are a scenery thing in the Minions' Chambers. Understand "array" or "hard" or "mattress" or "mattresses" or "bunks" or "bed" as the beds. Instead of entering the beds, try sleeping. Understand "lie on [something]" as entering.

Instead of taking the bunk beds, say "You really don't need any mattresses."

The description of the bunk beds is "At this point they're just an array of hard mattresses."

Chapter 2 - The Hangar

The Hangar Catwalk is below the access hatch. "You're standing on a narrow catwalk ringing a vast hangar. To the west is an airlock leading into a bright yellow rocket that fills most of the area. A ladder leads both up [if the access hatch is open]through[otherwise]to[end if] the ceiling, and down to the floor of the hangar proper[if the retractable dome is open]. Sunlight streams in from the open launch hatch, illuminating the entire area[otherwise]. The roof forms a dome about 30 feet above your head[end if]. You could also easily take off from here, if you were so inclined."

Instead of jumping in the hangar catwalk, say "The catwalk's safety railings would keep you on the catwalk with any human jump. That aside, you don't like just leaping out into the void like that; you prefer controlled flight."

The rocket airlock is a scenery thing in the Hangar Catwalk. The description is "It's a bright yellow rocket, straight out of 30s pulp science fiction covers. An airlock at this level allows entry." Instead of opening the airlock, say "It's already open." Instead of closing the airlock, say "The airlock doesn't close by simple muscle power." Instead of entering the airlock, try going west instead. Instead of taking the rocket airlock, say "You're as likely to manage that as to take the entire tower[one of][or]. And no, you wouldn't be capable of taking the tower, either[stopping]."

The ambient-catwalk is a privately-named scenery thing in Hangar Catwalk. Understand "catwalk" or "railing" or "railings" as the ambient-catwalk. The description is "This catwalk is made of sturdy steel and has strong, high railings. Despite the dizzying height, nobody could fall off of the catwalk accidentally."

After going from an outdoor-room to the Hangar Catwalk:
	announce tower entry;
	continue the action.

After going from the Hangar Catwalk to an outdoor-room:
	announce tower exit;
	continue the action.

The ambient-dome is a privately-named backdrop. It is in Hangar and Hangar Catwalk. The printed name is "roof". The description is "[if the retractable dome is open]The roof is largely gone, flooding the hangar with sunlight from a clear blue sky[otherwise]You can't see much through the roof[end if]." Understand "roof" or "sky" as the ambient-dome. Before examining up when the ambient-dome is in the location, try examining the ambient-dome instead. Instead of opening the ambient-dome, say "[if the retractable dome is open]It's already open[otherwise]The roof doesn't open by muscle power[end if]." Instead of closing the ambient-dome, say "[if the retractable dome is closed]It's already closed[otherwise]The roof doesn't close by muscle power[end if]."

Base Infiltration is a scene. Base Infiltration begins when Finding the Hatch ends. Base Infiltration ends when the location is the hangar catwalk.

When Base Infiltration ends:
	say "Right then. Time to get to work.";
	deactivate the Table of Tower Entry hints;
	deactivate the Table of Rocket Panic hints;
	activate the Table of Rocket Launch hints;
	score the achievement with message "infiltrating Dr. Sinister's tower".

A room called Hangar is below the Hangar Catwalk. "This enormous hangar appears to take up nearly all the space in this tower-or, at least, the space in the tower that's above the ground[if the height of the player is 3]. A narrow catwalk at this level will let you land[otherwise if the height of the player is greater than 3]. A catwalk, some distance below you, leads into a large rocket taking up most of the space in this hangar[otherwise]. Most of the space in the hangar is taken up by an enormous, yellow, finned rocket. A catwalk far above leads into it[end if].[paragraph break]A ladder leads up to the catwalk, and then further up to provide roof access[if the retractable dome is open], though most of the roof is now open as the base prepares for a new rocket launch[otherwise]. The roof itself looks quite solid, and you don't expect that rocket will be able to launch through it as-is[end if].[paragraph break]A hallway large enough to pass a freight train leads off to the south, to some kind of staging area[if the defense grid is full of lasery doom]. However, access to the staging area is currently blocked by a grid of shimmering light beams[end if]." The maximum height of the Hangar is 4.

A scenery thing called the rocket is in the Hangar. The description is "It's a bright yellow rocket, straight out of 30s pulp science fiction covers. A catwalk [if the height of the player is 3]at this level[otherwise if the height of the player is greater than 3]a bit below[otherwise]far above[end if] allows entry." Instead of opening, closing, or entering the rocket, say "You can't do much with the rocket when you aren't on the catwalk." Instead of taking the rocket, say "You're as likely to manage that as to take the entire tower[one of][or]. And no, you wouldn't be capable of taking the tower, either[stopping]."

A scenery thing called the catwalk is in Hangar. The description is "The catwalk leads into the rocket, and also connects to a ladder leading from the floor up to the roof[if the height of the player is 3]. You're flying level with it, and could easily land[otherwise if the height of the player is greater than three]. It's some distance below you[otherwise]. It's well above you[end if]."

The ladder is a backdrop. The ladder is in the Hangar and in the Hangar Catwalk. The description is "The ladder here leads up to [if the location is the Hangar]a catwalk[otherwise]the roof and down to the hangar floor[end if]." Instead of climbing the ladder, try going up.

Rule for touching down on Hangar Catwalk:
	now the player is grounded;
	say "You settle down on the catwalk[if the energy of yourself is greater than 2][shakes][end if]."

Rule for lifting off from the Hangar Catwalk:
	now the height of the player is 3;
	say "[line break]You clear the catwalk and begin flying through the cavernous hangar.";
	move the player to the Hangar, without printing a room description.

Before landing when the location is the Hangar and the height of the player is 3:
	now the height of the player is 0;
	move the player to the Hangar Catwalk, without printing a room description.

Rule for running out of power in the Hangar:
	if the height of the player is 3:
		now the height of the player is 0;
		move the player to the Hangar Catwalk, without printing a room description.

Before going down while yourself is flying and the location of the player is the Tower Roof and the height of the player is the height of the Tower Roof and the retractable dome is open (this is the aerial tower entry rule):
	say "You fly through the open launch door into the hangar proper.";
	now the height of the player is the maximum height of the Hangar;
	move the player to the Hangar;
	stop the action.
	
Before going up while yourself is flying and the location of the player is the Hangar and the height of the player is the maximum height of the Hangar and the retractable dome is open (this is the aerial tower exit rule):
	say "You fly through the open launch door into the open air.";
	now the height of the player is the height of the tower roof;
	move the player to the tower roof;
	stop the action.
	
The aerial tower entry rule is listed before the descent rule in the before rules.
The aerial tower exit rule is listed before the ascent rule in the before rules.

Rule for crashlanding on the Tower Roof when the retractable dome is open:
	say "You plummet through the open hatch into the base below.";
	now the height of the player is the maximum height of the Hangar;
	move the player to the Hangar.

Every turn when yourself is not grounded and the location is the Hangar and the height of yourself is 3 and height shift is true (this is the catwalk announcement rule):
	now height shift is false;
	say "You are now level with the catwalk[if yourself is flying]. You could land here if you so chose[end if]."

The catwalk announcement rule is listed after the passive flight mechanics rule in the every turn rules.

Chapter 3 - The defense grid

[The defense grid is an ignition source, but it's not important to the game here, particularly. See the section "Only you can prevent space station fires" for the relevant logic.]

The defense grid is an open scenery door. The defense grid is not openable. The defense grid is south of the Hangar and north of the Staging Area.

The defense grid can be full of lasery doom. The defense grid is not full of lasery doom.
The defense grid can be recognized as hazardous. The defense grid is not recognized as hazardous.

The description of the defense grid is "This circular doorway leads to [if the other side of the defense grid is visited]the[otherwise]some kind of[end if] [the printed name of the other side of the defense grid in lower case][defense grid status description]."

To say defense grid status description:
	if the defense grid is recognized as hazardous:
		say "[if the defense grid is full of lasery doom]. It is full of deadly laser beams[otherwise]. The laser beams are off at the moment[end if]";
	otherwise:
		say "[if the defense grid is full of lasery doom]. Beams of coruscating light crisscross the doorway. They don't look terribly friendly[end if]".

Understand "corridor" or "hallway" or "circular" or "door" or "laser" or "lasers" or "coruscating" or "light" or "beam" or "beams" or "deadly" or "circular" or "doorway" as the defense grid.

The grid victim is a thing that varies. The grid victim is the defense grid.[* An obviously bogus value. It should never be read before being written, so this should work out OK.]

Instead of touching, rubbing, taking, kissing, or tasting the full of lasery doom defense grid:
	if the defense grid is recognized as hazardous, say "No way. You saw what those beams did to [the grid victim]." instead;
	say "Those beams don't look friendly. You're not going to risk your skin messing with them." instead.

Check going through the full of lasery doom defense grid:
	if the defense grid is recognized as hazardous, say "No way. You saw what those beams did to [the grid victim]." instead;
	say "Those beams don't look friendly. You're not going to risk your skin dashing through them." instead.

Before inserting something (called the guinea pig) into the defense grid:
	if the guinea pig is not carried:
		say "(first taking [the guinea pig])[command clarification break]";
		silently try taking the guinea pig;
		if the guinea pig is not carried, stop the action.

Instead of throwing something (called the missile) at the full of lasery doom defense grid:
	try inserting the missile into the defense grid.

Instead of inserting something (called the guinea pig) into the defense grid:
	if the defense grid is not full of lasery doom:
		if the defense grid is recognized as hazardous:
			say "Nothing happens. The laser beams are off now, so it's just another empty doorway.";
		otherwise:
			say "You wave [the noun] in the doorway but nothing immediately obvious happens.";
	otherwise if the defense grid is recognized as hazardous:
		say "No way. You saw what it did to [the grid victim].";
	otherwise if the guinea pig is critical:
		say "You don't want to risk [the guinea pig] that way.";
	otherwise:
		say "The beam utterly vaporizes [the guinea pig]. Good thing you didn't try that with something [italic type]really[roman type] important.";
		remove the guinea pig from play;
		now the defense grid is recognized as hazardous;
		now the grid victim is the guinea pig.

The Long Way Around is a scene. The Long Way Around begins when Base Infiltration ends. The Long Way Around ends when the defense grid is full of lasery doom and the location is the Hangar or the location is the Hangar Catwalk.

When The Long Way Around ends:
	score the achievement with message "bypassing the defense grid".

Arming the Defenses is a scene. Arming the Defenses begins when Base Infiltration ends. Arming the Defenses ends when the player can see the full of lasery doom defense grid.

When Arming the Defenses ends:
	activate the Table of Defense Grid Hints.

Chapter 4 - Getting Into the Control Center

The smaller nondescript wooden wood[* Apologies to those of you who just had AGT flashbacks.] door is a closed locked lockable scenery door. The description of the nondescript door is "This nondescript door looks like it's just made of wood[if forced]. The lock has been wrecked[otherwise]. The lock on it looks pretty sturdy, though[end if]." The printed name is "door". Understand "lock" as the nondescript door. Understand "wrecked" or "broken" as the nondescript door when the nondescript door is forced. Understand "sturdy" as the nondescript door when the nondescript door is not forced.

The Tower Office is west of the Minions' Chambers and east of the smaller door. The Tower Office can be innocuous or trapped. The Tower Office is innocuous.
The printed name is "Dr. Sinister's Office". The description is "This luxurious office must be where Dr. Sinister spends most of his time scheming. A huge mahogany desk takes up most of the west side of the room, and behind it is a tall, black leather chair. A smaller door hides behind it. The rest of the base lies to the east[if trapped][in-room trap details][end if]."

To say in-room trap details:
	say ".[paragraph break]Most of the floor is gone at the moment, revealing an ominous pit that leads down a good distance[if the number of not scenery things in the Pit Trap is not zero]. At the bottom you can just make out [a list of not scenery things in the Pit Trap][end if]. Someone standing could still walk to either door, though".

The nondescript door can be intact or wrecked. The nondescript door is intact.

Instead of attacking the nondescript door:
	now the nondescript door is open;
	now the nondescript door is not openable;
	now the nondescript door is wrecked;
	say "[if the nondescript door is locked]Hah. A door is only as strong as its weakest component. [end if]With a single mighty punch, you reduce the door to splinters. The way to the [if the location is the Tower Office]command center[otherwise]office[end if] is now [if the nondescript door is locked]open to you[otherwise]permanently open[end if]."

Before doing something to the wrecked nondescript door, say "There's no door left anymore." instead.

The huge enormous mahogany desk is an enterable scenery supporter in the Tower Office. The printed name of the mahogany desk is "desk". The description is "It would look out of place anywhere else in the base, but here, it provides an excellent sense of power and control. The right-hand side of it includes a small drawer, easily accessible whether or not one is seated in the chair."

The small drawer is a closed openable container. The small drawer is part of the mahogany desk. The description is "This small drawer is part of the desk. It's on the right-hand edge if one is sitting in the chair, and it looks easily reachable even if one were merely standing near it[if closed]. It's closed[otherwise if the number of things enclosed by the drawer is zero]. It's empty[otherwise]. It's open, revealing [a list of things which are contained by the drawer][end if]."

Instead of opening the mahogany desk, try opening the small drawer. Instead of closing the mahogany desk, try closing the small drawer.

Instead of taking, pushing, or pulling the mahogany desk, say "Wow. It is [italic type]heavy[roman type]. You don't seem to be able to budge it at all."

The tall black leather chair is a scenery enterable supporter in the Tower Office. The printed name is "leather chair". The description is "It looks quite comfortable[if the Tower Office has been trapped], though it also looks like the doctor welded it to the floor as a safety precaution[otherwise]. Oddly, it seems to be welded to the floor. You suppose Dr. Sinister didn't want to scoot around the office for some reason[end if]." Instead of taking, pushing, or pulling the chair, say "[if the Tower Office has been trapped]It looks like Dr. Sinister welded his chair to the floor so that he would never fall afoul of his own trap door[otherwise]Bizarrely, it seems to be welded to the floor. Perhaps Dr. Sinister wanted to ensure the chair always stayed exactly where it was[end if]."

Check turning the leather chair:
	if the player is on the leather chair, say "Wheeee!" instead;
	say "The chair spins smoothly on its bearings." instead.

Understand "spin [something]" as turning.

Does the player mean turning the leather chair: It is likely.
Does the player mean turning the leather chair when the leather chair encloses yourself: it is very likely.
Does the player mean entering the leather chair: It is very likely.

The silver key is a thing in the drawer. The matching key of the nondescript door is the silver key. The description is "It's probably not [italic type]really[roman type] silver, but it is metallic and shiny. It's no larger than a housekey."

The Pit Trap is a room. The maximum height of the Pit Trap is 7. The description is "This pit trap is almost two hundred feet deep, and surrounded by smooth walls on all sides. Nevertheless, the bottom seems mostly clean. Perhaps he has some means of flushing it out - or maybe it's just never been used to dispose of anyone."

Rule for listing nondescript items of the Pit Trap when the height of the player is not the height of the location:
	say "Down at the bottom of the pit you can see [pit contents]."

The pit-walls are a privately-named scenery thing in Pit Trap. Understand "walls" or "wall" or "polished" or "steel" or "pit wall/walls" as the pit-walls. The printed name of the pit-walls is "pit walls".

Definition: a direction is horizontal if it is not up and it is not down and it is not inside and it is not outside.

Instead of examining a horizontal direction: try examining the pit-walls.
Before touching a horizontal direction: try touching the pit-walls instead.
Before climbing a horizontal direction: try climbing the pit-walls instead. Instead of climbing up, try climbing the pit-walls.

The description of the pit-walls is "The walls extend for hundreds of feet and seem to be made of polished steel." Instead of touching the pit-walls, say "They're quite smooth to the touch." Instead of climbing the pit-walls, say "You don't see any useful handholds."

Before touching the pit-walls while yourself is flying: say "That would fatally disrupt your flight." instead.
Before touching the pit-walls while yourself is plummeting: say "That isn't going to slow you down fast enough!" instead.
Before climbing the pit-walls while yourself is plummeting: say "You couldn't get a grip at this speed even if there were a grip to get, which there isn't."

The pit-floor is a privately-named scenery thing in Pit Trap. Understand "floor" or "ground" as the pit-floor. Instead of examining down, try examining the pit-floor. The printed name of the pit-floor is "pit floor". The description is "How does he keep it this clean? You're hard-pressed to even find dust."

The pit-scenery is a privately-named scenery thing. The description is "It goes down a couple of hundred feet or so[if the number of not scenery things in the Pit Trap is not zero]. Squinting, you can just make out [a list of not scenery things in the pit trap] at the bottom[end if]." Understand "pit" or "hole" as the pit-scenery.

To say pit contents:
	list the contents of the Pit Trap, as a sentence, tersely, [not listing concealed items,] listing marked items only, and giving brief inventory information.

Rule for reporting flight status of the Pit Trap while yourself is flying:
	if the height of yourself is the height of the location, say "flying";
	otherwise say "[current altitude] feet above the bottom".

Rule for touching down on the Pit Trap:
	now the player is grounded;
	say "You come to a safe landing at the bottom of the pit trap.[no line break][one of] Ha HA! Take [italic type]that[roman type], hidebound traditional villains![or][line break][stopping]"

Rule for crashlanding on the Pit Trap:
	say "You make an undignified crash as the pit trap's floor does what it was designed to do - be solid and a long way down.";
	end the story saying "You've fallen for the oldest trick in the book".

[This has to be one rule, since otherwise we set the value before we check it.]
After opening the small drawer when the Tower Office is innocuous:
	now the Tower Office is trapped;
	now the pit-scenery is in the Tower Office;
	repeat with plummetor running through the things in the Tower Office:
		if the plummetor is the player:
			[The player can't be flying here, since he just opened the drawer.]
			say "As you open the desk, you barely get a glimpse of [if the number of things contained by the small drawer is zero]the fact that it is empty[otherwise]its contents - [a list of the things contained by the small drawer] -[end if] before the floor opens up beneath you, revealing a vast pit below!";
			now the player is plummeting;
		otherwise if the plummetor is not scenery and the plummetor is not fixed in place:
			move the plummetor to the Pit Trap;
	if the player is not plummeting:
		consider the report opening rules;
		say "[line break]Suddenly, most of the floor in the room retracts! There are still narrow routes to the desk and the doors, but if you weren't on [the holder of the player], you'd definitely be taking an unscheduled flight right now[if the number of not scenery things in the Pit Trap is not zero]. Looking down from your perch, you can just make out [a list of not scenery things in the pit trap] far below[end if]."

Before going down in the trapped Tower Office when the player is grounded:
	say "You're not a huge fan of just leaping into the unknown like that. You prefer controlled flight." instead.

Instead of jumping in the Trapped Tower Office, try going down.

[More or less a copy-paste from the Hangar code.]

Before going down while yourself is flying and the location of the player is the Tower Office and the height of the player is the height of the Tower Office and the Tower Office is trapped (this is the aerial pit entry rule):
	say "You fly down into the pit trap.";
	now the height of the player is the maximum height of the Pit Trap;
	move the player to the Pit Trap;
	stop the action.
	
Before going up while yourself is flying and the location of the player is the Pit Trap and the height of the player is the maximum height of the Pit Trap and the Tower Office is trapped (this is the aerial pit exit rule):
	say "You fly back up into the office.";
	now the height of the player is the height of the Tower Office;
	move the player to the Tower Office;
	stop the action.
	
The aerial pit entry rule is listed before the descent rule in the before rules.
The aerial pit exit rule is listed before the ascent rule in the before rules.

Rule for crashlanding on the Tower Office when the Tower Office is trapped:
	say "You drop like a rock.";
	now the height of the player is the maximum height of the Pit Trap;
	move the player to the Pit Trap.

Rule for touching down on the Tower Office when the Tower Office is trapped:
	say "You settle down on one of the few safe spots in the room.";
	now the player is grounded.

[Because the beta testers are in fact Free Men.]
A wooden crate is a closed openable container in Pit Trap. The description is "It's pretty big, but it's just a wooden crate." The wooden crate is inflammable.
Report taking the wooden crate:
	say "It's big and bulky, but it's not heavy enough to cause you any real trouble.";
	stop the action.
Check inserting the wooden crate into the HummingBelt:
	say "That crate is almost as big as you are. You are not going to be able to stow it on your belt." instead.

Rule for printing room description details of the crate:
	do nothing.

Instead of lockforcing the closed crate with something:
	say "The crate isn't actually locked or stuck or anything. There's nothing stopping you from just opening it."

Instead of attacking the crate:
	if the player has the crate:
		say "It's really bulky. You can't get a proper angle for destruction while carrying it.";
	otherwise:
		say "You unleash your devastating fighting techniques, swiftly reducing the crate to a pile of splintered wood.[paragraph break][if the number of things contained by the crate is zero and the crate has not been open]Looks like it was empty after all[otherwise if the number of things contained by the crate is greater than zero]The [list of things contained by the crate] spill[s] out to the ground[otherwise]It's still empty, though[end if].";
		remove the crate from play;
		move the splintered wood to the location;
		repeat with prize running through things contained by the crate:
			move the prize to the location.

Instead of attacking the crate with the crowbar:
	if the player has the crate:
		say "It's really bulky. You can't get a proper angle for destruction while carrying it.";
	otherwise:
		say "It's been known for decades that wrecking crates with crowbars has a proven cathartic effect. You swiftly reduce the crate to a pile of splintered wood.[paragraph break][if the number of things contained by the crate is zero and the crate has not been open]Looks like there wasn't anything in it, though[otherwise if the number of things contained by the crate is greater than zero]The [list of things contained by the crate] spill[s] out to the ground[otherwise]It's still empty, though[end if].";
		remove the crate from play;
		move the splintered wood to the location.

The splintered wood is an improbable inflammable thing. The description is "These small chunks of wood are all that are left of the crate you destroyed." The indefinite article is "some". Understand "chunks" or "small" or "chunks of wood" as the splintered wood.

Chapter 5 - The Command Center

The Command Center is west of the nondescript door. The description of the Command Center is "Dr. Sinister seems to have found an interesting solution to the problem of maintaining operational security: he has placed his master command center in his bedroom. A surprisingly humble bed sits off against the south wall, while an impressive command terminal full of controls and displays occupies most of the opposite one. The Doctor's office lies back to the east."

The humble bed is an enterable scenery supporter in the Command Center. The printed name is "bed". Understand "cot" as the bed. The description is "It's little more than a cot, really. You wonder if he sleeps here normally, or if this was just for the occasional all-nighter. It certainly doesn't match up with the ostentation out in the main office."

Check sleeping in the Command Center: say "You've got vastly more important things to be doing." instead.

The command terminal is in the Command Center. The command terminal is scenery. Understand "switchboard" or "switches" or "center" or "array" or "control" or "panel" or "controls" or "console" as the terminal. The description is "[display summary]. [switches summary]". 

The master power switch is part of the command terminal. It is a switched off device. The description is "This switch presumably feeds power to the base's large systems." Understand "main power" as the master power switch.

The defense-grid switch is part of the command terminal. It is a switched on device. The description is "This switch is labeled 'DEFENSE GRID'[if broken]. However, the switch itself has broken off and it is wedged in the ON position[end if]." The printed name is "[if broken]broken [end if]defense grid switch". Understand "defense" and "grid" as the defense-grid switch. The defense-grid switch can be broken. The defense-grid switch is not broken. Understand the broken property as describing the defense-grid switch.

The main door switch is part of the command terminal. It is a switched off device. The description is "This switch is labeled 'MAIN DOOR'." Understand "gate" or "gates" or "doors" as the main door switch.

The launch-hatch switch is part of the command terminal. It is a switched on device. The description is "This switch is labeled 'LAUNCH HATCH'." The printed name is "launch hatch switch". Understand "launch", "hangar", "retractable", "dome", and "hatch" as the launch-hatch switch.

The trap toggle button is part of the command terminal. The description is "This button is labeled 'TRAP TOGGLE'."

Bed-snark is a truth state that varies. Bed-snark is false.

After going to the Command Center:
	now bed-snark is false;
	continue the action.

Before pushing, switching on, or switching off when the noun is part of the command terminal and the humble bed encloses the player (this is the bed command snark rule):
	if bed-snark is false:
		now bed-snark is true;
		say "(not first getting out of the bed - Dr. Sinister clearly has his priorities straight)[command clarification break]".

[These are so OPEN MAIN DOOR and the like work.]
Instead of opening the main door switch, try switching on the noun. Instead of closing the main door switch, try switching off the noun.
Instead of opening the launch-hatch switch, try switching on the noun. Instead of closing the launch-hatch switch, try switching off the noun.

Some displays are part of the command terminal. The description is "[display summary].".

To say display summary:
	if the master power switch is switched off:
		say "The terminal's displays are all dark";
	otherwise:
		say "The terminal's displays are now showing various parts of the base. One view [if the main gate is open]looks out the massive main doors to the path[otherwise]looks at the closed bulk of the main doors[end if], while another [if the retractable dome is open]gazes out the hangar into the blue sky[otherwise]stares at the rocket and the hangar ceiling[end if]. Other images flicker through the displays, but the only other one that catches your eye is the grid of light that seems to be sealing off the hangar from the main halls";

To say display initialization:
	say "The terminal's displays are now showing various parts of the base. One view [if the main gate is open]shows the main doors starting to majestically swing open to the island[otherwise]looks at the closed bulk of the main gate[end if], while another [if the retractable dome is open]shows the roof of the hangar opening up, revealing the blue sky above[otherwise]stares at the rocket and the hangar ceiling[end if]. Other images flicker through the displays, but the only other one that catches your eye is the grid of light starting to flicker to life, sealing off the hangar from the main halls";
	

To say switches summary:
	let N be the number of switched off devices that are part of the command terminal;
	let P be the number of switched on devices that are part of the command terminal;
	if N is 0, say "Beneath the displays, you find that all the controls on the terminal - [the list of switched on devices that are part of the command terminal] - are switched on. ";
	otherwise say "Beneath the displays, you note that [the list of switched on devices that are part of the command terminal] [if P is 1]is[otherwise]are[end if] on, and [the list of switched off devices that are part of the command terminal] [if N is 1]is[otherwise]are[end if] switched off. ";
	say "There is also a button marked 'TRAP TOGGLE'.[no line break]"

Instead of pushing the trap toggle button:
	if the master power switch is switched off:
		say "Nothing happens. Perhaps the fact that the power switch is off has something to do with this.";
	otherwise:
		if the Tower Office is trapped:
			now the Tower Office is innocuous;
			remove the pit-scenery from play;
		otherwise:
			now the Tower Office is trapped;
			now the pit-scenery is in the Tower Office;
		if the nondescript door is closed:
			say "You hear some machinery moving nearby.";
		otherwise if the Tower Office is trapped:
			say "The floor in the next room largely disappears, revealing a deep pit.";
		otherwise:
			say "The pit in the next room closes up, restoring the floor.".

Carry out switching on the master power switch:
	if the main door switch is switched on, now the main gate is open;
	if the launch-hatch switch is switched on, now the retractable dome is open;
	score the achievement with message "restoring power to the base";
	now the defense grid is full of lasery doom.

Carry out switching off the master power switch:
	now the main gate is closed;
	now the retractable dome is closed;
	now the defense grid is not full of lasery doom.

Report switching off the master power switch when the main door switch is switched on and the launch-hatch switch is switched on:
	say "As the displays shut down, you can see the main doors and the hangar's launch hatch each beginning to close. The light beams in the hangar also flicker and go out.";
	stop the action.

Report switching off the master power switch when the main door switch is switched on:
	say "As the displays shut down, you can see the main doors beginning to close and the light beams in the hangar flicker and go out.";
	stop the action.

Report switching off the master power switch when the launch-hatch switch is switched on:
	say "As the displays shut down, you can see the hangar's launch hatch beginning to close and the light beams in the hangar flicker and go out.";
	stop the action.

Report switching off the master power switch:
	say "As the displays go dark, you see the light beams in the hangar flicker and go out.";
	stop the action.

Report switching on the master power switch for the first time:
	say "The displays flicker to life. The old status screen appears momentarily - you can just make out the words 'POST-LAUNCH SHUTDOWN COMPLETE' before they turn to other feeds. [display initialization].";
	stop the action.

Report switching on the master power switch:
	say "The displays flicker to life. [display initialization].";
	stop the action.

Instead of switching off the defense-grid switch:
	if the defense-grid switch is broken:
		say "There isn't a switch there anymore.";
	otherwise:
		now the defense-grid switch is broken;
		say "The switch is stuck. You pull with all your might, and then the switch gives suddenly. Unfortunately, it hasn't actually switched off; the switch itself has crumbled to powder in your grip."

Instead of switching on the broken defense-grid switch, say "There isn't a switch there anymore."

Instead of attacking the defense-grid switch:
	if the defense-grid switch is broken:
		say "There isn't a switch there anymore.";
	otherwise:
		now the defense-grid switch is broken;
		say "You give the switch a short, sharp shock. Unfortunately, instead of loosening it, it disintegrates the switch entirely. The grid is stuck on."

[Some players tried to repair this switch with the wood splinters from the pit trap. While this isn't an acceptable solution (we want them to bypass it, not turn it off), we should at least acknowledge this as a good try.]
Instead of inserting the splintered wood into the broken defense-grid switch:
	say "Whatever's still left down there is beyond your ability to repair."

Does the player mean inserting the splintered wood into the broken defense-grid switch: it is very likely.
	
Instead of attacking a device:
	say "There's no reason to force it; simply toggling [the noun] will suffice."

Instead of lockforcing a device (called the widget) with the crowbar, try attacking the widget.

Instead of attacking the terminal:
	say "The command terminal is too useful to smash."

Instead of lockforcing the terminal with the crowbar:
	say "The command terminal is too useful to take apart."

Carry out switching on the main door switch:
	if the master power switch is switched on, now the main gate is open.

Carry out switching off the main door switch:
	if the master power switch is switched on, now the main gate is closed.

Report switching on the main door switch when the master power switch is switched on:
	say "On the displays, you see the massive main doors to the base slowly swing open.";
	stop the action.

Report switching off the main door switch when the master power switch is switched on:
	say "On the displays, you see the massive main doors to the base slowly swing shut.";
	stop the action.

Report switching on the main door switch when the master power switch is switched off:
	say "You switch [the noun] on, but with the master power switch off, there is no obvious effect.";
	stop the action.

Report switching off the main door switch when the master power switch is switched off:
	say "You switch [the noun] off, but with the master power switch off, there is no obvious effect.";
	stop the action.

Carry out switching on the launch-hatch switch:
	if the master power switch is switched on, now the retractable dome is open.

Carry out switching off the launch-hatch switch:
	if the master power switch is switched on, now the retractable dome is closed.

Report switching on the launch-hatch switch when the master power switch is switched on:
	say "On the displays, you see the hangar roof retract, revealing an inviting blue sky.";
	stop the action.

Report switching off the launch-hatch switch when the master power switch is switched on:
	say "On the displays, you see a dome close over the top of the hangar, roofing it off.";
	stop the action.

Report switching on the launch-hatch switch when the master power switch is switched off:
	say "You switch [the noun] on, but with the master power switch off, there is no obvious effect.";
	stop the action.

Report switching off the launch-hatch switch when the master power switch is switched off:
	say "You switch [the noun] off, but with the master power switch off, there is no obvious effect.";
	stop the action.

The distant-command-pit-hole-floor is a privately-named scenery thing in Command Center. The printed name is "[if the Tower Office is trapped and the nondescript door is open]pit[otherwise]floor[end if]". The description is "[if the Tower Office is trapped and the nondescript door is open]Most of the floor in the next room is gone, revealing an enormous pit. However, there is still more than enough room to walk around the edges; going east would be safe[otherwise]You see nothing special about the floor[end if]." Instead of doing something other than examining to the distant-command-pit-hole-floor when the Tower Office is trapped and the nondescript door is open, say "The pit is too far away." Instead of doing something other than examining to the distant-command-pit-hole-floor when the Tower Office is innocuous or the nondescript door is closed, say "Leave the floor alone. You have a job to do." Understand "pit" or "hole" or "floor" as the distant-command-pit-hole-floor.

Chapter 6 - Refueling the Rocket

The rocket can be fueled. The rocket is not fueled.

Peak Oil is a scene. Peak Oil begins when Base Infiltration ends. Peak Oil ends when the rocket is fueled.

When Peak Oil ends:
	score the achievement with message "refueling the rocket".

The large-handled key is a thing in the Pit Trap. Understand "large" and "handled" as the large-handled key. The description is "From the size and shape of this key, you'd guess it's for a vehicle of some kind[if not handled]. Why would Dr. Sinister throw the key down here? He must have wanted to get rid of it fast[end if]." The large-handled key is critical.

[Largely swiped from No Relation.]
The fuel truck is a vehicle in Isle SW. The description is "[if the fuel truck encloses the player]The truck's interior is functional, but not uncomfortable[otherwise]This truck looks like it's been around for awhile, but it's got the distinctive shape of a fuel truck. A hose is attached to the tanks on the back[end if][if the ignition is switched on]. Its engine hums with power[end if]." The initial appearance is "A fuel truck sits [if the ignition is switched on]humming[otherwise]quietly[end if] on the path here. Good to see the Doctor didn't destroy all his supplies when he left."

[We don't want the fuel truck to keep its initial appearance once it's moved.]
After going somewhere by the fuel truck: now the fuel truck is handled; continue the action.
After going somewhere with the fuel truck: now the fuel truck is handled; continue the action.

Before going inside when the fuel truck is in the location and the room inside from the location is nowhere and the fuel truck does not enclose the player: try entering the fuel truck instead.

Check taking the fuel truck: say "That's beyond even your considerable physique." instead.

Stealing is an action applying to one thing. Understand "steal [thing]" as stealing. Understand the command "jack" as "steal". Understand the command "swipe" as steal. Understand the command "hotwire" as "steal".

Carry out stealing:
	say "(first reclassifying as heroic appropriation of [the noun] in a time of great need)[command clarification break]";
	try taking the noun.
	
[And because that means commands like this are inevitable, we really ought to do this. Sadly, this breaks some error messages, so we're commenting it out unless we can extend the length of dictionary words by at least two letters.]
[Understand "appropriate [things]" or "heroically appropriate [things]" as taking.]

Instead of stealing the fuel truck when the fuel truck encloses the player, say "You, being a heroic sort, actually haven't studied the finer points of vehicle theft."

Instead of stealing something enclosed by the player, say "You can't steal something from yourself!"

The fuel truck is pushable between rooms.[* While rules about doing this are 'going with', the action itself is 'pushing to', which we have defined as hands-required behavior already.]

Before going to a room with the fuel truck for the first time, say "It takes some serious doing, but you manage to get enough leverage to get the truck rolling along its way."

Instead of pushing the fuel truck, say "The tires look like they can turn a bit, yes - however, without a direction to go in, this is mostly just an exercise in curiosity."

Entering the fuel truck is hands-required behavior.

The ignition is a device. The ignition is part of the truck. Instead of going by the truck when the ignition is switched off: say "You haven't started the truck yet." Instead of switching on the truck, try switching on the ignition. Instead of switching off the truck, try switching off the ignition. Instead of inserting the large-handled key into the ignition, try switching on the ignition.

After switching on the ignition, say "You put the large-handled key into the ignition and start the truck."

Instead of attacking the ignition when the player is enclosed by the truck, try stealing the truck. Instead of stealing the ignition when the player is enclosed by the truck, try stealing the truck. Instead of attacking the ignition, say "You can't reach the ignition from outside of the truck." Instead of stealing the ignition, say "You can't reach the ignition from outside of the truck."

Rule for printing the name of the fuel truck while not inserting or removing: say "fuel truck"; omit contents in listing.

Check switching on the ignition: if the fuel truck does not enclose the large-handled key, say "You don't have a key that starts the ignition." instead.
Carry out switching on the ignition:
	now the large-handled key is part of the ignition;
	now hands-free challenge is false.
	
Carry out switching off the ignition:
	now the large-handled key is carried by the player;
	now hands-free challenge is false.

Instead of taking the large-handled key when the large-handled key is part of the ignition, say "You can't take the key out until you've parked the truck."

Before switching on the ignition when the fuel truck does not enclose the player:
	say "(first entering the fuel truck)[command clarification break]";
	silently try entering the fuel truck;
	if the fuel truck does not enclose the player, stop the action.

Before switching off the ignition when the fuel truck does not enclose the player:
	say "(first entering the fuel truck)[command clarification break]";
	silently try entering the fuel truck;
	if the fuel truck does not enclose the player, stop the action.

Does the player mean turning the large-handled key when the  fuel truck encloses the player: it is very likely.
Instead of turning the large-handled key when the fuel truck encloses the player:
	if the large-handled key is part of the ignition, try switching off the ignition;
	otherwise try switching on the ignition.

Instead of fly-verbing in the fuel truck, say "You can't fly in here; it's too cramped."

Instead of going to the Minions' Chambers by the truck, say "The fuel truck won't fit through that door."
Instead of going to the Minions' Chambers with the truck, say "The fuel truck won't fit through that door."

Instead of going to a sea-room by the truck, say "This truck cannot transform into a boat or a submarine. Best to keep it on dry land."

Instead of going to a sea-room with the truck, say "This truck cannot transform into a boat or a submarine. Best to keep it on dry land."

Before going through a closed door (called the obstacle) by the truck, say "The truck is full of heinously flammable substances. You have no intention of smashing it into [the obstacle]." instead.

Before going through a closed door (called the obstacle) with the truck, say "The truck is full of heinously flammable substances. You have no intention of smashing it into [the obstacle]." instead.

Check going through the full of lasery doom defense grid by the truck:
	if the defense grid is recognized as hazardous, say "No way. You saw what those beams did to [the grid victim]." instead;
	say "Those beams don't look friendly. You're not going to risk driving through them." instead.

Check going through the full of lasery doom defense grid with the truck:
	if the defense grid is recognized as hazardous, say "No way. You saw what those beams did to [the grid victim]." instead;
	say "Those beams don't look friendly. You're not going to risk driving through them." instead.

Instead of going up by the truck, say "Not inside the truck, you won't."

Instead of going up with the truck, say "While you can probably push the truck from place to place, you aren't going to be deadlifting it."

Understand "drive [text]" as a mistake ("[bracket]To use a vehicle, simply ENTER it and then use normal move commands.[close bracket]")

Instead of opening the fuel truck:
	if the fuel truck encloses the player:
		try exiting;
	otherwise:
		try entering the fuel truck.

The hose is part of the fuel truck. The description is "A long rubber hose is connected to the fuel tanks." Understand "fuel tanks" or "rubber" or "tanks" or "fuel tank" or "tank" as the hose. The hose is critical. Instead of turning the hose, reject hose detachment. Instead of untying generally the hose, reject hose detachment. Instead of taking the hose, reject hose detachment. Instead of untying the hose from the fuel truck, reject hose detachment. Instead of untying the hose from something, say "The hose isn't attached to that." Instead of cutting the hose, say "That would be both dangerous, and serve no good purpose."

To reject hose detachment:
	if the rocket is in the location:
		try fueling the rocket;
	otherwise:
		say "The hose is part of the fuel truck; you'll need to get the truck to the same place as whatever it is you want to refuel."

Untying generally is an action applying to one thing. Understand "untie [something]" as untying generally. Untying it from is an action applying to two things. Understand "untie [something] from [something]" as untying it from. Understand the commands "hook" and "connect" as "tie". Understand the commands "unhook", "disconnect", and "detach" as "untie".

Check untying generally (this is the block untying generally rule): say "[The noun] [is-are] not something you can untie." instead. Check untying it from (this is the block untying rule): say "[The noun] [is-are] not something you can untie." instead.

Fueling is an action applying to one thing. Understand "fuel [something]" or "refuel [something]" as fueling.

Instead of tying the hose to something, try fueling the second noun. Before putting the hose on something, try fueling the second noun instead. Before inserting the hose into something, try fueling the second noun instead.

The first check fueling rule: If the fuel truck is not in the location, say "There doesn't seem to be any source of fuel handy. You'll need to find a tanker or something." instead.
Report fueling: say "That doesn't need refueling.";

Check fueling yourself: say "You don't run on that kind of fuel." instead.
Check fueling the fuel truck: say "The truck's already got a full tank." instead.
Check fueling the hose: say "The hose is already attached to the truck's fuel tank." instead.
Check fueling the fueled rocket: say "You've already fueled the rocket." instead.
Check fueling when the player is inside the fuel truck: say "You'll have to get out of the fuel truck to actually do any refueling." instead.

After fueling the rocket:
	now the rocket is fueled;
	say "You hook the hose up to the rocket, refuel its tanks, and replace the hose on the side of the truck. It should be ready for launch now."

Understand "gas" or "engine" as the fuel truck.

Instead of drinking the fuel truck, say "It's got a perfectly good pump. Siphoning rocket fuel by mouth is just going to end in tears."

Instead of drinking the hose, say "It's got a perfectly good pump. Siphoning rocket fuel by mouth is just going to end in tears."

Driver's License is a scene. Driver's License begins when play begins. Driver's License ends when the ignition is switched on or the location of the fuel truck is not Isle SW.

When Driver's License ends:
	score the achievement with message "getting the fuel truck moving".

Part 3 - Rocketry

Chapter 1 - The Furniture

The Rocket Interior is west of the Hangar Catwalk. "The rocket interior is small, but isn't quite to the level of 'cramped'. An acceleration chair takes up most of the floor, and a friendly-looking control panel sits in front of it[if the Hangar Catwalk is adjacent to the Rocket Interior]. The exit hatch leads east to the hangar[otherwise if the Station Rocketway is adjacent to the Rocket Interior]. The way out leads to the space station[end if]."

The interior-airlock is a privately-named scenery thing in Rocket Interior. Understand "airlock" as the interior-airlock. The printed name is "airlock". Instead of entering the interior-airlock, try going outside. Instead of opening or closing the interior-airlock, say "The airlock seems to be under automatic control. Launch and docking sequences should handle it on its own." The description of the interior-airlock is "[if the room outside from the location is nothing]This airlock keeps the atmosphere in and the boundless depths of space out[otherwise if the room outside from the location is visited]The airlock stands open, leading out to the [printed name of the room outside from the location in lower case][otherwise]The airlock stands open, leading out to parts unknown[end if]." Instead of searching the interior-airlock, try examining the interior-airlock.

After going to the Rocket Interior:
	say "You enter the rocket.";
	continue the action.

After going from the Rocket Interior:
	say "You get out of the rocket.";
	continue the action.

Outside of the Rocket Interior is the Hangar Catwalk.

The acceleration chair is an enterable scenery supporter in the Rocket Interior. Understand "pilot's" or "couch" or "seat" as the acceleration chair. The description is "It's soft and fluffy and looks like it's got receptacles for all kinds of restraints." Instead of pushing, pulling, touching, kissing, or squeezing the acceleration chair, say "It gives gently beneath your touch, but continues to provide full support." Report entering the acceleration chair: say "As you sit in the acceleration chair, a variety of webs and restraints affix you to the chair."; stop the action.

Does the player mean entering the acceleration chair: it is very likely.

Instead of drinking the energy drink when the location is the Rocket Interior, say "It may not quite be 'cramped', but it's close enough that you can't fly properly." Instead of going to the Rocket Interior while the player is flying, say "The doorway is too narrow to enter while flying."

Chapter 2 - The Controls

A ship-control is a kind of thing. Before doing something other than examining with a ship-control when the player is not on the acceleration chair, say "You can't really do much with the controls when you aren't in the pilot's seat." instead.

The control panel is a scenery thing in the Rocket Interior. Understand "controls" as the control panel. The description is "It's clearly designed to be user-friendly; there's nothing on it right now but a [if the control joystick is part of the control panel]control joystick[otherwise]big green button marked 'LAUNCH'[end if]." Before doing something other than examining with the control panel when the player is not on the acceleration chair, say "You can't really do much with the controls when you aren't in the pilot's seat." instead.

The launch button is a ship-control. The launch button is part of the control panel. The description is "It says 'LAUNCH' on it, as if inviting you to push it." Understand "big" and "green" as the launch button.

The control joystick is a ship-control. The description is "It's a simple joystick. It will let you control the flight of the rocket as easily as you would move in any direction. The direction away from you is marked WEST." 

The big green button is a ship-control. The description is "Now that you're docked, the LAUNCH button has re-emerged." Check pushing the big green button: say "But you haven't captured Dr. Sinister yet!" instead. The printed name is "launch button". Understand "launch" as the big green button.

[In-universe, the launch button and the big green button are the same button; indeed, they both have the same name and react to the same nouns. However, the 'big green button' is the one that appears once docking is completed. It's easier to have two objects here than it is to have scene-completion tests at every opportunity.]

Instead of pushing, pulling, or turning the joystick, give joystick help. Instead of moving the joystick relatively, give joystick help.

Before pushing the joystick to: 
	give joystick help, as an additional suggestion;
	try going the second noun instead.

Understand "stick" or "yoke" as the control joystick.

To say sample flight command:
	let X be an indexed text;
	let X be "go west";
	if the noun is a direction, now X is "go [noun]";
	if the second noun is a direction, now X is "go [second noun]";
	say "[X in upper case]".

To give joystick help, as an additional suggestion: say "[bracket][if as an additional suggestion]You may simply command the game to [otherwise]To move the ship, just use commands like [end if][sample flight command].[close bracket][line break]"

Check pushing the launch button:
	if the retractable dome is closed:
		activate the Table of Hatch Opening Hints;
		if the rocket is not fueled, activate the Table of Refueling Hints;
		say "You hear a chime, and a pleasant genderless voice comes from the panel.[paragraph break]'I'm sorry, but [if the rocket is not fueled]this rocket has not yet been fueled, and thus cannot launch. Furthermore, [end if]safety protocols require me to note that you cannot take off while the launch hatch is closed.'" instead;
	otherwise if the rocket is not fueled:
		activate the Table of Refueling Hints;
		say "You hear a chime, and a pleasant genderless voice comes from the panel.[paragraph break]'This rocket has not yet been fueled, and thus cannot launch.'" instead.

After pushing the launch button:
	say "As you press the launch button, machinery rumbles to life underneath you. You hear a chime, and a pleasant genderless voice comes from the panel.[paragraph break]'Good morning, O most worthy overlord. It's too bad that it has become necessary to flee your lovely island base. I will be your autopilot today. Please sit tight while I take us to your orbital redoubt.'[paragraph break]Well, that's a good sign, at least. You relax a bit while the landscape dwindles below you and the sky darkens above you.[paragraph break]After a few more minutes, the autopilot chimes again. 'We're nearly here. I've put you into an east-to-west orbit approaching the station, but you will have to perform the final approach yourself.' The launch button recesses into the control panel, and a control stick emerges. 'I will, as always, keep your orbit stable as you move. Docking arms will engage once you are stopped at location (1, 0, 0).'[paragraph break]Displays bloom around the window, indicating your present position and velocity. The station itself is now clearly visible to the west."; 
	remove the launch button from play;
	now the joystick is part of the control panel;
	move the rocketry displays to the Rocket Interior;
	now the description of the windshield window is "Out the window, the stars shine harshly, when you can make them out at all over the Earth's own glare. [if craft e-pos is greater than zero]Above it, you see Sinister's space station, a spinning ring stabilized by a static set of ancillary struts and docking arms[otherwise]Your view is unobstructed, as the space station is behind you at the moment[end if][first time]. This is a first for you, actually - generally anything that's a threat in the stratosphere or above gets handled by someone like [one of]Star R Star[or]the Ethereal Wonder[or]Justice-Bot[purely at random].[paragraph break]Heh. Something you can actually thank Dr. Sinister for, you guess[only].";
	change the east exit of the Rocket Interior to nowhere;
	change the outside exit of the Rocket Interior to nowhere.

Some rocketry displays are a scenery thing. The description is "[bracket]The displays are provided continuously in the status line at the top of the screen[if status-line-free play is true] and in brackets after every move. To restrict it to just the status line, type STATUS OFF[otherwise]. If your interpreter does not support this, type STATUS ON to duplicate it here in the main window[end if].[close bracket][line break]".

The windshield window is a scenery thing. Understand "station" or "space station" as the window when Docking is happening. The printed name is "window". The description is "[if the retractable dome is closed]All you see is the ceiling of the hangar[otherwise]The blue sky opens invitingly before you[end if]."

Chapter 3 - Flight mechanics

Docking is a scene. Docking begins when the room east from the Rocket Interior is nothing.

Craft u-pos is a number that varies. Craft u-pos is zero.
Craft n-pos is a number that varies. Craft n-pos is zero.
Craft e-pos is a number that varies. Craft e-pos is ten.
Craft n-vel is a number that varies. Craft n-vel is zero.
Craft e-vel is a number that varies. Craft e-vel is zero.
Last u-pos is a number that varies. Last u-pos is zero.
Last n-pos is a number that varies. Last n-pos is zero.
Last e-pos is a number that varies. Last e-pos is ten.
Last n-vel is a number that varies. Last n-vel is zero.
Last e-vel is a number that varies. Last e-vel is zero.
Last z-move is a number that varies. Last z-move is zero.

Docking ends when we are properly docked.

To decide whether we are properly docked:
	if craft u-pos is zero and craft n-pos is zero and craft e-pos is one and craft n-vel is zero, decide yes;
	decide no.

When Docking ends:
	say "You hear a loud clang as the station's docking arms steady the ship. The autopilot chimes, and announces, 'Here we are. Thank you for flying with me, sir.' The control stick folds back into the control panel, revealing the launch button once again.[paragraph break]A few moments later, the exit hatch opens, revealing a walkway out into the station proper.";
	remove the joystick from play;
	now the big green button is part of the control panel;
	now the left hand status line is "[the player's surroundings]";
	remove the rocketry displays from play;
	now the description of the windshield window is "It looks like the station is over the middle of the Pacific Ocean.";
	change the outside exit of Rocket Interior to Station Rocketway;
	change the up exit of Rocket Interior to Station Rocketway;
	change the down exit of Station Rocketway to Rocket Interior.

When Docking begins:
	select a new approach vector;
	now the left hand status line is "POS: ([craft e-pos], [craft n-pos], [craft u-pos])  VEL: ([craft e-vel], [craft n-vel], 0)";
	deactivate the Table of Rocket Launch Hints;
	deactivate the Table of Refueling Hints;
	deactivate the Table of Hatch Opening Hints;
	deactivate the Table of Defense Grid Hints;
	activate the Table of Stardock Hints.

To select a new approach vector:
	now craft u-pos is zero;
	now craft e-pos is ten;
	now craft n-vel is zero;
	now craft e-vel is zero;
	now craft n-pos is a random number between 1 and 10;
	increase the approach vector count by 1;
	now the target time is 8 + craft n-pos;
	if a random chance of 1 in 2 succeeds, now craft n-pos is craft n-pos * -1;
	now last z-move is zero;
	now last n-pos is craft n-pos;
	now last e-pos is craft e-pos;
	now last u-pos is craft u-pos;
	now last n-vel is craft n-vel;
	now last e-vel is craft e-vel.

To decide which number is the station's Manhattan distance:
	if craft u-pos is not zero, decide on 9999;
	if craft n-vel is not zero, decide on 9999;
	let result be 0;
	if craft n-pos is less than zero, decrease result by craft n-pos; otherwise increase result by craft n-pos;
	if craft e-pos is less than zero, decrease result by craft e-pos; otherwise increase result by craft e-pos;
	decide on result.

Every turn during Docking (this is the orbital mechanics rule):
	now last n-pos is craft n-pos;
	now last e-pos is craft e-pos;
	now last u-pos is craft u-pos;
	now last n-vel is craft n-vel;
	now last e-vel is craft e-vel;
	increase craft n-pos by craft n-vel;
	increase craft e-pos by craft e-vel;
	now craft e-vel is craft u-pos;
	if craft n-pos is zero and craft e-pos is zero and craft u-pos is zero:
		if craft n-vel is not zero:
			say "The ship shifts suddenly, jostling you in your acceleration chair. The autopilot chimes and announces, 'Negating lateral movement for collision avoidance.'[paragraph break]";
			decrease craft n-pos by craft n-vel;
			now craft n-vel is zero;
		otherwise if last z-move is not zero:
			say "Your restraints bite into you as the acceleration suddenly changes. The autopilot chimes and announces, 'Collision alert. Negating last orbit change.'";
			decrease craft e-pos by craft e-vel;
			decrease craft u-pos by last z-move;
			now craft e-vel is craft u-pos;
		otherwise:
			say "You have somehow managed to trick the autopilot into colliding with the space station, destroying both you and Dr. Sinister. I'm going to kill you now, but this is a bug! Please let me know about this - as of this writing I can be reached at [developer email].";
			end the story saying "Woe and fiery doom ensue";
	otherwise if the station's Manhattan distance is one and craft e-pos is not one:
		say "The autopilot chimes. 'Please remember that the docking point for your space station is on the eastern end. Bring your ship to a stop at position (1, 0, 0).'";
	otherwise if the craft n-pos is less than -20 or the craft n-pos is greater than 20 or the craft e-pos is less than -20 or the craft e-pos is greater than 20:
		say "The autopilot chimes. 'You have left the docking area. Please wait while I reorient your ship.' A few minutes later you are again facing the docking port of Dr. Sinister's space station. 'Relinquishing control to manual once again. Sobriety treatments will be available in the station's sick bay. Please be careful!'";
		select a new approach vector;
	otherwise:
		if craft n-pos is zero and last n-pos is not zero:
			if craft u-pos is zero and last u-pos is not zero and not we are properly docked:
				say "You are now aligned with the station's latitude and height. As you share an orbit with the station, you are maintaining longitudinal distance.";
			otherwise:
				say "You are now aligned with the station's latitude.";
		otherwise if craft n-pos is not zero and last n-pos is zero:
			if craft u-pos is zero and last u-pos is not zero and not we are properly docked:
				say "You now share an orbit with the station, and are maintaining longitudinal distance. However, you are now drifting away from the station's latitude.";
			otherwise:
				say "You are now drifting away from the station's latitude.";
		otherwise if craft e-pos is zero and last e-pos is not zero:
			say "You are now aligned with the station's height.";
		otherwise if craft e-vel is less than zero and last e-vel is zero:
			if craft e-pos is greater than zero:
				say "As you are in a tighter orbit, you are now catching up to the station's longitude.";
			otherwise:
				say "As you are in a tighter orbit, you are now drifting away from the station's longitude.";
		otherwise if craft e-vel is greater than zero and last e-vel is zero:
			if craft e-pos is less than zero:
				say "As you are in a broader orbit, you are now catching up to the station's longitude.";
			otherwise:
				say "As you are in a broader orbit, you are now drifting away from the station's longitude.";
	now last z-move is zero.

Instead of exiting during Docking, say "Best to stay in the acceleration chair while the ship is in flight."

Instead of going during Docking (this is the spaceflight rule):
	if the noun is outside:
		say "Best to stay in the acceleration chair while the ship is in flight.";
	otherwise if the noun is inside:
		say "You're already in the acceleration chair.";
	otherwise unless there is a vector of the noun in the Table of Thrust Vectors:
		say "The joystick can only thrust you in the four cardinal directions.";
	otherwise:
		choose the row with a vector of the noun in the Table of Thrust Vectors;
		let dz be 0 minus the x entry;
		if dz is 1 and craft u-pos is 3:
			say "The controls do not respond. Apparently, the autopilot won't let you fly that high.";
		otherwise if dz is -1 and craft u-pos is -3:
			say "The controls do not respond. Apparently, the autopilot doesn't want to de-orbit here.";
		otherwise if the y entry is the craft n-vel and the y entry is not zero:
			say "The controls do not respond; you're already cruising in that direction.";
		otherwise:
			increase craft n-vel by the y entry;
			increase craft u-pos by dz;
			now the last z-move is dz;
			say "You [message entry]."

Understand "thrust" or "thruster" or "thrusters" or "fire thruster/thrusters" as the west while Docking is happening.
Understand "fire retro/retrograde rocket/rockets" or "fire retro/retros" or "fire retrorockets" or "fire retro-rockets" or "fire retrorocket" or "fire retro-rocket" or "retro/retrograde rocket/rockets" or "retro" or "retros" or "retrorocket" or "retrorockets" or "retro-rocket" or "retro-rockets" as the east while Docking is happening.

The spaceflight rule is listed first in the instead rules.

Table of Thrust Vectors
vector		x	y	message
north		0	-1	"thrust laterally to your orbit"
south		0	1	"thrust laterally to your orbit"
east		1	0	"fire your retros, falling into a slightly tighter orbit"
west		-1	0	"thrust, pushing yourself out into a broader orbit"

Chapter 4 - Ratings

The approach vector count is a number that varies. The approach vector count is zero.
The target time is a number that varies. The target time is 9999.

When Docking ends:
	score the achievement with message "reaching the station";
	if the approach vector count is less than two:
		let X be ( 60 * the hours part of the time since Docking began ) + the minutes part of the time since Docking began;
		if X is at most the target time:
			score the achievement with message "ace flying";
			complete the "LORD OF THE SKIES" challenge;
		otherwise:
			score the achievement with message "competent flying";

Chapter 5 - Cheating - not for release

[We don't decide where you're going to be until the last minute. Because of this, any additional random events or text variation added to the early game changes where you will be launched, even with fixed randomness. These cheat commands help me stay sane with respect to the docking sequence by skipping it for Skein regressions.]

Cheat-docking is an action applying to nothing. Understand "cheat dock" or "dock cheat" as cheat-docking.

Check cheat-docking:
	if Docking is not happening, say "This cheat is unavailable at this time." instead.

Carry out cheat-docking:
	now craft e-pos is 1; now craft n-pos is 0; now craft u-pos is 0; now craft e-vel is 0; now craft n-vel is 0;
	say "You expertly dock the ship with the station."

Part 4 - Confrontation

Chapter 1 - The Map

Section 1 - Rooms

Station Rocketway is a room. "Dr. Sinister's space station seems to be reasonably well put together. This extensible walkway fits snugly against your rocket's airlock. Since the station is spinning, that direction feels like 'down'. The station proper [if unvisited]awaits you[otherwise]lies[end if] up above, towards the center."

The station-airlock is a privately-named scenery thing in Station Rocketway. Understand "airlock" as the station-airlock. The printed name is "airlock". Instead of entering the station-airlock, try going down. Instead of opening or closing the station-airlock, say "The airlock seems to be under automatic control. Launch and docking sequences should handle it on its own." The description of the station-airlock is "The airlock leads back down into the rocket."

The entrance ladder is fixed in place thing in Station Rocketway. "[if retracted]A ladder is just visible up at the top of the chamber[otherwise]A ladder leads up here[end if]." The entrance ladder can be retracted. The entrance ladder is retracted. The description of the entrance ladder is "[if retracted]You can only just see it at the top of the chamber[otherwise]It looks sturdy, and it takes up most of the rocketway[end if]."

Instead of climbing the entrance ladder, try going up.

Before drinking the energy drink when flight is cramped:
	say "The ladder is taking up space you'd need to fly. You'll have to climb it like a normal person." instead.

To decide if flight is cramped:
	if the location is the Station Rocketway and the entrance ladder is not retracted, decide yes;
	if the location is the Vestibule, decide yes;
	decide no.

Before going up from the Station Rocketway:
	if yourself is flying and the entrance ladder is not retracted:
		say "The ladder is taking up space you'd need to fly. You'll have to climb it like a normal person." instead;
	otherwise if the entrance ladder is retracted:
		if yourself is grounded:
			say "You can't reach the ceiling from here, and the ladder is well out of reach." instead;
		otherwise if yourself is flying:
			say "With some trepidation, you work your way up the access tube. The spin of the station is not playing well with your sense of balance, and you carom off the walls a few times on your way to the top of the chamber.[paragraph break]But you do make it, and a hand closes on the bottommost rung of the ladder. Your weight pulls the ladder down to the bottom of the chamber, taking you with it.";
			now the entrance ladder is not retracted;
			now yourself is grounded;
			now the energy of yourself is zero;
			stop the action.

Before going nowhere from the Vestibule, say "All the doors are firmly sealed except for the one below you[if the game is afoot] and the passage inwards[end if]." instead.

A starship pod is a kind of room.

An access corridor is a kind of starship pod. An access corridor has a number called the quadrant. The quadrant of an access corridor is usually 0. The printed name of an access corridor is usually "Access Corridor, Quadrant [quadrant]". The description of an access corridor is usually "[default access corridor description]".

Rule for touching down on a starship pod:
	now the player is grounded;
	say "You land, as elegantly as you can manage in spun gravity[if the energy of yourself is greater than 2][shakes][end if]."

Rule for touching down on Station Rocketway:
	now the player is grounded;
	say "You land, as elegantly as you can manage in spun gravity[if the energy of yourself is greater than 2][shakes][end if]."

Definition: A room is main-pod if it is not an access corridor.

After going to an access corridor from a main-pod room:
	say "[one of]You duck into the maintenance tunnels. Hopefully this will get you closer to Dr. Sinster's inner sanctum[or]You duck back into the tunnels[stopping].";
	continue the action.

After going to a main-pod room from an access corridor:
	say "[one of]You emerge from the maintenance tunnels back into the starbase proper[or]You climb back into the starbase's main quarters[stopping].";
	continue the action.

To say default access corridor description:
	say "This narrow access tunnel seems to ring the entire station. A small sign near a hatch on the ceiling reads 'QUADRANT [quadrant of the location]: [printed name of the room up from the location in upper case]'. The corridor continues both spinwards and antispinwards.[no line break]".

The small ceiling hatch sign is a backdrop. The ceiling hatch sign is in AC 1, AC 2, AC 3, and AC 4. The description is "The sign near the hatch reads 'QUADRANT [quadrant of the location]: [printed name of the room up from the location in upper case]'." Instead of opening or entering the small ceiling hatch sign, try going up. Instead of closing the small ceiling hatch sign, say "The hatch seems to be mildly spring-loaded, so it closes on its own after someone goes through it."

The maintenance tunnel hatch is a backdrop. The maintenance tunnel hatch is in Recreation Pod, Supply Pod, and Crew Pod. The description is "This small hatch leads down into the maintenance tunnels." Understand "tunnels" as the maintenance tunnel hatch. Instead of opening or entering the maintenance tunnel hatch, try going down. Instead of closing the maintenance tunnel hatch, say "The hatch seems to be mildly spring-loaded, so it closes on its own after someone goes through it."

Understand "spinwards" or "spinward" as the east when the location is a starship pod. Understand "antispinwards" or "asw" or "antispin" or "antispinward" as the west when the location is a starship pod. Before going south in a starship pod, try going east instead. Before going southwest in a starship pod, try going east instead.[* These last two are so that 's' and 'sw' are treated as synonyms of 'spinwards'.]

Understand "porthole" as the east when the location is the Vestibule. Understand "porthole" as the west when the location is the Vestibule. Understand "porthole" as the outside when the location is a starship pod.

To refuse unlocking portholes to the (way - a direction):
	if the location is the Vestibule and (the way is east or the way is west or the way is south or the way is southwest or the way is outside):
		say "The pressure seals on these portholes don't let you get any purchase.";
	otherwise unless the room the way from the location is a room:
		say "There isn't a porthole in that direction.";
	otherwise:
		say "The way [way] is already open."

Rule for printing the name of the east when the location is a starship pod: say "spinward".
Rule for printing the name of the south when the location is a starship pod: say "spinward".
Rule for printing the name of the southwest when the location is a starship pod: say "spinward".
Rule for printing the name of the west when the location is a starship pod: say "antispinward".

Before lockforcing a direction (called the way) with the crowbar when the location is a starship pod: refuse unlocking portholes to the way; stop.

Before unlocking a direction (called the way) with the crowbar when the location is a starship pod: refuse unlocking portholes to the way; stop.

Before attacking a direction (called the way) when the location is a starship pod: refuse unlocking portholes to the way; stop.

Before attacking a direction (called the way) with something when the location is a starship pod: refuse unlocking portholes to the way; stop.

Before opening a direction (called the way) when the location is a starship pod: refuse unlocking portholes to the way; stop.

Instead of going to an access corridor while flying, say no flight in access corridors.
Before drinking the energy drink when the location is an access corridor, say no flight in access corridors instead.
Before going inside when the location is an access corridor, try going up instead.
Instead of exiting when the location is an access corridor, try going up.
Before going outside when the location is an access corridor, try going up instead.
Before going inside when the room down from the location is an access corridor and the room inside from the location is nowhere, try going down instead.

To say no flight in access corridors: say "The access corridors are too cramped to permit flight."

The Vestibule is above the Station Rocketway. The Hub is north of the Vestibule, east of the Crew Pod, west of the Supply Pod, and south of the Recreation Pod. The Central Bridge is above the Hub.

The Vestibule is a starship pod. The Crew Pod is a starship pod. The Supply Pod is a starship pod. The Recreation Pod is a starship pod.

Outside from the Vestibule is the Hub. Outside from the Crew Pod is the Hub. Outside from the Supply Pod is the Hub. Outside from the Recreation Pod is the Hub. Inside from the Hub is nowhere.

AC 1 is an access corridor with quadrant 1. Up from AC 1 is the Vestibule.
AC 2 is an access corridor with quadrant 2. AC 2 is east from AC 1 and below the Supply Pod.
AC 3 is an access corridor with quadrant 3. AC 3 is east from AC 2 and below the Recreation Pod.
AC 4 is an access corridor with quadrant 4. AC 4 is east from AC 3, west from AC 1, and below the Crew Pod.

The description of Vestibule is "This is actually pretty swank for a space station. Every gram counts in rocketry, yet not only has the Doctor lifted up a full set of draperies for the walls, the floor here is even carpeted.[paragraph break]Portholes lead spinward, antispinward, out, and down. All but the down porthole are firmly sealed[if the game is afoot]. A passage leads inward to darkness[end if]."

The description of Crew Pod is "Dr. Sinister appears to keep better care of his minions when they're in outer space. The cots in this crew section look a lot softer than the bunks back on the island.[paragraph break]A doorway leads out to the center of the station, while an access hatch leads back down into the corridors."

The description of Supply Pod is "Dr. Sinister continues to show his maniacal levels of organization. This pod is lined with storage lockers packed tightly together and with no visible seams. The only gap is the doorway out to the center of the station. The way down to the maintenance tunnels is also clear."

The description of Recreation Pod is "[unless we have examined the bookcases]Dr. Sinister clearly retains a higher class of minion than your normal supervillain[otherwise]Well, at least Dr. Sinister tries to better the lot of his minions[end if]; this rec room is full of bookcases, with a game console in one corner for more interactive pursuits. A kitchen nook with an integrated sink and coffeemaker protrudes from the wall opposite the books.[paragraph break]A doorway leads out to the center of the station, while an access hatch leads back down into the corridors."

The description of Hub is "You feel noticably lighter in this section of the station; it must be a bit closer to the center. Corridors lead off in orthogonal directions, and a ladder leads up out of sight."

The description of Central Bridge is "This is it - Dr. Sinister's sanctum sanctorum! Given much of his reputation you'd have originally expected this to be some kind of monument to evil, but after following him through his compounds, you're not surprised to find that even here he runs his plots from an office that is a study in moderate and understated luxury.[paragraph break]You [italic type]do[roman type] kind of wonder how he managed to get a solid mahogany desk into orbit, though."

Instead of going nowhere from the Hub, say "It's an obvious fiction, but let's just pretend that those four orthogonal exits are compass directions, OK?"

The Starbase is a region. Vestibule, Hub, Crew Pod, Supply Pod, Recreation Pod, Central Bridge, AC 1, AC 2, AC 3, and AC 4 are in Starbase.

Some pressure seals are a scenery thing in the Vestibule. Understand "seal" as the pressure seals. The description is "These portholes are sealed completely airtight." Instead of attacking the pressure seals, say "The seal is far too sturdy for you to make an impact." Understand the command "club" as "attack".[* Yes, we're 12. What can I say?]

Section 2 - Doors and such

To decide if the game is afoot:
	if the room inside from the Vestibule is nowhere:
		decide no;
	otherwise:
		decide yes.

The dark passage is a backdrop. The description of the dark passage is "A passage leads into darkness where the draperies once were." Instead of entering the passage in the Vestibule, try going inside. Instead of entering or climbing the passage, try going down. Understand "tunnel" or "tunnels" or "passages" or "passageway" or "passageways" or "maintenance" as the dark passage. The dark passage is ambiguously plural.

Some hanging draperies are an ambiguously plural scenery thing in the vestibule. The description is "Fancy curtains bedeck the walls of this room. At least they're light; they'd probably have packed well in the rocket[unless the game is afoot]. One of them seems to be billowing a little[otherwise]. The gap you tore in them leads to the maintenance passageway[end if]."

Understand "drape" or "drapes" or "curtain" or "curtains" or "drapery" or "walls" as the draperies.

Understand "billow" or "billowing" as the draperies when not the game is afoot.[* My kingdom for a 'unless the game is afoot'. So it goes.]

Instead of taking the draperies:
	if the game is afoot:
		say "There's nothing else of interest behind the draperies.";
	otherwise:
		say "You pull down the billowing curtain, revealing a passageway leading into darkness! It must head to the maintenance tunnels.";
		reveal the passage.
		
Instead of looking under or searching or pulling or opening the draperies:
	if the game is afoot:
		say "There's nothing else of interest behind the draperies.";
	otherwise:
		say "Checking behind the billowing curtain, you find a passageway leading into darkness! It must head to the maintenance tunnels.[paragraph break]You pull down the curtain covering it and stow it in your belt.";
		reveal the passage.
		
Instead of touching the draperies, say "Feels like satin."

Does the player mean doing something with the draperies: it is likely.

Some torn curtains are an improbable inflammable thing. The description of the torn curtains is "You tore this off of the curtains in the vestibule. It's about 20 square feet of cloth." Understand "drape" or "curtain" or "drapery" or "draperies" or "drapes" or "cloth" as the torn curtains. The torn curtains are ambiguously plural.

Instead of touching the torn curtains, say "Feels like satin."

Definition: A room is passaged if it is the Vestibule.[* Movable backdrops are incredibly annoying to work with right now. This circumlocution lets us move a scenery backdrop into place only after the fact.]

To reveal the passage:
	change the inside exit of the Vestibule to AC 1;
	now the torn curtains are in the Hummingbelt;
	move the dark passage backdrop to all passaged rooms.

Section 3 - Scenery

The carpet is a scenery thing in the Vestibule. The description is "The carpet is a tastefully muted navy blue plush." Instead of touching the carpet, say "It feels like it wouldn't be out of place in any office building." Understand "floor" as the carpet. Instead of attacking or looking under the carpet, say "This carpet is wall-to-wall (well, OK, bulkhead-to-bulkhead) - there isn't any edge to get a grip on."

Some bookcases are a scenery supporter in the Recreation Pod. The description is "On second thought, none of these books have been disturbed in a very long time. Maybe his goons aren't as literate as you thought." Understand "bookshelf" or "bookcase" or "shelf" or "bookshelves" or "shelves" as the bookcases.

Some books are on the bookcases. The description is "All the books here are covered in a noticable layer of dust." Understand "dust" or "book" as the books. Instead of taking or opening the books, say "No time to read now."

For printing a locale paragraph about the bookcases:
	set the locale priority of the books to 0;
	continue the activity.

The game console is a scenery thing in the Recreation Pod. Understand "case" as the game console. The description is "Reasonably modern, but locked in a case for the moment. No gameplaying while duty calls, you suppose." Instead of doing something other than examining with the console, say "You don't have time to play games either."

The kitchen nook is a scenery container in the Recreation Pod.

The coffeemaker is in the kitchen nook. Understand "coffee maker" and "maker" and "coffee machine" and "machine" and "burner" and "receptacle" and "pot" and "coffeepot" and "coffee pot" and "heating" and "element" as the coffeemaker. Instead of taking the coffeemaker, say "The coffeemaker is part of the kitchen nook." The description is "This coffee machine is part of the wall itself in the kitchen nook - it is a receptacle carved into the wall with a burner at the bottom to heat a coffee pot - if that. It looks like the receptacle itself might double as the pot[if ruined]. You've cut holes into it and wrenched out various important-looking bits of it[end if]." Instead of touching the coffeemaker, say "You feel along the edges of the coffee machine, but you detect no seams. It must have been designed directly as part of the station."

Understand "make coffee/decaf" as a mistake ("[if the location is not the Recreation Pod]You don't make a habit of carrying coffee around; it's non-caloric and as such does not grant you the kind of power you need[otherwise if the coffeemaker is ruined]Nobody's making coffee with that thing anymore[otherwise if the coffeemaker is poisoned and the henchmen are not sedated]The guards seem to be making coffee on their own rounds; you needn't interfere[otherwise if the coffeemaker is poisoned]You've drugged the guards already; there's nothing more to do here[otherwise]You can't actually find where the coffee itself is; the burner is obvious, but you can't find where the beans themselves are[end if].")

The coffee-proxy is a privately-named scenery thing in the kitchen nook. The printed name is "coffee". The description is "You're not actually sure where the coffee grounds are, but at least you can tell where they go." Understand "coffee" and "beans" and "grounds" and "brew" and "basket" as the coffee-proxy.  Instead of attacking the coffee-proxy, try attacking the coffeemaker. Instead of attacking the coffee-proxy with something, try attacking the coffeemaker with the second noun. Instead of doing something other than examining when the noun is the coffee-proxy or the second noun is the coffee-proxy, try examining the coffee-proxy. 

Definition: A thing is corrupting if it is the jars or it is the vials.

Understand "spike [something] with [other things]" as inserting it into (with nouns reversed). Understand the commands "poison" or "adulterate" as "spike".

Instead of inserting a corrupting thing (called the adulterant) into the coffee-proxy, try inserting the adulterant into the coffeemaker.

Instead of inserting an inflammable thing (called the kindling) into the coffee-proxy:
	say "(Assuming you mean the heating element, not the brew basket)[command clarification break]";
	try inserting the kindling into the coffeemaker.

The sink is a fixed in place thing in the kitchen nook. The description is "The sink is another hole in the nook with a faucet sprayer extending from it. The faucet is flush with the top of the counter, you suppose to deal with the fact that the not-quite-gravity might make water spray everywhere." Instead of switching on the sink, say "The faucet sprays for a few seconds, then stops as you remove your hands." Instead of inserting something into the sink, say "You don't need to put anything into the sink."

Check sleeping in the Crew Pod: say "You're in enemy territory!" instead.

Some soft cots are a scenery supporter in Crew Pod. Understand "bed" or "beds" or "cot" or "web" or "webs" or "webbed" or "mattress" or "mattresses" as the cots. Instead of entering the cots, try sleeping. The printed name of the cots is "cots". The description is "These cots are space-ready, made mostly of webbed mattresses to keep the sleeper in place."

Instead of taking the cots, say "They're a little bulky for an infiltration mission."

Some blankets are an inflammable improbable thing on the cots. The description is "The blankets are pretty fluffy. You're not sure how this doesn't produce dangerous floating fibers." After taking the blankets for the first time, say "You strip the blankets from the cots." Understand "fluffy" as the blankets. Instead of kissing the blankets, say "Yup, they're fluffy all right." Understand the command "snuggle" as "kiss".

For printing a locale paragraph about the cots when the blankets are not handled:
	set the locale priority of the blankets to 0;
	continue the activity.

Some supply lockers are a closed locked lockable openable scenery container in the supply pod. The description is "You have to study the walls pretty closely to even see where the doors are." Instead of opening the lockers, say "You don't even see where the handles would be." Instead of attacking the lockers, say "They absorb your strike but do not open." Instead of lockforcing the lockers with the crowbar, say "You can't actually work your improvised crowbar into the tiny gaps."

The countermeasures crate is in the Supply Pod. "Disrupting the neatness is a crate in the corner labeled 'COUNTERMEASURES'." Understand "box" as the countermeasures crate. The countermeasures crate is a container. The countermeasures crate is fixed in place. Instead of taking the countermeasures crate, say "It's too large to comfortably carry." Instead of attacking the countermeasures crate with the crowbar, say "Splinters are no joke in spun gravity. Not a good idea." Instead of attacking the countermeasures crate, say "Punching out crates isn't really a worthwhile pursuit." Instead of opening or closing the countermeasures crate, say "The crate has no lid; the top is permanently open for your searches."

A countermeasure is a kind of thing. A countermeasure has some text called the counter. A countermeasure can be unidentified or identified. A countermeasure is usually unidentified. A countermeasure is usually privately-named.

Some jars full of brightly-colored reflective dust are an improbable countermeasure in the countermeasures crate. The description is "Light reflects off of the dust in these jars with a cheerful prismatic effect. They'd probably be very useful in defending against laser-based attacks." The counter of the jars is "That would negate a lot of Justice-Bot's firepower." Understand "jar" or "jars" or "reflective" or "glitter" or "dust" as the jars when the jars are identified. Instead of opening or emptying the jars, say "This space station would not be improved by having glitter everywhere." Instead of closing the jars, say "The jars are all already quite closed." The jars are ambiguously plural. Instead of eating or drinking the jars, say "You're not sure what that glitter is made of, but you probably don't want it inside of you."

Some vials are a countermeasure in the countermeasures crate. The description is "These vials are labeled neatly - they all seem to be various bromine compounds." The counter is "They're labeled as various bromine compounds. Halogens like these could seriously ruin Mr. Mysterious's day." Understand "vial" or "bromine" or "bromines" or "bromide" or "bromides" or "compound" or "compounds" or "potassium bromide" or "kbr" or "k br" or "vials" as the vials when the vials are identified. Instead of opening or emptying the vials, say "You'd as soon not get a whiff of these unnecessarily." Instead of closing the vials, say "The vials are already quite closed." The vials are ambiguously plural. Instead of eating or drinking the vials, say "No way. Most of these powders are probably poisonous."

A teleport blocker is a countermeasure in the countermeasures crate. The printed name is "box with circuitry you recognize as a teleport blocker". Understand "box" and "circuitry" and "teleport" and "blocker" and "box of/with circuitry" as the teleport blocker when the teleport blocker is identified. Instead of switching on or switching off the teleport blocker, say "The teleport blocker has no obvious controls." The counter is "[clean printed name]If the Coalition of Powered Response had sent Star-R-Star, he'd be fighting with his hands tied." The description is "The circuitry on this box seems to be powering a high-amplitude, low-frequency electromagnetic oscillator. You're sure it's a teleport blocker."

[This is kind of a hack, but it does seem to work right. The one-of/stopping pair didn't work.]

To say clean printed name:
	now the printed name of the teleport blocker is "teleport blocker".

A platinum-studded rope is an improbable inflammable countermeasure in the countermeasures crate. The counter is "Colonel Spectacular would be hard-pressed to escape from this." Instead of tying the rope to something, say "The metallic inserts make it very hard to bend. Dr. Sinister didn't think this one through." The description is "This looks like an ordinary rope, but there are chunks of silvery metal embedded in it at regular intervals." Understand "platinum" or "studded" or "rope" as the platinum-studded rope when the rope is identified.

A tuning fork is a countermeasure in the countermeasures crate. The counter is "You give it an experimental strike, and it produces a clean-high note. You recognize it immediately as A-880 - the precise tone that shifts the Ethereal Wonder into the physical realm." Instead of attacking the tuning fork, say "You strike the tuning fork, and it produces a clean, high note. You recognize it immediately as A-880." The description is "The tines of this fork are perhaps two and a half inches long, and it's made out of some metal you do not immediately recognize." Understand "tuning" and "fork" as the tuning fork when the tuning fork is identified.

Instead of searching the countermeasures crate when the number of unidentified countermeasures is greater than zero:
	let widget be a random unidentified countermeasure;
	say "Searching through the crate, you find [a widget]. [counter of the widget][line break]";
	now the widget is identified;
	if the number of unidentified countermeasures is greater than one, say "[line break][one of]A cursory glance doesn't identify anything else, but more investigation might help.[or]Other unidentified items still remain in the crate.[or]You put [the widget] back in the crate, near some other things you haven't checked yet.[in random order]";
	if the number of unidentified countermeasures is one, say "[line break]You've almost finished completely sorting through the crate."

Check examining the countermeasures crate when the number of unidentified countermeasures is greater than zero:
	try searching the countermeasures crate instead.

Finding Counters is a scene. Finding Counters begins when Docking ends. Finding Counters ends when all countermeasures are identified.
	
Rule for deciding whether all includes unidentified countermeasures: it does not.
[Kind of a hack but we haven't gotten a better way of handling it.]
Rule for printing a parser error when the latest parser error is the nothing to do error and the countermeasures crate is in the location and Finding Counters is happening and the player's command includes "crate/countermeasures":
	say "A crate full of 'countermeasures' isn't something to loot in bulk. Best to search it more carefully."
	
Instead of inserting something into the countermeasures crate, say "You aren't here to give Dr. Sinister anything except justice."

Instead of emptying the countermeasures crate when Finding Counters is happening, try searching the countermeasures crate.

When Finding Counters ends:
	say "Dr. Sinister was ready for anyone. Well. Anyone but you. He'll pay for that oversight." 
	
Chapter 2 - The Introductory Scenes

[Introducing the minions. We can't use 'for the first time' because that was when we had the ladder hit us or when we failed to reach it.]
After going to the Vestibule when the Vestibule is unvisited:
	say "You climb the ladder confidently, but still, you worry. Your arrival was not exactly stealthy, and it [italic type]can't[roman type] have gone unnoticed. Where's the welcoming committee? You strain your ears listening for ambushes or other traps as you ascend into the station proper.[paragraph break]You're almost relieved when you find four goons waiting for you up top.";
	pause the game;
	say "They spring into action as soon as you become visible. Fortunately, this involves more screaming into headsets and retreating than hammering you while you can't fight back.[paragraph break]'It's the Hummingbird! He's bypassed our teleport blockers and is in the Vestibule! Initiating lockdown procedures!'[paragraph break]They're fast. By the time you pull yourself all the way through the hatch, they're gone and the hatches out of this chamber are sealed.[paragraph break]You pause for a moment to catch your breath and get your bearings.";
	pause the game;
	say paragraph break;
	say paragraph break;
	continue the action.
	
Initial Mockery is a scene. Initial Mockery begins when Docking ends. Initial Mockery ends when the location is the Vestibule.

When Initial Mockery begins:
	deactivate the Table of Stardock Hints;
	activate the Table of Starbase Intro Hints.

When Initial Mockery ends:
	deactivate the Table of Starbase Intro Hints;
	activate the Table of Starbase Infiltration Hints;
	say "Dr. Sinister's voice crackles over the intercom. 'The Hummingbird? I invest all this in an island fortress and a space station - a [italic type]space station[roman type] - and all CPR sees fit to send is the [italic type]Hummingbird[roman type]? Pah!'";
	Subsequent Mockery happens in three turns from now.
	
At the time when Subsequent Mockery happens:
	say "Dr. Sinister's voice booms out once again through the public address system. 'Fall back to the Hub, men; our visitor won't be going anywhere, and even if he somehow does, your numbers will be more than enough to fight him back until the cannon is charged.'[paragraph break]You sneer inwardly. You're ten times the fighter of any minions the Doctor could gather.[paragraph break]Here's hoping he didn't gather twenty."

Initial Infiltration is a scene. Initial Infiltration begins when Initial Mockery ends. Initial Infiltration ends when the location is an access corridor.

When Initial Infiltration ends:
	say "[bracket]As you are on a spinning spacecraft, normal compass directions no longer apply. UP, DOWN, IN, and OUT all still work as expected, and the new directions SPINWARD and ANTISPINWARD are available. While on the station, these may be abbreviated SW and ASW.[close bracket][line break]";
	deactivate the Table of Starbase Infiltration Hints;
	activate the Table of Starbase Exploration Hints.



Chapter 3 - The Minions

Some henchmen are a person. Henchmen have a number called combat strength. Henchmen have a number called numerical strength. The combat strength of the henchmen is 5. The numerical strength of the henchmen is 15. The description is "Dr. Sinister's finest."[*This should never actually show up.]

Definition: The henchmen are all there if the numerical strength of the henchmen is 15.
Definition: The henchmen are spread too thin if the numerical strength of the henchmen is less than eleven.

Failure count is a number that varies. Failure count is zero.

Instead of going to the Hub:
	deactivate the Table of Starbase Exploration Hints;
	activate the Table of Goon Defeat Hints;
	let N be the combat strength of the henchmen;
	if N is 5:
		say "There's a good [numerical strength of the henchmen in words] or so unfriendly-looking goons in the hub of the station. That's more than you feel comfortable taking on; you'll have to do something to diminish their numbers, or at least make them less effective.";
	otherwise if N is 4:
		if yourself is flying:
			say "You flutter through into the main hall, where [numerical strength of the henchmen in words] of Dr. Sinister's finest await you. That's normally just a tad more than you're comfortable facing alone, but they were expecting someone coming in on the ground. More fool they. While you'd perhaps hoped to just fly over all of them, the spun gravity sends you careening about the room like a pinball, whacking and bowling over most of the men hoping to ambush you.[paragraph break]Before the ones left conscious can regroup, you tilt your flight path to the central bridge's access ladder.";
			move the player to the Central Bridge, without printing a room description;
		otherwise:
			if failure count is zero:
				increase failure count by 1;
				say "You stride into the main hall, where [numerical strength of the henchmen in words] of Dr. Sinister's finest await you[if the henchmen are all there]. That's well past your comfort zone, but they're not looking like they're really in fighting trim[otherwise]. That's normally a tad more than you're comfortable facing alone, but the odds don't seem too bad[end if].[paragraph break]However, they're still [if the henchmen are all there]numerous[otherwise]skilled[end if] enough that you cannot battle your way through to the central bridge access ladder they guard. You make a careful retreat before the situation gets any worse.[paragraph break]They do not follow.[paragraph break]That's good for your prospects of survival, at least in the short term, but not so great for your long-term prospects of success. You've weakened their forces some, but it looks like you'll need to either weaken them some more or strengthen yourself to actually break through.";
			otherwise:
				say "You've already tried and failed; you're going to need to do something else to turn the tide if you expect the results to be any different.";
			activate the Table of Powerup Hints;
	otherwise:
		say "[if the henchmen are spread too thin]There are only [numerical strength of the henchmen in words] foes left guarding the ladder to Dr. Sinister's bridge[otherwise]There are [numerical strength of the henchmen in words] guards waiting for you, but they are in no shape at all for fighting[end if]. You step out, grab one, and hurl him into two of his compatriots. In the resulting confusion, you turn a handspring that lands up you halfway up the ladder to the central bridge. There's nothing they can do to stop you now!";
		move the player to the Central Bridge, without printing a room description.

Some henchmen-shadows are a backdrop. The henchmen-shadows are in Starbase. The henchmen-shadows are privately-named. Understand "henchmen" or "goons" or "henchman" or "goon" or "guard" or "guards" as the henchmen-shadows. The description is "[if the location is an access corridor]They're up above in the central hub somewhere[otherwise if the location is adjacent to the Hub]There look to be about [numerical strength of the henchmen in words] out in the hub, patrolling purposefully. They don't seem like they're going to storm where you are, but they also look like they have no intention of letting you over to that ladder in the middle of the hub either[otherwise]They're out in the central hub somewhere, you think[end if][trigger hints]." 

Instead of doing something other than examining to the henchmen-shadows (this is the goons are elsewhere rule): say "Dr. Sinister's henchmen are too far away[trigger hints]." instead.

Instead of throwing something (called the missile) at the henchmen-shadows (this is the goons are targetable rule):
	if the location is not adjacent to the Hub:
		say "You don't have a clear shot at them from here[trigger hints].";
	otherwise if the missile is the vials:
		say "These compounds are probably closed up for a reason, and you'll have to be breathing the air here too. [if the coffeemaker is not poisoned]You'll need to find some more controlled and reliable way of delivering it to them[otherwise]You've already found a more reliable way of delivering it to them, anyway[end if][trigger hints].";
	otherwise if the missile is the jars:
		say "Adding glitter to a fistfight isn't going to help, or hurt, anyone. Well, except the air filters, but you kind of like those how they are[trigger hints].";
	otherwise:
		say "[The missile] isn't a very effective missile[trigger hints]."

The goons are targetable rule is listed before the goons are elsewhere rule in the instead rules.

To say trigger hints:
	deactivate the Table of Starbase Exploration Hints;
	activate the Table of Goon Defeat Hints.

Understand "hide" or "hide from [text]" as a mistake ("[if the location is the Vestibule or the location is an access corridor]You're pretty well hidden already[otherwise if the location is a starship pod]There isn't anywhere that's really out of sight of the guards[otherwise]There's not really anything worth hiding from here[end if].")

Chapter 4 - Under Pressure

An access corridor can be pressurized or depressurized. An access corridor is usually pressurized.

The hull is a backdrop. The hull is in Starbase. Understand "wall" or "bulkhead" as the hull. Understand "floor" as the hull when the location is not the Vestibule. The description of the hull is "[if the location is AC 3]The hull here is bare metal, reinforced compared to the other access corridors[otherwise if the location is an access corridor]The hull here is just bare metal[otherwise]The bulkheads here in the pods at least make an effort to look like ordinary walls, but they're still pretty obviously shells of metal[end if]."

Hale Hull is a scene. Hale Hull begins when Docking ends. Hale Hull ends when the number of depressurized access corridors is not zero.

[The basic accessibility rule blocks touching compass directions. We have to redirect in Before to catch this.]
Before attacking down when the hull is in the location, try attacking the hull instead.
Before attacking down with something (called the weapon) when the hull is in the location, try attacking the hull with the weapon instead.

Instead of attacking the hull with the crowbar when Hale Hull is happening and the location is an access corridor:
	if contact result is 12:
		say "You're here as the [italic type]less[roman type] violent option, remember? Venting the atmosphere to space isn't going to help you in that regard.";
	otherwise if the room up from the location is the Recreation Pod:
		say "The bulkhead here seems to be reinforced; it must have extra support to supply the Recreation Pod.";
	otherwise:
		now the location is depressurized;
		say "You strike the hull a ringing blow with the crowbar, and the floor buckles. With that dent you pull open the floor a bit and see below you... the Earth.[paragraph break]Pressure sirens scream, air whistles around your feet, orders fly through the thinning air, and you take this opportunity to flee before the bulkheads seal you in with the vac-suited repair crew.";
		move the player to a random access corridor adjacent to the location.
		
Instead of attacking the hull when Hale Hull is not happening and the location is an access corridor:
	say "You're unwilling to risk doing any more damage to the station's life support. That would be reckless endangerment."

Instead of attacking the hull when Hale Hull is happening and the location is an access corridor:
	say "You punch the bulkhead, but your fists alone aren't enough to damage it. Just as well; that thin shell of metal is all that stands between you and the boundless depths of space."

Understand "shell" or "metal" or "shell of metal" or "thin" or "fragile" as the hull.[* Secret shout-out!]
	
Instead of attacking the hull when the location is not an access corridor:
	say "Attacking the interior bulkheads isn't going to do you any good."
		
When Hale Hull ends:
	remove the crowbar from play;
	decrease the combat strength of the henchmen by 1;
	decrease the numerical strength of the henchmen by 3;
	now failure count is zero;
	say "The pressure doors close behind you, and you hear footsteps above. The repair crew must have come from the ranks of the guards! That should keep their numbers thinned a bit for a good while.[paragraph break]Your accomplishment is marred only in the fact that you seem to have left your crowbar behind in the depressurized chamber."
	
Instead of going to a depressurized access corridor:
	say "The pressure seals keep that area out of your reach."

Chapter 5 - Decaffeinating the Weasels

Caffeine level is a number that varies. Caffeine level is 20.

The henchmen can be alert, sedated, or exhausted. The henchmen are alert.
The coffeemaker can be poisoned. The coffeemaker is not poisoned.
The coffeemaker can be ruined. The coffeemaker is not ruined.

Caffeine Control is a scene. Caffeine Control begins when Initial Mockery ends. Caffeine Control ends when Space Infiltration ends. Caffeine Control ends in sedation when the henchmen are sedated. Caffeine Control ends in exhaustion when the henchmen are exhausted.

Every turn during Caffeine Control:
	let was-wired be false;
	if caffeine level is greater than zero:
		now was-wired is true;
		decrease caffeine level by 1;
	[If caffeine level was one, was-wired is true even though they're now at zero.]
	if caffeine level is zero:
		if was-wired is true:
			decrease the combat strength of the henchmen by 1;
			if the location is the Recreation Pod:
				say "[one of]You hear some muttering from the guards in the central hub.[paragraph break]'All right, Jim, it's your turn to fetch the coffee. Gods above know we all need it.'[paragraph break]'The intruder's in there, boss. I'm not going in there alone.'[paragraph break]'But...'[paragraph break]'Regs are on my side, boss. I'll do it as soon as it's safe.'[or]You hear the guard commander. 'Sorry boys, but coffee's on hold until our Hummingbird flutters off again.'[stopping]";
			otherwise:
				if the location is adjacent to the Hub:
					say "[one of]You hear some muttering from the guards in the central hub.[paragraph break]'We've been up for awhile now. Bob, it's your turn to fetch the coffee.'[paragraph break]'Roger that.'[paragraph break]You hear some quick movement, then the motion stops as the guards return to their normal posts[or]More voices from the hub. 'Dave. Coffee. Fast.' More motion. Though the voice is still quite alert, you can hear the fatigue behind it[or]You hear some barked orders as the minions order up another quick coffee break[stopping].";
				otherwise if the location is adjacent to the Recreation Pod:
					say "You hear some rapid, purposeful motion above you in the Recreation Pod, but it ends a few seconds after it starts.";
				otherwise:
					say "Some footsteps reverberate through the station. It sounds like someone's moving, and fast.";
				increase the combat strength of the henchmen by 1;
				now caffeine level is 20;
				if the coffeemaker is ruined:
					now the henchmen are exhausted;
				otherwise if the coffeemaker is poisoned:
					now the henchmen are sedated;
		otherwise if the location is not the Recreation Pod:
			say "Your feet have barely touched the deck when you hear a shouted 'ALL CLEAR' from above and some rapid movement directly above your head.[paragraph break]Nobody seems to be following, though.";
			increase the combat strength of the henchmen by 1;
			now caffeine level is 20;
			if the coffeemaker is ruined:
				now the henchmen are exhausted;
			otherwise if the coffeemaker is poisoned:
				now the henchmen are sedated.

When Caffeine Control ends in sedation:
	decrease the combat strength of the henchmen by 1;
	now failure count is zero;
	say "Sounds like they've taken some of the doctored coffee. Good. That should take the edge off of them and maybe give you a fighting chance."

When Caffeine Control ends in exhaustion:
	decrease the combat strength of the henchmen by 1;
	now failure count is zero;
	say "[if the location is adjacent to the Hub or the location is adjacent to the Recreation Pod]A torrent of cursing follows[otherwise]You can just make out some raised voices from elsewhere in the station[end if]. Looks like they've discovered your sabotage."

Instead of attacking the ruined coffeemaker, say "There isn't anything more you can do to it now."

Instead of attacking the not ruined coffeemaker, say "This thing is well-enough integrated into the countertop that you can't do much damage to it with your bare hands."

Instead of attacking the not ruined coffeemaker with something (called the instrument):
	if the instrument is the crowbar:
		say "You set to work with your crowbar, tearing apart the heating elements and tubes. This coffeemaker will never brew another cup.";
		now the coffeemaker is ruined;
	otherwise:
		say "You can't really work out a good way to hurt the coffee machine permanently with [the instrument]."

Chapter 6 - Only You Can Prevent Space Station Fires

[Various items are flammable. Flammable items can be burned or smouldered in the coffee machine. Doing so will alert the henchmen and force them to send a detachment to verify all is well. This will lower their strength by two for just long enough to race over and confront them. Even stopping to take flight will make it be too late.]

Section 1 - Advanced burning mechanics

Check an actor burning (this is the new block burning rule):
	say "You don't make a habit of carrying sources of flame around. If you want to burn something, you'll need to specify what you want to burn it in." instead.
	
The new block burning rule is listed instead of the block burning rule in the check burning rulebook.

Definition: a thing is a flame source if it is the coffeemaker or it is the defense grid.

Burning it in is an action applying to two things. Understand "burn [thing] in [thing]" as burning it in. Burning in is hands-required behavior.

Check burning it in (this is the can only burn things in a flame source rule):
	if the second noun is not a flame source, say "You can't ignite anything with [the second noun]." instead.

Carry out burning it in (this is the redirect ignition to insertion rule):
	try inserting the noun into the second noun.

Section 2 - Firefighting

Fire level is a number that varies. Fire level is 0.
Firefighting is a scene. Firefighting begins when Initial Mockery ends. Firefighting ends when Space Infiltration ends.

Every turn during Firefighting:
	if Fire level is greater than zero:
		[They're in the rec pod, they can totally access their delicious coffee.]
		now caffeine level is 20;
		decrease fire level by 1;
		if fire level is zero:
			if the location is adjacent to the Hub:
				say "[one of]You hear footsteps as the guards return from the Recreation Pod. Sounds like they got any fires under control[or]You hear the guards return to the Hub, again having confirmed your vandalism isn't a threat to everyone's lives[stopping].";
			otherwise if the location is adjacent to the Recreation Pod:
				say "You hear footsteps fade from above you. The fire control team must be returning to reinforce the central guards once again.";
			otherwise:
				say "Some footsteps reverberate through the station. It sounds like someone's moving, purposefully but not urgently. That's probably the fire control team returning to reinforce the central guards once again.";
			increase the combat strength of the henchmen by two;
			increase the numerical strength of the henchmen by five.

Section 3 - Burnination

Definition: A thing is literacy-positive if it is the bookcases or it is the books.

Before burning something literacy-positive in a flame source, say "What kind of hero burns books? No kind you want to be, at any rate." instead.

Instead of putting something on the coffeemaker, try inserting the noun into the coffeemaker.

Instead of inserting the crowbar into the coffeemaker, say "Forging iron takes more heat than a coffeemaker can provide."
Instead of inserting the energy drink into the coffeemaker, say "Yes, it gives you energy to burn, but that's not the way it does it."
Instead of burning the vials in the coffeemaker, say "Bromine boils at under 60 degrees Celsius and its vapor is a severe irritant. You don't really want to be unleashing that in an enclosed space like this station."

Instead of inserting the vials into the not poisoned coffeemaker:
	let toxic be false;
	if the player's command includes "poison":
		now toxic is true;
	now the coffeemaker is poisoned;
	say "[if toxic is true]Poison? You don't want to [italic type]kill[roman type] them, you just want them out of the way for a bit. As such, y[otherwise]Y[end if]ou check through the vials, looking for anything you could safely spike the coffee with. You settle on potassium bromide. If you remember right, about 40 grams of this spread through the coffeepot should slow down that platoon of thugs without permanently harming any of them.[paragraph break]Now you just need to wait for them to get it into their system."

Instead of inserting the vials into the poisoned coffeemaker:
	say "You've already exhausted your supply of sedatives[if Caffeine Control ended in sedation] and they've already drunk the tainted coffee. You've fully negated their alertness advantage[otherwise]. Now they just have to drink it[end if]."

Instead of inserting the jars into the coffeemaker:
	say "Glittery coffee? That's kind of gross, but it'd probably just get filtered out by the time the coffee was made anyway[if the coffeemaker is not poisoned]. If you want to adulterate the coffee, you'll need to find something more suitable[end if]."

Instead of inserting something inflammable into the coffeemaker:
	say "You can only fit part of [the noun] into the coffeemaker's heating element. It begins smoking but doesn't manage to properly catch fire. However, enough smoke is generated that alarms begin to go off.[paragraph break]You hear a commotion from the guards in the Hub. Time to make yourself scarce. You dive into the access hatch as they detatch a fire team to handle your meddling.";
	now the fire level is four; [* Four turns is exactly enough time for you to charge in from elsewhere without charging up first; this turn, move to adjacent maintenance pod, up, out.]
	decrease the combat strength of the henchmen by two;
	decrease the numerical strength of the henchmen by five;
	now caffeine level is 20; [To block them going 'all clear' if you time it just wrong.]
	move the player to AC 3.

Instead of going to the Recreation Pod when the fire level is not zero:
	say "You're not about to go to the Recreation Pod while the guards are there wielding fire extinguishers. You'd get clobbered on the way in."

Instead of inserting something into the coffeemaker:
	say "[The noun] [if the noun acts plural]don't[otherwise]doesn't[end if] really burn all that well." instead.

Chapter 7 - The Good Doctor

Section 1 - Scene logic

Space Infiltration is a scene. Space Infiltration begins when Docking ends. Space Infiltration ends when the location is the Central Bridge.

When Space Infiltration ends:
	deactivate the Table of Goon Defeat Hints;
	deactivate the Table of Goon Distraction Hints;
	deactivate the Table of Goon Weakening Hints;
	deactivate the Table of Powerup Hints;
	activate the Table of Final Confrontation Hints;
	now yourself is grounded;
	now the energy of yourself is zero;
	pause the game;
	say "[paragraph break]As you climb, the Hub narrows into a ring-shaped corridor. It's almost as if there's some long, thin object running the length of the station.[paragraph break]You recall the Doctor mentioning some kind of beam weapon when you first entered the station. You can only hope you aren't...[paragraph break]...well, it looks like you aren't too late after all. A display on the wall prominently announces '3:47:32 to full beam charge'. That more or less matches your position over the Pacific when you first docked - unless his master plan involves ruining a cruise ship's day, you should be able to wrap this up with time to spare.[paragraph break]You continue your climb to Dr. Sinister's inner sanctum.";
	pause the game;
	say "[paragraph break][paragraph break]";
	if the defense grid is not recognized as hazardous:
		repeat through the Table of Quip Followups:
			if the result entry is q_endgame_10:
				blank out the whole row;
	deliver the q_endgame_00 quip.

The catchall is a scenery thing in the Central Bridge. It is privately-named. Understand "desk" or "mahogany" or "Dr" or "Doctor" or "Sinister" or "papers" or "paper" or "chair" or "solid" as the catchall. The description is "[bracket]You should not have been able to get this message, because you should always be caught in a conversation sequence. This is a bug! Please contact [developer email] with information about how you managed to make this happen. Thanks.[close bracket]".

Section 2 - Dialog text

Table of Quip Texts (continued)
quip	quiptext
q_endgame_00	"You tense as you slip into the central bridge, ready for anything. Who knows what forces could guard Dr. Sinister's sanctum sanctorum?[paragraph break]It turns out the answer is 'nothing'; there isn't anyone here except Dr. Sinister himself, flipping through paperwork behind a mahogany desk.[paragraph break]How on Earth did he manage to spare the mass to send up a mahogany desk? Ah well. No time to question his priorities; you've got an evildoer to stop."
q_endgame_01	"'Your fiendish scheme ends here, Doctor!'[paragraph break]Dr. Sinister looks up, supremely unimpressed. 'Is that really the best you can do?'[paragraph break]'Er...'[paragraph break]'Do you even know what my fiendish scheme [italic type]is[roman type]?'"
q_endgame_02	"'Your sinister plan is foiled, Doctor!'[paragraph break]Dr. Sinister raises an eyebrow. 'Is that an insect I hear buzzing?'"
q_endgame_03	"You advance on the doctor, winding up. He puts his paper down and makes some futile warding gestures. 'Whoa whoa whoa whoa whoa, Hummingbird. What did I ever do to you?'"
q_endgame_04	"'The Hummingbird is no insect! And now...'[paragraph break]'[bold type]SILENCE![roman type]' Dr. Sinister's fist comes hammering down on his mahogany desk. 'Since when does CPR send an also-ran like you against a threat of my awesome caliber?'"
q_endgame_05	"'You're awfully blas[unicode 233] for someone whose master plan is falling apart around his ears.'[paragraph break]'Is it, though?'"
q_endgame_06	"'Enough. This ends now.' You advance on the doctor, winding up. He begins shrinking back in his chair and makes some futile warding gestures. 'Whoa whoa whoa whoa whoa, Hummingbird. What did I ever do to you?'"
q_endgame_07	"'Well, there was your army of genetically-modified sharks.'[paragraph break]Sinister blanches. 'You were able to defeat them? They should have been more than a match for the likes of you.'[paragraph break]You think back. 'Actually, now that you mention it, no; I just flew out of their reach.'[paragraph break]'You can fly. Doesn't count.'"
q_endgame_08	"'There's this [italic type]entire station[roman type], which you've built around a huge doomcannon.'[paragraph break]'That never threatened [italic type]you[roman type]. It would have been able to hold the world hostage in a few more hours, but...'[paragraph break]'I've wasted far too much time with this as it is. Enough.' You wind up again, but Dr. Sinister again waves you off.[paragraph break]'No, really, that won't be necessary. I'll come quietly. I know when I'm beaten.'"
q_endgame_09	"'There's the deadfall in your office.'[paragraph break]'You can fly. Doesn't count.'[paragraph break]'But...'[paragraph break]'And you shouldn't have been rummaging through my stuff.'"
q_endgame_10	"'What about those lasers blocking your hangar?'[paragraph break]'What about them?'[paragraph break]'It vaporized [a grid victim] pretty good.'[paragraph break]'And?'"
q_endgame_11	"'And it was right out in the open! Everything else I'd seen about you shows great concern with a safe working environment. What if one of your henchmen tripped?'[paragraph break]Dr. Sinister looks somewhat taken aback by this. 'The grid was usually off except in dire circumstances. I would never...'[paragraph break]'Don't give me that. The switch was on when I found it, and at the time you left you thought you held all the cards.'[paragraph break]He actually looks kind of crestfallen."
q_endgame_12	"'And, well, that's a threat.'[paragraph break]'It's a security grid! It's no more a threat than the locks on my doors. If you're going to claim I'm some big villain, you'll have to show better than that.'"
q_endgame_13	"You tilt your head quizzically. 'You know, CPR doesn't generally send me after the worst of the worst, but even so that kind of concern for your minions is rare.'[paragraph break]'[if the number of depressurized access corridors is zero]Loyalty is easily lost. Why borrow trouble?'[otherwise]More than you showed!' Dr. Sinister's voice quivers with rage. 'If you're anything to go by, it's totally fine for a hero to risk killing dozens of people just because they're in the way and have the wrong boss! I ought to...' He lunges over the table at you, swinging wildly.[paragraph break]Evil science clearly hasn't given him time to study hand-to-hand combat; you easily block his attack and maneuver him into a grip where he is harmless.[end if]"
q_endgame_14	"You harden your expression. 'We don't have time for this. You have [italic type]no idea[roman type] how precarious your situation is right now.'[paragraph break]'Oh?'[paragraph break]'CPR knows exactly where you are and is completely ready to blow all of us out of space before you get anywhere near the West Coast. You've been doomed basically since you took off in the first place.'[paragraph break]Dr. Sinister narrows his eyes. 'Why send you, then?'"
q_endgame_15	"'I know enough. There's a cylindrical core running through the center of the station, and a beam charge countdown was visible on the status screen on the way here. You've got some kind of orbital superweapon, and it'll be ready to fire about the time your orbit takes you over North America.'[paragraph break]Dr. Sinister smiles, and not in a friendly way, either. 'And how do you propose to stop it? My systems are automated.'"
q_endgame_16	"'I'm here at the Coalition's behest. The exact details of your sinister plan are really kind of beside the point.'[paragraph break]Dr. Sinister raises an eyebrow. 'You're admitting that outright? What makes you any different from my own minions?'"
q_endgame_17	"You shake your head. 'For all you've managed to do, Doc, you and your organization are still only a Class IV entity[if Finding Counters has ended]. You prepared to fight Class II and Class I enemies, but e[otherwise]. E[end if]ven a Class III like me could and did smash through your defenses. And I'm the weakest class CPR will field. If you get their [italic type]full[roman type] attention, they will crush you like a [italic type]bug[roman type].'[paragraph break]'Empty boasts don't impress me.'[paragraph break]'You got their full attention as soon as you launched from your island base. The only reason a multinational military strike hasn't [italic type]already[roman type] turned this whole station into a meteor shower over the Pacific is because I convinced them to let me try to resolve this less explosively.'[paragraph break]Dr. Sinister steeples his fingers. 'And why would you have done that?'"
q_endgame_18	"'Why the sneering? Belittling me only diminishes yourself. I crushed all the threats you threw at me.'[paragraph break]'Oh? Like what? I prepared for the likes of Star-R-Star, not insects like you.'"
q_endgame_19	"[if the number of depressurized access corridors is zero]You meet his gaze evenly. 'Well, it's time for you to repay that loyalty. We've probably only got a few minutes left before CPR decides I failed and the North American Space Command responds with massive retaliation. We're getting out of here. It'll be easier on all of us if you go quietly.'[paragraph break]'No need to to push harder. I know when I'm beaten.'[otherwise]Dr. Sinister struggles in your grip.[paragraph break]'That rage?' you ask him. 'That's [italic type]hatred of injustice[roman type], Doctor. I have no idea why you bothered with this whole plan, but once you're brought to justice...'[paragraph break]'Yes?'[paragraph break]'I'll be testifying for both sides. For the prosecution as to what's happened, and as a character witness for the defense.' The Doctor is speechless. 'Now let's get out of here - there are so many better things you could be doing, and by God we're going to find out what they are if it kills you.'[end if]"
q_endgame_20	"'You might have missed this, but I'm one of the good guys[if the number of depressurized access corridors is not zero].'[paragraph break]'It's easy to miss when you're committing acts of sabotage that threaten the entire station.'[paragraph break]'Your henchmen are more than skilled enough to handle minor damage like that[end if]. I'm not a fan of pointlessly wasting lives. That includes yours and your men's.'[paragraph break]You gesture at the door. 'It's over. Save who you can, and just come quietly.'[paragraph break]Dr. Sinister considers you, and nods slowly. 'If what you say is true, it sounds like I may owe you my thanks.' Just then the screens on his desk glow red. He looks at it briefly. 'Yes. Thank you. Let's go.'"
q_endgame_21	"'Because, all told, I'd just as soon it not come to that.' Out of the corner of your eye, you see his desk screens blinking alerts. 'It looks like they've decided I failed. Care to prove them wrong?'[paragraph break]Dr. Sinister hesitates, but the look on his face betrays him, and you know that..."
q_endgame_22	"'This isn't about me.'[paragraph break]'Isn't it?'[paragraph break]'Of course it isn't. I'm not here because of some vendetta against you; I'm here because of your giant orbital doom cannon. You [italic type]certainly[roman type] aren't up here for me; [if Finding Counters has ended]all your preparations were for heroes a lot more powerful than I was[otherwise]you were deeply offended that I was all CPR sent when I finally made it in[end if].'[paragraph break]'And while we talk, the cannon keeps charging.'[paragraph break]'It will never finish.'[paragraph break]'Really.'"

Table of Quip Followups (continued)
quip	option	result
q_endgame_00	"'Your fiendish scheme ends here!'"	q_endgame_01
q_endgame_00	"'Your sinister plan is foiled!'"	q_endgame_02
q_endgame_00	"[bracket]Punch him.[close bracket]"	q_endgame_03
q_endgame_01	"'Of course!'"	q_endgame_15
q_endgame_01	"'I don't need to.'"	q_endgame_16
q_endgame_01	"[bracket]Punch him.[close bracket]"	q_endgame_06
q_endgame_02	"'Insect?'"	q_endgame_04
q_endgame_02	"'You're awfully calm.'"	q_endgame_05
q_endgame_02	"[bracket]Punch him.[close bracket]"	q_endgame_06
q_endgame_03	"'Super-sharks.'"	q_endgame_07
q_endgame_03	"'Orbital Doom Cannons.'"	q_endgame_08
q_endgame_03	"'It doesn't matter what you've done to [italic type]me[roman type].'"	q_endgame_22
q_endgame_04	"'I beat you handily.'"	q_endgame_18
q_endgame_04	"'You're still only human.'"	q_endgame_17
q_endgame_04	"[bracket]Punch him.[close bracket]"	q_endgame_06
q_endgame_05	"'Your plan is hopeless.'"	q_endgame_17
q_endgame_05	"'I've beaten you.'"	q_endgame_18
q_endgame_05	"[bracket]Punch him.[close bracket]"	q_endgame_06
q_endgame_06	"'Super-sharks.'"	q_endgame_07
q_endgame_06	"'Orbital Doom Cannons.'"	q_endgame_08
q_endgame_06	"'It doesn't matter what you've done to [italic type]me[roman type].'"	q_endgame_22
q_endgame_07	"'Trap doors.'"	q_endgame_09
q_endgame_07	"'Orbital Doom Cannons.'"	q_endgame_08
q_endgame_09	"'The laser grid.'"	q_endgame_10
q_endgame_09	"'Orbital Doom Cannons.'"	q_endgame_08
q_endgame_10	"'It's not like you.'"	q_endgame_11
q_endgame_10	"'It's dangerous.'"	q_endgame_12
q_endgame_11	"'Are you OK?'"	q_endgame_13
q_endgame_11	"'We've wasted enough time.'"	q_endgame_14
q_endgame_12	"'Well, there's your orbital doom cannon...'"	q_endgame_08
q_endgame_13	"'We're running out of time.'"	q_endgame_14
q_endgame_13	"'Are you sure you're on the right side?'"	q_endgame_19
q_endgame_14	"'To save you guys.'"	q_endgame_20
q_endgame_14	"'To make them unnecessary.'"	q_endgame_21
q_endgame_15	"'I don't have to.'"	q_endgame_14
q_endgame_15	"[bracket]Punch him.[close bracket]"	q_endgame_06
q_endgame_16	"'I [italic type]prevent[roman type] my bosses from pulling out the big guns.'"	q_endgame_14
q_endgame_16	"'My bosses are vastly more powerful.'"	q_endgame_17
q_endgame_16	"[bracket]Punch him.[close bracket]"	q_endgame_06
q_endgame_17	"'To save lives.'"	q_endgame_20
q_endgame_17	"'That kind of force isn't necessary here.'"	q_endgame_21
q_endgame_18	"'Super-sharks.'"	q_endgame_07
q_endgame_18	"'Orbital Doom Cannons.'"	q_endgame_08
q_endgame_22	"'You're about to run out of time.'"	q_endgame_14
q_endgame_22	"'You've always just been a bit player.'"	q_endgame_17

Before quipping when the current quip is q_endgame_07:
	if the Tower Office has not been trapped:
		repeat through the Table of Quip Followups:
			if the quip entry is q_endgame_07 and the result entry is q_endgame_09:
				blank out the whole row.

After quipping when the current quip is q_endgame_08:
	score the achievement with message "great justice";
	end the story finally saying "You have won".
After quipping when the current quip is q_endgame_19:
	if the number of depressurized access corridors is not zero:
		score the achievement with message "finding a light in the darkness";
	otherwise:
		score the achievement with message "great justice";
	end the story finally saying "You have won".
After quipping when the current quip is q_endgame_20:
	score the achievement with message "saving the day in the nick of time";
	end the story finally saying "You have won".
After quipping when the current quip is q_endgame_21:
	score the achievement with message "saving the day in the nick of time";
	end the story finally saying "You have won".

When play ends:
	if the story has ended finally:
		if contact result is 12, complete the "NO ONE LEFT BEHIND" challenge;
		if the achievement "finding a light in the darkness" is scored, complete the "NOT SO DIFFERENT AFTER ALL" challenge;
		if hands-free challenge is true, complete the "SELF-RELIANCE" challenge.

Book III - External information

Include Menus by Emily Short.
Include Adaptive Hints by Michael Martin.

Part 1 - External commands

Requesting metadata is an action out of world applying to nothing. Understand "about" or "help" or "hint" or "hints" or "credits" as requesting metadata.

Carry out requesting metadata:
	now the current menu is the Table of About Menu Options;
	carry out the displaying activity;
	clear the screen;
	say paragraph break;
	say paragraph break;
	if RQ is active:
		try requesting a recap;
	otherwise:
		try looking.

After printing the banner text:
	say "[bracket]Type ABOUT for information unique to this game, even if you've played Interactive Fiction before.[close bracket][line break]".

Understand "xyzzy" as a mistake ("You find yourself suddenly remembering your battle against the nefarious Lord Chitin and his army of zyzzyva weevils. It doesn't seem to help in your current situation.")

Understand "zyzzyva" or "weevil" as a mistake ("No! Lord Chitin is in jail! You've got to focus! [italic type]Focus![roman type]")

Understand "focus" as a mistake ("You mentally slap yourself upside the head. You feel much better now.")

Understand "* [text]" as a mistake ("[bracket]Noted.[close bracket]")

Enabling status-line-free play is an action out of world applying to nothing. Understand "status on" as enabling status-line-free play.

Disabling status-line-free play is an action out of world applying to nothing. Understand "status off" as disabling status-line-free play.

Status-line-free play is a truth state that varies. Status-line-free play is true.

Carry out enabling status-line-free play: now status-line-free play is true.
Carry out disabling status-line-free play: now status-line-free play is false.

Report enabling status-line-free play:
	say "FLIGHT OF THE HUMMINGBIRD will now dump important information to the main window instead of leaving it in the status line like usual. To restore default behavior, enter the command STATUS OFF."

Report disabling status-line-free play:
	say "FLIGHT OF THE HUMMINGBIRD will now only display some crucial information in the status line. If you are using an interpreter that does not support status lines, you may dump this information to the main window with the command STATUS ON."

Every turn when the player is not grounded and status-line-free play is true (this is the report flight status in main window rule):
	say "[bracket]You are ";
	carry out the reporting flight status activity with the location;
	say ".[close bracket][line break]".

The report flight status in main window rule is listed last in the every turn rules.
	
Every turn during Docking (this is the report starship status in main window rule):
	if status-line-free play is true, say "[bracket]POS: ([craft e-pos], [craft n-pos], [craft u-pos])  VEL: ([craft e-vel], [craft n-vel], 0)[close bracket][line break]".
	
The report starship status in main window rule is listed last in the every turn rules.

Explaining exits is an action out of world applying to nothing. Understand "exits" as explaining exits.

Definition: A direction (called the way) is valid if the room the way from the location is not nothing.

Carry out explaining exits:
	let N be the number of valid directions;
	if N is:
		-- 0: say "There aren't any obvious exits from here.";
		-- 1: say "The only obvious exit is [list of valid directions].";
		-- otherwise: say "Obvious exits lead [list of valid directions]."

Part 2 - The ABOUT menus

To decide if flight-scored:
	if the achievement "taking flight for the first time" is scored:
		decide yes;
	decide no.

Table of About Menu Options
title	subtable	description	toggle
"About Flight of the Hummingbird"	a table-name	"This is my second 'full-length' game. It was originally intended to be tricky to implement and full of all the unusable ideas I came up with when writing [italic type]Weishaupt Scholars[roman type], but it grew legs. I hope you enjoy it.[paragraph break][italic type]Flight of the Hummingbird[roman type] is a 'polite' game on the cruelty scale, with a small catch: should you succeed in getting yourself killed, a single UNDO will rarely suffice to save you, though it should never require more than three UNDOs from a death to get into a position that is guaranteed to be survivable. Playing on an interpreter with multiple-undo support is highly recommended.[paragraph break]I owe a tremendous debt of gratitude to Graham Nelson for Inform, and to Eric Eve, Aaron Reed, Mikael Segercrantz, and Emily Short for their useful extensions. Even when I did not use them directly, they often pointed me in the direction I needed to go. I am also indebted to my beta-testers: Benjamin Mullins, Reiver TaanArth, Dan Uznanski, George Oliver, Johnny Rivera, Marius M[unicode 252]ller, and David Martin.[paragraph break]The cover art provided with the game is courtesy James Asher.[paragraph break]Comments or bug reports will be gratefully received. At the time of this writing I can be reached via email at <[developer email]>."	a rule
"Special commands"	--		"This game will occasionally put critical information in the status line by default. If you are using a restricted interpreter that cannot render status lines, the command STATUS ON will cause this data to instead be dumped to the main window every turn that it is relevant. This can be ugly, however, and so it may also be disabled with the command STATUS OFF[if flight-scored].[paragraph break]You may start or stop flying with FLY or LAND. You may change your altitude with UP and DOWN while flying. While flying, your altitude will be marked in the status line at the top of the screen, or, if STATUS ON has been set, after every turn[end if][if Initial Infiltration has ended].[paragraph break]When on a spinning spacecraft, normal compass directions no longer apply. UP, DOWN, IN, and OUT all still work as expected, and the new directions SPINWARD and ANTISPINWARD are available. While on the station, these may be abbreviated SW and ASW[end if].[paragraph break]As more special commands become available, this section will expand to keep a record of them."	--
"Hints"				Table of Active Hints	--		--
"Return to game"			--		--		quit rule

To say developer email:
	say "mcmartin[email-at]gmail[email-dot]com".

To say email-at: say "@".

To say email-dot: (- print "."; -).

Part 3 - Hints

Table of Potential Hints (continued)
title	subtable	active
"How do I get to the island?"	Table of Ocean Crossing Hints	1
"Ack! Dr. Sinister has escaped!"	Table of Rocket Panic Hints	0
"How do I get into the tower?"	Table of Tower Panic Hints	0
"How do I open the access hatch on the tower roof?"	Table of Tower Entry Hints	0
"How do I pursue Dr. Sinister?"	Table of Rocket Launch Hints	0
"How do I open the launch hatch?"	Table of Hatch Opening Hints	0
"How do I refuel the rocket?"	Table of Refueling Hints	0
"How do I get past the hallway of lasery doom?"	Table of Defense Grid Hints	0
"How do I fly this thing?"	Table of Stardock Hints	0
"I just left the ship. Now what?"	Table of Starbase Intro Hints	0
"I'm stuck in the vestibule!"	Table of Starbase Infiltration Hints	0
"I'm in the base. Now what?"	Table of Starbase Exploration Hints	0
"How do I get past the goons?"	Table of Goon Defeat Hints	0
"How can I split up the goons?"	Table of Goon Distraction Hints	0
"How can I make the goons worse at fighting?"	Table of Goon Weakening Hints	0
"I've weakened the goons, but they're still too strong!"	Table of Powerup Hints	0
"How do I defeat Dr. Sinister?"	Table of Final Confrontation Hints	0

Table of Ocean Crossing Hints
hint	used (a number)
"You seem unwilling to swim."
"That's a good idea, actually; the water is lethally dangerous."
"Perhaps you have some ability that will let you cross the water."
"Check your description and your inventory."
"If you drink from your energy drink, you can fly for a few turns."
"But it doesn't seem to be enough to get you to the island."
"Perhaps you can extend your flight time somehow."
"By, for instance, giving yourself some time to save yourself before you hit the ground."
"As long as you're at least fifty feet in the air, you'll have time to take another drink."
"So make sure your first two moves after taking flight are both GO UP and you should be fine."
"From any shore room, PUT ALL IN BELT. DRINK DRINK. U. U. U. U. W. FLY. W. W. W. W. W. FLY. W. LAND."

Table of Rocket Panic Hints
hint	used (a number)
"So he has."
"And the containment force fields are still up."
"Guess you'll have to see what you can find left in his stronghold."

Table of Tower Panic Hints
hint	used (a number)
"Have you tried the front door?"
"Yeah, not looking like a likely way in."
"Maybe you could get in the way the good Doctor got out."
"That is, the tower roof."
"But it's so high up!"
"If only you had some way to get up there."
"It's a pity you can't climb walls."
"Or, oh, I don't know, fly."
"Oh wait!"
"The tower's about 100 feet up."
"That's just high enough to be reachable on one drink."
"From the tower door, FLY. UP. UP. UP. UP. SOUTH."

Table of Tower Entry Hints
hint	used (a number)
"Tried opening it?"
"It's stuck."
"You'll need to force it somehow."
"A crowbar would be ideal."
"Something like it would probably do."
"Have you seen a nice supply of metal bars anywhere?"
"Check the south edge of the beach."
"SEARCH WRECKAGE."
"Once you have that, PRY HATCH WITH CROWBAR will do the trick."

Table of Rocket Launch Hints
hint	used (a number)
"Is there anything in the room you entered that might help you chase him?"
"What's in the hangar?"
"Where does the catwalk above the hangar lead?"
"You'll need to chase him in the rocket."
"The rocket is fairly easy to use; check out the control panel."
"SIT IN CHAIR. PUSH BUTTON."

Table of Hatch Opening Hints
hint	used (a number)
"You can't launch the rocket with the hatch closed."
"And the hatch is way too large to open on your own."
"You'll need to find the controls for it."
"Have you explored the base thoroughly?"
"The command center is west of the office."
"There are various ways to get that door open."
"You could look for a key."
"But it's probably easier to simply FORCE THE LOCK or BREAK THE DOOR."
"Once you're in the Command Center, TURN ON THE MASTER POWER SWITCH."
"Dr. Sinister left the hatch switch open, so you should be fine."
"But do note that the hatch closes when the power is cut."

Table of Refueling Hints
hint	used (a number)
"Well, first you'll need a source of fuel."
"Have you explored the base thoroughly?"
"How about the environs?"
"There's a fuel truck in the southwest corner of the island."
"You'll need to get it into the Hangar."
"But it's not going anywhere without the key."
"Have you found any keys anywhere?"
"Once you have the right key, you can just START TRUCK and drive it around."
"There's one in Dr. Sinister's desk in his office."
"OPEN DESK."
"Well, that was dramatic. And now there's more stuff to check out."
"Of course, you'll also have to not get killed by the deathtrap."
"You should be an old hand at this by now."
"Oh, come on, why are you still reading this?"
"What game is this again?"
"FLY."
"The large-handled key at the bottom of the pit is the one that you need."
"As long as it's in your inventory when you START TRUCK, you'll be able to do so."

Table of Defense Grid Hints
hint	used (a number)
"Yeah, you won't be getting through that grid when it's on."
"There's a control for it in the command center."
"But it's stuck in the ON position."
"On the other hand, it didn't appear until you did something else."
"TURN OFF THE MASTER POWER SWITCH."
"Of course, that also closes the hatch, so you can't leave."
"Is there another way into the hangar?"
"Didn't you find it already?"
"Didn't you, in fact, use it already?"
"If the main doors are open, you can fly up to the roof and enter again that way."
"You can open the main doors with TURN ON MAIN DOORS SWITCH in the Command Center."

Table of Stardock Hints
hint	used (a number)
"Well, now you're in orbit."
"The autopilot told you where you need to be."
"And the status line is telling you where you are."
"If you don't [italic type]have[roman type] a status line, STATUS ON will put it in the main window. (See 'Special Commands', above.)"
"There's a control stick, but you can thrust to move in a direction with just N, S, E, W."
"However, orbital mechanics are a bit tricky. Experiment to see how it works."
"Your main thrusters will kick you into a higher, faster orbit."
"But now you're above the station, which is now making a 'tighter turn' around the earth."
"To catch up with the station, you'll need to be in a tighter orbit instead."
"Since you're facing west, thrusting east will drop your orbit."
"You'll also need to line up laterally, but that's a straightforward use of N and S."
"Don't forget to cancel your lateral thrust once you're aligned!"
"If you're happy with your current velocity, WAIT or its abbreviation Z will let you cruise."
"Also, your score for this sequence depends slightly on how fast you solve it. Try for an ace rating!"

Table of Starbase Intro Hints
hint	used (a number)
"That ladder up there looks like it would be handy."
"But it's out of reach."
"Do you have any way to get higher up?"
"You've done this several times already."
"If you FLY, you'll be able to fly up to the ladder and climb it up."

Table of Starbase Infiltration Hints
hint	used (a number)
"Uh oh, it looks like you're locked in!"
"So, what's the first thing you do when you're locked in?"
"Take stock of your surroundings. Anything look odd?"
"How about that billowing curtain?"
"That usually means there's a breeze or something behind it."
"LOOK BEHIND THE CURTAIN."
"Once you've found the passage behind it. you can just GO IN."

Table of Starbase Exploration Hints
hint	used (a number)
"Well, you've got the run of the base now."
"As far as you've seen, anyway."
"Explore the base and see what you can find."
"Your ultimate goal is to reach Dr. Sinister himself."
"That's all the hints for now - check back once you've actually been stopped by an obstacle."

Table of Goon Defeat Hints
hint	used (a number)
"Tricky. Fifteen enemies, all in fighting trim."
"You have two basic ways of dealing with them."
"You could split off a few of them for awhile by creating an emergency of some kind[enable splitoff]."
"Or, you could weaken their ability to fight[enable weaken]."

[These next two hint tables are enabled by the 'enable' interpolations above.]

Table of Goon Distraction Hints
hint	used (a number)
"If you have a tool of some kind, you can create a pressure hazard."
"If you don't, you might be able to produce a shorter emergency with a fire or something."
"The access corridors border on space."
"And there's a heat source in the Recreation Pod."
"It's the coffeemaker."
"ATTACK HULL WITH CROWBAR in most access corridors for a long-running detachment."
"or, you can BURN CURTAINS IN COFFEEMAKER and race to the Hub as fast as you can."
"Other items are burnable besides the curtains."

Table of Goon Weakening Hints
hint	used (a number)
"It's hard to retain a state of high alert for a long time."
"You might be able to disrupt their readiness somehow."
"If you wait for awhile, you might get a hint of how they're maintaining it."
"You'll need to be in a room adjacent to the Hub - that is, one of the starship pods - to make any conversation out, though."
"Looks like they're coffee achievers."
"And the coffee machine seems hard to sabotage since there aren't any parts you can get at."
"A tool might help with that."
"You also might be able to adulterate the coffee to make it not work well as a stimulant."
"That's possible, but not necessary."
"The goons, not being idiots, won't enter the Recreation Pod while you're in it."
"By guarding it, you can prevent their caffeine access and thus damage their readiness."
"They'll come get coffee the instant you leave, though."
"Launching your final attack from the rec pod after they've missed a coffee break thanks to you will let you have an advantage."
"Alternately, ATTACK COFFEEMAKER WITH CROWBAR will ruin their coffee forever."
"As a third alternative, if you search the countermeasures crate in the Supply Pod repeatedly, you'll find something you can put in the coffee that will permanently negate their caffeine advantage."
"PUT VIALS IN COFFEE. This won't stack with caffeine denial, and you'll have to wait elsewhere for them to actually drink it."

Table of Powerup Hints
hint	used (a number)
"They've been weakened, but you're still heavily outnumbered."
"You could do something else to distract or weaken them further[enable splitoff][enable weaken]."
"Or you could power yourself up somehow."
"Most of this is coming down to a fistfight."
"Can you strengthen your arms somehow?"
"Or give them more energy?"
"FLY before you enter the Hub while the goons are in their weakened state."

Table of Final Confrontation Hints
hint	used (a number)
"This is it! The final confrontation!"
"Relax, though - you can't fail from this point on."
"Just pick according to whim; the only thing at stake may be an optional challenge."

[We get a cool meta-effect of unlocking hints by reading hints this way.]
To say enable splitoff:
	activate the Table of Goon Distraction Hints;
	construct the hints menu.

To say enable weaken:
	activate the Table of Goon Weakening Hints;
	construct the hints menu.

Part 4 - Scoring

Section 1 - Ranking, achievements, and challenges

To score the achievement with message (X - some text):
	choose the row with a message of X in the Table of Achievements;
	unless there is a used entry:
		increase the score by the points entry;
		now the used entry is the turn count.
		
To decide whether the achievement (X - some text) is scored:
	if there is a used corresponding to a message of X in the Table of Achievements, decide yes;
	otherwise decide no.
	
Requesting the full score is an action out of world. Understand "full" or "full score" as requesting the full score.

Carry out requesting the full score (this is the announce the full score rule):
	if the score is not 0:
		say "In [turn count] turn[s], you [if the story has not ended]have so far [end if]earned:[paragraph break]";
		repeat through the Table of Achievements in used order:
			say "    [points entry] point[s] for [message entry][line break]";
		say "    [score] point[s] total (out of [maximum score])[paragraph break]";
		say "This gives you a rank of [current rank].";
	otherwise:
		follow the announce the score rule;
	announce completed challenges.
		
To say current rank:
	let last text be the rank in row 1 of the Table of Rankings;
	repeat through the Table of Rankings:
		if the score entry is greater than the score:
			break;
		now the last text is the rank entry;
	say last text.

Table of Achievements
message	points		used (a number)
"taking flight for the first time"	2
"making it to Sinister Isle"	3
"infiltrating Dr. Sinister's tower"	5
"restoring power to the base"	5
"bypassing the defense grid"	5
"getting the fuel truck moving"	5
"refueling the rocket"	5
"reaching the station"	5
"competent flying"	5
"ace flying"	5
"great justice"	10
"finding a light in the darkness"	10
"saving the day in the nick of time"	10

Table of Rankings
score	rank
0	"Mild-Mannered Reporter"
2	"Wild Talent"
5	"Third-String Hero"
15	"Dedicated Investigator"
30	"Relentless Pursuer"
35	"Unflinching Sentinel"
50	"Moving Up In The World"

Table of Challenges
title	description	completed
"TWO BIRDS WITH ONE STONE"	"Complete two navigation puzzles simultaneously."	false
"LORD OF THE SKIES"	"Beat the target time for the docking puzzle, earning the 'ace flying' score."	false
"NO ONE LEFT BEHIND"	"Complete the game with minimum endangerment of enemies, and make sure everyone else does too."	false
"NOT SO DIFFERENT AFTER ALL"	"Complete the game with maximum endangerment of enemies, and leverage the results for good."	false
"SELF-RELIANCE"	"Complete the game without using any takable items besides the energy drink."	false

To decide what number is the number of completed challenges:
	let result be 0;
	repeat through the Table of Challenges:
		if the completed entry is true, increment the result;
	decide on the result.

To decide what number is the number of remaining challenges:
	decide on the number of rows in the Table of Challenges minus the number of completed challenges.

To announce completed challenges:
	if the number of completed challenges is zero:
		say "[line break]You have completed no optional challenges.";
	otherwise:
		say "[line break]You have completed [if the number of completed challenges is one]this optional challenge[otherwise]the following optional challenges[end if]:[paragraph break]";
		repeat through the Table of Challenges:
			if the completed entry is true:
				say "[bold type][title entry]:[roman type] [description entry][line break]".

To say uncompleted challenges:
	if the number of remaining challenges is zero:
		say "Furthermore, you have completed all of the optional challenges. Congratulations!";[* This isn't actually possible until challenges persist the way achievements do, which will involve a kick up to Glulx that I'm delaying.]
	otherwise:
		say "You have [if the number of remaining challenges is one]one optional challenge remaining[otherwise][the number of remaining challenges in words] optional challenges remaining[end if]:[paragraph break]";
		repeat through the Table of Challenges:
			if the completed entry is false:
				say " - [description entry][line break]"

To complete the (T - some text) challenge :
	if there is a title corresponding to a title of T in the Table of Challenges:
		choose the row with a title of T in the Table of Challenges;
		now the completed entry is true.

Section 2 - New Endgame Options (in place of Section SR3/3 - Final question options in Standard Rules by Graham Nelson)

Table of Final Question Options
final question wording	only if victorious	topic	final response rule	final response activity
"RESTART"	false	"restart"	 immediately restart the VM rule	 --
"RESTORE a saved game"	 false	 "restore"	 immediately restore saved game rule	 --
"UNDO your last move"	 false	 "undo"	 immediately undo rule	 --
"see the FULL score for that game"	false	"full" or "score" or "full score"	announce the full score rule	--
"read the ENDNOTES"	 true	 "endnotes" or "amusing"	 --	 amusing a victorious player
"QUIT"	 false	 "quit"	 immediately quit rule	 --

Section 3 - Endnotes

Rule for amusing a victorious player:
	say "Congratulations on completing the game! In this playthrough, you completed [number of completed challenges in words] out of [number of rows in the Table of Challenges in words] optional challenges. They will be listed along with your full score. [uncompleted challenges][line break]In less serious suggestions, have you tried...[line break] - XYZZY?[line break]   - and the two nonstandard followups cued thereby?[line break] - Taking the rocket?[line break]   - Twice?[line break] - STEALing any small object?[line break] - Taking the tower?[line break] - Tying the rope to anything?[line break] - Falling, unpowered, through the open launch hatch?[line break] - Throwing something plot non-critical (like the silver key or the splintered wood) at the defense grid while it's on?[line break]   - Or something plot-critical like the energy drink?[line break]   - Or messing with it in any way afterwards?[line break] - Kicking things?[line break] - Screaming?[line break]   - While falling?[line break]   - Immediately before an impact?"

Part 5 - Testing materials - not for release

When play begins, seed the random-number generator with 1337.

When play begins (this is the run property checks at the start of play rule):
	repeat with item running through things:
		unless the item provides the property description or the item is a device or the item is a container or the item is a supporter or the item is Library message debug or the item is I7_LibraryMessages:
			say "[item] has no description."
