package iageserver;

import java.net.*;
import java.io.*;


/**
 * Server polling class. Runs on separate thread and waits for
 * new client connections.
 */
public class serverlisten implements Runnable {

  /** Reference to server's IP Socket */
  ServerSocket SS = null;
  /** Determines whether server is listening for new input */
  boolean isListening = true;
  /** Reference to the thread this process is running on */
  Thread tref;
  /** The port to listen on */
  private int listenport = 1111;

  /** Starts up a new serverlisten object on it's own thread */
  public serverlisten(int port) {
	listenport = port;
    // Start our class running in a new thread.
    tref = new Thread(this);
    tref.start();

  }

  /** Listen process itself. Starts listening and doesn't stop until
    * isListening becomes false. When isListening does become false, 
    * destroys the server socket and itself.
    */
  public void run() {

	  try {

		  // Run the games initialise event
		  interpreter init = new interpreter(new player(), new parsestring("!,!", new player(), ","));
		  init.runcode(data.ogame.OnInitialise, "Game.OnInitialise");
	
		  // Enumerate all the items and run their initialise code
		  // if they have some
		  int i = 1;
		  item im = null;
		  while (i <= data.oitems.getCount()) {
		  	  im = (item) data.oitems.get(i);
		  	  // Run the code
		      init.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", "initialise", new String[4], 0, "Internal.Initialise", 0, 0);
		  	  i++;
		  }
		  
		  // Same for locations
		  location l = null;
		  i = 1;
		  while (i <= data.olocations.getCount()) {
		  	  l = (location) data.olocations.get(i);
		  	  // Run the code
		      init.runcode(l.OnInput, "Location(" + l.Name + ").OnInput", "initialise", new String[4], 0, "Internal.Initialise", 0, 0);
		  	  i++;
		  }
		  
		  // Same for characters
		  character cc = null;
		  i = 1;
		  while (i <= data.ocharacters.getCount()) {
		  	  cc = (character) data.ocharacters.get(i);
		  	  // Run the code
		      init.runcode(cc.OnAction, "Character(" + cc.Name + ").OnAction", "initialise", new String[4], 0, "Internal.Initialise", 0, 0);
		  	  i++;
		  }
	  }
	  catch (Exception e) {
	  	  System.out.println("Initialisation error - non fatal.");
	  	  e.printStackTrace();
	  }

      try {
      	
          SS = new ServerSocket(listenport);
          vdu.println("Opened server listening process on: " + getInternetIP() + ": " + Integer.toString(listenport));
          
          // Start the NPC timers off when the server process is started
          // if we are using real-time NPCs.
          if (data.ogame.RealTimeNPCs)
          	data.onpctimer = new npctimer();
          
      } 
      catch (IOException e) {
          vdu.println("Could not initialise server on port: " + Integer.toString(data.ipport));
          return;
      }

      vdu.println("Waiting for client connection...");
      while (isListening) {
        try {
          new serverlistenthread(SS.accept()).start();
          tref.yield();
        }
        catch(IOException e) {
			// Do nothing - always generates an error when socket closed
			// because SS.accept blocks until connection received.
        }
      }

      try {
        SS.close();
      }
      catch(IOException e) {
        vdu.println("Error closing server socket - " + e.getMessage());
      }
  }

  /** Stops the object listening */
  public void stop() {
    
    isListening = false;
    
    // Stop NPC timer processes if we are running
    // real time NPCs
    if (data.ogame.RealTimeNPCs) {
    	data.onpctimer.StopRunning = true;
    }
    
    try {
    	SS.close();   	
	}
	catch(Exception e) {
		e.printStackTrace();
		vdu.println("Unable to close server socket: " + e.getMessage());	
	}
  }

  /** Returns the reference to the thread this process is running on */
  public Thread getThread() {
    return tref;
  }
  
	/**
	 *  Returns the Internet IP address for the current server
	 */
  	public String getInternetIP() {
  		
  		try {
			return InetAddress.getLocalHost().getHostAddress();
		}
		catch(Exception e) {
			e.printStackTrace();	
			return "<unable to get local host>";
		}
  }
}
