package iagecompiler;

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;

/**
 * Frame class used to display all objects to coder
 */
public class mainframe extends Frame {
	
  private data dat = null;
  private boolean dataloaded = false;
	
  /* Control tree:
  
  	contentPane (borderlayout)
  		txtoutput
  
  */
	
  private MenuBar jMenuBar1 = new MenuBar();
  private Menu jMenuFile = new Menu();
  private MenuItem jMenuFileCompile = new MenuItem();
  private MenuItem jMenuFileSave = new MenuItem();
  private MenuItem jMenuFileSaveEncrypted = new MenuItem();
  private MenuItem jMenuFileExit = new MenuItem();
  private Menu jMenuHelp = new Menu();
  private MenuItem jMenuHelpAbout = new MenuItem();
  
  private BorderLayout borderLayout = new BorderLayout();
  private TextArea txtoutput = new TextArea();
  
  private String curdir = ""; // Holds the last directory accessed
  
  /**Constructs a new server output window and displays it */
  public mainframe() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  
  /**Component initialization*/
  private void jbInit() throws Exception  {
  	
    this.setLayout(borderLayout);
    this.setSize(new Dimension(760, 480));
    this.setTitle("Compiler - IAGE");
  	
  	
  	// menubar
    jMenuFile.setLabel("File");
    jMenuFileCompile.setLabel("Compile");
    
    jMenuFileCompile.setLabel("Compile");
    jMenuFileCompile.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
      	jMenuFileCompile_actionPerformed(e);
      }
  	});
  	jMenuFileSaveEncrypted.setLabel("Save");
  	jMenuFileSaveEncrypted.setEnabled(false);
  	jMenuFileSaveEncrypted.addActionListener(new ActionListener() {
  		public void actionPerformed(ActionEvent e) {
  			jMenuFileSaveEncrypted_actionPerformed(e);
  		}
  	});
    jMenuFileExit.setLabel("Exit");
    jMenuFileExit.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuFileExit_actionPerformed(e);
      }
    });
    
    jMenuHelp.setLabel("Help");
    jMenuHelpAbout.setLabel("About");
    jMenuHelpAbout.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuHelpAbout_actionPerformed(e);
      }
    });
    ;
    jMenuFile.add(jMenuFileCompile);
    jMenuFile.addSeparator();
    jMenuFile.add(jMenuFileSaveEncrypted);
    jMenuFile.addSeparator();
    jMenuFile.add(jMenuFileExit);
    
    
    jMenuHelp.add(jMenuHelpAbout);
    
    jMenuBar1.add(jMenuFile);
    jMenuBar1.add(jMenuHelp);
    this.setMenuBar(jMenuBar1);

	// Controls
    txtoutput.setEditable(false);
    txtoutput.append("Internet Adventure Game Engine Compiler " + global.versionno + "\nCopyright(c)2000-2002, R.Rawson-Tetley.\n");
      
    // Show
    this.add(txtoutput, BorderLayout.CENTER);
 
 	// References
    data.theframe = this;
    vdu.console = txtoutput;

  }
  
  /**File | Compile action performed*/
  public void jMenuFileCompile_actionPerformed(ActionEvent e) {
  	new importiage().doimport();
  	jMenuFileSave.setEnabled(true);
  	jMenuFileSaveEncrypted.setEnabled(true);
  }
  
  /**File | Exit action performed*/
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    dispose();
  }
  
  /**File | SaveEncrypted action performed */
  public void jMenuFileSaveEncrypted_actionPerformed(ActionEvent e) {
  	// Ask user for output file name.
  	String curdir = "";
  	FileDialog chooser = new FileDialog(this, curdir); 
  	chooser.setTitle("Save Encrypted Compiled IAGE File As...");
  	chooser.show();
  	
  	if (chooser.getFile() == null) return;
	data.openfilename = chooser.getDirectory() + chooser.getFile();
	new data().SaveData(true);
  }
  
  /**Help | About action performed*/
  public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
    mainframe_AboutBox dlg = new mainframe_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.show();
  }
 
  /*** Writes a line of text to the outputstream specified */
  private void writeline(FileOutputStream out, String s) {
  	
  	byte[] ba = s.getBytes();
  	try {
  		out.write(ba);
  		// Dump a Windows type carriage return - it's a bytestream, who cares!
  		// The read process looks for Windows type carriage returns anyway
  		byte[] bb = { 13, 10 };
  		out.write(bb);
  	}
  	catch (Exception e) {
  		e.printStackTrace();
  		vdu.println("Error writing to file - " + e.getMessage());
  	}
  	
  }
 
   private String readline(FileInputStream fs) {
    // Reads a complete line of data from a file, throwing away the
    // Chr(13) and Chr(10)s.
    StringBuffer sb = new StringBuffer("");
    Integer iob;
    int nb = -1;
    //byte[] by;

    while (true) {

      // Read next byte from stream
      try {
        nb = fs.read();
      }
      catch(Exception e) {
        vdu.println("Error reading from file - " + e.getMessage());
        return sb.toString();
      }

      // if it's a -1 or a 13, better quit and return
      if (nb == 13) {
        try {
          nb = fs.read(); // ditch the chr(10) as well
        }
        catch(Exception e) {
          vdu.println("Error reading from file - " + e.getMessage());
          return sb.toString();
        }
        return sb.toString();
      }

      if (nb == -1) {
        // no more data - return what we have
        return sb.toString();
      }

      // Otherwise, append our jobbie into the string buffer
      iob = new Integer(nb);
      byte[] by = { iob.byteValue()};
      sb.append(new String(by));

    }

  }
  
  /*** Lets the user select their template */
  private void loadtemplate() {
  	
  	// Retrieve what our last file path used was:
  	String loadpath = new File("").getAbsolutePath() + File.separator + "lastpath.ini";
  	try {
	  	File ourpath = new File(loadpath);
	  	FileInputStream in = new FileInputStream(ourpath);
	  	curdir = readline(in);
	  	in.close();
	 }
	 catch (IOException ie)
	 {
	 	// Ignore	
	 }
  	
  	// Prompt for a file
  	FileDialog chooser = new FileDialog(this, ""); 
  	chooser.setTitle("Select the template library to compile with");
  	chooser.show();
  	
  	if (chooser.getFile() == null) return;
  	
	// Save the path of the file chosen 
	// in the user's profile directory in a file
	// called "lastpath.ini"
	curdir = chooser.getDirectory() + chooser.getFile();
	String savepath = new File("").getAbsolutePath() + File.separator + "lastpath.ini";
	try {
		File lastpath = new File(savepath);
		FileOutputStream out = new FileOutputStream(lastpath);
		writeline(out, curdir);
		out.close();
	}
	catch (IOException ex) {
		ex.printStackTrace();
	}
		
	// Load into the data objects
	try {
		dat = new data(chooser.getDirectory() + chooser.getFile());
		dataloaded = true;
		
		// Enable saving
		jMenuFileSave.setEnabled(true);
		jMenuFileSaveEncrypted.setEnabled(true);
		
	}
	catch (Exception ex) {
		ex.printStackTrace();	
	}
  	    
  }	
  
   
  /**Overridden so frame can destroy itself when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      	jMenuFileExit_actionPerformed(null);
    }
  }
}