/*
 * Decompiled with CFR 0.152.
 */
package iageserver;

import iageserver.adverb;
import iageserver.character;
import iageserver.codemodule;
import iageserver.error;
import iageserver.flag;
import iageserver.game;
import iageserver.iagecollection;
import iageserver.item;
import iageserver.location;
import iageserver.message;
import iageserver.noun;
import iageserver.npctimer;
import iageserver.runafterinput;
import iageserver.runbeforeinput;
import iageserver.vdu;
import iageserver.verb;
import java.io.File;
import java.io.FileInputStream;

public class data {
    static boolean fileeof = false;
    static boolean isencrypted = false;
    static int encrypttype = 0;
    public static final boolean debugging = false;
    public static int maxflags;
    public static int ipport;
    public static String versionno;
    public static String internalversion;
    public static String defaultnewplayername;
    public static boolean canstartenginenow;
    public static String lasterror;
    public static int numberofconnections;
    public static int nextplayerID;
    public static String gamepath;
    public static iagecollection oadverbs;
    public static iagecollection overbs;
    public static iagecollection onouns;
    public static game ogame;
    public static iagecollection olocations;
    public static iagecollection ocharacters;
    public static iagecollection oitems;
    public static iagecollection omodules;
    public static runafterinput orunafterinput;
    public static runbeforeinput orunbeforeinput;
    public static error oerror;
    public static npctimer onpctimer;
    public static iagecollection oplayers;
    public static iagecollection omessages;
    public static flag[] oflags;

    public data(String sfile) {
        block20: {
            canstartenginenow = false;
            numberofconnections = 0;
            nextplayerID = 1;
            oadverbs = new iagecollection();
            overbs = new iagecollection();
            onouns = new iagecollection();
            ogame = new game();
            olocations = new iagecollection();
            ocharacters = new iagecollection();
            oitems = new iagecollection();
            omodules = new iagecollection();
            orunafterinput = new runafterinput();
            orunbeforeinput = new runbeforeinput();
            oerror = new error();
            oplayers = new iagecollection();
            omessages = new iagecollection();
            oflags = new flag[maxflags];
            int flagcnt = 1;
            while (flagcnt < maxflags) {
                flag f;
                data.oflags[flagcnt] = f = new flag();
                ++flagcnt;
            }
            fileeof = false;
            File fh = new File(sfile);
            if (!fh.exists()) {
                vdu.println("file - " + sfile + " does not exist.");
                lasterror = "file - " + sfile + " does not exist.";
                return;
            }
            gamepath = sfile;
            try {
                FileInputStream in = new FileInputStream(fh);
                vdu.println(fh.getName() + " opened.");
                String buffline = data.readline(in);
                if (buffline.indexOf("IAGE 2") != -1) {
                    vdu.println("IAGE File Format 2.0 detected.");
                    buffline = data.readline(in);
                    if (buffline.indexOf("0") == -1) {
                        vdu.println("File is encrypted.");
                        isencrypted = true;
                        if (buffline.indexOf("1") != -1) {
                            encrypttype = 1;
                        }
                        if (buffline.indexOf("2") != -1) {
                            encrypttype = 2;
                        }
                    } else {
                        vdu.println("File is not encrypted.");
                        isencrypted = false;
                    }
                    vdu.println("Loading data, please wait...");
                    while (!fileeof) {
                        buffline = data.decrypt(data.readline(in));
                        if (this.comparestring(buffline, "GAME")) {
                            vdu.print("Reading game properties...");
                            this.loadgame(in);
                        }
                        if (this.comparestring(buffline, "LOCATIONS")) {
                            vdu.print("Reading locations...");
                            this.loadlocations(in);
                        }
                        if (this.comparestring(buffline, "ITEMS")) {
                            vdu.print("Reading objects...");
                            this.loaditems(in);
                        }
                        if (this.comparestring(buffline, "CHARACTERS")) {
                            vdu.print("Reading characters...");
                            this.loadcharacters(in);
                        }
                        if (this.comparestring(buffline, "MESSAGES")) {
                            vdu.print("Reading messages...");
                            this.loadmessages(in);
                        }
                        if (this.comparestring(buffline, "NOUNS")) {
                            vdu.print("Reading dictionary (nouns)...");
                            this.loadnouns(in);
                        }
                        if (this.comparestring(buffline, "ADVERBS")) {
                            vdu.print("Reading dictionary (adverbs)...");
                            this.loadadverbs(in);
                        }
                        if (this.comparestring(buffline, "VERBS")) {
                            vdu.print("Reading dictionary (verbs)...");
                            this.loadverbs(in);
                        }
                        if (this.comparestring(buffline, "MODULES")) {
                            vdu.print("Reading code modules...");
                            this.loadmodules(in);
                        }
                        if (this.comparestring(buffline, "RUNBEFOREINPUT")) {
                            vdu.print("Reading event code (1 of 2)...");
                            this.loadrunbeforeinput(in);
                        }
                        if (!this.comparestring(buffline, "RUNAFTERINPUT")) continue;
                        vdu.print("Reading event code (2 of 2)...");
                        this.loadrunafterinput(in);
                    }
                    vdu.println("Load complete.");
                    break block20;
                }
                vdu.println(sfile + " has an unrecognised file format.");
                lasterror = sfile + " has an unrecognised file format.";
                return;
            }
            catch (Exception e) {
                vdu.println("Error occurred: " + e.getMessage());
                lasterror = "Error occurred: " + e.getMessage();
                e.printStackTrace();
                return;
            }
        }
        canstartenginenow = true;
    }

    public static String readline(FileInputStream fs) {
        StringBuffer sb = new StringBuffer("");
        int nb = -1;
        boolean readabyte = false;
        while (true) {
            try {
                nb = fs.read();
            }
            catch (Exception e) {
                vdu.println("Error reading from file - " + e.getMessage());
                return sb.toString();
            }
            if (nb == 10 && !readabyte) {
                try {
                    nb = fs.read();
                }
                catch (Exception e) {
                    vdu.println("Error reading from file - " + e.getMessage());
                    return sb.toString();
                }
            }
            if (nb == 13 || nb == 10) {
                return sb.toString();
            }
            if (nb == -1) {
                fileeof = true;
                return sb.toString();
            }
            readabyte = true;
            Integer iob = new Integer(nb);
            byte[] by = new byte[]{iob.byteValue()};
            sb.append(new String(by));
        }
    }

    private void loadgame(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (buff.indexOf("END") == -1 && !fileeof) {
            if (data.comparebuff(buff, "MaxItemsCanCarry")) {
                data.ogame.MaxItemsCanCarry = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "MaxWeightCanCarry")) {
                data.ogame.MaxWeightCanCarry = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "MaxSizeCanCarry")) {
                data.ogame.MaxSizeCanCarry = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "StartingLocation")) {
                data.ogame.StartingLocation = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "RepeatDescription")) {
                data.ogame.RepeatDescription = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "ShowAvailableExits")) {
                data.ogame.ShowAvailableExits = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "AllowPersist")) {
                data.ogame.AllowPersist = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "SinglePlayerGame")) {
                data.ogame.SinglePlayerGame = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "MaxUsers")) {
                data.ogame.MaxUsers = (int)data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "IDEPassword")) {
                data.ogame.IDEPassword = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "Name")) {
                data.ogame.Name = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "OverrideSecondaryNouns")) {
                data.ogame.OverrideSecondaryNouns = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "MediaBase")) {
                data.ogame.MediaBase = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "UsingIAGECombat")) {
                data.ogame.UsingIAGECombat = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "UsingIAGEMoney")) {
                data.ogame.UsingIAGEMoney = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "WideDisplay")) {
                game.WideDisplay = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "RealTimeNPCs")) {
                data.ogame.RealTimeNPCs = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "PlayersStayDead")) {
                data.ogame.PlayersStayDead = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "NPCsStayDead")) {
                data.ogame.NPCsStayDead = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "DefaultHitPoints")) {
                data.ogame.DefaultHitPoints = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "DefaultDamage")) {
                data.ogame.DefaultDamage = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "DefaultMoney")) {
                data.ogame.DefaultMoney = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "DefaultChanceOfHitting")) {
                data.ogame.DefaultChanceOfHitting = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "ChanceOfHittingIncrementForKill")) {
                data.ogame.ChanceOfHittingIncrementForKill = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "DamageIndicatorIncrementForKill")) {
                data.ogame.DamageIndicatorIncrementForKill = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "OnAfterInputImmediate")) {
                data.ogame.OnAfterInputImmediate.add(data.getpropvalue_string(buff));
            }
            if (data.comparebuff(buff, "OnDisplayBanner")) {
                data.ogame.OnDisplayBanner.add(data.getpropvalue_string(buff));
            }
            if (data.comparebuff(buff, "OnQuit")) {
                data.ogame.OnQuit.add(data.getpropvalue_string(buff));
            }
            if (data.comparebuff(buff, "OnStart")) {
                data.ogame.OnStart.add(data.getpropvalue_string(buff));
            }
            if (data.comparebuff(buff, "OnScore")) {
                data.ogame.OnScore.add(data.getpropvalue_string(buff));
            }
            if (data.comparebuff(buff, "OnInitialise")) {
                data.ogame.OnInitialise.add(data.getpropvalue_string(buff));
            }
            buff = data.decrypt(data.readline(in));
        }
        vdu.println("OK.");
    }

    private void loadlocations(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (!this.comparestring(buff, "END") && !fileeof) {
            location l = new location();
            while (!(this.comparestring(buff, "BREAK") || fileeof || this.comparestring(buff, "END"))) {
                if (data.comparebuff(buff, "ID")) {
                    l.ID = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "Name")) {
                    l.Name = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "ImagePath")) {
                    l.ImagePath = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "Description")) {
                    l.Description = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "IsDark")) {
                    l.IsDark = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "CustomProperties")) {
                    l.CustomProperties = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "N")) {
                    l.N = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "S")) {
                    l.S = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "E")) {
                    l.E = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "W")) {
                    l.W = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "U")) {
                    l.U = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "D")) {
                    l.D = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "NE")) {
                    l.NE = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "NW")) {
                    l.NW = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "SE")) {
                    l.SE = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "SW")) {
                    l.SW = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "OnInput")) {
                    l.OnInput.add(data.getpropvalue_string(buff));
                }
                if (data.comparebuff(buff, "OnDisplay")) {
                    l.OnDisplay.add(data.getpropvalue_string(buff));
                }
                buff = data.decrypt(data.readline(in));
            }
            olocations.add(l);
            if (this.comparestring(buff, "END")) continue;
            buff = data.decrypt(data.readline(in));
        }
        vdu.println("OK (" + Integer.toString(olocations.getCount()) + " Locations).");
    }

    private void loaditems(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (!this.comparestring(buff, "END") && !fileeof) {
            item i = new item();
            while (!(this.comparestring(buff, "BREAK") || fileeof || this.comparestring(buff, "END"))) {
                if (data.comparebuff(buff, "ID")) {
                    i.ID = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "Name")) {
                    i.Name = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "CurrentLocation")) {
                    i.CurrentLocation = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "Weight")) {
                    i.Weight = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "Description")) {
                    i.Description = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "CustomProperties")) {
                    i.CustomProperties = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "UserBooleans")) {
                    i.UserBooleans = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "NounID")) {
                    i.NounID = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "IsLightSource")) {
                    i.IsLightSource = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "IsLit")) {
                    i.IsLit = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "IsWorn")) {
                    i.IsWorn = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "IsWeapon")) {
                    i.IsWeapon = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "Transparent")) {
                    i.Transparent = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "HasSurface")) {
                    i.HasSurface = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "CanBeLaidOn")) {
                    i.CanBeLaidOn = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "CanBeStoodOn")) {
                    i.CanBeStoodOn = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "CanBeSatOn")) {
                    i.CanBeSatOn = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "CanBeGotIn")) {
                    i.CanBeGotIn = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "DefaultExamine")) {
                    i.DefaultExamine = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "IsContainer")) {
                    i.IsContainer = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "IsEdible")) {
                    i.IsEdible = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "EdibleHitPoints")) {
                    i.EdibleHitPoints = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "IsWearable")) {
                    i.IsWearable = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "IsReadable")) {
                    i.IsReadable = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "ReadableText")) {
                    i.ReadableText = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "Size")) {
                    i.Size = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "DamageIndicator")) {
                    i.DamageIndicator = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "Invisible")) {
                    i.Invisible = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "IsFixed")) {
                    i.IsFixed = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "CanOpenClose")) {
                    i.CanOpenClose = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "OpenCloseState")) {
                    i.OpenCloseState = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "FixedMessage")) {
                    i.FixedMessage = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "IsSubItem")) {
                    i.IsSubItem = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "SubItemOf")) {
                    i.SubItemOf = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "OnAction")) {
                    i.OnAction.add(data.getpropvalue_string(buff));
                }
                buff = data.decrypt(data.readline(in));
            }
            oitems.add(i);
            if (this.comparestring(buff, "END")) continue;
            buff = data.decrypt(data.readline(in));
        }
        vdu.println("OK (" + Integer.toString(oitems.getCount()) + " Objects).");
    }

    private void loadcharacters(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (!this.comparestring(buff, "END") && !fileeof) {
            character c = new character();
            while (!(this.comparestring(buff, "BREAK") || fileeof || this.comparestring(buff, "END"))) {
                if (data.comparebuff(buff, "ID")) {
                    c.ID = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "Name")) {
                    c.Name = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "CurrentLocation")) {
                    c.CurrentLocation = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "Description")) {
                    c.Description = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "CustomProperties")) {
                    c.CustomProperties = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "NounID")) {
                    c.NounID = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "TimerInterval")) {
                    c.TimerInterval = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "DefaultExamine")) {
                    c.DefaultExamine = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "HitPoints")) {
                    c.HitPoints = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "DamageIndicator")) {
                    c.DamageIndicator = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "AutoAttack")) {
                    c.AutoAttack = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "AttackWhenAttacked")) {
                    c.AttackWhenAttacked = data.getpropvalue_boolean(buff);
                }
                if (data.comparebuff(buff, "Money")) {
                    c.Money = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "OnTimer")) {
                    c.OnTimer.add(data.getpropvalue_string(buff));
                }
                if (data.comparebuff(buff, "OnTalk")) {
                    c.OnTalk.add(data.getpropvalue_string(buff));
                }
                if (data.comparebuff(buff, "OnAction")) {
                    c.OnAction.add(data.getpropvalue_string(buff));
                }
                buff = data.decrypt(data.readline(in));
            }
            ocharacters.add(c);
            if (this.comparestring(buff, "END")) continue;
            buff = data.decrypt(data.readline(in));
        }
        vdu.println("OK (" + Integer.toString(ocharacters.getCount()) + " NPCs).");
    }

    private void loadverbs(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (!this.comparestring(buff, "END") && !fileeof) {
            verb v = new verb();
            while (!(this.comparestring(buff, "BREAK") || fileeof || this.comparestring(buff, "END"))) {
                if (data.comparebuff(buff, "ID")) {
                    v.ID = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "Text")) {
                    v.Text = data.getpropvalue_string(buff);
                }
                buff = data.decrypt(data.readline(in));
            }
            overbs.add(v);
            if (this.comparestring(buff, "END")) continue;
            buff = data.decrypt(data.readline(in));
        }
        vdu.println("OK (" + Integer.toString(overbs.getCount()) + " Verbs).");
    }

    private void loadadverbs(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (!this.comparestring(buff, "END") && !fileeof) {
            adverb v = new adverb();
            while (!(this.comparestring(buff, "BREAK") || fileeof || this.comparestring(buff, "END"))) {
                if (data.comparebuff(buff, "ID")) {
                    v.ID = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "Text")) {
                    v.Text = data.getpropvalue_string(buff);
                }
                buff = data.decrypt(data.readline(in));
            }
            oadverbs.add(v);
            if (this.comparestring(buff, "END")) continue;
            buff = data.decrypt(data.readline(in));
        }
        vdu.println("OK (" + Integer.toString(oadverbs.getCount()) + " Adverbs).");
    }

    private void loadmodules(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (!this.comparestring(buff, "END") && !fileeof) {
            codemodule co = new codemodule();
            while (!(this.comparestring(buff, "BREAK") || fileeof || this.comparestring(buff, "END"))) {
                if (data.comparebuff(buff, "ID")) {
                    co.ID = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "N")) {
                    co.Name = data.getpropvalue_string(buff);
                }
                if (data.comparebuff(buff, "C")) {
                    co.Code.add(data.getpropvalue_string(buff));
                }
                buff = data.decrypt(data.readline(in));
            }
            omodules.add(co);
            if (this.comparestring(buff, "END")) continue;
            buff = data.decrypt(data.readline(in));
        }
        vdu.println("OK (" + Integer.toString(omodules.getCount()) + " Code modules).");
    }

    private void loadnouns(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (!this.comparestring(buff, "END") && !fileeof) {
            noun v = new noun();
            while (!(this.comparestring(buff, "BREAK") || fileeof || this.comparestring(buff, "END"))) {
                if (data.comparebuff(buff, "ID")) {
                    v.ID = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "Text")) {
                    v.Text = data.getpropvalue_string(buff);
                }
                buff = data.decrypt(data.readline(in));
            }
            onouns.add(v);
            if (this.comparestring(buff, "END")) continue;
            buff = data.decrypt(data.readline(in));
        }
        vdu.println("OK (" + Integer.toString(onouns.getCount()) + " Nouns).");
    }

    private void loadrunbeforeinput(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (!this.comparestring(buff, "$END$") && !fileeof) {
            data.orunbeforeinput.code.add(buff);
            buff = data.decrypt(data.readline(in));
        }
        vdu.println("OK (" + Integer.toString(data.orunbeforeinput.code.getCount()) + " lines).");
    }

    private void loadrunafterinput(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (!this.comparestring(buff, "$END$") && !fileeof) {
            data.orunafterinput.code.add(buff);
            buff = data.decrypt(data.readline(in));
        }
        vdu.println("OK (" + Integer.toString(data.orunafterinput.code.getCount()) + " lines).");
    }

    private void loadmessages(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (!this.comparestring(buff, "END") && !fileeof) {
            message v = new message();
            while (!(this.comparestring(buff, "BREAK") || fileeof || this.comparestring(buff, "END"))) {
                if (data.comparebuff(buff, "ID")) {
                    v.ID = data.getpropvalue_long(buff);
                }
                if (data.comparebuff(buff, "Text")) {
                    v.Text = data.getpropvalue_string(buff);
                }
                buff = data.decrypt(data.readline(in));
            }
            omessages.add(v);
            if (this.comparestring(buff, "END")) continue;
            buff = data.decrypt(data.readline(in));
        }
        vdu.println("OK (" + Integer.toString(omessages.getCount()) + " Messages).");
    }

    public static long getpropvalue_long(String sbuff) {
        String p = data.getvalue(sbuff);
        return Long.parseLong(p);
    }

    public static String getpropvalue_string(String sbuff) {
        return data.getvalue(sbuff);
    }

    public static boolean getpropvalue_boolean(String sbuff) {
        String p = data.getvalue(sbuff);
        return p.equals("true") || p.equals("True");
    }

    public static String getvalue(String sbuff) {
        String paramvalue = sbuff.substring(sbuff.indexOf("=") + 1, sbuff.length());
        if (paramvalue.startsWith(" ") && paramvalue.length() == 1) {
            return "";
        }
        paramvalue = data.removeleadingspaces(paramvalue);
        paramvalue = data.removetrailingspaces(paramvalue);
        return paramvalue;
    }

    public static boolean comparebuff(String buff, String compareto) {
        if (buff.indexOf("=") == -1) {
            return false;
        }
        String prop = buff.substring(0, buff.indexOf("=") - 1);
        prop = data.removeleadingspaces(prop);
        return (prop = data.removetrailingspaces(prop)).equals(compareto);
    }

    private boolean comparestring(String buff, String compareto) {
        buff = data.removeleadingspaces(buff);
        return (buff = data.removetrailingspaces(buff)).equals(compareto);
    }

    public static String removeleadingspaces(String s) {
        s = s.trim();
        return s;
    }

    public static String removetrailingspaces(String s) {
        s = s.trim();
        return s;
    }

    public static String trimstring(String s) {
        s = s.trim();
        return s;
    }

    public static String decrypt(String s) {
        if (!isencrypted) {
            return s;
        }
        if (encrypttype == 1) {
            String Hex = "0123456789ABCDEF";
            byte[] ba = new byte[s.length() / 2];
            int bpos = 0;
            int ihi = 0;
            int ilo = 0;
            String shi = "";
            String slo = "";
            String out = "";
            int i = 0;
            while (i < s.length()) {
                shi = s.substring(i, i + 1);
                ihi = "0123456789ABCDEF".indexOf(shi) * 16;
                slo = s.substring(++i, i + 1);
                ilo = "0123456789ABCDEF".indexOf(slo);
                ba[bpos] = Byte.parseByte(Integer.toString(ihi + ilo));
                ++bpos;
                ++i;
            }
            out = new String(ba);
            out = out.substring(0, bpos);
            return out;
        }
        byte[] ba = s.getBytes();
        byte[] ob = new byte[ba.length];
        String out = "";
        int i = 0;
        while (i < ba.length) {
            ob[i] = ba[i];
            ob[i] = (byte)(ob[i] - 2);
            ++i;
        }
        out = new String(ob);
        return out;
    }

    public static String encrypt(String s) {
        String Hex = "0123456789ABCDEF";
        byte[] ba = s.getBytes();
        double cb = 0.0;
        double hi = 0.0;
        double lo = 0.0;
        int ihi = 0;
        int ilo = 0;
        String shi = "";
        String slo = "";
        String out = "";
        String hexrep = "";
        int i = 0;
        while (i < ba.length) {
            cb = ba[i];
            hi = cb / 16.0;
            int iihi = (int)hi;
            hi = iihi;
            lo = cb - hi * 16.0;
            shi = Double.toString(hi);
            slo = Double.toString(lo);
            if (shi.endsWith(".0")) {
                shi = shi.substring(0, shi.length() - 2);
            }
            if (slo.endsWith(".0")) {
                slo = slo.substring(0, slo.length() - 2);
            }
            ihi = Integer.parseInt(shi);
            ilo = Integer.parseInt(slo);
            hexrep = "0123456789ABCDEF".substring(ihi, ihi + 1);
            hexrep = hexrep + "0123456789ABCDEF".substring(ilo, ilo + 1);
            out = out + hexrep;
            ++i;
        }
        return out;
    }

    public static String booleanToString(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }

    public static boolean stringToBoolean(String s) {
        return s.equalsIgnoreCase("true");
    }

    static {
        debugging = false;
        maxflags = 1000;
        ipport = 1111;
        versionno = "Version 020709";
        internalversion = "Internet Adventure Game Engine " + versionno + "\nWritten by R.Rawson-Tetley\nCopyright(c)2000-2002, R.Rawson-Tetley";
        defaultnewplayername = "<new player>";
        canstartenginenow = false;
        lasterror = "No error.";
        numberofconnections = 0;
        nextplayerID = 1;
        gamepath = "";
        oadverbs = new iagecollection();
        overbs = new iagecollection();
        onouns = new iagecollection();
        ogame = new game();
        olocations = new iagecollection();
        ocharacters = new iagecollection();
        oitems = new iagecollection();
        omodules = new iagecollection();
        orunafterinput = new runafterinput();
        orunbeforeinput = new runbeforeinput();
        oerror = new error();
        onpctimer = null;
        oplayers = new iagecollection();
        omessages = new iagecollection();
        oflags = new flag[maxflags];
    }
}

