/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;

public class Displayer
extends Canvas {
    private Font theCurrentFont;
    private String theFontName = "";
    private int theFontSize;
    private int theFontStyle;
    private String theOldFontName = "";
    private int theOldFontSize;
    private Color theOldFontForeColour = Color.white;
    private FontMetrics fm;
    private boolean mIsBusy = false;
    private Color backColour = Color.blue;
    private Color foreColour = Color.white;
    private int lineRenderCount;
    private Image ibuffer;
    private Graphics igraphics;
    private boolean mIsReady = false;
    private Label statuslabel;

    public synchronized boolean getIsReady() {
        return this.mIsReady;
    }

    public synchronized void setIsReady(boolean bl) {
        this.mIsReady = bl;
    }

    public Displayer() {
        try {
            try {
                this.theCurrentFont = new Font("Dialog", 0, 12);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Object var2_2 = null;
            this.theFontName = this.theCurrentFont.getName();
            this.theFontSize = this.theCurrentFont.getSize();
            this.theFontStyle = 0;
            this.theOldFontName = this.theCurrentFont.getName();
            this.theOldFontSize = this.theCurrentFont.getSize();
            this.theOldFontForeColour = Color.white;
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.theFontName = this.theCurrentFont.getName();
            this.theFontSize = this.theCurrentFont.getSize();
            this.theFontStyle = 0;
            this.theOldFontName = this.theCurrentFont.getName();
            this.theOldFontSize = this.theCurrentFont.getSize();
            this.theOldFontForeColour = Color.white;
            throw throwable;
        }
    }

    public void paint(Graphics graphics) {
        if (this.ibuffer == null || this.ibuffer.getWidth(this) != this.getSize().width || this.ibuffer.getHeight(this) != this.getSize().height) {
            this.resize();
        }
        if (this.ibuffer == null) {
            return;
        }
        this.setIsReady(true);
        graphics.drawImage(this.ibuffer, 0, 1, this);
    }

    public synchronized void renderLine(String string, Label label) {
        this.statuslabel = label;
        this.doRender(string);
        this.scrollUpOneLine();
        this.incrementRenderCount();
        if (this.getRenderCount() >= this.getRows() - 1) {
            this.setIsBusy(true);
            this.showMore();
            this.repaint();
        }
    }

    public synchronized void incrementRenderCount() {
        ++this.lineRenderCount;
    }

    public synchronized void resetRenderCount() {
        this.lineRenderCount = 0;
    }

    public synchronized int getRenderCount() {
        return this.lineRenderCount;
    }

    public synchronized int getColumnWidth() {
        Dimension dimension = this.getSize();
        double d = dimension.width;
        double d2 = this.fm.charWidth('M');
        int n = (int)(d / d2) - 2;
        return n;
    }

    public synchronized boolean getStringWidth(String string) {
        Dimension dimension = this.getSize();
        double d = dimension.width;
        double d2 = this.fm.stringWidth(string);
        return d2 >= d - (double)this.getColumnWidth();
    }

    public synchronized int getRows() {
        this.updateFonts();
        return this.getSize().height / this.fm.getHeight() - 1;
    }

    public synchronized int getLineHeight() {
        return this.fm.getHeight();
    }

    public synchronized void scrollUpOneLine() {
        try {
            Graphics graphics = this.igraphics;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            int n3 = this.getLineHeight();
            graphics.copyArea(0, n3, n, n2 - n3, 0, -n3);
            this.eraseBottomLine();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void eraseBottomLine() {
        try {
            Graphics graphics = this.igraphics;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            int n3 = this.getLineHeight();
            graphics.setColor(this.backColour);
            graphics.fillRect(0, n2 - n3, n, n3);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void clearScreen() {
        try {
            Graphics graphics = this.igraphics;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            graphics.setColor(this.backColour);
            graphics.fillRect(0, 0, n, n2);
            this.repaint();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void showMore() {
        try {
            this.statuslabel.setText("[More...]");
            this.statuslabel.repaint();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void showPressAKey() {
        try {
            this.statuslabel.setText("[Press any key...]");
            this.statuslabel.repaint();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public synchronized boolean getIsBusy() {
        return this.mIsBusy;
    }

    public synchronized void setIsBusy(boolean bl) {
        if (this.mIsBusy && !bl) {
            this.resetRenderCount();
            this.statuslabel.setText("");
        }
        this.mIsBusy = bl;
    }

    public synchronized void doRender(String string) {
        try {
            Graphics graphics = this.igraphics;
            int n = this.getSize().height;
            int n2 = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            int n3 = 0;
            int n4 = 0;
            while (n2 < string.length()) {
                string3 = string.substring(n2, n2 + 1);
                if (string3.equals("<")) {
                    int n5;
                    int n6;
                    if (!string2.equals("")) {
                        this.updateFonts();
                        graphics.drawString(string2, n3, n - this.getLineHeight());
                        n3 += this.fm.stringWidth(string2);
                        string2 = "";
                    }
                    if ((string4 = string.substring(n2 + 1, n4 = string.indexOf(">", n2))).equalsIgnoreCase("B")) {
                        this.theFontStyle |= 1;
                    }
                    if (string4.equalsIgnoreCase("/B")) {
                        --this.theFontStyle;
                    }
                    if (string4.equalsIgnoreCase("I")) {
                        this.theFontStyle |= 2;
                    }
                    if (string4.equalsIgnoreCase("/I")) {
                        this.theFontStyle -= 2;
                    }
                    if (string4.toLowerCase().startsWith("font")) {
                        String string5;
                        this.theOldFontForeColour = this.foreColour;
                        this.theOldFontName = this.theFontName;
                        this.theOldFontSize = this.theFontSize;
                        n6 = 0;
                        n5 = 0;
                        int n7 = string4.indexOf("color=");
                        if (n7 != -1) {
                            n6 = n7 + 6;
                            n5 = string4.indexOf(" ", n7 + 7);
                            if (n5 == -1) {
                                n5 = string4.length();
                            }
                            if ((string5 = string4.substring(n6, n5).trim()).equals("white")) {
                                this.foreColour = Color.white;
                            }
                            if (string5.equals("black")) {
                                this.foreColour = Color.black;
                            }
                            if (string5.equals("blue") || string5.equals("navy")) {
                                this.foreColour = Color.blue;
                            }
                            if (string5.equals("gray")) {
                                this.foreColour = Color.gray;
                            }
                            if (string5.equals("yellow")) {
                                this.foreColour = Color.yellow;
                            }
                            if (string5.equals("red")) {
                                this.foreColour = Color.red;
                            }
                            if (string5.equals("pink")) {
                                this.foreColour = Color.pink;
                            }
                            if (string5.equals("orange")) {
                                this.foreColour = Color.orange;
                            }
                            if (string5.equals("magenta")) {
                                this.foreColour = Color.magenta;
                            }
                            if (string5.equals("lightgray")) {
                                this.foreColour = Color.lightGray;
                            }
                            if (string5.equals("darkgray")) {
                                this.foreColour = Color.darkGray;
                            }
                            if (string5.equals("green")) {
                                this.foreColour = Color.green;
                            }
                            if (string5.equals("cyan")) {
                                this.foreColour = Color.cyan;
                            }
                        }
                        if ((n7 = string4.indexOf("size=")) != -1) {
                            n6 = n7 + 5;
                            n5 = string4.indexOf(" ", n7 + 6);
                            if (n5 == -1) {
                                n5 = string4.length();
                            }
                            if ((string5 = string4.substring(n6, n5).trim()).equals("1")) {
                                this.theFontSize = 10;
                            }
                            if (string5.equals("2")) {
                                this.theFontSize = 12;
                            }
                            if (string5.equals("3")) {
                                this.theFontSize = 16;
                            }
                            if (string5.equals("4")) {
                                this.theFontSize = 24;
                            }
                            if (string5.equals("5")) {
                                this.theFontSize = 36;
                            }
                            if (string5.equals("6")) {
                                this.theFontSize = 72;
                            }
                        }
                        if ((n7 = string4.indexOf("face=")) != -1) {
                            n6 = n7 + 5;
                            n5 = string4.indexOf(" ", n7 + 6);
                            if (n5 == -1) {
                                n5 = string4.length();
                            }
                            this.theFontName = string5 = string4.substring(n6, n5).trim();
                        }
                    }
                    if (string4.equalsIgnoreCase("/FONT")) {
                        this.foreColour = this.theOldFontForeColour;
                        this.theFontName = this.theOldFontName;
                        this.theFontSize = this.theOldFontSize;
                    }
                    if (string4.equalsIgnoreCase("CLEARSCREEN")) {
                        this.clearScreen();
                        this.resetRenderCount();
                    }
                    if (string4.equalsIgnoreCase("WAITKEY")) {
                        this.showPressAKey();
                        this.setIsBusy(true);
                        this.repaint();
                    }
                    if (string4.toLowerCase().startsWith("bgcolor")) {
                        n6 = 0;
                        n5 = 0;
                        n6 = string4.indexOf(" ");
                        String string6 = string4.substring(n6 + 1, n5 = string4.length()).trim();
                        if (string6.equals("white")) {
                            this.backColour = Color.white;
                        }
                        if (string6.equals("black")) {
                            this.backColour = Color.black;
                        }
                        if (string6.equals("blue") || string6.equals("navy")) {
                            this.backColour = Color.blue;
                        }
                        if (string6.equals("gray")) {
                            this.backColour = Color.gray;
                        }
                        if (string6.equals("yellow")) {
                            this.backColour = Color.yellow;
                        }
                        if (string6.equals("red")) {
                            this.backColour = Color.red;
                        }
                        if (string6.equals("pink")) {
                            this.backColour = Color.pink;
                        }
                        if (string6.equals("orange")) {
                            this.backColour = Color.orange;
                        }
                        if (string6.equals("magenta")) {
                            this.backColour = Color.magenta;
                        }
                        if (string6.equals("lightgray")) {
                            this.backColour = Color.lightGray;
                        }
                        if (string6.equals("darkgray")) {
                            this.backColour = Color.darkGray;
                        }
                        if (string6.equals("green")) {
                            this.backColour = Color.green;
                        }
                        if (string6.equals("cyan")) {
                            this.backColour = Color.cyan;
                        }
                    }
                    this.updateFonts();
                    n2 = n4;
                } else {
                    string2 = String.valueOf(string2) + string3;
                }
                ++n2;
            }
            if (!string2.equals("")) {
                graphics.drawString(string2, n3, n - this.getLineHeight());
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void resize() {
        try {
            if (this.ibuffer != null) {
                Image image = this.ibuffer;
                this.ibuffer = this.createImage(this.getSize().width, this.getSize().height);
                this.igraphics = this.ibuffer.getGraphics();
                this.clearScreen();
                this.igraphics.drawImage(image, 0, this.getSize().height - image.getHeight(this), this);
            } else {
                this.ibuffer = this.createImage(this.getSize().width, this.getSize().height);
                this.igraphics = this.ibuffer.getGraphics();
                this.clearScreen();
            }
            this.updateFonts();
            this.repaint();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public synchronized void updateFonts() {
        if (this.igraphics != null) {
            try {
                try {
                    this.theCurrentFont = new Font(this.theFontName, this.theFontStyle, this.theFontSize);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object var2_2 = null;
                this.igraphics.setFont(this.theCurrentFont);
                this.igraphics.setColor(this.foreColour);
                this.fm = this.igraphics.getFontMetrics();
                return;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.igraphics.setFont(this.theCurrentFont);
                this.igraphics.setColor(this.foreColour);
                this.fm = this.igraphics.getFontMetrics();
                throw throwable;
            }
        }
    }
}

