# iotest.exe makefile
# for LCC-Win32

TARGET=iotest.exe

# PORT_NAME is for file-naming:
PORT_NAME=lcc
COMPILE=lcc
LINK=lcclnk

# Instead of specifying directories, we'll use a make.bat to
# copy all source files to the current directory--lcc doesn't
# seem to want to put .$(OBJ_EXT) files where it's told
#SOURCE_DIR=c:/hugo/source
SOURCE_DIR=.
#NONPORTABLE_DIR=c:/hugo/source/lcc
NONPORTABLE_DIR=.

OBJ_EXT=obj
NONPORTABLE_OBJS=he$(PORT_NAME).$(OBJ_EXT) hewin.obj

DEFINES=-DLCCWIN32 -DIOTEST
WFLAGS=-Wall
DFLAGS=-g
CFLAGS=-I$(SOURCE_DIR) $(WFLAGS) $(DFLAGS) $(DEFINES) -c
LFLAGS=-subsystem windows

OBJS=iotest.$(OBJ_EXT) stringfn.$(OBJ_EXT) \
$(NONPORTABLE_OBJS)

he.exe: $(OBJS)
	$(LINK) $(LFLAGS) -o $(TARGET) $(OBJS)


# Portable sources:

iotest.$(OBJ_EXT): $(SOURCE_DIR)/iotest.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/iotest.c

stringfn.$(OBJ_EXT): $(SOURCE_DIR)/stringfn.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/stringfn.c


# Non-portable sources:

he$(PORT_NAME).$(OBJ_EXT): $(NONPORTABLE_DIR)/he$(PORT_NAME).c
	$(COMPILE) $(CFLAGS) $(NONPORTABLE_DIR)/he$(PORT_NAME).c

hewin.obj: $(NONPORTABLE_DIR)/hewin.c
	$(COMPILE) $(CFLAGS) $(NONPORTABLE_DIR)/hewin.c
