/*
	HEWIN32.H

	Extern declarations for Win32 Hugo Engine files
*/

#ifdef UNDER_CE
#include "hewince.h"
#endif

#ifndef MAXPATH
#define MAXPATH         _MAX_PATH
#endif

#include <tchar.h>	// for Unicode
#include <stdio.h>

#define HOME_KEY		512
#define END_KEY			513
#define DELETE_KEY		514
#define INSERT_KEY		515
#define BACKSPACE_KEY		516
#define CTRL_LEFT_KEY		517
#define CTRL_RIGHT_KEY		518
#define OVERRIDE_UPDATE_CLIENT	1000
#define UPDATE_CLIENT		1001

/* hewin.c */
void UpdateClient(int visible_update);
void ConstrainCursor(void);
void ClipVisibleClient(void);
void MatchFont(int flags);
void ResetCharDimensions(int flags);
void SetClientDimensions(void);
void CreateMenus(void);
void ShowCompassRose(void);
int HandleContextCommands(int x, int y);
UINT APIENTRY CenterHookProc(HWND hwndDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);
HANDLE TryToOpenHandle(char *f, char *d);

extern TCHAR executable_module[];
extern HINSTANCE AppInstance;
extern HWND wndMain;
extern HMENU menuMain;
extern HBITMAP bmpMem;
extern HDC dcMem;
extern HFONT fontDefault, fontCurrent;
extern LOGFONT lfCurrent;
extern HACCEL accelMain;
extern char client_needs_updating;
extern char post_picture_update;
extern char client_painted;
extern int scroll_offset, scroll_offset_fill;
extern int caret_height;
extern BOOL override_resize_handling;
extern char waiting_for_key;
extern char disable_sounds;
extern int client_width, client_height;
extern int prop_charwidth, prop_lineheight;
extern int fixed_charset, prop_charset;
extern int last_hugo_font;
extern char scrollback_active;
extern char show_compass_rose;
extern char processed_accelerator_key;
extern int scrollback_pos;
extern TCHAR scrollback_buffer[];
extern TCHAR current_save_dir[];
extern int reg_FastGraphics;
extern int reg_DisplayGraphics;
extern int reg_GraphicsSmoothing;
extern int reg_PlaySounds;
extern int reg_AutoTranslateLatin1;

/* Most Recently Used file list: */
#define MRU_FILE_COUNT 4
extern TCHAR MRU_filename[][MAXPATH];

#ifdef UNICODE
char *strcpy_UtoA(char *a, WCHAR *u);
WCHAR *strcpy_AtoU(WCHAR *u, char *a);
WCHAR unicode_buffer[];
#endif

/* hemsvc.c */
int hugo_color(int c);
void PushKeypress(int k);
int PullKeypress(void);
void FlushBuffer(void);

extern char override_update_client;
extern char getline_active;
extern int current_back_color;
extern int current_window_left, current_window_top,
	current_window_right, current_windowbottom;

/* heres.c */
void hugo_stopmusic(void);
void hugo_stopsample(void);
void hugo_stopvideo(void);

/* hetemp.c */
int CreateResourceCache(char *name, FILE *file, long length);

/* hesound.cpp */
int InitPlayer(void);
void SuspendAudio(void);
void ResumeAudio(void);

extern char NT_sound_system;

/* hesound_nt.c */
extern char player_started;

/* hevideo.cpp */
struct VIDEO_WINDOW
{
	int left;
	int top;
	int right;
	int bottom;
	int width;
	int height;
};
extern struct VIDEO_WINDOW video_window;
extern char video_running;
extern char just_stopped_video;


