/*
	HCLCC.C

	Non-portable functions specific to LCC:

		hugo_splitpath
		hugo_makepath
		hugo_closefiles

	for the Hugo Compiler

	Copyright (c) 1995-2002 by Kent Tessman
*/


#include "hcheader.h"


/*
    FILENAME MANAGEMENT:

    Different operating systems will have their own ways of naming
    files.  The following routines are simply required to know and
    be able to dissect/build the components of a particular filename,
    storing/restoring the components via the specified char arrays.

    For example, in MS-DOS:

	hugo_splitpath("C:\HUGO\FILES\HUGOLIB.H", ...)
		becomes:  C:, HUGO\FILES, HUGOLIB, H

    and

	hugo_makepath(..., "C:", "HUGO\FILES", "HUGOLIB", "H")
		becomes:  C:\HUGO\FILES\HUGOLIB.H

    The appropriate equivalent nomenclature should be used for the
    operating system in question.
*/

void hugo_splitpath(char *path, char *drive, char *dir, char *fname, char *ext)
{
	char *file;
	char *extension;

        strcpy(drive, "");
        strcpy(dir, "");
        strcpy(fname, "");
        strcpy(ext, "");

        if ((file = strrchr(path, '\\'))==0)
        {
                if ((file = strrchr(path, ':'))==0) file = path;
        }

        strncpy(dir, path, strlen(path) - strlen(file));
        *(dir + strlen(path)-strlen(file)) = 0;
        extension = strrchr(path, '.');

        if (extension!=0)
        {
                strncpy(fname, file, strlen(file)-strlen(extension));
                *(fname + strlen(file)-strlen(extension)) = 0;
                strcpy(ext, extension+1);
        }
        else strcpy(fname, file);

	if (fname[0]=='\\') strcpy(fname, fname+1);
}

void hugo_makepath(char *path, char *drive, char *dir, char *fname, char *ext)
{
        strcpy(path, drive);
        strcat(path, dir);

	if ((strlen(dir) and path[strlen(path)-1]!='\\') and fname[0]!='\\')
		strcat(path, "\\");

        strcat(path,fname);

	if (*ext!='\0')
	{
	        if (*ext == '.') ext++;
        	strcat(path,".");
        	strcat(path,ext);
	}
}


/* hugo_closefiles

    Closes all open files.  NOTE:  If the operating system automatically
    closes any open streams upon exit from the program, this function may
    be left empty.
*/

void hugo_closefiles()
{
/*
	fclose(sourcefile);
	fclose(objectfile);
	fclose(textfile);
	fclose(allfile);
	fclose(listfile);
*/
}
