! ----------------------------------------------------------------------------
!  gGRAMMAR: German Grammar table entries for the standard verbs library.
!
!  This is release 0/5
!                                                                 
!  (c) Tinic Urou in 1996
!  orginal english version (c) by Graham Nelson 1993, 1994, 1995
! ----------------------------------------------------------------------------
!  The "meta-verbs", commands to the game rather than in the game, come first:
! ----------------------------------------------------------------------------

System_file;

Verb meta "score" "punkt" "punkte"
		*                                -> Score;
Verb meta "fullscore" "full" "gesamtpunkte" "gesamte" "gesamt"
		*                                -> FullScore
		* "score"                        -> FullScore
		* "punkte"                       -> FullScore;
Verb meta "q" "quit" "die" "end" "stirb" "ende" "enden" "beende" "beenden"
		*                                -> Quit;
Verb meta "restore" "lad" "lade" "laden"
		*                                -> Restore;
Verb meta "restart" "neustart"
		*                                -> Restart;
Verb meta "verify" "prf" "prfe"
		*                                -> Verify;
Verb meta "save" "sicher" "sichere" "sichern"
		*                                -> Save;
Verb meta "script" "skript"
		*                                -> ScriptOn
		* "aus"                          -> ScriptOff
		* "an"                           -> ScriptOn;
Verb meta "noscript" "unscript"
		*                                -> ScriptOff;
Verb meta "superbrief" "short" "kurz"
		*                                -> LMode3;
Verb meta "verbose" "long" "lang"
		*                                -> LMode2;
Verb meta "brief" "normal"
		*                                -> LMode1;
Verb meta "nomen" "pronomen"
		*                                -> Pronouns;
Verb meta "benachrichtigen" "melden"
		* "an"                           -> NotifyOn
		* "aus"                          -> NotifyOff;
Verb meta "version"
		*                                -> Version;
#IFNDEF NO_PLACES;
Verb meta "orte" "plaetze"
		*                                -> Places;
Verb meta "objekte" "gegenstaende"
		*                                -> Objects;
#ENDIF;

! ----------------------------------------------------------------------------
!  Debugging grammar
! ----------------------------------------------------------------------------

#ifdef DEBUG;
Verb meta "trace"
		*                                -> TraceOn
		* number                         -> TraceLevel
		* "on"                           -> TraceOn
		* "off"                          -> TraceOff;
Verb meta "actions"
		*                                -> ActionsOn
		* "on"                           -> ActionsOn
		* "off"                          -> ActionsOff;
Verb meta "routines"
		*                                -> RoutinesOn
		* "on"                           -> RoutinesOn
		* "off"                          -> RoutinesOff;
Verb meta "timers" "daemons"
		*                                -> TimersOn
		* "on"                           -> TimersOn
		* "off"                          -> TimersOff;
Verb meta "recording"
		*                                -> CommandsOn
		* "on"                           -> CommandsOn
		* "off"                          -> CommandsOff;
Verb meta "replay"
		*                                -> CommandsRead;
Verb meta "random"
		*                                -> Predictable;
Verb meta "purloin"
		* multi                          -> XPurloin;
Verb meta "abstract"
		* noun "to" noun                 -> XAbstract;
Verb meta "tree"
		*                                -> XTree
		* noun                           -> XTree;
Verb meta "goto"
		* number                         -> Goto;
Verb meta "gonear"
		* noun                           -> Gonear;
Verb meta "scope"
		*                                -> Scope
		* noun                           -> Scope;
#endif;

! ----------------------------------------------------------------------------
!  And now the game verbs.
! ----------------------------------------------------------------------------

Verb "nimm" "hol" "trag" "heb" "hole" "trage" "hebe"
		* multi                          -> Take
		* multi "auf"                    -> Take
		* multi "weg"                    -> Remove
		* multi "raus"                   -> Remove
		* multiinside "aus" noun         -> Remove
		* multiinside "von" noun         -> Remove
		* multiinside "vom" noun         -> Remove;
Verb "steh" "stehe"
		*                                -> Exit
		* "auf"                          -> Exit
		* "auf" noun                     -> Enter;
Verb "entfern" "entferne"
		* held                           -> Disrobe
		* multi                          -> Take
		* multiinside "von" noun         -> Remove
		* multiinside "vom" noun         -> Remove;
Verb "zieh" "ziehe"
		* held "aus"                     -> Disrobe
		* held "an"                      -> Wear
		* noun                           -> Pull
		* "an" noun                      -> Pull;
Verb "leg" "lege"
		* multiheld "ab"                 -> Drop
		* held "an"                      -> Wear
		* multiexcept "in" noun          -> Insert
		* multiexcept "auf" noun         -> PutOn;
Verb "steck" "stecke"
		* multiexcept "in" noun          -> Insert
		* multiexcept "auf" noun         -> Insert;
Verb "leer" "leere"
		* noun                           -> Empty
		* noun "aus"                     -> Empty
		* noun "in" noun                 -> EmptyT
		* noun "auf" noun                -> EmptyT;
Verb "lass"
		* multiheld "fallen"             -> Drop
		* multiheld "liegen"             -> Drop
		* multiheld "weg"                -> Drop;
Verb "verliere" "verlier"
		* multiheld                      -> Drop;
Verb "wirf"
		* multiheld                      -> Drop
		* multiheld "weg"                -> Drop
		* multiexcept "in" noun          -> Insert
		* multiexcept "zu" noun          -> Insert
		* multiexcept "zum" noun         -> Insert
		* held "zu" noun                 -> ThrowAt
		* held "auf" noun                -> ThrowAt
		* held "gegen" noun              -> ThrowAt;
Verb "bezahl" "biet" "fuetter" "bezahle" "biete" "fuettere"
		* creature held                  -> GiveR
		* creature held "an"             -> GiveR
		* held creature                  -> Give;
Verb "gib" "gebe"
		* creature held                  -> GiveR
		* held "zu" creature             -> GiveR
		* noun "zu" noun                 -> Transfer
		* held creature                  -> Give;
Verb "zeig" "praesentier" "zeige" "praesentiere"
		* creature held                  -> ShowR
		* held creature                  -> Show;
[ ADirection; if (noun in compass) rtrue; rfalse; ];
Verb "geh" "lauf" "renn" "verlass" "gehe" "laufe" "renne" "verlasse"
		*                                -> VagueGo
		* noun=ADirection                -> Go
		* "nach" noun=ADirection         -> Go
		* noun                           -> Enter
		* "in" noun                      -> Enter
		* "durch" noun                   -> Enter
		* "hinein"                       -> GoIn;
Verb "inventory" "inv" "i" "besitz"
		*                                -> Inv
		* "schmal"                       -> InvTall
		* "breit"                        -> InvWide;

[ ConTopic w; consult_from = wn;
  do w=NextWordStopped();
  until (w==-1 || (w=='to' && action_to_be==##Answer));
  wn--;
  consult_words = wn-consult_from;
  if (consult_words==0) return -1;
  if (action_to_be==##Ask or ##Answer or ##Tell)
  {   w=wn; wn=consult_from; parsed_number=NextWord();
      if (parsed_number=='the' && consult_words>1) parsed_number=NextWord();
      wn=w; return 1;
  }
  return 0;
];
[ ConTopicI w;
  consult_from = wn;
  do w=NextWordStopped(); until (w=='in' or -1); if (w==-1) return -1;
  wn--; consult_words = wn-consult_from;
  if (consult_words==0) return -1; return 0; ];

Verb "schau" "l" "schaue"
		*                                -> Look
		* "auf" noun                     -> Examine
		* noun "an"                      -> Examine
		* "in" noun                      -> Search
		* "unter" noun                   -> LookUnder
		* "durch" noun                   -> Search;
Verb "konsultier" "konsultiere"
		* noun "ueber" ConTopic          -> Consult
		* noun ConTopic                  -> Consult;
Verb "oeffne"
		* noun                           -> Open
		* noun "mit" held                -> Unlock;
Verb "schliess" "bedeck" "deck" "schliesse" "bedecke" "decke"
		* noun                           -> Close
		* noun "zu"                      -> Close
		* "ab"                           -> Lock
		* noun "ab"                      -> Lock
		* noun "auf"                     -> UnLock
		* "auf"                          -> UnLock
		* noun "mit" held "auf"          -> UnLock
		* noun "mit" held "zu"           -> Lock;
Verb "betret" "ueberquer" "betrete" "ueberquere"
		*                                -> GoIn
		* noun                           -> Enter;
Verb "sitz" "lieg" "sitze" "liege"
		* "auf" noun                     -> Enter
		* "in" noun                      -> Enter;
Verb "hinein" "innerhalb"
		*                                -> GoIn;
Verb "exit" "raus" "ausserhalb" "ausgang"
		*                                -> Exit;
Verb "untersuch" "x" "observier" "beschreibe" "beschreib" "untersuche" "observiere"
		* noun                           -> Examine;
Verb "lies"
		* noun                           -> Examine
		* "ueber" ConTopicI "in" noun    -> Consult
		* ConTopicI "in" noun            -> Consult;
Verb "ja" "y" "yes" "j"
		*                                -> Yes;
Verb "nein"
		*                                -> No;
Verb "sorry" "verzeihung"
		*                                -> Sorry;
Verb "mist" "scheiss" "verdammt" "scheisse"
		*                                -> Strong
		* special                        -> Strong;
Verb "verfluche" "verfluch" "plage" "plag"
		*                                -> Mild
		* special                        -> Mild;
Verb "such" "suche"
		* "in" noun                      -> Search
		* "im" noun                      -> Search
		* noun                           -> Search
		* noun "ab"                      -> Search;
Verb "schuettel" "schuettele"
		*                                -> WaveHands
		* noun                           -> Wave;
Verb "begruesse" "begruess"
		*                                -> WaveHands;
Verb "stell" "pass" "stelle" "passe"
		* noun                           -> Set
		* noun "ein"                     -> Set
		* noun "auf" special             -> SetTo;
Verb "beweg" "verschieb" "schieb" "bewege" "verschiebe" "schiebe"
		* noun                           -> Push
		* noun noun                      -> PushDir
		* noun "zu" noun                 -> Transfer;
Verb "drueck" "druecke"
		* noun "aus"                     -> Squeeze
		* noun                           -> Push
		* noun noun                      -> PushDir
		* noun "zu" noun                 -> Transfer;
Verb "dreh" "rotier" "schraub" "drehe" "rotiere" "schraube"
		* noun                           -> Turn
		* noun "an"                      -> Switchon
		* noun "ab"                      -> Switchoff
		* noun "weg"                     -> Switchoff;
Verb "schalt" "schalte"
		* noun                           -> Switchon
		* noun "an"                      -> Switchon
		* noun "aus"                     -> Switchoff;
Verb "attakier" "zerbrich"  "triff"  "kaempf"  "zerstoer"  "toet"  "zerbrech"
     "attakiere""zerbreche" "treffe" "kaempfe" "zerstoere" "toete"
		* noun                           -> Attack
		* noun "mit" held                -> Attack;
Verb "brech" "breche"
		* noun                           -> Attack
		* noun "mit" held                -> Attack
		* noun "auf"                     -> Attack;
Verb "wart" "z" "warte"
		*                                -> Wait;
Verb "antwort" "sag" "schrei" "sprich" "antworte"
		* ConTopic "zu" creature         -> Answer
		* ConTopic "zur" creature        -> Answer;
Verb "erzaehl" "erzaehle"
		* creature "ueber" ConTopic      -> Tell;
Verb "frag" "frage"
		* creature "ueber" ConTopic      -> Ask
		* creature "nach" noun           -> AskFor;
Verb "iss" "ess" "esse"
		* held                           -> Eat;
Verb "schlaf" "penn" "schlafe" "penne"
		*                                -> Sleep;
Verb "pul" "pule"
		* noun                           -> Take
		* noun "weg"                     -> Take;
Verb "sing" "singe"
		*                                -> Sing;
Verb "kletter" "klettere"
		* noun                           -> Climb
		* noun "hoch"                    -> Climb
		* noun "runter"                  -> Climb
		* "ueber" noun                   -> Climb;
Verb "kauf" "kaufe"
		* noun                           -> Buy;
Verb "zerdruecke" "zerdrueck" "quetsch" "quetsche"
		* noun "aus"                     -> Squeeze
		* noun                           -> Squeeze;
Verb "schwimm" "tauch" "schwimme" "tauche"
		*                                -> Swim;
Verb "schwing" "schwinge"
		* noun                           -> Swing
		* "zu" noun                      -> Swing;
Verb "blas" "blase"
		* held                           -> Blow;
Verb "bet" "bete"
		*                                -> Pray;
Verb "weck" "wach" "wecke" "wache"
		*                                -> Wake
		* "auf"                          -> Wake
		* creature                       -> WakeOther
		* creature "auf"                 -> WakeOther;
Verb "kuess" "umarm" "kuesse" "umarme"
		* creature                       -> Kiss;
Verb "denk" "denke"
		*                                -> Think;
Verb "riech" "rieche"
		*                                -> Smell
		* noun                           -> Smell;
Verb "hoer" "hoere"
		*                                -> Listen
		* noun "zu"                      -> Listen
		* "auf" noun                     -> Listen;
Verb "schmeck" "schmecke"
		* noun                           -> Taste;
Verb "beruehr" "fuehl" "beruehre" "fuehle"
		* noun                           -> Touch;
Verb "reib" "polier" "saeuber" "reibe" "poliere" "saeubere"
		* noun                           -> Rub;
Verb "bind" "verbind" "fixier" "binde" "verbinde" "fixiere"
		* noun                           -> Tie
		* noun "mit" noun                -> Tie;
Verb "brenn" "verbrenn" "erhell" "brenne" "verbrenne" "erhelle"
		* noun                           -> Burn
		* noun "mit" held                -> Burn;
Verb "trink" "sauf" "trinke" "saufe"
		* noun                           -> Drink;
Verb "fuell" "fuelle"
		* noun                           -> Fill;
Verb "schneid" "zerteil" "teil" "schneide" "zerteile" "teile"
		* noun                           -> Cut;
Verb "spring" "ueberspring" "hop" "springe" "ueberspringe"
		*                                -> Jump
		* "over" noun                    -> JumpOver;
Verb "grab"     * noun                           -> Dig
		* noun "mit" held                -> Dig;

! ----------------------------------------------------------------------------
!  Final task: provide trivial routines if the user hasn't already:
! ----------------------------------------------------------------------------

#Stub TimePasses      0;
#Stub Amusing         0;
#Stub DeathMessage    0;
#Stub DarkToDark      0;
#Stub NewRoom         0;
#Stub LookRoutine     0;
#Stub AfterLife       0;
#Stub GamePreRoutine  0;
#Stub GamePostRoutine 0;
#Stub AfterPrompt     0;
#Stub BeforeParsing   0;
#Stub PrintTaskName   1;
#Stub InScope         1;
#Stub UnknownVerb     1;
#Stub PrintVerb       1;
#Stub ParserError     1;
#Stub ParseNumber     2;
#Stub ChooseObjects   2;
#IFNDEF PrintRank;
Constant Make__PR;
#ENDIF;
#IFDEF Make__PR;
[ PrintRank; "."; ];
#ENDIF;
#IFNDEF ParseNoun;
Constant Make__PN;
#ENDIF;
#IFDEF Make__PN;
[ ParseNoun obj; obj=obj; return -1; ];
#ENDIF;
#Default Story 0;
#Default Headline 0;

! ----------------------------------------------------------------------------
