!
! File:         PrintSlow.h
!
! Description:  This is a library extension for Inform 6 that allows you to modify the speed at which text is printed to the
!               interpreter. This is not recommended for already slow devices like handhelds.
!
! Modification History
! Who           When            What
! D Cornelson   16-Mar-2003     Original
!
! 1. Include "PrintSlow"; into your program.
! 2. In the Initialise routine, set PrintSlowSettings.Override = false and PrintSlowSettings.Speed = 1 to 10;
!    1 is the fastest and 10 is the slowest.
!
! NOTE: Since so many things are printed in the library, if you really wanted everything effected, you'd have to do some serious
!       library modifications to make that happen. As it is, this will work for general printing.
!
! USAGE: printslow("text");
!
! NOTE: You cannot concatenate or use the comma in printslow....it requires one string less than 800 bytes long. If you need to
!       print variables or more than 800 bytes, you should break up your printing.
!
! NOTE: printslow(); does _not_ print a newline automatically so you have to add this on your own.
!
Object PrintSlowSettings with Speed 5, Override true;

Array print_slow_array ->	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
							0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;

[ printslow d i j w c cc ovr;
		ClearSlowArray();
		if (PrintSlowSettings.Override == true) {
			ovr = PrintSlowSettings.Speed;
			PrintSlowSettings.Speed = 0;
		}
		w = 0->33;
		c = 0;
		d.print_to_array(print_slow_array);
		for (i=2 : i<=(print_slow_array-->0+1) : i++) {
			c++;
			for (cc=i : cc<=(print_slow_array-->0+1) && print_slow_array->cc ~= 32 : cc++);
			if (c + (cc-i) >= w) {
				print (char) 13;
				c = 1;
			}
			if (print_slow_array->i / (11-PrintSlowSettings.Speed)*(11-PrintSlowSettings.Speed) == print_slow_array->i && PrintSlowSettings.Speed ~= 0)
			@read_char 1 1 DoNothing j;
			switch (print_slow_array->i) {
				13:			print (char) 13;
							c = 0;
				126:		print (char) 34;
				default:	print (char) print_slow_array->i;
			}
		}
		if (PrintSlowSettings.Override == true) {
			PrintSlowSettings.Speed = ovr;
		}
];

[ DoNothing; 	rtrue; ];

[ ClearSlowArray i;	for (i=1 : i<800 : i++) print_slow_array->i = 0; ];
