! scenery.h  Version 2
! Part of Platypus release 4
! Copyright 2001 Anson Turner.
!
! Inspired by "scenic.h" by Richard Barnett, Joe Mason, Roger Firth,
! and Stefano Gaburri.


! To use, give an object (it does not have to be a room) a "scenery"
! property with the following format:
!
! (dictionary words) (0 or 1) (string or routine) (dictionary words)...
!
! For example:
!
! Object glass "drinking glass"
!   with
!     name 'glass' 'drinking',
!     description "It has a picture of Ricky Rat on it.",
!     scenery 'ricky' 'rat' 'picture' 0 "His face is frozen in a feral grin.";
!
! The dictionary words are the names of a bit of scenery or a feature
! of the object. The 0 or 1 marks the end of the vocabulary. When the player
! tries to examine the pseudo-object, the description given in the string is
! printed (or the routine is called). If the player tries to do anything else
! to the object, a message is printed, in the plural if the end-marker is 1
! (rather than 0):
!
!     You can't do anything with that (those).
!
! This is a library message (Miscellany 526) which can be replaced as usual
! via +messages()+ properties.
!
! After the string or routine, you can include more sets of words with
! accompanying end markers and text/routine, keeping in mind that a
! property can hold a maximum of 32 entries (unless you are using Glulx).

! Note that pronouns are never set to scenery, which could conceivably
! cause problems:
!
! >EXAMINE PIN
! The pin is securely inserted in the grenade.
!
! >EXAMINE TAPESTRY
! It depicts a unicorn. (Very uninspired.)
!
! >TAKE IT
! You pull the pin from the grenade.
!
! ...etc.


System_file;

ScopeCogs SceneryImp "(Scenery Imp)"
  has concealed static,
  private scenery, itvalue,
  with
    soutput, smess, mlen,
    join_scope
    [ obj;
        if (obj == player &&
            scope_reason == PARSING_REASON or MEDDLE_EARLY_REASON)
            rtrue;
    ],
    disambiguate RoutFalse,
    short_name [;
        if (meta) print (object) self;
        else print "something";
        rtrue;
    ],
    parse_name [;
        
        self.itvalue = PronounValue('it');
        self.mlen = 0;
        
        LoopOverScope(Parse__Scenery);
        
        return self.mlen + 10000;
    ],
    meddle_early [;
        if (self == noun or second)
        {  
            if (PronounValue('it') == self)
                SetPronoun('it', self.itvalue);

            if (action == ##Examine && self.soutput)
                return PrintOrRun(self, soutput);
        
            SceneryMetaRoutine();

            return L__M(##Miscellany, 526, self.smess);
        }
    ];

[ SceneryMetaRoutine;

    if (action ~= ##Examine || SceneryImp.soutput == 0)
        meta = true;
];

[ Parse__Scenery obj     c pc pl paddr sr rl ml;
    
    if (obj provides scenery)
    {   paddr = obj.&scenery;
        pl = obj.#scenery / WORDSIZE;
        for (c = 0:c < pl:c++)
        {   pc = paddr-->c;
            if (pc == 0 or 1)
            {   rl = c - sr + 1;
                ml = Parse__Range(paddr+sr*WORDSIZE, rl);
                if (ml && ml > SceneryImp.mlen)
                {   SceneryImp.mlen = ml;
                    SceneryImp.smess = pc;
                    SceneryImp.soutput = paddr-->(c+1);
                }
                c++;
                sr = c + 1;
            }
        }
    }
];

[ Parse__Range addr len     l own w;

    own = wn;
    while ((w = NextWord()) ~= 0 && FindByWord(w, addr, len) ~= -1)
        l++;
    wn = own;
    return l;
];


#IFDEF DEBUG;
ShowobjCogs
  with
    knows_property [ p;
        if (p == scenery) rtrue;
    ],
    print_property [;
        print "???";
    ];
#ENDIF;
