!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.02.19 ORNameable [Z, GLULX]
! Gives an object the ability to be named and then be referred to by that name.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep :	ORLibraryMessages
!--------------------------------------------------------------------------------------
! To create a nameable object, simple derive it from ORNameable:
!
!	object golem "Golem"
!		has	animate  
!		class ORNameable
!		with description "The creature looks dirty and pathetic."
!		,	name 'golem'
!	;
!
! And during game play you can name the golem with a command similar to:
!
!	>name golem "bob"
!
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORNameable";					!Constant USE_ORNameable; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORNameable; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.12	Initial Creation
! 2002.02.26	Fit to new template
! 2002.02.27	Fixed search and replace error when applying new framework.
! 2002.07.07	Added menu documentation.
! 2002.10.19	Added autodep for ObjectInitialise 
! 2003.02.19	Added better ifdef for self docs
!--------------------------------------------------------------------------------------
#ifdef USE_ORNameable;message "          Processing library extension ORNameable...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
#ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
	#ifndef USE_ORLibraryMessages; Constant USE_ORLibraryMessages; message "          ****Forcing inclusion of ORLibraryMessages****"; #include "ORLibraryMessages"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORNameable_DONEREPLACE; constant ORNameable_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORNameable_DONEMESSAGE; constant ORNameable_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORNameable requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------
	global named_wn;
	global named_article;
	#ifndef MAX_SIZE; constant MAX_SIZE=9;#endif;
	class ORNameable 
		with	custom_name	0 0 0 0 0 0 0 0 0 0 !--up to 20 characters in length
		,	after_description false !--used to passthrough the following short_name (used with recursion)
		,	short_name[; if(self.after_description==false){
							self.after_description=true;
							print (name)self;
							if(self.&custom_name->0~=0){
								print " (or ";
								self.named_name();
								print ")";
							}
							self.after_description=false;
							rtrue;
						}
				]
		,	custom_article 0
		,	before[;
				Name:	if(noun==self) {
							self.set_name(named_wn);
							rtrue;
						}
			]
		,	parse_name[w t count o swn add length;
				length=WordLength(wn);
				if(length>MAX_SIZE) length=MAX_SIZE;
				if(parser_action==##TheSame){   
					for(t=0:t<self.#custom_name:t++) if(parser_one.&custom_name->t~=parser_two.&number->i) return -2; !--different
					return -1; !--indistinguishable
				}
				while(true){
					swn=wn;
					w=NextWord();
					t=WordInProperty(w,self,name);
	#ifdef USE_ORRecogName;
					if(t<1 || w==0) t=MatchAgainstShortName(self,swn);
	#endif;				
					if(t<1){
						add=WordAddress(swn);
						t=true;
						for(o=0:o<length:o++){
							if(add->o~=self.&custom_name->o){
								t=false;
								break;
							}
						}
					}
					if(t<1) {
						if(count>0) return count;
						return -1;
					}
					count++;
				}
			]
		,	named_name[t temp;
				switch(self.custom_article){
					'a':print "a ";
					'an': print "an ";
					'the': print "the ";
				}
				for(t=0:t<self.#custom_name:t++){
					temp=(self.&custom_name->t);
					if(temp==0) continue;
					if(self.custom_article==0 && t==0) temp=temp-32;
					print (char)temp;
				}
			]
		,	set_name[addr len t;
				if(named_wn==0) rfalse;
				addr=WordAddress(named_wn);
				len=WordLength(named_wn);
				if(len==0) rfalse;
				if(len>self.#custom_name)len=self.#custom_name;
				for(t=0:t<self.#custom_name:t++) self.&custom_name->t=0; !-zero out name first
				for(t=0:t<len:t++) self.&custom_name->t=addr->t; !--copy new name in
				self.custom_article=named_article;
				L__M(##Name,1,self);
				rtrue;
			]	
	;
	ORLibMessage with body[;
			Name:	
				switch(lm_n){
					1 :	noun.after_description=true;
						print (ig)CIVerb(actor,"began","begin")," to think of ",(the)noun," as ";
						if(noun.custom_article==0) print "~";
						noun.named_name();
						print".";
						if(named_article==0)print"~";
						noun.after_description=false;
					2:	bkt_o(); 
						print (CICant)noun," be named."; 
						bkt_c();
				}
		];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORNameable_DONECODE;constant ORNameable_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORNameable_DONEGRAMMAR; constant ORNameable_DONEGRAMMAR; #ifdef ORNameable_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------
	!-- isolate a single word, possibly quoted (name knife "stinger")
	!-- and possibly beginning with an article (refer to the knife as a sword)
	[single_word addr; 
		named_wn=wn++; 
		named_article=0;
		if(WordAddress(named_wn)->0=='"')named_wn=wn++; !--strip out quotes
		addr=WordAddress(named_wn);
		if(WordLength(named_wn)==3 && addr->0=='t' && addr->1=='h' && addr->2=='e') named_article='the';
		if(WordLength(named_wn)==2 && addr->0=='a' && addr->1=='n') named_article='an';
		if(WordLength(named_wn)==1 && addr->0=='a') named_article='a';
		if(named_article~=0) named_wn=wn++; !--strip out article
		if(WordAddress(named_wn+1)->0=='"') wn++; 
		rtrue; 
	];
	[NameSub; 	L__M(##Name,2,self);];
	Verb 'name'
		* noun single_word->Name
		* noun 'as'/'to' single_word ->Name	
	;
	Verb 'refer'
		* 'to' noun 'as' single_word ->Name
	;
	verb 'dub' = 'name';
	verb 'call' = 'name';
#ifdef ORMenuCatch;
	!--Commands, document thyself.
	ORMenu ORHelpName "Name" with text "Some objects can be named. That is, certain objects can be named by the player and then referred to by that given name. For example:^^NAME SWORD BOB^^can then be followed with:^^PUT BOB IN SHEATH."
		,	object_initialise[;	if(ORMenuCatch~=0) move self to ORMenuCatch; ]
	;
#endif;
!--------------------------------------------------------------------------------------
#endif; #endif; #endif;
