#!/usr/bin/env python

import re
import string

header = open("glkc.h", "r")
wrapper = open("glk.py", "w")

wrapper.write(
"""import glkc

interruptHandler = None

def callInterruptHandler():
	if interruptHandler != None:
		interruptHandler()

class Shadow:
	def __cmp__(self, other):
		if other == None:
			return 1 
		elif self.this == other.this:
			return 0
		elif self.this < other.this:
			return -1
		else:
			return 1

class event_t(Shadow):
	def __init__(self, obj):
		self.this = glkc.new_event_t(obj)
	def __del__(self):
		glkc.delete_event_t(self.this)
	def __getattr__(self, name):
		if name == "type":
			return glkc.event_t_type_get(self.this)
		elif name == "win":
			return safeInit(winid_t, glkc.event_t_win_get(self.this))
		elif name == "val1":
			return glkc.event_t_val1_get(self.this)
		elif name == "val2":
			return glkc.event_t_val2_get(self.this)
		else:
			# FIXME: gives wrong error message if name doesn't exist
			return self.__dict__[name]
	def __setattr__(self, name, value):
		if name == "type":
			glkc.event_t_type_set(self.this, value)
		elif name == "win":
			glkc.event_t_win_set(self.this, safeRef(winid_t, value))
		elif name == "val1":
			glkc.event_t_val1_set(self.this, value)
		elif name == "val2":
			glkc.event_t_val2_set(self.this, value)
		else:
			self.__dict__[name] = value

class buffer_t(Shadow):
	def __init__(self, str, maxlen):
		if str == None:
			str = ""
		self.this = glkc.new_buffer_t(str, maxlen)
	def __del__(self):
		glkc.delete_buffer_t(self.this)
	def snapshot(self):
		return glkc.snapshot_whole_buffer(self.this)
	def snapshot(self, len):
		return glkc.snapshot_buffer(self.this, len)
	def maxlen(self):
		return glkc.get_buffer_maxlen(self.this)

class winid_t(Shadow):
	def __init__(self, obj):
		self.this = glkc.new_window_t(obj)
	def __del__(self):
		glkc.delete_window_t(self.this)

class strid_t(Shadow):
	def __init__(self, obj):
		self.this = glkc.new_stream_t(obj)
	def __del__(self):
		glkc.delete_stream_t(self.this)

class frefid_t(Shadow):
	def __init__(self, obj):
		self.this = glkc.new_fileref_t(obj)
	def __del__(self):
		glkc.delete_fileref_t(self.this)

class schannid_t(Shadow):
	def __init__(self, obj):
		self.this = glkc.new_schannel_t(obj)
	def __del__(self):
		glkc.delete_schannel_t(self.this)

def safeInit(klass, obj):
	if obj == None:
		return None
	else:
		return klass(obj)

def safeRef(klass, obj):
	if obj == None:
		return None
	else:
		return obj.this 

def set_interrupt_handler(func):
	global interruptHandler
	interruptHandler = func

def rangeCheckedChr(x):
	if x in range(0, 256): 
		return chr(x)
	else:
		return x

def exit():
	glkc.glk_exit()

def gestalt_ext(sel, val, arrlen): 
	r = glkc.glk_gestalt_ext(sel, val, arrlen)
	try:
		(r0, r1) = r
		return (r0, r1)
	except TypeError:
		return (None, None)

def window_close(win):
	r = glkc.glk_window_close(safeRef(winid_t, win))
	try:
		(r0, r1) = r
		return (r0, r1)
	except TypeError:
		return (None, None)

def stream_close(str):
	r = glkc.glk_stream_close(safeRef(strid_t, str))
	try:
		(r0, r1) = r
		return (r0, r1)
	except TypeError:
		return (None, None)

def get_line_stream(str, len):
	r0 = glkc.glk_get_line_stream(str, len)
	return r0

def get_buffer_stream(str, len):
	r0 = glkc.glk_get_buffer_stream(str, len)
	return r0

def stream_open_memory(buf, fmode, rock):
	r0 = glkc.glk_stream_open_memory(safeRef(buffer_t, buf), fmode, rock)
	return safeInit(strid_t, r0)

def request_line_event(win, buf, initlen):
	glkc.glk_request_line_event(safeRef(winid_t, win), safeRef(buffer_t, buf), initlen)

""")

overriddenFuncs = [	"set_interrupt_handler",
					"exit",
					"gestalt_ext",
					"get_line_stream",
					"get_buffer_stream",
					"stream_open_memory",
					"request_line_event" ]
convertedTypes = {	"event_t"			: "event_t",
					"window_t"			: "winid_t",
					"stream_t"			: "strid_t",
					"fileref_t"			: "frefid_t",
					"schannel_t"		: "schanid_t" }

def convertedReturnType(i, returnTypes):
	if convertedTypes.has_key(returnTypes[i]):
		return "safeInit(%s, r%d)" % (convertedTypes[returnTypes[i]], i)
	elif returnTypes[i] in ["unsigned char", "glsi32"]:
		return "rangeCheckedChr(r%d)" % i
	else:
		return "r%d" % i

def convertedArg(i, argNames, argTypes):
	if convertedTypes.has_key(argTypes[i]):
		return "safeRef(%s, %s)" % (convertedTypes[argTypes[i]], argNames[i])
	elif argTypes[i] == "unsigned char":
		return "ord(%s)" % argNames[i]
	else:
		return argNames[i]

def writeConstant(words):
	if words[1][0:4] != "GLK_":
		wrapper.write("%s = glkc.%s\n" % (words[1], words[1]))
		wrapper.write("\n")

def writeFunction(words):
	i = 1
	returnTypes = []
	if words[i] == "unsigned":
		returnTypes.append("%s %s" % (words[i], words[i+1]))
		i += 1
	elif words[i] != "void":
		returnTypes.append(words[i])
	i += 1
	funcName = words[i]
	i += 1
	argTypes = [] 
	argNames = []
	while i < len(words):
		if words[i] == "void":
			type = words[i]
			name = ""
		elif words[i] == "unsigned":
			type = "%s %s" % (words[i], words[i+1])
			i += 2 
			name = words[i]
		else:
			type = words[i]
			i += 1
			name = words[i]
		if name[-3:] == "ptr" or name == "result" or name == "event":
			returnTypes.append(type)
		else:
			argTypes.append(type)
			argNames.append(name)
		i += 1
	if not funcName[4:] in overriddenFuncs:
		wrapper.write("def %s(%s):\n" % (funcName[4:],
			string.join(argNames, ", ")))
		wrapper.write("\t");
		if len(returnTypes) == 0:
			pass
		elif len(returnTypes) == 1:
			wrapper.write("r0 = ")
		else:
			wrapper.write("r = ")
		wrapper.write("glkc.%s(%s)\n" % (funcName, string.join(
			[convertedArg(i, argNames, argTypes) for i in
			range(0, len(argNames))], ", ")))
		if len(returnTypes) == 0:
			pass
		elif len(returnTypes) == 1:
			wrapper.write("\treturn %s\n" % convertedReturnType(0,
				returnTypes))
		else:
			wrapper.write("\ttry:\n")	
			wrapper.write("\t\t(%s) = r\n" % string.join(["r%d" % i for i in
				range(0, len(returnTypes))], ", "))
			wrapper.write("\t\treturn (%s)\n" % string.join(
				[convertedReturnType(i, returnTypes) for i in
				range(0, len(returnTypes))], ", "))
			wrapper.write("\texcept TypeError:\n")
			wrapper.write("\t\treturn (%s)\n" % string.join(["None" for i in
				range(0, len(returnTypes))], ", "))
		wrapper.write("\n")

lines = header.readlines()
for line in lines:
	words = [w for w in re.split("\W*", line) if w != ""]

	if words:
		if words[0] == "define":
			writeConstant(words)
		elif words[0] == "extern":
			writeFunction(words)
