/* Streams.h - definitions for Streams.c */
/*
	Copyright (c) 1993, by David Michael Betz
	All rights reserved
*/

#ifndef __STREAMS__
#define __STREAMS__

/* buffer size */
#define BSIZE	512

/* open modes */
#define StreamRead	1
#define StreamWrite	2

/* end of file indicator for StreamGetC */
#define StreamEOF	-1

typedef struct {
  short fRefNum;
  short mode;
  unsigned char buf[BSIZE];
  int ptr;
  long cnt;
} Stream,**StreamHandle;

/* prototypes */
StreamHandle OpenStream(ConstStr255Param fName,short vRefNum);
StreamHandle CreateStream(ConstStr255Param fName,short vRefNum,long type,long creator);
void CloseStream(StreamHandle fh);
int StreamGetC(StreamHandle fh);
int StreamGetLine(StreamHandle fh,Str255 str);
int StreamPutC(StreamHandle fh,int ch);
void StreamPutString(StreamHandle fh,ConstStr255Param str);

#endif