{ -------------------------------------------------------------------------- }
{ --------------- UNIDAD DE VGA256 -> Cosas para los graficos -------------- }
{ ----------------------- Alberto Salazar Palomo --------------------------- }
{ ----------------------- (C) Navigator Soft 1997 -------------------------- }
{ -------------------------------------------------------------------------- }
Unit VGA256;

INTERFACE

Uses Paletas;

Var VgaVideo:Pointer;

PROCEDURE VACIA;
PROCEDURE MODOTEXTO;
PROCEDURE SPCOPY (var p1,p2:pointer;x,y,ax,ay,xs,ys:integer;f:boolean);
Procedure ReserveScreen(Var ScreenPointer:Pointer);
Procedure DeleteScreen(Var ScreenPointer:Pointer);
Procedure ReserveBlock(Ancx,Ancy:Word;Var Image:Pointer);
Procedure GetBlock(X,Y,Ancx,Ancy:Integer;Var Image:Pointer);
Procedure DelBlock(Var Image:Pointer);

Function  XBlock(Block:Pointer):Word;
Function  YBlock(Block:Pointer):Word;
Function  BlockSize(S:Pointer):Word;

Procedure SetScreen(N:Byte);
Procedure SetVGA256;
Procedure SaveScreen(ScreenPointer:Pointer);
Procedure RestoreScreen(ScreenPointer:Pointer);
Procedure ScreenCopy(Origen,Destino:Pointer);
Procedure ScreenZoneCopy(Origen:Pointer;X,Y,Ancx,Ancy:Word;Destino:Pointer;Dx,Dy:Word);
Procedure SetVgaOut(Scr:Pointer);
Procedure RestoreVgaOut;
Procedure WaitVBL;

Procedure ReGetBlock(X,Y:Word;Image:Pointer);
Procedure PutSprite(X,Y:Integer;Trans:Byte;Image:Pointer);
Procedure PutSpFlipX(X,Y:Integer;Trans:Byte;Image:Pointer);
Procedure PutSpFlipY(X,Y:Integer;Trans:Byte;Image:Pointer);
Procedure PutBlock(X,Y:Integer;Image:Pointer);
Procedure PutBlFlipX(X,Y:Integer;Image:Pointer);
Procedure PutBlFlipY(X,Y:Integer;Image:Pointer);
Procedure PutCBlock(X,Y:Integer;Color:Byte;Image:Pointer);
Procedure PutCBlFlipX(X,Y:Integer;Color:Byte;Image:Pointer);
Procedure PutCBlFlipY(X,Y:Integer;Color:Byte;Image:Pointer);
Procedure PutShapeCopy(X,Y:Integer;Graph:Pointer;Back:Pointer);
Procedure PutShapeCopyFlipX(X,Y:Integer;Graph:Pointer;Back:Pointer);
Procedure PutShapeCopyFlipY(X,Y:Integer;Graph:Pointer;Back:Pointer);

Procedure ScrollLeft(X:Word;Y:Byte;Ancx,Ancy,Delta:Word);
Procedure ScrollRight(X:Word;Y:Byte;Ancx,Ancy,Delta:Word);
Procedure ScrollUp(X:Word;Y:Byte;Ancx,Ancy,Delta:Word);
Procedure ScrollDown(X:Word;Y:Byte;Ancx,Ancy,Delta:Word);

Function  Point(X,Y:Integer):Byte;
Function  PointCopy(X,Y:Integer;Back:Pointer):Byte;

Procedure SetView(X,Y,X1,Y1:Integer);
Procedure GetView(Var X,Y,X1,Y1:Integer);
Procedure ClsView;
Procedure Cls;
Procedure SetOrigin(X,Y:Integer);
Procedure ScreenDisplay(X:Integer);
Procedure Pset(X,Y:Integer;C:Byte);
Procedure Paint(X,Y:Integer;C:Byte);
Procedure PaintCopy(X,Y:Integer;Back:Pointer);
Procedure Box(X,Y,X1,Y1:Integer;Color:Byte);
Procedure Rectangle(X,Y,X1,Y1:Integer;Color:Integer);
Procedure Line(X1,Y1,X2,Y2:Integer;Color:Integer);
Procedure LineCopy(X1,Y1,X2,Y2:Integer;Back:Pointer);
Procedure LineTo(X,Y:Integer;Color:Byte);
Procedure LineCopyTo(X,Y:Integer;Back:Pointer);
Procedure Circle(X,Y,R:Integer;Color:Byte);
Procedure CircleCopy(X,Y,R:Integer;Back:Pointer);
Procedure Ellipse(X,Y,Rx,Ry:Integer;Color:Word);
Procedure EllipseCopy(X,Y,Rx,Ry:Integer;Back:Pointer);
Procedure Polygon(X,Y,R,N,Q:Integer;Color:Word);
Procedure PolygonCopy(X,Y,R,N,Q:Integer;Back:Pointer);
Procedure Draw(D:String);
Procedure Zoom(X,Y,Ax,Ay,Tx,Ty,Dx,Dy:Integer);
Procedure ZoomBlock(X,Y,Tx,Ty:Integer;Block:Pointer);
Procedure ZoomFromScreen(X,Y,Ax,Ay:Integer;Block:Pointer;Dx,Dy,Tx,Ty:Integer);

IMPLEMENTATION

Uses Utiles,Dos,Crt;

Const   PI = 3.1415912;
        VideoX=320;
        VideoY=200;

Var     ANCHO:Array[0..319] of Byte;

        VgaVideoX,VgaVideoY,OrigenX,OrigenY,VgaOx,VgaOy:Integer;
        SBAx,SBAy,SBX,SBY,DESX,DESY,SUMAX,SUMAY:Integer;
        AnX,AnY,Sxd,Syd,Sxr,Syr,E,Ed,Er:Integer;
        SPRITEBUF:Pointer;

          { *************** FUNCIONES *************** }

Function  BlockSize;
          Begin
               BlockSize:=(MemW[Seg(S^):Ofs(S^)])*(MemW[Seg(S^):Ofs(S^)+2])+4
          End;

Function  XBlock;
          Begin XBlock:=MemW[Seg(Block^):Ofs(Block^)] End;

Function  YBlock;
          Begin YBlock:=MemW[Seg(Block^):Ofs(Block^)+2] End;


         { ******************** PROCEDIMIENTOS PRIVADOS *******************}

Function  AjustaCoordenadas(X,Y:Integer;Spr:Pointer):Boolean;
          Begin
               SBAx:=XBlock(Spr);
               SBAy:=YBlock(Spr);

               if ( ((X+SBAx)<=VgaOx) or ((Y+SBAy)<=VgaOy) or
                    (X>=VgaVideoX) or (Y>=VgaVideoY)  )
               Then Begin
                         AjustaCoordenadas:=False;
                         exit;
               End;


               SBX:=X; SBY:=Y; DESX:=0; DESY:=0; SPRITEBUF:=Spr; SUMAX:=0;

               {Ajuste Superior Izquierdo}
               if (X<VgaOx) then
               begin
                    SBAx:=SBAx-abs(X-VgaOx);
                    SBX:=VgaOx;
                    DESX:=abs(X-VgaOx);
                    SUMAX:=DESX;
               end;

               if (Y<VgaOy) then
               Begin
                    SBAy:=SBAy-abs(Y-VgaOy);
                    SBY:=VgaOy;
                    DESY:=abs(Y-VgaOy);
               end;

               {AJuste Inferior Derecho}

               if ((X+SBAx)>VgaVideoX) then
               Begin
                    SUMAX:=SBAx-abs(VgaVideoX-X);
                    SBAx:=abs(VgaVideoX-X);
               end;

               if ((Y+SBAy)>VgaVideoY) then SBAy:=abs(VgaVideoY-Y);

               AjustaCoordenadas:=True;
          End;


          (* **************** PUBLICOS ******************** *)

PROCEDURE VACIA;
VAR
REGIS:REGISTERS;

BEGIN
REGIS.AH:=$01;
INTR ($16,REGIS);
IF (REGIS.FLAGS AND $0040)=0 THEN
   REPEAT
   REGIS.AH:=0;
   INTR ($16,REGIS);
   REGIS.AH:=$01;
   INTR ($16,REGIS);
   UNTIL (REGIS.FLAGS AND $0040) <> 0;
END;

PROCEDURE MODOTEXTO;
var
regs:registers;

begin
regs.ah:=0;
regs.al:=3;
intr ($10,regs);
end;




Procedure ReserveScreen;
          Begin
               GetMem(ScreenPointer,64000);
          End;

Procedure DeleteScreen;
          Begin
               FreeMem(ScreenPointer,64000);
               ScreenPointer:=Nil;
          End;

Procedure GetBlock;
          Begin
               ReserveBlock(Ancx,Ancy,Image);
               If Image<>NIL then ReGetBlock(X,Y,Image);
          End;

Procedure ReserveBlock;
          Begin
               GetMem(Image,Ancx*Ancy+4);
               If Image<>Nil Then
               Begin
                    Memw[Seg(Image^):Ofs(Image^)]:=Ancx;
                    Memw[Seg(Image^):Ofs(Image^)+2]:=Ancy;
               End;
          End;

Procedure DelBlock;
          Begin
               If Image<>Nil Then FreeMem(Image,BlockSize(Image));
          End;

Procedure SetScreen;
          Begin
               Asm
                  Mov Ah,0
                  Mov Al,N
                  Int $10
                  Cld
               End;
               DirectVideo:=False
          End;

procedure SetVga256;
          Begin
               SetScreen(19);
          End;

Procedure SaveScreen; Assembler;
          ASM
             Push Ds
             LES DI,ScreenPointer
             MOV SI,0
             MOV AX,0A000h
             MOV DS,AX
             MOV CX,32000
             REP MovsW
             Pop Ds
          End;

Procedure RestoreScreen; Assembler;
          ASM
             PUSH DS
             MOV AX,0A000h
             MOV ES,AX
             MOV DI,0
             LDS SI,ScreenPointer
             MOV CX,32000
             REP MovsW
             Pop Ds
          End;

Procedure WaitVBL; Assembler;
          asm
             mov dx,3dah;
          @Lo1:

              in al,dx
              test al,8
              jz @Lo1
          @Lo2:
              in al,dx
              test al,8
              jnz @Lo2
          End;

Procedure ScreenCopy; Assembler;
          ASM
             PUSH DS
             LES DI,Destino        {Carga en ES[DI] el Puntero Destino}
             LDS SI,Origen         {Carga en DS[SI] el Puntero Fuente}
             MOV CX,32000
             REP MovsW
             Pop Ds
          End;

Procedure ScreenZoneCopy;
          Var YY:Integer;
          Begin
               For YY:=0 to (Ancy-1) Do
                    MoveMem(Pseg(Origen),Pofs(Origen)+(Y+YY)*VideoX+X,
                            Pseg(Destino),Pofs(Destino)+(Dy+YY)*VideoX+Dx,Ancx);
          End;

Procedure SetVgaOut;
          Begin
               VgaVideo:=Scr;
          End;

Procedure RestoreVgaOut;
          Begin
               VgaVideo:=Ptr($a000,0000);
          End;

Procedure ReGetBlock; assembler;
          asm
             Push Ds
             Push Es

             Xor Ax,Ax
             Xor Bx,Bx
             Mov Ax,Y
             Xchg Ah,Al
             Shr Ax,1
             Shr Ax,1
             Mov Bx,Y
             Xchg Bh,Bl
             Add Ax,Bx
             Add Ax,X             { Ax= 320*Y+X }

             Les Di,Image
             Lds Si,VgaVideo
             Add Si,Ax


             Mov Bx,Es:[Di]       { Bx = Anchura }
             Mov Dx,Es:[Di+2]     { Dx = Altura  }
             Add Di,4

        @ReGetVertical:

             Mov Cx,Bx

             Rep Movsb

             Add Si,320
             Sub Si,Bx

             Dec Dx
             Cmp Dx,0

        Jne @ReGetVertical

          Pop Es
          Pop Ds
        End;

Procedure PutSprite;
          Begin
               if (AjustaCoordenadas(X,Y,Image)) then
          asm

             Push Bp
             Push Ds             { Salva el registro Ds}

             Xor Ax,Ax
             Mov Ah,Trans
             Push Ax

             Les Di,VgaVideo     { Define donde deben escribirse los datos}

             Xor Ax,Ax           { Introduce La Operacion}
             Xor Bx,Bx
             Mov Ax,SBY
             Xchg Al,Ah
             Shr Ax,1
             Shr Ax,1
             Mov Bx,SBY
             Xchg bl,bh
             Add Ax,Bx
             Add Di,Ax
             Add Di,SBX           { 320*SBY+SBX}

             Mov Bp,SUMAX         { Lo que falta para la anchura real.}

             Mov Ax,SBAx
             Add Ax,Bp
             Mul DESY
             Add Ax,DESX
             Add Ax,4             {Se salta la cabecera de anchura, altura}

             Mov Bx,SBAx          {Anchura}
             Mov Dx,SBAy          {Altura}

             Lds Si,SPRITEBUF
             Add Si,Ax        { Define desde donde deben comenzar a leerse los datos}

             Pop Ax           { Obtiene la Transparencia.}


            @Vertical:
                    Mov Cx,Bx

                    @Horizontal:
                                LodSb          { Toma un punto}
                                Cmp Al,Ah      { Mira si es Transparente}
                                Je @H1
                                Mov es:[di],al
                    @H1:
                                Inc Di

                    Loop @Horizontal

                    Add Di,320
                    Sub Di,Bx
                    Add Si,Bp

                    Dec Dx
                    Cmp Dx,0
             Jne @Vertical

             Pop Ds
             Pop Bp
          End;
          End; { Final de Put Sprite. }

Procedure PutSpFlipX;
          Begin
               if (AjustaCoordenadas(X,Y,Image)) then
          asm

             Push Bp
             Push Ds             { Salva el registro Ds}

             Xor Ax,Ax
             Mov Ah,Trans
             Push Ax

             Les Di,VgaVideo     { Define donde deben escribirse los datos}

             Xor Ax,Ax           { Introduce La Operacion}
             Xor Bx,Bx
             Mov Ax,SBY
             Xchg Al,Ah
             Shr Ax,1
             Shr Ax,1
             Mov Bx,SBY
             Xchg bl,bh
             Add Ax,Bx
             Add Di,Ax
             Add Di,SBX           { 320*SBY+SBX}

             Mov Bp,SUMAX         { Lo que falta para la anchura real.}

             Mov Ax,SBAx
             Add Ax,Bp
             Mov Bx,DESY
             Inc Bx
             Mul Bx
             Dec Ax           { Se Pone A la altura necesaria del grafico.}

             Mov Bx,SBAx      { Anchura }
             Mov Dx,SBAy      { Altura}

             Sub Ax,DESX
             Add Ax,4         { Se salta la cabecera de anchura, altura}


             Lds Si,SPRITEBUF

             Add Si,Ax        { Define desde donde deben comenzar a leerse los datos }

             Pop Ax           { Obtiene la Transparencia.}


            @Vertical:
                    Mov Cx,Bx

                    @Horizontal:
                                Mov Al,Ds:[si]  { Toma un punto}
                                Dec Si
                                Cmp Al,Ah       { Mira si es Transparente}
                                Je @H1
                                Mov es:[di],al
                    @H1:
                                Inc Di

                    Loop @Horizontal

                    Add Di,320
                    Sub Di,Bx

                    Add Si,Bx
                    Add Si,Bp
                    Add Si,Bx

                    Dec Dx
                    Cmp Dx,0
             Jne @Vertical

             Pop Ds
             Pop Bp
          End;
          End; { Final de Put Sprite Flip X. }

Procedure PutSpFlipY;
          Begin
               if (AjustaCoordenadas(X,Y,Image)) then
          asm

             Push Bp
             Push Ds             { Salva el registro Ds}

             Xor Ax,Ax
             Mov Ah,Trans
             Push Ax

             Les Di,VgaVideo     { Define donde deben escribirse los datos}

             Xor Ax,Ax           { Introduce La Operacion}
             Xor Bx,Bx
             Mov Ax,SBY
             Xchg Al,Ah
             Shr Ax,1
             Shr Ax,1
             Mov Bx,SBY
             Xchg bl,bh
             Add Ax,Bx
             Add Di,Ax
             Add Di,SBX           { 320*SBY+SBX}

             Mov Bp,SUMAX         { Lo que falta para la anchura real.}

             Mov Ax,SBAx
             Add Ax,Bp
             Mul DESY
             Add Ax,SBAx
             Add Ax,Bp
             Sub Ax,DESX

             Mov Bx,SBAx      { Anchura }
             Mov Dx,SBAy      { Altura}
             Mov Cx,Ax

             Lds Si,SPRITEBUF

             Push Dx

             Mov Ax,ds:[si]
             Mov Dx,ds:[si+2]
             Mul Dx
             Pop Dx           { Desplazamiento hasta el final del bloque. }
             Add Ax,4

             Add Si,Ax        { Define desde donde deben comenzar a leerse los datos }
             Sub Si,Cx

             Pop Ax           { Obtiene la Transparencia.}


            @Vertical:
                    Mov Cx,Bx

                    @Horizontal:
                                Lodsb  { Toma un punto}
                                Cmp Al,Ah       { Mira si es Transparente}
                                Je @H1
                                Mov es:[di],al
                    @H1:
                                Inc Di

                    Loop @Horizontal

                    Add Di,320
                    Sub Di,Bx

                    Sub Si,Bx
                    Sub Si,Bp
                    Sub Si,Bx

                    Dec Dx
                    Cmp Dx,0
             Jne @Vertical

             Pop Ds
             Pop Bp
          End;
          End; { Final de Put Sprite FlipY. }

PROCEDURE SPCOPY (var p1,p2:pointer;x,y,ax,ay,xs,ys:integer;f:boolean);
var
aux:pointer;

begin
setvgaout (p1);
 getblock (x,y,ax,ay,aux);
restorevgaout;

setvgaout (p2);
  if not f then
     putsprite (xs,ys,13,aux)
  else
     putspflipx (xs,ys,13,aux);
restorevgaout;

delblock (aux);
end;


Procedure PutBlock;
          Begin
              if (AjustaCoordenadas(X,Y,Image)) then
          asm
             Push Bp
             Push Ds             { Salva el registro Ds }

             Les Di,VgaVideo     { Define donde deben escribirse los datos }

             Xor Ax,Ax           { Introduce La Operacion }
             Xor Bx,Bx
             Mov Ax,SBY
             Xchg Al,Ah
             Shr Ax,1
             Shr Ax,1
             Mov Bx,SBY
             Xchg bl,bh
             Add Ax,Bx
             Add Di,Ax
             Add Di,SBX          { 320*SBY+SBX }

             Mov Bp,SUMAX        { Lo que falta para la anchura real.}

             Mov Ax,SBAx
             Add Ax,Bp
             Mul DESY
             Add Ax,DESX
             Add Ax,4         { Se salta la cabecera de anchura, altura }

             Mov Bx,SBAx      { Anchura }
             Mov Dx,SBAy      { Altura  }

             Lds Si,SPRITEBUF
             Add Si,Ax        { Define desde donde deben comenzar a leerse los datos}
             Cld
            @Vertical:
                    Mov Cx,Bx
                    Rep Movsb
                    Add Di,320
                    Sub Di,Bx
                    Add Si,Bp
                    Dec Dx
                    Cmp Dx,0
             Jne @Vertical

             Pop Ds
             Pop Bp
          End;
          End;  { Final de Put Block. }

Procedure PutBlFlipX;
          Begin
               if (AjustaCoordenadas(X,Y,Image)) then
          asm

             Push Bp
             Push Ds             { Salva el registro Ds}

             Les Di,VgaVideo     { Define donde deben escribirse los datos}

             Xor Ax,Ax           { Introduce La Operacion}
             Xor Bx,Bx
             Mov Ax,SBY
             Xchg Al,Ah
             Shr Ax,1
             Shr Ax,1
             Mov Bx,SBY
             Xchg bl,bh
             Add Ax,Bx
             Add Di,Ax
             Add Di,SBX           { 320*SBY+SBX}

             Mov Bp,SUMAX         { Lo que falta para la anchura real.}

             Mov Ax,SBAx
             Add Ax,Bp
             Mov Bx,DESY
             Inc Bx
             Mul Bx
             Dec Ax           { Se Pone A la altura necesaria del grafico.}

             Mov Bx,SBAx      { Anchura }
             Mov Dx,SBAy      { Altura}

             Sub Ax,DESX
             Add Ax,4         { Se salta la cabecera de anchura, altura}


             Lds Si,SPRITEBUF

             Add Si,Ax        { Define desde donde deben comenzar a leerse los datos }

            @Vertical:
                    Mov Cx,Bx

                    @Horizontal:
                                Mov Al,Ds:[si]  { Toma un punto}
                                Dec Si
                                Stosb
                    Loop @Horizontal

                    Add Di,320
                    Sub Di,Bx

                    Add Si,Bx
                    Add Si,Bp
                    Add Si,Bx

                    Dec Dx
                    Cmp Dx,0
             Jne @Vertical

             Pop Ds
             Pop Bp
          End;
          End; { Final de Put Sprite Flip X. }

Procedure PutBlFlipY;
          Begin
               if (AjustaCoordenadas(X,Y,Image)) then
          asm

             Push Bp
             Push Ds             { Salva el registro Ds}

             Les Di,VgaVideo     { Define donde deben escribirse los datos}

             Xor Ax,Ax           { Introduce La Operacion}
             Xor Bx,Bx
             Mov Ax,SBY
             Xchg Al,Ah
             Shr Ax,1
             Shr Ax,1
             Mov Bx,SBY
             Xchg bl,bh
             Add Ax,Bx
             Add Di,Ax
             Add Di,SBX           { 320*SBY+SBX}

             Mov Bp,SUMAX         { Lo que falta para la anchura real.}

             Mov Ax,SBAx
             Add Ax,Bp
             Mul DESY
             Add Ax,SBAx
             Add Ax,Bp
             Sub Ax,DESX

             Mov Bx,SBAx      { Anchura }
             Mov Dx,SBAy      { Altura}
             Mov Cx,Ax

             Lds Si,SPRITEBUF

             Push Dx
             Mov Ax,ds:[si]
             Mov Dx,ds:[si+2]
             Mul Dx
             Pop Dx           { Desplazamiento hasta el final del bloque. }
             Add Ax,4

             Add Si,Ax        { Define desde donde deben comenzar a leerse los datos }
             Sub Si,Cx

            @Vertical:
                    Mov Cx,Bx
                    Rep movsb

                    Add Di,320
                    Sub Di,Bx

                    Sub Si,Bx
                    Sub Si,Bp
                    Sub Si,Bx

                    Dec Dx
                    Cmp Dx,0
             Jne @Vertical

             Pop Ds
             Pop Bp
          End;
          End; { Final de Put Block FlipY. }

Procedure PutCBlock;
          Begin
               if (AjustaCoordenadas(X,Y,Image)) then
          asm

             Push Bp
             Push Ds             { Salva el registro Ds}

             Xor Ax,Ax
             Mov Ah,Color
             Push Ax

             Les Di,VgaVideo     { Define donde deben escribirse los datos}

             Xor Ax,Ax           { Introduce La Operacion}
             Xor Bx,Bx
             Mov Ax,SBY
             Xchg Al,Ah
             Shr Ax,1
             Shr Ax,1
             Mov Bx,SBY
             Xchg bl,bh
             Add Ax,Bx
             Add Di,Ax
             Add Di,SBX           { 320*SBY+SBX}

             Mov Bp,SUMAX         { Lo que falta para la anchura real.}

             Mov Ax,SBAx
             Add Ax,Bp
             Mul DESY
             Add Ax,DESX
             Add Ax,4             {Se salta la cabecera de anchura, altura}

             Mov Bx,SBAx          {Anchura}
             Mov Dx,SBAy          {Altura}

             Lds Si,SPRITEBUF
             Add Si,Ax        { Define desde donde deben comenzar a leerse los datos}

             Pop Ax           { Obtiene la Transparencia.}


            @Vertical:
                    Mov Cx,Bx

                    @Horizontal:
                                LodSb          { Toma un punto}
                                Cmp Al,0       { Mira si es Transparente}
                                Je @H1
                                Mov es:[di],ah
                    @H1:
                                Inc Di

                    Loop @Horizontal

                    Add Di,320
                    Sub Di,Bx
                    Add Si,Bp

                    Dec Dx
                    Cmp Dx,0
             Jne @Vertical

             Pop Ds
             Pop Bp
          End;
          End; { Final de Put Sprite. }

Procedure PutCBlFlipX;
          Begin
               if (AjustaCoordenadas(X,Y,Image)) then
          asm

             Push Bp
             Push Ds             { Salva el registro Ds}

             Xor Ax,Ax
             Mov Ah,Color
             Push Ax

             Les Di,VgaVideo     { Define donde deben escribirse los datos}

             Xor Ax,Ax           { Introduce La Operacion}
             Xor Bx,Bx
             Mov Ax,SBY
             Xchg Al,Ah
             Shr Ax,1
             Shr Ax,1
             Mov Bx,SBY
             Xchg bl,bh
             Add Ax,Bx
             Add Di,Ax
             Add Di,SBX           { 320*SBY+SBX}

             Mov Bp,SUMAX         { Lo que falta para la anchura real.}

             Mov Ax,SBAx
             Add Ax,Bp
             Mov Bx,DESY
             Inc Bx
             Mul Bx
             Dec Ax           { Se Pone A la altura necesaria del grafico.}

             Mov Bx,SBAx      { Anchura }
             Mov Dx,SBAy      { Altura}

             Sub Ax,DESX
             Add Ax,4         { Se salta la cabecera de anchura, altura}


             Lds Si,SPRITEBUF

             Add Si,Ax        { Define desde donde deben comenzar a leerse los datos }

             Pop Ax           { Obtiene la Transparencia.}


            @Vertical:
                    Mov Cx,Bx

                    @Horizontal:
                                Mov Al,Ds:[si]  { Toma un punto}
                                Dec Si
                                Cmp Al,0       { Mira si es Transparente}
                                Je @H1
                                Mov es:[di],ah
                    @H1:
                                Inc Di

                    Loop @Horizontal

                    Add Di,320
                    Sub Di,Bx

                    Add Si,Bx
                    Add Si,Bp
                    Add Si,Bx

                    Dec Dx
                    Cmp Dx,0
             Jne @Vertical

             Pop Ds
             Pop Bp
          End;
          End; { Final de Put Sprite Flip X. }

Procedure PutCBlFlipY;
          Begin
               if (AjustaCoordenadas(X,Y,Image)) then
          asm

             Push Bp
             Push Ds             { Salva el registro Ds}

             Xor Ax,Ax
             Mov Ah,Color
             Push Ax

             Les Di,VgaVideo     { Define donde deben escribirse los datos}

             Xor Ax,Ax           { Introduce La Operacion}
             Xor Bx,Bx
             Mov Ax,SBY
             Xchg Al,Ah
             Shr Ax,1
             Shr Ax,1
             Mov Bx,SBY
             Xchg bl,bh
             Add Ax,Bx
             Add Di,Ax
             Add Di,SBX           { 320*SBY+SBX}

             Mov Bp,SUMAX         { Lo que falta para la anchura real.}

             Mov Ax,SBAx
             Add Ax,Bp
             Mul DESY
             Add Ax,SBAx
             Add Ax,Bp
             Sub Ax,DESX

             Mov Bx,SBAx      { Anchura }
             Mov Dx,SBAy      { Altura}
             Mov Cx,Ax

             Lds Si,SPRITEBUF

             Push Dx

             Mov Ax,ds:[si]
             Mov Dx,ds:[si+2]
             Mul Dx
             Pop Dx           { Desplazamiento hasta el final del bloque. }
             Add Ax,4

             Add Si,Ax        { Define desde donde deben comenzar a leerse los datos }
             Sub Si,Cx

             Pop Ax           { Obtiene la Transparencia.}


            @Vertical:
                    Mov Cx,Bx

                    @Horizontal:
                                Lodsb  { Toma un punto}
                                Cmp Al,0       { Mira si es Transparente}
                                Je @H1
                                Mov es:[di],ah
                    @H1:
                                Inc Di

                    Loop @Horizontal

                    Add Di,320
                    Sub Di,Bx

                    Sub Si,Bx
                    Sub Si,Bp
                    Sub Si,Bx

                    Dec Dx
                    Cmp Dx,0
             Jne @Vertical

             Pop Ds
             Pop Bp
          End;
          End; { Final de Put Sprite FlipY. }

Procedure PutShapeCopy;
          Var Ax,Ay,a,b,_SE,_OF:Integer;
          Begin
               Ax:=XBlock(Graph);
               Ay:=XBlock(Graph);

               _SE:=PSeg(Graph);
               _OF:=POfs(Graph)+4;

               for b:=y to (Y+Ay-1) Do
                   for a:=x to (X+Ax-1) do
                   Begin
                        if Byte(Ptr(_SE,_OF)^)<>0 then Pset(a,b,PointCopy(a,b,Back));
                        Inc(_OF);
                   End;
          End;

Procedure PutShapeCopyFlipX;
          Var Ax,Ay,a,b,_SE,_OF,r:Integer;
          Begin
               Ax:=XBlock(Graph);
               Ay:=YBlock(Graph);

               _SE:=PSeg(Graph);
               _OF:=POfs(Graph)+4;

               r:=X+Ax-1;

               for b:=y to (Y+Ay-1) Do
                   for a:=x to (X+Ax-1) do
                   Begin
                        if Byte(Ptr(_SE,_OF)^)<>0 then Pset(r-a,b,PointCopy(r-a,b,Back));
                        Inc(_OF);
                   End;
          End;

Procedure PutShapeCopyFlipY;
          Var Ax,Ay,a,b,_SE,_OF,r:Integer;
          Begin
               Ax:=XBlock(Graph);
               Ay:=YBlock(Graph);

               _SE:=PSeg(Graph);
               _OF:=POfs(Graph)+4;

               r:=Y+Ay-1;

               for b:=y to (Y+Ay-1) Do
                   for a:=x to (X+Ax-1) do
                   Begin
                        if Byte(Ptr(_SE,_OF)^)<>0 then Pset(a,r-b,PointCopy(a,r-b,Back));
                        Inc(_OF);
                   End;
          End;

Procedure ScrollLeft; Assembler;
          Asm
             Push Ds

             Les Si,VgaVideo
             Lds Di,VgaVideo

             Xor Ax,Ax          { Introduce La Operacion }
             Xor Bx,Bx
             Mov Ah,Y
             Shr Ax,1
             Shr Ax,1
             Mov Bh,Y
             Add Ax,Bx
             Add Ax,X            { 320*Y+X }
             Add Di,Ax

             Add Ax,Delta
             Add Si,Ax           {Define lugar de lectura}

             Mov Cx,Ancy          {Contador Bucle Vertical}
             Mov Ax,0            {Color 0}

         @L1:
             Push Cx           {Se salvan los valores}
             Mov Bx,Di
             Mov Dx,Si

             Mov Cx,Ancx
             Sub Cx,Delta
             Rep Movsb
             Mov Cx,Delta
             Rep Stosb

             Mov Si,Dx
             Mov Di,Bx
             Pop Cx
             Add Si,320
             Add Di,320
         Loop @L1
             Mov Ax,0            {Color 0 para pintar}
             Mov Cx,Delta

             Pop Ds
          End;

Procedure ScrollRight; Assembler;
          Asm
             Push Ds

             Les Di,VgaVideo
             Lds Si,Vgavideo

             Xor Ax,Ax          { Introduce La Operacion }
             Xor Bx,Bx
             Mov Ah,Y
             Shr Ax,1
             Shr Ax,1
             Mov Bh,Y
             Add Ax,Bx
             Add Ax,X
             Add Ax,Ancx          { 320*Y+X+Ancx }
             Dec Ax
             Add Di,Ax

             Sub Ax,Delta
             Add Si,Ax           {Define lugar de lectura}

             Mov Cx,Ancy          {Contador Bucle Vertical}
             Mov Ax,0            {Color 0}
             Std
         @L1:

             Push Cx             {Se salvan los valores}
             Mov Bx,Di
             Mov Dx,Si

             Mov Cx,Ancx
             Sub Cx,Delta
             Rep Movsb
             Mov Cx,Delta
             Rep Stosb

             Mov Si,Dx
             Mov Di,Bx
             Pop Cx
             Add Si,320
             Add Di,320
         Loop @L1

             Cld
             Pop Ds
          End;

Procedure ScrollUp; Assembler;
          Asm
             Push Ds

             Les Di,VgaVideo
             Lds Si,Vgavideo

             Xor Ax,Ax          { Introduce La Operacion }
             Xor Bx,Bx
             Mov Ah,Y
             Shr Ax,1
             Shr Ax,1
             Mov Bh,Y
             Add Ax,Bx
             Add Ax,X            { 320*Y+X }
             Add Di,Ax

             Mov Cx,Delta
         @SU:
             Add Ax,320
             Loop @Su
             Add Si,Ax           {Define lugar de lectura}

             Mov Ax,Ancy
             Sub Ax,Delta
             Mov Cx,Ax

         @L1:
             Mov Ax,Cx
             Mov Bx,Di
             Mov Dx,Si
             Mov Cx,Ancx
             Rep Movsb
             Mov Si,Dx
             Mov Di,Bx
             Mov Cx,Ax
             Add Si,320
             Add Di,320
         Loop @L1
             Mov Ax,0            {Color 0 para pintar}
             Mov Cx,Delta
         @L3:
             Mov Bx,Cx
             Mov Dx,Di
             Mov Cx,Ancx
             Rep Stosb
             Mov Di,Dx
             Mov Cx,Bx
             Add Di,320
         Loop @L3

              Pop Ds
          End;

Procedure ScrollDown; Assembler;
          Asm
             Push Ds

             Les Di,VgaVideo
             Lds Si,Vgavideo

             Xor Ax,Ax
             Mov Al,Y
             Add Ax,Ancy
             Dec Ax
             Mov Y,Al

             Xor Ax,Ax          { Introduce La Operacion }
             Xor Bx,Bx
             Mov Ah,Y
             Shr Ax,1
             Shr Ax,1
             Mov Bh,Y
             Add Ax,Bx
             Add Ax,X            { 320*Y+X }
             Add Di,Ax

             Mov Cx,Delta
         @SU:
             Sub Ax,320
             Loop @Su
             Add Si,Ax           {Define lugar de lectura}

             Mov Ax,Ancy
             Sub Ax,Delta
             Mov Cx,Ax

         @L1:
             Mov Ax,Cx
             Mov Bx,Di
             Mov Dx,Si
             Mov Cx,Ancx
             Rep Movsb
             Mov Si,Dx
             Mov Di,Bx
             Mov Cx,Ax
             Sub Si,320
             Sub Di,320
         Loop @L1
             Mov Ax,0              {Color 0 para pintar}
             Mov Cx,Delta
         @L3:
             Mov Bx,Cx
             Mov Dx,Di
             Mov Cx,Ancx
             Rep Stosb
             Mov Di,Dx
             Mov Cx,Bx
             Sub Di,320
         Loop @L3

              Pop Ds
          End;


            (* Procedimientos para dibujar graficos *)

Procedure GetView;
          Begin
               X:=VgaOx;
               Y:=VgaOy;
               X1:=VgaVideoX;
               Y1:=VgaVideoY;
          End;

Procedure SetView;
          Begin
               VgaVideoX:=X1+1;
               VgaVideoY:=Y1+1;
               VgaOx:=X;
               VgaOy:=Y;

               if (VgaVideoX>320) then VgaVideoX:=320;
               if (VgaVideoY>200) then VgaVideoY:=200;
               if (VgaVideoX<0) then VgaVideoX:=0;
               if (VgaVideoY<0) then VgaVideoY:=0;

               if (VgaOx>320) then VgaOx:=320;
               if (VgaOy>200) then VgaOy:=200;
               if (VgaOx<0) then VgaOx:=0;
               if (VgaOy<0) then VgaOy:=0;

               if (VgaOx>VgaVideoX) then SwapInteger(VgaOx,VgavideoX);
               if (VgaOy>VgaVideoY) then SwapInteger(VgaOy,VgavideoY);
          End;

Procedure ClsView; Assembler;
          asm

              Push Es
              Push Bp

              Les Di,VgaVideo
              Mov Ax,VgaOy
              Mov Bx,320
              Mul Bx
              Add Ax,VgaOx
              Add Di,Ax

              Mov Bx,VgaVideoX
              Sub Bx,VgaOx

              Mov Dx,VgaVideoY
              Sub Dx,VgaOy
              Xor Ax,Ax
              Mov Bp,Di

          @LOOPING:

              Mov Cx,Bx
              Rep Stosb
              Add Bp,320
              Mov Di,Bp
              Dec Dx
              Cmp Dx,0
              Jne @LOOPING

              Pop Bp
              Pop Es

          End;

Function  Point; Assembler;
          asm
             Push Es
             Les Si,VgaVideo
             Mov Ax,VideoX
             Mul Y
             Add Ax,X
             Add Si,Ax
             Mov Al,Es:[Si]
             Pop Es
          End;

Function  PointCopy; Assembler;
          asm
             Push Es
             Les Si,Back
             Mov Ax,VideoX
             Mul Y
             Add Ax,X
             Add Si,Ax
             Mov Al,Es:[Si]
             Pop Es
          End;

Procedure Cls; Assembler;
          Asm
             Push Es
             Les Di,VgaVideo
             Mov Cx,32000
             Xor Ax,Ax
             Rep StosW
             Pop Es
          End;

Procedure SetOrigin;
          Begin
               OrigenX:=X;
               OrigenY:=Y;
          End;

procedure Pset;
          Begin
               If (X<VgaVideoX) and (Y<VgaVideoY) and
                  (X>=VgaOx) and (Y>=VgaOy) then
               asm
                  Push Es
                  Les Di,VgaVideo
                  Mov Ax,VideoX
                  Mul Y
                  Add Ax,X
                  Add Di,Ax
                  Mov aL,C
                  Mov Es:[Di],Al
                  Pop Es
               End;
          End;

Procedure Paint;
          Var Co,X1,Y1,T:Integer;

          Begin
               Co:=Point(X,Y);
               If C=Co Then Exit;

               While (Point(X-1,Y)=Co) and (X>=(VgaOx+1)) Do Dec(X);

               X1:=X; Y1:=Y;
               While (Point(X,Y)=Co) and (X<VgaVideoX) Do
               Begin
                    Pset(X,Y,C);
                    Inc(X);
               End;

               T:=X;

               X:=X1; Y:=Y1;
               While (X<T) and (X<VgaVideoX) Do
               Begin
                    If (Point(X,Y-1)=Co) and (Y>=(VgaOy+1))     Then Paint(X,Y-1,C);
                    If (Point(X,Y+1)=Co) and (Y<=(VgaVideoY-2)) Then Paint(X,Y+1,C);
                    Inc(X);
               End;
          End;

Procedure PaintCopy;
          Var Co,X1,Y1,T:Integer;

          Begin
               Co:=Point(X,Y);
               If PointCopy(X,Y,Back)=Co Then Exit;

               While (Point(X-1,Y)=Co) and (X>=(VgaOx+1)) Do Dec(X);

               X1:=X; Y1:=Y;
               While (Point(X,Y)=Co) and (X<VgaVideoX) Do
               Begin
                    Pset(X,Y,PointCopy(X,Y,Back));
                    Inc(X);
               End;

               T:=X;

               X:=X1; Y:=Y1;
               While (X<T) and (X<VgaVideoX) Do
               Begin
                    If (Point(X,Y-1)=Co) and (Y>=(VgaOy+1))     Then PaintCopy(X,Y-1,Back);
                    If (Point(X,Y+1)=Co) and (Y<=(VgaVideoY-2)) Then PaintCopy(X,Y+1,Back);
                    Inc(X);
               End;
          End;

Procedure Box;

        BEGIN

          if (X>X1) then SwapInteger(X,X1);
          if (Y>Y1) then SwapInteger(Y,Y1);

          if (X<VgaVideoX) and (Y<VgaVideoY) and (X>=VgaOx) and
             (X1>=VgaOx) and (Y>=VgaOy) and (Y1>=VgaOy) then
          Begin
               if (X1>VgaVideoX) then X1:=VgaVideoX;
               if (Y1>VgaVideoY) then Y1:=VgaVideoY;

               If (X<VgaOx) then SBAx:=(X1-VgaOx)+1 else SBAx:=(X1-X)+1;
               If (Y<VgaOy) then SBAy:=(Y1-VgaOy)+1 else SBAy:=(Y1-Y)+1;


               if (SBAy=0) then SBAy:=1;
               if (SBAx=0) then SBAx:=1;

               if (X<VgaOx) then X:=VgaOx;
               if (Y<VgaOy) then Y:=VgaOy;

             asm
               Push Es
               Mov Ax,320
               Mul Y
               Add Ax,X
               Mov Bx,Ax

               Les Di,VgaVideo

               Add Bx,Di
               Mov Dx,SBAy
               Mov Al,Color

             @VertiBox:;

               Mov Di,Bx
               Mov Cx,SBAx

               Rep Stosb

               Add Bx,320
               Dec Dx
               Cmp Dx,0
               Jne @VertiBox

               Pop Es
             End;
          End;
        End;

Procedure Rectangle;
          Var A:Integer;
          Begin
               If X>X1 then SwapInteger(X,X1);
               If Y>Y1 then SwapInteger(Y,Y1);

               For A:=X to X1 Do
               Begin
                    Pset(A,Y,Color);
                    Pset(A,Y1,Color);
               End;

               For A:=Y to Y1 Do
               Begin
                    Pset(X,A,Color);
                    Pset(X1,A,Color)
               End
          End;

Procedure Line; Assembler;
          Asm

             Push Ds
             Push Es
                          { Calculos Preliminares }
             Mov Syd,1
             Mov Ax,Y2
             Sub Ax,Y1

             Cmp Ax,0
         JGE @ABS1          {Bifurca si Y2<Y1}

             Mov Syd,-1
             Mov Ax,Y1
             Sub Ax,Y2

          @ABS1:
             Mov Any,Ax     {Define la Altura Y}

             Mov Sxd,1
             Mov Ax,X2
             Sub Ax,X1
             Cmp Ax,0
         JGE @ABS2          {Bifurca si X2-X1>=0}

             Mov Sxd,-1
             Mov Ax,X1
             Sub Ax,X2

          @ABS2:
             Mov Anx,Ax     {Define la Anchura X}

             Mov Bx,Anx
             Cmp Bx,Any

         JGE @ABS3

             Mov Sxr,0
             Mov Ax,Syd
             Mov Syr,Ax

             Mov Bx,Any       {Intercambia Anx,Any}
             Mov Ax,Anx
             Mov Anx,Bx
             Mov Any,Ax
             Jmp @ABS4

          @ABS3:

             Mov Syr,0
             Mov Ax,Sxd
             Mov Sxr,Ax

          @ABS4:

                         { ********* Define Valores Iniciales ******** }

             Mov Bx,Any
             Shl Bx,1
             Mov Er,Bx        {Introduce en Er = 2*Any}

             Sub Bx,Anx
             Mov E,Bx         {Introduce E = 2*Any - Anx}

             Mov Bx,Any
             Sub Bx,Anx
             Shl Bx,1
             Mov Ed,Bx        { Ed = 2*(Any-Anx) }

      { ------------------------------------------------- DIBUJA ---}

             Les Di,VgaVideo

             Mov Cx,Anx            { Define Contador de Bucle}
             Inc Cx

          @Bucle:

             Mov Ax,X1         { Si X>=320 o X<0 No Pinta }
             Cmp Ax,VgaVideoX
             Jae @Cont
             Cmp Ax,VgaOx
             Jb  @Cont

             Mov Ax,Y1         { Si Y>=200 o Y<0 No Pinta }
             Cmp Ax,VgaVideoY
             Jae  @Cont
             Cmp Ax,VgaOy
             Jb  @Cont

             Mov Ax,Y1           { Introduce en Di la operacin 320*Y+X }
             Mov Bx,320          { Con lo que se determina la posicin  }
             Mul Bx
             Add Ax,X1
             Mov Di,Ax
             Add Di,Word Ptr VgaVideo

             Mov Ax,Color        {Define el Color de pintada}
             Stosb               {Dibuja un punto en la Zona de Trabajo}

          @Cont:

             Cmp E,0
             JL @Cont1
                 Mov Ax,Sxd
                 Add Ax,X1
                 Mov X1,Ax

                 Mov Ax,Syd
                 Add Ax,Y1
                 Mov Y1,Ax

                 Mov Ax,Ed
                 Add Ax,E
                 Mov E,Ax

                 Jmp @Cont2

          @Cont1:
                 Mov Ax,Sxr
                 Add Ax,X1
                 Mov X1,Ax

                 Mov Ax,Syr
                 Add Ax,Y1
                 Mov Y1,Ax

                 Mov Ax,Er
                 Add Ax,E
                 Mov E,Ax

          @Cont2:

                 Loop @Bucle

             Mov Ax,X2
             Mov Bx,Y2
             Mov OrigenX,Ax
             Mov OrigenY,Bx

             Pop Es
             Pop Ds
       End;

Procedure LineCopy; Assembler;
          Asm

             Push Ds
             Push Es
                          { Calculos Preliminares }
             Mov Syd,1
             Mov Ax,Y2
             Sub Ax,Y1

             Cmp Ax,0
         JGE @ABS1          {Bifurca si Y2<Y1}

             Mov Syd,-1
             Mov Ax,Y1
             Sub Ax,Y2

          @ABS1:
             Mov Any,Ax     {Define la Altura Y}

             Mov Sxd,1
             Mov Ax,X2
             Sub Ax,X1
             Cmp Ax,0
         JGE @ABS2          {Bifurca si X2-X1>=0}

             Mov Sxd,-1
             Mov Ax,X1
             Sub Ax,X2

          @ABS2:
             Mov Anx,Ax     {Define la Anchura X}

             Mov Bx,Anx
             Cmp Bx,Any

         JGE @ABS3

             Mov Sxr,0
             Mov Ax,Syd
             Mov Syr,Ax

             Mov Bx,Any       {Intercambia Anx,Any}
             Mov Ax,Anx
             Mov Anx,Bx
             Mov Any,Ax
             Jmp @ABS4

          @ABS3:

             Mov Syr,0
             Mov Ax,Sxd
             Mov Sxr,Ax

          @ABS4:

                         { ********* Define Valores Iniciales ******** }

             Mov Bx,Any
             Shl Bx,1
             Mov Er,Bx        {Introduce en Er = 2*Any}

             Sub Bx,Anx
             Mov E,Bx         {Introduce E = 2*Any - Anx}

             Mov Bx,Any
             Sub Bx,Anx
             Shl Bx,1
             Mov Ed,Bx        { Ed = 2*(Any-Anx) }

      { ------------------------------------------------- DIBUJA ---}

             Mov Cx,Anx            { Define Contador de Bucle}
             Inc Cx

          @Bucle:

             Mov Ax,X1         { Si X>=320 o X<0 No Pinta }
             Cmp Ax,VgaVideoX
             Jae @Cont
             Cmp Ax,VgaOx
             Jb  @Cont

             Mov Ax,Y1         { Si Y>=200 o Y<0 No Pinta }
             Cmp Ax,VgaVideoY
             Jae  @Cont
             Cmp Ax,VgaOy
             Jb  @Cont

             Mov Ax,Y1           { Introduce en Di la operacin 320*Y+X }
             Mov Bx,320          { Con lo que se determina la posicin  }
             Mul Bx
             Add Ax,X1

             Xchg Ax,Bx
             Les Di,Back
             Add Di,Bx
             Mov al,Es:[Di]

             Les Di,VgaVideo
             Add Di,Bx
             Mov Es:[Di],Al

          @Cont:

             Cmp E,0
             JL @Cont1
                 Mov Ax,Sxd
                 Add Ax,X1
                 Mov X1,Ax

                 Mov Ax,Syd
                 Add Ax,Y1
                 Mov Y1,Ax

                 Mov Ax,Ed
                 Add Ax,E
                 Mov E,Ax

                 Jmp @Cont2

          @Cont1:
                 Mov Ax,Sxr
                 Add Ax,X1
                 Mov X1,Ax

                 Mov Ax,Syr
                 Add Ax,Y1
                 Mov Y1,Ax

                 Mov Ax,Er
                 Add Ax,E
                 Mov E,Ax

          @Cont2:

                 Loop @Bucle

             Mov Ax,X2
             Mov Bx,Y2
             Mov OrigenX,Ax
             Mov OrigenY,Bx

             Pop Es
             Pop Ds
       End;

Procedure LineTO;
          Begin Line(OrigenX,OrigenY,X,Y,Color) End;

Procedure LineCopyTo;
          Begin LineCopy(OrigenX,OrigenY,X,Y,Back) End;

Procedure Circle;
          Begin
               Ellipse(X,Y,R,R,Color);
          End;

Procedure CircleCopy;
          Begin
               EllipseCopy(X,Y,R,R,Back);
          End;

Procedure Ellipse;
          Var A:Real;
          Begin
               A:=0; SetOrigin(X+Rx-1,Y);
               Repeat
                     LineTO(X+Trunc(Rx*Cos(A)),Y+Trunc(Ry*Sin(A)),Color);
                     A:=A+0.05;
               Until A>PI*2;
               LineTO(X+Rx-1,Y,Color);
          End;

Procedure EllipseCopy;
          Var A:Real;
              X1,Y1:Integer;
          Begin
               A:=0; SetOrigin(X+Rx-1,Y);
               X1:=X+Trunc(Rx*Cos(A));
               Y1:=Y+Trunc(Ry*Sin(A));
               Repeat
                     LineCopyTO(X1,Y1,Back);
                     A:=A+0.05;
               Until A>PI*2;
               LineCopyTO(X+Rx-1,Y,Back);
          End;

Procedure Polygon;
          var
             A:Real;
             X1,Y1,X2,Y2,b:Integer;
          Begin
               a:=q*pi/180;
               x1:=trunc(x+r*cos(a));y1:=trunc(y-r*sin(a));
               SetOrigin(X1,Y1);
               for b:=1 to n do
               begin
                    a:=a+2*pi/n;
                    x2:=trunc(x+r*cos(a));y2:=trunc(y-r*sin(a));
                    LineTo(x2,y2,Color);
               End;
          End;

Procedure PolygonCopy;
          var
             A:Real;
             X1,Y1,X2,Y2,b:Integer;
          Begin
               a:=q*pi/180;
               x1:=trunc(x+r*cos(a));y1:=trunc(y-r*sin(a));
               SetOrigin(X1,Y1);
               for b:=1 to n do
               begin
                    a:=a+2*pi/n;
                    x2:=trunc(x+r*cos(a));y2:=trunc(y-r*sin(a));
                    LineCopyTo(x2,y2,Back);
               End;
          End;

Procedure Draw;
          Var Xo,Yo,C,XX,YY,Rx,Ry,Dis:LongInt;
              T,T1:Integer;
              Sc,Ang,Des:Real;
              C1:String;
              Si:Boolean;

          Procedure Toma(Var C1,C:String;Var T:Integer);
          Var C2:String[5];
          Begin
               C:=C1[1];
               C1:=Copy(C1,2,Length(C1)-1);
               C2:='';
               While (Pos(C1[1],'.-1234567890 ')>0) And (Length(C1)>0) Do
               Begin
                    If C1[1]<>' ' Then C2:=C2+C1[1];
                    C1:=Copy(C1,2,Length(C1)-1)
               End;
               Val(C2,T,T);
          End;

          Begin
               D:=Upper(D);
               C:=15; Xo:=OrigenX; Yo:=OrigenY; Sc:=1;
               XX:=0; YY:=0; Ang:=0; Des:=0;
               Repeat
                     Toma(D,C1,T);
                     If C1='S' Then Sc:=0.95+0.05*T;
                     If C1='A' Then Ang:=-T*Pi/180;
                     If C1='C' Then C:=T;
                     If C1='G' Then
                               Begin
                                    Xo:=T;
                                    Toma(D,C1,T);
                                    Yo:=T;
                                    SetOrigin(Xo,Yo); C1:='G';
                                    XX:=0; YY:=0;
                               End;
               If Pos(C1,'SCAG')=0 Then Begin
                     If C1='B' Then Begin
                                         Si:=False;
                                         Toma(D,C1,T)
                                    End Else Si:=True;
                     T1:=T; If T1=0 Then T1:=1;
                     If C1='L' Then XX:=XX-Trunc(T1*Sc);
                     If C1='R' then XX:=XX+Trunc(T1*Sc);
                     If C1='U' Then YY:=YY-Trunc(T1*Sc);
                     If C1='D' Then YY:=YY+Trunc(T1*Sc);
                     If C1='W' Then Begin YY:=YY-Trunc(T1*Sc); XX:=XX-Trunc(T1*Sc) End;
                     If C1='H' Then Begin YY:=YY+Trunc(T1*Sc); XX:=XX-Trunc(T1*Sc) End;
                     If C1='E' Then Begin YY:=YY-Trunc(T1*Sc); XX:=XX+Trunc(T1*Sc) End;
                     If C1='F' Then Begin YY:=YY+Trunc(T1*Sc); XX:=XX+Trunc(T1*Sc) End;
                     If C1='M' Then
                               Begin
                                    XX:=XX+Trunc(T*Sc);  {Solo T porque}
                                    Toma(D,C1,T);        {Puede mover 0,Y}
                                    YY:=YY+Trunc(T*Sc)   { O X,0 }
                               End;

                     Dis:=Round(Sqrt(XX*XX+YY*YY));
                     If XX<>0 Then Des:=ArcTan(YY/XX);
                     If XX=0 Then
                     Begin
                          If YY<0 Then Des:=-Pi/2;
                          If YY>=0 Then Des:=Pi/2
                     End;

                     Rx:=Round(Dis*Cos(Ang+Des));
                     Ry:=Round(Dis*Sin(Ang+Des));

                     If Si Then
                     Begin
                          LineTo(Xo+Rx,Yo+Ry,C)
                     End
                        Else
                     Begin
                          SetOrigin(Xo+Rx,Yo+Ry)
                     End;
               End
               Until D=''
          End;

Procedure ScreenDisplay;
          Begin
               port[$3D4] := 13 ;
               port[$03D5] := X
          End;

Procedure Zoom;
          Var P:Pointer;
              A,B,C:integer;
          Begin
               GetBlock(X,Y,Ax,Ay,P); C:=4;
               For A:=0 to Ay-1 Do For B:=0 to Ax-1 Do
               Begin
               Box(Dx+B*Tx,Dy+A*Ty,Dx+(B+1)*Tx,Dy+(A+1)*Ty-1,Mem[Seg(P^):Ofs(P^)+C]);
               C:=C+1
               End;
               DelBlock(P)
          End;

Procedure ZoomBlock;
          Var A,B,C,Ax,Ay:integer;
          Begin
               Ax:=XBlock(Block); Ay:=Yblock(Block);
               C:=4;
               For A:=0 to Ay-1 Do For B:=0 to Ax-1 Do
               Begin
               Box(X+B*Tx,Y+A*Ty,X+(B+1)*Tx,Y+(A+1)*Ty-1,Mem[Seg(Block^):Ofs(Block^)+C]);
               C:=C+1
               End;
          End;

Procedure ZoomFromScreen;
          Var A,B:integer;
          Begin
               For A:=0 to Ay-1 Do For B:=0 to Ax-1 Do
               Box(DX+B*Tx,DY+A*Ty,DX+(B+1)*Tx,DY+(A+1)*Ty-1,Mem[Seg(Block^):Ofs(Block^)+(Y+A)*320+(X+B)]);
          End;

{ ========================== Initialization ============================= }


Begin
     VgaVideo:=Ptr($a000,0000);
     VgaOx:=0;
     VgaOy:=0;
     VgaVideoX:=320;
     VgavideoY:=200;
     SumaX:=0;
     SumaY:=0;
     DesX:=0;
     DesY:=0;
END.



