{ ------------------------------------------------------------------------ }
{ --------------------------- Unidad U_FUENTE ---------------------------- }
{ ------------------------ Alberto Salazar Palomo ------------------------ }
{ ------------------------- Navigator Soft 1997 -------------------------- }
{ ------------------------------------------------------------------------ }
unit u_fuente;
interface
uses vga256,u_tipos;


TYPE

  t_fuente=object
    letras:array [0..256,1..8] of byte;
    gradiente_i:byte; { color incio del gradiente, final=gradiente_i+8 }

    { --------------- }

    procedure init (cfichero:cad70);
    procedure i_gradiente (color:byte);
    procedure cargar (cfichero:cad70);
    procedure actu_linea_pix (cadena:cad39;linea_pix:byte;
       posx,posy,topexmin,topeymin,topexmax,topeymax:integer;
       gradiente:boolean);
    procedure actu_cadena_pant (cadena:cad39;posx,posy:integer;
      topexmin,topeymin,topexmax,topeymax:integer;gradiente:boolean);
  end;

{}
IMPLEMENTATION

{}
procedure t_fuente.init (cfichero:cad70);
var
  fi:file;
  buffer:word;

  begin
    Assign(Fi,cfichero);
    Reset(Fi,1);
    Seek(Fi,16);

    buffer:=filesize (fi)-16;
    blockread (fi,letras,buffer);

    Close(Fi);
  end; { //-- Fin de t_fuente.init }

{}

procedure t_fuente.i_gradiente (color:byte);
  begin
    gradiente_i:=color;
  end; { //-- Fin de t_fuente.i_gradiente }

{}

procedure t_fuente.cargar (cfichero:cad70);
  begin
   init (cfichero);
  end; { //-- Fin de t_fuente.cargar }
{}

procedure t_fuente.actu_linea_pix (cadena:cad39;linea_pix:byte;
       posx,posy,topexmin,topeymin,topexmax,topeymax:integer;
       gradiente:boolean);

var
  px:integer;
  mascara,conta,contalong,long:byte;

  begin
    if linea_pix<9 then
      begin
      long:=length (cadena);
      contalong:=1;
      px:=topexmin;

      while (contalong<=long) and (px<topexmax) do
        begin
          mascara:=letras [ord (cadena [contalong]),linea_pix]; { Escogemos la }
          { letra, y el nmero de lnea de pixels (1..8) de la letra que }
          { queremos imprimir }
          for px:=px to px+8 do { Para una letra Xx8 (eje X) }
            begin

              if mascara and 128=128 then { Falta poner gradientes y }
                begin { controlar que no este en el topey }
                 if not (posy>topeymax) and not (posy<topeymin) then
                   begin
                   if gradiente then
                     pset (px,posy,gradiente_i+linea_pix)
                   else
                     pset (px,posy,7); { Cambiar el color }
                   end;
                end;
            mascara:=mascara shl 1; { Rotamos los bits hacia la izquierda }
            end;
          inc (contalong);
        end;
      end;
  end; { //-- Fin de t_fuente.actu_linea_pix }

{ EXPLICACION DEL ROLLO DEL AND RARO Y EL SHL }
{if mascara and 128 = 128 then (* Este es un BitWise AND *)
         (* !? -> nos compara si el bit ms alto del nmero mascara *)
         (* ( formato byte -> 8 Bits -> ltimo bit 2**7=128 ), comparamos*)
         (* si est a uno para imprimir, y rotamos los bits de los *)
         (* nmeros, con SHL ( ms abajo), con lo que el bit 7 pasa a *)
         (* ser el 8, y comprobamos lo mismo para imprimir el siguiente *)
         (* caracter... -> si sabes un poco como va el rollo este de *)
         (* los nmeros en binario habrs pillado esto ms o menos *) }
{}
procedure t_fuente.actu_cadena_pant (cadena:cad39;posx,posy:integer;
      topexmin,topeymin,topexmax,topeymax:integer;gradiente:boolean);
var
  conta:byte;

  begin
    for conta:=1 to 10 do
      begin
        actu_linea_pix (cadena,conta,posx,posy,topexmin,topeymin,
            topexmax,topeymax,gradiente);
        inc (posy);
      end;
  end; { //-- Fin de t_fuente.actu_cadena_pant }
{}
{}
{}
{}
{}
end.

{ ------------------------------------------------------------------------- }
{ ------------------------------ PUBLICIDAD ------------------------------- }
{ --> Si lo que te gusta es programar,  OYE !, este es tu fanzine: ------- }
{ ------------------------- Virtual Zone Magazine ------------------------- }
{ ------------------------- C/ Camino de Ronda 38, 1D -------------------- }
{ ------------------------- 18004 - Granada ------------------------------- }
{ ------------------------------------------------------------------------- }
