


/*
 * GtkScare is a runner for Adrift text adventure games.
 * This program is released under GNU GPL. See the file COPYING.TXT for
 * details.
 * Copyright (c) 2004 Pallav Nawani
 *
 */


/*! 
*
* \file rogue.h
* 	Data Structures for Rogue.
* 	
* 	
* \author Pallav Nawani
* Copyright Pallav Nawani
* 
*/

#ifndef _IC_GTKSCARE_H_
#define _IC_GTKSCARE_H_

#include "gtk/gtk.h"
#include <stdio.h>
#include "scare.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "agility.h"
#include "interp.h"

#ifdef __cplusplus
}
#endif

#include "os.h"

/* tads 2 headers */
#include "trd.h"

/* tads 3 headers */
#include "t3std.h"
#include "vmmain.h"
#include "vmvsn.h"
#include "vmmaincn.h"
#include "vmhostsi.h"


/*
 * data maintained internally by Rogue.
 */


#define NSIZE 2048
#define CMDBUF 256
#define DEFAULT_FONT_SIZE 12

#define CONFIG_STR_MAX NSIZE
#define CONFIG_STR_NUM 8

enum Rg_dialog_response {
   DNORESPONSE = -1,
   DNO,
   DYES
};

// The supported game types
enum Rg_game_types {
   RG_NOGAME,
   RG_ADRIFT,
   RG_AGX,
   RG_TADS2,
   RG_TADS3
};

// These are the game related commands we may be working on
enum Rg_game_commands {
   OPEN_GAME,
   SAVE_GAME,
   LOAD_SAVEFILE,
   RESTART_GAME,
   SET_BGCOLOR,
   SET_NORMALCOLOR,
   SET_INPUTCOLOR,
   SET_FONT,
   WAIT_FOR_KEY,
   WAIT_FOR_INPUT,
   LOAD_INFOFILE
};



/* These are tags used to format the output of Rogue */
enum Output_tags {
   ITALIC,
   BOLD,
   UNDERLINE,
   CENTER,
   RIGHT_JUSTIFY,
   NORMAL,
   USERINPUT,
   IMPORTANTINFO,
   DEBUGINFO,
   LASTTAG
};


// Configuration data
struct Config_data
{
   char prevfiles[CONFIG_STR_NUM][CONFIG_STR_MAX];
   int num_prev_files;
   int verbosity;
   GdkColor bgcol;
   GdkColor fgcol;

   // Init config data
   Config_data()
   {
      int i;
      int j;
      
      for(i = 0; i < CONFIG_STR_NUM; i++)
      	 for(j = 0; j < CONFIG_STR_MAX; j++)
	    prevfiles[i][j] = '\0';

      num_prev_files = 0;
      verbosity   = 0;
      
      bgcol.pixel = 0;
      bgcol.red   = 0;
      bgcol.green = 0;
      bgcol.blue  = 0;
      fgcol = bgcol;
   }

   /* read configuration data from a file */
   void rg_read_config();

   /* Write configuration data to a file */
   void write_config();

};


/// Data for an adrift game
typedef struct _rg_scare_data
{
   int type;			///< Game type 
   sc_game sgame;		///< The game being played
   sc_game_hint shint[CMDBUF];	///< Hints for the game
} Rg_scare_data;


/// Data for a Tads game
typedef struct _rg_tads_data
{
   int argc;		///< Argc. For some stupid reason Tads
			///< wants to mess with argv and argc.
   char **argv;		///< Argv
   unsigned key;	///< Gdk code of key pressed
   unsigned modifier;	///< Gdk code for modifier
   char *sstr;		///< Score string.

} Rg_tads_data;


/// Data for a game supported by Rogue
typedef union {
   int type;			///< Game type
   Rg_scare_data scare;		///< A Scare game

} Rg_game;


/// The main data structure in Rogue. It holds all the information for running the games.
typedef struct _Gtk_sdata {

   int argc;		   ///< Count of arguments to Rogue
   char **argv;		   ///< Arguments to Rogue

   char gname[NSIZE];	   ///< Name of the current game
   char userin[NSIZE];	   ///< User input
   char name[NSIZE];	   ///< Space for name
   char cmds[CMDBUF][256]; ///< Command buffer

   int num_cmds;	///< Number of commands in the buffer
   int ipoint;		///< Insertion point of commands
   int spoint;		///< Search point
   
   FILE *savefile;	///< FILE pointer to  save file
   FILE *log;		///< input log
   FILE *debuglog;	///< debug input log
   
   char tags[CMDBUF][64]; ///< Stack of tags that can be applied to output
   int  tsize;		///< Number of tags in stack

   short fstack[CMDBUF];///< Font size stack
   short ftop;		///< top of the font stack
   GtkTextTag *ftag;	///< Current font tag
   
   char got_input;	///< Got input?
   char got_key;	///< Got keypress?
   char status;		///< Status bar update id
   char command;	///< The command we're working on
   char yesno;		///< confirmation value
   char menu;		///< Was the save/load done from the menu?

   GtkWidget *textw;	///< The text widget
   GtkWidget *notesw;	///< The notes widget
   GtkWidget *sbar;	///< The status bar
   GtkWidget *mwin;	///< The main window
   GtkWidget *entry;	///< The entry widget
   GtkWidget *curw;	///< Current widget
   GtkWidget *mverb;	///< The menu widget that sets/unsets verbose
   GtkWidget *debugger;	///< The debugger console
   GtkCheckMenuItem *log_menu_item;	///< Logging enabled/disabled
   GtkWidget *log_toolbar;	///< Logging enabled/disabled

   GdkPixbuf *gp;	///< Used in the about box

   Rg_game rgame;	///< The game being played
   Rg_tads_data tads;	///< Tads data
   Config_data  cdata;	///< Configuration data

} Gtk_sdata;


// Initialize interface data
void sdata_init(Gtk_sdata *sdata);

/* make tags which are used in formatting user input */
void make_tags(Gtk_sdata *sdata, GtkTextBuffer *buffer);

#endif




/*  End of file rogue.h  */

