
/*! 
*
* Rogue is a runner for Interactive fiction games. It supports games
* written in many different toolkits. These include Adrift, AGT/AGX
* and TADS.
*
* \file rg_game.h
* 	No description yet
* 	
* 	
* \author Pallav Nawani
* Copyright Pallav Nawani (c) 2005
* 
*/

#include "rogue.h"

#ifndef _IC_RG_GAME_H_
#define _IC_RG_GAME_H_


/// Identifies the game type.
int identify_game_type(char *fname);

/// Loads a supported game.
int rg_open_game(Gtk_sdata *rdata, char *fname);

/// Get the name of the game currently being played.
char *rg_get_game_name(Gtk_sdata *rdata);

/// Returns the name of the author of the current game.
char *rg_get_author_name(Gtk_sdata *rdata);

/// Returns the default font requested by the game.
char *rg_get_game_font(Gtk_sdata *rdata);

/// Some game specific setup
void rg_game_setup(Gtk_sdata *rdata);

/// Is the game running?
int rg_game_running(Gtk_sdata *rdata);

/// Has the game finished?
int rg_game_finished(Gtk_sdata *rdata);

/// Free game data & do cleanup.
void rg_free_game(Gtk_sdata *rdata);

/// Restart a game.
void rg_restart_game(Gtk_sdata *rdata);

/// Load a save game is the game is already running.
void rg_load_save_game(Gtk_sdata *rdata);

/// Saves the game if a game is currently running.
void rg_save_the_game(Gtk_sdata *rdata);

/// Quits a running game.
int rg_quit_game(Gtk_sdata *rdata);

/// Sets the verbosity mode for the game.
void rg_set_game_verbosity(Gtk_sdata *rdata, int mode);

/// Undo a game turn if a game is running.
int rg_undo_game_turn(Gtk_sdata *rdata);

/// Make a string for the title bar
void rg_make_title_string(Gtk_sdata *sdata, char *title, int len);

#endif




/*  End of file rg_game.h  */

