
/*! 
*
* Rogue is a runner for Interactive fiction games. It supports games
* written in many different toolkits. These include Adrift, AGT/AGX
* and TADS.
*
* \file rg_basic.h
* 	General operations required by all interpreters such as
*	prompting for filename, outputting strings, etc.
* 	
* 	
* \author Pallav Nawani
* Copyright Pallav Nawani (c) 2005
* 
*/


#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>

#include "support.h"
#include "rogue.h"
#include "interface.h"


#ifndef _IC_RG_BASIC_H_
#define _IC_RG_BASIC_H_

/// Make text output tags.
void make_tags(Gtk_sdata *sdata, GtkTextBuffer *buffer);

/// Display a text string.
void rg_output_string(Gtk_sdata *idata, const char *string);

/// Get a line of input from the user.
void rg_read_line(Gtk_sdata *idata);

/// Push a string onto the status bar.
void rg_update_status_bar(Gtk_sdata *idata, const char *string);

/// Get a filename from the user.
int rg_get_filename(Gtk_sdata *idata, int is_save);

/// Clears the text buffer.
void rg_clear_screen(Gtk_sdata *idata);

/// Loads and shows a text file.
void rg_show_info(char *fname);

/// Sends command to interpreters
void rg_send_command(Gtk_sdata *idata, char *input);

#endif




/*  End of file rg_basic.h  */

