//---------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "FontDialog.h"
#include "glkthread.h"
#include "verbs.h"
#include "Main.h"
#include "preps.h"
//---------------------------------------------------------------------
#pragma resource "*.dfm"
TFontsForm *FontsForm;
extern GLK *glk;
//---------------------------------------------------------------------
__fastcall TFontsForm::TFontsForm(TComponent* AOwner)
	: TForm(AOwner)
{
}
//---------------------------------------------------------------------
void TFontsForm::populate_fonts()
{
TEXTMETRIC font_data;
PropFont->Items->Clear();

for (int i=0;i<Screen->Fonts->Count;i++){
    Canvas->Font->Name=Screen->Fonts->Strings[i];
    GetTextMetrics(Canvas->Handle,&font_data);
    if (font_data.tmPitchAndFamily&TMPF_TRUETYPE){
      PropFont->Items->Add(Screen->Fonts->Strings[i]);
      MenuFont->Items->Add(Screen->Fonts->Strings[i]);};
    if (!(font_data.tmPitchAndFamily&TMPF_FIXED_PITCH)&&(font_data.tmPitchAndFamily&TMPF_TRUETYPE))
      FixedFont->Items->Add(Screen->Fonts->Strings[i]);
    if (Screen->Fonts->Strings[i]==MainForm->prop_font->Name)
      PropFont->ItemIndex=PropFont->Items->Count-1;
    if (Screen->Fonts->Strings[i]==MainForm->fixed_font->Name)
      FixedFont->ItemIndex=FixedFont->Items->Count-1;
    if (Screen->Fonts->Strings[i]==VerbForm->Font->Name)
      MenuFont->ItemIndex=MenuFont->Items->Count-1;};

PropSize->Text=MainForm->prop_font->Size;
FixedSize->Text=MainForm->fixed_font->Size;
MenuSize->Text=VerbForm->VerbTree->Font->Size;
};
//--------------------------------------------------------------------------
void __fastcall TFontsForm::SizeKeyPress(TObject *Sender,
      char &Key)
{
if ((Key<'0'||Key>'9')&&(Key!=8))
  Key=0;
}
//---------------------------------------------------------------------------

void __fastcall TFontsForm::FormShow(TObject *Sender)
{
oked=false;

orig_textbuffer_font=PropFont->ItemIndex;
orig_textgrid_font=FixedFont->ItemIndex;
orig_menu_font=MenuFont->ItemIndex;

orig_textbuffer_size=PropSize->Text.ToInt();
orig_textgrid_size=FixedSize->Text.ToInt();
orig_menu_size=MenuSize->Text.ToInt();
}
//---------------------------------------------------------------------------

void __fastcall TFontsForm::CancelBtnClick(TObject *Sender)
{
PropFont->ItemIndex=orig_textbuffer_font;
FixedFont->ItemIndex=orig_textgrid_font;
MenuFont->ItemIndex=orig_menu_font;

PropSize->Text=orig_textbuffer_size;
FixedSize->Text=orig_textgrid_size;
MenuSize->Text=orig_menu_size;
}
//---------------------------------------------------------------------------

void __fastcall TFontsForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
if (!oked)
  CancelBtnClick(NULL);
}
//---------------------------------------------------------------------------

void __fastcall TFontsForm::OKBtnClick(TObject *Sender)
{
int textbuffer_size=PropSize->Text.ToInt();
int textgrid_size=FixedSize->Text.ToInt();
int menu_size=MenuSize->Text.ToInt();

if (textbuffer_size<10||textbuffer_size>20||textgrid_size<10||textgrid_size>20||
    menu_size<10||menu_size>20)
  Application->MessageBox("All fonts must be sized between 10 and 20 points.",
    "Sorry!",MB_OK);

else{

  MainForm->prop_font->Name=PropFont->Items->Strings[PropFont->ItemIndex];
  MainForm->prop_font->Size=textbuffer_size;

  MainForm->fixed_font->Name=FixedFont->Items->Strings[FixedFont->ItemIndex];
  MainForm->fixed_font->Size=textgrid_size;

  if (!MainForm->story_loaded){
    glk->prop_font->Assign(MainForm->prop_font);
    glk->fixed_font->Assign(MainForm->fixed_font);};

  VerbForm->Font->Name=MenuFont->Items->Strings[MenuFont->ItemIndex];
  VerbForm->Font->Size=menu_size;
  PrepForm->Font->Assign(VerbForm->Font);

  oked=true;};
}
//---------------------------------------------------------------------------

