package zpplet.system;

/*
 * An automatically resizable window 0.
 * 		- Does not use margins
 * 		- Not for V6
 * Would be nice to add scrollback (via JScroll?) 
 */

import java.util.*;

import zpplet.ZUserConfig;
import zpplet.machine.ZMachine;
import zpplet.misc.ScrollBuffer;
import zpplet.misc.ZChars;

public class ZWindow0
		extends ZWindow
	{
	private ScrollBuffer para; // paragraphs

	public ZWindow0(ZMachine zm)
		{
		super(zm, 0);
		para = new ScrollBuffer(ZUserConfig.scrollback);
		}

	public void newLine()
		{
		para.nextLine();
		appendFormatChars();
		super.newLine();
		}

	protected synchronized void bufferChar(int ch)
		{
		para.append((char)ch);
		super.bufferChar(ch);
		}

	public void resize(int width, int height)
		{
		flush();
		int delta = getCursorY() - height;
		if ((delta > 0) || ((delta < 0) && (getCursorY() >= getLines()))) ypos -= delta * screen.getLineHeight();
		this.width = width * screen.unitx;
		this.height = height * screen.unity;
		if (!inBounds(xpos) || (ypos >= this.height))
			{
			xpos = leftmargin;
			ypos = 0;
			}
		resetLineCount();
		renderLines();
		}

	private Vector splitLine(String s, int maxwidth)
		{
		Vector result = new Vector();
		
		int start = 0, end = 0; // current line (end at breaking space)
		int first = 0, last = 0; // potential addendum (no internal spaces/control)  
		int wstart = 0; // start of new width (position past last control sequence)
		int prewidth = 0; // width from start to wstart

		int format = s.indexOf(ZChars.FORMAT_ESCAPE); // position of next control character
		if (format == -1) format = s.length();
		
		while (first < s.length())
			{
			int space = s.indexOf(' ', first);
			if (space == -1) space = s.length();
			last = (format < space) ? format : space;

			int width = prewidth + screen.getStringWidth(s.substring(wstart, last), font);
			while (width > maxwidth)
				{
				if (start < end)
					{
					// already have a candidate line, so lop it off and check updated size
					result.add(s.substring(start, end));
					start = end = wstart = first;
					prewidth = 0;
					width = screen.getStringWidth(s.substring(first, last), font);
					}
				
				// check for splits in middle of word
				while (width > maxwidth && (last - first) > 1)
					width = prewidth + screen.getStringWidth(s.substring(first, --last), font);

				end = last;
				}

			// add the addendum 
			if (format < space)
				{
				// adding up to control
				prewidth += screen.getStringWidth(s.substring(wstart, format), font);
				first = end = wstart = format + 3;
				setFormat(s.charAt(format + 1), s.charAt(format + 2));
				
				format = s.indexOf(ZChars.FORMAT_ESCAPE, first);
				if (format == -1) format = s.length();
				}
			else
				{
				first = end = space;
				while ((first < s.length()) && (s.charAt(first) == ' '))
					first++; // skip spaces
				}
			}
		
		// add current line
		result.add(s.substring(start, end));
		return result;
		}

	public void renderLines()
		{
		// magically rewrite entire window
		// NOTE: does not use margins
		ZFont curfont = font;
		clear();
		int line = 0, yline = getCursorY();
		while (yline >= 0)
			{
			String s = para.get(line++);
			if (s == null) break;
			Vector split = splitLine(s, width);
			yline -= split.size();
			for (int i = 0; i < split.size(); i++)
				drawFormatText(left, top + (yline + i) * screen.getLineHeight(), (String)split.get(i));
			}
		font = curfont;
		if (pausing) drawMore();
		}

	private void setFormat(int stylechar, int colorchar)
		{
		font.set(stylechar >> 8);
		font.setStyle(stylechar & 0xFF);
		font.color.setZColor(colorchar & 0xFF, colorchar >> 8);
		}

	private void drawFormatText(int x, int y, String text)
		{
		int p = 0;
		while (true)
			{
			int i = text.indexOf(ZChars.FORMAT_ESCAPE, p);
			if (i == -1)
				{
				screen.drawText(x, y, text.substring(p), this);
				return;
				}
			if (i > p) x += screen.drawText(x, y, text.substring(p, i), this);
			setFormat(text.charAt(i + 1), text.charAt(i + 2));
			p = i + 3;
			}
		}

	public void postInputLine(String s)
		{
		para.append(s);
		}

	private void appendFormatChars()
		{
		para.append(ZChars.FORMAT_ESCAPE);
		para.append((char)((font.getZFont() << 8) | font.getZStyle()));
		para.append((char)font.getColorBytes());
		}

	public void setColor(int fg, int bg)
		{
		super.setColor(fg, bg);
		appendFormatChars();
		}

	public void setStyle(int style)
		{
		super.setStyle(style);
		appendFormatChars();
		}

	public int setFont(int zfont)
		{
		int result = super.setFont(zfont);
		appendFormatChars();
		return result;
		}
	}