package zpplet.system;

import java.awt.*;

import zpplet.system.ZColor;
import zpplet.ZUserConfig;

public class ZFont
	{
	// font styles
	public final static int ROMAN = 0;
	public final static int REVERSE = 1;
	public final static int BOLD = 2;
	public final static int ITALIC = 4;
	public final static int FIXED = 8;

	// fonts
	public final static int PREVIOUS_FONT = 0;
	public final static int NORMAL_FONT = 1;
	public final static int PICTURE_FONT = 2;
	public final static int GRAPHICS_FONT = 3;
	public final static int FIXED_FONT = 4;

	private Font font;
	private int zfont, zstyle;
	public ZColor color;
	private boolean dirty; // need to regen font

	public ZFont(ZScreen screen)
		{
		zfont = NORMAL_FONT;
		zstyle = ROMAN;

		color = new ZColor();
		dirty = true;
		}

	public Font getFont()
		{
		if (dirty)
			{
			String name = (zfont == FIXED_FONT) || ((zstyle & FIXED) != 0) ? ZUserConfig.fixedfont
					: ZUserConfig.normalfont;
			int style = (zstyle & ITALIC) == 0 ? Font.PLAIN : Font.ITALIC;
			if ((zstyle & BOLD) != 0)
				style |= Font.BOLD; 
			font = new Font(name, style, ZUserConfig.fontsize);
			}
		return font;
		}
	
	public void touch()
		{
		dirty = true;
		}
	
	public Color getForeground()
		{
		Color result;
		if ((zstyle & REVERSE) == 0)
			result = color.fg;
		else
			result = color.bg;
		if ((zstyle & BOLD) != 0)
			return result.brighter();
		return result;
		}

	public int getZFont()
		{
		return zfont;
		}
	
	public int getZStyle()
		{
		return zstyle;
		}
	
	public Color getBack()
		{
		if ((zstyle & REVERSE) == 0)
			return color.bg;
		return color.fg;
		}

	public int getColorBytes()
		{
		return (color.zfg & 0xFF) + ((color.zbg & 0xFF) << 8);
		}
	
	public boolean isFixed()
		{
		return (zfont == FIXED_FONT) || ((zstyle & FIXED) != 0);
		}

	public void setStyle(int style)
		{
		if (style == ROMAN)
			zstyle = ROMAN;
		else
			zstyle |= style;
		dirty = true;
		}

	public int set(int font)
		{
		switch (font)
			{
			case PREVIOUS_FONT:
				return zfont;

			case FIXED_FONT: // courier
			case NORMAL_FONT:
				int old = zfont;
				zfont = font;
				dirty = true;
				return old;

			case PICTURE_FONT:
				return 0; // not supported by anyone

			case GRAPHICS_FONT: // graphics
				return 0; // not supported by me

			default:
				System.err.println("Illegal font value " + font);
				return 0;
			}
		}
	}