package zpplet.header;


public class ZHeader6
		extends ZHeader5
	{
	final static int FONT_HEIGHT_UNITS = 0x26;
	final static int FONT_WIDTH_UNITS = 0x27;
	
	final static int ROUTINE_BASE = 0x28;
	final static int STRING_BASE = 0x2A;
	final static int TEXT_PIXEL_WIDTH = 0x30;
	
	public ZHeader6(byte[] mem)
		{
		super(mem);
		}

	public void setFontHeightUnits(int value)
		{
		m[FONT_HEIGHT_UNITS] = (byte)value;
		}

	public void setFontWidthUnits(int value)
		{
		m[FONT_WIDTH_UNITS] = (byte)value;
		}

	public void setPicturesAvailable(boolean value)
		{
		super.setPicturesAvailable(value);
		if (value)
			m[FLAGS1] |= (1 << 1);
		else
			m[FLAGS1] &= ~(1 << 1);
		}
	
	public void setSoundAvailable(boolean value)
		{
		super.setSoundAvailable(value);
		if (value)
			m[FLAGS1] |= (1 << 5);
		else
			m[FLAGS1] &= ~(1 << 5);
		}

	public void setMenusAvailable(boolean value)
		{
		if (!value)
			m[FLAGS2] &= ~1;
		}
	
	public int getRoutineBase()
		{
		return getWord(ROUTINE_BASE) * 8;
		}
	
	public int getStringBase()
		{
		return getWord(STRING_BASE) * 8;
		}
	
	public void setPixelWidth(int value)
		{
		m[TEXT_PIXEL_WIDTH] = (byte)((value >> 8) & 0xFF);
		m[TEXT_PIXEL_WIDTH] = (byte)(value & 0xFF);
		}
	}
