/*
 * Decompiled with CFR 0.152.
 */
package zpplet.ops;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import zpplet.data.ZDictionary4;
import zpplet.data.ZUserDictionary;
import zpplet.machine.ZMachine;
import zpplet.machine.ZMachine5;
import zpplet.misc.ZError;
import zpplet.ops.ZInstruction;
import zpplet.ops.ZInstruction4;
import zpplet.system.ZWindow;

public class ZInstruction5
extends ZInstruction4 {
    public ZInstruction5(ZMachine zm) {
        super(zm);
    }

    protected void initOps() {
        super.initOps();
        this.ops[26] = new OP_CALLN();
        this.ops[27] = new OP_SET_COLOUR();
        this.ops[28] = new OP_THROW();
        this.ops[143] = new OP_CALLN();
        this.ops[181] = null;
        this.ops[182] = null;
        this.ops[185] = new OP_CATCH();
        this.ops[190] = null;
        this.ops[191] = new OP_PIRACY();
        this.ops[248] = new ZInstruction.OP_NOT(this);
        this.ops[249] = new OP_CALLN();
        this.ops[250] = new OP_CALLN();
        this.ops[251] = new OP_TOKENISE();
        this.ops[252] = new OP_ENCODE_TEXT();
        this.ops[253] = new OP_COPY_TABLE();
        this.ops[254] = new OP_PRINT_TABLE();
        this.ops[255] = new OP_CHECK_ARG_COUNT();
        this.ops[256] = new ZInstruction.OP_SAVE(this);
        this.ops[257] = new ZInstruction.OP_RESTORE(this);
        this.ops[258] = new OP_LOG_SHIFT();
        this.ops[259] = new OP_ART_SHIFT();
        this.ops[260] = new OP_SET_FONT();
        this.ops[265] = new OP_SAVE_UNDO();
        this.ops[266] = new OP_RESTORE_UNDO();
        this.ops[267] = new OP_PRINT_UNICODE();
        this.ops[268] = new OP_CHECK_UNICODE();
    }

    protected void doRead() throws ZError {
        if (this.noperands < 3) {
            this.o[2] = 0;
        }
        if (this.noperands < 4) {
            this.o[3] = 0;
        }
        int tbuf = this.o[0];
        this.zm.curw.flush();
        this.zm.curw.resetLineCount();
        int tsize = this.zm.getByte(tbuf);
        if (tsize < 3) {
            throw new ZError("Text buffer < 3 bytes");
        }
        int count = this.zm.getByte(tbuf + 1);
        tsize -= count;
        int ch = 13;
        while (tsize-- > 0) {
            ch = this.zm.getInput(true, this.o[2], this.o[3]);
            if (ch == -1) {
                throw new ZError(null);
            }
            if (this.zm.zc.isTerminator(ch)) break;
            if (ch >= 65 && ch <= 90) {
                ch += 32;
            }
            this.zm.setByte(tbuf + 2 + count++, ch);
        }
        this.zm.setByte(tbuf + 1, count);
        if (this.o[1] != 0) {
            this.zm.zd.tokenize(tbuf + 2, count, this.o[1], true);
        }
        this.doStore(ch);
    }

    protected void doSave() {
        if (this.noperands == 0) {
            super.doSave();
            return;
        }
        try {
            String fname = this.zm.getStringAt(this.o[2]).toUpperCase();
            if (fname.indexOf(46) == -1) {
                fname = String.valueOf(fname) + ".AUX";
            }
            System.out.println("Writing " + fname);
            FileOutputStream f = new FileOutputStream(fname);
            f.write(this.zm.getMem(), this.o[0], this.o[1]);
            f.close();
            this.doStore(1);
            return;
        }
        catch (IOException iOException) {
        }
        catch (ZError zError) {}
        this.doStore(0);
    }

    protected void doRestore() {
        if (this.noperands == 0) {
            super.doRestore();
            return;
        }
        try {
            String fname = this.zm.getStringAt(this.o[2]).toUpperCase();
            if (fname.indexOf(46) == -1) {
                fname = String.valueOf(fname) + ".AUX";
            }
            System.out.println("Reading " + fname);
            FileInputStream f = new FileInputStream(fname);
            f.read(this.zm.getMem(), this.o[0], this.o[1]);
            f.close();
            this.doStore(1);
            return;
        }
        catch (IOException iOException) {
        }
        catch (ZError zError) {}
        this.doStore(0);
    }

    protected void doEraseWindow() {
        short n = (short)this.o[0];
        if (n == -1) {
            this.doSplitWindow(0);
            this.zm.s.clear();
            this.zm.w[0].moveCursor(1, 1);
        } else if (n == -2) {
            this.zm.s.clear();
            this.zm.w[0].moveCursor(1, 1);
            this.zm.w[1].moveCursor(1, 1);
        } else {
            this.zm.w[this.o[0]].clear();
            this.zm.w[this.o[0]].moveCursor(1, 1);
        }
    }

    protected void loadParameters(int count) {
        int i = 0;
        while (i < count) {
            if (i < this.noperands - 1) {
                this.zm.l[i] = this.o[i + 1];
            }
            ++i;
        }
    }

    protected void doSetColour() {
        if (this.noperands < 3) {
            this.zm.curw.setColor((short)this.o[0], (short)this.o[1]);
        } else {
            this.zm.w[this.o[2]].setColor((short)this.o[0], (short)this.o[1]);
        }
    }

    class OP_CALLN
    implements ZInstruction.IOP {
        OP_CALLN() {
        }

        public void x() {
            ZInstruction5.this.doCall(false);
        }
    }

    class OP_SET_COLOUR
    implements ZInstruction.IOP {
        OP_SET_COLOUR() {
        }

        public void x() {
            ZInstruction5.this.doSetColour();
        }
    }

    class OP_THROW
    implements ZInstruction.IOP {
        OP_THROW() {
        }

        public void x() {
            while (ZInstruction5.this.zm.st.size() > ZInstruction5.this.o[1]) {
                ZInstruction5.this.zm.st.pop();
            }
            ZInstruction5.this.doReturn(ZInstruction5.this.o[0]);
        }
    }

    class OP_CATCH
    implements ZInstruction.IOP {
        OP_CATCH() {
        }

        public void x() {
            ZInstruction5.this.doStore(ZInstruction5.this.zm.st.size());
        }
    }

    class OP_PIRACY
    implements ZInstruction.IOP {
        OP_PIRACY() {
        }

        public void x() {
            ZInstruction5.this.doBranch(false);
        }
    }

    class OP_SET_CURSOR
    implements ZInstruction.IOP {
        OP_SET_CURSOR() {
        }

        public void x() {
            ZInstruction5.this.zm.curw.moveCursor(ZInstruction5.this.o[1], ZInstruction5.this.o[0]);
        }
    }

    class OP_TOKENISE
    implements ZInstruction.IOP {
        OP_TOKENISE() {
        }

        public void x() {
            ZDictionary4 dict = ZInstruction5.this.noperands < 3 || ZInstruction5.this.o[2] == 0 ? (ZDictionary4)ZInstruction5.this.zm.zd : new ZUserDictionary(ZInstruction5.this.zm, ZInstruction5.this.o[2]);
            boolean parseunknown = ZInstruction5.this.noperands < 4 || ZInstruction5.this.o[3] == 0;
            int tbuf = ZInstruction5.this.o[0];
            int tlen = ZInstruction5.this.zm.getByte(tbuf + 1);
            dict.tokenize(tbuf + 2, tlen, ZInstruction5.this.o[1], parseunknown);
        }
    }

    class OP_ENCODE_TEXT
    implements ZInstruction.IOP {
        OP_ENCODE_TEXT() {
        }

        public void x() {
            int ascii_text = ZInstruction5.this.o[0] + ZInstruction5.this.o[2];
            int coded_text = ZInstruction5.this.o[3];
            int[] encword = ZInstruction5.this.zm.zc.encode(ascii_text, ZInstruction5.this.o[1], 3);
            int i = 0;
            while (i < 3) {
                ZInstruction5.this.zm.setWord(coded_text + i * 2, encword[i]);
                ++i;
            }
        }
    }

    class OP_COPY_TABLE
    implements ZInstruction.IOP {
        OP_COPY_TABLE() {
        }

        public void x() {
            int first = ZInstruction5.this.o[0];
            int second = ZInstruction5.this.o[1];
            int length = ZInstruction5.this.o[2];
            if (ZInstruction5.this.o[1] == 0) {
                if (length < 0) {
                    length = -length;
                }
                int i = ZInstruction5.this.o[0] + length - 1;
                while (i >= ZInstruction5.this.o[0]) {
                    ZInstruction5.this.zm.setByte(i, 0);
                    --i;
                }
            } else if (length > 0) {
                System.arraycopy(ZInstruction5.this.zm.getMem(), first, ZInstruction5.this.zm.getMem(), second, length);
            } else {
                length = -length;
                int i = 0;
                while (i < length) {
                    ZInstruction5.this.zm.setByte(second + i, ZInstruction5.this.zm.getByte(first + i));
                    ++i;
                }
            }
        }
    }

    class OP_PRINT_TABLE
    implements ZInstruction.IOP {
        OP_PRINT_TABLE() {
        }

        public void x() {
            int textpos = ZInstruction5.this.o[0];
            int width = ZInstruction5.this.o[1];
            int height = 1;
            int skip = 0;
            if (ZInstruction5.this.noperands > 2) {
                height = ZInstruction5.this.o[2];
            }
            if (ZInstruction5.this.noperands > 3) {
                skip = ZInstruction5.this.o[3];
            }
            ZInstruction5.this.zm.curw.flush();
            int x = ZInstruction5.this.zm.curw.getCursorX();
            int y = ZInstruction5.this.zm.curw.getCursorY();
            int j = 0;
            while (j < height) {
                ZInstruction5.this.zm.curw.moveCursor(x, y + j);
                int i = 0;
                while (i < width) {
                    ZInstruction5.this.zm.printAsciiChar((char)ZInstruction5.this.zm.getByte(textpos++));
                    ++i;
                }
                textpos += skip;
                ++j;
            }
        }
    }

    class OP_CHECK_ARG_COUNT
    implements ZInstruction.IOP {
        OP_CHECK_ARG_COUNT() {
        }

        public void x() {
            ZInstruction5.this.doBranch(ZInstruction5.this.o[0] <= ZInstruction5.this.nargs);
        }
    }

    class OP_LOG_SHIFT
    implements ZInstruction.IOP {
        OP_LOG_SHIFT() {
        }

        public void x() {
            short n = (short)ZInstruction5.this.o[1];
            if (n >= 0) {
                ZInstruction5.this.doStore(ZInstruction5.this.o[0] << n);
            } else {
                ZInstruction5.this.doStore(ZInstruction5.this.o[0] >>> -n);
            }
        }
    }

    class OP_ART_SHIFT
    implements ZInstruction.IOP {
        OP_ART_SHIFT() {
        }

        public void x() {
            short n = (short)ZInstruction5.this.o[1];
            if (n >= 0) {
                ZInstruction5.this.doStore(ZInstruction5.this.o[0] << n);
            } else {
                ZInstruction5.this.doStore((short)ZInstruction5.this.o[0] >> -n);
            }
        }
    }

    class OP_SET_FONT
    implements ZInstruction.IOP {
        OP_SET_FONT() {
        }

        public void x() {
            ZWindow w = ZInstruction5.this.noperands < 2 ? ZInstruction5.this.zm.curw : ZInstruction5.this.zm.w[ZInstruction5.this.o[1]];
            ZInstruction5.this.doStore(w.setFont(ZInstruction5.this.o[0]));
        }
    }

    class OP_SAVE_UNDO
    implements ZInstruction.IOP {
        OP_SAVE_UNDO() {
        }

        public void x() {
            ZInstruction5.this.doStore(((ZMachine5)ZInstruction5.this.zm).saveUndo());
        }
    }

    class OP_RESTORE_UNDO
    implements ZInstruction.IOP {
        OP_RESTORE_UNDO() {
        }

        public void x() {
            ZInstruction5.this.doStore(((ZMachine5)ZInstruction5.this.zm).restoreUndo());
        }
    }

    class OP_PRINT_UNICODE
    implements ZInstruction.IOP {
        OP_PRINT_UNICODE() {
        }

        public void x() {
            int ch = ZInstruction5.this.zm.zc.fromUnicodeToZAscii((char)ZInstruction5.this.o[0]);
            if (ch != -2) {
                ZInstruction5.this.zm.printAsciiChar(ch);
            }
        }
    }

    class OP_CHECK_UNICODE
    implements ZInstruction.IOP {
        OP_CHECK_UNICODE() {
        }

        public void x() {
            int bits = 3;
            int ch = ZInstruction5.this.zm.zc.fromUnicodeToZAscii((char)ZInstruction5.this.o[0]);
            if (ch == -2) {
                bits &= 0xFFFFFFFD;
            }
            if (ZInstruction5.this.zm.zc.toOutput(ch) == '\u0000') {
                bits &= 0xFFFFFFFE;
            }
            ZInstruction5.this.doStore(bits);
        }
    }
}

