/*
 * Decompiled with CFR 0.152.
 */
package zpplet.ops;

import zpplet.machine.ZMachine;
import zpplet.ops.ZInstruction;
import zpplet.system.ZMedia;

public class ZInstruction3
extends ZInstruction {
    public ZInstruction3(ZMachine zm) {
        super(zm);
    }

    protected void initOps() {
        super.initOps();
        this.ops[188] = new OP_SHOW_STATUS();
        this.ops[189] = new OP_VERIFY();
        this.ops[234] = new OP_SPLIT_WINDOW();
        this.ops[235] = new OP_SET_WINDOW();
        this.ops[243] = new OP_OUTPUT_STREAM();
        this.ops[244] = new OP_INPUT_STREAM();
        this.ops[245] = new OP_SOUND_EFFECT();
    }

    protected void doSplitWindow(int lines) {
        if (this.zm.hd.getVersion() <= 3) {
            System.err.println("Splitting window while using status line");
        }
        if (lines == this.zm.w[1].getLines()) {
            return;
        }
        this.zm.w[1].flush();
        this.zm.w[0].flush();
        this.zm.w[0].moveTo(1, 1 + lines);
        this.zm.w[0].resize(this.zm.s.getChars(), this.zm.s.getLines() - lines);
        this.zm.w[1].resize(this.zm.s.getChars(), lines);
        if (this.zm.hd.getVersion() == 3) {
            this.zm.w[1].clear();
        }
    }

    class OP_SHOW_STATUS
    implements ZInstruction.IOP {
        OP_SHOW_STATUS() {
        }

        public void x() {
            ZInstruction3.this.zm.updateStatusLine();
        }
    }

    class OP_VERIFY
    implements ZInstruction.IOP {
        OP_VERIFY() {
        }

        public void x() {
            ZInstruction3.this.doBranch(ZInstruction3.this.zm.verifyChecksum());
        }
    }

    class OP_SPLIT_WINDOW
    implements ZInstruction.IOP {
        OP_SPLIT_WINDOW() {
        }

        public void x() {
            ZInstruction3.this.doSplitWindow(ZInstruction3.this.o[0]);
        }
    }

    class OP_SET_WINDOW
    implements ZInstruction.IOP {
        OP_SET_WINDOW() {
        }

        public void x() {
            ZInstruction3.this.zm.curw.flush();
            ZInstruction3.this.zm.curw = ZInstruction3.this.zm.w[ZInstruction3.this.o[0]];
            if (ZInstruction3.this.o[0] == 1) {
                ZInstruction3.this.zm.curw.moveCursor(1, 1);
            }
        }
    }

    class OP_OUTPUT_STREAM
    implements ZInstruction.IOP {
        OP_OUTPUT_STREAM() {
        }

        public void x() {
            if (ZInstruction3.this.o[0] == 0) {
                return;
            }
            short n = (short)ZInstruction3.this.o[0];
            boolean setting = n > 0;
            short stream = setting ? n : -n;
            int addr = ZInstruction3.this.noperands < 2 ? 0 : ZInstruction3.this.o[1];
            int width = ZInstruction3.this.noperands < 3 ? 0 : ZInstruction3.this.o[2];
            ZInstruction3.this.zm.curw.flush();
            ZInstruction3.this.zm.setOutputStream(stream, setting, addr, width);
        }
    }

    class OP_INPUT_STREAM
    implements ZInstruction.IOP {
        OP_INPUT_STREAM() {
        }

        public void x() {
            ZInstruction3.this.zm.setInputStream(ZInstruction3.this.o[0]);
        }
    }

    class OP_SOUND_EFFECT
    implements ZInstruction.IOP {
        OP_SOUND_EFFECT() {
        }

        public void x() {
            if (ZInstruction3.this.noperands == 0 || ZInstruction3.this.o[0] == 1 || ZInstruction3.this.o[0] == 2) {
                ZMedia.beep(ZInstruction3.this.o[0]);
                return;
            }
            if (ZInstruction3.this.zm.media != null) {
                switch (ZInstruction3.this.o[1]) {
                    case 1: {
                        ZInstruction3.this.zm.media.cacheSound(ZInstruction3.this.o[0]);
                        break;
                    }
                    case 2: {
                        int volume = ZInstruction3.this.noperands < 3 ? 255 : ZInstruction3.this.o[2] & 0xFF;
                        int loops = ZInstruction3.this.noperands < 3 ? 0 : ZInstruction3.this.o[2] >> 8;
                        ZInstruction3.this.zm.media.playSound(ZInstruction3.this.o[0], volume, loops);
                        break;
                    }
                    case 3: {
                        ZInstruction3.this.zm.media.stopSound();
                        break;
                    }
                    case 4: {
                        ZInstruction3.this.zm.media.uncacheSound(ZInstruction3.this.o[0]);
                    }
                }
            }
        }
    }
}

