/*
 * Decompiled with CFR 0.152.
 */
package zpplet.machine;

import zpplet.ZUserConfig;
import zpplet.data.ZDictionary4;
import zpplet.data.ZObjectTree4;
import zpplet.header.ZHeader6;
import zpplet.machine.ZMachine;
import zpplet.machine.ZMachine5;
import zpplet.ops.ZInstruction6;
import zpplet.system.ZColor;
import zpplet.system.ZScreen;
import zpplet.system.ZWindow;

public class ZMachine6
extends ZMachine5 {
    private int stringbase;
    private int routinebase;

    public ZMachine6(byte[] mem, ZScreen screen) {
        super(mem, screen);
    }

    public int unpackSAddr(int addr) {
        return this.stringbase + addr * 4;
    }

    public int unpackRAddr(int addr) {
        return this.routinebase + addr * 4;
    }

    protected void initStructures() {
        this.hd = new ZHeader6(this.m);
        this.objs = new ZObjectTree4(this);
        this.zd = new ZDictionary4(this);
        this.zi = new ZInstruction6(this);
    }

    protected void initWindows() {
        this.w = new ZWindow[8];
        this.w[0] = new ZWindow(this, 0);
        this.w[0].moveTo(1, 1);
        this.w[0].resize(this.s.getBoundsWidth(), this.s.getBoundsHeight());
        this.w[0].moveCursor(1, 1);
        this.w[0].setWrapMode(true);
        this.w[0].setScroll(true);
        this.w[0].setTranscripting(true);
        this.w[0].setBufferMode(true);
        int i = 1;
        while (i < 8) {
            this.w[i] = new ZWindow(this, i);
            this.w[i].moveTo(1, 1);
            this.w[i].resize(0, 0);
            this.w[i].setWrapMode(false);
            this.w[i].setScroll(false);
            this.w[i].setTranscripting(false);
            this.w[i].setBufferMode(true);
            ++i;
        }
        this.w[1].resize(this.s.getBoundsWidth(), 0);
        this.curw = this.w[0];
        this.s.setMouseWindow(1);
    }

    public void setHeaderFlags() {
        ZHeader6 header = (ZHeader6)this.hd;
        if (header.story == 3 && header.getRelease() == 296) {
            header.setGraphicsWanted(true);
        }
        header.setRevision(0, 0);
        if (header.isFixedForced()) {
            ZUserConfig.normalfont = ZUserConfig.fixedfont;
        }
        header.setBoldAvailable(true);
        header.setItalicAvailable(true);
        header.setFixedFontAvailable(true);
        header.setTimedInputAvailable(true);
        header.setInterpreterInfo(ZUserConfig.interpreter, 74);
        header.setScreenDimensions(this.s.getLines(), this.s.getChars());
        header.setColorsAvailable(true);
        header.setPicturesAvailable(this.media != null);
        header.setUndoAvailable(true);
        header.setMouseAvailable(true);
        header.setSoundAvailable(true);
        header.setScreenHeightUnits(this.s.getBoundsHeight());
        header.setScreenWidthUnits(this.s.getBoundsWidth());
        header.setFontHeightUnits(this.s.getLineHeight());
        header.setFontWidthUnits(this.s.getCharWidth());
        header.setDefaultForegroundColor(ZColor.def.zfg);
        header.setDefaultBackgroundColor(ZColor.def.zbg);
        int alphabase = header.getAlphaCustomBase();
        int terminatorbase = header.getTerminatorsBase();
        int unicodebase = header.getUnicodeBase();
        this.zc.setCustomAddresses(alphabase, terminatorbase, unicodebase);
        this.routinebase = header.getRoutineBase();
        this.stringbase = header.getStringBase();
        header.setMenusAvailable(false);
    }

    public void restart() {
        super.restart();
        this.w[0].moveTo(1, 1);
        this.w[0].resize(this.s.getBoundsWidth(), this.s.getBoundsHeight());
        this.w[0].moveCursor(1, this.w[0].getLines());
        int i = 1;
        while (i < 8) {
            this.w[i].moveTo(1, 1);
            this.w[i].resize(0, 0);
            ++i;
        }
        this.curw = this.w[0];
    }

    public void resize() {
        ZHeader6 h = (ZHeader6)this.hd;
        h.setScreenDimensions(this.s.getLines(), this.s.getChars());
        h.setScreenHeightUnits(this.s.getBoundsHeight());
        h.setScreenWidthUnits(this.s.getBoundsWidth());
    }

    public void openStream3(int addr, int width) {
        if (width < 0) {
            width = -width;
        } else if (width > 0) {
            width = this.w[width].getTextWidth();
        }
        this.stream3.push(new ZMachine.Stream3Data(this, addr, width));
        this.outputs[3] = true;
    }

    private StringBuilder getTableStringAt(int addr) {
        StringBuilder result = new StringBuilder();
        int nchars = this.getWord(addr);
        int i = 0;
        while (i < nchars) {
            result.append((char)this.getByte(addr + 2 + i));
            ++i;
        }
        return result;
    }

    public void closeStream3() {
        ZMachine.Stream3Data data = (ZMachine.Stream3Data)this.stream3.pop();
        data.pixelwidth += this.curw.getStringWidth(this.getTableStringAt(data.addr).toString());
        if (data.width != 0) {
            data.addr += this.getWord(data.addr) + 2;
            this.setWord(data.addr, 0);
        }
        ((ZHeader6)this.hd).setPixelWidth(data.pixelwidth);
        this.outputs[3] = !this.stream3.isEmpty();
    }

    public void printToStream3(int ch) {
        ZMachine.Stream3Data data = (ZMachine.Stream3Data)this.stream3.peek();
        int width = data.width;
        if (width == 0) {
            super.printToStream3(ch);
            return;
        }
        int nchars = this.getWord(data.addr);
        if (ch == 13) {
            data.pixelwidth += this.curw.getStringWidth(this.getTableStringAt(data.addr).toString());
            data.addr += 2 + nchars;
            this.setWord(data.addr, 0);
            return;
        }
        StringBuilder sb = this.getTableStringAt(data.addr);
        sb.append((char)ch);
        int split = this.curw.splitText(sb.toString(), data.width);
        if (split == 0) {
            this.setByte(data.addr + 2 + nchars, ch);
            this.setWord(data.addr, nchars + 1);
            return;
        }
        this.setWord(data.addr, split);
        data.pixelwidth += this.curw.getStringWidth(sb.substring(0, split));
        data.addr += 2 + nchars;
        while (split < sb.length() && sb.charAt(split) == ' ') {
            ++split;
        }
        sb.delete(0, split);
        this.setWord(data.addr, sb.length());
        int i = 0;
        while (i < sb.length()) {
            this.setByte(data.addr + 2 + i, sb.charAt(i));
            ++i;
        }
    }
}

