/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.Color;
import java.awt.Font;
import org.zmpp.swingui.Canvas;
import org.zmpp.swingui.ColorTranslator;
import org.zmpp.swingui.CursorWindow;
import org.zmpp.swingui.LineEditor;
import org.zmpp.swingui.TextCursorImpl;
import org.zmpp.swingui.Viewport;
import org.zmpp.swingui.WordWrapper;
import org.zmpp.vm.ScreenModel;
import org.zmpp.vm.TextCursor;

public abstract class SubWindow
implements CursorWindow {
    private Viewport viewport;
    private TextCursor cursor;
    private int top;
    private int height;
    private int foreground;
    private int background;
    private int fontnumber;
    private Font font;
    private boolean isReverseVideo;
    private String name;

    public SubWindow(Viewport viewport, String string) {
        this.viewport = viewport;
        this.cursor = new TextCursorImpl(this);
        this.name = string;
    }

    public int getFontNumber() {
        return this.fontnumber;
    }

    public void setFontNumber(int n) {
        this.fontnumber = n;
    }

    public void setReverseVideo(boolean bl) {
        this.isReverseVideo = bl;
    }

    public boolean isReverseVideo() {
        return this.isReverseVideo;
    }

    public TextCursor getCursor() {
        return this.cursor;
    }

    public void setCursorPosition(int n, int n2) {
        this.cursor.setPosition(n, n2);
    }

    public int getHeight() {
        return this.height;
    }

    public int getTop() {
        return this.top;
    }

    public void setVerticalBounds(int n, int n2) {
        this.top = n;
        this.height = n2;
        this.sizeUpdated();
    }

    public void resize(int n) {
        this.height = this.getCanvas().getFontHeight(this.font) * n;
        this.sizeUpdated();
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void clear() {
        this.clipToCurrentBounds();
        this.getCanvas().fillRect(this.getBackgroundColor(), 0, this.getTop(), this.getCanvas().getWidth(), this.height);
        this.resetCursorToHome();
    }

    public void eraseLine() {
        Canvas canvas = this.getCanvas();
        int n = this.getCurrentX();
        this.clipToCurrentBounds();
        canvas.fillRect(this.getBackgroundColor(), n, this.getCurrentY() - canvas.getFontAscent(this.font), canvas.getWidth() - n, canvas.getFontHeight(this.font));
    }

    public void setBackground(int n) {
        this.background = n;
    }

    protected Color getBackgroundColor() {
        if (this.background == -1) {
            return this.getCanvas().getColorAtPixel(this.getCurrentX(), this.getCurrentY());
        }
        return ColorTranslator.getInstance().translate(this.background, this.viewport.getDefaultBackground());
    }

    public void setForeground(int n) {
        this.foreground = n;
    }

    protected Color getForegroundColor() {
        if (this.foreground == -1) {
            return this.getCanvas().getColorAtPixel(this.getCurrentX(), this.getCurrentY());
        }
        return ColorTranslator.getInstance().translate(this.foreground, this.viewport.getDefaultForeground());
    }

    protected void printString(String string) {
        int n;
        Canvas canvas = this.getCanvas();
        int n2 = n = canvas.getWidth();
        WordWrapper wordWrapper = new WordWrapper(n2, canvas, this.font, this.isBuffered());
        String[] stringArray = wordWrapper.wrap(this.getCurrentX(), string);
        this.printLines(stringArray);
    }

    public String toString() {
        return "[" + this.name + "]";
    }

    public void drawCursor(boolean bl) {
        Canvas canvas = this.getCanvas();
        int n = canvas.getCharWidth(this.font, '0');
        this.clipToCurrentBounds();
        canvas.fillRect(bl ? this.getForegroundColor() : this.getBackgroundColor(), this.getCurrentX(), this.getCurrentY() - canvas.getFontAscent(this.font), n, canvas.getFontHeight(this.font));
    }

    public void backspace(char c) {
        Canvas canvas = this.getCanvas();
        int n = canvas.getCharWidth(this.font, c);
        this.clipToCurrentBounds();
        canvas.fillRect(this.getBackgroundColor(), this.getCurrentX() - n, this.getCurrentY() - canvas.getFontAscent(this.font), n, canvas.getFontHeight(this.font));
        this.cursor.setColumn(this.cursor.getColumn() - 1);
    }

    protected abstract void scrollIfNeeded();

    protected void newline() {
        this.cursor.setLine(this.cursor.getLine() + 1);
        this.cursor.setColumn(1);
    }

    protected Canvas getCanvas() {
        return this.viewport.getCanvas();
    }

    protected LineEditor getEditor() {
        return this.viewport.getLineEditor();
    }

    protected ScreenModel getScreen() {
        return this.viewport;
    }

    protected Viewport getViewport() {
        return this.viewport;
    }

    protected Color getTextBackground() {
        return this.isReverseVideo ? this.getForegroundColor() : this.getBackgroundColor();
    }

    protected Color getTextColor() {
        return this.isReverseVideo ? this.getBackgroundColor() : this.getForegroundColor();
    }

    protected void printLine(String string, Color color, Color color2) {
        this.clipToCurrentBounds();
        Canvas canvas = this.getCanvas();
        canvas.fillRect(color, this.getCurrentX(), this.getCurrentY() - canvas.getFontHeight(this.font) + canvas.getFontDescent(this.font), canvas.getStringWidth(this.font, string), canvas.getFontHeight(this.font));
        canvas.drawString(color2, this.font, this.getCurrentX(), this.getCurrentY(), string);
        this.cursor.setColumn(this.cursor.getColumn() + string.length());
    }

    public void flushBuffer() {
    }

    public abstract void setBufferMode(boolean var1);

    public abstract boolean isBuffered();

    public abstract void setPagingEnabled(boolean var1);

    public abstract boolean isPagingEnabled();

    public abstract void resetCursorToHome();

    public abstract void resetPager();

    protected abstract void sizeUpdated();

    protected abstract int getCurrentX();

    protected abstract int getCurrentY();

    private void printLines(String[] stringArray) {
        Color color = this.getTextColor();
        Color color2 = this.getTextBackground();
        if ((this.getFont().getStyle() & 1) > 0 && !this.isReverseVideo) {
            color = color.brighter();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.printLine(string, color2, color);
            if (!SubWindow.endsWithNewLine(string)) continue;
            this.newline();
        }
        this.scrollIfNeeded();
    }

    private static boolean endsWithNewLine(String string) {
        return string.length() > 0 && string.charAt(string.length() - 1) == '\n';
    }

    protected void clipToCurrentBounds() {
        Canvas canvas = this.getCanvas();
        canvas.setClip(0, this.top, canvas.getWidth(), this.height);
    }
}

