// zeal - A portable Glk-based Z-code interpreter
// Copyright (C) 2000 Jeremy Condit <jcondit@eecs.harvard.edu>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// =======================================================================
//  dict.h:
//
//  the dictionary class represents a dictionary in the z-machine's
//  memory, and is used for lookup, lexical analysis, and encoding.
// =======================================================================

#ifndef _dict_h_
#define _dict_h_

#include "zeal.h"
#include "alpha.h"

class dictionary {
    public:
        dictionary(address addr = 0);
        ~dictionary();

        ubyte z_encode(uword result[3], address* addr, address end);
        address lookup(uword target[3]);
        void lex(address text, address parse, bool preserve);

    private:
        bool add_zchar(uword* result, ubyte* cur, ubyte zchar);
        bool add_zscii(uword* result, ubyte* cur, ubyte zscii);

        bool next_word(address* addr, address end);
        bool is_separator(ubyte c);

        address dict;
        ubyte entry_len;
        word num_entries;
        bool sorted;

        ubyte* seps;
        ubyte num_seps;

        alphabet alpha;
};

#endif // _dict_h_
