// zeal - A portable Glk-based Z-code interpreter
// Copyright (C) 2000 Jeremy Condit <jcondit@eecs.harvard.edu>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// =======================================================================
//  bfish.h:
//
//  the bfish class decodes z-encoded strings into zscii text, handing
//  off the results to any zscii_output class.  bfish itself is an
//  abstract class; the bfish_addr and bfish_pc classes implement the
//  next_zword method to tell bfish where to get its data.
// =======================================================================

#ifndef _bfish_h_
#define _bfish_h_

#include "zeal.h"
#include "output.h"
#include "alpha.h"

class bfish {
    public:
        bfish();
        virtual ~bfish();

        virtual uword next_zword() = 0;

        void print_string(zscii_output* output, bool is_abbrev = false);

    private:
        typedef enum { NORMAL, ZSCII1, ZSCII2, ABBREV } state;

        struct context {
            state cur_state;

            int cur_shift;
            int locked_shift;

            ubyte zscii;
            int abbrev;
            
            bool is_abbrev;

            zscii_output* output;
        };

        void print_zchar(context* ctx, ubyte zchar);

        alphabet alpha;

        static const int shift_change[][3];
};

class bfish_addr : public bfish {
    public:
        bfish_addr(address addr_in);
        ~bfish_addr();

        uword next_zword();

    private:
        address addr;
};

class bfish_pc : public bfish {
    public:
        bfish_pc();
        ~bfish_pc();

        uword next_zword();
};

#endif // _bfish_h_
