/*
 * Decompiled with CFR 0.152.
 */
package zmachine;

import zmachine.ZMemory;
import zmachine.ZUserInterface;
import zmachine.ui.StringTokenizer;

class ZIOCard {
    private ZUserInterface zui;
    private ZMemory memory;
    private int version;
    private int inputStream;
    private int outputStream;
    private boolean buffer;
    private StringBuffer outputBuffer;
    private int[] isOpen;
    private int[] baseMemAddr;
    private int[] curMemAddr;
    private int[] memWidth;
    private int[] memCursorX;
    private boolean[] memMultiLine;

    ZIOCard() {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[4] = 1;
        this.isOpen = nArray;
        this.baseMemAddr = new int[16];
        this.curMemAddr = new int[16];
        this.memWidth = new int[16];
        this.memCursorX = new int[16];
        this.memMultiLine = new boolean[16];
    }

    void initialize(ZUserInterface ui, ZMemory mem, int ver, boolean buf) {
        this.zui = ui;
        this.memory = mem;
        this.version = ver;
        this.outputStream = 1;
        this.inputStream = 0;
        this.buffer = buf;
        this.outputBuffer = new StringBuffer();
    }

    void printString(String s) {
        if (this.isOpen[this.outputStream] == 0) {
            return;
        }
        switch (this.outputStream) {
            case 1: {
                if (this.buffer) {
                    this.outputBuffer.append(s);
                    break;
                }
                this.zui.showString(s);
                break;
            }
            case 2: {
                System.out.print(s);
                break;
            }
            case 3: {
                System.out.println("Stream 3");
                if (!this.memMultiLine[this.isOpen[this.outputStream] - 1]) {
                    int n = 0;
                    while (n < s.length()) {
                        this.memory.putByte(this.curMemAddr[this.isOpen[this.outputStream] - 1] + n, s.charAt(n));
                        ++n;
                    }
                    int n2 = this.isOpen[this.outputStream] - 1;
                    this.curMemAddr[n2] = this.curMemAddr[n2] + s.length();
                    this.memory.putWord(this.baseMemAddr[this.isOpen[this.outputStream] - 1], this.memory.fetchWord(this.baseMemAddr[this.isOpen[this.outputStream] - 1]) + s.length());
                    break;
                }
                StringTokenizer st = new StringTokenizer(s, "\n ", true);
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (tok.equals("\n")) {
                        this.memory.putWord(this.curMemAddr[this.isOpen[this.outputStream] - 1], 0);
                        this.baseMemAddr[this.isOpen[this.outputStream] - 1] = this.curMemAddr[this.isOpen[this.outputStream] - 1];
                        int n = this.isOpen[this.outputStream] - 1;
                        this.curMemAddr[n] = this.curMemAddr[n] + 2;
                        continue;
                    }
                    if (this.memCursorX[this.isOpen[this.outputStream] - 1] + tok.length() > this.memWidth[this.isOpen[this.outputStream] - 1] - 2) {
                        this.memory.putWord(this.curMemAddr[this.isOpen[this.outputStream] - 1], 0);
                        this.baseMemAddr[this.isOpen[this.outputStream] - 1] = this.curMemAddr[this.isOpen[this.outputStream] - 1];
                        int n = this.isOpen[this.outputStream] - 1;
                        this.curMemAddr[n] = this.curMemAddr[n] + 2;
                    }
                    int n = 0;
                    while (n < tok.length()) {
                        this.memory.putByte(this.curMemAddr[this.isOpen[this.outputStream] - 1] + n, tok.charAt(n));
                        ++n;
                    }
                    int n3 = this.isOpen[this.outputStream] - 1;
                    this.curMemAddr[n3] = this.curMemAddr[n3] + tok.length();
                    this.memory.putWord(this.baseMemAddr[this.isOpen[this.outputStream] - 1], this.memory.fetchWord(this.baseMemAddr[this.isOpen[this.outputStream] - 1]) + tok.length());
                }
                break;
            }
        }
    }

    void outputFlush() {
        if (!this.buffer) {
            return;
        }
        if (this.outputBuffer.length() == 0) {
            return;
        }
        this.zui.showString(this.outputBuffer.toString());
        this.outputBuffer = new StringBuffer();
    }

    void setOutputStream(int s, int baddr, int w, boolean multiLine) {
        System.out.println("Open/Close Stream " + s);
        if (s < 0) {
            int n = -s;
            this.isOpen[n] = this.isOpen[n] - 1;
            if (this.isOpen[-s] < 0) {
                this.isOpen[-s] = 0;
            }
            this.outputStream = 1;
            return;
        }
        if (s == 0 || s > 4) {
            this.zui.fatal("Illegal output stream: " + s);
        }
        if (s == 3) {
            int n = this.outputStream = 3;
            this.isOpen[n] = this.isOpen[n] + 1;
            if (this.isOpen[this.outputStream] > 16) {
                this.zui.fatal("Output stream 3 Overflow");
            }
            this.memMultiLine[this.isOpen[this.outputStream] - 1] = multiLine;
            this.baseMemAddr[this.isOpen[this.outputStream] - 1] = baddr;
            this.memory.putWord(this.baseMemAddr[this.isOpen[this.outputStream] - 1], 0);
            this.curMemAddr[this.isOpen[this.outputStream] - 1] = this.baseMemAddr[this.isOpen[this.outputStream] - 1] + 2;
            if (this.memMultiLine[this.isOpen[this.outputStream] - 1]) {
                this.memWidth[this.isOpen[this.outputStream] - 1] = w < 0 ? -w : this.zui.getWindowSize(w)[0];
                this.memCursorX[this.isOpen[this.outputStream] - 1] = 0;
            }
        } else if (s == 4) {
            this.zui.fatal("Output stream 4 not yet supported");
        } else {
            this.outputStream = s;
            this.isOpen[s] = 1;
        }
    }

    void setInputStream(int s) {
        if (s < 0 || s > 1) {
            this.zui.fatal("Illegal input stream: " + s);
        }
        if (s == 1) {
            this.zui.fatal("Input stream 1 unsupported");
        } else {
            this.inputStream = s;
        }
    }

    int readLine(StringBuffer sb, int time) {
        return this.zui.readLine(sb, time);
    }

    int readChar(int time) {
        int c = this.zui.readChar(time);
        return c;
    }
}

