/* support.c
 *
 *  ``pinfocom'' -- a portable Infocom Inc. data file interpreter.
 *  Copyright (C) 1987-1992  InfoTaskForce
 *  Modified 2003 by Nils Gesbert
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Header: RCS/support.c,v 3.0 1992/10/21 16:56:19 pds Stab $
 */

#include <string.h>
#include <ctype.h>
#ifndef NO_SIGNALS
#include <signal.h>
#endif

#include "infocom.h"

inline void
null()
{
    /* The NULL function */
}

void
change_status()
{
    if (gflags.game_state == RESTART_GAME) {
      int i;
      for (i = 0; i < data_head.save_bytes / BLOCK_SIZE + 1; i++)
	load_page(i, base_ptr + i * BLOCK_SIZE);
    }

    stack_var_ptr = stack_base;
    stack = --stack_var_ptr;

    pbf_p->len = 0;
    pc_page = data_head.game_o / BLOCK_SIZE;
    pc_offset = data_head.game_o % BLOCK_SIZE;
    fix_pc();

    gflags.game_state = PLAY_GAME;
}

void
restart()
{
    new_line();
    gflags.game_state = RESTART_GAME;
    change_status();
}

void
quit()
{
  gflags.game_state = QUIT_GAME;
}

inline void
verify()
{
  ret_value(1); /* Qui peut bien vouloir s'amuser  calculer des checksums ? */
}

void
store A1(word, value)
{
    /*extern word     *stack;*/

    word            var;

    NEXT_BYTE(var);
    if (var == 0)
        *(--stack) = value;
    else
        put_var(var, value);
}

void
ret_value A1(word, result)
{
    /*extern word     pc_offset;*/

    word    branch;

    NEXT_BYTE(branch);

    /* Test bit 7 */
    if ((branch & 0x80) != 0)
    {
        /* Clear bit 7 */
        branch &= 0x7F;
        ++result;
    }

    /* Test bit 6 */
    if ((branch & 0x40) == 0)
    {
        byte b;

        NEXT_BYTE(b);
        branch = (branch << 8) + b;
        /* Test bit D. If set, make branch negative. */
        if (branch & 0x2000)
            branch |= 0xC000;
    }
    else
        /* Clear bit 6 */
        branch &= 0xBF;

    if ((--result) != 0)
    {
        switch (branch)
        {
            case 0 :    rtn(0);
                        break;
            case 1 :    rtn(1);
                        break;
            default :   pc_offset += (branch - 2);
                        fix_pc();
        }
    }
}

byte
get_byte A2(word*, page, word*, offset)
{
    /*extern word     resident_blocks;*/
    /*extern byte     *base_ptr;*/

    byte            *ptr;

    if (*page < resident_blocks)
        ptr = base_ptr + ((long_word)*page * BLOCK_SIZE) + *offset;
    else
        ptr = fetch_page(*page) + *offset;

    ++(*offset);
    if (*offset == BLOCK_SIZE)
    {
        *offset = 0;
        ++(*page);
    }

    return (Z_TO_BYTE(ptr));
}

word
get_word A2(word*, page, word*, offset)
{
    word    temp;

    temp = get_byte(page, offset) << 8;
    return ((word)(temp + get_byte(page, offset)));
}

word
next_word()
{
    word    temp;
    byte    b;

    NEXT_BYTE(b);
    temp = b << 8;
    NEXT_BYTE(b);
    return ((word)(temp + b));
}

void
error A2(const char *, buffer, int, value)
{
  char    buf[81];

  sprintf(buf, buffer, value);
  ecrit_texte ("[Erreur : "); 
  ecrit_texte (buf);
  scr_putline (" -- appuyez sur une touche]");
  ngetchx(); /* a va quitter, faut qu'on puisse lire le message */
  quit();
}
