/*
  Alloc
*/

#include "alloc.h"

#include "os.h"

void *allocate(size_t n)
{
  void *s = os_alloc(n);
  if(n && !s)
    os_exit(1);
  return s;
}

void *allocate_zero(size_t n)
{
  void *s = allocate(n);
  os_mset(s, n, 0);
  return s;
}

