/*
 * generic.c
 *
 * Very primitive, generic interface using stdio
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "frotz.h"

extern char euro_substitute[];

static swallow_nl = 0;

void 	os_beep (int n) {}
void 	os_cursor_off (void) {}
void 	os_cursor_on (void) {}
void 	os_draw_picture (int n, int x, int y) {}
void 	os_erase_area (int top, int left, int bottom, int right) {}
void 	os_finish_with_sample (void) {}
int  	os_font_data (int n, int *height, int *width) { return 0; }
void 	os_more_prompt (void) {}
int  	os_peek_colour (void) { return 0; }
int  	os_picture_data (int n, int *height, int *width) { return 0; }
void 	os_prepare_sample (int n) {}
int	os_random_seed (void) { return 1; }
void 	os_reset_screen (void) {}
void 	os_set_colour (int fg, int bg) {}
void 	os_set_cursor (int y, int x) {}
void 	os_set_font (int font) {}
void 	os_set_text_style (int style) {}
void 	os_start_sample (int n, int r, int vol) {}
void 	os_stop_sample (void) {}
void 	os_wait_sample (void) {}

int os_char_width (int c)
{

    if (c == 9)		/* gap between sentences */

	return 2;

    else if (c == 11)	/* paragraph indentation */

	return 3;

    else if (c >= EURO_MIN && c <= EURO_MAX)

	return (euro_substitute[2 * (c - EURO_MIN) + 1] == ' ') ? 1 : 2;

    else

	return 1;

}/* os_char_width */

void os_display_char (int c)
{

    if (cwin == 0)

	if (c == 9) {		/* gap between sentences */

	    putchar (' ');
	    putchar (' ');

	} else if (c == 11) {	/* paragraph indentation */

	    putchar (' ');
	    putchar (' ');
	    putchar (' ');

	} else if (c >= EURO_MIN && c <= EURO_MAX) {

	    int c1 = euro_substitute[2 * (c - EURO_MIN)];
	    int c2 = euro_substitute[2 * (c - EURO_MIN) + 1];

	    putchar (c1);

	    if (c2 != ' ')
		putchar (c2);

	} else

	    putchar (c);

}/* os_display_char */

void os_display_string (const char *s)
{

    while (*s) {

	if (*s == NEW_FONT || *s == NEW_STYLE)
	    s++;
	else
	    os_display_char ((unsigned char) *s);

	s++;

    }

}/* os_display_string */

void os_fatal (const char *s)
{

    fprintf (stderr, "Fatal: %s\n", s);

    exit (1);

}/* os_fatal */

void os_init_screen (void)
{

    h_screen_width = h_screen_cols = 79;
    h_screen_height = h_screen_rows = 1;

    h_config |= CONFIG_NOSTATUSLINE;

}/* os_init_screen */

void os_process_arguments (int argc, char *argv[])
{

    story_name = (argc <= 1) ? "story.dat" : argv[1];

}/* os_process_arguments */

int os_read_file_name (char *name, const char *default_name, int type)
{

    print_string ("Enter file name (default is ");
    print_string (default_name);
    print_string ("): ");

    read_string (MAX_FILE_NAME, name);

    if (name[0] == 0)
	strcpy (name, default_name);

    return 1;

}/* os_read_file_name */

int os_read_key (int timeout)
{

    return getchar ();

}/* os_read_key */

int os_read_line (int max, char *buf, int timeout, int width, int continued)
{

    gets (buf);

    swallow_nl = 1;

    return 13;

}/* os_read_line */

void os_scroll_area (int top, int left, int bottom, int right, int pixels)
{

    if (!swallow_nl)
	putchar ('\n');

    swallow_nl = 0;

}/* os_scroll_area */

int os_string_width (const char *s)
{
    int width = 0;

    while (*s) {

	if (s == NEW_FONT || s == NEW_STYLE)
	    s++;
	else
	    width += os_char_width ((unsigned char) *s);

	s++;

    }

    return width;

}/* os_string_width */
