/* heliofnt.c - HelioFrotz User Interface (most of it!)
 *
 * This file is part of HelioFrotz.
 *
 * HelioFrotz is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * HelioFrotz is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <system.h>
#include "../stdlib/fnt.h"
#include "frotz.h"
#include "heliofro.h"


int textFont  = smallFont;
int fixedFont = smallFixedFont;

static int maxheight = 0;
static int current_zfont = smallFont;
static int current_style = 0;
static int curr_x = 0;
static int curr_y = 0;
static zchar screenmap[160][160];

void os_set_colour (int x, int y) {}

int os_font_data(int font, int *height, int *width)
{
  int oldfont;

  oldfont = FntGetFont();
  switch (font) {
  case FIXED_WIDTH_FONT:
    FntSetFont(fixedFont);
    break;
  default:
    FntSetFont(textFont);
    break;
  }
  *width = FntCharWidth('0');
  FntSetFont(fixedFont);
  *height = FntLineHeight();
  FntSetFont(textFont);
  if (FntLineHeight()>*height) *height = FntLineHeight();
  maxheight = *height;
  FntSetFont(oldfont);
  return 1;
}


void os_set_text_style (int new_style)
{
  current_style = new_style;
}

void SetupFont()
{
  if (current_style & FIXED_WIDTH_STYLE)
    FntSetFont(fixedFont);
  else
    FntSetFont(current_zfont);

  if (current_style & EMPHASIS_STYLE)
    FntSetUnderlineMode(solidUnderline);
  else
    FntSetUnderlineMode(noUnderline);
}

int os_char_width (zchar c)
{
  SetupFont();
  return FntCharWidth(c);
}

void os_set_font (int font)
{
  if (font==FIXED_WIDTH_FONT)
    current_zfont = fixedFont;
  else
    current_zfont = textFont;
}

void os_display_char (zchar c)
{
  int x, y;

  switch (c) {
  case ZC_GAP:
    os_display_char(' ');
    c = ' ';
    break;
  case ZC_INDENT:
    os_display_char(' ');
    os_display_char(' ');
    c = ' ';
    break;
  }
  if (curr_y>150) return;

  SetupFont();
  FntDrawChar(c, curr_x, curr_y, (current_style & REVERSE_STYLE)?TRUE:FALSE);

  for (y=FntLineHeight(); y>=0; y--)
    for (x=os_char_width(c); x>=0; x--)
      screenmap[curr_y+y][curr_x+x]=(x==0)?0:c;
  
  for (y=FntLineHeight(); y<maxheight; y++)
    for (x=os_char_width(c); x>=0; x--)
      screenmap[curr_y+y][curr_x+x]=' ';

  for (y=FntLineHeight(); y<maxheight; y++)
    LcdDrawHoriLine(curr_x, curr_x+os_char_width(c)-1, curr_y+y, NON_DOTTED_LINE, (current_style & REVERSE_STYLE)?COLOR_BLACK:COLOR_WHITE,COLOR_WHITE);

  curr_x += os_char_width(c);
}


void os_display_string (const zchar *s)
{
  while (*s) {
    if (*s == ZC_NEW_FONT || *s == ZC_NEW_STYLE) {
      s++;
      if (s[-1] == ZC_NEW_FONT)
        os_set_font(*s++);
      else
        os_set_text_style(*s++);
    }
    else
      os_display_char(*s++);
  }
}



int os_string_width (const zchar *s)
{
  int width = 0;
  int oldcurr, oldstyle;

  oldcurr = current_zfont;
  oldstyle = current_style;
  while (*s) {
    if (*s == ZC_NEW_STYLE || *s == ZC_NEW_FONT) {
      if (*s == ZC_NEW_FONT)
	os_set_font(*(s+1));
      else if (*s == ZC_NEW_STYLE)
	os_set_text_style(*(s+1));
      s += 2;
    } else
      width += os_char_width(*s++);
  }
  current_zfont = oldcurr;
  current_style = oldstyle;
  return width;
}

void os_set_cursor (int y, int x)
{
  curr_y = y - 1;
  curr_x = x - 1;
}

void os_erase_area (int top, int left, int bottom, int right)
{
  ObjectBounds bnds;
  int x, y;
  
  top--;
  left--;
  right--;
  bottom--;

  bnds.xcoord = left;
  bnds.ycoord = top;
  bnds.width = right - left + 1;
  bnds.height = bottom - top + 1;

  LcdEraseRegion(&bnds);

  for (y=top; y<=bottom; y++)
    for (x=left; x<=right; x++)
      screenmap[y][x] = ' ';
}

void os_scroll_area (int top, int left, int bottom, int right, int units)
{
  ObjectBounds bnds;
  BitmapTemplate b;
  int x, y;

  if (units == 0)
    return;
  else if (units > bottom - top || units < top - bottom) {
    FntClearScreen();
    memset(screenmap, ' ', 160*150);
  } else if (units > 0) {
    b.xcoord = left - 1;
    b.ycoord = top - 1 + units;
    b.width = right - left + 1;
    b.height = bottom - top - units + 1;
    LcdGetBitmap(&b);
    b.ycoord = top - 1;
    LcdDrawBitmap(&b, FALSE);
    qfree(b.bitmap_data);

    for (y=0; y<b.height; y++)
      for (x=0; x<b.width; x++)
	screenmap[b.ycoord + y][b.xcoord+x] = screenmap[b.ycoord+y+units][b.xcoord+x];
    
    bnds.xcoord = left - 1;
    bnds.ycoord = bottom - units;
    bnds.width = right - left + 1;
    bnds.height = units;
    LcdEraseRegion(&bnds);

    for (y=0; y<bnds.height; y++)
      for (x=0; x<bnds.width; x++)
	screenmap[bnds.ycoord + y][bnds.xcoord+x] = ' ';

  }
  else {
    b.xcoord = left - 1;
    b.ycoord = top - 1;
    b.width = right - left + 1;
    b.height = bottom - top + units + 1;
    LcdGetBitmap(&b);
    b.ycoord = top - 1 + units;
    LcdDrawBitmap(&b, FALSE);
    qfree(b.bitmap_data);

    for (y=0; y<b.height; y++)
      for (x=0; x<b.width; x++)
	screenmap[b.ycoord + y-units][b.xcoord+x] = screenmap[b.ycoord+y][b.xcoord+x];

    bnds.xcoord = left - 1;
    bnds.ycoord = top - 1;
    bnds.width = right - left + 1;
    bnds.height = -units;
    LcdEraseRegion(&bnds);

    for (y=0; y<bnds.height; y++)
      for (x=0; x<bnds.width; x++)
	screenmap[bnds.ycoord + y][bnds.xcoord+x] = ' ';
  }
}

void os_reset_screen(void)
{
  os_exit_prompt();
}

void os_beep (int volume)
{
  FntBeep();
}


static int endchar(char a)
{
  switch(a) {
  case ' ':
  case '<':
  case '>':
  case '(':
  case ')':
  case '\\':
  case '/':
  case '.':
  case '?':
  case '!':
  case '`':
  case '\"':
  case ',':
  case ':':
  case ';':
    return TRUE;
  default:
    return FALSE;
  }
}
  

void findclick(int x, int y, char *buff){
  int r, c;

  buff[0] = 0;
  c = x;
  r = y;
  if (c>=h_screen_width) return;
  if (r>=h_screen_height) return;

  if (endchar(screenmap[r][c])) return;
  while (!endchar(screenmap[r][c]) && c>0) c--;
  if (endchar(screenmap[r][c])) c++;
  do {
    if (screenmap[r][c]==0 && c<(h_screen_width-1)) {
      if(!endchar(screenmap[r][c+1])) {
	*buff = screenmap[r][c+1];
	buff++;
      }
    }
    c++;
  } while (!endchar(screenmap[r][c]) && c<h_screen_width);
  *buff = 0;
}



void os_prepare_sample (int x) {}
void os_finish_with_sample (void) {}
void os_start_sample (int x, int y, int z) {}
void os_stop_sample (void) {}


bool os_picture_data(int num, int *height, int *width) { return FALSE; }

void os_draw_picture (int num, int row, int col) { }

int os_peek_colour (void) { return BLACK_COLOUR; }
