/* getfile.c - HelioFrotz File Chooser
 *
 * This file is part of HelioFrotz.
 *
 * HelioFrotz is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * HelioFrotz is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <system.h>
#include "frotz.h"
#include "heliofro.h"
#include "../stdlib/fnt.h"
#include "../stdlib/my_stdio.h"
#include "res/resource.h"

static int donefile;
static int hitok;
static char *fileType=NULL;
static char *filePrompt=NULL;
static char outFile[40]={0};
static int checkOver=0;

int GetFileName(char *def, char *type, char *prompt, char *outfile, int checkover)
{
  EvtType event;
  donefile=0;
  hitok=0;

  strcpy(outFile, def);
  fileType = type;
  filePrompt = prompt;
  checkOver = checkover;
  FormPopupForm(FORM_SAVELOAD);	        //start main form
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
  } while(!donefile);
  FntClearScreen();

  if (hitok) strcpy(outfile, outFile);
  return hitok;
}

void SaveLoadOK(int OK)
{
  BYTE *text_ptr;
  char buff[100];

  if (!OK) hitok = 0;
  else hitok = 1;
  
  TextboxGetTextPointer(TEXT_SAVELOAD, &text_ptr) ;
  strcpy(outFile, text_ptr);
  if (checkOver && OK) {
    FILE *fp;
    fp=fopen(text_ptr, "rb");
    if (fp) {
      fclose(fp);
      sprintf(buff, "Overwrite '%s'?", text_ptr);
      if (DoYesNo(buff,-1)) {
	donefile = 1;
	EvtAppendEvt(EVT_FORM_CLOSE, FORM_SAVELOAD, 0, 0, NULL);
	FormPopupForm(FORM_MAIN);
      } else
	FormPopupForm(FORM_SAVELOAD);
      return;
    }
  }
  donefile = 1;
  EvtAppendEvt(EVT_FORM_CLOSE, FORM_SAVELOAD, 0, 0, NULL);
  FormPopupForm(FORM_MAIN);
}

BOOLEAN FormSaveLoadHandleEvent(EvtType* Event)
{
  ObjectBounds bnds;
  BYTE *text_ptr;
  char buff[100];

  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    StringSetText(STRING_SAVELOAD, filePrompt);
    FormDrawForm(Event->eventID);
    FormObjectSetFocus(TEXT_SAVELOAD);
    TextboxSetInsertPointOn(TEXT_SAVELOAD);
    TextboxSetText(TEXT_SAVELOAD, outFile);
    TextboxSetInsertPointPositionByCharPos(TEXT_SAVELOAD, strlen(outFile));
    TextboxDrawTextbox(TEXT_SAVELOAD);
    BitmapDrawBitmap(BITMAP_SAVELOAD);
    ListDeleteAllItems(LIST_SAVELOAD);
    ListAllDBs(fileType, LIST_SAVELOAD);
    ListSetSelectedItem(LIST_SAVELOAD, NO_SELECTION);
    ListDrawList(LIST_SAVELOAD);
    break;

  case EVT_BITMAP_SELECT:
    if (Event->eventID==BITMAP_SAVELOAD) { // Delete button
      TextboxGetTextPointer(TEXT_SAVELOAD, &text_ptr) ;
      if (text_ptr[0]==0) {
	FntBeep();
	break;
      }
      strcpy(outFile, text_ptr);
      
      sprintf(buff, "Really delete %s?", text_ptr);
      if (DoYesNo(buff, FORM_SAVELOAD)) {
	TextboxGetTextPointer(TEXT_SAVELOAD, &text_ptr) ;
	unlink(text_ptr);
      } 
    }
    break;

  case EVT_KEY:
    if (Event->eventID == SOFT_KEY) {		
      if ((BYTE)(Event->para1) == 13) SaveLoadOK(1);
      else TextboxAddKeyInChar(TEXT_SAVELOAD, (BYTE)(Event->para1));
      return TRUE;
    }
    break;

  case EVT_KEYBOARD_STATUS:
    TextboxGetTextboxBounds(TEXT_SAVELOAD, &bnds);
    if (Event->para1==KEYBOARD_ON) {
      bnds.ycoord -= 61;
    } else if (Event->para1==KEYBOARD_OFF) {
      bnds.ycoord += 61;
    }
    TextboxSetBounds(TEXT_SAVELOAD, bnds);
    TextboxSetInsertPointOff(TEXT_SAVELOAD);
    TextboxGetTextPointer(TEXT_SAVELOAD, &text_ptr) ;
    TextboxSetInsertPointPositionByCharPos(TEXT_SAVELOAD, strlen(text_ptr));
    if (Event->para1==KEYBOARD_OFF) FormDrawForm(FORM_SAVELOAD);
    TextboxDrawTextbox(TEXT_SAVELOAD);
    TextboxSetInsertPointOn(TEXT_SAVELOAD);
    break;


  case EVT_LIST_SELECT:
    ListSetSelectedItem(Event->eventID, Event->para1);
    ListSetHighlightedItem(Event->eventID, Event->para1);
    ListDrawList(Event->eventID);
    ListGetListItem(LIST_SAVELOAD, Event->para1, (BYTE **)&text_ptr);
    TextboxSetInsertPointOn(TEXT_SAVELOAD);
    TextboxSetText(TEXT_SAVELOAD, text_ptr);
    TextboxSetInsertPointPositionByCharPos(TEXT_SAVELOAD, strlen(text_ptr));
    TextboxDrawTextbox(TEXT_SAVELOAD);
    return TRUE;
		

  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      SaveLoadOK(1);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      SaveLoadOK(0);
      break;
    default:
      return FALSE;
    }
    break;

  default:
    return FALSE;
  }
  return FALSE;
}
