
//**********
//*  Serial Number: 981026-163958
//* Version Number:   0001.77
//**********

#define SERIAL_NUM   "981026-163958"
#define VERSION_NUM  "0001.77"

// Check the endian of your machine as this is set for LSB-MSB order
// to change the edian just comment out this define
#define ENDIAN_LSB_MSB

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef unsigned char ubyte;
typedef signed char sbyte;
typedef unsigned short uword;
typedef short word;
typedef unsigned long udword;
typedef long dword;

//------------------------------------------------------------------------------------------------------------

#ifndef __GNUC__
#pragma pack(2)
#endif

#define PDBHEADER struct pdbheader_struct
struct pdbheader_struct{
	ubyte name[32];				// String - This is the name of the database on the PalmPilot device.
								//  It need not match the name of the PDB file in the environment in which it is created.
	uword fileAttributes;		// Attributes of the pdb file.
								//  0x0002 Read-Only
								//  0x0004 Dirty AppInfoArea
								//  0x0008 Backup this database (i.e. no conduit exists)
								//  0x0010 (16 decimal) Okay to install newer over existing copy, if present on PalmPilot
								//  0x0020 (32 decimal) Force the PalmPilot to reset after this database is installed
	uword version;				// Defined by the application.
	udword creationDate;		// Expressed as the number of seconds since January 1, 1904.
								//  The database will not install if this value is zero. (PalmOS 1.0.6)
	udword modificationDate;	// Expressed as the number of seconds since January 1, 1904.
								//  The database will not install if this value is zero. (PalmOS 1.0.6)
	udword lastBackupDate;		// Expressed as the number of seconds since January 1, 1904.
								//  This can be left at zero and the database will install.
	udword modificationNumber;	// Set to zero.
	udword appInfoArea;			// The byte number in the PDB file (counting from zero) at which the AppInfoArea is located.
								//  This must be the first entry in the Data portion of the PDB file.
								//  If this database does not have an AppInfoArea, set this value to zero.
	udword sortInfoArea;		// The byte number in the PDB file (counting from zero) at which the SortInfoArea is
								//  located. This must be placed immediately after the AppInfoArea, if one exists,
								//  within the Data portion of the PDB file. If this database does not have a SortInfoArea,
								//  set this value to zero. Do not use this. See Note C below for further details.
	ubyte databaseType[4];		// String - Set this to the desired value. Generally it should match the Database Type
								//  used by the corresponding application This is 4 characters long and does not have a
								//  terminating null.
	ubyte creatorID[4];			// String - Set this to the desired value. Generally it should match the Creator ID used
								//  by the corresponding application. In all cases, you should always register your
								//  Creator ID before using it. This is 4 characters long and does not have a terminating
								//  null.
	udword uniqueIDSeed;		// This is used to generate the Unique ID number of subsequent records. Generally,
								//  this should be set to zero.
	udword nextRecordListID;	// Set this to zero. (This does not appear to be used, but that has not been verified by
								//  a third party.)
	uword numberOfRecords;		// This contains the number of records
}
#ifdef __GNUC__
__attribute__ ((packed))
#endif
;

//------------------------------------------------------------------------------------------------------------

#define RECHEADER struct recheader_struct
struct recheader_struct{
	udword recordDataOffset;	// The byte number in the PDB file (counting from zero) at which the record is located.
	ubyte recordAttributes;		// The records attributes.
 								//  0x10 (16 decimal) Secret record bit.
								//  0x20 (32 decimal) Record in use (busy bit).
								//  0x40 (64 decimal) Dirty record bit.
								//  0x80 (128, unsigned decimal) Delete record on next HotSync.
								//  The least significant four bits are used to represent the category values.
	ubyte uniqueID[3];			// Set this to zero and do not try to second-guess what PalmOS will do with this value.
}
#ifdef __GNUC__
__attribute__ ((packed))
#endif
;

//------------------------------------------------------------------------------------------------------------

void WriteWord(void* addr,uword data){

	ubyte* to = (ubyte*)addr;
	ubyte* from = (ubyte*)&data;

#ifdef ENDIAN_LSB_MSB
	to[0] = from[1];
	to[1] = from[0];
#else
	to[0] = from[0];
	to[1] = from[1];
#endif
}

//------------------------------------------------------------------------------------------------------------

void WriteDWord(void* addr,udword data){

	ubyte* to = (ubyte*)addr;
	ubyte* from = (ubyte*)&data;

#ifdef ENDIAN_LSB_MSB
	to[0] = from[3];
	to[1] = from[2];
	to[2] = from[1];
	to[3] = from[0];
#else
	to[0] = from[0];
	to[1] = from[1];
	to[2] = from[2];
	to[3] = from[3];
#endif
}

//------------------------------------------------------------------------------------------------------------

void main(int argc,char *argv[]){

	FILE* fpo;
	FILE* fpi;
	dword c;
	PDBHEADER pdbHeader;
	RECHEADER recHeader;
	dword save;
	dword length;
	ubyte* zip;
	uword records;

	printf("Z2PDB: V%s. Builds a FROTZ database for the PalmIII/Pilot.\n",VERSION_NUM);
	printf(" By P.D.Margrave (C) King of the Jungle Ltd. SN:%s\n\n",SERIAL_NUM);
	printf("  USAGE: Z2PDB <FROTZ PDB File> <Zip File> <Title>\n");
	printf("\n");

	// do command line parsing

	if(argc < 4){
		printf("ERROR: Not enough parameters\n");
		exit(1);
	}

	if(fpo = fopen(argv[1],"wb")){
		printf("Writing PDB file \"%s\" - %s\n",argv[3],argv[1]);

		if(fpi = fopen(argv[2],"rb")){
			printf("Inserting ZIP file - %s\n",argv[2]);
			save = ftell(fpi);
			fseek(fpi,0,SEEK_END);
			length = ftell(fpi);
			fseek(fpi,save,SEEK_SET);

			length = (length + 4095) & 0xfffff000;

			zip = malloc(length);
			fread(zip,length,1,fpi);
			records = (length / 4096);

			// make header
			memset(&pdbHeader,0,sizeof(PDBHEADER));
			if(strlen(argv[3]) > 31){
				*(argv[3] + 31) = 0;		// fix title width
			}
			strcpy(pdbHeader.name,argv[3]);
			WriteWord(&(pdbHeader.fileAttributes),0x0000);
			WriteWord(&(pdbHeader.version),0x0001);
			WriteDWord(&(pdbHeader.creationDate),0x34ac829f);
			WriteDWord(&(pdbHeader.modificationDate),0x34ac829f);
			WriteDWord(&(pdbHeader.lastBackupDate),0x00000000);
			WriteDWord(&(pdbHeader.modificationNumber),0x00000000);
			WriteDWord(&(pdbHeader.appInfoArea),0x00000000);
			WriteDWord(&(pdbHeader.sortInfoArea),0x00000000);
			pdbHeader.databaseType[0] = 'Z';
			pdbHeader.databaseType[1] = 'C';
			pdbHeader.databaseType[2] = 'O';
			pdbHeader.databaseType[3] = 'D';
			pdbHeader.creatorID[0] = 'F';
			pdbHeader.creatorID[1] = 'o';
			pdbHeader.creatorID[2] = 't';
			pdbHeader.creatorID[3] = 'z';
			WriteDWord(&(pdbHeader.uniqueIDSeed),0x00000000);
			WriteDWord(&(pdbHeader.nextRecordListID),0x00000000);
			WriteWord(&(pdbHeader.numberOfRecords),records);
			fwrite(&pdbHeader,sizeof(PDBHEADER),1,fpo);

			for(c = 0;c < records;c++){
				WriteDWord(&(recHeader.recordDataOffset),(c * 4096) + sizeof(PDBHEADER) + records * sizeof(RECHEADER));
				recHeader.recordAttributes = 0x60;
				recHeader.uniqueID[0] = 0x00;
				recHeader.uniqueID[1] = 0x00;
				recHeader.uniqueID[2] = 0x00;
				fwrite(&recHeader,sizeof(RECHEADER),1,fpo);
			}

			fwrite(zip,length,1,fpo);
			free(zip);

			fclose(fpi);

		}
		fclose(fpo);
	}
}

//------------------------------------------------------------------------------------------------------------
