/*
 * file "S5init.c"
 *
 *
 */

#include "frotz.h"
#include "S5frotz.h"
#include "S5api.h"

/*
#define INFORMATION "\
\n\
FROTZ V2.32 - interpreter for all Infocom games. Complies with standard\n\
1.0 of Graham Nelson's specification. Written by Stefan Jokisch in 1995-7\n\
\n\
Syntax: frotz [options] story-file\n\
\n\
  -a   watch attribute setting  \t -l # left margin\n\
  -A   watch attribute testing  \t -o   watch object movement\n\
  -b # background colour        \t -O   watch object locating\n\
  -B # reverse background colour\t -p   alter piracy opcode\n\
  -c # context lines            \t -r # right margin\n\
  -d # display mode (see below) \t -s # random number seed value\n\
  -e # emphasis colour [mode 1] \t -S # transscript width\n\
  -f # foreground colour        \t -t   set Tandy bit\n\
  -F # reverse foreground colour\t -T   bold typing [modes 2+4+5]\n\
  -g # font [mode 5] (see below)\t -u # slots for multiple undo\n\
  -h # screen height            \t -w # screen width\n\
  -i   ignore runtime errors    \t -x   expand abbreviations g/x/z\n\
\n\
Fonts are 0 (fixed), 1 (sans serif), 2 (comic), 3 (times), 4 (serif).\n\
\n\
Display modes are 0 (mono), 1 (text), 2 (CGA), 3 (MCGA), 4 (EGA), 5 (Amiga)."
*/

short getopt (struct sg *g, short, char *[], const char *);

/*
 * dectoi
 *
 * Convert a string containing a decimal number to integer. The string may
 * be NULL, but it must not be empty.
 *
 */

/* short dectoi (struct sg *g, const char *s)
{
    short n = 0;

    if (s != NULL)

	do {

	    n = 10 * n + (*s & 15);

	} while (*++s > ' ');

    return n;

}*/ /* dectoi */

/*
 * hextoi
 *
 * Convert a string containing a hex number to integer. The string may be
 * NULL, but it must not be empty.
 *
 */

/* short hextoi (struct sg *g, const char *s)
{
    short n = 0;

    if (s != NULL)

	do {

	    n = 16 * n + (*s & 15);

	    if (*s > '9')
		n += 9;

	} while (*++s > ' ');

    return n;

}*/ /* hextoi */

/*
 * cleanup
 *
 * Shut down the IO interface: free memory, close files, restore
 * interrupt pointers and return to the previous video mode.
 *
 */

void cleanup (struct sg *g)
{
}/* cleanup */

/*
 * os_fatal
 *
 * Display error message and exit program.
 *
 */

void os_fatal (struct sg *g, const char *s)
{

    if (g->h_interpreter_number)
	os_reset_screen (g);

    /* Display error message */

    SrvPrintf(g," --- Fatal error: ");
    SrvPrintf(g,s);
	os_read_key (g, 0, TRUE);

    /* Abort program */

    SrvExit(g);

}/* os_fatal */

/*
 * parse_options
 *
 * Parse program options and set global flags accordingly.
 *
 */

/*void parse_options (struct sg *g, short argc, char **argv)
{
    short c;

    do {

	short num = 0;

	c = getopt (g,argc, argv, "aAb:B:c:d:e:f:F:g:h:il:oOpr:s:S:tTu:w:x");

	if (g->optarg != NULL)
	    num = dectoi (g,g->optarg);

	if (c == 'a')
	    g->option_attribute_assignment = 1;
	if (c == 'A')
	    g->option_attribute_testing = 1;
	if (c == 'b')
	    g->user_background = num;
	if (c == 'B')
	    g->user_reverse_bg = num;
	if (c == 'c')
	    g->option_context_lines = num;
	if (c == 'd')
	    g->display = g->optarg[0] | 32;
	if (c == 'e')
	    g->user_emphasis = num;
	if (c == 'T')
	    g->user_bold_typing = 1;
	if (c == 'f')
	    g->user_foreground = num;
	if (c == 'F')
	    g->user_reverse_fg = num;
	if (c == 'g')
	    g->user_font = num;
	if (c == 'h')
	    g->user_screen_height = num;
	if (c == 'i')
	    g->option_ignore_errors = 1;
	if (c == 'l')
	    g->option_left_margin = num;
	if (c == 'o')
	    g->option_object_movement = 1;
	if (c == 'O')
	    g->option_object_locating = 1;
	if (c == 'p')
	    g->option_piracy = 1;
	if (c == 'r')
	    g->option_right_margin = num;
	if (c == 's')
	    g->user_random_seed = num;
	if (c == 'S')
	    g->option_script_cols = num;
	if (c == 't')
	    g->user_tandy_bit = 1;
	if (c == 'u')
	    g->option_undo_slots = num;
	if (c == 'w')
	    g->user_screen_width = num;
	if (c == 'x')
	    g->option_expand_abbreviations = 1;

    } while (c != 0);

} */ /* parse_options */

/*
 * os_process_arguments
 *
 * Handle command line switches. Some variables may be set to activate
 * special features of Frotz:
 *
 *     option_attribute_assignment
 *     option_attribute_testing
 *     option_context_lines
 *     option_object_locating
 *     option_object_movement
 *     option_left_margin
 *     option_right_margin
 *     option_ignore_errors
 *     option_piracy
 *     option_undo_slots
 *     option_expand_abbreviations
 *     option_script_cols
 *
 * The global pointer "story_name" is set to the story file name.
 *
 */

void os_process_arguments (struct sg *g, short argc, char *argv[])
{
    const char *p;
    short i;

    /* Parse command line options */

    // parse_options (g,argc, argv);

    if (g->optind != argc - 1) {
		return;
    }

    /* Set the story file name */
    SrvGetStoryName(g, &(g->story_name));//argv[g->optind];

    /* Strip path and extension off the story file name */

    p = g->story_name;

    for (i = 0; g->story_name[i] != 0; i++)
	if (g->story_name[i] == '\\' || g->story_name[i] == ':')
	    p = g->story_name + i + 1;

    for (i = 0; p[i] != 0 && p[i] != '.' && i < 8; i++)
	g->stripped_story_name[i] = p[i];

    g->stripped_story_name[i] = 0;

    /* Create nice default file names */

    Srvstrcpy (g->script_name, g->stripped_story_name);
    Srvstrcpy (g->command_name, g->stripped_story_name);
    Srvstrcpy (g->save_name, g->stripped_story_name);
    Srvstrcpy (g->auxilary_name, g->stripped_story_name);

    Srvstrcat (g->script_name, ".scr");
    Srvstrcat (g->command_name, ".rec");
    Srvstrcat (g->save_name, ".sav");
    Srvstrcat (g->auxilary_name, ".aux");

    /* Save the executable file name */

    g->progname = argv[0];

}/* os_process_arguments */

/*
 * os_init_screen
 *
 * Initialise the IO interface. Prepare the screen and other devices
 * (mouse, sound board). Set various OS depending story file header
 * entries:
 *
 *     h_config (aka flags 1)
 *     h_flags (aka flags 2)
 *     h_screen_cols (aka screen width in characters)
 *     h_screen_rows (aka screen height in lines)
 *     h_screen_width
 *     h_screen_height
 *     h_font_height (defaults to 1)
 *     h_font_width (defaults to 1)
 *     h_default_foreground
 *     h_default_background
 *     h_interpreter_number
 *     h_interpreter_version
 *     h_user_name (optional; not used by any game)
 *
 * Finally, set reserve_mem to the amount of memory (in bytes) that
 * should not be used for multiple undo and reserved for later use.
 *
 */

void os_init_screen (struct sg *g)
{
	int scrh, scrw;

    /* If the display mode has not already been set by the user then see
       if this is a monochrome board. If so, set the display mode to 0.
       Otherwise check the graphics flag of the story. Select a graphic
       mode if it is set or if this is a V6 game. Select text mode if it
       is not. */

    if (g->h_version == V3)
	g->h_config |= CONFIG_SPLITSCREEN;
    if (g->h_version >= V4)
	g->h_config |= CONFIG_BOLDFACE;
    if (g->h_version >= V4)
	g->h_config |= CONFIG_EMPHASIS | CONFIG_FIXED | CONFIG_TIMEDINPUT;

    /* Handle various game flags. These flags are set if the game wants
       to use certain features. The flags must be cleared if the feature
       is not available. */

    if (g->h_flags & GRAPHICS_FLAG)
	    g->h_flags &= ~GRAPHICS_FLAG;
    if (g->h_version == V3 && (g->h_flags & OLD_SOUND_FLAG))
    g->h_flags &= ~OLD_SOUND_FLAG;
    if (g->h_version >= V5 && (g->h_flags & UNDO_FLAG))
	if (!g->option_undo_slots)
	    g->h_flags &= ~UNDO_FLAG;
    g->h_flags &= ~COLOUR_FLAG;
    g->h_flags &= ~MENU_FLAG;

    /* Set the screen dimensions, font size and default colour */
    SrvScreenSize(g, &scrw, &scrh);
    g->h_screen_width = scrw;
    g->h_screen_height = scrh;
    g->h_font_height = 1;
    g->h_font_width = 1;
    g->h_default_foreground = 1;
    g->h_default_background = 0;

    if (g->user_screen_width != -1)
	g->h_screen_width = g->user_screen_width;
    if (g->user_screen_height != -1)
	g->h_screen_height = g->user_screen_height;

    g->h_screen_cols = g->h_screen_width / g->h_font_width;
    g->h_screen_rows = g->h_screen_height / g->h_font_height;

    /* Set the interpreter number (a constant telling the game which
       operating system it runs on) and the interpreter version. The
       interpreter number has effect on V6 games and "Beyond Zork". */

    g->h_interpreter_number = INTERP_PSIONS5;
    g->h_interpreter_version = 'S';


}/* os_init_screen */

/*
 * os_reset_screen
 *
 * Reset the screen before the program stops.
 *
 */

void os_reset_screen (struct sg *g)
{

    os_set_font (g,TEXT_FONT);
    os_set_text_style (g,0);
    os_display_string (g,(zchar *) "[Press any key to continue]");
    os_read_key (g, 0, TRUE);

    cleanup (g);

}/* os_reset_screen */

/*
 * os_restart_game
 *
 * This routine allows the interface to interfere with the process of
 * restarting a game at various stages:
 *
 *     RESTART_BEGIN - restart has just begun
 *     RESTART_WPROP_SET - window properties have been initialised
 *     RESTART_END - restart is complete
 *
 */

void os_restart_game (struct sg *g, short stage)
{
	stage;
}/* os_restart_game */

/*
 * os_random_seed
 *
 * Return an appropriate random seed value in the range from 0 to
 * 32767, possibly by using the current system time.
 *
 */

/*short os_random_seed (void)
{

    if (user_random_seed == -1) {

    return SrvRandom();

    } else return user_random_seed;

}
*//* os_random_seed */
